/***************************************
  $Header: /home/amb/wwwoffle/RCS/wwwoffle.h 1.3 1997/01/19 10:55:26 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 0.9b.
  A header file for all of the programs wwwoffle, wwwoffled, wwwoffles.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef WWWOFFLE_H
#define WWWOFFLE_H    /*+ To stop multiple inclusions. +*/

#include <stdio.h>

/*+ The default port number to use for the http proxy demon. +*/
#define DEF_HTTP_PORT 8080

/*+ The default port number to use for the wwwoffle control. +*/
#define DEF_WWWOFFLE_PORT 8081

/*+ The default spool directory. +*/
#define DEF_SPOOL "/var/spool/wwwoffle"

/*+ The default age of pages in days before purging. +*/
#define DEF_AGE 14

/*+ The maximum number of servers to fork. +*/
#define MAX_SERVERS 8

/*+ The character to use to replace '/' in the spool directories. +*/
#define PATH_SEP '%'

/*+ The time in seconds to wait while reading from a socket. +*/
#define SOCKET_TIMEOUT 120

/* In parse.c */

void CommandConnect(FILE *client);
void ForkServer(int client,int browser);

/* In purge.c */

void PurgeCache(int age,int nhosts,char **hosts,int client);

/* In spool.c */

int OpenOutgoingSpoolFile(int rw);
int OpenWebpageSpoolFile(int rw,char *url);

/* In parse.c */

char *ParseRequest(FILE *req,char **url);
char *ParseReply(int rep,int *status);
void SplitURL(char *url,char **host,char **path,char **args);
void MakeRequestNonProxy(char *url,char *path,char *args,char **buffer);

/* In messages.c */

void ServerErrorMessage(int fd,char *string);
void ServerFetchFailed(int fd,char *url,char *host,int port,int connect_or_timeout);
void WillGet(int fd,char *url,int already);
void Refresh(int fd,char *url);

/* In index.c */

void GenerateIndex(int fd,char *url);

/* In io.c */

char *fgets_realloc(char *buffer,FILE *file);
int ReadOrTimeout(int fd,char *buffer,int n);

#endif /* WWWOFFLE_H */
