/***************************************
  $Header: /home/amb/wwwoffle/RCS/parse.c 1.4 1997/01/19 17:13:08 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 0.9b.
  Functions to parse the HTTP requests.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <unistd.h>

#include "wwwoffle.h"


/*++++++++++++++++++++++++++++++++++++++
  Parse the request to the server.

  char *ParseRequest Returns the request.

  FILE *req The file pointer to read the request from.

  char **url Return the url or NULL if it failed.
  ++++++++++++++++++++++++++++++++++++++*/

char *ParseRequest(FILE *req,char **url)
{
 char *buffer=NULL,*buf=NULL;
 int post=0,n=0;

 *url=NULL;

 buf=fgets_realloc(buf,req);

 if(!buf)
    return(NULL);

 *url=(char*)malloc(strlen(buf));

 if(sscanf(buf,"%*s %s",*url)!=1)
   {free(*url);*url=NULL;return(NULL);}

 if(!strncasecmp("POST",buf,4))
    post=1;

 buffer=(char*)malloc(strlen(buf)+1);
 buffer[0]=0;

 do
   {
    if(n)
       buffer=(char*)realloc(buffer,n+strlen(buf)+1);
    strcpy(&buffer[n],buf);
    n+=strlen(buf);
   }
 while(buf && buf[0]!='\r' && buf[0]!='\n' && (buf=fgets_realloc(buf,req)));

 if(post)
   {
    buf=fgets_realloc(buf,req);

    buffer=(char*)realloc(buffer,n+strlen(buf)+1);
    strcpy(&buffer[n],buf);

    if(buf[strlen(buf)-2]=='\r' || buf[strlen(buf)-2]=='\n')
       buf[strlen(buf)-2]=0;
    else
       buf[strlen(buf)-1]=0;

    *url=(char*)realloc(*url,strlen(*url)+strlen(buf)+2);
    strcat(*url,"!");
    strcat(*url,buf);
   }

 return(buffer);
}


/*++++++++++++++++++++++++++++++++++++++
  Parse the reply from the server.

  char *ParseReply Return the chunk of data that was read.

  int rep The file descriptor to read the reply from.

  int *status Return the numeric status code.
  ++++++++++++++++++++++++++++++++++++++*/

char *ParseReply(int rep,int *status)
{
 char *buffer=(char*)malloc(65);
 int n;

 n=ReadOrTimeout(rep,buffer,64);

 if(n<=0)
    return(NULL);

 buffer[n]=0;

 if(sscanf(buffer,"%*s %d",status)!=1)
    *status=0;

 return(buffer);
}


/*++++++++++++++++++++++++++++++++++++++
  Split a URL into a hostname, a path name and an argument list.

  char *url The URL to split.

  char **host Returns a pointer to the hostname.

  char **path Returns a pointer to the path of the file.

  char **args Returns a pointer to the arguments if any to the URL.
  ++++++++++++++++++++++++++++++++++++++*/

void SplitURL(char *url,char **host,char **path,char **args)
{
 int i=0;
 char *copyurl=malloc(strlen(url)+2);

 strcpy(copyurl,url);
 *host=NULL;
 *path=NULL;
 *args=NULL;

 if(!strncasecmp(copyurl,"http:",5))
   {
    i=5;
    if(copyurl[i]=='/') i++;
    if(copyurl[i]=='/') i++;
   }

 *host=&copyurl[i];

 for(;copyurl[i];i++)
    if(copyurl[i]=='/')
       break;

 if(copyurl[i])
   {
    copyurl[i++]=0;

    *path=&copyurl[i];

    for(;copyurl[i];i++)
       if(copyurl[i]=='?' || copyurl[i]=='!')
          break;

    if(copyurl[i])
      {
       if(copyurl[i]=='!')
         {
          int j;
          for(j=i+strlen(&copyurl[i]);j>=i;j--)
             copyurl[j+1]=copyurl[j];
         }

       copyurl[i++]=0;
       *args=&copyurl[i];
      }
   }

 if(!*path || !**path)
    *path="";
}


/*++++++++++++++++++++++++++++++++++++++
  Change the request from one to a proxy to a normal one.

  char *url The URL that we are trying to get.

  char *path The path we are going to get.

  char *args The arguments to the URL we are going to get.

  char **buffer The buffer containing the request.
  ++++++++++++++++++++++++++++++++++++++*/

void MakeRequestNonProxy(char *url,char *path,char *args,char **buffer)
{
 char *start,*stop;

 if(args && *args=='!')
   {
    char *pling=strstr(url,args);
    *pling=0;
    start=strstr(*buffer,url);
    stop=start+strlen(url);
    *pling='!';
   }
 else
   {
    start=strstr(*buffer,url);
    stop=start+strlen(url);
   }

 if(args && *args!='!')
    sprintf(start,"/%s?%s",path,args);
 else
    sprintf(start,"/%s",path);

 start+=strlen(start);

 while(*stop)
    *start++=*stop++;

 *start=0;
}
