/***************************************
  $Header: /home/amb/wwwoffle/RCS/errors.c 1.2 1997/01/18 21:00:42 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 0.9b.
  Generate error messages in a standard format on stderr.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


/*+ Under Linux or SGI, stdarg is used +*/
#if defined(__linux__) || defined(__sgi__)
#define USE_STD_ARG
#endif

#include <unistd.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef USE_STD_ARG
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#include <errno.h>

/* SunOS 4.x does not have strerror(). */
#if defined(__sun__) && !defined(__svr4__)
extern int sys_nerr;
extern char *sys_errlist[];

char* strerror(int err)
{
 if(err>0 && err<sys_nerr)
    return(sys_errlist[err]);
 else
    return("Unknown error");
}
#endif

#include "errors.h"


/*+ The name of the program. +*/
static char *program;

/*+ The process id of the program. +*/
static pid_t pid;

/*+ The error messages. +*/
static char *ErrorString[]={"","Warning: ","Fatal: "};


/*++++++++++++++++++++++++++++++++++++++
  Initialise the error handler, get the program name and pid.

  char *name The name of the program.
  ++++++++++++++++++++++++++++++++++++++*/

void InitErrorHandler(char *name)
{
 program=name;

 pid=getpid();
}


/*++++++++++++++++++++++++++++++++++++++
  Print an error message.

  int errlev Which error level.

  char* fmt The format of the message.

  ... The rest of the arguments (printf style).
  ++++++++++++++++++++++++++++++++++++++*/

void PrintMessage(int errlev,char* fmt, ...)
{
 int str_len=strlen(program)+strlen(ErrorString[errlev])+strlen(fmt)+16;
 char* string=(char*)malloc(str_len);
 va_list ap;
 int i,j;

#ifdef USE_STD_ARG
 va_start(ap,fmt);
#else
 va_start(ap);
#endif

 sprintf(string,"%s[%d] %s",program,pid,ErrorString[errlev]);

 for(i=0,j=strlen(string);fmt[i];i++)
   {
    if(fmt[i]!='%')
       string[j++]=fmt[i];
    else
       if(fmt[++i]!='!')
         {
          string[j++]='%';
          string[j++]=fmt[i];
         }
       else
         {
          char buf[8],*msg=buf;

          if(fmt[++i]=='s')
             msg=strerror(errno);
          else
             sprintf(buf,"%d",errno);

          str_len+=strlen(msg);
          string=realloc(string,str_len);
          string[j]=0;
          strcat(string,msg);
          j+=strlen(msg);
         }
   }
 if(string[j-1]!='\n')
    string[j++]='\n';
 string[j]=0;

 vfprintf(stderr,string,ap);

 va_end(ap);

 free(string);

 if(errlev==Fatal)
    exit(2);
}
