/***************************************
  $Header: /home/amb/wwwoffle/RCS/connect.c 1.2 1997/01/17 19:45:26 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 0.9a.
  Handle WWWOFFLE connections received by the demon.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <unistd.h>

#include "wwwoffle.h"
#include "errors.h"


/*+ The server sockets that we listen on +*/
extern int http_fd,             /*+ for the HTTP connections. +*/
           wwwoffle_fd;         /*+ for the WWWOFFLE connections. +*/

/*+ The proxy server that we use. +*/
extern char *proxy;

/*+ The online / offline status. +*/
extern int online;

/*+ The current number of active servers. +*/
extern int n_servers;

/*+ The wwwoffle client when fetching. +*/
extern int fetching;


/*++++++++++++++++++++++++++++++++++++++
  Parse a request that comes from wwwoffle.

  FILE *client The file pointer that corresponds to the wwwoffle connection.
  ++++++++++++++++++++++++++++++++++++++*/

void CommandConnect(FILE *client)
{
 char *line=NULL;

 if(!(line=fgets_realloc(line,client)))
   {PrintMessage(Warning,"Nothing to read from the wwwoffle control socket [%!s]."); return;}

 if(!strncmp(&line[9],"ONLINE",6))
   {
    char *msg="WWWOFFLE Now Online\n";

    PrintMessage(Inform,"WWWOFFLE Online.");

    write(fileno(client),msg,strlen(msg));

    online=1;
   }
 else if(!strncmp(&line[9],"OFFLINE",7))
   {
    char *msg="WWWOFFLE Now Offline\n";

    PrintMessage(Inform,"WWWOFFLE Offline.");

    write(fileno(client),msg,strlen(msg));

    online=0;

    if(fetching)
      {
       close(fetching);
       fetching=0;
      }
   }
 else if(!strncmp(&line[9],"FETCH",5))
   {
    char *msg;

    PrintMessage(Inform,"WWWOFFLE Fetch.");

    if(fetching)
       msg="WWWOFFLE Already fetching.\n";
    else if(!online)
       msg="WWWOFFLE Must be online to fetch.\n";
    else
       msg="WWWOFFLE Now Fetching.\n";

    write(fileno(client),msg,strlen(msg));

    if(!fetching && online)
      {
       int i;

       fetching=fileno(client);

       for(i=0;i<(MAX_SERVERS/2) && n_servers<=MAX_SERVERS;i++)
          ForkServer(fetching,0);
      }
   }
 else if(!strncmp(&line[9],"GET ",4))
   {
    PrintMessage(Inform,"WWWOFFLE Get.");

    do
      {
       char *url,*request;
       int fd[2];

       while(line[strlen(line)-1]=='\r' || line[strlen(line)-1]=='\n')
          line[strlen(line)-1]=0;

       url=&line[13];
       request=(char*)malloc(strlen(url)+32);

       while(n_servers==MAX_SERVERS)
          sleep(1);

       if(pipe(fd))
         {PrintMessage(Warning,"Cannot create a pipe for get [%!s].");continue;}

       sprintf(request,"GET %s HTTP/1.0\r\nAccept: */*\r\n\r\n",url);
       write(fd[1],request,strlen(request));

       ForkServer(fd[0],online);

       close(fd[0]);
       close(fd[1]);

       free(request);
      }
    while((line=fgets_realloc(line,client)) && line[1] && line[2]);
   }
 else if(!strncmp(&line[9],"PURGE ",6))
   {
    char msg[80];
    int age=DEF_AGE;
    char **hosts=NULL;
    int nhosts=0;

    PrintMessage(Inform,"WWWOFFLE Purge.");

    do
      {
       while(line[strlen(line)-1]=='\r' || line[strlen(line)-1]=='\n')
          line[strlen(line)-1]=0;

       if(!strncmp(&line[15],"AGE ",4))
         {
          char ages[10];
          int tempage=atoi(&line[19]);

          sprintf(ages,"%d",tempage);

          if(!strcmp(&line[19],ages))
             age=tempage;
         }
       else if(!strncmp(&line[15],"HOST ",5))
         {
          if(!hosts)
             hosts=(char**)malloc(8*sizeof(char*));
          else if(!(nhosts%8))
             hosts=realloc(hosts,(8+nhosts)*sizeof(char*));

          hosts[nhosts]=(char*)malloc(strlen(line)-12);
          strcpy(hosts[nhosts],&line[20]);
          nhosts++;
         }
      }
    while((line=fgets_realloc(line,client)) && line[1] && line[2]);

    sprintf(msg,"WWWOFFLE Purging pages older than %d days from %s hosts.\n",age,hosts?"specified":"all");
    write(fileno(client),msg,strlen(msg));

    PurgeCache(age,nhosts,hosts,fileno(client));

    for(nhosts--;nhosts>=0;nhosts--)
       free(hosts[nhosts]);
    free(hosts);
   }
 else
   {
    char *msg=(char*)malloc(strlen(line)+32);

    while(line[strlen(line)-1]=='\r' || line[strlen(line)-1]=='\n')
       line[strlen(line)-1]=0;

    PrintMessage(Warning,"Unknown WWWOFFLE control command '%s'.",line);

    sprintf(msg,"WWWOFFLE Unknown Command '%s'.",line);
    write(fileno(client),msg,strlen(msg));

    free(msg);
   }
}


/*++++++++++++++++++++++++++++++++++++++
  Fork a server.

  int client The file descriptor that the data comes in on.

  int browser Set to true if there is a browser connection.
  ++++++++++++++++++++++++++++++++++++++*/

void ForkServer(int client,int browser)
{
 char *command[5],clientstr[5];
 int pid;

 sprintf(clientstr,"%d",client);

 command[0]="./wwwoffles";
 if(online && browser)
    command[1]="-real";
 else if(online && !browser)
    command[1]="-fetch";
 else if(!online && browser)
    command[1]="-spool";
 else
    command[1]="-get";
 command[2]=clientstr;
 command[3]=proxy;
 command[4]=NULL;

 if((pid=fork())==-1)
    PrintMessage(Warning,"Cannot fork a server [%!s].");
 else
   {
    if(pid)                      /* The parent */
      {
       n_servers++;
       PrintMessage(Inform,"Forked wwwoffles %s (pid=%d).",command[1],pid);
      }
    else                         /* The child */
      {
       if(fetching && fetching!=client)
          close(fetching);

       close(http_fd);
       close(wwwoffle_fd);

       execv(command[0],command);

       PrintMessage(Warning,"Can not execv ./wwwoffles [%!s].");
       exit(1);
      }
   }
}
