/***************************************
  $Header: /home/amb/wwwoffle/RCS/wwwoffles.c 1.1 1997/01/11 13:09:34 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 0.9.
  A server to fetch the required pages.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <signal.h>
#include <unistd.h>
#include <fcntl.h>

#include "wwwoffle.h"
#include "sockets.h"
#include "errors.h"


static void usage(void);

/*+ The mode of the fetch,
  1=real (from host to cache+client),
  2=fetch (from client to cache),
  3=spool (from cache to client),
  4=get (from client to cache - no reply),
  5=index (make index to client). +*/
static int mode=-1;

/*+ The read (and write) file descriptor for the client. +*/
static int client=-1;

/*+ The file descriptor to read and write to the remote host. +*/
static int server=-1;

/*+ The read or write file descriptor for the spool file. +*/
static int spool=-1;

/*+ The read or write file descriptor for the outgoing spool directory. +*/
static int outgoing=-1;


/*++++++++++++++++++++++++++++++++++++++
  The main program.
  ++++++++++++++++++++++++++++++++++++++*/

int main(int argc, char** argv)
{
 char *buffer,*url;
 char *server_host=NULL;
 int server_port=0;
 int n;
 FILE *client_file=NULL,*outgoing_file=NULL;

 /* Parse the command line options */

 if(argc!=3 && argc!=4)
    usage();

 if(!strcmp(argv[1],"-real"))
    mode=1;
 else if(!strcmp(argv[1],"-fetch"))
    mode=2;
 else if(!strcmp(argv[1],"-spool"))
    mode=3;
 else if(!strcmp(argv[1],"-get"))
    mode=4;
 else
    exit(1);

 /* Initialise things. */

 InitErrorHandler(argv[0]);

 signal(SIGPIPE,SIG_IGN);

 /* Set up the file handle to read the request from. */

 client=atoi(argv[2]);

 if(client<=0)
    PrintMessage(Fatal,"Cannot use client file descriptor %d.",client);

 client_file=fdopen(client,"r");
 if(!client_file)
    PrintMessage(Fatal,"Cannot use fdopen on the client file descriptor %d.",client);

 if(mode==2)
   {
    outgoing=OpenOutgoingSpoolFile(1);

    if(outgoing==-1)
       PrintMessage(Fatal,"Cannot open the spooled outgoing request to read.");
    else if(outgoing==-2)
      {PrintMessage(Inform,"No more spooled outgoing requests.");return(3);}

    outgoing_file=fdopen(outgoing,"r");
    if(!outgoing_file)
       PrintMessage(Fatal,"Cannot use fdopen on the outgoing file descriptor %d.",outgoing);
   }

 /* Get the URL from the request. */

 if(mode==1 || mode==3 || mode==4)
    buffer=GetURL(client_file,&url);
 else /* mode==2 */
    buffer=GetURL(outgoing_file,&url);

 if(url)
   {
    PrintMessage(Inform,"URL = %s",url);

    if(mode==1 || mode==3)
      {
       char *host,*path,*args;

       SplitURL(url,&host,&path,&args);

       if(!*host)
          mode=5;
       if(mode==3 && !strncmp(host,"localhost",9))
          mode=1;
      }
   }
 else
   {
    if(mode!=4)
       ServerErrorMessage(client,buffer?"Cannot parse the HTTP request":"The HTTP request was empty");

    PrintMessage(Fatal,"Could not parse HTTP request (%s).",buffer?"Parse error":"Empty request");
   }

 /* Set up the file descriptor for the spool file. */

 if(mode==1 || mode==2 || mode==4)
   {
    spool=OpenWebpageSpoolFile(0,url);

    if(spool==-1)
      {
       if(mode==1)
          ServerErrorMessage(client,"Cannot open the spooled web page to write");

       PrintMessage(Fatal,"Cannot open the spooled web page to write.");
      }
   }
 else if(mode==3)
   {
    spool=OpenWebpageSpoolFile(1,url);

    if(spool==-1)
      {
       mode=-3;

       spool=OpenWebpageSpoolFile(0,url);

       if(spool==-1)
         {
          ServerErrorMessage(client,"Cannot open the spooled web page to write");

          PrintMessage(Fatal,"Cannot open a spooled web page to write.");
         }
      }
   }

 if(mode==-3 || mode==4)
   {
    outgoing=OpenOutgoingSpoolFile(0);

    if(outgoing==-1)
      {
       if(mode==-3)
          ServerErrorMessage(client,"Cannot open the spooled outgoing request to write");

       PrintMessage(Fatal,"Cannot open the spooled outgoing request to write.");
      }
   }

 /* Set up the file descriptor for the remote host. */

 if(mode==1 || mode==2)
   {
    char *host,*colon;
    int port=80;

    if(argc==4)
      {
       host=(char*)malloc(strlen(argv[3])+1);
       strcpy(host,argv[3]);
      }
    else
      {
       char *path,*args;

       SplitURL(url,&host,&path,&args);

       MakeRequestNonProxy(url,path,args,&buffer,&n);
      }

    if((colon=strchr(host,':')))
      {
       *colon++=0;
       if(*colon)
          port=atoi(colon);
      }

    server=OpenClientSocket(host,port);

    if(server==-1)
      {
       ServerFetchFailed(spool,url,host,port,1);
       if(mode==1)
          ServerFetchFailed(client,url,host,port,1);

       PrintMessage(Fatal,"Cannot open a socket to the server %s port %d.",host,port);
      }

    server_host=host;
    server_port=port;
   }

 /* Do whatever is needed. */

 buffer=(char*)realloc(buffer,257);

 if(mode==1)
   {
    do
      {
       write(server,buffer,strlen(buffer));
      }
    while(buffer && buffer[1] && buffer[2] && (buffer=fgets_realloc(buffer,client_file)));

    if(!buffer)
       buffer=(char*)malloc(257);

    while((n=ReadOrTimeout(server,buffer,256,SERVER_TIMEOUT))>0)
      {
       write(spool,buffer,n);
       write(client,buffer,n);
      }

    if(n<0)
      {
       PrintMessage(Warning,"Timed out while reading from server.");
       lseek(spool,0,SEEK_SET);
       ServerFetchFailed(spool,url,server_host,server_port,0);
      }
   }
 else if(mode==2)
   {
    do
      {
       write(server,buffer,strlen(buffer));
      }
    while(buffer && buffer[1] && buffer[2] && (buffer=fgets_realloc(buffer,outgoing_file)));

    if(!buffer)
       buffer=(char*)malloc(strlen(url)>256?strlen(url)+32:257);

    sprintf(buffer,"Fetching %s\n",url);
    write(client,buffer,strlen(buffer));

    while((n=ReadOrTimeout(server,buffer,256,SERVER_TIMEOUT))>0)
       write(spool,buffer,n);

    if(n<0)
      {
       PrintMessage(Warning,"Timed out while reading from server.");
       lseek(spool,0,SEEK_SET);
       ServerFetchFailed(spool,url,server_host,server_port,0);
      }
   }
 else if(mode==3)
   {
    char *head="HTTP/1.0 400 WWWOFFLE Fetch Failed\r\n";

    n=read(spool,buffer,256);

    if(n==0 || !strncmp(buffer,head,strlen(head)))
       OpenWebpageSpoolFile(-1,url);

    if(n)
       do
         {
          write(client,buffer,n);
         }
       while((n=read(spool,buffer,256)));
   }
 else if(mode==-3)
   {
    do
      {
       write(outgoing,buffer,strlen(buffer));
      }
    while(buffer && buffer[1] && buffer[2] && (buffer=fgets_realloc(buffer,client_file)));

    WillGet(client,url,0);
    WillGet(spool,url,1);
   }
 else if(mode==4)
   {
    do
      {
       write(outgoing,buffer,strlen(buffer));
      }
    while(buffer && buffer[1] && buffer[2] && (buffer=fgets_realloc(buffer,client_file)));

    WillGet(spool,url,1);
   }
 else /* mode==5 */
   {
    GenerateIndex(client,url);
   }

 /* Close down and exit. */

 if(client>0)
    fclose(client_file);

 if(server>0)
    CloseSocket(server);

 if(outgoing>0)
   {
    if(mode==2)
       fclose(outgoing_file);
    else
       close(outgoing);
   }

 if(spool>0)
    close(spool);

 if(buffer)
    free(buffer);

 return(0);
}


/*++++++++++++++++++++++++++++++++++++++
  Print the program usage.
  ++++++++++++++++++++++++++++++++++++++*/

static void usage(void)
{
 fputs("\n"
       "WWWOFFLES - World Wide Web Offline Explorer (Server) - Version 0.9\n"
       "\n",stderr);

 fputs("(c) Andrew M. Bishop 1996,97 [       amb@gedanken.demon.co.uk ]\n"
       "                             [http://www.gedanken.demon.co.uk/]\n"
       "\n",stderr);

 fputs("*** Don't run this program, use wwwoffle or wwwoffled instead. ***\n"
       "\n",stderr);

 exit(1);
}
