/***************************************
  $Header: /home/amb/wwwoffle/RCS/sockets.c 1.1 1997/01/11 13:09:34 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 0.9.
  Socket manipulation routines.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdio.h>
#include <errno.h>
#include <unistd.h>

#include <netdb.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "errors.h"
#include "sockets.h"


/*++++++++++++++++++++++++++++++++++++++
  Opens a socket for a client.

  int OpenClientSocket Returns the socket file descriptor.

  char* host The name of the remote host.

  int port The socket number.
  ++++++++++++++++++++++++++++++++++++++*/

int OpenClientSocket(char* host, int port)
{
 int s;
 int retval,err=0;
 struct sockaddr_in server;
 struct hostent* hp;
 int retries=4;

 server.sin_family=AF_INET;
 server.sin_port=htons((unsigned short)port);

 hp=gethostbyname(host);
 if(!hp)
   {PrintMessage(Warning,"Unknown host '%s' for server [%!s].",host);return(-1);}
 memcpy((char*)&server.sin_addr,(char*)hp->h_addr,sizeof(server.sin_addr));

 do{
    s=socket(PF_INET,SOCK_STREAM,0);
    if(s==-1)
      {PrintMessage(Warning,"Cannot create client socket [%!s].");return(-1);}

    retval=connect(s,(struct sockaddr *)&server,sizeof(server));
    if(retval==-1)
      {
       err=errno;
       if(--retries)
          PrintMessage(Inform,"Connect fail [%!s]%s.",errno==ECONNREFUSED?"; trying again":"");
       else
         {PrintMessage(Warning,"Connect fail [%!s].");return(-1);}
       close(s);
       sleep(1);
      }
   }
 while(retval==-1 && err==ECONNREFUSED);

 return(s);
}


/*++++++++++++++++++++++++++++++++++++++
  Opens a socket for a server.

  int OpenServerSocket Returns a socket to be a server.

  int port The port number to use.
  ++++++++++++++++++++++++++++++++++++++*/

int OpenServerSocket(int port)
{
 int s;
 int retval;
 struct sockaddr_in server;
 int reuse_addr=1;

 s=socket(PF_INET,SOCK_STREAM,0);
 if(s==-1)
   {PrintMessage(Warning,"Cannot create server socket [%!s].");return(-1);}

 setsockopt(s,SOL_SOCKET,SO_REUSEADDR,&reuse_addr,sizeof(reuse_addr));

 server.sin_family=AF_INET;
 server.sin_addr.s_addr=INADDR_ANY;
 server.sin_port=htons((unsigned int)port);

 retval=bind(s,(struct sockaddr*)&server,sizeof(server));
 if(retval==-1)
   {PrintMessage(Warning,"Failed to bind server socket [%!s].");return(-1);}

 listen(s,4);

 return(s);
}


/*++++++++++++++++++++++++++++++++++++++
  Waits for a connection on the socket.

  int AcceptConnect returns a socket with a remote connection on the end.

  int s Specifies the socket to check for.

  char** name Returns the name of the remote connection.

  int* port Returns the port number on the remote machine.
  ++++++++++++++++++++++++++++++++++++++*/

int AcceptConnect(int s,char** name,int* port)
{
 struct sockaddr_in server;
 int length=sizeof(server),retval;
 static char host[MAXHOSTNAMELEN];
 struct hostent* hp=NULL;
 int msg;

 msg=accept(s,(struct sockaddr*)0,(int*)0);

 if(msg==-1)
    PrintMessage(Warning,"Accept on server socket failed [%!s].",s);
 else
   {
    retval=getpeername(msg,(struct sockaddr*)&server,&length);
    if(retval==-1)
       PrintMessage(Warning,"Failed to get client socket peername [%!s].");
    else
      {
       hp=gethostbyaddr((char*)&server.sin_addr,sizeof(server.sin_addr),AF_INET);
       if(hp)
          strcpy(host,hp->h_name);
       else
         {
          unsigned char addr[4];
          int i;

          for(i=0;i<4;i++)
             addr[i]=(server.sin_addr.s_addr>>(8*i))%256;

          sprintf(host,"%d.%d.%d.%d",addr[3],addr[2],addr[1],addr[0]);
         }

       *name=host;
       *port=ntohs(server.sin_port);
      }
   }

 return(msg);
}


/*++++++++++++++++++++++++++++++++++++++
  Closes a previously opened socket.

  int s The socket to close
  ++++++++++++++++++++++++++++++++++++++*/

void CloseSocket(int s)
{
 int retval=close(s);

 if(retval==-1)
    PrintMessage(Warning,"Socket close failed [%!s].");
}
