/***************************************
  $Header: /home/amb/wwwoffle/RCS/parse.c 1.1 1997/01/11 13:21:42 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 0.9.
  Functions to parse the HTTP requests.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <unistd.h>

#include "wwwoffle.h"


/*++++++++++++++++++++++++++++++++++++++
  Read from the specified file descriptor until a URL is seen.

  char *GetURL Returns the line that was read.

  FILE *req The file pointer to read the request from.

  char **url Return the url or NULL if it failed.
  ++++++++++++++++++++++++++++++++++++++*/

char *GetURL(FILE *req,char **url)
{
 int start=0,stop=0;
 char *buffer=NULL;

 *url=NULL;

 buffer=fgets_realloc(buffer,req);

 if(!buffer)
    return(NULL);

 /* Make a copy of the URL from the buffer */

 for(start=0;buffer[start]!='\n';start++)
    if(buffer[start]==' ' || buffer[start]=='\t')
       break;

 while(buffer[++start]!='\n' && (buffer[start]==' ' || buffer[start]=='\t'));

 if(buffer[start]=='\n')
    return(buffer);

 for(stop=start;buffer[stop]!='\n';stop++)
    if(buffer[stop]==' ' || buffer[stop]=='\t' || buffer[stop]=='\r')
       break;

 *url=(char*)malloc(stop-start+1);
 strncpy(*url,&buffer[start],stop-start);
 (*url)[stop-start]=0;

 return(buffer);
}


/*++++++++++++++++++++++++++++++++++++++
  Split a URL into a hostname, a path name and an argument list.

  char *url The URL to split.

  char **host Returns a pointer to the hostname.

  char **path Returns a pointer to the path of the file.

  char **args Returns a pointer to the arguments if any to the URL.
  ++++++++++++++++++++++++++++++++++++++*/

void SplitURL(char *url,char **host,char **path,char **args)
{
 int i=0;
 char *copyurl=malloc(strlen(url)+1);

 strcpy(copyurl,url);
 *host=NULL;
 *path=NULL;
 *args=NULL;

 /* Split up the copy of the URL */

 if(!strncasecmp(copyurl,"http:",5))
   {
    i=5;
    if(copyurl[i]=='/') i++;
    if(copyurl[i]=='/') i++;
   }

 *host=&copyurl[i];

 for(;copyurl[i];i++)
    if(copyurl[i]=='/')
       break;

 if(copyurl[i])
   {
    copyurl[i++]=0;

    *path=&copyurl[i];

    for(;copyurl[i];i++)
       if(copyurl[i]=='?')
          break;

    if(copyurl[i])
      {
       copyurl[i++]=0;

       *args=&copyurl[i];
      }
   }

 if(!*path || !**path)
    *path="";
}


/*++++++++++++++++++++++++++++++++++++++
  Change the request from one to a proxy to a normal one.

  char *url The URL that we are trying to get.

  char *path The path we are going to get.

  char *args The arguments to the URL we are going to get.

  char **buffer The buffer containing the request.

  int *n The number of bytes in the buffer.
  ++++++++++++++++++++++++++++++++++++++*/

void MakeRequestNonProxy(char *url,char *path,char *args,char **buffer,int *n)
{
 char *start=strstr(*buffer,url);
 char *stop=start+strlen(url);

 strcpy(start,"/");
 start++;

 if(*path)
   {
    strcpy(start,path);
    start+=strlen(path);
   }

 if(args)
   {
    strcpy(start,"?");
    start++;
    strcpy(start,args);
    start+=strlen(args);
   }

 while(*stop)
    *start++=*stop++;

 *start=0;

 *n=start-*buffer;
}
