/***************************************
  $Header: /home/amb/wwwoffle/RCS/messages.c 1.1 1997/01/11 13:09:34 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 0.9.
  Messages that the program sends in reply to requests from browsers
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdio.h>

#include <unistd.h>

#include "wwwoffle.h"


/*++++++++++++++++++++++++++++++++++++++
  A fatal server error occured.

  int fd The file descriptor to report the error to.

  char *string The message string of the error.
  ++++++++++++++++++++++++++++++++++++++*/

void ServerErrorMessage(int fd,char *string)
{
 char *head=
 "HTTP/1.0 400 WWWOFFLE Internal Error\r\n"
 "Content-type: text/html\r\n"
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>\n"
 "WWWOFFLE - World Wide Web Offline Explorer\n"
 "</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n"
 "<H1 align=center>WWWOFFLE Internal Error</H1>\n"
 "<p align=center>\n"
 "The WWWOFFLE server encountered a fatal error\n"
 "<br><b><tt>\n";
 char *tail=
 "\n"
 "</tt></b>\n"
 "</BODY>\n"
 "</HTML>\n";

 write(fd,head  ,strlen(head));
 write(fd,string,strlen(string));
 write(fd,tail  ,strlen(tail));
}


/*++++++++++++++++++++++++++++++++++++++
  The connection to the remote host failed.

  int fd The file descriptor to send the message to.

  char *url The url that failed.

  char *host The host that the connection to failed.

  int port The port number on the host that failed.

  int connect_or_timeout Set to true if the failure was during connection, else timeout.
  ++++++++++++++++++++++++++++++++++++++*/

void ServerFetchFailed(int fd,char *url,char *host,int port,int connect_or_timeout)
{
 char string[16];
 char *head=
 "HTTP/1.0 400 WWWOFFLE Fetch Failed\r\n" /* This line must not be changed (see wwwoffles.h). */
 "Content-type: text/html\r\n"
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>\n"
 "WWWOFFLE - World Wide Web Offline Explorer\n"
 "</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n"
 "<H1 align=center>WWWOFFLE Server Connect Failed</H1>\n"
 "<p align=center>\n"
 "Your request for URL\n"
 "<br><b><tt>\n";
 char *middle=
 "\n"
 "</tt></b><br>\n"
 "failed because the connection to\n"
 "<br><b><tt>\n";
 char *tail1=
 "\n"
 "</tt></b><br>\n"
 "could not be made.\n"
 "</BODY>\n"
 "</HTML>\n";
 char *tail2=
 "\n"
 "</tt></b><br>\n"
 "timed out during the transfer.\n"
 "</BODY>\n"
 "</HTML>\n";

 sprintf(string," port %d",port);

 write(fd,head  ,strlen(head));
 write(fd,url   ,strlen(url));
 write(fd,middle,strlen(middle));
 write(fd,host  ,strlen(host));
 if(port!=80)
    write(fd,string,strlen(string));
 if(connect_or_timeout)
    write(fd,tail1,strlen(tail1));
 else
    write(fd,tail2,strlen(tail2));
}


/*++++++++++++++++++++++++++++++++++++++
  Print the message stating that we will get the URL.

  int fd The file descriptor to send the message to.

  char *url The url we are going to get.

  int already Set to true if we have already marked this for getting.
  ++++++++++++++++++++++++++++++++++++++*/

void WillGet(int fd,char *url,int already)
{
 char *head=
 "HTTP/1.0 400 WWWOFFLE Will Get\r\n"
 "Content-type: text/html\r\n"
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>\n"
 "WWWOFFLE - World Wide Web Offline Explorer\n"
 "</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n";
 char *middle1=
 "<H1 align=center>WWWOFFLE Request Recorded</H1>\n"
 "<p align=center>\n"
 "Your request for URL\n"
 "<br><b><tt>\n";
 char *middle2=
 "<H1 align=center>WWWOFFLE Request Already Recorded</H1>\n"
 "<p align=center>\n"
 "Your request for URL\n"
 "<br><b><tt>\n";
 char *tail1=
 "\n"
 "</tt></b><br>\n"
 "has been recorded for download.\n"
 "</BODY>\n"
 "</HTML>\n";
 char *tail2=
 "\n"
 "</tt></b><br>\n"
 "has already been recorded for download.\n"
 "</BODY>\n"
 "</HTML>\n";

 write(fd,head,strlen(head));
 if(already)
    write(fd,middle2,strlen(middle2));
 else
    write(fd,middle1,strlen(middle1));
 write(fd,url ,strlen(url));
 if(already)
    write(fd,tail2,strlen(tail2));
 else
    write(fd,tail1,strlen(tail1));
}
