/***************************************
  $Header: /home/amb/wwwoffle/RCS/io.c 1.1 1997/01/11 13:09:34 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 0.9.
  Functions for file input and output.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdio.h>
#include <stdlib.h>

#include <sys/time.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>

#include "wwwoffle.h"


/*++++++++++++++++++++++++++++++++++++++
  Call fgets and realloc the buffer as needed to get a whole line.

  char *fgets_realloc Returns the modified buffer (NULL at the end of the file).

  char *buffer The current buffer.

  FILE *file The file to read from.
  ++++++++++++++++++++++++++++++++++++++*/

char *fgets_realloc(char *buffer,FILE *file)
{
 int n=0;
 char *buf;

 if(!buffer)
    buffer=(char*)malloc(65);

 while((buf=fgets(&buffer[n],64,file)))
   {
    int s=strlen(buf);
    n+=s;

    if(buffer[n-1]=='\n')
       break;
    else
       buffer=(char*)realloc(buffer,n+65);
   }

 if(!buf)
   {free(buffer);buffer=NULL;}

 return(buffer);
}


/*++++++++++++++++++++++++++++++++++++++
  Read data from a file descriptor, with a timeout.

  int ReadOrTimeout Returns the number of bytes read or -1 for a timeout.

  int fd The file descriptor.

  char *buffer The buffer to put the data into.

  int n The number of bytes read.

  int timeout The time in seconds to wait for data before quiting.
  ++++++++++++++++++++++++++++++++++++++*/

int ReadOrTimeout(int fd,char *buffer,int n,int timeout)
{
 fd_set readfd;
 struct timeval tv;

 FD_ZERO(&readfd);

 FD_SET(fd,&readfd);

 tv.tv_sec=timeout;
 tv.tv_usec=0;

 if(select(fd+1,&readfd,NULL,NULL,&tv)<=0)
    return(-1);

 return(read(fd,buffer,n));
}
