/***************************************
  $Header: /home/amb/wwwoffle/RCS/index.c 1.1 1997/01/11 13:09:34 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 0.9.
  Generate an index of the web pages that are cached in the system.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdio.h>
#include <stdlib.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <dirent.h>
#include <fcntl.h>
#include <unistd.h>

#include "wwwoffle.h"
#include "errors.h"


static void IndexDir(int fd,char *dirname);
static void IndexRoot(int fd);


/*++++++++++++++++++++++++++++++++++++++
  Generate an index of the pages that are in the cache.

  int fd The file descriptor to write the output to.

  char *url The URL that specifies the path to generate the index for.
  ++++++++++++++++++++++++++++++++++++++*/

void GenerateIndex(int fd,char *url)
{
 char *head=
 "HTTP/1.0 200 WWWOFFLE Index\r\n"
 "Content-type: text/html\r\n"
 "\r\n"
 "<HTML>\n"
 "<HEAD>\n"
 "<TITLE>\n"
 "WWWOFFLE - World Wide Web Offline Explorer\n"
 "</TITLE>\n"
 "</HEAD>\n"
 "<BODY>\n"
 "<H1 align=center>WWWOFFLE Cache Index</H1>\n"
 "<ul>\n";
 char *head2=
 "<ul>\n";
 char *tail2=
 "</ul>\n";
 char *tail=
 "</ul>\n"
 "</BODY>\n"
 "</HTML>\n";

 write(fd,head,strlen(head));

 if(!url[1])
    IndexRoot(fd);
 else
   {
    char *buffer=(char*)malloc(strlen(url)+24);
    sprintf(buffer,"<li><b>http://%s</b>\n",&url[1]);
    write(fd,buffer,strlen(buffer));
    free(buffer);

    write(fd,head2,strlen(head2));

    IndexDir(fd,&url[1]);

    write(fd,tail2,strlen(tail2));
   }

 write(fd,tail,strlen(tail));
}


/*++++++++++++++++++++++++++++++++++++++
  Index the root of the cache.

  int fd The file descriptor to write to.
  ++++++++++++++++++++++++++++++++++++++*/

static void IndexRoot(int fd)
{
 DIR *dir;
 struct dirent* ent;

 /* Open the spool directory. */

 dir=opendir(".");
 if(!dir)
   {PrintMessage(Warning,"Cannot open spool directory [%!s]; index failed.");return;}

 ent=readdir(dir);
 if(!ent)
   {PrintMessage(Warning,"Cannot read spool directory [%!s]; index failed.");closedir(dir);return;}

 ent=readdir(dir);  /* skip .  */
 ent=readdir(dir);  /* skip .. */

 /* Print all of the sub directories. */

 while(ent)
   {
    char *name=ent->d_name;
    struct stat buf;

    if(stat(name,&buf))
       PrintMessage(Warning,"Cannot stat file '%s' [%!s]; race condition?",name);
    else
       if(S_ISDIR(buf.st_mode) && strcmp(name,"outgoing"))
         {
          char *buffer=(char*)malloc(2*strlen(name)+32);
          sprintf(buffer,"<li><b><a href=\"%s\">%s</a></b>\n",name,name);
          write(fd,buffer,strlen(buffer));
          free(buffer);
         }

    ent=readdir(dir);
   }

 closedir(dir);
}


/*++++++++++++++++++++++++++++++++++++++
  Create an index of a subdirectory.

  int fd The file descriptor to write to.

  char *dirname The name of the subdirectory.
  ++++++++++++++++++++++++++++++++++++++*/

static void IndexDir(int fd,char *dirname)
{
 DIR *dir;
 struct dirent* ent;

 /* Open the spool subdirectory. */

 if(chdir(dirname))
   {PrintMessage(Warning,"Cannot change to directory '%s' [%!s]; not indexed.",dirname);return;}

 dir=opendir(".");
 if(!dir)
   {PrintMessage(Warning,"Cannot open directory '%s' [%!s]; not indexed.",dirname);chdir("..");return;}

 ent=readdir(dir);
 if(!ent)
   {PrintMessage(Warning,"Cannot read directory '%s' [%!s]; not indexed.",dirname);closedir(dir);chdir("..");return;}

 ent=readdir(dir);  /* skip .  */
 ent=readdir(dir);  /* skip .. */

 /* Print all of the file names. */

 while(ent)
   {
    char *name=(char*)malloc(strlen(ent->d_name)+1);
    struct stat buf;
    char *buffer;

    strcpy(name,ent->d_name);

    if(stat(name,&buf))
       PrintMessage(Warning,"Cannot stat file '%s/%s' [%!s]; race condition?",dirname,name);
    else
      {
       int i;
       char *args="";

       for(i=0;name[i];i++)
          if(name[i]==PATH_SEP)
            {
             if(name[i+1]==PATH_SEP)
               {args=&name[i];break;}
             else
                name[i]='/';
            }

       if(args!=name)
         {
          if(*args)
            {
             int afd=open(args,O_RDONLY);

             *args=0;

             if(afd!=-1)
               {
                int rr,r=0;
                args=(char*)malloc(64+1);

                while((rr=read(afd,&args[r],64)))
                  {
                   r+=rr;
                   args=(char*)realloc(args,r+64+1);
                  }

                args[r]=0;
                close(afd);
               }
            }

          buffer=(char*)malloc(2*strlen(args)+2*strlen(name)+strlen(dirname)+48);

          if(*args)
             sprintf(buffer,"<li><b><a href=\"http://%s/%s?%s\">%s?%s</a></b>\n",dirname,name[1]?name:"",args,name,args);
          else
             sprintf(buffer,"<li><b><a href=\"http://%s/%s\">%s</a></b>\n",dirname,name[1]?name:"",name);
          write(fd,buffer,strlen(buffer));

          free(buffer);
         }
      }

    free(name);

    ent=readdir(dir);
   }

 chdir("..");
}
