/* UTF8-UCS4-String/lib/xp/include/utf8stringmap.h
 * 
 * Copyright (C) 2002 Francis James Franklin <fjf@alinameridon.com>
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef UTF8_UCS4_STRING__UTF8STRINGMAP_H
#define UTF8_UCS4_STRING__UTF8STRINGMAP_H

#ifdef UTF8_UCS4_STRING_SOURCE
#include "utf8stringpair.h"
#else
#include <UTF8-UCS4-String/utf8stringpair.h>
#endif

class UTF8StringMap
{
 private:
  class UTF8StringMapValue
    {
    public:
      UTF8StringMapValue ();
      UTF8StringMapValue (const UTF8StringMapValue & rhs);

      ~UTF8StringMapValue ();

      void clear ();

      bool ins (const UTF8String & key, const UTF8String & value, unsigned long & index);

      void del (const UTF8String & key, unsigned long & index);
      void del (const char * key_utf8str, unsigned long & index);

      const UTF8String * lookup (const UTF8String & key, unsigned long & index) const;
      const UTF8String * lookup (const char * key_utf8str, unsigned long & index) const;

      inline const UTF8StringPair * operator[] (unsigned long i) const { return m_pair[i]; }

      unsigned long size () const { return m_pair_count; }

      int count () const { return m_count; }

      int ref ()   { return ++m_count; }
      int unref () { return --m_count; }

    private:
      int m_count; // reference count

      unsigned long m_pair_max;
      unsigned long m_pair_count;

      UTF8StringPair ** m_pair;

      bool grow (unsigned long size = 1);
    };

  UTF8StringMapValue * m_value;

 public:
  UTF8StringMap ();
  UTF8StringMap (const UTF8StringMap & rhs);

  ~UTF8StringMap ();

  UTF8StringMap & operator= (const UTF8StringMap & rhs);

  void clear ();

  inline bool ins (const UTF8StringPair & pair)
    {
      return ins (pair.name (), pair.value ());
    }
  bool ins (const UTF8String & key, const UTF8String & value);

  void del (const UTF8String & key);
  void del (const char * key_utf8str);

  inline const UTF8StringPair * lookup (const UTF8String & key) const
    {
      unsigned long index = 0;
      if (m_value->lookup (key, index)) return (*m_value)[index];
      return 0;
    }
  inline const UTF8StringPair * lookup (const char * key_utf8str) const
    {
      unsigned long index = 0;
      if (m_value->lookup (key_utf8str, index)) return (*m_value)[index];
      return 0;
    }

  inline const UTF8StringPair * operator[] (unsigned long i) const
    {
      if (i >= m_value->size ()) return 0;
      return (*m_value)[i];
    }
  unsigned long size () const { return m_value->size (); }
};

#endif /* ! UTF8_UCS4_STRING__UTF8STRINGMAP_H */
