/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* UTF8-UCS4-String/lib/cocoa/UUS_Tree.mm
 * 
 * Copyright (C) 2002 Francis James Franklin <fjf@alinameridon.com>
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "UTF8StringTree.h"
#include "UUS_Tree.h"

@implementation UUS_Tree

+ (UUS_Tree *)treeWithData:(NSData *)data
{
	if (data == nil) return nil;

	UUS_Tree * uus_tree = [UUS_Tree alloc];
	if (uus_tree)
		{
			[uus_tree init];

			UTF8StringTree * tree = 0;
			try
				{
					tree = new UTF8StringTree;
				}
			catch (...)
				{
					tree = 0;
				}
			if (tree)
				{
					bool success = false;
					try
						{
							UTF8String error;
							tree->import ((const char *) [data bytes], (int) [data length], error);
							success = true;
						}
					catch (...)
						{
							success = false;
						}
					if (success)
						{
							void * treeptr = reinterpret_cast<void *>(tree);
							[uus_tree setTree:treeptr];
						}
					else
						{
							delete tree;
							tree = 0;
						}
				}
			if (tree == 0)
				{
					[uus_tree release];
					uus_tree = nil;
				}
		}
	return uus_tree;
}

- (id)init
{
	[super init];

	m_count = 1;
	m_tree = 0;

	return self;
}

- (void)setTree:(void *)tree
{
	if (m_tree)
		{
			UTF8StringTree * old_tree = reinterpret_cast<UTF8StringTree *>(m_tree);
			delete old_tree;
		}
	m_tree = tree;
}

- (const void *)tree
{
	return m_tree;
}

- (id)retain
{
	if (m_count > 0) m_count++;
	return [super retain];
}

- (oneway void)release
{
	if (--m_count == 0)
		{
			if (m_tree)
				{
					UTF8StringTree * tree = reinterpret_cast<UTF8StringTree *>(m_tree);
					delete tree;
					m_tree = 0;
				}
		}
	[super release];
}

@end
