/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* UTF8-UCS4-String/lib/cocoa/UTF8-UCS4-String.framework/Headers/UUS_Window.h
 * 
 * Copyright (C) 2002 Francis James Franklin <fjf@alinameridon.com>
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef UTF8_UCS4_STRING__UUS_WINDOW_H
#define UTF8_UCS4_STRING__UUS_WINDOW_H

#import <Cocoa/Cocoa.h>

class UUS_Window
{
public:
	enum WindowStyle
	{
		ws_Normal,
		ws_Panel,
		ws_Raw
	};

protected:
	UUS_Window (WindowStyle ws);

public:
	~UUS_Window ();

private:
	WindowStyle				m_ws;
	unsigned int			m_styleMask;
	NSBackingStoreType		m_backingType;
	NSWindowController *	m_controller;
	NSWindow *				m_window;
	NSView *				m_view;
	float					m_opacity;
	NSRect					m_frame;

protected:
	bool create (bool closable, bool miniaturizable, bool resizable);
	virtual bool create ();
	virtual void destroy ();

	void setAlpha (float opacity); // 0..1

	unsigned int width ()  const { return static_cast<unsigned int>(m_frame.size.width);  }
	unsigned int height () const { return static_cast<unsigned int>(m_frame.size.height); }

	void setSize (unsigned int width, unsigned int height);
	void setMinSize (unsigned int width, unsigned int height);

	bool replaceMainView (NSView * view); // call this *after* create()

	virtual void notifyResized ();
	virtual bool closeRequest ();
public:
	void recalibrate ();
	bool close ();
};

#endif /* ! UTF8_UCS4_STRING__UUS_WINDOW_H */
