/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* UTF8-UCS4-String/lib/cocoa/UTF8-UCS4-String.framework/Headers/UUS_TreeWindow.h
 * 
 * Copyright (C) 2002 Francis James Franklin <fjf@alinameridon.com>
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef UTF8_UCS4_STRING__UUS_TREEWINDOW_H
#define UTF8_UCS4_STRING__UUS_TREEWINDOW_H

#ifdef UTF8_UCS4_STRING_SOURCE
#include "UUS_Tree.h"
#else
#include <UTF8-UCS4-String/UUS_Tree.h>
#endif

@interface UUS_TreeWindow : NSObject
{
	int			m_count;
	void *		m_window;
	UUS_Tree *	m_tree;
	BOOL		m_isPanel;
}
+(UUS_TreeWindow *)windowWithTree:(UUS_Tree *)tree;
+(UUS_TreeWindow *)panelWithTree:(UUS_Tree *)tree;
-(id)initWithWindow:(void *)window;
-(id)initWithPanel:(void *)window;
-(void)setTree:(UUS_Tree *)tree;
-(UUS_Tree *)tree;
-(BOOL)show;
-(void)hide;
-(id)retain;
-(oneway void)release;
@end

#endif /* ! UTF8_UCS4_STRING__UUS_TREEWINDOW_H */
