/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* UTF8-UCS4-String/lib/cocoa/UTF8-UCS4-String.framework/Headers/UUS_Table.h
 * 
 * Copyright (C) 2002 Francis James Franklin <fjf@alinameridon.com>
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef UTF8_UCS4_STRING__UUS_TABLE_H
#define UTF8_UCS4_STRING__UUS_TABLE_H

#import <Cocoa/Cocoa.h>

#ifdef UTF8_UCS4_STRING_SOURCE
#include "utf8stringmap.h"
#else
#include <UTF8-UCS4-String/utf8stringmap.h>
#endif

class UTF8StringTree;

class UUS_Table
{
public:
	class TableClick
	{
	public:
		virtual void tableClick (const UUS_Table & table) = 0;
		virtual ~TableClick () { }
	};

	UUS_Table (const UTF8String & table_name, bool is_outline = false);

	virtual ~UUS_Table ();

	const UTF8String & name () const { return m_table_name; }

	virtual bool attach (NSView * parent, int x, int y, unsigned int width, unsigned int height, unsigned int mask);
	virtual void detach ();

	bool exists () const { return (m_scroll_view == nil) ? false : true; }

	bool column (id identifier, NSString * header, bool is_outline = false);

	virtual void clear (); // remove all columns

	void reload ();

	/* data_src and delegate will be retained and later released
	 */
	void set_data_src (id data_src); // set_data_src (nil) will release the current data source, if any, and empty the table
	void set_delegate (id delegate); // set_delegate (nil) will release the current delegate, if any

	int selectedRow ();  // -1 if none
	id  selectedItem (); // nil if none - outline tables only

	void click () const
	{
		if (m_target) m_target->tableClick (*this);
	}
protected:
	TableClick *		m_target;
private:
	const UTF8String	m_table_name;
	bool				m_is_outline;
	NSScrollView *		m_scroll_view;
	NSTableView *		m_table_view;
	NSTableHeaderView *	m_header_view;
	id					m_data_src;
	id					m_delegate;
};

@interface UUS_MapTableDataSource : NSObject
{
	int					m_count;
	UTF8StringMap *		m_map;
}
-(id)initWithMap:(UTF8StringMap *)map;
-(int)numberOfRowsInTableView:(NSTableView *)aTableView;
-(id)tableView:(NSTableView *)aTableView objectValueForTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex;
-(BOOL)tableView:(NSTableView *)aTableView shouldEditTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex;
-(id)retain;
-(oneway void)release;
@end

class UUS_MapTable : public UUS_Table
{
public:
	UUS_MapTable (const UTF8String & table_name);
	UUS_MapTable (const UTF8String & table_name, const UTF8StringMap & map, const UTF8String & left, const UTF8String & right);

	~UUS_MapTable ();

	void clear (); // disassociate current map

	bool remap (const UTF8StringMap & map, const UTF8String & left, const UTF8String & right);
private:
	bool _map ();

public:
	bool attach (NSView * parent, int x, int y, unsigned int width, unsigned int height, unsigned int mask);

private:
	bool						m_mapped;
	UUS_MapTableDataSource *	m_dsrc;
	UTF8StringMap				m_map;
	UTF8String					m_left;
	UTF8String					m_right;
};

class UUS_TreeTable;

@interface UUS_TreeTableDataSource : NSObject
{
	int						m_count;
	const UTF8StringTree *	m_tree;
	UUS_TreeTable *			m_table;
}
-(id)initWithTree:(const UTF8StringTree *)tree withTable:(UUS_TreeTable *)table;
-(id)outlineView:(NSOutlineView *)outlineView child:(int)index ofItem:(id)item;
-(BOOL)outlineView:(NSOutlineView *)outlineView isItemExpandable:(id)item;
-(int)outlineView:(NSOutlineView *)outlineView numberOfChildrenOfItem:(id)item;
-(id)outlineView:(NSOutlineView *)outlineView objectValueForTableColumn:(NSTableColumn *)tableColumn byItem:(id)item;
-(BOOL)outlineView:(NSOutlineView *)outlineView shouldEditTableColumn:(NSTableColumn *)tableColumn item:(id)item;
-(void)outlineViewSelectionDidChange:(NSNotification *)notification;
-(id)retain;
-(oneway void)release;
@end

class UUS_TreeTable : public UUS_Table
{
public:
	UUS_TreeTable (const UTF8String & table_name);

	~UUS_TreeTable ();

	void clear (); // disassociate current tree

	bool setTree (const UTF8StringTree * tree);
private:
	bool _tree ();
public:
	const UTF8StringTree * tree () const { return m_tree; }

	bool attach (NSView * parent, int x, int y, unsigned int width, unsigned int height, unsigned int mask);

	void setClickBack (TableClick * click_back) { m_target = click_back; }

private:
	UUS_TreeTableDataSource *		m_dsrc;
	const UTF8StringTree *			m_tree;
public:
	const UTF8StringTree::Node *	m_node;
private:
	UTF8String						m_left;
	UTF8String						m_right;
};

#endif /* ! UTF8_UCS4_STRING__UUS_TABLE_H */
