/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* UTF8-UCS4-String/app/cocoa/UUS_TreeView.mm
 * 
 * Copyright (C) 2002 Francis James Franklin <fjf@alinameridon.com>
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#import <Cocoa/Cocoa.h>

#include "UUS_TV_App.h"

@interface AppDelegate : NSObject
{
	UUS_TV_App *	m_app;
	BOOL			m_okay;
	BOOL			m_file;
}
- (id)initWithApp:(UUS_TV_App *)app;
- (void)applicationWillFinishLaunching:(NSNotification *)aNotification;
- (BOOL)application:(NSApplication *)theApplication openFile:(NSString *)filename;
- (void)applicationDidFinishLaunching:(NSNotification *)aNotification;
- (NSApplicationTerminateReply)applicationShouldTerminate:(NSApplication *)sender;
- (void)applicationWillTerminate:(NSNotification *)aNotification;
@end

@implementation AppDelegate

- (id)initWithApp:(UUS_TV_App *)app
{
	[super init];
	m_app = app;
	m_okay = NO;
	m_file = NO;
	return self;
}

- (void)applicationWillFinishLaunching:(NSNotification *)aNotification
{
	/* initialize the interface
	 */
	if (m_app)
		if (m_app->interfaceSetup ()) m_okay = YES;
}

- (BOOL)application:(NSApplication *)theApplication openFile:(NSString *)filename
{
	if (m_app == 0) return NO;

	BOOL opened = m_app->open (filename);
	if (opened) m_file = YES;

	return opened ? YES : NO;
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
	/* NOTE: prior to this, NSApplication may have sent an "open this document" notification
	 */
	if (m_okay == YES)
		{
			if (!m_file) m_app->open ();
			m_app->finalSetup ();
		}
}

- (NSApplicationTerminateReply)applicationShouldTerminate:(NSApplication *)sender
{
	return NSTerminateNow; // TODO: NSTerminateLater with modal query?
}

- (void)applicationWillTerminate:(NSNotification *)aNotification
{
	/* clean-up
	 */
	if (m_app)
		{
			m_app->shutdown ();
			m_app = 0;
		}
	m_okay = NO;
}

@end

int main (int /*argc*/, const char ** /*argv*/)
{
	NSAutoreleasePool * pool = [[NSAutoreleasePool alloc] init];

	[NSApplication sharedApplication];

	AppDelegate * uus_tv_app = [AppDelegate alloc];
	if (uus_tv_app)
		{
			UUS_TV_App app;

			[uus_tv_app initWithApp:(&app)];

			[NSApp setDelegate:uus_tv_app];
			[NSApp run];
		}

	[pool release];

	return 0;
}
