# start: UTF8-UCS4-String/ac-helpers/fr-expat.m4
# 
# Copyright (C) 2002 Francis James Franklin
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# The above license applies to THIS FILE ONLY.
#
# Check for optional expat

dnl Usage: FR_EXPAT_OPT(yes|no)

AC_DEFUN([FR_EXPAT_OPT],[

fr_expat_cppflags=""
fr_expat_ldflags=""
fr_expat_prefix=""

if [ test "x$1" = "xyes" ]; then
	fr_expat_opt=check
else
	fr_expat_opt=required
fi

# At this point fr_expat_opt can be "check" or "required"

AC_ARG_WITH(expat,[  --with-expat=DIR        use expat in DIR],[
	if test "x$withval" = "xyes"; then
		fr_expat_opt=specified
	elif test "x$withval" != "xno"; then
		fr_expat_prefix="$withval"
		fr_expat_opt=specified
	else
		if test $fr_expat_opt = required; then
			AC_MSG_ERROR([* * * expat is required * * *])
		fi
		fr_expat_opt=no
	fi
])

# At this point fr_expat_opt can be "check", "required", "specified", or "no"

if test $fr_expat_opt != no; then
	if test "x$fr_expat_prefix" != "x"; then
		_fr_cppflags="$CPPFLAGS"
		_fr_ldflags="$LDFLAGS"
		CPPFLAGS="$CPPFLAGS -I$fr_expat_prefix/include"
		LDFLAGS="$LDFLAGS -L$fr_expat_prefix/lib"
	fi
	AC_CHECK_HEADER(expat.h,[
		AC_CHECK_LIB(expat,XML_ParserFree,[
			fr_expat_opt=yes
			fr_expat_ldflags="-lexpat"
		],[	if test $fr_expat_opt != check; then
				AC_MSG_ERROR([* * * failed to find expat! * * *])
			fi
			fr_expat_opt=no
		],-lm)
	],[	if test $fr_expat_opt != check; then
			AC_MSG_ERROR([* * * failed to find expat! * * *])
		fi
		fr_expat_opt=no
	])
	if test "x$fr_expat_prefix" != "x"; then
		if test $fr_expat_opt = yes; then
			fr_expat_cppflags="-I$fr_expat_prefix/include"
			fr_expat_ldflags="-L$fr_expat_prefix/lib $fr_expat_ldflags"
		fi
		CPPFLAGS="$_fr_cppflags"
		LDFLAGS="$_fr_ldflags"
	fi
fi

# At this point fr_expat_opt can be "yes" or "no"

])
# 
# end: UTF8-UCS4-String/ac-helpers/fr-expat.m4
# 
