# start: UTF8-UCS4-String/ac-helpers/fr-cocoa.m4
# 
# Copyright (C) 2002 Francis James Franklin
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# The above license applies to THIS FILE ONLY.
#
# Check for optional expat

dnl Usage: FR_COCOA_OPT(yes|no)

AC_DEFUN([FR_COCOA_OPT],[

fr_cocoa_cppflags=""
fr_cocoa_ldflags=""
fr_cocoa_prefix=""

if [ test "x$1" = "xyes" ]; then
	fr_cocoa_opt=check
else
	fr_cocoa_opt=required
fi

# At this point fr_cocoa_opt can be "check" or "required"

AC_ARG_ENABLE(cocoa,[  --enable-cocoa          enable use of Cocoa/ObjC++],[
	if test "x$withval" = "xyes"; then
		fr_cocoa_opt=specified
	else
		if test $fr_cocoa_opt = required; then
			AC_MSG_ERROR([* * * Cocoa/ObjC++ is required * * *])
		fi
		fr_cocoa_opt=no
	fi
])

# At this point fr_cocoa_opt can be "check", "required", "specified", or "no"

if test $fr_cocoa_opt != no; then
	AC_LANG_CPLUSPLUS
	_fr_cppflags="$CPPFLAGS"
	_fr_libs="$LIBS"
	CPPFLAGS="$CPPFLAGS -ObjC++"
	LIBS="-framework Cocoa"
	AC_MSG_CHECKING([for Cocoa/ObjC++])
	AC_TRY_LINK([
#include <stdio.h>
#include <Cocoa/Cocoa.h>

class Poppy
{
	NSColor * m_color;
public:
	Poppy (NSColor * color) : m_color(color) { }
	void grow () { fprintf (stderr, "it's Spring!\n"); }
};
	],[
	Poppy seed([NSColor redColor]);
	seed.grow ();
	],[	AC_MSG_RESULT(yes)
		fr_cocoa_opt=yes
	],[	AC_MSG_RESULT(no)
		if test $fr_cocoa_opt = check; then
			fr_cocoa_opt=no
		else
			AC_MSG_ERROR([* * * your system doesn't seem to support Cocoa/ObjC++ * * *])
		fi
	])
	CPPFLAGS="$_fr_cppflags"
	LIBS="$_fr_libs"
	AC_LANG_C
fi

# At this point fr_cocoa_opt can be "yes" or "no"

])
# 
# end: UTF8-UCS4-String/ac-helpers/fr-cocoa.m4
# 
