/* libeXtra/utils/utf8stringpair.h
 *
 * Copyright (C) 2002 Francis James Franklin <fjf@alinameridon.com>
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef LIBEXTRA_UTF8STRINGPAIR_H
#define LIBEXTRA_UTF8STRINGPAIR_H

#include "utf8string.h"

class UTF8StringPair
{
 private:
  UTF8String m_name;
  UTF8String m_value;

 public:
  UTF8StringPair (const UTF8StringPair & rhs);
  UTF8StringPair (const UTF8String & name, const UTF8String & value);
  UTF8StringPair (const char * name, const char * value);

  inline UTF8StringPair & operator= (UTF8StringPair & rhs) // is this necessary?
  {
    m_name  = rhs.m_name;
    m_value = rhs.m_value;
    return *this;
  }

  inline const UTF8String & name () const { return m_name; }
  inline const UTF8String & name (const UTF8String & new_name) { return m_name = new_name; }

  inline const UTF8String & value () const { return m_value; }
  inline const UTF8String & value (const UTF8String & new_value) { return m_value = new_value; }
};

#endif /* ! LIBEXTRA_UTF8STRINGPAIR_H */
