<?php
define( 'BLOGDEFINITION', true ); // this prevents most of WP from being loaded
require_once( dirname( dirname( __FILE__) ) . '/wp-config.php' ); // absolute includes are faster

if ( 
	$current_blog->archived == '1' || 
	$current_blog->spam == '1' ||
	$current_blog->deleted == '1' 
) {
	header("HTTP/1.1 404 Not Found");
	graceful_fail('404 &#8212; File not found.');
}

if ( !function_exists('wp_check_filetype') ) :
function wp_check_filetype($filename, $mimes = null) {
	// Accepted MIME types are set here as PCRE unless provided.
	$mimes = is_array($mimes) ? $mimes : array (
		'jpg|jpeg|jpe' => 'image/jpeg',
		'gif' => 'image/gif',
		'png' => 'image/png',
		'bmp' => 'image/bmp',
		'tif|tiff' => 'image/tiff',
		'ico' => 'image/x-icon',
		'asf|asx|wax|wmv|wmx' => 'video/asf',
		'avi' => 'video/avi',
		'mov|qt' => 'video/quicktime',
		'mpeg|mpg|mpe' => 'video/mpeg',
		'txt|c|cc|h' => 'text/plain',
		'rtx' => 'text/richtext',
		'css' => 'text/css',
		'htm|html' => 'text/html',
		'mp3|mp4' => 'audio/mpeg',
		'ra|ram' => 'audio/x-realaudio',
		'wav' => 'audio/wav',
		'ogg' => 'audio/ogg',
		'mid|midi' => 'audio/midi',
		'wma' => 'audio/wma',
		'rtf' => 'application/rtf',
		'js' => 'application/javascript',
		'pdf' => 'application/pdf',
		'doc' => 'application/msword',
		'pot|pps|ppt' => 'application/vnd.ms-powerpoint',
		'wri' => 'application/vnd.ms-write',
		'xla|xls|xlt|xlw' => 'application/vnd.ms-excel',
		'mdb' => 'application/vnd.ms-access',
		'mpp' => 'application/vnd.ms-project',
		'swf' => 'application/x-shockwave-flash',
		'class' => 'application/java',
		'tar' => 'application/x-tar',
		'zip' => 'application/zip',
		'gz|gzip' => 'application/x-gzip',
		'exe' => 'application/x-msdownload'
	);

	$type = false;
	$ext = false;

	foreach ($mimes as $ext_preg => $mime_match) {
		$ext_preg = '!\.(' . $ext_preg . ')$!i';
		if ( preg_match($ext_preg, $filename, $ext_matches) ) {
			$type = $mime_match;
			$ext = $ext_matches[1];
			break;
		}
	}

	return compact('ext', 'type');
}
endif;


$file = $_GET[ 'file' ];

$file = constant( "ABSPATH" ) . constant( "UPLOADS" ) . $file;
if ( !is_file( $file ) ) {
	header("HTTP/1.1 404 Not Found");
	graceful_fail('404 &#8212; File not found.');
}

// These should never, ever be served
$never = array( 'js', 'exe', 'swf', 'class', 'tar', 'zip', 'rar' );
if ( in_array( preg_replace( '|.*\.(.*)$|', '$1', $file ), $never ) ) {
	header("HTTP/1.1 404 Not Found");
	graceful_fail('404 &#8212; File not found.');
}

$mime = wp_check_filetype( $_SERVER[ 'REQUEST_URI' ] );
if( $mime[ 'type' ] != false ) {
	$mimetype = $mime[ 'type' ];
} else {
	$ext = substr( $_SERVER[ 'REQUEST_URI' ], strrpos( $_SERVER[ 'REQUEST_URI' ], '.' ) + 1 );
	$mimetype = "image/$ext";
}
header( 'Content-type: ' . $mimetype ); // always send this

$timestamp = filemtime( $file );

$last_modified = gmdate('D, d M Y H:i:s', $timestamp);
$etag = '"' . md5($last_modified) . '"';
@header( "Last-Modified: $last_modified GMT" );
@header( 'ETag: ' . $etag );

$expire = gmdate('D, d M Y H:i:s', time() + 100000000);
@header( "Expires: $expire GMT" );

// Support for Conditional GET
if (isset($_SERVER['HTTP_IF_NONE_MATCH'])) $client_etag = stripslashes($_SERVER['HTTP_IF_NONE_MATCH']);
else $client_etag = false;

$client_last_modified = trim( $_SERVER['HTTP_IF_MODIFIED_SINCE']);
// If string is empty, return 0. If not, attempt to parse into a timestamp
$client_modified_timestamp = $client_last_modified ? strtotime($client_last_modified) : 0;

// Make a timestamp for our most recent modification...	
$modified_timestamp = strtotime($last_modified);

if ( ($client_last_modified && $client_etag) ?
	 (($client_modified_timestamp >= $modified_timestamp) && ($client_etag == $etag)) :
	 (($client_modified_timestamp >= $modified_timestamp) || ($client_etag == $etag)) ) {
	header('HTTP/1.1 304 Not Modified');
	exit;
}

// If we made it this far, just serve the file

readfile( $file );

?>
