<?php
/**
 * Title: FAQs
 * Slug: twentytwentyfive/text-faqs
 * Categories: text, about
 * Keywords: faq, about, frequently asked questions
 * Viewport width: 1400
 * Description: A FAQs section with a FAQ heading and list of toggle questions and answers.
 *
 * @package    WordPress
 * @subpackage Twenty_Twenty_Five
 * @since      Twenty Twenty-Five 1.0
 */

?>
<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull">
	<!-- wp:group {"align":"wide","style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"},"blockGap":"var:preset|spacing|50"}},"layout":{"type":"default"}} -->
	<div class="wp-block-group alignwide" style="padding-top:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50)">
		<!-- wp:heading {"fontSize":"x-large"} -->
		<h2 class="wp-block-heading has-x-large-font-size"><?php echo esc_html_x( 'Frequently Asked Questions', 'Heading of the FAQs pattern.', 'twentytwentyfive' ); ?></h2>
		<!-- /wp:heading -->

		<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"default"}} -->
		<div class="wp-block-group">
			<!-- wp:details {"style":{"border":{"bottom":{"color":"var:preset|color|accent-6","width":"1px"}},"spacing":{"padding":{"bottom":"var:preset|spacing|30"}},"typography":{"fontStyle":"normal","fontWeight":"400"}}} -->
			<details class="wp-block-details" style="border-bottom-color:var(--wp--preset--color--accent-6);border-bottom-width:1px;padding-bottom:var(--wp--preset--spacing--30);font-style:normal;font-weight:400">
				<summary><?php echo esc_html_x( 'What is The Stories Book about?', 'Question in the FAQs pattern.', 'twentytwentyfive' ); ?></summary>
				<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"300"}}} -->
				<p style="font-style:normal;font-weight:300"><?php echo esc_html_x( 'This exquisite compilation showcases a diverse array of photographs that capture the essence of different eras and cultures, reflecting the unique styles and perspectives of each artist. Fleckenstein\'s evocative imagery, Strand\'s groundbreaking modernist approach, and Kōno\'s meticulous documentation of Japanese life come together in a harmonious blend that celebrates the art of photography.', 'Answer in the FAQs pattern.', 'twentytwentyfive' ); ?></p>
				<!-- /wp:paragraph -->
			</details>
			<!-- /wp:details -->

			<!-- wp:details {"style":{"border":{"bottom":{"color":"var:preset|color|accent-6","width":"1px"}},"spacing":{"padding":{"bottom":"var:preset|spacing|30"}},"typography":{"fontStyle":"normal","fontWeight":"400"}}} -->
			<details class="wp-block-details" style="border-bottom-color:var(--wp--preset--color--accent-6);border-bottom-width:1px;padding-bottom:var(--wp--preset--spacing--30);font-style:normal;font-weight:400">
				<summary><?php echo esc_html_x( 'How much does The Stories Book cost?', 'Question in the FAQs pattern.', 'twentytwentyfive' ); ?></summary>
				<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"300"}}} -->
				<p style="font-style:normal;font-weight:300"><?php echo esc_html_x( 'This exquisite compilation showcases a diverse array of photographs that capture the essence of different eras and cultures, reflecting the unique styles and perspectives of each artist. Fleckenstein\'s evocative imagery, Strand\'s groundbreaking modernist approach, and Kōno\'s meticulous documentation of Japanese life come together in a harmonious blend that celebrates the art of photography.', 'Answer in the FAQs pattern.', 'twentytwentyfive' ); ?></p>
				<!-- /wp:paragraph -->
			</details>
			<!-- /wp:details -->

			<!-- wp:details {"style":{"border":{"bottom":{"color":"var:preset|color|accent-6","width":"1px"}},"spacing":{"padding":{"bottom":"var:preset|spacing|30"}},"typography":{"fontStyle":"normal","fontWeight":"400"}}} -->
			<details class="wp-block-details" style="border-bottom-color:var(--wp--preset--color--accent-6);border-bottom-width:1px;padding-bottom:var(--wp--preset--spacing--30);font-style:normal;font-weight:400">
				<summary><?php echo esc_html_x( 'When will The Stories Book be released?', 'Question in the FAQs pattern.', 'twentytwentyfive' ); ?></summary>
				<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"300"}}} -->
				<p style="font-style:normal;font-weight:300"><?php echo esc_html_x( 'This exquisite compilation showcases a diverse array of photographs that capture the essence of different eras and cultures, reflecting the unique styles and perspectives of each artist. Fleckenstein\'s evocative imagery, Strand\'s groundbreaking modernist approach, and Kōno\'s meticulous documentation of Japanese life come together in a harmonious blend that celebrates the art of photography.', 'Answer in the FAQs pattern.', 'twentytwentyfive' ); ?></p>
				<!-- /wp:paragraph -->
			</details>
			<!-- /wp:details -->

			<!-- wp:details {"style":{"border":{"bottom":{"color":"var:preset|color|accent-6","width":"1px"}},"spacing":{"padding":{"bottom":"var:preset|spacing|30"}},"typography":{"fontStyle":"normal","fontWeight":"400"}}} -->
			<details class="wp-block-details" style="border-bottom-color:var(--wp--preset--color--accent-6);border-bottom-width:1px;padding-bottom:var(--wp--preset--spacing--30);font-style:normal;font-weight:400">
				<summary><?php echo esc_html_x( 'Are signed copies available?', 'Question in the FAQs pattern.', 'twentytwentyfive' ); ?></summary>
				<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"300"}}} -->
				<p style="font-style:normal;font-weight:300"><?php echo esc_html_x( 'This exquisite compilation showcases a diverse array of photographs that capture the essence of different eras and cultures, reflecting the unique styles and perspectives of each artist. Fleckenstein\'s evocative imagery, Strand\'s groundbreaking modernist approach, and Kōno\'s meticulous documentation of Japanese life come together in a harmonious blend that celebrates the art of photography.', 'Answer in the FAQs pattern.', 'twentytwentyfive' ); ?></p>
				<!-- /wp:paragraph -->
			</details>
			<!-- /wp:details -->

			<!-- wp:details {"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}}} -->
			<details class="wp-block-details" style="font-style:normal;font-weight:400">
				<summary><?php echo esc_html_x( 'Will The Stories Book be available in other languages other that English?', 'Question in the FAQs pattern', 'twentytwentyfive' ); ?></summary>
				<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"300"}}} -->
				<p style="font-style:normal;font-weight:300"><?php echo esc_html_x( 'This exquisite compilation showcases a diverse array of photographs that capture the essence of different eras and cultures, reflecting the unique styles and perspectives of each artist. Fleckenstein\'s evocative imagery, Strand\'s groundbreaking modernist approach, and Kōno\'s meticulous documentation of Japanese life come together in a harmonious blend that celebrates the art of photography.', 'Answer in the FAQs pattern.', 'twentytwentyfive' ); ?></p>
				<!-- /wp:paragraph -->
			</details>
			<!-- /wp:details -->
		</div>
		<!-- /wp:group -->
	</div>
	<!-- /wp:group -->
</div>
<!-- /wp:group -->
