/******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 480:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var callBound = __webpack_require__(5304);
var $byteLength = callBound('ArrayBuffer.prototype.byteLength', true);

var isArrayBuffer = __webpack_require__(4602);

/** @type {import('.')} */
module.exports = function byteLength(ab) {
	if (!isArrayBuffer(ab)) {
		return NaN;
	}
	return $byteLength ? $byteLength(ab) : ab.byteLength;
}; // in node < 0.11, byteLength is an own nonconfigurable property


/***/ }),

/***/ 5304:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(3803);

var callBind = __webpack_require__(6427);

var $indexOf = callBind(GetIntrinsic('String.prototype.indexOf'));

module.exports = function callBoundIntrinsic(name, allowMissing) {
	var intrinsic = GetIntrinsic(name, !!allowMissing);
	if (typeof intrinsic === 'function' && $indexOf(name, '.prototype.') > -1) {
		return callBind(intrinsic);
	}
	return intrinsic;
};


/***/ }),

/***/ 6427:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var bind = __webpack_require__(7870);
var GetIntrinsic = __webpack_require__(3803);
var setFunctionLength = __webpack_require__(4521);

var $TypeError = __webpack_require__(1642);
var $apply = GetIntrinsic('%Function.prototype.apply%');
var $call = GetIntrinsic('%Function.prototype.call%');
var $reflectApply = GetIntrinsic('%Reflect.apply%', true) || bind.call($call, $apply);

var $defineProperty = __webpack_require__(8918);
var $max = GetIntrinsic('%Math.max%');

module.exports = function callBind(originalFunction) {
	if (typeof originalFunction !== 'function') {
		throw new $TypeError('a function is required');
	}
	var func = $reflectApply(bind, $call, arguments);
	return setFunctionLength(
		func,
		1 + $max(0, originalFunction.length - (arguments.length - 1)),
		true
	);
};

var applyBind = function applyBind() {
	return $reflectApply(bind, $apply, arguments);
};

if ($defineProperty) {
	$defineProperty(module.exports, 'apply', { value: applyBind });
} else {
	module.exports.apply = applyBind;
}


/***/ }),

/***/ 3303:
/***/ (function(module) {

"use strict";


/* eslint no-invalid-this: 1 */

var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
var toStr = Object.prototype.toString;
var max = Math.max;
var funcType = '[object Function]';

var concatty = function concatty(a, b) {
    var arr = [];

    for (var i = 0; i < a.length; i += 1) {
        arr[i] = a[i];
    }
    for (var j = 0; j < b.length; j += 1) {
        arr[j + a.length] = b[j];
    }

    return arr;
};

var slicy = function slicy(arrLike, offset) {
    var arr = [];
    for (var i = offset || 0, j = 0; i < arrLike.length; i += 1, j += 1) {
        arr[j] = arrLike[i];
    }
    return arr;
};

var joiny = function (arr, joiner) {
    var str = '';
    for (var i = 0; i < arr.length; i += 1) {
        str += arr[i];
        if (i + 1 < arr.length) {
            str += joiner;
        }
    }
    return str;
};

module.exports = function bind(that) {
    var target = this;
    if (typeof target !== 'function' || toStr.apply(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
    }
    var args = slicy(arguments, 1);

    var bound;
    var binder = function () {
        if (this instanceof bound) {
            var result = target.apply(
                this,
                concatty(args, arguments)
            );
            if (Object(result) === result) {
                return result;
            }
            return this;
        }
        return target.apply(
            that,
            concatty(args, arguments)
        );

    };

    var boundLength = max(0, target.length - args.length);
    var boundArgs = [];
    for (var i = 0; i < boundLength; i++) {
        boundArgs[i] = '$' + i;
    }

    bound = Function('binder', 'return function (' + joiny(boundArgs, ',') + '){ return binder.apply(this,arguments); }')(binder);

    if (target.prototype) {
        var Empty = function Empty() {};
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
    }

    return bound;
};


/***/ }),

/***/ 7870:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var implementation = __webpack_require__(3303);

module.exports = Function.prototype.bind || implementation;


/***/ }),

/***/ 3803:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var undefined;

var $Error = __webpack_require__(6716);
var $EvalError = __webpack_require__(6788);
var $RangeError = __webpack_require__(9204);
var $ReferenceError = __webpack_require__(9908);
var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);
var $URIError = __webpack_require__(1451);

var $Function = Function;

// eslint-disable-next-line consistent-return
var getEvalledConstructor = function (expressionSyntax) {
	try {
		return $Function('"use strict"; return (' + expressionSyntax + ').constructor;')();
	} catch (e) {}
};

var $gOPD = Object.getOwnPropertyDescriptor;
if ($gOPD) {
	try {
		$gOPD({}, '');
	} catch (e) {
		$gOPD = null; // this is IE 8, which has a broken gOPD
	}
}

var throwTypeError = function () {
	throw new $TypeError();
};
var ThrowTypeError = $gOPD
	? (function () {
		try {
			// eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
			arguments.callee; // IE 8 does not throw here
			return throwTypeError;
		} catch (calleeThrows) {
			try {
				// IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
				return $gOPD(arguments, 'callee').get;
			} catch (gOPDthrows) {
				return throwTypeError;
			}
		}
	}())
	: throwTypeError;

var hasSymbols = __webpack_require__(8040)();
var hasProto = __webpack_require__(1856)();

var getProto = Object.getPrototypeOf || (
	hasProto
		? function (x) { return x.__proto__; } // eslint-disable-line no-proto
		: null
);

var needsEval = {};

var TypedArray = typeof Uint8Array === 'undefined' || !getProto ? undefined : getProto(Uint8Array);

var INTRINSICS = {
	__proto__: null,
	'%AggregateError%': typeof AggregateError === 'undefined' ? undefined : AggregateError,
	'%Array%': Array,
	'%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined : ArrayBuffer,
	'%ArrayIteratorPrototype%': hasSymbols && getProto ? getProto([][Symbol.iterator]()) : undefined,
	'%AsyncFromSyncIteratorPrototype%': undefined,
	'%AsyncFunction%': needsEval,
	'%AsyncGenerator%': needsEval,
	'%AsyncGeneratorFunction%': needsEval,
	'%AsyncIteratorPrototype%': needsEval,
	'%Atomics%': typeof Atomics === 'undefined' ? undefined : Atomics,
	'%BigInt%': typeof BigInt === 'undefined' ? undefined : BigInt,
	'%BigInt64Array%': typeof BigInt64Array === 'undefined' ? undefined : BigInt64Array,
	'%BigUint64Array%': typeof BigUint64Array === 'undefined' ? undefined : BigUint64Array,
	'%Boolean%': Boolean,
	'%DataView%': typeof DataView === 'undefined' ? undefined : DataView,
	'%Date%': Date,
	'%decodeURI%': decodeURI,
	'%decodeURIComponent%': decodeURIComponent,
	'%encodeURI%': encodeURI,
	'%encodeURIComponent%': encodeURIComponent,
	'%Error%': $Error,
	'%eval%': eval, // eslint-disable-line no-eval
	'%EvalError%': $EvalError,
	'%Float32Array%': typeof Float32Array === 'undefined' ? undefined : Float32Array,
	'%Float64Array%': typeof Float64Array === 'undefined' ? undefined : Float64Array,
	'%FinalizationRegistry%': typeof FinalizationRegistry === 'undefined' ? undefined : FinalizationRegistry,
	'%Function%': $Function,
	'%GeneratorFunction%': needsEval,
	'%Int8Array%': typeof Int8Array === 'undefined' ? undefined : Int8Array,
	'%Int16Array%': typeof Int16Array === 'undefined' ? undefined : Int16Array,
	'%Int32Array%': typeof Int32Array === 'undefined' ? undefined : Int32Array,
	'%isFinite%': isFinite,
	'%isNaN%': isNaN,
	'%IteratorPrototype%': hasSymbols && getProto ? getProto(getProto([][Symbol.iterator]())) : undefined,
	'%JSON%': typeof JSON === 'object' ? JSON : undefined,
	'%Map%': typeof Map === 'undefined' ? undefined : Map,
	'%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Map()[Symbol.iterator]()),
	'%Math%': Math,
	'%Number%': Number,
	'%Object%': Object,
	'%parseFloat%': parseFloat,
	'%parseInt%': parseInt,
	'%Promise%': typeof Promise === 'undefined' ? undefined : Promise,
	'%Proxy%': typeof Proxy === 'undefined' ? undefined : Proxy,
	'%RangeError%': $RangeError,
	'%ReferenceError%': $ReferenceError,
	'%Reflect%': typeof Reflect === 'undefined' ? undefined : Reflect,
	'%RegExp%': RegExp,
	'%Set%': typeof Set === 'undefined' ? undefined : Set,
	'%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Set()[Symbol.iterator]()),
	'%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined : SharedArrayBuffer,
	'%String%': String,
	'%StringIteratorPrototype%': hasSymbols && getProto ? getProto(''[Symbol.iterator]()) : undefined,
	'%Symbol%': hasSymbols ? Symbol : undefined,
	'%SyntaxError%': $SyntaxError,
	'%ThrowTypeError%': ThrowTypeError,
	'%TypedArray%': TypedArray,
	'%TypeError%': $TypeError,
	'%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined : Uint8Array,
	'%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined : Uint8ClampedArray,
	'%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined : Uint16Array,
	'%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined : Uint32Array,
	'%URIError%': $URIError,
	'%WeakMap%': typeof WeakMap === 'undefined' ? undefined : WeakMap,
	'%WeakRef%': typeof WeakRef === 'undefined' ? undefined : WeakRef,
	'%WeakSet%': typeof WeakSet === 'undefined' ? undefined : WeakSet
};

if (getProto) {
	try {
		null.error; // eslint-disable-line no-unused-expressions
	} catch (e) {
		// https://github.com/tc39/proposal-shadowrealm/pull/384#issuecomment-1364264229
		var errorProto = getProto(getProto(e));
		INTRINSICS['%Error.prototype%'] = errorProto;
	}
}

var doEval = function doEval(name) {
	var value;
	if (name === '%AsyncFunction%') {
		value = getEvalledConstructor('async function () {}');
	} else if (name === '%GeneratorFunction%') {
		value = getEvalledConstructor('function* () {}');
	} else if (name === '%AsyncGeneratorFunction%') {
		value = getEvalledConstructor('async function* () {}');
	} else if (name === '%AsyncGenerator%') {
		var fn = doEval('%AsyncGeneratorFunction%');
		if (fn) {
			value = fn.prototype;
		}
	} else if (name === '%AsyncIteratorPrototype%') {
		var gen = doEval('%AsyncGenerator%');
		if (gen && getProto) {
			value = getProto(gen.prototype);
		}
	}

	INTRINSICS[name] = value;

	return value;
};

var LEGACY_ALIASES = {
	__proto__: null,
	'%ArrayBufferPrototype%': ['ArrayBuffer', 'prototype'],
	'%ArrayPrototype%': ['Array', 'prototype'],
	'%ArrayProto_entries%': ['Array', 'prototype', 'entries'],
	'%ArrayProto_forEach%': ['Array', 'prototype', 'forEach'],
	'%ArrayProto_keys%': ['Array', 'prototype', 'keys'],
	'%ArrayProto_values%': ['Array', 'prototype', 'values'],
	'%AsyncFunctionPrototype%': ['AsyncFunction', 'prototype'],
	'%AsyncGenerator%': ['AsyncGeneratorFunction', 'prototype'],
	'%AsyncGeneratorPrototype%': ['AsyncGeneratorFunction', 'prototype', 'prototype'],
	'%BooleanPrototype%': ['Boolean', 'prototype'],
	'%DataViewPrototype%': ['DataView', 'prototype'],
	'%DatePrototype%': ['Date', 'prototype'],
	'%ErrorPrototype%': ['Error', 'prototype'],
	'%EvalErrorPrototype%': ['EvalError', 'prototype'],
	'%Float32ArrayPrototype%': ['Float32Array', 'prototype'],
	'%Float64ArrayPrototype%': ['Float64Array', 'prototype'],
	'%FunctionPrototype%': ['Function', 'prototype'],
	'%Generator%': ['GeneratorFunction', 'prototype'],
	'%GeneratorPrototype%': ['GeneratorFunction', 'prototype', 'prototype'],
	'%Int8ArrayPrototype%': ['Int8Array', 'prototype'],
	'%Int16ArrayPrototype%': ['Int16Array', 'prototype'],
	'%Int32ArrayPrototype%': ['Int32Array', 'prototype'],
	'%JSONParse%': ['JSON', 'parse'],
	'%JSONStringify%': ['JSON', 'stringify'],
	'%MapPrototype%': ['Map', 'prototype'],
	'%NumberPrototype%': ['Number', 'prototype'],
	'%ObjectPrototype%': ['Object', 'prototype'],
	'%ObjProto_toString%': ['Object', 'prototype', 'toString'],
	'%ObjProto_valueOf%': ['Object', 'prototype', 'valueOf'],
	'%PromisePrototype%': ['Promise', 'prototype'],
	'%PromiseProto_then%': ['Promise', 'prototype', 'then'],
	'%Promise_all%': ['Promise', 'all'],
	'%Promise_reject%': ['Promise', 'reject'],
	'%Promise_resolve%': ['Promise', 'resolve'],
	'%RangeErrorPrototype%': ['RangeError', 'prototype'],
	'%ReferenceErrorPrototype%': ['ReferenceError', 'prototype'],
	'%RegExpPrototype%': ['RegExp', 'prototype'],
	'%SetPrototype%': ['Set', 'prototype'],
	'%SharedArrayBufferPrototype%': ['SharedArrayBuffer', 'prototype'],
	'%StringPrototype%': ['String', 'prototype'],
	'%SymbolPrototype%': ['Symbol', 'prototype'],
	'%SyntaxErrorPrototype%': ['SyntaxError', 'prototype'],
	'%TypedArrayPrototype%': ['TypedArray', 'prototype'],
	'%TypeErrorPrototype%': ['TypeError', 'prototype'],
	'%Uint8ArrayPrototype%': ['Uint8Array', 'prototype'],
	'%Uint8ClampedArrayPrototype%': ['Uint8ClampedArray', 'prototype'],
	'%Uint16ArrayPrototype%': ['Uint16Array', 'prototype'],
	'%Uint32ArrayPrototype%': ['Uint32Array', 'prototype'],
	'%URIErrorPrototype%': ['URIError', 'prototype'],
	'%WeakMapPrototype%': ['WeakMap', 'prototype'],
	'%WeakSetPrototype%': ['WeakSet', 'prototype']
};

var bind = __webpack_require__(7870);
var hasOwn = __webpack_require__(9429);
var $concat = bind.call(Function.call, Array.prototype.concat);
var $spliceApply = bind.call(Function.apply, Array.prototype.splice);
var $replace = bind.call(Function.call, String.prototype.replace);
var $strSlice = bind.call(Function.call, String.prototype.slice);
var $exec = bind.call(Function.call, RegExp.prototype.exec);

/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */
var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
var reEscapeChar = /\\(\\)?/g; /** Used to match backslashes in property paths. */
var stringToPath = function stringToPath(string) {
	var first = $strSlice(string, 0, 1);
	var last = $strSlice(string, -1);
	if (first === '%' && last !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected closing `%`');
	} else if (last === '%' && first !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected opening `%`');
	}
	var result = [];
	$replace(string, rePropName, function (match, number, quote, subString) {
		result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
	});
	return result;
};
/* end adaptation */

var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
	var intrinsicName = name;
	var alias;
	if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
		alias = LEGACY_ALIASES[intrinsicName];
		intrinsicName = '%' + alias[0] + '%';
	}

	if (hasOwn(INTRINSICS, intrinsicName)) {
		var value = INTRINSICS[intrinsicName];
		if (value === needsEval) {
			value = doEval(intrinsicName);
		}
		if (typeof value === 'undefined' && !allowMissing) {
			throw new $TypeError('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
		}

		return {
			alias: alias,
			name: intrinsicName,
			value: value
		};
	}

	throw new $SyntaxError('intrinsic ' + name + ' does not exist!');
};

module.exports = function GetIntrinsic(name, allowMissing) {
	if (typeof name !== 'string' || name.length === 0) {
		throw new $TypeError('intrinsic name must be a non-empty string');
	}
	if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
		throw new $TypeError('"allowMissing" argument must be a boolean');
	}

	if ($exec(/^%?[^%]*%?$/, name) === null) {
		throw new $SyntaxError('`%` may not be present anywhere but at the beginning and end of the intrinsic name');
	}
	var parts = stringToPath(name);
	var intrinsicBaseName = parts.length > 0 ? parts[0] : '';

	var intrinsic = getBaseIntrinsic('%' + intrinsicBaseName + '%', allowMissing);
	var intrinsicRealName = intrinsic.name;
	var value = intrinsic.value;
	var skipFurtherCaching = false;

	var alias = intrinsic.alias;
	if (alias) {
		intrinsicBaseName = alias[0];
		$spliceApply(parts, $concat([0, 1], alias));
	}

	for (var i = 1, isOwn = true; i < parts.length; i += 1) {
		var part = parts[i];
		var first = $strSlice(part, 0, 1);
		var last = $strSlice(part, -1);
		if (
			(
				(first === '"' || first === "'" || first === '`')
				|| (last === '"' || last === "'" || last === '`')
			)
			&& first !== last
		) {
			throw new $SyntaxError('property names with quotes must have matching quotes');
		}
		if (part === 'constructor' || !isOwn) {
			skipFurtherCaching = true;
		}

		intrinsicBaseName += '.' + part;
		intrinsicRealName = '%' + intrinsicBaseName + '%';

		if (hasOwn(INTRINSICS, intrinsicRealName)) {
			value = INTRINSICS[intrinsicRealName];
		} else if (value != null) {
			if (!(part in value)) {
				if (!allowMissing) {
					throw new $TypeError('base intrinsic for ' + name + ' exists, but the property is not available.');
				}
				return void undefined;
			}
			if ($gOPD && (i + 1) >= parts.length) {
				var desc = $gOPD(value, part);
				isOwn = !!desc;

				// By convention, when a data property is converted to an accessor
				// property to emulate a data property that does not suffer from
				// the override mistake, that accessor's getter is marked with
				// an `originalValue` property. Here, when we detect this, we
				// uphold the illusion by pretending to see that original data
				// property, i.e., returning the value rather than the getter
				// itself.
				if (isOwn && 'get' in desc && !('originalValue' in desc.get)) {
					value = desc.get;
				} else {
					value = value[part];
				}
			} else {
				isOwn = hasOwn(value, part);
				value = value[part];
			}

			if (isOwn && !skipFurtherCaching) {
				INTRINSICS[intrinsicRealName] = value;
			}
		}
	}
	return value;
};


/***/ }),

/***/ 8040:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var origSymbol = typeof Symbol !== 'undefined' && Symbol;
var hasSymbolSham = __webpack_require__(9063);

module.exports = function hasNativeSymbols() {
	if (typeof origSymbol !== 'function') { return false; }
	if (typeof Symbol !== 'function') { return false; }
	if (typeof origSymbol('foo') !== 'symbol') { return false; }
	if (typeof Symbol('bar') !== 'symbol') { return false; }

	return hasSymbolSham();
};


/***/ }),

/***/ 9063:
/***/ (function(module) {

"use strict";


/* eslint complexity: [2, 18], max-statements: [2, 33] */
module.exports = function hasSymbols() {
	if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
	if (typeof Symbol.iterator === 'symbol') { return true; }

	var obj = {};
	var sym = Symbol('test');
	var symObj = Object(sym);
	if (typeof sym === 'string') { return false; }

	if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
	if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

	// temp disabled per https://github.com/ljharb/object.assign/issues/17
	// if (sym instanceof Symbol) { return false; }
	// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
	// if (!(symObj instanceof Symbol)) { return false; }

	// if (typeof Symbol.prototype.toString !== 'function') { return false; }
	// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

	var symVal = 42;
	obj[sym] = symVal;
	for (sym in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
	if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

	if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

	var syms = Object.getOwnPropertySymbols(obj);
	if (syms.length !== 1 || syms[0] !== sym) { return false; }

	if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

	if (typeof Object.getOwnPropertyDescriptor === 'function') {
		var descriptor = Object.getOwnPropertyDescriptor(obj, sym);
		if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
	}

	return true;
};


/***/ }),

/***/ 6411:
/***/ (function(module, exports) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
	autosize 4.0.4
	license: MIT
	http://www.jacklmoore.com/autosize
*/
(function (global, factory) {
	if (true) {
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else { var mod; }
})(this, function (module, exports) {
	'use strict';

	var map = typeof Map === "function" ? new Map() : function () {
		var keys = [];
		var values = [];

		return {
			has: function has(key) {
				return keys.indexOf(key) > -1;
			},
			get: function get(key) {
				return values[keys.indexOf(key)];
			},
			set: function set(key, value) {
				if (keys.indexOf(key) === -1) {
					keys.push(key);
					values.push(value);
				}
			},
			delete: function _delete(key) {
				var index = keys.indexOf(key);
				if (index > -1) {
					keys.splice(index, 1);
					values.splice(index, 1);
				}
			}
		};
	}();

	var createEvent = function createEvent(name) {
		return new Event(name, { bubbles: true });
	};
	try {
		new Event('test');
	} catch (e) {
		// IE does not support `new Event()`
		createEvent = function createEvent(name) {
			var evt = document.createEvent('Event');
			evt.initEvent(name, true, false);
			return evt;
		};
	}

	function assign(ta) {
		if (!ta || !ta.nodeName || ta.nodeName !== 'TEXTAREA' || map.has(ta)) return;

		var heightOffset = null;
		var clientWidth = null;
		var cachedHeight = null;

		function init() {
			var style = window.getComputedStyle(ta, null);

			if (style.resize === 'vertical') {
				ta.style.resize = 'none';
			} else if (style.resize === 'both') {
				ta.style.resize = 'horizontal';
			}

			if (style.boxSizing === 'content-box') {
				heightOffset = -(parseFloat(style.paddingTop) + parseFloat(style.paddingBottom));
			} else {
				heightOffset = parseFloat(style.borderTopWidth) + parseFloat(style.borderBottomWidth);
			}
			// Fix when a textarea is not on document body and heightOffset is Not a Number
			if (isNaN(heightOffset)) {
				heightOffset = 0;
			}

			update();
		}

		function changeOverflow(value) {
			{
				// Chrome/Safari-specific fix:
				// When the textarea y-overflow is hidden, Chrome/Safari do not reflow the text to account for the space
				// made available by removing the scrollbar. The following forces the necessary text reflow.
				var width = ta.style.width;
				ta.style.width = '0px';
				// Force reflow:
				/* jshint ignore:start */
				ta.offsetWidth;
				/* jshint ignore:end */
				ta.style.width = width;
			}

			ta.style.overflowY = value;
		}

		function getParentOverflows(el) {
			var arr = [];

			while (el && el.parentNode && el.parentNode instanceof Element) {
				if (el.parentNode.scrollTop) {
					arr.push({
						node: el.parentNode,
						scrollTop: el.parentNode.scrollTop
					});
				}
				el = el.parentNode;
			}

			return arr;
		}

		function resize() {
			if (ta.scrollHeight === 0) {
				// If the scrollHeight is 0, then the element probably has display:none or is detached from the DOM.
				return;
			}

			var overflows = getParentOverflows(ta);
			var docTop = document.documentElement && document.documentElement.scrollTop; // Needed for Mobile IE (ticket #240)

			ta.style.height = '';
			ta.style.height = ta.scrollHeight + heightOffset + 'px';

			// used to check if an update is actually necessary on window.resize
			clientWidth = ta.clientWidth;

			// prevents scroll-position jumping
			overflows.forEach(function (el) {
				el.node.scrollTop = el.scrollTop;
			});

			if (docTop) {
				document.documentElement.scrollTop = docTop;
			}
		}

		function update() {
			resize();

			var styleHeight = Math.round(parseFloat(ta.style.height));
			var computed = window.getComputedStyle(ta, null);

			// Using offsetHeight as a replacement for computed.height in IE, because IE does not account use of border-box
			var actualHeight = computed.boxSizing === 'content-box' ? Math.round(parseFloat(computed.height)) : ta.offsetHeight;

			// The actual height not matching the style height (set via the resize method) indicates that 
			// the max-height has been exceeded, in which case the overflow should be allowed.
			if (actualHeight < styleHeight) {
				if (computed.overflowY === 'hidden') {
					changeOverflow('scroll');
					resize();
					actualHeight = computed.boxSizing === 'content-box' ? Math.round(parseFloat(window.getComputedStyle(ta, null).height)) : ta.offsetHeight;
				}
			} else {
				// Normally keep overflow set to hidden, to avoid flash of scrollbar as the textarea expands.
				if (computed.overflowY !== 'hidden') {
					changeOverflow('hidden');
					resize();
					actualHeight = computed.boxSizing === 'content-box' ? Math.round(parseFloat(window.getComputedStyle(ta, null).height)) : ta.offsetHeight;
				}
			}

			if (cachedHeight !== actualHeight) {
				cachedHeight = actualHeight;
				var evt = createEvent('autosize:resized');
				try {
					ta.dispatchEvent(evt);
				} catch (err) {
					// Firefox will throw an error on dispatchEvent for a detached element
					// https://bugzilla.mozilla.org/show_bug.cgi?id=889376
				}
			}
		}

		var pageResize = function pageResize() {
			if (ta.clientWidth !== clientWidth) {
				update();
			}
		};

		var destroy = function (style) {
			window.removeEventListener('resize', pageResize, false);
			ta.removeEventListener('input', update, false);
			ta.removeEventListener('keyup', update, false);
			ta.removeEventListener('autosize:destroy', destroy, false);
			ta.removeEventListener('autosize:update', update, false);

			Object.keys(style).forEach(function (key) {
				ta.style[key] = style[key];
			});

			map.delete(ta);
		}.bind(ta, {
			height: ta.style.height,
			resize: ta.style.resize,
			overflowY: ta.style.overflowY,
			overflowX: ta.style.overflowX,
			wordWrap: ta.style.wordWrap
		});

		ta.addEventListener('autosize:destroy', destroy, false);

		// IE9 does not fire onpropertychange or oninput for deletions,
		// so binding to onkeyup to catch most of those events.
		// There is no way that I know of to detect something like 'cut' in IE9.
		if ('onpropertychange' in ta && 'oninput' in ta) {
			ta.addEventListener('keyup', update, false);
		}

		window.addEventListener('resize', pageResize, false);
		ta.addEventListener('input', update, false);
		ta.addEventListener('autosize:update', update, false);
		ta.style.overflowX = 'hidden';
		ta.style.wordWrap = 'break-word';

		map.set(ta, {
			destroy: destroy,
			update: update
		});

		init();
	}

	function destroy(ta) {
		var methods = map.get(ta);
		if (methods) {
			methods.destroy();
		}
	}

	function update(ta) {
		var methods = map.get(ta);
		if (methods) {
			methods.update();
		}
	}

	var autosize = null;

	// Do nothing in Node.js environment and IE8 (or lower)
	if (typeof window === 'undefined' || typeof window.getComputedStyle !== 'function') {
		autosize = function autosize(el) {
			return el;
		};
		autosize.destroy = function (el) {
			return el;
		};
		autosize.update = function (el) {
			return el;
		};
	} else {
		autosize = function autosize(el, options) {
			if (el) {
				Array.prototype.forEach.call(el.length ? el : [el], function (x) {
					return assign(x, options);
				});
			}
			return el;
		};
		autosize.destroy = function (el) {
			if (el) {
				Array.prototype.forEach.call(el.length ? el : [el], destroy);
			}
			return el;
		};
		autosize.update = function (el) {
			if (el) {
				Array.prototype.forEach.call(el.length ? el : [el], update);
			}
			return el;
		};
	}

	exports.default = autosize;
	module.exports = exports['default'];
});

/***/ }),

/***/ 4827:
/***/ (function(module) {

// This code has been refactored for 140 bytes
// You can see the original here: https://github.com/twolfson/computedStyle/blob/04cd1da2e30fa45844f95f5cb1ac898e9b9ef050/lib/computedStyle.js
var computedStyle = function (el, prop, getComputedStyle) {
  getComputedStyle = window.getComputedStyle;

  // In one fell swoop
  return (
    // If we have getComputedStyle
    getComputedStyle ?
      // Query it
      // TODO: From CSS-Query notes, we might need (node, null) for FF
      getComputedStyle(el) :

    // Otherwise, we are in IE and use currentStyle
      el.currentStyle
  )[
    // Switch to camelCase for CSSOM
    // DEV: Grabbed from jQuery
    // https://github.com/jquery/jquery/blob/1.9-stable/src/css.js#L191-L194
    // https://github.com/jquery/jquery/blob/1.9-stable/src/core.js#L593-L597
    prop.replace(/-(\w)/gi, function (word, letter) {
      return letter.toUpperCase();
    })
  ];
};

module.exports = computedStyle;


/***/ }),

/***/ 2656:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $defineProperty = __webpack_require__(8918);

var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);

var gopd = __webpack_require__(3828);

/** @type {import('.')} */
module.exports = function defineDataProperty(
	obj,
	property,
	value
) {
	if (!obj || (typeof obj !== 'object' && typeof obj !== 'function')) {
		throw new $TypeError('`obj` must be an object or a function`');
	}
	if (typeof property !== 'string' && typeof property !== 'symbol') {
		throw new $TypeError('`property` must be a string or a symbol`');
	}
	if (arguments.length > 3 && typeof arguments[3] !== 'boolean' && arguments[3] !== null) {
		throw new $TypeError('`nonEnumerable`, if provided, must be a boolean or null');
	}
	if (arguments.length > 4 && typeof arguments[4] !== 'boolean' && arguments[4] !== null) {
		throw new $TypeError('`nonWritable`, if provided, must be a boolean or null');
	}
	if (arguments.length > 5 && typeof arguments[5] !== 'boolean' && arguments[5] !== null) {
		throw new $TypeError('`nonConfigurable`, if provided, must be a boolean or null');
	}
	if (arguments.length > 6 && typeof arguments[6] !== 'boolean') {
		throw new $TypeError('`loose`, if provided, must be a boolean');
	}

	var nonEnumerable = arguments.length > 3 ? arguments[3] : null;
	var nonWritable = arguments.length > 4 ? arguments[4] : null;
	var nonConfigurable = arguments.length > 5 ? arguments[5] : null;
	var loose = arguments.length > 6 ? arguments[6] : false;

	/* @type {false | TypedPropertyDescriptor<unknown>} */
	var desc = !!gopd && gopd(obj, property);

	if ($defineProperty) {
		$defineProperty(obj, property, {
			configurable: nonConfigurable === null && desc ? desc.configurable : !nonConfigurable,
			enumerable: nonEnumerable === null && desc ? desc.enumerable : !nonEnumerable,
			value: value,
			writable: nonWritable === null && desc ? desc.writable : !nonWritable
		});
	} else if (loose || (!nonEnumerable && !nonWritable && !nonConfigurable)) {
		// must fall back to [[Set]], and was not explicitly asked to make non-enumerable, non-writable, or non-configurable
		obj[property] = value; // eslint-disable-line no-param-reassign
	} else {
		throw new $SyntaxError('This environment does not support defining a property as non-configurable, non-writable, or non-enumerable.');
	}
};


/***/ }),

/***/ 1198:
/***/ (function(__unused_webpack_module, exports) {

"use strict";
/*istanbul ignore start*/


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = Diff;

/*istanbul ignore end*/
function Diff() {}

Diff.prototype = {
  /*istanbul ignore start*/

  /*istanbul ignore end*/
  diff: function diff(oldString, newString) {
    /*istanbul ignore start*/
    var
    /*istanbul ignore end*/
    options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var callback = options.callback;

    if (typeof options === 'function') {
      callback = options;
      options = {};
    }

    this.options = options;
    var self = this;

    function done(value) {
      if (callback) {
        setTimeout(function () {
          callback(undefined, value);
        }, 0);
        return true;
      } else {
        return value;
      }
    } // Allow subclasses to massage the input prior to running


    oldString = this.castInput(oldString);
    newString = this.castInput(newString);
    oldString = this.removeEmpty(this.tokenize(oldString));
    newString = this.removeEmpty(this.tokenize(newString));
    var newLen = newString.length,
        oldLen = oldString.length;
    var editLength = 1;
    var maxEditLength = newLen + oldLen;
    var bestPath = [{
      newPos: -1,
      components: []
    }]; // Seed editLength = 0, i.e. the content starts with the same values

    var oldPos = this.extractCommon(bestPath[0], newString, oldString, 0);

    if (bestPath[0].newPos + 1 >= newLen && oldPos + 1 >= oldLen) {
      // Identity per the equality and tokenizer
      return done([{
        value: this.join(newString),
        count: newString.length
      }]);
    } // Main worker method. checks all permutations of a given edit length for acceptance.


    function execEditLength() {
      for (var diagonalPath = -1 * editLength; diagonalPath <= editLength; diagonalPath += 2) {
        var basePath =
        /*istanbul ignore start*/
        void 0
        /*istanbul ignore end*/
        ;

        var addPath = bestPath[diagonalPath - 1],
            removePath = bestPath[diagonalPath + 1],
            _oldPos = (removePath ? removePath.newPos : 0) - diagonalPath;

        if (addPath) {
          // No one else is going to attempt to use this value, clear it
          bestPath[diagonalPath - 1] = undefined;
        }

        var canAdd = addPath && addPath.newPos + 1 < newLen,
            canRemove = removePath && 0 <= _oldPos && _oldPos < oldLen;

        if (!canAdd && !canRemove) {
          // If this path is a terminal then prune
          bestPath[diagonalPath] = undefined;
          continue;
        } // Select the diagonal that we want to branch from. We select the prior
        // path whose position in the new string is the farthest from the origin
        // and does not pass the bounds of the diff graph


        if (!canAdd || canRemove && addPath.newPos < removePath.newPos) {
          basePath = clonePath(removePath);
          self.pushComponent(basePath.components, undefined, true);
        } else {
          basePath = addPath; // No need to clone, we've pulled it from the list

          basePath.newPos++;
          self.pushComponent(basePath.components, true, undefined);
        }

        _oldPos = self.extractCommon(basePath, newString, oldString, diagonalPath); // If we have hit the end of both strings, then we are done

        if (basePath.newPos + 1 >= newLen && _oldPos + 1 >= oldLen) {
          return done(buildValues(self, basePath.components, newString, oldString, self.useLongestToken));
        } else {
          // Otherwise track this path as a potential candidate and continue.
          bestPath[diagonalPath] = basePath;
        }
      }

      editLength++;
    } // Performs the length of edit iteration. Is a bit fugly as this has to support the
    // sync and async mode which is never fun. Loops over execEditLength until a value
    // is produced.


    if (callback) {
      (function exec() {
        setTimeout(function () {
          // This should not happen, but we want to be safe.

          /* istanbul ignore next */
          if (editLength > maxEditLength) {
            return callback();
          }

          if (!execEditLength()) {
            exec();
          }
        }, 0);
      })();
    } else {
      while (editLength <= maxEditLength) {
        var ret = execEditLength();

        if (ret) {
          return ret;
        }
      }
    }
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  pushComponent: function pushComponent(components, added, removed) {
    var last = components[components.length - 1];

    if (last && last.added === added && last.removed === removed) {
      // We need to clone here as the component clone operation is just
      // as shallow array clone
      components[components.length - 1] = {
        count: last.count + 1,
        added: added,
        removed: removed
      };
    } else {
      components.push({
        count: 1,
        added: added,
        removed: removed
      });
    }
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  extractCommon: function extractCommon(basePath, newString, oldString, diagonalPath) {
    var newLen = newString.length,
        oldLen = oldString.length,
        newPos = basePath.newPos,
        oldPos = newPos - diagonalPath,
        commonCount = 0;

    while (newPos + 1 < newLen && oldPos + 1 < oldLen && this.equals(newString[newPos + 1], oldString[oldPos + 1])) {
      newPos++;
      oldPos++;
      commonCount++;
    }

    if (commonCount) {
      basePath.components.push({
        count: commonCount
      });
    }

    basePath.newPos = newPos;
    return oldPos;
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  equals: function equals(left, right) {
    if (this.options.comparator) {
      return this.options.comparator(left, right);
    } else {
      return left === right || this.options.ignoreCase && left.toLowerCase() === right.toLowerCase();
    }
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  removeEmpty: function removeEmpty(array) {
    var ret = [];

    for (var i = 0; i < array.length; i++) {
      if (array[i]) {
        ret.push(array[i]);
      }
    }

    return ret;
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  castInput: function castInput(value) {
    return value;
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  tokenize: function tokenize(value) {
    return value.split('');
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  join: function join(chars) {
    return chars.join('');
  }
};

function buildValues(diff, components, newString, oldString, useLongestToken) {
  var componentPos = 0,
      componentLen = components.length,
      newPos = 0,
      oldPos = 0;

  for (; componentPos < componentLen; componentPos++) {
    var component = components[componentPos];

    if (!component.removed) {
      if (!component.added && useLongestToken) {
        var value = newString.slice(newPos, newPos + component.count);
        value = value.map(function (value, i) {
          var oldValue = oldString[oldPos + i];
          return oldValue.length > value.length ? oldValue : value;
        });
        component.value = diff.join(value);
      } else {
        component.value = diff.join(newString.slice(newPos, newPos + component.count));
      }

      newPos += component.count; // Common case

      if (!component.added) {
        oldPos += component.count;
      }
    } else {
      component.value = diff.join(oldString.slice(oldPos, oldPos + component.count));
      oldPos += component.count; // Reverse add and remove so removes are output first to match common convention
      // The diffing algorithm is tied to add then remove output and this is the simplest
      // route to get the desired output with minimal overhead.

      if (componentPos && components[componentPos - 1].added) {
        var tmp = components[componentPos - 1];
        components[componentPos - 1] = components[componentPos];
        components[componentPos] = tmp;
      }
    }
  } // Special case handle for when one terminal is ignored (i.e. whitespace).
  // For this case we merge the terminal into the prior string and drop the change.
  // This is only available for string mode.


  var lastComponent = components[componentLen - 1];

  if (componentLen > 1 && typeof lastComponent.value === 'string' && (lastComponent.added || lastComponent.removed) && diff.equals('', lastComponent.value)) {
    components[componentLen - 2].value += lastComponent.value;
    components.pop();
  }

  return components;
}

function clonePath(path) {
  return {
    newPos: path.newPos,
    components: path.components.slice(0)
  };
}


/***/ }),

/***/ 1973:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
var __webpack_unused_export__;
/*istanbul ignore start*/


__webpack_unused_export__ = ({
  value: true
});
exports.Kx = diffChars;
__webpack_unused_export__ = void 0;

/*istanbul ignore end*/
var
/*istanbul ignore start*/
_base = _interopRequireDefault(__webpack_require__(1198))
/*istanbul ignore end*/
;

/*istanbul ignore start*/ function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*istanbul ignore end*/
var characterDiff = new
/*istanbul ignore start*/
_base
/*istanbul ignore end*/
.
/*istanbul ignore start*/
default
/*istanbul ignore end*/
();

/*istanbul ignore start*/
__webpack_unused_export__ = characterDiff;

/*istanbul ignore end*/
function diffChars(oldStr, newStr, options) {
  return characterDiff.diff(oldStr, newStr, options);
}


/***/ }),

/***/ 1345:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var util = __webpack_require__(5022);

function scrollIntoView(elem, container, config) {
  config = config || {};
  // document 归一化到 window
  if (container.nodeType === 9) {
    container = util.getWindow(container);
  }

  var allowHorizontalScroll = config.allowHorizontalScroll;
  var onlyScrollIfNeeded = config.onlyScrollIfNeeded;
  var alignWithTop = config.alignWithTop;
  var alignWithLeft = config.alignWithLeft;
  var offsetTop = config.offsetTop || 0;
  var offsetLeft = config.offsetLeft || 0;
  var offsetBottom = config.offsetBottom || 0;
  var offsetRight = config.offsetRight || 0;

  allowHorizontalScroll = allowHorizontalScroll === undefined ? true : allowHorizontalScroll;

  var isWin = util.isWindow(container);
  var elemOffset = util.offset(elem);
  var eh = util.outerHeight(elem);
  var ew = util.outerWidth(elem);
  var containerOffset = undefined;
  var ch = undefined;
  var cw = undefined;
  var containerScroll = undefined;
  var diffTop = undefined;
  var diffBottom = undefined;
  var win = undefined;
  var winScroll = undefined;
  var ww = undefined;
  var wh = undefined;

  if (isWin) {
    win = container;
    wh = util.height(win);
    ww = util.width(win);
    winScroll = {
      left: util.scrollLeft(win),
      top: util.scrollTop(win)
    };
    // elem 相对 container 可视视窗的距离
    diffTop = {
      left: elemOffset.left - winScroll.left - offsetLeft,
      top: elemOffset.top - winScroll.top - offsetTop
    };
    diffBottom = {
      left: elemOffset.left + ew - (winScroll.left + ww) + offsetRight,
      top: elemOffset.top + eh - (winScroll.top + wh) + offsetBottom
    };
    containerScroll = winScroll;
  } else {
    containerOffset = util.offset(container);
    ch = container.clientHeight;
    cw = container.clientWidth;
    containerScroll = {
      left: container.scrollLeft,
      top: container.scrollTop
    };
    // elem 相对 container 可视视窗的距离
    // 注意边框, offset 是边框到根节点
    diffTop = {
      left: elemOffset.left - (containerOffset.left + (parseFloat(util.css(container, 'borderLeftWidth')) || 0)) - offsetLeft,
      top: elemOffset.top - (containerOffset.top + (parseFloat(util.css(container, 'borderTopWidth')) || 0)) - offsetTop
    };
    diffBottom = {
      left: elemOffset.left + ew - (containerOffset.left + cw + (parseFloat(util.css(container, 'borderRightWidth')) || 0)) + offsetRight,
      top: elemOffset.top + eh - (containerOffset.top + ch + (parseFloat(util.css(container, 'borderBottomWidth')) || 0)) + offsetBottom
    };
  }

  if (diffTop.top < 0 || diffBottom.top > 0) {
    // 强制向上
    if (alignWithTop === true) {
      util.scrollTop(container, containerScroll.top + diffTop.top);
    } else if (alignWithTop === false) {
      util.scrollTop(container, containerScroll.top + diffBottom.top);
    } else {
      // 自动调整
      if (diffTop.top < 0) {
        util.scrollTop(container, containerScroll.top + diffTop.top);
      } else {
        util.scrollTop(container, containerScroll.top + diffBottom.top);
      }
    }
  } else {
    if (!onlyScrollIfNeeded) {
      alignWithTop = alignWithTop === undefined ? true : !!alignWithTop;
      if (alignWithTop) {
        util.scrollTop(container, containerScroll.top + diffTop.top);
      } else {
        util.scrollTop(container, containerScroll.top + diffBottom.top);
      }
    }
  }

  if (allowHorizontalScroll) {
    if (diffTop.left < 0 || diffBottom.left > 0) {
      // 强制向上
      if (alignWithLeft === true) {
        util.scrollLeft(container, containerScroll.left + diffTop.left);
      } else if (alignWithLeft === false) {
        util.scrollLeft(container, containerScroll.left + diffBottom.left);
      } else {
        // 自动调整
        if (diffTop.left < 0) {
          util.scrollLeft(container, containerScroll.left + diffTop.left);
        } else {
          util.scrollLeft(container, containerScroll.left + diffBottom.left);
        }
      }
    } else {
      if (!onlyScrollIfNeeded) {
        alignWithLeft = alignWithLeft === undefined ? true : !!alignWithLeft;
        if (alignWithLeft) {
          util.scrollLeft(container, containerScroll.left + diffTop.left);
        } else {
          util.scrollLeft(container, containerScroll.left + diffBottom.left);
        }
      }
    }
  }
}

module.exports = scrollIntoView;

/***/ }),

/***/ 5425:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


module.exports = __webpack_require__(1345);

/***/ }),

/***/ 5022:
/***/ (function(module) {

"use strict";


var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

var RE_NUM = /[\-+]?(?:\d*\.|)\d+(?:[eE][\-+]?\d+|)/.source;

function getClientPosition(elem) {
  var box = undefined;
  var x = undefined;
  var y = undefined;
  var doc = elem.ownerDocument;
  var body = doc.body;
  var docElem = doc && doc.documentElement;
  // 根据 GBS 最新数据，A-Grade Browsers 都已支持 getBoundingClientRect 方法，不用再考虑传统的实现方式
  box = elem.getBoundingClientRect();

  // 注：jQuery 还考虑减去 docElem.clientLeft/clientTop
  // 但测试发现，这样反而会导致当 html 和 body 有边距/边框样式时，获取的值不正确
  // 此外，ie6 会忽略 html 的 margin 值，幸运地是没有谁会去设置 html 的 margin

  x = box.left;
  y = box.top;

  // In IE, most of the time, 2 extra pixels are added to the top and left
  // due to the implicit 2-pixel inset border.  In IE6/7 quirks mode and
  // IE6 standards mode, this border can be overridden by setting the
  // document element's border to zero -- thus, we cannot rely on the
  // offset always being 2 pixels.

  // In quirks mode, the offset can be determined by querying the body's
  // clientLeft/clientTop, but in standards mode, it is found by querying
  // the document element's clientLeft/clientTop.  Since we already called
  // getClientBoundingRect we have already forced a reflow, so it is not
  // too expensive just to query them all.

  // ie 下应该减去窗口的边框吧，毕竟默认 absolute 都是相对窗口定位的
  // 窗口边框标准是设 documentElement ,quirks 时设置 body
  // 最好禁止在 body 和 html 上边框 ，但 ie < 9 html 默认有 2px ，减去
  // 但是非 ie 不可能设置窗口边框，body html 也不是窗口 ,ie 可以通过 html,body 设置
  // 标准 ie 下 docElem.clientTop 就是 border-top
  // ie7 html 即窗口边框改变不了。永远为 2
  // 但标准 firefox/chrome/ie9 下 docElem.clientTop 是窗口边框，即使设了 border-top 也为 0

  x -= docElem.clientLeft || body.clientLeft || 0;
  y -= docElem.clientTop || body.clientTop || 0;

  return {
    left: x,
    top: y
  };
}

function getScroll(w, top) {
  var ret = w['page' + (top ? 'Y' : 'X') + 'Offset'];
  var method = 'scroll' + (top ? 'Top' : 'Left');
  if (typeof ret !== 'number') {
    var d = w.document;
    // ie6,7,8 standard mode
    ret = d.documentElement[method];
    if (typeof ret !== 'number') {
      // quirks mode
      ret = d.body[method];
    }
  }
  return ret;
}

function getScrollLeft(w) {
  return getScroll(w);
}

function getScrollTop(w) {
  return getScroll(w, true);
}

function getOffset(el) {
  var pos = getClientPosition(el);
  var doc = el.ownerDocument;
  var w = doc.defaultView || doc.parentWindow;
  pos.left += getScrollLeft(w);
  pos.top += getScrollTop(w);
  return pos;
}
function _getComputedStyle(elem, name, computedStyle_) {
  var val = '';
  var d = elem.ownerDocument;
  var computedStyle = computedStyle_ || d.defaultView.getComputedStyle(elem, null);

  // https://github.com/kissyteam/kissy/issues/61
  if (computedStyle) {
    val = computedStyle.getPropertyValue(name) || computedStyle[name];
  }

  return val;
}

var _RE_NUM_NO_PX = new RegExp('^(' + RE_NUM + ')(?!px)[a-z%]+$', 'i');
var RE_POS = /^(top|right|bottom|left)$/;
var CURRENT_STYLE = 'currentStyle';
var RUNTIME_STYLE = 'runtimeStyle';
var LEFT = 'left';
var PX = 'px';

function _getComputedStyleIE(elem, name) {
  // currentStyle maybe null
  // http://msdn.microsoft.com/en-us/library/ms535231.aspx
  var ret = elem[CURRENT_STYLE] && elem[CURRENT_STYLE][name];

  // 当 width/height 设置为百分比时，通过 pixelLeft 方式转换的 width/height 值
  // 一开始就处理了! CUSTOM_STYLE.height,CUSTOM_STYLE.width ,cssHook 解决@2011-08-19
  // 在 ie 下不对，需要直接用 offset 方式
  // borderWidth 等值也有问题，但考虑到 borderWidth 设为百分比的概率很小，这里就不考虑了

  // From the awesome hack by Dean Edwards
  // http://erik.eae.net/archives/2007/07/27/18.54.15/#comment-102291
  // If we're not dealing with a regular pixel number
  // but a number that has a weird ending, we need to convert it to pixels
  // exclude left right for relativity
  if (_RE_NUM_NO_PX.test(ret) && !RE_POS.test(name)) {
    // Remember the original values
    var style = elem.style;
    var left = style[LEFT];
    var rsLeft = elem[RUNTIME_STYLE][LEFT];

    // prevent flashing of content
    elem[RUNTIME_STYLE][LEFT] = elem[CURRENT_STYLE][LEFT];

    // Put in the new values to get a computed value out
    style[LEFT] = name === 'fontSize' ? '1em' : ret || 0;
    ret = style.pixelLeft + PX;

    // Revert the changed values
    style[LEFT] = left;

    elem[RUNTIME_STYLE][LEFT] = rsLeft;
  }
  return ret === '' ? 'auto' : ret;
}

var getComputedStyleX = undefined;
if (typeof window !== 'undefined') {
  getComputedStyleX = window.getComputedStyle ? _getComputedStyle : _getComputedStyleIE;
}

function each(arr, fn) {
  for (var i = 0; i < arr.length; i++) {
    fn(arr[i]);
  }
}

function isBorderBoxFn(elem) {
  return getComputedStyleX(elem, 'boxSizing') === 'border-box';
}

var BOX_MODELS = ['margin', 'border', 'padding'];
var CONTENT_INDEX = -1;
var PADDING_INDEX = 2;
var BORDER_INDEX = 1;
var MARGIN_INDEX = 0;

function swap(elem, options, callback) {
  var old = {};
  var style = elem.style;
  var name = undefined;

  // Remember the old values, and insert the new ones
  for (name in options) {
    if (options.hasOwnProperty(name)) {
      old[name] = style[name];
      style[name] = options[name];
    }
  }

  callback.call(elem);

  // Revert the old values
  for (name in options) {
    if (options.hasOwnProperty(name)) {
      style[name] = old[name];
    }
  }
}

function getPBMWidth(elem, props, which) {
  var value = 0;
  var prop = undefined;
  var j = undefined;
  var i = undefined;
  for (j = 0; j < props.length; j++) {
    prop = props[j];
    if (prop) {
      for (i = 0; i < which.length; i++) {
        var cssProp = undefined;
        if (prop === 'border') {
          cssProp = prop + which[i] + 'Width';
        } else {
          cssProp = prop + which[i];
        }
        value += parseFloat(getComputedStyleX(elem, cssProp)) || 0;
      }
    }
  }
  return value;
}

/**
 * A crude way of determining if an object is a window
 * @member util
 */
function isWindow(obj) {
  // must use == for ie8
  /* eslint eqeqeq:0 */
  return obj != null && obj == obj.window;
}

var domUtils = {};

each(['Width', 'Height'], function (name) {
  domUtils['doc' + name] = function (refWin) {
    var d = refWin.document;
    return Math.max(
    // firefox chrome documentElement.scrollHeight< body.scrollHeight
    // ie standard mode : documentElement.scrollHeight> body.scrollHeight
    d.documentElement['scroll' + name],
    // quirks : documentElement.scrollHeight 最大等于可视窗口多一点？
    d.body['scroll' + name], domUtils['viewport' + name](d));
  };

  domUtils['viewport' + name] = function (win) {
    // pc browser includes scrollbar in window.innerWidth
    var prop = 'client' + name;
    var doc = win.document;
    var body = doc.body;
    var documentElement = doc.documentElement;
    var documentElementProp = documentElement[prop];
    // 标准模式取 documentElement
    // backcompat 取 body
    return doc.compatMode === 'CSS1Compat' && documentElementProp || body && body[prop] || documentElementProp;
  };
});

/*
 得到元素的大小信息
 @param elem
 @param name
 @param {String} [extra]  'padding' : (css width) + padding
 'border' : (css width) + padding + border
 'margin' : (css width) + padding + border + margin
 */
function getWH(elem, name, extra) {
  if (isWindow(elem)) {
    return name === 'width' ? domUtils.viewportWidth(elem) : domUtils.viewportHeight(elem);
  } else if (elem.nodeType === 9) {
    return name === 'width' ? domUtils.docWidth(elem) : domUtils.docHeight(elem);
  }
  var which = name === 'width' ? ['Left', 'Right'] : ['Top', 'Bottom'];
  var borderBoxValue = name === 'width' ? elem.offsetWidth : elem.offsetHeight;
  var computedStyle = getComputedStyleX(elem);
  var isBorderBox = isBorderBoxFn(elem, computedStyle);
  var cssBoxValue = 0;
  if (borderBoxValue == null || borderBoxValue <= 0) {
    borderBoxValue = undefined;
    // Fall back to computed then un computed css if necessary
    cssBoxValue = getComputedStyleX(elem, name);
    if (cssBoxValue == null || Number(cssBoxValue) < 0) {
      cssBoxValue = elem.style[name] || 0;
    }
    // Normalize '', auto, and prepare for extra
    cssBoxValue = parseFloat(cssBoxValue) || 0;
  }
  if (extra === undefined) {
    extra = isBorderBox ? BORDER_INDEX : CONTENT_INDEX;
  }
  var borderBoxValueOrIsBorderBox = borderBoxValue !== undefined || isBorderBox;
  var val = borderBoxValue || cssBoxValue;
  if (extra === CONTENT_INDEX) {
    if (borderBoxValueOrIsBorderBox) {
      return val - getPBMWidth(elem, ['border', 'padding'], which, computedStyle);
    }
    return cssBoxValue;
  }
  if (borderBoxValueOrIsBorderBox) {
    var padding = extra === PADDING_INDEX ? -getPBMWidth(elem, ['border'], which, computedStyle) : getPBMWidth(elem, ['margin'], which, computedStyle);
    return val + (extra === BORDER_INDEX ? 0 : padding);
  }
  return cssBoxValue + getPBMWidth(elem, BOX_MODELS.slice(extra), which, computedStyle);
}

var cssShow = {
  position: 'absolute',
  visibility: 'hidden',
  display: 'block'
};

// fix #119 : https://github.com/kissyteam/kissy/issues/119
function getWHIgnoreDisplay(elem) {
  var val = undefined;
  var args = arguments;
  // in case elem is window
  // elem.offsetWidth === undefined
  if (elem.offsetWidth !== 0) {
    val = getWH.apply(undefined, args);
  } else {
    swap(elem, cssShow, function () {
      val = getWH.apply(undefined, args);
    });
  }
  return val;
}

function css(el, name, v) {
  var value = v;
  if ((typeof name === 'undefined' ? 'undefined' : _typeof(name)) === 'object') {
    for (var i in name) {
      if (name.hasOwnProperty(i)) {
        css(el, i, name[i]);
      }
    }
    return undefined;
  }
  if (typeof value !== 'undefined') {
    if (typeof value === 'number') {
      value += 'px';
    }
    el.style[name] = value;
    return undefined;
  }
  return getComputedStyleX(el, name);
}

each(['width', 'height'], function (name) {
  var first = name.charAt(0).toUpperCase() + name.slice(1);
  domUtils['outer' + first] = function (el, includeMargin) {
    return el && getWHIgnoreDisplay(el, name, includeMargin ? MARGIN_INDEX : BORDER_INDEX);
  };
  var which = name === 'width' ? ['Left', 'Right'] : ['Top', 'Bottom'];

  domUtils[name] = function (elem, val) {
    if (val !== undefined) {
      if (elem) {
        var computedStyle = getComputedStyleX(elem);
        var isBorderBox = isBorderBoxFn(elem);
        if (isBorderBox) {
          val += getPBMWidth(elem, ['padding', 'border'], which, computedStyle);
        }
        return css(elem, name, val);
      }
      return undefined;
    }
    return elem && getWHIgnoreDisplay(elem, name, CONTENT_INDEX);
  };
});

// 设置 elem 相对 elem.ownerDocument 的坐标
function setOffset(elem, offset) {
  // set position first, in-case top/left are set even on static elem
  if (css(elem, 'position') === 'static') {
    elem.style.position = 'relative';
  }

  var old = getOffset(elem);
  var ret = {};
  var current = undefined;
  var key = undefined;

  for (key in offset) {
    if (offset.hasOwnProperty(key)) {
      current = parseFloat(css(elem, key)) || 0;
      ret[key] = current + offset[key] - old[key];
    }
  }
  css(elem, ret);
}

module.exports = _extends({
  getWindow: function getWindow(node) {
    var doc = node.ownerDocument || node;
    return doc.defaultView || doc.parentWindow;
  },
  offset: function offset(el, value) {
    if (typeof value !== 'undefined') {
      setOffset(el, value);
    } else {
      return getOffset(el);
    }
  },

  isWindow: isWindow,
  each: each,
  css: css,
  clone: function clone(obj) {
    var ret = {};
    for (var i in obj) {
      if (obj.hasOwnProperty(i)) {
        ret[i] = obj[i];
      }
    }
    var overflow = obj.overflow;
    if (overflow) {
      for (var i in obj) {
        if (obj.hasOwnProperty(i)) {
          ret.overflow[i] = obj.overflow[i];
        }
      }
    }
    return ret;
  },
  scrollLeft: function scrollLeft(w, v) {
    if (isWindow(w)) {
      if (v === undefined) {
        return getScrollLeft(w);
      }
      window.scrollTo(v, getScrollTop(w));
    } else {
      if (v === undefined) {
        return w.scrollLeft;
      }
      w.scrollLeft = v;
    }
  },
  scrollTop: function scrollTop(w, v) {
    if (isWindow(w)) {
      if (v === undefined) {
        return getScrollTop(w);
      }
      window.scrollTo(getScrollLeft(w), v);
    } else {
      if (v === undefined) {
        return w.scrollTop;
      }
      w.scrollTop = v;
    }
  },

  viewportWidth: 0,
  viewportHeight: 0
}, domUtils);

/***/ }),

/***/ 8918:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(292);

/** @type {import('.')} */
var $defineProperty = GetIntrinsic('%Object.defineProperty%', true) || false;
if ($defineProperty) {
	try {
		$defineProperty({}, 'a', { value: 1 });
	} catch (e) {
		// IE 8 has a broken defineProperty
		$defineProperty = false;
	}
}

module.exports = $defineProperty;


/***/ }),

/***/ 3592:
/***/ (function(module) {

"use strict";


/* eslint no-invalid-this: 1 */

var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
var toStr = Object.prototype.toString;
var max = Math.max;
var funcType = '[object Function]';

var concatty = function concatty(a, b) {
    var arr = [];

    for (var i = 0; i < a.length; i += 1) {
        arr[i] = a[i];
    }
    for (var j = 0; j < b.length; j += 1) {
        arr[j + a.length] = b[j];
    }

    return arr;
};

var slicy = function slicy(arrLike, offset) {
    var arr = [];
    for (var i = offset || 0, j = 0; i < arrLike.length; i += 1, j += 1) {
        arr[j] = arrLike[i];
    }
    return arr;
};

var joiny = function (arr, joiner) {
    var str = '';
    for (var i = 0; i < arr.length; i += 1) {
        str += arr[i];
        if (i + 1 < arr.length) {
            str += joiner;
        }
    }
    return str;
};

module.exports = function bind(that) {
    var target = this;
    if (typeof target !== 'function' || toStr.apply(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
    }
    var args = slicy(arguments, 1);

    var bound;
    var binder = function () {
        if (this instanceof bound) {
            var result = target.apply(
                this,
                concatty(args, arguments)
            );
            if (Object(result) === result) {
                return result;
            }
            return this;
        }
        return target.apply(
            that,
            concatty(args, arguments)
        );

    };

    var boundLength = max(0, target.length - args.length);
    var boundArgs = [];
    for (var i = 0; i < boundLength; i++) {
        boundArgs[i] = '$' + i;
    }

    bound = Function('binder', 'return function (' + joiny(boundArgs, ',') + '){ return binder.apply(this,arguments); }')(binder);

    if (target.prototype) {
        var Empty = function Empty() {};
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
    }

    return bound;
};


/***/ }),

/***/ 5903:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var implementation = __webpack_require__(3592);

module.exports = Function.prototype.bind || implementation;


/***/ }),

/***/ 292:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var undefined;

var $Error = __webpack_require__(6716);
var $EvalError = __webpack_require__(6788);
var $RangeError = __webpack_require__(9204);
var $ReferenceError = __webpack_require__(9908);
var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);
var $URIError = __webpack_require__(1451);

var $Function = Function;

// eslint-disable-next-line consistent-return
var getEvalledConstructor = function (expressionSyntax) {
	try {
		return $Function('"use strict"; return (' + expressionSyntax + ').constructor;')();
	} catch (e) {}
};

var $gOPD = Object.getOwnPropertyDescriptor;
if ($gOPD) {
	try {
		$gOPD({}, '');
	} catch (e) {
		$gOPD = null; // this is IE 8, which has a broken gOPD
	}
}

var throwTypeError = function () {
	throw new $TypeError();
};
var ThrowTypeError = $gOPD
	? (function () {
		try {
			// eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
			arguments.callee; // IE 8 does not throw here
			return throwTypeError;
		} catch (calleeThrows) {
			try {
				// IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
				return $gOPD(arguments, 'callee').get;
			} catch (gOPDthrows) {
				return throwTypeError;
			}
		}
	}())
	: throwTypeError;

var hasSymbols = __webpack_require__(4482)();
var hasProto = __webpack_require__(1856)();

var getProto = Object.getPrototypeOf || (
	hasProto
		? function (x) { return x.__proto__; } // eslint-disable-line no-proto
		: null
);

var needsEval = {};

var TypedArray = typeof Uint8Array === 'undefined' || !getProto ? undefined : getProto(Uint8Array);

var INTRINSICS = {
	__proto__: null,
	'%AggregateError%': typeof AggregateError === 'undefined' ? undefined : AggregateError,
	'%Array%': Array,
	'%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined : ArrayBuffer,
	'%ArrayIteratorPrototype%': hasSymbols && getProto ? getProto([][Symbol.iterator]()) : undefined,
	'%AsyncFromSyncIteratorPrototype%': undefined,
	'%AsyncFunction%': needsEval,
	'%AsyncGenerator%': needsEval,
	'%AsyncGeneratorFunction%': needsEval,
	'%AsyncIteratorPrototype%': needsEval,
	'%Atomics%': typeof Atomics === 'undefined' ? undefined : Atomics,
	'%BigInt%': typeof BigInt === 'undefined' ? undefined : BigInt,
	'%BigInt64Array%': typeof BigInt64Array === 'undefined' ? undefined : BigInt64Array,
	'%BigUint64Array%': typeof BigUint64Array === 'undefined' ? undefined : BigUint64Array,
	'%Boolean%': Boolean,
	'%DataView%': typeof DataView === 'undefined' ? undefined : DataView,
	'%Date%': Date,
	'%decodeURI%': decodeURI,
	'%decodeURIComponent%': decodeURIComponent,
	'%encodeURI%': encodeURI,
	'%encodeURIComponent%': encodeURIComponent,
	'%Error%': $Error,
	'%eval%': eval, // eslint-disable-line no-eval
	'%EvalError%': $EvalError,
	'%Float32Array%': typeof Float32Array === 'undefined' ? undefined : Float32Array,
	'%Float64Array%': typeof Float64Array === 'undefined' ? undefined : Float64Array,
	'%FinalizationRegistry%': typeof FinalizationRegistry === 'undefined' ? undefined : FinalizationRegistry,
	'%Function%': $Function,
	'%GeneratorFunction%': needsEval,
	'%Int8Array%': typeof Int8Array === 'undefined' ? undefined : Int8Array,
	'%Int16Array%': typeof Int16Array === 'undefined' ? undefined : Int16Array,
	'%Int32Array%': typeof Int32Array === 'undefined' ? undefined : Int32Array,
	'%isFinite%': isFinite,
	'%isNaN%': isNaN,
	'%IteratorPrototype%': hasSymbols && getProto ? getProto(getProto([][Symbol.iterator]())) : undefined,
	'%JSON%': typeof JSON === 'object' ? JSON : undefined,
	'%Map%': typeof Map === 'undefined' ? undefined : Map,
	'%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Map()[Symbol.iterator]()),
	'%Math%': Math,
	'%Number%': Number,
	'%Object%': Object,
	'%parseFloat%': parseFloat,
	'%parseInt%': parseInt,
	'%Promise%': typeof Promise === 'undefined' ? undefined : Promise,
	'%Proxy%': typeof Proxy === 'undefined' ? undefined : Proxy,
	'%RangeError%': $RangeError,
	'%ReferenceError%': $ReferenceError,
	'%Reflect%': typeof Reflect === 'undefined' ? undefined : Reflect,
	'%RegExp%': RegExp,
	'%Set%': typeof Set === 'undefined' ? undefined : Set,
	'%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Set()[Symbol.iterator]()),
	'%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined : SharedArrayBuffer,
	'%String%': String,
	'%StringIteratorPrototype%': hasSymbols && getProto ? getProto(''[Symbol.iterator]()) : undefined,
	'%Symbol%': hasSymbols ? Symbol : undefined,
	'%SyntaxError%': $SyntaxError,
	'%ThrowTypeError%': ThrowTypeError,
	'%TypedArray%': TypedArray,
	'%TypeError%': $TypeError,
	'%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined : Uint8Array,
	'%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined : Uint8ClampedArray,
	'%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined : Uint16Array,
	'%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined : Uint32Array,
	'%URIError%': $URIError,
	'%WeakMap%': typeof WeakMap === 'undefined' ? undefined : WeakMap,
	'%WeakRef%': typeof WeakRef === 'undefined' ? undefined : WeakRef,
	'%WeakSet%': typeof WeakSet === 'undefined' ? undefined : WeakSet
};

if (getProto) {
	try {
		null.error; // eslint-disable-line no-unused-expressions
	} catch (e) {
		// https://github.com/tc39/proposal-shadowrealm/pull/384#issuecomment-1364264229
		var errorProto = getProto(getProto(e));
		INTRINSICS['%Error.prototype%'] = errorProto;
	}
}

var doEval = function doEval(name) {
	var value;
	if (name === '%AsyncFunction%') {
		value = getEvalledConstructor('async function () {}');
	} else if (name === '%GeneratorFunction%') {
		value = getEvalledConstructor('function* () {}');
	} else if (name === '%AsyncGeneratorFunction%') {
		value = getEvalledConstructor('async function* () {}');
	} else if (name === '%AsyncGenerator%') {
		var fn = doEval('%AsyncGeneratorFunction%');
		if (fn) {
			value = fn.prototype;
		}
	} else if (name === '%AsyncIteratorPrototype%') {
		var gen = doEval('%AsyncGenerator%');
		if (gen && getProto) {
			value = getProto(gen.prototype);
		}
	}

	INTRINSICS[name] = value;

	return value;
};

var LEGACY_ALIASES = {
	__proto__: null,
	'%ArrayBufferPrototype%': ['ArrayBuffer', 'prototype'],
	'%ArrayPrototype%': ['Array', 'prototype'],
	'%ArrayProto_entries%': ['Array', 'prototype', 'entries'],
	'%ArrayProto_forEach%': ['Array', 'prototype', 'forEach'],
	'%ArrayProto_keys%': ['Array', 'prototype', 'keys'],
	'%ArrayProto_values%': ['Array', 'prototype', 'values'],
	'%AsyncFunctionPrototype%': ['AsyncFunction', 'prototype'],
	'%AsyncGenerator%': ['AsyncGeneratorFunction', 'prototype'],
	'%AsyncGeneratorPrototype%': ['AsyncGeneratorFunction', 'prototype', 'prototype'],
	'%BooleanPrototype%': ['Boolean', 'prototype'],
	'%DataViewPrototype%': ['DataView', 'prototype'],
	'%DatePrototype%': ['Date', 'prototype'],
	'%ErrorPrototype%': ['Error', 'prototype'],
	'%EvalErrorPrototype%': ['EvalError', 'prototype'],
	'%Float32ArrayPrototype%': ['Float32Array', 'prototype'],
	'%Float64ArrayPrototype%': ['Float64Array', 'prototype'],
	'%FunctionPrototype%': ['Function', 'prototype'],
	'%Generator%': ['GeneratorFunction', 'prototype'],
	'%GeneratorPrototype%': ['GeneratorFunction', 'prototype', 'prototype'],
	'%Int8ArrayPrototype%': ['Int8Array', 'prototype'],
	'%Int16ArrayPrototype%': ['Int16Array', 'prototype'],
	'%Int32ArrayPrototype%': ['Int32Array', 'prototype'],
	'%JSONParse%': ['JSON', 'parse'],
	'%JSONStringify%': ['JSON', 'stringify'],
	'%MapPrototype%': ['Map', 'prototype'],
	'%NumberPrototype%': ['Number', 'prototype'],
	'%ObjectPrototype%': ['Object', 'prototype'],
	'%ObjProto_toString%': ['Object', 'prototype', 'toString'],
	'%ObjProto_valueOf%': ['Object', 'prototype', 'valueOf'],
	'%PromisePrototype%': ['Promise', 'prototype'],
	'%PromiseProto_then%': ['Promise', 'prototype', 'then'],
	'%Promise_all%': ['Promise', 'all'],
	'%Promise_reject%': ['Promise', 'reject'],
	'%Promise_resolve%': ['Promise', 'resolve'],
	'%RangeErrorPrototype%': ['RangeError', 'prototype'],
	'%ReferenceErrorPrototype%': ['ReferenceError', 'prototype'],
	'%RegExpPrototype%': ['RegExp', 'prototype'],
	'%SetPrototype%': ['Set', 'prototype'],
	'%SharedArrayBufferPrototype%': ['SharedArrayBuffer', 'prototype'],
	'%StringPrototype%': ['String', 'prototype'],
	'%SymbolPrototype%': ['Symbol', 'prototype'],
	'%SyntaxErrorPrototype%': ['SyntaxError', 'prototype'],
	'%TypedArrayPrototype%': ['TypedArray', 'prototype'],
	'%TypeErrorPrototype%': ['TypeError', 'prototype'],
	'%Uint8ArrayPrototype%': ['Uint8Array', 'prototype'],
	'%Uint8ClampedArrayPrototype%': ['Uint8ClampedArray', 'prototype'],
	'%Uint16ArrayPrototype%': ['Uint16Array', 'prototype'],
	'%Uint32ArrayPrototype%': ['Uint32Array', 'prototype'],
	'%URIErrorPrototype%': ['URIError', 'prototype'],
	'%WeakMapPrototype%': ['WeakMap', 'prototype'],
	'%WeakSetPrototype%': ['WeakSet', 'prototype']
};

var bind = __webpack_require__(5903);
var hasOwn = __webpack_require__(9429);
var $concat = bind.call(Function.call, Array.prototype.concat);
var $spliceApply = bind.call(Function.apply, Array.prototype.splice);
var $replace = bind.call(Function.call, String.prototype.replace);
var $strSlice = bind.call(Function.call, String.prototype.slice);
var $exec = bind.call(Function.call, RegExp.prototype.exec);

/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */
var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
var reEscapeChar = /\\(\\)?/g; /** Used to match backslashes in property paths. */
var stringToPath = function stringToPath(string) {
	var first = $strSlice(string, 0, 1);
	var last = $strSlice(string, -1);
	if (first === '%' && last !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected closing `%`');
	} else if (last === '%' && first !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected opening `%`');
	}
	var result = [];
	$replace(string, rePropName, function (match, number, quote, subString) {
		result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
	});
	return result;
};
/* end adaptation */

var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
	var intrinsicName = name;
	var alias;
	if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
		alias = LEGACY_ALIASES[intrinsicName];
		intrinsicName = '%' + alias[0] + '%';
	}

	if (hasOwn(INTRINSICS, intrinsicName)) {
		var value = INTRINSICS[intrinsicName];
		if (value === needsEval) {
			value = doEval(intrinsicName);
		}
		if (typeof value === 'undefined' && !allowMissing) {
			throw new $TypeError('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
		}

		return {
			alias: alias,
			name: intrinsicName,
			value: value
		};
	}

	throw new $SyntaxError('intrinsic ' + name + ' does not exist!');
};

module.exports = function GetIntrinsic(name, allowMissing) {
	if (typeof name !== 'string' || name.length === 0) {
		throw new $TypeError('intrinsic name must be a non-empty string');
	}
	if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
		throw new $TypeError('"allowMissing" argument must be a boolean');
	}

	if ($exec(/^%?[^%]*%?$/, name) === null) {
		throw new $SyntaxError('`%` may not be present anywhere but at the beginning and end of the intrinsic name');
	}
	var parts = stringToPath(name);
	var intrinsicBaseName = parts.length > 0 ? parts[0] : '';

	var intrinsic = getBaseIntrinsic('%' + intrinsicBaseName + '%', allowMissing);
	var intrinsicRealName = intrinsic.name;
	var value = intrinsic.value;
	var skipFurtherCaching = false;

	var alias = intrinsic.alias;
	if (alias) {
		intrinsicBaseName = alias[0];
		$spliceApply(parts, $concat([0, 1], alias));
	}

	for (var i = 1, isOwn = true; i < parts.length; i += 1) {
		var part = parts[i];
		var first = $strSlice(part, 0, 1);
		var last = $strSlice(part, -1);
		if (
			(
				(first === '"' || first === "'" || first === '`')
				|| (last === '"' || last === "'" || last === '`')
			)
			&& first !== last
		) {
			throw new $SyntaxError('property names with quotes must have matching quotes');
		}
		if (part === 'constructor' || !isOwn) {
			skipFurtherCaching = true;
		}

		intrinsicBaseName += '.' + part;
		intrinsicRealName = '%' + intrinsicBaseName + '%';

		if (hasOwn(INTRINSICS, intrinsicRealName)) {
			value = INTRINSICS[intrinsicRealName];
		} else if (value != null) {
			if (!(part in value)) {
				if (!allowMissing) {
					throw new $TypeError('base intrinsic for ' + name + ' exists, but the property is not available.');
				}
				return void undefined;
			}
			if ($gOPD && (i + 1) >= parts.length) {
				var desc = $gOPD(value, part);
				isOwn = !!desc;

				// By convention, when a data property is converted to an accessor
				// property to emulate a data property that does not suffer from
				// the override mistake, that accessor's getter is marked with
				// an `originalValue` property. Here, when we detect this, we
				// uphold the illusion by pretending to see that original data
				// property, i.e., returning the value rather than the getter
				// itself.
				if (isOwn && 'get' in desc && !('originalValue' in desc.get)) {
					value = desc.get;
				} else {
					value = value[part];
				}
			} else {
				isOwn = hasOwn(value, part);
				value = value[part];
			}

			if (isOwn && !skipFurtherCaching) {
				INTRINSICS[intrinsicRealName] = value;
			}
		}
	}
	return value;
};


/***/ }),

/***/ 4482:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var origSymbol = typeof Symbol !== 'undefined' && Symbol;
var hasSymbolSham = __webpack_require__(7457);

module.exports = function hasNativeSymbols() {
	if (typeof origSymbol !== 'function') { return false; }
	if (typeof Symbol !== 'function') { return false; }
	if (typeof origSymbol('foo') !== 'symbol') { return false; }
	if (typeof Symbol('bar') !== 'symbol') { return false; }

	return hasSymbolSham();
};


/***/ }),

/***/ 7457:
/***/ (function(module) {

"use strict";


/* eslint complexity: [2, 18], max-statements: [2, 33] */
module.exports = function hasSymbols() {
	if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
	if (typeof Symbol.iterator === 'symbol') { return true; }

	var obj = {};
	var sym = Symbol('test');
	var symObj = Object(sym);
	if (typeof sym === 'string') { return false; }

	if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
	if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

	// temp disabled per https://github.com/ljharb/object.assign/issues/17
	// if (sym instanceof Symbol) { return false; }
	// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
	// if (!(symObj instanceof Symbol)) { return false; }

	// if (typeof Symbol.prototype.toString !== 'function') { return false; }
	// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

	var symVal = 42;
	obj[sym] = symVal;
	for (sym in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
	if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

	if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

	var syms = Object.getOwnPropertySymbols(obj);
	if (syms.length !== 1 || syms[0] !== sym) { return false; }

	if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

	if (typeof Object.getOwnPropertyDescriptor === 'function') {
		var descriptor = Object.getOwnPropertyDescriptor(obj, sym);
		if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
	}

	return true;
};


/***/ }),

/***/ 6788:
/***/ (function(module) {

"use strict";


/** @type {import('./eval')} */
module.exports = EvalError;


/***/ }),

/***/ 6716:
/***/ (function(module) {

"use strict";


/** @type {import('.')} */
module.exports = Error;


/***/ }),

/***/ 9204:
/***/ (function(module) {

"use strict";


/** @type {import('./range')} */
module.exports = RangeError;


/***/ }),

/***/ 9908:
/***/ (function(module) {

"use strict";


/** @type {import('./ref')} */
module.exports = ReferenceError;


/***/ }),

/***/ 6724:
/***/ (function(module) {

"use strict";


/** @type {import('./syntax')} */
module.exports = SyntaxError;


/***/ }),

/***/ 1642:
/***/ (function(module) {

"use strict";


/** @type {import('./type')} */
module.exports = TypeError;


/***/ }),

/***/ 1451:
/***/ (function(module) {

"use strict";


/** @type {import('./uri')} */
module.exports = URIError;


/***/ }),

/***/ 7998:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $TypeError = __webpack_require__(1642);

/** @type {import('./RequireObjectCoercible')} */
module.exports = function RequireObjectCoercible(value) {
	if (value == null) {
		throw new $TypeError((arguments.length > 0 && arguments[1]) || ('Cannot call method on ' + value));
	}
	return value;
};


/***/ }),

/***/ 5249:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var hasSymbols = typeof Symbol === 'function' && typeof Symbol.iterator === 'symbol';

var isPrimitive = __webpack_require__(3777);
var isCallable = __webpack_require__(5443);
var isDate = __webpack_require__(8659);
var isSymbol = __webpack_require__(3082);

var ordinaryToPrimitive = function OrdinaryToPrimitive(O, hint) {
	if (typeof O === 'undefined' || O === null) {
		throw new TypeError('Cannot call method on ' + O);
	}
	if (typeof hint !== 'string' || (hint !== 'number' && hint !== 'string')) {
		throw new TypeError('hint must be "string" or "number"');
	}
	var methodNames = hint === 'string' ? ['toString', 'valueOf'] : ['valueOf', 'toString'];
	var method, result, i;
	for (i = 0; i < methodNames.length; ++i) {
		method = O[methodNames[i]];
		if (isCallable(method)) {
			result = method.call(O);
			if (isPrimitive(result)) {
				return result;
			}
		}
	}
	throw new TypeError('No default value');
};

var GetMethod = function GetMethod(O, P) {
	var func = O[P];
	if (func !== null && typeof func !== 'undefined') {
		if (!isCallable(func)) {
			throw new TypeError(func + ' returned for property ' + P + ' of object ' + O + ' is not a function');
		}
		return func;
	}
	return void 0;
};

// http://www.ecma-international.org/ecma-262/6.0/#sec-toprimitive
module.exports = function ToPrimitive(input) {
	if (isPrimitive(input)) {
		return input;
	}
	var hint = 'default';
	if (arguments.length > 1) {
		if (arguments[1] === String) {
			hint = 'string';
		} else if (arguments[1] === Number) {
			hint = 'number';
		}
	}

	var exoticToPrim;
	if (hasSymbols) {
		if (Symbol.toPrimitive) {
			exoticToPrim = GetMethod(input, Symbol.toPrimitive);
		} else if (isSymbol(input)) {
			exoticToPrim = Symbol.prototype.valueOf;
		}
	}
	if (typeof exoticToPrim !== 'undefined') {
		var result = exoticToPrim.call(input, hint);
		if (isPrimitive(result)) {
			return result;
		}
		throw new TypeError('unable to convert exotic object to primitive');
	}
	if (hint === 'default' && (isDate(input) || isSymbol(input))) {
		hint = 'string';
	}
	return ordinaryToPrimitive(input, hint === 'default' ? 'number' : hint);
};


/***/ }),

/***/ 3777:
/***/ (function(module) {

"use strict";


module.exports = function isPrimitive(value) {
	return value === null || (typeof value !== 'function' && typeof value !== 'object');
};


/***/ }),

/***/ 5619:
/***/ (function(module) {

"use strict";


// do not edit .js files directly - edit src/index.jst


  var envHasBigInt64Array = typeof BigInt64Array !== 'undefined';


module.exports = function equal(a, b) {
  if (a === b) return true;

  if (a && b && typeof a == 'object' && typeof b == 'object') {
    if (a.constructor !== b.constructor) return false;

    var length, i, keys;
    if (Array.isArray(a)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;)
        if (!equal(a[i], b[i])) return false;
      return true;
    }


    if ((a instanceof Map) && (b instanceof Map)) {
      if (a.size !== b.size) return false;
      for (i of a.entries())
        if (!b.has(i[0])) return false;
      for (i of a.entries())
        if (!equal(i[1], b.get(i[0]))) return false;
      return true;
    }

    if ((a instanceof Set) && (b instanceof Set)) {
      if (a.size !== b.size) return false;
      for (i of a.entries())
        if (!b.has(i[0])) return false;
      return true;
    }

    if (ArrayBuffer.isView(a) && ArrayBuffer.isView(b)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;)
        if (a[i] !== b[i]) return false;
      return true;
    }


    if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
    if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
    if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();

    keys = Object.keys(a);
    length = keys.length;
    if (length !== Object.keys(b).length) return false;

    for (i = length; i-- !== 0;)
      if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;

    for (i = length; i-- !== 0;) {
      var key = keys[i];

      if (!equal(a[key], b[key])) return false;
    }

    return true;
  }

  // true if both NaN, false otherwise
  return a!==a && b!==b;
};


/***/ }),

/***/ 4843:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var isCallable = __webpack_require__(5443);

var toStr = Object.prototype.toString;
var hasOwnProperty = Object.prototype.hasOwnProperty;

var forEachArray = function forEachArray(array, iterator, receiver) {
    for (var i = 0, len = array.length; i < len; i++) {
        if (hasOwnProperty.call(array, i)) {
            if (receiver == null) {
                iterator(array[i], i, array);
            } else {
                iterator.call(receiver, array[i], i, array);
            }
        }
    }
};

var forEachString = function forEachString(string, iterator, receiver) {
    for (var i = 0, len = string.length; i < len; i++) {
        // no such thing as a sparse string.
        if (receiver == null) {
            iterator(string.charAt(i), i, string);
        } else {
            iterator.call(receiver, string.charAt(i), i, string);
        }
    }
};

var forEachObject = function forEachObject(object, iterator, receiver) {
    for (var k in object) {
        if (hasOwnProperty.call(object, k)) {
            if (receiver == null) {
                iterator(object[k], k, object);
            } else {
                iterator.call(receiver, object[k], k, object);
            }
        }
    }
};

var forEach = function forEach(list, iterator, thisArg) {
    if (!isCallable(iterator)) {
        throw new TypeError('iterator must be a function');
    }

    var receiver;
    if (arguments.length >= 3) {
        receiver = thisArg;
    }

    if (toStr.call(list) === '[object Array]') {
        forEachArray(list, iterator, receiver);
    } else if (typeof list === 'string') {
        forEachString(list, iterator, receiver);
    } else {
        forEachObject(list, iterator, receiver);
    }
};

module.exports = forEach;


/***/ }),

/***/ 3828:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(2473);

var $gOPD = GetIntrinsic('%Object.getOwnPropertyDescriptor%', true);

if ($gOPD) {
	try {
		$gOPD([], 'length');
	} catch (e) {
		// IE 8 has a broken gOPD
		$gOPD = null;
	}
}

module.exports = $gOPD;


/***/ }),

/***/ 8819:
/***/ (function(module) {

"use strict";


/* eslint no-invalid-this: 1 */

var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
var toStr = Object.prototype.toString;
var max = Math.max;
var funcType = '[object Function]';

var concatty = function concatty(a, b) {
    var arr = [];

    for (var i = 0; i < a.length; i += 1) {
        arr[i] = a[i];
    }
    for (var j = 0; j < b.length; j += 1) {
        arr[j + a.length] = b[j];
    }

    return arr;
};

var slicy = function slicy(arrLike, offset) {
    var arr = [];
    for (var i = offset || 0, j = 0; i < arrLike.length; i += 1, j += 1) {
        arr[j] = arrLike[i];
    }
    return arr;
};

var joiny = function (arr, joiner) {
    var str = '';
    for (var i = 0; i < arr.length; i += 1) {
        str += arr[i];
        if (i + 1 < arr.length) {
            str += joiner;
        }
    }
    return str;
};

module.exports = function bind(that) {
    var target = this;
    if (typeof target !== 'function' || toStr.apply(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
    }
    var args = slicy(arguments, 1);

    var bound;
    var binder = function () {
        if (this instanceof bound) {
            var result = target.apply(
                this,
                concatty(args, arguments)
            );
            if (Object(result) === result) {
                return result;
            }
            return this;
        }
        return target.apply(
            that,
            concatty(args, arguments)
        );

    };

    var boundLength = max(0, target.length - args.length);
    var boundArgs = [];
    for (var i = 0; i < boundLength; i++) {
        boundArgs[i] = '$' + i;
    }

    bound = Function('binder', 'return function (' + joiny(boundArgs, ',') + '){ return binder.apply(this,arguments); }')(binder);

    if (target.prototype) {
        var Empty = function Empty() {};
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
    }

    return bound;
};


/***/ }),

/***/ 8729:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var implementation = __webpack_require__(8819);

module.exports = Function.prototype.bind || implementation;


/***/ }),

/***/ 2473:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var undefined;

var $Error = __webpack_require__(6716);
var $EvalError = __webpack_require__(6788);
var $RangeError = __webpack_require__(9204);
var $ReferenceError = __webpack_require__(9908);
var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);
var $URIError = __webpack_require__(1451);

var $Function = Function;

// eslint-disable-next-line consistent-return
var getEvalledConstructor = function (expressionSyntax) {
	try {
		return $Function('"use strict"; return (' + expressionSyntax + ').constructor;')();
	} catch (e) {}
};

var $gOPD = Object.getOwnPropertyDescriptor;
if ($gOPD) {
	try {
		$gOPD({}, '');
	} catch (e) {
		$gOPD = null; // this is IE 8, which has a broken gOPD
	}
}

var throwTypeError = function () {
	throw new $TypeError();
};
var ThrowTypeError = $gOPD
	? (function () {
		try {
			// eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
			arguments.callee; // IE 8 does not throw here
			return throwTypeError;
		} catch (calleeThrows) {
			try {
				// IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
				return $gOPD(arguments, 'callee').get;
			} catch (gOPDthrows) {
				return throwTypeError;
			}
		}
	}())
	: throwTypeError;

var hasSymbols = __webpack_require__(5810)();
var hasProto = __webpack_require__(1856)();

var getProto = Object.getPrototypeOf || (
	hasProto
		? function (x) { return x.__proto__; } // eslint-disable-line no-proto
		: null
);

var needsEval = {};

var TypedArray = typeof Uint8Array === 'undefined' || !getProto ? undefined : getProto(Uint8Array);

var INTRINSICS = {
	__proto__: null,
	'%AggregateError%': typeof AggregateError === 'undefined' ? undefined : AggregateError,
	'%Array%': Array,
	'%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined : ArrayBuffer,
	'%ArrayIteratorPrototype%': hasSymbols && getProto ? getProto([][Symbol.iterator]()) : undefined,
	'%AsyncFromSyncIteratorPrototype%': undefined,
	'%AsyncFunction%': needsEval,
	'%AsyncGenerator%': needsEval,
	'%AsyncGeneratorFunction%': needsEval,
	'%AsyncIteratorPrototype%': needsEval,
	'%Atomics%': typeof Atomics === 'undefined' ? undefined : Atomics,
	'%BigInt%': typeof BigInt === 'undefined' ? undefined : BigInt,
	'%BigInt64Array%': typeof BigInt64Array === 'undefined' ? undefined : BigInt64Array,
	'%BigUint64Array%': typeof BigUint64Array === 'undefined' ? undefined : BigUint64Array,
	'%Boolean%': Boolean,
	'%DataView%': typeof DataView === 'undefined' ? undefined : DataView,
	'%Date%': Date,
	'%decodeURI%': decodeURI,
	'%decodeURIComponent%': decodeURIComponent,
	'%encodeURI%': encodeURI,
	'%encodeURIComponent%': encodeURIComponent,
	'%Error%': $Error,
	'%eval%': eval, // eslint-disable-line no-eval
	'%EvalError%': $EvalError,
	'%Float32Array%': typeof Float32Array === 'undefined' ? undefined : Float32Array,
	'%Float64Array%': typeof Float64Array === 'undefined' ? undefined : Float64Array,
	'%FinalizationRegistry%': typeof FinalizationRegistry === 'undefined' ? undefined : FinalizationRegistry,
	'%Function%': $Function,
	'%GeneratorFunction%': needsEval,
	'%Int8Array%': typeof Int8Array === 'undefined' ? undefined : Int8Array,
	'%Int16Array%': typeof Int16Array === 'undefined' ? undefined : Int16Array,
	'%Int32Array%': typeof Int32Array === 'undefined' ? undefined : Int32Array,
	'%isFinite%': isFinite,
	'%isNaN%': isNaN,
	'%IteratorPrototype%': hasSymbols && getProto ? getProto(getProto([][Symbol.iterator]())) : undefined,
	'%JSON%': typeof JSON === 'object' ? JSON : undefined,
	'%Map%': typeof Map === 'undefined' ? undefined : Map,
	'%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Map()[Symbol.iterator]()),
	'%Math%': Math,
	'%Number%': Number,
	'%Object%': Object,
	'%parseFloat%': parseFloat,
	'%parseInt%': parseInt,
	'%Promise%': typeof Promise === 'undefined' ? undefined : Promise,
	'%Proxy%': typeof Proxy === 'undefined' ? undefined : Proxy,
	'%RangeError%': $RangeError,
	'%ReferenceError%': $ReferenceError,
	'%Reflect%': typeof Reflect === 'undefined' ? undefined : Reflect,
	'%RegExp%': RegExp,
	'%Set%': typeof Set === 'undefined' ? undefined : Set,
	'%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Set()[Symbol.iterator]()),
	'%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined : SharedArrayBuffer,
	'%String%': String,
	'%StringIteratorPrototype%': hasSymbols && getProto ? getProto(''[Symbol.iterator]()) : undefined,
	'%Symbol%': hasSymbols ? Symbol : undefined,
	'%SyntaxError%': $SyntaxError,
	'%ThrowTypeError%': ThrowTypeError,
	'%TypedArray%': TypedArray,
	'%TypeError%': $TypeError,
	'%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined : Uint8Array,
	'%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined : Uint8ClampedArray,
	'%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined : Uint16Array,
	'%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined : Uint32Array,
	'%URIError%': $URIError,
	'%WeakMap%': typeof WeakMap === 'undefined' ? undefined : WeakMap,
	'%WeakRef%': typeof WeakRef === 'undefined' ? undefined : WeakRef,
	'%WeakSet%': typeof WeakSet === 'undefined' ? undefined : WeakSet
};

if (getProto) {
	try {
		null.error; // eslint-disable-line no-unused-expressions
	} catch (e) {
		// https://github.com/tc39/proposal-shadowrealm/pull/384#issuecomment-1364264229
		var errorProto = getProto(getProto(e));
		INTRINSICS['%Error.prototype%'] = errorProto;
	}
}

var doEval = function doEval(name) {
	var value;
	if (name === '%AsyncFunction%') {
		value = getEvalledConstructor('async function () {}');
	} else if (name === '%GeneratorFunction%') {
		value = getEvalledConstructor('function* () {}');
	} else if (name === '%AsyncGeneratorFunction%') {
		value = getEvalledConstructor('async function* () {}');
	} else if (name === '%AsyncGenerator%') {
		var fn = doEval('%AsyncGeneratorFunction%');
		if (fn) {
			value = fn.prototype;
		}
	} else if (name === '%AsyncIteratorPrototype%') {
		var gen = doEval('%AsyncGenerator%');
		if (gen && getProto) {
			value = getProto(gen.prototype);
		}
	}

	INTRINSICS[name] = value;

	return value;
};

var LEGACY_ALIASES = {
	__proto__: null,
	'%ArrayBufferPrototype%': ['ArrayBuffer', 'prototype'],
	'%ArrayPrototype%': ['Array', 'prototype'],
	'%ArrayProto_entries%': ['Array', 'prototype', 'entries'],
	'%ArrayProto_forEach%': ['Array', 'prototype', 'forEach'],
	'%ArrayProto_keys%': ['Array', 'prototype', 'keys'],
	'%ArrayProto_values%': ['Array', 'prototype', 'values'],
	'%AsyncFunctionPrototype%': ['AsyncFunction', 'prototype'],
	'%AsyncGenerator%': ['AsyncGeneratorFunction', 'prototype'],
	'%AsyncGeneratorPrototype%': ['AsyncGeneratorFunction', 'prototype', 'prototype'],
	'%BooleanPrototype%': ['Boolean', 'prototype'],
	'%DataViewPrototype%': ['DataView', 'prototype'],
	'%DatePrototype%': ['Date', 'prototype'],
	'%ErrorPrototype%': ['Error', 'prototype'],
	'%EvalErrorPrototype%': ['EvalError', 'prototype'],
	'%Float32ArrayPrototype%': ['Float32Array', 'prototype'],
	'%Float64ArrayPrototype%': ['Float64Array', 'prototype'],
	'%FunctionPrototype%': ['Function', 'prototype'],
	'%Generator%': ['GeneratorFunction', 'prototype'],
	'%GeneratorPrototype%': ['GeneratorFunction', 'prototype', 'prototype'],
	'%Int8ArrayPrototype%': ['Int8Array', 'prototype'],
	'%Int16ArrayPrototype%': ['Int16Array', 'prototype'],
	'%Int32ArrayPrototype%': ['Int32Array', 'prototype'],
	'%JSONParse%': ['JSON', 'parse'],
	'%JSONStringify%': ['JSON', 'stringify'],
	'%MapPrototype%': ['Map', 'prototype'],
	'%NumberPrototype%': ['Number', 'prototype'],
	'%ObjectPrototype%': ['Object', 'prototype'],
	'%ObjProto_toString%': ['Object', 'prototype', 'toString'],
	'%ObjProto_valueOf%': ['Object', 'prototype', 'valueOf'],
	'%PromisePrototype%': ['Promise', 'prototype'],
	'%PromiseProto_then%': ['Promise', 'prototype', 'then'],
	'%Promise_all%': ['Promise', 'all'],
	'%Promise_reject%': ['Promise', 'reject'],
	'%Promise_resolve%': ['Promise', 'resolve'],
	'%RangeErrorPrototype%': ['RangeError', 'prototype'],
	'%ReferenceErrorPrototype%': ['ReferenceError', 'prototype'],
	'%RegExpPrototype%': ['RegExp', 'prototype'],
	'%SetPrototype%': ['Set', 'prototype'],
	'%SharedArrayBufferPrototype%': ['SharedArrayBuffer', 'prototype'],
	'%StringPrototype%': ['String', 'prototype'],
	'%SymbolPrototype%': ['Symbol', 'prototype'],
	'%SyntaxErrorPrototype%': ['SyntaxError', 'prototype'],
	'%TypedArrayPrototype%': ['TypedArray', 'prototype'],
	'%TypeErrorPrototype%': ['TypeError', 'prototype'],
	'%Uint8ArrayPrototype%': ['Uint8Array', 'prototype'],
	'%Uint8ClampedArrayPrototype%': ['Uint8ClampedArray', 'prototype'],
	'%Uint16ArrayPrototype%': ['Uint16Array', 'prototype'],
	'%Uint32ArrayPrototype%': ['Uint32Array', 'prototype'],
	'%URIErrorPrototype%': ['URIError', 'prototype'],
	'%WeakMapPrototype%': ['WeakMap', 'prototype'],
	'%WeakSetPrototype%': ['WeakSet', 'prototype']
};

var bind = __webpack_require__(8729);
var hasOwn = __webpack_require__(9429);
var $concat = bind.call(Function.call, Array.prototype.concat);
var $spliceApply = bind.call(Function.apply, Array.prototype.splice);
var $replace = bind.call(Function.call, String.prototype.replace);
var $strSlice = bind.call(Function.call, String.prototype.slice);
var $exec = bind.call(Function.call, RegExp.prototype.exec);

/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */
var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
var reEscapeChar = /\\(\\)?/g; /** Used to match backslashes in property paths. */
var stringToPath = function stringToPath(string) {
	var first = $strSlice(string, 0, 1);
	var last = $strSlice(string, -1);
	if (first === '%' && last !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected closing `%`');
	} else if (last === '%' && first !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected opening `%`');
	}
	var result = [];
	$replace(string, rePropName, function (match, number, quote, subString) {
		result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
	});
	return result;
};
/* end adaptation */

var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
	var intrinsicName = name;
	var alias;
	if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
		alias = LEGACY_ALIASES[intrinsicName];
		intrinsicName = '%' + alias[0] + '%';
	}

	if (hasOwn(INTRINSICS, intrinsicName)) {
		var value = INTRINSICS[intrinsicName];
		if (value === needsEval) {
			value = doEval(intrinsicName);
		}
		if (typeof value === 'undefined' && !allowMissing) {
			throw new $TypeError('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
		}

		return {
			alias: alias,
			name: intrinsicName,
			value: value
		};
	}

	throw new $SyntaxError('intrinsic ' + name + ' does not exist!');
};

module.exports = function GetIntrinsic(name, allowMissing) {
	if (typeof name !== 'string' || name.length === 0) {
		throw new $TypeError('intrinsic name must be a non-empty string');
	}
	if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
		throw new $TypeError('"allowMissing" argument must be a boolean');
	}

	if ($exec(/^%?[^%]*%?$/, name) === null) {
		throw new $SyntaxError('`%` may not be present anywhere but at the beginning and end of the intrinsic name');
	}
	var parts = stringToPath(name);
	var intrinsicBaseName = parts.length > 0 ? parts[0] : '';

	var intrinsic = getBaseIntrinsic('%' + intrinsicBaseName + '%', allowMissing);
	var intrinsicRealName = intrinsic.name;
	var value = intrinsic.value;
	var skipFurtherCaching = false;

	var alias = intrinsic.alias;
	if (alias) {
		intrinsicBaseName = alias[0];
		$spliceApply(parts, $concat([0, 1], alias));
	}

	for (var i = 1, isOwn = true; i < parts.length; i += 1) {
		var part = parts[i];
		var first = $strSlice(part, 0, 1);
		var last = $strSlice(part, -1);
		if (
			(
				(first === '"' || first === "'" || first === '`')
				|| (last === '"' || last === "'" || last === '`')
			)
			&& first !== last
		) {
			throw new $SyntaxError('property names with quotes must have matching quotes');
		}
		if (part === 'constructor' || !isOwn) {
			skipFurtherCaching = true;
		}

		intrinsicBaseName += '.' + part;
		intrinsicRealName = '%' + intrinsicBaseName + '%';

		if (hasOwn(INTRINSICS, intrinsicRealName)) {
			value = INTRINSICS[intrinsicRealName];
		} else if (value != null) {
			if (!(part in value)) {
				if (!allowMissing) {
					throw new $TypeError('base intrinsic for ' + name + ' exists, but the property is not available.');
				}
				return void undefined;
			}
			if ($gOPD && (i + 1) >= parts.length) {
				var desc = $gOPD(value, part);
				isOwn = !!desc;

				// By convention, when a data property is converted to an accessor
				// property to emulate a data property that does not suffer from
				// the override mistake, that accessor's getter is marked with
				// an `originalValue` property. Here, when we detect this, we
				// uphold the illusion by pretending to see that original data
				// property, i.e., returning the value rather than the getter
				// itself.
				if (isOwn && 'get' in desc && !('originalValue' in desc.get)) {
					value = desc.get;
				} else {
					value = value[part];
				}
			} else {
				isOwn = hasOwn(value, part);
				value = value[part];
			}

			if (isOwn && !skipFurtherCaching) {
				INTRINSICS[intrinsicRealName] = value;
			}
		}
	}
	return value;
};


/***/ }),

/***/ 5810:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var origSymbol = typeof Symbol !== 'undefined' && Symbol;
var hasSymbolSham = __webpack_require__(1759);

module.exports = function hasNativeSymbols() {
	if (typeof origSymbol !== 'function') { return false; }
	if (typeof Symbol !== 'function') { return false; }
	if (typeof origSymbol('foo') !== 'symbol') { return false; }
	if (typeof Symbol('bar') !== 'symbol') { return false; }

	return hasSymbolSham();
};


/***/ }),

/***/ 1759:
/***/ (function(module) {

"use strict";


/* eslint complexity: [2, 18], max-statements: [2, 33] */
module.exports = function hasSymbols() {
	if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
	if (typeof Symbol.iterator === 'symbol') { return true; }

	var obj = {};
	var sym = Symbol('test');
	var symObj = Object(sym);
	if (typeof sym === 'string') { return false; }

	if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
	if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

	// temp disabled per https://github.com/ljharb/object.assign/issues/17
	// if (sym instanceof Symbol) { return false; }
	// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
	// if (!(symObj instanceof Symbol)) { return false; }

	// if (typeof Symbol.prototype.toString !== 'function') { return false; }
	// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

	var symVal = 42;
	obj[sym] = symVal;
	for (sym in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
	if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

	if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

	var syms = Object.getOwnPropertySymbols(obj);
	if (syms.length !== 1 || syms[0] !== sym) { return false; }

	if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

	if (typeof Object.getOwnPropertyDescriptor === 'function') {
		var descriptor = Object.getOwnPropertyDescriptor(obj, sym);
		if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
	}

	return true;
};


/***/ }),

/***/ 8198:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $defineProperty = __webpack_require__(8918);

var hasPropertyDescriptors = function hasPropertyDescriptors() {
	return !!$defineProperty;
};

hasPropertyDescriptors.hasArrayLengthDefineBug = function hasArrayLengthDefineBug() {
	// node v0.6 has a bug where array lengths can be Set but not Defined
	if (!$defineProperty) {
		return null;
	}
	try {
		return $defineProperty([], 'length', { value: 1 }).length !== 1;
	} catch (e) {
		// In Firefox 4-22, defining length on an array throws an exception.
		return true;
	}
};

module.exports = hasPropertyDescriptors;


/***/ }),

/***/ 1856:
/***/ (function(module) {

"use strict";


var test = {
	__proto__: null,
	foo: {}
};

var $Object = Object;

/** @type {import('.')} */
module.exports = function hasProto() {
	// @ts-expect-error: TS errors on an inherited property for some reason
	return { __proto__: test }.foo === test.foo
		&& !(test instanceof $Object);
};


/***/ }),

/***/ 9905:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var origSymbol = __webpack_require__.g.Symbol;
var hasSymbolSham = __webpack_require__(5682);

module.exports = function hasNativeSymbols() {
	if (typeof origSymbol !== 'function') { return false; }
	if (typeof Symbol !== 'function') { return false; }
	if (typeof origSymbol('foo') !== 'symbol') { return false; }
	if (typeof Symbol('bar') !== 'symbol') { return false; }

	return hasSymbolSham();
};


/***/ }),

/***/ 5682:
/***/ (function(module) {

"use strict";


/* eslint complexity: [2, 18], max-statements: [2, 33] */
module.exports = function hasSymbols() {
	if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
	if (typeof Symbol.iterator === 'symbol') { return true; }

	var obj = {};
	var sym = Symbol('test');
	var symObj = Object(sym);
	if (typeof sym === 'string') { return false; }

	if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
	if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

	// temp disabled per https://github.com/ljharb/object.assign/issues/17
	// if (sym instanceof Symbol) { return false; }
	// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
	// if (!(symObj instanceof Symbol)) { return false; }

	// if (typeof Symbol.prototype.toString !== 'function') { return false; }
	// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

	var symVal = 42;
	obj[sym] = symVal;
	for (sym in obj) { return false; } // eslint-disable-line no-restricted-syntax
	if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

	if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

	var syms = Object.getOwnPropertySymbols(obj);
	if (syms.length !== 1 || syms[0] !== sym) { return false; }

	if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

	if (typeof Object.getOwnPropertyDescriptor === 'function') {
		var descriptor = Object.getOwnPropertyDescriptor(obj, sym);
		if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
	}

	return true;
};


/***/ }),

/***/ 81:
/***/ (function(module) {

"use strict";


/* eslint complexity: [2, 18], max-statements: [2, 33] */
module.exports = function hasSymbols() {
	if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
	if (typeof Symbol.iterator === 'symbol') { return true; }

	var obj = {};
	var sym = Symbol('test');
	var symObj = Object(sym);
	if (typeof sym === 'string') { return false; }

	if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
	if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

	// temp disabled per https://github.com/ljharb/object.assign/issues/17
	// if (sym instanceof Symbol) { return false; }
	// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
	// if (!(symObj instanceof Symbol)) { return false; }

	// if (typeof Symbol.prototype.toString !== 'function') { return false; }
	// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

	var symVal = 42;
	obj[sym] = symVal;
	for (sym in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
	if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

	if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

	var syms = Object.getOwnPropertySymbols(obj);
	if (syms.length !== 1 || syms[0] !== sym) { return false; }

	if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

	if (typeof Object.getOwnPropertyDescriptor === 'function') {
		var descriptor = Object.getOwnPropertyDescriptor(obj, sym);
		if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
	}

	return true;
};


/***/ }),

/***/ 4111:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var hasSymbols = __webpack_require__(81);

/** @type {import('.')} */
module.exports = function hasToStringTagShams() {
	return hasSymbols() && !!Symbol.toStringTag;
};


/***/ }),

/***/ 9429:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var call = Function.prototype.call;
var $hasOwn = Object.prototype.hasOwnProperty;
var bind = __webpack_require__(766);

/** @type {import('.')} */
module.exports = bind.call(call, $hasOwn);


/***/ }),

/***/ 2075:
/***/ (function(module) {

"use strict";


/* eslint no-invalid-this: 1 */

var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
var toStr = Object.prototype.toString;
var max = Math.max;
var funcType = '[object Function]';

var concatty = function concatty(a, b) {
    var arr = [];

    for (var i = 0; i < a.length; i += 1) {
        arr[i] = a[i];
    }
    for (var j = 0; j < b.length; j += 1) {
        arr[j + a.length] = b[j];
    }

    return arr;
};

var slicy = function slicy(arrLike, offset) {
    var arr = [];
    for (var i = offset || 0, j = 0; i < arrLike.length; i += 1, j += 1) {
        arr[j] = arrLike[i];
    }
    return arr;
};

var joiny = function (arr, joiner) {
    var str = '';
    for (var i = 0; i < arr.length; i += 1) {
        str += arr[i];
        if (i + 1 < arr.length) {
            str += joiner;
        }
    }
    return str;
};

module.exports = function bind(that) {
    var target = this;
    if (typeof target !== 'function' || toStr.apply(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
    }
    var args = slicy(arguments, 1);

    var bound;
    var binder = function () {
        if (this instanceof bound) {
            var result = target.apply(
                this,
                concatty(args, arguments)
            );
            if (Object(result) === result) {
                return result;
            }
            return this;
        }
        return target.apply(
            that,
            concatty(args, arguments)
        );

    };

    var boundLength = max(0, target.length - args.length);
    var boundArgs = [];
    for (var i = 0; i < boundLength; i++) {
        boundArgs[i] = '$' + i;
    }

    bound = Function('binder', 'return function (' + joiny(boundArgs, ',') + '){ return binder.apply(this,arguments); }')(binder);

    if (target.prototype) {
        var Empty = function Empty() {};
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
    }

    return bound;
};


/***/ }),

/***/ 766:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var implementation = __webpack_require__(2075);

module.exports = Function.prototype.bind || implementation;


/***/ }),

/***/ 8575:
/***/ (function(module) {

if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    if (superCtor) {
      ctor.super_ = superCtor
      ctor.prototype = Object.create(superCtor.prototype, {
        constructor: {
          value: ctor,
          enumerable: false,
          writable: true,
          configurable: true
        }
      })
    }
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    if (superCtor) {
      ctor.super_ = superCtor
      var TempCtor = function () {}
      TempCtor.prototype = superCtor.prototype
      ctor.prototype = new TempCtor()
      ctor.prototype.constructor = ctor
    }
  }
}


/***/ }),

/***/ 4602:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var callBind = __webpack_require__(4374);
var callBound = __webpack_require__(7442);
var GetIntrinsic = __webpack_require__(3767);

var $ArrayBuffer = GetIntrinsic('%ArrayBuffer%', true);
/** @type {undefined | ((receiver: ArrayBuffer) => number) | ((receiver: unknown) => never)} */
var $byteLength = callBound('ArrayBuffer.prototype.byteLength', true);
var $toString = callBound('Object.prototype.toString');

// in node 0.10, ArrayBuffers have no prototype methods, but have an own slot-checking `slice` method
var abSlice = !!$ArrayBuffer && !$byteLength && new $ArrayBuffer(0).slice;
var $abSlice = !!abSlice && callBind(abSlice);

/** @type {import('.')} */
module.exports = $byteLength || $abSlice
	? function isArrayBuffer(obj) {
		if (!obj || typeof obj !== 'object') {
			return false;
		}
		try {
			if ($byteLength) {
				// @ts-expect-error no idea why TS can't handle the overload
				$byteLength(obj);
			} else {
				// @ts-expect-error TS chooses not to type-narrow inside a closure
				$abSlice(obj, 0);
			}
			return true;
		} catch (e) {
			return false;
		}
	}
	: $ArrayBuffer
		// in node 0.8, ArrayBuffers have no prototype or own methods, but also no Symbol.toStringTag
		? function isArrayBuffer(obj) {
			return $toString(obj) === '[object ArrayBuffer]';
		}
		: function isArrayBuffer(obj) { // eslint-disable-line no-unused-vars
			return false;
		};


/***/ }),

/***/ 7442:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(3767);

var callBind = __webpack_require__(4374);

var $indexOf = callBind(GetIntrinsic('String.prototype.indexOf'));

module.exports = function callBoundIntrinsic(name, allowMissing) {
	var intrinsic = GetIntrinsic(name, !!allowMissing);
	if (typeof intrinsic === 'function' && $indexOf(name, '.prototype.') > -1) {
		return callBind(intrinsic);
	}
	return intrinsic;
};


/***/ }),

/***/ 4374:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var bind = __webpack_require__(7410);
var GetIntrinsic = __webpack_require__(3767);
var setFunctionLength = __webpack_require__(4521);

var $TypeError = __webpack_require__(1642);
var $apply = GetIntrinsic('%Function.prototype.apply%');
var $call = GetIntrinsic('%Function.prototype.call%');
var $reflectApply = GetIntrinsic('%Reflect.apply%', true) || bind.call($call, $apply);

var $defineProperty = __webpack_require__(8918);
var $max = GetIntrinsic('%Math.max%');

module.exports = function callBind(originalFunction) {
	if (typeof originalFunction !== 'function') {
		throw new $TypeError('a function is required');
	}
	var func = $reflectApply(bind, $call, arguments);
	return setFunctionLength(
		func,
		1 + $max(0, originalFunction.length - (arguments.length - 1)),
		true
	);
};

var applyBind = function applyBind() {
	return $reflectApply(bind, $apply, arguments);
};

if ($defineProperty) {
	$defineProperty(module.exports, 'apply', { value: applyBind });
} else {
	module.exports.apply = applyBind;
}


/***/ }),

/***/ 1818:
/***/ (function(module) {

"use strict";


/* eslint no-invalid-this: 1 */

var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
var toStr = Object.prototype.toString;
var max = Math.max;
var funcType = '[object Function]';

var concatty = function concatty(a, b) {
    var arr = [];

    for (var i = 0; i < a.length; i += 1) {
        arr[i] = a[i];
    }
    for (var j = 0; j < b.length; j += 1) {
        arr[j + a.length] = b[j];
    }

    return arr;
};

var slicy = function slicy(arrLike, offset) {
    var arr = [];
    for (var i = offset || 0, j = 0; i < arrLike.length; i += 1, j += 1) {
        arr[j] = arrLike[i];
    }
    return arr;
};

var joiny = function (arr, joiner) {
    var str = '';
    for (var i = 0; i < arr.length; i += 1) {
        str += arr[i];
        if (i + 1 < arr.length) {
            str += joiner;
        }
    }
    return str;
};

module.exports = function bind(that) {
    var target = this;
    if (typeof target !== 'function' || toStr.apply(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
    }
    var args = slicy(arguments, 1);

    var bound;
    var binder = function () {
        if (this instanceof bound) {
            var result = target.apply(
                this,
                concatty(args, arguments)
            );
            if (Object(result) === result) {
                return result;
            }
            return this;
        }
        return target.apply(
            that,
            concatty(args, arguments)
        );

    };

    var boundLength = max(0, target.length - args.length);
    var boundArgs = [];
    for (var i = 0; i < boundLength; i++) {
        boundArgs[i] = '$' + i;
    }

    bound = Function('binder', 'return function (' + joiny(boundArgs, ',') + '){ return binder.apply(this,arguments); }')(binder);

    if (target.prototype) {
        var Empty = function Empty() {};
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
    }

    return bound;
};


/***/ }),

/***/ 7410:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var implementation = __webpack_require__(1818);

module.exports = Function.prototype.bind || implementation;


/***/ }),

/***/ 3767:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var undefined;

var $Error = __webpack_require__(6716);
var $EvalError = __webpack_require__(6788);
var $RangeError = __webpack_require__(9204);
var $ReferenceError = __webpack_require__(9908);
var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);
var $URIError = __webpack_require__(1451);

var $Function = Function;

// eslint-disable-next-line consistent-return
var getEvalledConstructor = function (expressionSyntax) {
	try {
		return $Function('"use strict"; return (' + expressionSyntax + ').constructor;')();
	} catch (e) {}
};

var $gOPD = Object.getOwnPropertyDescriptor;
if ($gOPD) {
	try {
		$gOPD({}, '');
	} catch (e) {
		$gOPD = null; // this is IE 8, which has a broken gOPD
	}
}

var throwTypeError = function () {
	throw new $TypeError();
};
var ThrowTypeError = $gOPD
	? (function () {
		try {
			// eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
			arguments.callee; // IE 8 does not throw here
			return throwTypeError;
		} catch (calleeThrows) {
			try {
				// IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
				return $gOPD(arguments, 'callee').get;
			} catch (gOPDthrows) {
				return throwTypeError;
			}
		}
	}())
	: throwTypeError;

var hasSymbols = __webpack_require__(6945)();
var hasProto = __webpack_require__(1856)();

var getProto = Object.getPrototypeOf || (
	hasProto
		? function (x) { return x.__proto__; } // eslint-disable-line no-proto
		: null
);

var needsEval = {};

var TypedArray = typeof Uint8Array === 'undefined' || !getProto ? undefined : getProto(Uint8Array);

var INTRINSICS = {
	__proto__: null,
	'%AggregateError%': typeof AggregateError === 'undefined' ? undefined : AggregateError,
	'%Array%': Array,
	'%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined : ArrayBuffer,
	'%ArrayIteratorPrototype%': hasSymbols && getProto ? getProto([][Symbol.iterator]()) : undefined,
	'%AsyncFromSyncIteratorPrototype%': undefined,
	'%AsyncFunction%': needsEval,
	'%AsyncGenerator%': needsEval,
	'%AsyncGeneratorFunction%': needsEval,
	'%AsyncIteratorPrototype%': needsEval,
	'%Atomics%': typeof Atomics === 'undefined' ? undefined : Atomics,
	'%BigInt%': typeof BigInt === 'undefined' ? undefined : BigInt,
	'%BigInt64Array%': typeof BigInt64Array === 'undefined' ? undefined : BigInt64Array,
	'%BigUint64Array%': typeof BigUint64Array === 'undefined' ? undefined : BigUint64Array,
	'%Boolean%': Boolean,
	'%DataView%': typeof DataView === 'undefined' ? undefined : DataView,
	'%Date%': Date,
	'%decodeURI%': decodeURI,
	'%decodeURIComponent%': decodeURIComponent,
	'%encodeURI%': encodeURI,
	'%encodeURIComponent%': encodeURIComponent,
	'%Error%': $Error,
	'%eval%': eval, // eslint-disable-line no-eval
	'%EvalError%': $EvalError,
	'%Float32Array%': typeof Float32Array === 'undefined' ? undefined : Float32Array,
	'%Float64Array%': typeof Float64Array === 'undefined' ? undefined : Float64Array,
	'%FinalizationRegistry%': typeof FinalizationRegistry === 'undefined' ? undefined : FinalizationRegistry,
	'%Function%': $Function,
	'%GeneratorFunction%': needsEval,
	'%Int8Array%': typeof Int8Array === 'undefined' ? undefined : Int8Array,
	'%Int16Array%': typeof Int16Array === 'undefined' ? undefined : Int16Array,
	'%Int32Array%': typeof Int32Array === 'undefined' ? undefined : Int32Array,
	'%isFinite%': isFinite,
	'%isNaN%': isNaN,
	'%IteratorPrototype%': hasSymbols && getProto ? getProto(getProto([][Symbol.iterator]())) : undefined,
	'%JSON%': typeof JSON === 'object' ? JSON : undefined,
	'%Map%': typeof Map === 'undefined' ? undefined : Map,
	'%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Map()[Symbol.iterator]()),
	'%Math%': Math,
	'%Number%': Number,
	'%Object%': Object,
	'%parseFloat%': parseFloat,
	'%parseInt%': parseInt,
	'%Promise%': typeof Promise === 'undefined' ? undefined : Promise,
	'%Proxy%': typeof Proxy === 'undefined' ? undefined : Proxy,
	'%RangeError%': $RangeError,
	'%ReferenceError%': $ReferenceError,
	'%Reflect%': typeof Reflect === 'undefined' ? undefined : Reflect,
	'%RegExp%': RegExp,
	'%Set%': typeof Set === 'undefined' ? undefined : Set,
	'%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Set()[Symbol.iterator]()),
	'%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined : SharedArrayBuffer,
	'%String%': String,
	'%StringIteratorPrototype%': hasSymbols && getProto ? getProto(''[Symbol.iterator]()) : undefined,
	'%Symbol%': hasSymbols ? Symbol : undefined,
	'%SyntaxError%': $SyntaxError,
	'%ThrowTypeError%': ThrowTypeError,
	'%TypedArray%': TypedArray,
	'%TypeError%': $TypeError,
	'%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined : Uint8Array,
	'%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined : Uint8ClampedArray,
	'%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined : Uint16Array,
	'%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined : Uint32Array,
	'%URIError%': $URIError,
	'%WeakMap%': typeof WeakMap === 'undefined' ? undefined : WeakMap,
	'%WeakRef%': typeof WeakRef === 'undefined' ? undefined : WeakRef,
	'%WeakSet%': typeof WeakSet === 'undefined' ? undefined : WeakSet
};

if (getProto) {
	try {
		null.error; // eslint-disable-line no-unused-expressions
	} catch (e) {
		// https://github.com/tc39/proposal-shadowrealm/pull/384#issuecomment-1364264229
		var errorProto = getProto(getProto(e));
		INTRINSICS['%Error.prototype%'] = errorProto;
	}
}

var doEval = function doEval(name) {
	var value;
	if (name === '%AsyncFunction%') {
		value = getEvalledConstructor('async function () {}');
	} else if (name === '%GeneratorFunction%') {
		value = getEvalledConstructor('function* () {}');
	} else if (name === '%AsyncGeneratorFunction%') {
		value = getEvalledConstructor('async function* () {}');
	} else if (name === '%AsyncGenerator%') {
		var fn = doEval('%AsyncGeneratorFunction%');
		if (fn) {
			value = fn.prototype;
		}
	} else if (name === '%AsyncIteratorPrototype%') {
		var gen = doEval('%AsyncGenerator%');
		if (gen && getProto) {
			value = getProto(gen.prototype);
		}
	}

	INTRINSICS[name] = value;

	return value;
};

var LEGACY_ALIASES = {
	__proto__: null,
	'%ArrayBufferPrototype%': ['ArrayBuffer', 'prototype'],
	'%ArrayPrototype%': ['Array', 'prototype'],
	'%ArrayProto_entries%': ['Array', 'prototype', 'entries'],
	'%ArrayProto_forEach%': ['Array', 'prototype', 'forEach'],
	'%ArrayProto_keys%': ['Array', 'prototype', 'keys'],
	'%ArrayProto_values%': ['Array', 'prototype', 'values'],
	'%AsyncFunctionPrototype%': ['AsyncFunction', 'prototype'],
	'%AsyncGenerator%': ['AsyncGeneratorFunction', 'prototype'],
	'%AsyncGeneratorPrototype%': ['AsyncGeneratorFunction', 'prototype', 'prototype'],
	'%BooleanPrototype%': ['Boolean', 'prototype'],
	'%DataViewPrototype%': ['DataView', 'prototype'],
	'%DatePrototype%': ['Date', 'prototype'],
	'%ErrorPrototype%': ['Error', 'prototype'],
	'%EvalErrorPrototype%': ['EvalError', 'prototype'],
	'%Float32ArrayPrototype%': ['Float32Array', 'prototype'],
	'%Float64ArrayPrototype%': ['Float64Array', 'prototype'],
	'%FunctionPrototype%': ['Function', 'prototype'],
	'%Generator%': ['GeneratorFunction', 'prototype'],
	'%GeneratorPrototype%': ['GeneratorFunction', 'prototype', 'prototype'],
	'%Int8ArrayPrototype%': ['Int8Array', 'prototype'],
	'%Int16ArrayPrototype%': ['Int16Array', 'prototype'],
	'%Int32ArrayPrototype%': ['Int32Array', 'prototype'],
	'%JSONParse%': ['JSON', 'parse'],
	'%JSONStringify%': ['JSON', 'stringify'],
	'%MapPrototype%': ['Map', 'prototype'],
	'%NumberPrototype%': ['Number', 'prototype'],
	'%ObjectPrototype%': ['Object', 'prototype'],
	'%ObjProto_toString%': ['Object', 'prototype', 'toString'],
	'%ObjProto_valueOf%': ['Object', 'prototype', 'valueOf'],
	'%PromisePrototype%': ['Promise', 'prototype'],
	'%PromiseProto_then%': ['Promise', 'prototype', 'then'],
	'%Promise_all%': ['Promise', 'all'],
	'%Promise_reject%': ['Promise', 'reject'],
	'%Promise_resolve%': ['Promise', 'resolve'],
	'%RangeErrorPrototype%': ['RangeError', 'prototype'],
	'%ReferenceErrorPrototype%': ['ReferenceError', 'prototype'],
	'%RegExpPrototype%': ['RegExp', 'prototype'],
	'%SetPrototype%': ['Set', 'prototype'],
	'%SharedArrayBufferPrototype%': ['SharedArrayBuffer', 'prototype'],
	'%StringPrototype%': ['String', 'prototype'],
	'%SymbolPrototype%': ['Symbol', 'prototype'],
	'%SyntaxErrorPrototype%': ['SyntaxError', 'prototype'],
	'%TypedArrayPrototype%': ['TypedArray', 'prototype'],
	'%TypeErrorPrototype%': ['TypeError', 'prototype'],
	'%Uint8ArrayPrototype%': ['Uint8Array', 'prototype'],
	'%Uint8ClampedArrayPrototype%': ['Uint8ClampedArray', 'prototype'],
	'%Uint16ArrayPrototype%': ['Uint16Array', 'prototype'],
	'%Uint32ArrayPrototype%': ['Uint32Array', 'prototype'],
	'%URIErrorPrototype%': ['URIError', 'prototype'],
	'%WeakMapPrototype%': ['WeakMap', 'prototype'],
	'%WeakSetPrototype%': ['WeakSet', 'prototype']
};

var bind = __webpack_require__(7410);
var hasOwn = __webpack_require__(9429);
var $concat = bind.call(Function.call, Array.prototype.concat);
var $spliceApply = bind.call(Function.apply, Array.prototype.splice);
var $replace = bind.call(Function.call, String.prototype.replace);
var $strSlice = bind.call(Function.call, String.prototype.slice);
var $exec = bind.call(Function.call, RegExp.prototype.exec);

/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */
var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
var reEscapeChar = /\\(\\)?/g; /** Used to match backslashes in property paths. */
var stringToPath = function stringToPath(string) {
	var first = $strSlice(string, 0, 1);
	var last = $strSlice(string, -1);
	if (first === '%' && last !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected closing `%`');
	} else if (last === '%' && first !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected opening `%`');
	}
	var result = [];
	$replace(string, rePropName, function (match, number, quote, subString) {
		result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
	});
	return result;
};
/* end adaptation */

var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
	var intrinsicName = name;
	var alias;
	if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
		alias = LEGACY_ALIASES[intrinsicName];
		intrinsicName = '%' + alias[0] + '%';
	}

	if (hasOwn(INTRINSICS, intrinsicName)) {
		var value = INTRINSICS[intrinsicName];
		if (value === needsEval) {
			value = doEval(intrinsicName);
		}
		if (typeof value === 'undefined' && !allowMissing) {
			throw new $TypeError('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
		}

		return {
			alias: alias,
			name: intrinsicName,
			value: value
		};
	}

	throw new $SyntaxError('intrinsic ' + name + ' does not exist!');
};

module.exports = function GetIntrinsic(name, allowMissing) {
	if (typeof name !== 'string' || name.length === 0) {
		throw new $TypeError('intrinsic name must be a non-empty string');
	}
	if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
		throw new $TypeError('"allowMissing" argument must be a boolean');
	}

	if ($exec(/^%?[^%]*%?$/, name) === null) {
		throw new $SyntaxError('`%` may not be present anywhere but at the beginning and end of the intrinsic name');
	}
	var parts = stringToPath(name);
	var intrinsicBaseName = parts.length > 0 ? parts[0] : '';

	var intrinsic = getBaseIntrinsic('%' + intrinsicBaseName + '%', allowMissing);
	var intrinsicRealName = intrinsic.name;
	var value = intrinsic.value;
	var skipFurtherCaching = false;

	var alias = intrinsic.alias;
	if (alias) {
		intrinsicBaseName = alias[0];
		$spliceApply(parts, $concat([0, 1], alias));
	}

	for (var i = 1, isOwn = true; i < parts.length; i += 1) {
		var part = parts[i];
		var first = $strSlice(part, 0, 1);
		var last = $strSlice(part, -1);
		if (
			(
				(first === '"' || first === "'" || first === '`')
				|| (last === '"' || last === "'" || last === '`')
			)
			&& first !== last
		) {
			throw new $SyntaxError('property names with quotes must have matching quotes');
		}
		if (part === 'constructor' || !isOwn) {
			skipFurtherCaching = true;
		}

		intrinsicBaseName += '.' + part;
		intrinsicRealName = '%' + intrinsicBaseName + '%';

		if (hasOwn(INTRINSICS, intrinsicRealName)) {
			value = INTRINSICS[intrinsicRealName];
		} else if (value != null) {
			if (!(part in value)) {
				if (!allowMissing) {
					throw new $TypeError('base intrinsic for ' + name + ' exists, but the property is not available.');
				}
				return void undefined;
			}
			if ($gOPD && (i + 1) >= parts.length) {
				var desc = $gOPD(value, part);
				isOwn = !!desc;

				// By convention, when a data property is converted to an accessor
				// property to emulate a data property that does not suffer from
				// the override mistake, that accessor's getter is marked with
				// an `originalValue` property. Here, when we detect this, we
				// uphold the illusion by pretending to see that original data
				// property, i.e., returning the value rather than the getter
				// itself.
				if (isOwn && 'get' in desc && !('originalValue' in desc.get)) {
					value = desc.get;
				} else {
					value = value[part];
				}
			} else {
				isOwn = hasOwn(value, part);
				value = value[part];
			}

			if (isOwn && !skipFurtherCaching) {
				INTRINSICS[intrinsicRealName] = value;
			}
		}
	}
	return value;
};


/***/ }),

/***/ 6945:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var origSymbol = typeof Symbol !== 'undefined' && Symbol;
var hasSymbolSham = __webpack_require__(6992);

module.exports = function hasNativeSymbols() {
	if (typeof origSymbol !== 'function') { return false; }
	if (typeof Symbol !== 'function') { return false; }
	if (typeof origSymbol('foo') !== 'symbol') { return false; }
	if (typeof Symbol('bar') !== 'symbol') { return false; }

	return hasSymbolSham();
};


/***/ }),

/***/ 6992:
/***/ (function(module) {

"use strict";


/* eslint complexity: [2, 18], max-statements: [2, 33] */
module.exports = function hasSymbols() {
	if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
	if (typeof Symbol.iterator === 'symbol') { return true; }

	var obj = {};
	var sym = Symbol('test');
	var symObj = Object(sym);
	if (typeof sym === 'string') { return false; }

	if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
	if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

	// temp disabled per https://github.com/ljharb/object.assign/issues/17
	// if (sym instanceof Symbol) { return false; }
	// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
	// if (!(symObj instanceof Symbol)) { return false; }

	// if (typeof Symbol.prototype.toString !== 'function') { return false; }
	// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

	var symVal = 42;
	obj[sym] = symVal;
	for (sym in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
	if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

	if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

	var syms = Object.getOwnPropertySymbols(obj);
	if (syms.length !== 1 || syms[0] !== sym) { return false; }

	if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

	if (typeof Object.getOwnPropertyDescriptor === 'function') {
		var descriptor = Object.getOwnPropertyDescriptor(obj, sym);
		if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
	}

	return true;
};


/***/ }),

/***/ 5443:
/***/ (function(module) {

"use strict";


var fnToStr = Function.prototype.toString;
var reflectApply = typeof Reflect === 'object' && Reflect !== null && Reflect.apply;
var badArrayLike;
var isCallableMarker;
if (typeof reflectApply === 'function' && typeof Object.defineProperty === 'function') {
	try {
		badArrayLike = Object.defineProperty({}, 'length', {
			get: function () {
				throw isCallableMarker;
			}
		});
		isCallableMarker = {};
		// eslint-disable-next-line no-throw-literal
		reflectApply(function () { throw 42; }, null, badArrayLike);
	} catch (_) {
		if (_ !== isCallableMarker) {
			reflectApply = null;
		}
	}
} else {
	reflectApply = null;
}

var constructorRegex = /^\s*class\b/;
var isES6ClassFn = function isES6ClassFunction(value) {
	try {
		var fnStr = fnToStr.call(value);
		return constructorRegex.test(fnStr);
	} catch (e) {
		return false; // not a function
	}
};

var tryFunctionObject = function tryFunctionToStr(value) {
	try {
		if (isES6ClassFn(value)) { return false; }
		fnToStr.call(value);
		return true;
	} catch (e) {
		return false;
	}
};
var toStr = Object.prototype.toString;
var fnClass = '[object Function]';
var genClass = '[object GeneratorFunction]';
var hasToStringTag = typeof Symbol === 'function' && typeof Symbol.toStringTag === 'symbol';

module.exports = reflectApply
	? function isCallable(value) {
		if (!value) { return false; }
		if (typeof value !== 'function' && typeof value !== 'object') { return false; }
		if (typeof value === 'function' && !value.prototype) { return true; }
		try {
			reflectApply(value, null, badArrayLike);
		} catch (e) {
			if (e !== isCallableMarker) { return false; }
		}
		return !isES6ClassFn(value);
	}
	: function isCallable(value) {
		if (!value) { return false; }
		if (typeof value !== 'function' && typeof value !== 'object') { return false; }
		if (typeof value === 'function' && !value.prototype) { return true; }
		if (hasToStringTag) { return tryFunctionObject(value); }
		if (isES6ClassFn(value)) { return false; }
		var strClass = toStr.call(value);
		return strClass === fnClass || strClass === genClass;
	};


/***/ }),

/***/ 8659:
/***/ (function(module) {

"use strict";


var getDay = Date.prototype.getDay;
var tryDateObject = function tryDateGetDayCall(value) {
	try {
		getDay.call(value);
		return true;
	} catch (e) {
		return false;
	}
};

var toStr = Object.prototype.toString;
var dateClass = '[object Date]';
var hasToStringTag = typeof Symbol === 'function' && typeof Symbol.toStringTag === 'symbol';

module.exports = function isDateObject(value) {
	if (typeof value !== 'object' || value === null) {
		return false;
	}
	return hasToStringTag ? tryDateObject(value) : toStr.call(value) === dateClass;
};


/***/ }),

/***/ 5604:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var callBound = __webpack_require__(6131);

var $byteLength = callBound('SharedArrayBuffer.prototype.byteLength', true);

/** @type {import('.')} */
module.exports = $byteLength
	? function isSharedArrayBuffer(obj) {
		if (!obj || typeof obj !== 'object') {
			return false;
		}
		try {
			$byteLength(obj);
			return true;
		} catch (e) {
			return false;
		}
	}
	: function isSharedArrayBuffer(obj) { // eslint-disable-line no-unused-vars
		return false;
	};


/***/ }),

/***/ 6131:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(6254);

var callBind = __webpack_require__(7679);

var $indexOf = callBind(GetIntrinsic('String.prototype.indexOf'));

module.exports = function callBoundIntrinsic(name, allowMissing) {
	var intrinsic = GetIntrinsic(name, !!allowMissing);
	if (typeof intrinsic === 'function' && $indexOf(name, '.prototype.') > -1) {
		return callBind(intrinsic);
	}
	return intrinsic;
};


/***/ }),

/***/ 7679:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var bind = __webpack_require__(578);
var GetIntrinsic = __webpack_require__(6254);
var setFunctionLength = __webpack_require__(4521);

var $TypeError = __webpack_require__(1642);
var $apply = GetIntrinsic('%Function.prototype.apply%');
var $call = GetIntrinsic('%Function.prototype.call%');
var $reflectApply = GetIntrinsic('%Reflect.apply%', true) || bind.call($call, $apply);

var $defineProperty = __webpack_require__(8918);
var $max = GetIntrinsic('%Math.max%');

module.exports = function callBind(originalFunction) {
	if (typeof originalFunction !== 'function') {
		throw new $TypeError('a function is required');
	}
	var func = $reflectApply(bind, $call, arguments);
	return setFunctionLength(
		func,
		1 + $max(0, originalFunction.length - (arguments.length - 1)),
		true
	);
};

var applyBind = function applyBind() {
	return $reflectApply(bind, $apply, arguments);
};

if ($defineProperty) {
	$defineProperty(module.exports, 'apply', { value: applyBind });
} else {
	module.exports.apply = applyBind;
}


/***/ }),

/***/ 901:
/***/ (function(module) {

"use strict";


/* eslint no-invalid-this: 1 */

var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
var toStr = Object.prototype.toString;
var max = Math.max;
var funcType = '[object Function]';

var concatty = function concatty(a, b) {
    var arr = [];

    for (var i = 0; i < a.length; i += 1) {
        arr[i] = a[i];
    }
    for (var j = 0; j < b.length; j += 1) {
        arr[j + a.length] = b[j];
    }

    return arr;
};

var slicy = function slicy(arrLike, offset) {
    var arr = [];
    for (var i = offset || 0, j = 0; i < arrLike.length; i += 1, j += 1) {
        arr[j] = arrLike[i];
    }
    return arr;
};

var joiny = function (arr, joiner) {
    var str = '';
    for (var i = 0; i < arr.length; i += 1) {
        str += arr[i];
        if (i + 1 < arr.length) {
            str += joiner;
        }
    }
    return str;
};

module.exports = function bind(that) {
    var target = this;
    if (typeof target !== 'function' || toStr.apply(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
    }
    var args = slicy(arguments, 1);

    var bound;
    var binder = function () {
        if (this instanceof bound) {
            var result = target.apply(
                this,
                concatty(args, arguments)
            );
            if (Object(result) === result) {
                return result;
            }
            return this;
        }
        return target.apply(
            that,
            concatty(args, arguments)
        );

    };

    var boundLength = max(0, target.length - args.length);
    var boundArgs = [];
    for (var i = 0; i < boundLength; i++) {
        boundArgs[i] = '$' + i;
    }

    bound = Function('binder', 'return function (' + joiny(boundArgs, ',') + '){ return binder.apply(this,arguments); }')(binder);

    if (target.prototype) {
        var Empty = function Empty() {};
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
    }

    return bound;
};


/***/ }),

/***/ 578:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var implementation = __webpack_require__(901);

module.exports = Function.prototype.bind || implementation;


/***/ }),

/***/ 6254:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var undefined;

var $Error = __webpack_require__(6716);
var $EvalError = __webpack_require__(6788);
var $RangeError = __webpack_require__(9204);
var $ReferenceError = __webpack_require__(9908);
var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);
var $URIError = __webpack_require__(1451);

var $Function = Function;

// eslint-disable-next-line consistent-return
var getEvalledConstructor = function (expressionSyntax) {
	try {
		return $Function('"use strict"; return (' + expressionSyntax + ').constructor;')();
	} catch (e) {}
};

var $gOPD = Object.getOwnPropertyDescriptor;
if ($gOPD) {
	try {
		$gOPD({}, '');
	} catch (e) {
		$gOPD = null; // this is IE 8, which has a broken gOPD
	}
}

var throwTypeError = function () {
	throw new $TypeError();
};
var ThrowTypeError = $gOPD
	? (function () {
		try {
			// eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
			arguments.callee; // IE 8 does not throw here
			return throwTypeError;
		} catch (calleeThrows) {
			try {
				// IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
				return $gOPD(arguments, 'callee').get;
			} catch (gOPDthrows) {
				return throwTypeError;
			}
		}
	}())
	: throwTypeError;

var hasSymbols = __webpack_require__(2665)();
var hasProto = __webpack_require__(1856)();

var getProto = Object.getPrototypeOf || (
	hasProto
		? function (x) { return x.__proto__; } // eslint-disable-line no-proto
		: null
);

var needsEval = {};

var TypedArray = typeof Uint8Array === 'undefined' || !getProto ? undefined : getProto(Uint8Array);

var INTRINSICS = {
	__proto__: null,
	'%AggregateError%': typeof AggregateError === 'undefined' ? undefined : AggregateError,
	'%Array%': Array,
	'%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined : ArrayBuffer,
	'%ArrayIteratorPrototype%': hasSymbols && getProto ? getProto([][Symbol.iterator]()) : undefined,
	'%AsyncFromSyncIteratorPrototype%': undefined,
	'%AsyncFunction%': needsEval,
	'%AsyncGenerator%': needsEval,
	'%AsyncGeneratorFunction%': needsEval,
	'%AsyncIteratorPrototype%': needsEval,
	'%Atomics%': typeof Atomics === 'undefined' ? undefined : Atomics,
	'%BigInt%': typeof BigInt === 'undefined' ? undefined : BigInt,
	'%BigInt64Array%': typeof BigInt64Array === 'undefined' ? undefined : BigInt64Array,
	'%BigUint64Array%': typeof BigUint64Array === 'undefined' ? undefined : BigUint64Array,
	'%Boolean%': Boolean,
	'%DataView%': typeof DataView === 'undefined' ? undefined : DataView,
	'%Date%': Date,
	'%decodeURI%': decodeURI,
	'%decodeURIComponent%': decodeURIComponent,
	'%encodeURI%': encodeURI,
	'%encodeURIComponent%': encodeURIComponent,
	'%Error%': $Error,
	'%eval%': eval, // eslint-disable-line no-eval
	'%EvalError%': $EvalError,
	'%Float32Array%': typeof Float32Array === 'undefined' ? undefined : Float32Array,
	'%Float64Array%': typeof Float64Array === 'undefined' ? undefined : Float64Array,
	'%FinalizationRegistry%': typeof FinalizationRegistry === 'undefined' ? undefined : FinalizationRegistry,
	'%Function%': $Function,
	'%GeneratorFunction%': needsEval,
	'%Int8Array%': typeof Int8Array === 'undefined' ? undefined : Int8Array,
	'%Int16Array%': typeof Int16Array === 'undefined' ? undefined : Int16Array,
	'%Int32Array%': typeof Int32Array === 'undefined' ? undefined : Int32Array,
	'%isFinite%': isFinite,
	'%isNaN%': isNaN,
	'%IteratorPrototype%': hasSymbols && getProto ? getProto(getProto([][Symbol.iterator]())) : undefined,
	'%JSON%': typeof JSON === 'object' ? JSON : undefined,
	'%Map%': typeof Map === 'undefined' ? undefined : Map,
	'%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Map()[Symbol.iterator]()),
	'%Math%': Math,
	'%Number%': Number,
	'%Object%': Object,
	'%parseFloat%': parseFloat,
	'%parseInt%': parseInt,
	'%Promise%': typeof Promise === 'undefined' ? undefined : Promise,
	'%Proxy%': typeof Proxy === 'undefined' ? undefined : Proxy,
	'%RangeError%': $RangeError,
	'%ReferenceError%': $ReferenceError,
	'%Reflect%': typeof Reflect === 'undefined' ? undefined : Reflect,
	'%RegExp%': RegExp,
	'%Set%': typeof Set === 'undefined' ? undefined : Set,
	'%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Set()[Symbol.iterator]()),
	'%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined : SharedArrayBuffer,
	'%String%': String,
	'%StringIteratorPrototype%': hasSymbols && getProto ? getProto(''[Symbol.iterator]()) : undefined,
	'%Symbol%': hasSymbols ? Symbol : undefined,
	'%SyntaxError%': $SyntaxError,
	'%ThrowTypeError%': ThrowTypeError,
	'%TypedArray%': TypedArray,
	'%TypeError%': $TypeError,
	'%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined : Uint8Array,
	'%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined : Uint8ClampedArray,
	'%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined : Uint16Array,
	'%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined : Uint32Array,
	'%URIError%': $URIError,
	'%WeakMap%': typeof WeakMap === 'undefined' ? undefined : WeakMap,
	'%WeakRef%': typeof WeakRef === 'undefined' ? undefined : WeakRef,
	'%WeakSet%': typeof WeakSet === 'undefined' ? undefined : WeakSet
};

if (getProto) {
	try {
		null.error; // eslint-disable-line no-unused-expressions
	} catch (e) {
		// https://github.com/tc39/proposal-shadowrealm/pull/384#issuecomment-1364264229
		var errorProto = getProto(getProto(e));
		INTRINSICS['%Error.prototype%'] = errorProto;
	}
}

var doEval = function doEval(name) {
	var value;
	if (name === '%AsyncFunction%') {
		value = getEvalledConstructor('async function () {}');
	} else if (name === '%GeneratorFunction%') {
		value = getEvalledConstructor('function* () {}');
	} else if (name === '%AsyncGeneratorFunction%') {
		value = getEvalledConstructor('async function* () {}');
	} else if (name === '%AsyncGenerator%') {
		var fn = doEval('%AsyncGeneratorFunction%');
		if (fn) {
			value = fn.prototype;
		}
	} else if (name === '%AsyncIteratorPrototype%') {
		var gen = doEval('%AsyncGenerator%');
		if (gen && getProto) {
			value = getProto(gen.prototype);
		}
	}

	INTRINSICS[name] = value;

	return value;
};

var LEGACY_ALIASES = {
	__proto__: null,
	'%ArrayBufferPrototype%': ['ArrayBuffer', 'prototype'],
	'%ArrayPrototype%': ['Array', 'prototype'],
	'%ArrayProto_entries%': ['Array', 'prototype', 'entries'],
	'%ArrayProto_forEach%': ['Array', 'prototype', 'forEach'],
	'%ArrayProto_keys%': ['Array', 'prototype', 'keys'],
	'%ArrayProto_values%': ['Array', 'prototype', 'values'],
	'%AsyncFunctionPrototype%': ['AsyncFunction', 'prototype'],
	'%AsyncGenerator%': ['AsyncGeneratorFunction', 'prototype'],
	'%AsyncGeneratorPrototype%': ['AsyncGeneratorFunction', 'prototype', 'prototype'],
	'%BooleanPrototype%': ['Boolean', 'prototype'],
	'%DataViewPrototype%': ['DataView', 'prototype'],
	'%DatePrototype%': ['Date', 'prototype'],
	'%ErrorPrototype%': ['Error', 'prototype'],
	'%EvalErrorPrototype%': ['EvalError', 'prototype'],
	'%Float32ArrayPrototype%': ['Float32Array', 'prototype'],
	'%Float64ArrayPrototype%': ['Float64Array', 'prototype'],
	'%FunctionPrototype%': ['Function', 'prototype'],
	'%Generator%': ['GeneratorFunction', 'prototype'],
	'%GeneratorPrototype%': ['GeneratorFunction', 'prototype', 'prototype'],
	'%Int8ArrayPrototype%': ['Int8Array', 'prototype'],
	'%Int16ArrayPrototype%': ['Int16Array', 'prototype'],
	'%Int32ArrayPrototype%': ['Int32Array', 'prototype'],
	'%JSONParse%': ['JSON', 'parse'],
	'%JSONStringify%': ['JSON', 'stringify'],
	'%MapPrototype%': ['Map', 'prototype'],
	'%NumberPrototype%': ['Number', 'prototype'],
	'%ObjectPrototype%': ['Object', 'prototype'],
	'%ObjProto_toString%': ['Object', 'prototype', 'toString'],
	'%ObjProto_valueOf%': ['Object', 'prototype', 'valueOf'],
	'%PromisePrototype%': ['Promise', 'prototype'],
	'%PromiseProto_then%': ['Promise', 'prototype', 'then'],
	'%Promise_all%': ['Promise', 'all'],
	'%Promise_reject%': ['Promise', 'reject'],
	'%Promise_resolve%': ['Promise', 'resolve'],
	'%RangeErrorPrototype%': ['RangeError', 'prototype'],
	'%ReferenceErrorPrototype%': ['ReferenceError', 'prototype'],
	'%RegExpPrototype%': ['RegExp', 'prototype'],
	'%SetPrototype%': ['Set', 'prototype'],
	'%SharedArrayBufferPrototype%': ['SharedArrayBuffer', 'prototype'],
	'%StringPrototype%': ['String', 'prototype'],
	'%SymbolPrototype%': ['Symbol', 'prototype'],
	'%SyntaxErrorPrototype%': ['SyntaxError', 'prototype'],
	'%TypedArrayPrototype%': ['TypedArray', 'prototype'],
	'%TypeErrorPrototype%': ['TypeError', 'prototype'],
	'%Uint8ArrayPrototype%': ['Uint8Array', 'prototype'],
	'%Uint8ClampedArrayPrototype%': ['Uint8ClampedArray', 'prototype'],
	'%Uint16ArrayPrototype%': ['Uint16Array', 'prototype'],
	'%Uint32ArrayPrototype%': ['Uint32Array', 'prototype'],
	'%URIErrorPrototype%': ['URIError', 'prototype'],
	'%WeakMapPrototype%': ['WeakMap', 'prototype'],
	'%WeakSetPrototype%': ['WeakSet', 'prototype']
};

var bind = __webpack_require__(578);
var hasOwn = __webpack_require__(9429);
var $concat = bind.call(Function.call, Array.prototype.concat);
var $spliceApply = bind.call(Function.apply, Array.prototype.splice);
var $replace = bind.call(Function.call, String.prototype.replace);
var $strSlice = bind.call(Function.call, String.prototype.slice);
var $exec = bind.call(Function.call, RegExp.prototype.exec);

/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */
var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
var reEscapeChar = /\\(\\)?/g; /** Used to match backslashes in property paths. */
var stringToPath = function stringToPath(string) {
	var first = $strSlice(string, 0, 1);
	var last = $strSlice(string, -1);
	if (first === '%' && last !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected closing `%`');
	} else if (last === '%' && first !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected opening `%`');
	}
	var result = [];
	$replace(string, rePropName, function (match, number, quote, subString) {
		result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
	});
	return result;
};
/* end adaptation */

var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
	var intrinsicName = name;
	var alias;
	if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
		alias = LEGACY_ALIASES[intrinsicName];
		intrinsicName = '%' + alias[0] + '%';
	}

	if (hasOwn(INTRINSICS, intrinsicName)) {
		var value = INTRINSICS[intrinsicName];
		if (value === needsEval) {
			value = doEval(intrinsicName);
		}
		if (typeof value === 'undefined' && !allowMissing) {
			throw new $TypeError('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
		}

		return {
			alias: alias,
			name: intrinsicName,
			value: value
		};
	}

	throw new $SyntaxError('intrinsic ' + name + ' does not exist!');
};

module.exports = function GetIntrinsic(name, allowMissing) {
	if (typeof name !== 'string' || name.length === 0) {
		throw new $TypeError('intrinsic name must be a non-empty string');
	}
	if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
		throw new $TypeError('"allowMissing" argument must be a boolean');
	}

	if ($exec(/^%?[^%]*%?$/, name) === null) {
		throw new $SyntaxError('`%` may not be present anywhere but at the beginning and end of the intrinsic name');
	}
	var parts = stringToPath(name);
	var intrinsicBaseName = parts.length > 0 ? parts[0] : '';

	var intrinsic = getBaseIntrinsic('%' + intrinsicBaseName + '%', allowMissing);
	var intrinsicRealName = intrinsic.name;
	var value = intrinsic.value;
	var skipFurtherCaching = false;

	var alias = intrinsic.alias;
	if (alias) {
		intrinsicBaseName = alias[0];
		$spliceApply(parts, $concat([0, 1], alias));
	}

	for (var i = 1, isOwn = true; i < parts.length; i += 1) {
		var part = parts[i];
		var first = $strSlice(part, 0, 1);
		var last = $strSlice(part, -1);
		if (
			(
				(first === '"' || first === "'" || first === '`')
				|| (last === '"' || last === "'" || last === '`')
			)
			&& first !== last
		) {
			throw new $SyntaxError('property names with quotes must have matching quotes');
		}
		if (part === 'constructor' || !isOwn) {
			skipFurtherCaching = true;
		}

		intrinsicBaseName += '.' + part;
		intrinsicRealName = '%' + intrinsicBaseName + '%';

		if (hasOwn(INTRINSICS, intrinsicRealName)) {
			value = INTRINSICS[intrinsicRealName];
		} else if (value != null) {
			if (!(part in value)) {
				if (!allowMissing) {
					throw new $TypeError('base intrinsic for ' + name + ' exists, but the property is not available.');
				}
				return void undefined;
			}
			if ($gOPD && (i + 1) >= parts.length) {
				var desc = $gOPD(value, part);
				isOwn = !!desc;

				// By convention, when a data property is converted to an accessor
				// property to emulate a data property that does not suffer from
				// the override mistake, that accessor's getter is marked with
				// an `originalValue` property. Here, when we detect this, we
				// uphold the illusion by pretending to see that original data
				// property, i.e., returning the value rather than the getter
				// itself.
				if (isOwn && 'get' in desc && !('originalValue' in desc.get)) {
					value = desc.get;
				} else {
					value = value[part];
				}
			} else {
				isOwn = hasOwn(value, part);
				value = value[part];
			}

			if (isOwn && !skipFurtherCaching) {
				INTRINSICS[intrinsicRealName] = value;
			}
		}
	}
	return value;
};


/***/ }),

/***/ 2665:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var origSymbol = typeof Symbol !== 'undefined' && Symbol;
var hasSymbolSham = __webpack_require__(2408);

module.exports = function hasNativeSymbols() {
	if (typeof origSymbol !== 'function') { return false; }
	if (typeof Symbol !== 'function') { return false; }
	if (typeof origSymbol('foo') !== 'symbol') { return false; }
	if (typeof Symbol('bar') !== 'symbol') { return false; }

	return hasSymbolSham();
};


/***/ }),

/***/ 2408:
/***/ (function(module) {

"use strict";


/* eslint complexity: [2, 18], max-statements: [2, 33] */
module.exports = function hasSymbols() {
	if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
	if (typeof Symbol.iterator === 'symbol') { return true; }

	var obj = {};
	var sym = Symbol('test');
	var symObj = Object(sym);
	if (typeof sym === 'string') { return false; }

	if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
	if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

	// temp disabled per https://github.com/ljharb/object.assign/issues/17
	// if (sym instanceof Symbol) { return false; }
	// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
	// if (!(symObj instanceof Symbol)) { return false; }

	// if (typeof Symbol.prototype.toString !== 'function') { return false; }
	// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

	var symVal = 42;
	obj[sym] = symVal;
	for (sym in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
	if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

	if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

	var syms = Object.getOwnPropertySymbols(obj);
	if (syms.length !== 1 || syms[0] !== sym) { return false; }

	if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

	if (typeof Object.getOwnPropertyDescriptor === 'function') {
		var descriptor = Object.getOwnPropertyDescriptor(obj, sym);
		if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
	}

	return true;
};


/***/ }),

/***/ 3082:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var toStr = Object.prototype.toString;
var hasSymbols = __webpack_require__(9905)();

if (hasSymbols) {
	var symToStr = Symbol.prototype.toString;
	var symStringRegex = /^Symbol\(.*\)$/;
	var isSymbolObject = function isRealSymbolObject(value) {
		if (typeof value.valueOf() !== 'symbol') {
			return false;
		}
		return symStringRegex.test(symToStr.call(value));
	};

	module.exports = function isSymbol(value) {
		if (typeof value === 'symbol') {
			return true;
		}
		if (toStr.call(value) !== '[object Symbol]') {
			return false;
		}
		try {
			return isSymbolObject(value);
		} catch (e) {
			return false;
		}
	};
} else {

	module.exports = function isSymbol(value) {
		// this environment does not support Symbols.
		return  false && 0;
	};
}


/***/ }),

/***/ 2527:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var whichTypedArray = __webpack_require__(4010);

/** @type {import('.')} */
module.exports = function isTypedArray(value) {
	return !!whichTypedArray(value);
};


/***/ }),

/***/ 9894:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

// Load in dependencies
var computedStyle = __webpack_require__(4827);

/**
 * Calculate the `line-height` of a given node
 * @param {HTMLElement} node Element to calculate line height of. Must be in the DOM.
 * @returns {Number} `line-height` of the element in pixels
 */
function lineHeight(node) {
  // Grab the line-height via style
  var lnHeightStr = computedStyle(node, 'line-height');
  var lnHeight = parseFloat(lnHeightStr, 10);

  // If the lineHeight did not contain a unit (i.e. it was numeric), convert it to ems (e.g. '2.3' === '2.3em')
  if (lnHeightStr === lnHeight + '') {
    // Save the old lineHeight style and update the em unit to the element
    var _lnHeightStyle = node.style.lineHeight;
    node.style.lineHeight = lnHeightStr + 'em';

    // Calculate the em based height
    lnHeightStr = computedStyle(node, 'line-height');
    lnHeight = parseFloat(lnHeightStr, 10);

    // Revert the lineHeight style
    if (_lnHeightStyle) {
      node.style.lineHeight = _lnHeightStyle;
    } else {
      delete node.style.lineHeight;
    }
  }

  // If the lineHeight is in `pt`, convert it to pixels (4px for 3pt)
  // DEV: `em` units are converted to `pt` in IE6
  // Conversion ratio from https://developer.mozilla.org/en-US/docs/Web/CSS/length
  if (lnHeightStr.indexOf('pt') !== -1) {
    lnHeight *= 4;
    lnHeight /= 3;
  // Otherwise, if the lineHeight is in `mm`, convert it to pixels (96px for 25.4mm)
  } else if (lnHeightStr.indexOf('mm') !== -1) {
    lnHeight *= 96;
    lnHeight /= 25.4;
  // Otherwise, if the lineHeight is in `cm`, convert it to pixels (96px for 2.54cm)
  } else if (lnHeightStr.indexOf('cm') !== -1) {
    lnHeight *= 96;
    lnHeight /= 2.54;
  // Otherwise, if the lineHeight is in `in`, convert it to pixels (96px for 1in)
  } else if (lnHeightStr.indexOf('in') !== -1) {
    lnHeight *= 96;
  // Otherwise, if the lineHeight is in `pc`, convert it to pixels (12pt for 1pc)
  } else if (lnHeightStr.indexOf('pc') !== -1) {
    lnHeight *= 16;
  }

  // Continue our computation
  lnHeight = Math.round(lnHeight);

  // If the line-height is "normal", calculate by font-size
  if (lnHeightStr === 'normal') {
    // Create a temporary node
    var nodeName = node.nodeName;
    var _node = document.createElement(nodeName);
    _node.innerHTML = '&nbsp;';

    // If we have a text area, reset it to only 1 row
    // https://github.com/twolfson/line-height/issues/4
    if (nodeName.toUpperCase() === 'TEXTAREA') {
      _node.setAttribute('rows', '1');
    }

    // Set the font-size of the element
    var fontSizeStr = computedStyle(node, 'font-size');
    _node.style.fontSize = fontSizeStr;

    // Remove default padding/border which can affect offset height
    // https://github.com/twolfson/line-height/issues/4
    // https://developer.mozilla.org/en-US/docs/Web/API/HTMLElement/offsetHeight
    _node.style.padding = '0px';
    _node.style.border = '0px';

    // Append it to the body
    var body = document.body;
    body.appendChild(_node);

    // Assume the line height of the element is the height
    var height = _node.offsetHeight;
    lnHeight = height;

    // Remove our child from the DOM
    body.removeChild(_node);
  }

  // Return the calculated height
  return lnHeight;
}

// Export lineHeight
module.exports = lineHeight;


/***/ }),

/***/ 7970:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__(195);


/***/ }),

/***/ 3110:
/***/ (function(module) {

"use strict";
/**
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule ExecutionEnvironment
 */

/*jslint evil: true */



var canUseDOM = !!(
  typeof window !== 'undefined' &&
  window.document &&
  window.document.createElement
);

/**
 * Simple, lightweight module assisting with the detection and context of
 * Worker. Helps avoid circular dependencies and allows code to reason about
 * whether or not they are in a Worker, even if they never include the main
 * `ReactWorker` dependency.
 */
var ExecutionEnvironment = {

  canUseDOM: canUseDOM,

  canUseWorkers: typeof Worker !== 'undefined',

  canUseEventListeners:
    canUseDOM && !!(window.addEventListener || window.attachEvent),

  canUseViewport: canUseDOM && !!window.screen,

  isInWorker: !canUseDOM // For now, this is true - might change in the future.

};

module.exports = ExecutionEnvironment;


/***/ }),

/***/ 3812:
/***/ (function(module) {

/**
 * Copyright 2004-present Facebook. All Rights Reserved.
 *
 * @providesModule UserAgent_DEPRECATED
 */

/**
 *  Provides entirely client-side User Agent and OS detection. You should prefer
 *  the non-deprecated UserAgent module when possible, which exposes our
 *  authoritative server-side PHP-based detection to the client.
 *
 *  Usage is straightforward:
 *
 *    if (UserAgent_DEPRECATED.ie()) {
 *      //  IE
 *    }
 *
 *  You can also do version checks:
 *
 *    if (UserAgent_DEPRECATED.ie() >= 7) {
 *      //  IE7 or better
 *    }
 *
 *  The browser functions will return NaN if the browser does not match, so
 *  you can also do version compares the other way:
 *
 *    if (UserAgent_DEPRECATED.ie() < 7) {
 *      //  IE6 or worse
 *    }
 *
 *  Note that the version is a float and may include a minor version number,
 *  so you should always use range operators to perform comparisons, not
 *  strict equality.
 *
 *  **Note:** You should **strongly** prefer capability detection to browser
 *  version detection where it's reasonable:
 *
 *    http://www.quirksmode.org/js/support.html
 *
 *  Further, we have a large number of mature wrapper functions and classes
 *  which abstract away many browser irregularities. Check the documentation,
 *  grep for things, or ask on javascript@lists.facebook.com before writing yet
 *  another copy of "event || window.event".
 *
 */

var _populated = false;

// Browsers
var _ie, _firefox, _opera, _webkit, _chrome;

// Actual IE browser for compatibility mode
var _ie_real_version;

// Platforms
var _osx, _windows, _linux, _android;

// Architectures
var _win64;

// Devices
var _iphone, _ipad, _native;

var _mobile;

function _populate() {
  if (_populated) {
    return;
  }

  _populated = true;

  // To work around buggy JS libraries that can't handle multi-digit
  // version numbers, Opera 10's user agent string claims it's Opera
  // 9, then later includes a Version/X.Y field:
  //
  // Opera/9.80 (foo) Presto/2.2.15 Version/10.10
  var uas = navigator.userAgent;
  var agent = /(?:MSIE.(\d+\.\d+))|(?:(?:Firefox|GranParadiso|Iceweasel).(\d+\.\d+))|(?:Opera(?:.+Version.|.)(\d+\.\d+))|(?:AppleWebKit.(\d+(?:\.\d+)?))|(?:Trident\/\d+\.\d+.*rv:(\d+\.\d+))/.exec(uas);
  var os    = /(Mac OS X)|(Windows)|(Linux)/.exec(uas);

  _iphone = /\b(iPhone|iP[ao]d)/.exec(uas);
  _ipad = /\b(iP[ao]d)/.exec(uas);
  _android = /Android/i.exec(uas);
  _native = /FBAN\/\w+;/i.exec(uas);
  _mobile = /Mobile/i.exec(uas);

  // Note that the IE team blog would have you believe you should be checking
  // for 'Win64; x64'.  But MSDN then reveals that you can actually be coming
  // from either x64 or ia64;  so ultimately, you should just check for Win64
  // as in indicator of whether you're in 64-bit IE.  32-bit IE on 64-bit
  // Windows will send 'WOW64' instead.
  _win64 = !!(/Win64/.exec(uas));

  if (agent) {
    _ie = agent[1] ? parseFloat(agent[1]) : (
          agent[5] ? parseFloat(agent[5]) : NaN);
    // IE compatibility mode
    if (_ie && document && document.documentMode) {
      _ie = document.documentMode;
    }
    // grab the "true" ie version from the trident token if available
    var trident = /(?:Trident\/(\d+.\d+))/.exec(uas);
    _ie_real_version = trident ? parseFloat(trident[1]) + 4 : _ie;

    _firefox = agent[2] ? parseFloat(agent[2]) : NaN;
    _opera   = agent[3] ? parseFloat(agent[3]) : NaN;
    _webkit  = agent[4] ? parseFloat(agent[4]) : NaN;
    if (_webkit) {
      // We do not add the regexp to the above test, because it will always
      // match 'safari' only since 'AppleWebKit' appears before 'Chrome' in
      // the userAgent string.
      agent = /(?:Chrome\/(\d+\.\d+))/.exec(uas);
      _chrome = agent && agent[1] ? parseFloat(agent[1]) : NaN;
    } else {
      _chrome = NaN;
    }
  } else {
    _ie = _firefox = _opera = _chrome = _webkit = NaN;
  }

  if (os) {
    if (os[1]) {
      // Detect OS X version.  If no version number matches, set _osx to true.
      // Version examples:  10, 10_6_1, 10.7
      // Parses version number as a float, taking only first two sets of
      // digits.  If only one set of digits is found, returns just the major
      // version number.
      var ver = /(?:Mac OS X (\d+(?:[._]\d+)?))/.exec(uas);

      _osx = ver ? parseFloat(ver[1].replace('_', '.')) : true;
    } else {
      _osx = false;
    }
    _windows = !!os[2];
    _linux   = !!os[3];
  } else {
    _osx = _windows = _linux = false;
  }
}

var UserAgent_DEPRECATED = {

  /**
   *  Check if the UA is Internet Explorer.
   *
   *
   *  @return float|NaN Version number (if match) or NaN.
   */
  ie: function() {
    return _populate() || _ie;
  },

  /**
   * Check if we're in Internet Explorer compatibility mode.
   *
   * @return bool true if in compatibility mode, false if
   * not compatibility mode or not ie
   */
  ieCompatibilityMode: function() {
    return _populate() || (_ie_real_version > _ie);
  },


  /**
   * Whether the browser is 64-bit IE.  Really, this is kind of weak sauce;  we
   * only need this because Skype can't handle 64-bit IE yet.  We need to remove
   * this when we don't need it -- tracked by #601957.
   */
  ie64: function() {
    return UserAgent_DEPRECATED.ie() && _win64;
  },

  /**
   *  Check if the UA is Firefox.
   *
   *
   *  @return float|NaN Version number (if match) or NaN.
   */
  firefox: function() {
    return _populate() || _firefox;
  },


  /**
   *  Check if the UA is Opera.
   *
   *
   *  @return float|NaN Version number (if match) or NaN.
   */
  opera: function() {
    return _populate() || _opera;
  },


  /**
   *  Check if the UA is WebKit.
   *
   *
   *  @return float|NaN Version number (if match) or NaN.
   */
  webkit: function() {
    return _populate() || _webkit;
  },

  /**
   *  For Push
   *  WILL BE REMOVED VERY SOON. Use UserAgent_DEPRECATED.webkit
   */
  safari: function() {
    return UserAgent_DEPRECATED.webkit();
  },

  /**
   *  Check if the UA is a Chrome browser.
   *
   *
   *  @return float|NaN Version number (if match) or NaN.
   */
  chrome : function() {
    return _populate() || _chrome;
  },


  /**
   *  Check if the user is running Windows.
   *
   *  @return bool `true' if the user's OS is Windows.
   */
  windows: function() {
    return _populate() || _windows;
  },


  /**
   *  Check if the user is running Mac OS X.
   *
   *  @return float|bool   Returns a float if a version number is detected,
   *                       otherwise true/false.
   */
  osx: function() {
    return _populate() || _osx;
  },

  /**
   * Check if the user is running Linux.
   *
   * @return bool `true' if the user's OS is some flavor of Linux.
   */
  linux: function() {
    return _populate() || _linux;
  },

  /**
   * Check if the user is running on an iPhone or iPod platform.
   *
   * @return bool `true' if the user is running some flavor of the
   *    iPhone OS.
   */
  iphone: function() {
    return _populate() || _iphone;
  },

  mobile: function() {
    return _populate() || (_iphone || _ipad || _android || _mobile);
  },

  nativeApp: function() {
    // webviews inside of the native apps
    return _populate() || _native;
  },

  android: function() {
    return _populate() || _android;
  },

  ipad: function() {
    return _populate() || _ipad;
  }
};

module.exports = UserAgent_DEPRECATED;


/***/ }),

/***/ 7939:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule isEventSupported
 */



var ExecutionEnvironment = __webpack_require__(3110);

var useHasFeature;
if (ExecutionEnvironment.canUseDOM) {
  useHasFeature =
    document.implementation &&
    document.implementation.hasFeature &&
    // always returns true in newer browsers as per the standard.
    // @see http://dom.spec.whatwg.org/#dom-domimplementation-hasfeature
    document.implementation.hasFeature('', '') !== true;
}

/**
 * Checks if an event is supported in the current execution environment.
 *
 * NOTE: This will not work correctly for non-generic events such as `change`,
 * `reset`, `load`, `error`, and `select`.
 *
 * Borrows from Modernizr.
 *
 * @param {string} eventNameSuffix Event name, e.g. "click".
 * @param {?boolean} capture Check if the capture phase is supported.
 * @return {boolean} True if the event is supported.
 * @internal
 * @license Modernizr 3.0.0pre (Custom Build) | MIT
 */
function isEventSupported(eventNameSuffix, capture) {
  if (!ExecutionEnvironment.canUseDOM ||
      capture && !('addEventListener' in document)) {
    return false;
  }

  var eventName = 'on' + eventNameSuffix;
  var isSupported = eventName in document;

  if (!isSupported) {
    var element = document.createElement('div');
    element.setAttribute(eventName, 'return;');
    isSupported = typeof element[eventName] === 'function';
  }

  if (!isSupported && useHasFeature && eventNameSuffix === 'wheel') {
    // This is the only way to test support for the `wheel` event in IE9+.
    isSupported = document.implementation.hasFeature('Events.wheel', '3.0');
  }

  return isSupported;
}

module.exports = isEventSupported;


/***/ }),

/***/ 195:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";
/**
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule normalizeWheel
 * @typechecks
 */



var UserAgent_DEPRECATED = __webpack_require__(3812);

var isEventSupported = __webpack_require__(7939);


// Reasonable defaults
var PIXEL_STEP  = 10;
var LINE_HEIGHT = 40;
var PAGE_HEIGHT = 800;

/**
 * Mouse wheel (and 2-finger trackpad) support on the web sucks.  It is
 * complicated, thus this doc is long and (hopefully) detailed enough to answer
 * your questions.
 *
 * If you need to react to the mouse wheel in a predictable way, this code is
 * like your bestest friend. * hugs *
 *
 * As of today, there are 4 DOM event types you can listen to:
 *
 *   'wheel'                -- Chrome(31+), FF(17+), IE(9+)
 *   'mousewheel'           -- Chrome, IE(6+), Opera, Safari
 *   'MozMousePixelScroll'  -- FF(3.5 only!) (2010-2013) -- don't bother!
 *   'DOMMouseScroll'       -- FF(0.9.7+) since 2003
 *
 * So what to do?  The is the best:
 *
 *   normalizeWheel.getEventType();
 *
 * In your event callback, use this code to get sane interpretation of the
 * deltas.  This code will return an object with properties:
 *
 *   spinX   -- normalized spin speed (use for zoom) - x plane
 *   spinY   -- " - y plane
 *   pixelX  -- normalized distance (to pixels) - x plane
 *   pixelY  -- " - y plane
 *
 * Wheel values are provided by the browser assuming you are using the wheel to
 * scroll a web page by a number of lines or pixels (or pages).  Values can vary
 * significantly on different platforms and browsers, forgetting that you can
 * scroll at different speeds.  Some devices (like trackpads) emit more events
 * at smaller increments with fine granularity, and some emit massive jumps with
 * linear speed or acceleration.
 *
 * This code does its best to normalize the deltas for you:
 *
 *   - spin is trying to normalize how far the wheel was spun (or trackpad
 *     dragged).  This is super useful for zoom support where you want to
 *     throw away the chunky scroll steps on the PC and make those equal to
 *     the slow and smooth tiny steps on the Mac. Key data: This code tries to
 *     resolve a single slow step on a wheel to 1.
 *
 *   - pixel is normalizing the desired scroll delta in pixel units.  You'll
 *     get the crazy differences between browsers, but at least it'll be in
 *     pixels!
 *
 *   - positive value indicates scrolling DOWN/RIGHT, negative UP/LEFT.  This
 *     should translate to positive value zooming IN, negative zooming OUT.
 *     This matches the newer 'wheel' event.
 *
 * Why are there spinX, spinY (or pixels)?
 *
 *   - spinX is a 2-finger side drag on the trackpad, and a shift + wheel turn
 *     with a mouse.  It results in side-scrolling in the browser by default.
 *
 *   - spinY is what you expect -- it's the classic axis of a mouse wheel.
 *
 *   - I dropped spinZ/pixelZ.  It is supported by the DOM 3 'wheel' event and
 *     probably is by browsers in conjunction with fancy 3D controllers .. but
 *     you know.
 *
 * Implementation info:
 *
 * Examples of 'wheel' event if you scroll slowly (down) by one step with an
 * average mouse:
 *
 *   OS X + Chrome  (mouse)     -    4   pixel delta  (wheelDelta -120)
 *   OS X + Safari  (mouse)     -  N/A   pixel delta  (wheelDelta  -12)
 *   OS X + Firefox (mouse)     -    0.1 line  delta  (wheelDelta  N/A)
 *   Win8 + Chrome  (mouse)     -  100   pixel delta  (wheelDelta -120)
 *   Win8 + Firefox (mouse)     -    3   line  delta  (wheelDelta -120)
 *
 * On the trackpad:
 *
 *   OS X + Chrome  (trackpad)  -    2   pixel delta  (wheelDelta   -6)
 *   OS X + Firefox (trackpad)  -    1   pixel delta  (wheelDelta  N/A)
 *
 * On other/older browsers.. it's more complicated as there can be multiple and
 * also missing delta values.
 *
 * The 'wheel' event is more standard:
 *
 * http://www.w3.org/TR/DOM-Level-3-Events/#events-wheelevents
 *
 * The basics is that it includes a unit, deltaMode (pixels, lines, pages), and
 * deltaX, deltaY and deltaZ.  Some browsers provide other values to maintain
 * backward compatibility with older events.  Those other values help us
 * better normalize spin speed.  Example of what the browsers provide:
 *
 *                          | event.wheelDelta | event.detail
 *        ------------------+------------------+--------------
 *          Safari v5/OS X  |       -120       |       0
 *          Safari v5/Win7  |       -120       |       0
 *         Chrome v17/OS X  |       -120       |       0
 *         Chrome v17/Win7  |       -120       |       0
 *                IE9/Win7  |       -120       |   undefined
 *         Firefox v4/OS X  |     undefined    |       1
 *         Firefox v4/Win7  |     undefined    |       3
 *
 */
function normalizeWheel(/*object*/ event) /*object*/ {
  var sX = 0, sY = 0,       // spinX, spinY
      pX = 0, pY = 0;       // pixelX, pixelY

  // Legacy
  if ('detail'      in event) { sY = event.detail; }
  if ('wheelDelta'  in event) { sY = -event.wheelDelta / 120; }
  if ('wheelDeltaY' in event) { sY = -event.wheelDeltaY / 120; }
  if ('wheelDeltaX' in event) { sX = -event.wheelDeltaX / 120; }

  // side scrolling on FF with DOMMouseScroll
  if ( 'axis' in event && event.axis === event.HORIZONTAL_AXIS ) {
    sX = sY;
    sY = 0;
  }

  pX = sX * PIXEL_STEP;
  pY = sY * PIXEL_STEP;

  if ('deltaY' in event) { pY = event.deltaY; }
  if ('deltaX' in event) { pX = event.deltaX; }

  if ((pX || pY) && event.deltaMode) {
    if (event.deltaMode == 1) {          // delta in LINE units
      pX *= LINE_HEIGHT;
      pY *= LINE_HEIGHT;
    } else {                             // delta in PAGE units
      pX *= PAGE_HEIGHT;
      pY *= PAGE_HEIGHT;
    }
  }

  // Fall-back if spin cannot be determined
  if (pX && !sX) { sX = (pX < 1) ? -1 : 1; }
  if (pY && !sY) { sY = (pY < 1) ? -1 : 1; }

  return { spinX  : sX,
           spinY  : sY,
           pixelX : pX,
           pixelY : pY };
}


/**
 * The best combination if you prefer spinX + spinY normalization.  It favors
 * the older DOMMouseScroll for Firefox, as FF does not include wheelDelta with
 * 'wheel' event, making spin speed determination impossible.
 */
normalizeWheel.getEventType = function() /*string*/ {
  return (UserAgent_DEPRECATED.firefox())
           ? 'DOMMouseScroll'
           : (isEventSupported('wheel'))
               ? 'wheel'
               : 'mousewheel';
};

module.exports = normalizeWheel;


/***/ }),

/***/ 8383:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var keysShim;
if (!Object.keys) {
	// modified from https://github.com/es-shims/es5-shim
	var has = Object.prototype.hasOwnProperty;
	var toStr = Object.prototype.toString;
	var isArgs = __webpack_require__(4418); // eslint-disable-line global-require
	var isEnumerable = Object.prototype.propertyIsEnumerable;
	var hasDontEnumBug = !isEnumerable.call({ toString: null }, 'toString');
	var hasProtoEnumBug = isEnumerable.call(function () {}, 'prototype');
	var dontEnums = [
		'toString',
		'toLocaleString',
		'valueOf',
		'hasOwnProperty',
		'isPrototypeOf',
		'propertyIsEnumerable',
		'constructor'
	];
	var equalsConstructorPrototype = function (o) {
		var ctor = o.constructor;
		return ctor && ctor.prototype === o;
	};
	var excludedKeys = {
		$applicationCache: true,
		$console: true,
		$external: true,
		$frame: true,
		$frameElement: true,
		$frames: true,
		$innerHeight: true,
		$innerWidth: true,
		$onmozfullscreenchange: true,
		$onmozfullscreenerror: true,
		$outerHeight: true,
		$outerWidth: true,
		$pageXOffset: true,
		$pageYOffset: true,
		$parent: true,
		$scrollLeft: true,
		$scrollTop: true,
		$scrollX: true,
		$scrollY: true,
		$self: true,
		$webkitIndexedDB: true,
		$webkitStorageInfo: true,
		$window: true
	};
	var hasAutomationEqualityBug = (function () {
		/* global window */
		if (typeof window === 'undefined') { return false; }
		for (var k in window) {
			try {
				if (!excludedKeys['$' + k] && has.call(window, k) && window[k] !== null && typeof window[k] === 'object') {
					try {
						equalsConstructorPrototype(window[k]);
					} catch (e) {
						return true;
					}
				}
			} catch (e) {
				return true;
			}
		}
		return false;
	}());
	var equalsConstructorPrototypeIfNotBuggy = function (o) {
		/* global window */
		if (typeof window === 'undefined' || !hasAutomationEqualityBug) {
			return equalsConstructorPrototype(o);
		}
		try {
			return equalsConstructorPrototype(o);
		} catch (e) {
			return false;
		}
	};

	keysShim = function keys(object) {
		var isObject = object !== null && typeof object === 'object';
		var isFunction = toStr.call(object) === '[object Function]';
		var isArguments = isArgs(object);
		var isString = isObject && toStr.call(object) === '[object String]';
		var theKeys = [];

		if (!isObject && !isFunction && !isArguments) {
			throw new TypeError('Object.keys called on a non-object');
		}

		var skipProto = hasProtoEnumBug && isFunction;
		if (isString && object.length > 0 && !has.call(object, 0)) {
			for (var i = 0; i < object.length; ++i) {
				theKeys.push(String(i));
			}
		}

		if (isArguments && object.length > 0) {
			for (var j = 0; j < object.length; ++j) {
				theKeys.push(String(j));
			}
		} else {
			for (var name in object) {
				if (!(skipProto && name === 'prototype') && has.call(object, name)) {
					theKeys.push(String(name));
				}
			}
		}

		if (hasDontEnumBug) {
			var skipConstructor = equalsConstructorPrototypeIfNotBuggy(object);

			for (var k = 0; k < dontEnums.length; ++k) {
				if (!(skipConstructor && dontEnums[k] === 'constructor') && has.call(object, dontEnums[k])) {
					theKeys.push(dontEnums[k]);
				}
			}
		}
		return theKeys;
	};
}
module.exports = keysShim;


/***/ }),

/***/ 806:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var slice = Array.prototype.slice;
var isArgs = __webpack_require__(4418);

var origKeys = Object.keys;
var keysShim = origKeys ? function keys(o) { return origKeys(o); } : __webpack_require__(8383);

var originalKeys = Object.keys;

keysShim.shim = function shimObjectKeys() {
	if (Object.keys) {
		var keysWorksWithArguments = (function () {
			// Safari 5.0 bug
			var args = Object.keys(arguments);
			return args && args.length === arguments.length;
		}(1, 2));
		if (!keysWorksWithArguments) {
			Object.keys = function keys(object) { // eslint-disable-line func-name-matching
				if (isArgs(object)) {
					return originalKeys(slice.call(object));
				}
				return originalKeys(object);
			};
		}
	} else {
		Object.keys = keysShim;
	}
	return Object.keys || keysShim;
};

module.exports = keysShim;


/***/ }),

/***/ 4418:
/***/ (function(module) {

"use strict";


var toStr = Object.prototype.toString;

module.exports = function isArguments(value) {
	var str = toStr.call(value);
	var isArgs = str === '[object Arguments]';
	if (!isArgs) {
		isArgs = str !== '[object Array]' &&
			value !== null &&
			typeof value === 'object' &&
			typeof value.length === 'number' &&
			value.length >= 0 &&
			toStr.call(value.callee) === '[object Function]';
	}
	return isArgs;
};


/***/ }),

/***/ 131:
/***/ (function(module) {

"use strict";


/** @type {import('.')} */
module.exports = [
	'Float32Array',
	'Float64Array',
	'Int8Array',
	'Int16Array',
	'Int32Array',
	'Uint8Array',
	'Uint8ClampedArray',
	'Uint16Array',
	'Uint32Array',
	'BigInt64Array',
	'BigUint64Array'
];


/***/ }),

/***/ 5372:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var ReactPropTypesSecret = __webpack_require__(9567);

function emptyFunction() {}
function emptyFunctionWithReset() {}
emptyFunctionWithReset.resetWarningCache = emptyFunction;

module.exports = function() {
  function shim(props, propName, componentName, location, propFullName, secret) {
    if (secret === ReactPropTypesSecret) {
      // It is still safe when called from React.
      return;
    }
    var err = new Error(
      'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
      'Use PropTypes.checkPropTypes() to call them. ' +
      'Read more at http://fb.me/use-check-prop-types'
    );
    err.name = 'Invariant Violation';
    throw err;
  };
  shim.isRequired = shim;
  function getShim() {
    return shim;
  };
  // Important!
  // Keep this list in sync with production version in `./factoryWithTypeCheckers.js`.
  var ReactPropTypes = {
    array: shim,
    bigint: shim,
    bool: shim,
    func: shim,
    number: shim,
    object: shim,
    string: shim,
    symbol: shim,

    any: shim,
    arrayOf: getShim,
    element: shim,
    elementType: shim,
    instanceOf: getShim,
    node: shim,
    objectOf: getShim,
    oneOf: getShim,
    oneOfType: getShim,
    shape: getShim,
    exact: getShim,

    checkPropTypes: emptyFunctionWithReset,
    resetWarningCache: emptyFunction
  };

  ReactPropTypes.PropTypes = ReactPropTypes;

  return ReactPropTypes;
};


/***/ }),

/***/ 2652:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

if (false) { var throwOnDirectAccess, ReactIs; } else {
  // By explicitly using `prop-types` you are opting into new production behavior.
  // http://fb.me/prop-types-in-prod
  module.exports = __webpack_require__(5372)();
}


/***/ }),

/***/ 9567:
/***/ (function(module) {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var ReactPropTypesSecret = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';

module.exports = ReactPropTypesSecret;


/***/ }),

/***/ 5438:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
exports.__esModule = true;
var React = __webpack_require__(9196);
var PropTypes = __webpack_require__(2652);
var autosize = __webpack_require__(6411);
var _getLineHeight = __webpack_require__(9894);
var getLineHeight = _getLineHeight;
var RESIZED = "autosize:resized";
/**
 * A light replacement for built-in textarea component
 * which automaticaly adjusts its height to match the content
 */
var TextareaAutosizeClass = /** @class */ (function (_super) {
    __extends(TextareaAutosizeClass, _super);
    function TextareaAutosizeClass() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            lineHeight: null
        };
        _this.textarea = null;
        _this.onResize = function (e) {
            if (_this.props.onResize) {
                _this.props.onResize(e);
            }
        };
        _this.updateLineHeight = function () {
            if (_this.textarea) {
                _this.setState({
                    lineHeight: getLineHeight(_this.textarea)
                });
            }
        };
        _this.onChange = function (e) {
            var onChange = _this.props.onChange;
            _this.currentValue = e.currentTarget.value;
            onChange && onChange(e);
        };
        return _this;
    }
    TextareaAutosizeClass.prototype.componentDidMount = function () {
        var _this = this;
        var _a = this.props, maxRows = _a.maxRows, async = _a.async;
        if (typeof maxRows === "number") {
            this.updateLineHeight();
        }
        if (typeof maxRows === "number" || async) {
            /*
              the defer is needed to:
                - force "autosize" to activate the scrollbar when this.props.maxRows is passed
                - support StyledComponents (see #71)
            */
            setTimeout(function () { return _this.textarea && autosize(_this.textarea); });
        }
        else {
            this.textarea && autosize(this.textarea);
        }
        if (this.textarea) {
            this.textarea.addEventListener(RESIZED, this.onResize);
        }
    };
    TextareaAutosizeClass.prototype.componentWillUnmount = function () {
        if (this.textarea) {
            this.textarea.removeEventListener(RESIZED, this.onResize);
            autosize.destroy(this.textarea);
        }
    };
    TextareaAutosizeClass.prototype.render = function () {
        var _this = this;
        var _a = this, _b = _a.props, onResize = _b.onResize, maxRows = _b.maxRows, onChange = _b.onChange, style = _b.style, innerRef = _b.innerRef, children = _b.children, props = __rest(_b, ["onResize", "maxRows", "onChange", "style", "innerRef", "children"]), lineHeight = _a.state.lineHeight;
        var maxHeight = maxRows && lineHeight ? lineHeight * maxRows : null;
        return (React.createElement("textarea", __assign({}, props, { onChange: this.onChange, style: maxHeight ? __assign({}, style, { maxHeight: maxHeight }) : style, ref: function (element) {
                _this.textarea = element;
                if (typeof _this.props.innerRef === 'function') {
                    _this.props.innerRef(element);
                }
                else if (_this.props.innerRef) {
                    _this.props.innerRef.current = element;
                }
            } }), children));
    };
    TextareaAutosizeClass.prototype.componentDidUpdate = function () {
        this.textarea && autosize.update(this.textarea);
    };
    TextareaAutosizeClass.defaultProps = {
        rows: 1,
        async: false
    };
    TextareaAutosizeClass.propTypes = {
        rows: PropTypes.number,
        maxRows: PropTypes.number,
        onResize: PropTypes.func,
        innerRef: PropTypes.any,
        async: PropTypes.bool
    };
    return TextareaAutosizeClass;
}(React.Component));
exports.TextareaAutosize = React.forwardRef(function (props, ref) {
    return React.createElement(TextareaAutosizeClass, __assign({}, props, { innerRef: ref }));
});


/***/ }),

/***/ 773:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
var __webpack_unused_export__;

__webpack_unused_export__ = true;
var TextareaAutosize_1 = __webpack_require__(5438);
exports.Z = TextareaAutosize_1.TextareaAutosize;


/***/ }),

/***/ 4793:
/***/ (function(module) {

var characterMap = {
	"À": "A",
	"Á": "A",
	"Â": "A",
	"Ã": "A",
	"Ä": "A",
	"Å": "A",
	"Ấ": "A",
	"Ắ": "A",
	"Ẳ": "A",
	"Ẵ": "A",
	"Ặ": "A",
	"Æ": "AE",
	"Ầ": "A",
	"Ằ": "A",
	"Ȃ": "A",
	"Ç": "C",
	"Ḉ": "C",
	"È": "E",
	"É": "E",
	"Ê": "E",
	"Ë": "E",
	"Ế": "E",
	"Ḗ": "E",
	"Ề": "E",
	"Ḕ": "E",
	"Ḝ": "E",
	"Ȇ": "E",
	"Ì": "I",
	"Í": "I",
	"Î": "I",
	"Ï": "I",
	"Ḯ": "I",
	"Ȋ": "I",
	"Ð": "D",
	"Ñ": "N",
	"Ò": "O",
	"Ó": "O",
	"Ô": "O",
	"Õ": "O",
	"Ö": "O",
	"Ø": "O",
	"Ố": "O",
	"Ṍ": "O",
	"Ṓ": "O",
	"Ȏ": "O",
	"Ù": "U",
	"Ú": "U",
	"Û": "U",
	"Ü": "U",
	"Ý": "Y",
	"à": "a",
	"á": "a",
	"â": "a",
	"ã": "a",
	"ä": "a",
	"å": "a",
	"ấ": "a",
	"ắ": "a",
	"ẳ": "a",
	"ẵ": "a",
	"ặ": "a",
	"æ": "ae",
	"ầ": "a",
	"ằ": "a",
	"ȃ": "a",
	"ç": "c",
	"ḉ": "c",
	"è": "e",
	"é": "e",
	"ê": "e",
	"ë": "e",
	"ế": "e",
	"ḗ": "e",
	"ề": "e",
	"ḕ": "e",
	"ḝ": "e",
	"ȇ": "e",
	"ì": "i",
	"í": "i",
	"î": "i",
	"ï": "i",
	"ḯ": "i",
	"ȋ": "i",
	"ð": "d",
	"ñ": "n",
	"ò": "o",
	"ó": "o",
	"ô": "o",
	"õ": "o",
	"ö": "o",
	"ø": "o",
	"ố": "o",
	"ṍ": "o",
	"ṓ": "o",
	"ȏ": "o",
	"ù": "u",
	"ú": "u",
	"û": "u",
	"ü": "u",
	"ý": "y",
	"ÿ": "y",
	"Ā": "A",
	"ā": "a",
	"Ă": "A",
	"ă": "a",
	"Ą": "A",
	"ą": "a",
	"Ć": "C",
	"ć": "c",
	"Ĉ": "C",
	"ĉ": "c",
	"Ċ": "C",
	"ċ": "c",
	"Č": "C",
	"č": "c",
	"C̆": "C",
	"c̆": "c",
	"Ď": "D",
	"ď": "d",
	"Đ": "D",
	"đ": "d",
	"Ē": "E",
	"ē": "e",
	"Ĕ": "E",
	"ĕ": "e",
	"Ė": "E",
	"ė": "e",
	"Ę": "E",
	"ę": "e",
	"Ě": "E",
	"ě": "e",
	"Ĝ": "G",
	"Ǵ": "G",
	"ĝ": "g",
	"ǵ": "g",
	"Ğ": "G",
	"ğ": "g",
	"Ġ": "G",
	"ġ": "g",
	"Ģ": "G",
	"ģ": "g",
	"Ĥ": "H",
	"ĥ": "h",
	"Ħ": "H",
	"ħ": "h",
	"Ḫ": "H",
	"ḫ": "h",
	"Ĩ": "I",
	"ĩ": "i",
	"Ī": "I",
	"ī": "i",
	"Ĭ": "I",
	"ĭ": "i",
	"Į": "I",
	"į": "i",
	"İ": "I",
	"ı": "i",
	"Ĳ": "IJ",
	"ĳ": "ij",
	"Ĵ": "J",
	"ĵ": "j",
	"Ķ": "K",
	"ķ": "k",
	"Ḱ": "K",
	"ḱ": "k",
	"K̆": "K",
	"k̆": "k",
	"Ĺ": "L",
	"ĺ": "l",
	"Ļ": "L",
	"ļ": "l",
	"Ľ": "L",
	"ľ": "l",
	"Ŀ": "L",
	"ŀ": "l",
	"Ł": "l",
	"ł": "l",
	"Ḿ": "M",
	"ḿ": "m",
	"M̆": "M",
	"m̆": "m",
	"Ń": "N",
	"ń": "n",
	"Ņ": "N",
	"ņ": "n",
	"Ň": "N",
	"ň": "n",
	"ŉ": "n",
	"N̆": "N",
	"n̆": "n",
	"Ō": "O",
	"ō": "o",
	"Ŏ": "O",
	"ŏ": "o",
	"Ő": "O",
	"ő": "o",
	"Œ": "OE",
	"œ": "oe",
	"P̆": "P",
	"p̆": "p",
	"Ŕ": "R",
	"ŕ": "r",
	"Ŗ": "R",
	"ŗ": "r",
	"Ř": "R",
	"ř": "r",
	"R̆": "R",
	"r̆": "r",
	"Ȓ": "R",
	"ȓ": "r",
	"Ś": "S",
	"ś": "s",
	"Ŝ": "S",
	"ŝ": "s",
	"Ş": "S",
	"Ș": "S",
	"ș": "s",
	"ş": "s",
	"Š": "S",
	"š": "s",
	"ß": "ss",
	"Ţ": "T",
	"ţ": "t",
	"ț": "t",
	"Ț": "T",
	"Ť": "T",
	"ť": "t",
	"Ŧ": "T",
	"ŧ": "t",
	"T̆": "T",
	"t̆": "t",
	"Ũ": "U",
	"ũ": "u",
	"Ū": "U",
	"ū": "u",
	"Ŭ": "U",
	"ŭ": "u",
	"Ů": "U",
	"ů": "u",
	"Ű": "U",
	"ű": "u",
	"Ų": "U",
	"ų": "u",
	"Ȗ": "U",
	"ȗ": "u",
	"V̆": "V",
	"v̆": "v",
	"Ŵ": "W",
	"ŵ": "w",
	"Ẃ": "W",
	"ẃ": "w",
	"X̆": "X",
	"x̆": "x",
	"Ŷ": "Y",
	"ŷ": "y",
	"Ÿ": "Y",
	"Y̆": "Y",
	"y̆": "y",
	"Ź": "Z",
	"ź": "z",
	"Ż": "Z",
	"ż": "z",
	"Ž": "Z",
	"ž": "z",
	"ſ": "s",
	"ƒ": "f",
	"Ơ": "O",
	"ơ": "o",
	"Ư": "U",
	"ư": "u",
	"Ǎ": "A",
	"ǎ": "a",
	"Ǐ": "I",
	"ǐ": "i",
	"Ǒ": "O",
	"ǒ": "o",
	"Ǔ": "U",
	"ǔ": "u",
	"Ǖ": "U",
	"ǖ": "u",
	"Ǘ": "U",
	"ǘ": "u",
	"Ǚ": "U",
	"ǚ": "u",
	"Ǜ": "U",
	"ǜ": "u",
	"Ứ": "U",
	"ứ": "u",
	"Ṹ": "U",
	"ṹ": "u",
	"Ǻ": "A",
	"ǻ": "a",
	"Ǽ": "AE",
	"ǽ": "ae",
	"Ǿ": "O",
	"ǿ": "o",
	"Þ": "TH",
	"þ": "th",
	"Ṕ": "P",
	"ṕ": "p",
	"Ṥ": "S",
	"ṥ": "s",
	"X́": "X",
	"x́": "x",
	"Ѓ": "Г",
	"ѓ": "г",
	"Ќ": "К",
	"ќ": "к",
	"A̋": "A",
	"a̋": "a",
	"E̋": "E",
	"e̋": "e",
	"I̋": "I",
	"i̋": "i",
	"Ǹ": "N",
	"ǹ": "n",
	"Ồ": "O",
	"ồ": "o",
	"Ṑ": "O",
	"ṑ": "o",
	"Ừ": "U",
	"ừ": "u",
	"Ẁ": "W",
	"ẁ": "w",
	"Ỳ": "Y",
	"ỳ": "y",
	"Ȁ": "A",
	"ȁ": "a",
	"Ȅ": "E",
	"ȅ": "e",
	"Ȉ": "I",
	"ȉ": "i",
	"Ȍ": "O",
	"ȍ": "o",
	"Ȑ": "R",
	"ȑ": "r",
	"Ȕ": "U",
	"ȕ": "u",
	"B̌": "B",
	"b̌": "b",
	"Č̣": "C",
	"č̣": "c",
	"Ê̌": "E",
	"ê̌": "e",
	"F̌": "F",
	"f̌": "f",
	"Ǧ": "G",
	"ǧ": "g",
	"Ȟ": "H",
	"ȟ": "h",
	"J̌": "J",
	"ǰ": "j",
	"Ǩ": "K",
	"ǩ": "k",
	"M̌": "M",
	"m̌": "m",
	"P̌": "P",
	"p̌": "p",
	"Q̌": "Q",
	"q̌": "q",
	"Ř̩": "R",
	"ř̩": "r",
	"Ṧ": "S",
	"ṧ": "s",
	"V̌": "V",
	"v̌": "v",
	"W̌": "W",
	"w̌": "w",
	"X̌": "X",
	"x̌": "x",
	"Y̌": "Y",
	"y̌": "y",
	"A̧": "A",
	"a̧": "a",
	"B̧": "B",
	"b̧": "b",
	"Ḑ": "D",
	"ḑ": "d",
	"Ȩ": "E",
	"ȩ": "e",
	"Ɛ̧": "E",
	"ɛ̧": "e",
	"Ḩ": "H",
	"ḩ": "h",
	"I̧": "I",
	"i̧": "i",
	"Ɨ̧": "I",
	"ɨ̧": "i",
	"M̧": "M",
	"m̧": "m",
	"O̧": "O",
	"o̧": "o",
	"Q̧": "Q",
	"q̧": "q",
	"U̧": "U",
	"u̧": "u",
	"X̧": "X",
	"x̧": "x",
	"Z̧": "Z",
	"z̧": "z",
	"й":"и",
	"Й":"И",
	"ё":"е",
	"Ё":"Е",
};

var chars = Object.keys(characterMap).join('|');
var allAccents = new RegExp(chars, 'g');
var firstAccent = new RegExp(chars, '');

function matcher(match) {
	return characterMap[match];
}

var removeAccents = function(string) {	
	return string.replace(allAccents, matcher);
};

var hasAccents = function(string) {
	return !!string.match(firstAccent);
};

module.exports = removeAccents;
module.exports.has = hasAccents;
module.exports.remove = removeAccents;


/***/ }),

/***/ 3002:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(8024);
var $concat = GetIntrinsic('%Array.prototype.concat%');

var callBind = __webpack_require__(9386);

var callBound = __webpack_require__(3315);
var $slice = callBound('Array.prototype.slice');

var hasSymbols = __webpack_require__(1489)();
var isConcatSpreadable = hasSymbols && Symbol.isConcatSpreadable;

/** @type {never[]} */ var empty = [];
var $concatApply = isConcatSpreadable ? callBind.apply($concat, empty) : null;

// eslint-disable-next-line no-extra-parens
var isArray = isConcatSpreadable ? /** @type {(value: unknown) => value is unknown[]} */ (__webpack_require__(9277)) : null;

/** @type {import('.')} */
module.exports = isConcatSpreadable
	// eslint-disable-next-line no-unused-vars
	? function safeArrayConcat(item) {
		for (var i = 0; i < arguments.length; i += 1) {
			/** @type {typeof item} */ var arg = arguments[i];
			// @ts-expect-error ts(2538) see https://github.com/microsoft/TypeScript/issues/9998#issuecomment-1890787975; works if `const`
			if (arg && typeof arg === 'object' && typeof arg[isConcatSpreadable] === 'boolean') {
				// @ts-expect-error ts(7015) TS doesn't yet support Symbol indexing
				if (!empty[isConcatSpreadable]) {
					// @ts-expect-error ts(7015) TS doesn't yet support Symbol indexing
					empty[isConcatSpreadable] = true;
				}
				// @ts-expect-error ts(2721) ts(18047) not sure why TS can't figure out this can't be null
				var arr = isArray(arg) ? $slice(arg) : [arg];
				// @ts-expect-error ts(7015) TS can't handle expandos on an array
				arr[isConcatSpreadable] = true; // shadow the property. TODO: use [[Define]]
				arguments[i] = arr;
			}
		}
		// @ts-expect-error ts(2345) https://github.com/microsoft/TypeScript/issues/57164 TS doesn't understand that apply can take an arguments object
		return $concatApply(arguments);
	}
	: callBind($concat, empty);


/***/ }),

/***/ 3315:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(8024);

var callBind = __webpack_require__(9386);

var $indexOf = callBind(GetIntrinsic('String.prototype.indexOf'));

module.exports = function callBoundIntrinsic(name, allowMissing) {
	var intrinsic = GetIntrinsic(name, !!allowMissing);
	if (typeof intrinsic === 'function' && $indexOf(name, '.prototype.') > -1) {
		return callBind(intrinsic);
	}
	return intrinsic;
};


/***/ }),

/***/ 9386:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var bind = __webpack_require__(5127);
var GetIntrinsic = __webpack_require__(8024);
var setFunctionLength = __webpack_require__(4521);

var $TypeError = __webpack_require__(1642);
var $apply = GetIntrinsic('%Function.prototype.apply%');
var $call = GetIntrinsic('%Function.prototype.call%');
var $reflectApply = GetIntrinsic('%Reflect.apply%', true) || bind.call($call, $apply);

var $defineProperty = __webpack_require__(8918);
var $max = GetIntrinsic('%Math.max%');

module.exports = function callBind(originalFunction) {
	if (typeof originalFunction !== 'function') {
		throw new $TypeError('a function is required');
	}
	var func = $reflectApply(bind, $call, arguments);
	return setFunctionLength(
		func,
		1 + $max(0, originalFunction.length - (arguments.length - 1)),
		true
	);
};

var applyBind = function applyBind() {
	return $reflectApply(bind, $apply, arguments);
};

if ($defineProperty) {
	$defineProperty(module.exports, 'apply', { value: applyBind });
} else {
	module.exports.apply = applyBind;
}


/***/ }),

/***/ 6850:
/***/ (function(module) {

"use strict";


/* eslint no-invalid-this: 1 */

var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
var toStr = Object.prototype.toString;
var max = Math.max;
var funcType = '[object Function]';

var concatty = function concatty(a, b) {
    var arr = [];

    for (var i = 0; i < a.length; i += 1) {
        arr[i] = a[i];
    }
    for (var j = 0; j < b.length; j += 1) {
        arr[j + a.length] = b[j];
    }

    return arr;
};

var slicy = function slicy(arrLike, offset) {
    var arr = [];
    for (var i = offset || 0, j = 0; i < arrLike.length; i += 1, j += 1) {
        arr[j] = arrLike[i];
    }
    return arr;
};

var joiny = function (arr, joiner) {
    var str = '';
    for (var i = 0; i < arr.length; i += 1) {
        str += arr[i];
        if (i + 1 < arr.length) {
            str += joiner;
        }
    }
    return str;
};

module.exports = function bind(that) {
    var target = this;
    if (typeof target !== 'function' || toStr.apply(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
    }
    var args = slicy(arguments, 1);

    var bound;
    var binder = function () {
        if (this instanceof bound) {
            var result = target.apply(
                this,
                concatty(args, arguments)
            );
            if (Object(result) === result) {
                return result;
            }
            return this;
        }
        return target.apply(
            that,
            concatty(args, arguments)
        );

    };

    var boundLength = max(0, target.length - args.length);
    var boundArgs = [];
    for (var i = 0; i < boundLength; i++) {
        boundArgs[i] = '$' + i;
    }

    bound = Function('binder', 'return function (' + joiny(boundArgs, ',') + '){ return binder.apply(this,arguments); }')(binder);

    if (target.prototype) {
        var Empty = function Empty() {};
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
    }

    return bound;
};


/***/ }),

/***/ 5127:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var implementation = __webpack_require__(6850);

module.exports = Function.prototype.bind || implementation;


/***/ }),

/***/ 8024:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var undefined;

var $Error = __webpack_require__(6716);
var $EvalError = __webpack_require__(6788);
var $RangeError = __webpack_require__(9204);
var $ReferenceError = __webpack_require__(9908);
var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);
var $URIError = __webpack_require__(1451);

var $Function = Function;

// eslint-disable-next-line consistent-return
var getEvalledConstructor = function (expressionSyntax) {
	try {
		return $Function('"use strict"; return (' + expressionSyntax + ').constructor;')();
	} catch (e) {}
};

var $gOPD = Object.getOwnPropertyDescriptor;
if ($gOPD) {
	try {
		$gOPD({}, '');
	} catch (e) {
		$gOPD = null; // this is IE 8, which has a broken gOPD
	}
}

var throwTypeError = function () {
	throw new $TypeError();
};
var ThrowTypeError = $gOPD
	? (function () {
		try {
			// eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
			arguments.callee; // IE 8 does not throw here
			return throwTypeError;
		} catch (calleeThrows) {
			try {
				// IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
				return $gOPD(arguments, 'callee').get;
			} catch (gOPDthrows) {
				return throwTypeError;
			}
		}
	}())
	: throwTypeError;

var hasSymbols = __webpack_require__(330)();
var hasProto = __webpack_require__(1856)();

var getProto = Object.getPrototypeOf || (
	hasProto
		? function (x) { return x.__proto__; } // eslint-disable-line no-proto
		: null
);

var needsEval = {};

var TypedArray = typeof Uint8Array === 'undefined' || !getProto ? undefined : getProto(Uint8Array);

var INTRINSICS = {
	__proto__: null,
	'%AggregateError%': typeof AggregateError === 'undefined' ? undefined : AggregateError,
	'%Array%': Array,
	'%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined : ArrayBuffer,
	'%ArrayIteratorPrototype%': hasSymbols && getProto ? getProto([][Symbol.iterator]()) : undefined,
	'%AsyncFromSyncIteratorPrototype%': undefined,
	'%AsyncFunction%': needsEval,
	'%AsyncGenerator%': needsEval,
	'%AsyncGeneratorFunction%': needsEval,
	'%AsyncIteratorPrototype%': needsEval,
	'%Atomics%': typeof Atomics === 'undefined' ? undefined : Atomics,
	'%BigInt%': typeof BigInt === 'undefined' ? undefined : BigInt,
	'%BigInt64Array%': typeof BigInt64Array === 'undefined' ? undefined : BigInt64Array,
	'%BigUint64Array%': typeof BigUint64Array === 'undefined' ? undefined : BigUint64Array,
	'%Boolean%': Boolean,
	'%DataView%': typeof DataView === 'undefined' ? undefined : DataView,
	'%Date%': Date,
	'%decodeURI%': decodeURI,
	'%decodeURIComponent%': decodeURIComponent,
	'%encodeURI%': encodeURI,
	'%encodeURIComponent%': encodeURIComponent,
	'%Error%': $Error,
	'%eval%': eval, // eslint-disable-line no-eval
	'%EvalError%': $EvalError,
	'%Float32Array%': typeof Float32Array === 'undefined' ? undefined : Float32Array,
	'%Float64Array%': typeof Float64Array === 'undefined' ? undefined : Float64Array,
	'%FinalizationRegistry%': typeof FinalizationRegistry === 'undefined' ? undefined : FinalizationRegistry,
	'%Function%': $Function,
	'%GeneratorFunction%': needsEval,
	'%Int8Array%': typeof Int8Array === 'undefined' ? undefined : Int8Array,
	'%Int16Array%': typeof Int16Array === 'undefined' ? undefined : Int16Array,
	'%Int32Array%': typeof Int32Array === 'undefined' ? undefined : Int32Array,
	'%isFinite%': isFinite,
	'%isNaN%': isNaN,
	'%IteratorPrototype%': hasSymbols && getProto ? getProto(getProto([][Symbol.iterator]())) : undefined,
	'%JSON%': typeof JSON === 'object' ? JSON : undefined,
	'%Map%': typeof Map === 'undefined' ? undefined : Map,
	'%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Map()[Symbol.iterator]()),
	'%Math%': Math,
	'%Number%': Number,
	'%Object%': Object,
	'%parseFloat%': parseFloat,
	'%parseInt%': parseInt,
	'%Promise%': typeof Promise === 'undefined' ? undefined : Promise,
	'%Proxy%': typeof Proxy === 'undefined' ? undefined : Proxy,
	'%RangeError%': $RangeError,
	'%ReferenceError%': $ReferenceError,
	'%Reflect%': typeof Reflect === 'undefined' ? undefined : Reflect,
	'%RegExp%': RegExp,
	'%Set%': typeof Set === 'undefined' ? undefined : Set,
	'%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Set()[Symbol.iterator]()),
	'%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined : SharedArrayBuffer,
	'%String%': String,
	'%StringIteratorPrototype%': hasSymbols && getProto ? getProto(''[Symbol.iterator]()) : undefined,
	'%Symbol%': hasSymbols ? Symbol : undefined,
	'%SyntaxError%': $SyntaxError,
	'%ThrowTypeError%': ThrowTypeError,
	'%TypedArray%': TypedArray,
	'%TypeError%': $TypeError,
	'%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined : Uint8Array,
	'%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined : Uint8ClampedArray,
	'%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined : Uint16Array,
	'%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined : Uint32Array,
	'%URIError%': $URIError,
	'%WeakMap%': typeof WeakMap === 'undefined' ? undefined : WeakMap,
	'%WeakRef%': typeof WeakRef === 'undefined' ? undefined : WeakRef,
	'%WeakSet%': typeof WeakSet === 'undefined' ? undefined : WeakSet
};

if (getProto) {
	try {
		null.error; // eslint-disable-line no-unused-expressions
	} catch (e) {
		// https://github.com/tc39/proposal-shadowrealm/pull/384#issuecomment-1364264229
		var errorProto = getProto(getProto(e));
		INTRINSICS['%Error.prototype%'] = errorProto;
	}
}

var doEval = function doEval(name) {
	var value;
	if (name === '%AsyncFunction%') {
		value = getEvalledConstructor('async function () {}');
	} else if (name === '%GeneratorFunction%') {
		value = getEvalledConstructor('function* () {}');
	} else if (name === '%AsyncGeneratorFunction%') {
		value = getEvalledConstructor('async function* () {}');
	} else if (name === '%AsyncGenerator%') {
		var fn = doEval('%AsyncGeneratorFunction%');
		if (fn) {
			value = fn.prototype;
		}
	} else if (name === '%AsyncIteratorPrototype%') {
		var gen = doEval('%AsyncGenerator%');
		if (gen && getProto) {
			value = getProto(gen.prototype);
		}
	}

	INTRINSICS[name] = value;

	return value;
};

var LEGACY_ALIASES = {
	__proto__: null,
	'%ArrayBufferPrototype%': ['ArrayBuffer', 'prototype'],
	'%ArrayPrototype%': ['Array', 'prototype'],
	'%ArrayProto_entries%': ['Array', 'prototype', 'entries'],
	'%ArrayProto_forEach%': ['Array', 'prototype', 'forEach'],
	'%ArrayProto_keys%': ['Array', 'prototype', 'keys'],
	'%ArrayProto_values%': ['Array', 'prototype', 'values'],
	'%AsyncFunctionPrototype%': ['AsyncFunction', 'prototype'],
	'%AsyncGenerator%': ['AsyncGeneratorFunction', 'prototype'],
	'%AsyncGeneratorPrototype%': ['AsyncGeneratorFunction', 'prototype', 'prototype'],
	'%BooleanPrototype%': ['Boolean', 'prototype'],
	'%DataViewPrototype%': ['DataView', 'prototype'],
	'%DatePrototype%': ['Date', 'prototype'],
	'%ErrorPrototype%': ['Error', 'prototype'],
	'%EvalErrorPrototype%': ['EvalError', 'prototype'],
	'%Float32ArrayPrototype%': ['Float32Array', 'prototype'],
	'%Float64ArrayPrototype%': ['Float64Array', 'prototype'],
	'%FunctionPrototype%': ['Function', 'prototype'],
	'%Generator%': ['GeneratorFunction', 'prototype'],
	'%GeneratorPrototype%': ['GeneratorFunction', 'prototype', 'prototype'],
	'%Int8ArrayPrototype%': ['Int8Array', 'prototype'],
	'%Int16ArrayPrototype%': ['Int16Array', 'prototype'],
	'%Int32ArrayPrototype%': ['Int32Array', 'prototype'],
	'%JSONParse%': ['JSON', 'parse'],
	'%JSONStringify%': ['JSON', 'stringify'],
	'%MapPrototype%': ['Map', 'prototype'],
	'%NumberPrototype%': ['Number', 'prototype'],
	'%ObjectPrototype%': ['Object', 'prototype'],
	'%ObjProto_toString%': ['Object', 'prototype', 'toString'],
	'%ObjProto_valueOf%': ['Object', 'prototype', 'valueOf'],
	'%PromisePrototype%': ['Promise', 'prototype'],
	'%PromiseProto_then%': ['Promise', 'prototype', 'then'],
	'%Promise_all%': ['Promise', 'all'],
	'%Promise_reject%': ['Promise', 'reject'],
	'%Promise_resolve%': ['Promise', 'resolve'],
	'%RangeErrorPrototype%': ['RangeError', 'prototype'],
	'%ReferenceErrorPrototype%': ['ReferenceError', 'prototype'],
	'%RegExpPrototype%': ['RegExp', 'prototype'],
	'%SetPrototype%': ['Set', 'prototype'],
	'%SharedArrayBufferPrototype%': ['SharedArrayBuffer', 'prototype'],
	'%StringPrototype%': ['String', 'prototype'],
	'%SymbolPrototype%': ['Symbol', 'prototype'],
	'%SyntaxErrorPrototype%': ['SyntaxError', 'prototype'],
	'%TypedArrayPrototype%': ['TypedArray', 'prototype'],
	'%TypeErrorPrototype%': ['TypeError', 'prototype'],
	'%Uint8ArrayPrototype%': ['Uint8Array', 'prototype'],
	'%Uint8ClampedArrayPrototype%': ['Uint8ClampedArray', 'prototype'],
	'%Uint16ArrayPrototype%': ['Uint16Array', 'prototype'],
	'%Uint32ArrayPrototype%': ['Uint32Array', 'prototype'],
	'%URIErrorPrototype%': ['URIError', 'prototype'],
	'%WeakMapPrototype%': ['WeakMap', 'prototype'],
	'%WeakSetPrototype%': ['WeakSet', 'prototype']
};

var bind = __webpack_require__(5127);
var hasOwn = __webpack_require__(9429);
var $concat = bind.call(Function.call, Array.prototype.concat);
var $spliceApply = bind.call(Function.apply, Array.prototype.splice);
var $replace = bind.call(Function.call, String.prototype.replace);
var $strSlice = bind.call(Function.call, String.prototype.slice);
var $exec = bind.call(Function.call, RegExp.prototype.exec);

/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */
var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
var reEscapeChar = /\\(\\)?/g; /** Used to match backslashes in property paths. */
var stringToPath = function stringToPath(string) {
	var first = $strSlice(string, 0, 1);
	var last = $strSlice(string, -1);
	if (first === '%' && last !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected closing `%`');
	} else if (last === '%' && first !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected opening `%`');
	}
	var result = [];
	$replace(string, rePropName, function (match, number, quote, subString) {
		result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
	});
	return result;
};
/* end adaptation */

var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
	var intrinsicName = name;
	var alias;
	if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
		alias = LEGACY_ALIASES[intrinsicName];
		intrinsicName = '%' + alias[0] + '%';
	}

	if (hasOwn(INTRINSICS, intrinsicName)) {
		var value = INTRINSICS[intrinsicName];
		if (value === needsEval) {
			value = doEval(intrinsicName);
		}
		if (typeof value === 'undefined' && !allowMissing) {
			throw new $TypeError('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
		}

		return {
			alias: alias,
			name: intrinsicName,
			value: value
		};
	}

	throw new $SyntaxError('intrinsic ' + name + ' does not exist!');
};

module.exports = function GetIntrinsic(name, allowMissing) {
	if (typeof name !== 'string' || name.length === 0) {
		throw new $TypeError('intrinsic name must be a non-empty string');
	}
	if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
		throw new $TypeError('"allowMissing" argument must be a boolean');
	}

	if ($exec(/^%?[^%]*%?$/, name) === null) {
		throw new $SyntaxError('`%` may not be present anywhere but at the beginning and end of the intrinsic name');
	}
	var parts = stringToPath(name);
	var intrinsicBaseName = parts.length > 0 ? parts[0] : '';

	var intrinsic = getBaseIntrinsic('%' + intrinsicBaseName + '%', allowMissing);
	var intrinsicRealName = intrinsic.name;
	var value = intrinsic.value;
	var skipFurtherCaching = false;

	var alias = intrinsic.alias;
	if (alias) {
		intrinsicBaseName = alias[0];
		$spliceApply(parts, $concat([0, 1], alias));
	}

	for (var i = 1, isOwn = true; i < parts.length; i += 1) {
		var part = parts[i];
		var first = $strSlice(part, 0, 1);
		var last = $strSlice(part, -1);
		if (
			(
				(first === '"' || first === "'" || first === '`')
				|| (last === '"' || last === "'" || last === '`')
			)
			&& first !== last
		) {
			throw new $SyntaxError('property names with quotes must have matching quotes');
		}
		if (part === 'constructor' || !isOwn) {
			skipFurtherCaching = true;
		}

		intrinsicBaseName += '.' + part;
		intrinsicRealName = '%' + intrinsicBaseName + '%';

		if (hasOwn(INTRINSICS, intrinsicRealName)) {
			value = INTRINSICS[intrinsicRealName];
		} else if (value != null) {
			if (!(part in value)) {
				if (!allowMissing) {
					throw new $TypeError('base intrinsic for ' + name + ' exists, but the property is not available.');
				}
				return void undefined;
			}
			if ($gOPD && (i + 1) >= parts.length) {
				var desc = $gOPD(value, part);
				isOwn = !!desc;

				// By convention, when a data property is converted to an accessor
				// property to emulate a data property that does not suffer from
				// the override mistake, that accessor's getter is marked with
				// an `originalValue` property. Here, when we detect this, we
				// uphold the illusion by pretending to see that original data
				// property, i.e., returning the value rather than the getter
				// itself.
				if (isOwn && 'get' in desc && !('originalValue' in desc.get)) {
					value = desc.get;
				} else {
					value = value[part];
				}
			} else {
				isOwn = hasOwn(value, part);
				value = value[part];
			}

			if (isOwn && !skipFurtherCaching) {
				INTRINSICS[intrinsicRealName] = value;
			}
		}
	}
	return value;
};


/***/ }),

/***/ 330:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var origSymbol = typeof Symbol !== 'undefined' && Symbol;
var hasSymbolSham = __webpack_require__(1489);

module.exports = function hasNativeSymbols() {
	if (typeof origSymbol !== 'function') { return false; }
	if (typeof Symbol !== 'function') { return false; }
	if (typeof origSymbol('foo') !== 'symbol') { return false; }
	if (typeof Symbol('bar') !== 'symbol') { return false; }

	return hasSymbolSham();
};


/***/ }),

/***/ 1489:
/***/ (function(module) {

"use strict";


/* eslint complexity: [2, 18], max-statements: [2, 33] */
module.exports = function hasSymbols() {
	if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
	if (typeof Symbol.iterator === 'symbol') { return true; }

	var obj = {};
	var sym = Symbol('test');
	var symObj = Object(sym);
	if (typeof sym === 'string') { return false; }

	if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
	if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

	// temp disabled per https://github.com/ljharb/object.assign/issues/17
	// if (sym instanceof Symbol) { return false; }
	// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
	// if (!(symObj instanceof Symbol)) { return false; }

	// if (typeof Symbol.prototype.toString !== 'function') { return false; }
	// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

	var symVal = 42;
	obj[sym] = symVal;
	for (sym in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
	if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

	if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

	var syms = Object.getOwnPropertySymbols(obj);
	if (syms.length !== 1 || syms[0] !== sym) { return false; }

	if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

	if (typeof Object.getOwnPropertyDescriptor === 'function') {
		var descriptor = Object.getOwnPropertyDescriptor(obj, sym);
		if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
	}

	return true;
};


/***/ }),

/***/ 9277:
/***/ (function(module) {

var toString = {}.toString;

module.exports = Array.isArray || function (arr) {
  return toString.call(arr) == '[object Array]';
};


/***/ }),

/***/ 1312:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var callBound = __webpack_require__(2137);
var isRegex = __webpack_require__(6073);

var $exec = callBound('RegExp.prototype.exec');
var $TypeError = __webpack_require__(1642);

module.exports = function regexTester(regex) {
	if (!isRegex(regex)) {
		throw new $TypeError('`regex` must be a RegExp');
	}
	return function test(s) {
		return $exec(regex, s) !== null;
	};
};


/***/ }),

/***/ 2137:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(5273);

var callBind = __webpack_require__(381);

var $indexOf = callBind(GetIntrinsic('String.prototype.indexOf'));

module.exports = function callBoundIntrinsic(name, allowMissing) {
	var intrinsic = GetIntrinsic(name, !!allowMissing);
	if (typeof intrinsic === 'function' && $indexOf(name, '.prototype.') > -1) {
		return callBind(intrinsic);
	}
	return intrinsic;
};


/***/ }),

/***/ 381:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var bind = __webpack_require__(3331);
var GetIntrinsic = __webpack_require__(5273);
var setFunctionLength = __webpack_require__(4521);

var $TypeError = __webpack_require__(1642);
var $apply = GetIntrinsic('%Function.prototype.apply%');
var $call = GetIntrinsic('%Function.prototype.call%');
var $reflectApply = GetIntrinsic('%Reflect.apply%', true) || bind.call($call, $apply);

var $defineProperty = __webpack_require__(8918);
var $max = GetIntrinsic('%Math.max%');

module.exports = function callBind(originalFunction) {
	if (typeof originalFunction !== 'function') {
		throw new $TypeError('a function is required');
	}
	var func = $reflectApply(bind, $call, arguments);
	return setFunctionLength(
		func,
		1 + $max(0, originalFunction.length - (arguments.length - 1)),
		true
	);
};

var applyBind = function applyBind() {
	return $reflectApply(bind, $apply, arguments);
};

if ($defineProperty) {
	$defineProperty(module.exports, 'apply', { value: applyBind });
} else {
	module.exports.apply = applyBind;
}


/***/ }),

/***/ 7780:
/***/ (function(module) {

"use strict";


/* eslint no-invalid-this: 1 */

var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
var toStr = Object.prototype.toString;
var max = Math.max;
var funcType = '[object Function]';

var concatty = function concatty(a, b) {
    var arr = [];

    for (var i = 0; i < a.length; i += 1) {
        arr[i] = a[i];
    }
    for (var j = 0; j < b.length; j += 1) {
        arr[j + a.length] = b[j];
    }

    return arr;
};

var slicy = function slicy(arrLike, offset) {
    var arr = [];
    for (var i = offset || 0, j = 0; i < arrLike.length; i += 1, j += 1) {
        arr[j] = arrLike[i];
    }
    return arr;
};

var joiny = function (arr, joiner) {
    var str = '';
    for (var i = 0; i < arr.length; i += 1) {
        str += arr[i];
        if (i + 1 < arr.length) {
            str += joiner;
        }
    }
    return str;
};

module.exports = function bind(that) {
    var target = this;
    if (typeof target !== 'function' || toStr.apply(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
    }
    var args = slicy(arguments, 1);

    var bound;
    var binder = function () {
        if (this instanceof bound) {
            var result = target.apply(
                this,
                concatty(args, arguments)
            );
            if (Object(result) === result) {
                return result;
            }
            return this;
        }
        return target.apply(
            that,
            concatty(args, arguments)
        );

    };

    var boundLength = max(0, target.length - args.length);
    var boundArgs = [];
    for (var i = 0; i < boundLength; i++) {
        boundArgs[i] = '$' + i;
    }

    bound = Function('binder', 'return function (' + joiny(boundArgs, ',') + '){ return binder.apply(this,arguments); }')(binder);

    if (target.prototype) {
        var Empty = function Empty() {};
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
    }

    return bound;
};


/***/ }),

/***/ 3331:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var implementation = __webpack_require__(7780);

module.exports = Function.prototype.bind || implementation;


/***/ }),

/***/ 5273:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var undefined;

var $Error = __webpack_require__(6716);
var $EvalError = __webpack_require__(6788);
var $RangeError = __webpack_require__(9204);
var $ReferenceError = __webpack_require__(9908);
var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);
var $URIError = __webpack_require__(1451);

var $Function = Function;

// eslint-disable-next-line consistent-return
var getEvalledConstructor = function (expressionSyntax) {
	try {
		return $Function('"use strict"; return (' + expressionSyntax + ').constructor;')();
	} catch (e) {}
};

var $gOPD = Object.getOwnPropertyDescriptor;
if ($gOPD) {
	try {
		$gOPD({}, '');
	} catch (e) {
		$gOPD = null; // this is IE 8, which has a broken gOPD
	}
}

var throwTypeError = function () {
	throw new $TypeError();
};
var ThrowTypeError = $gOPD
	? (function () {
		try {
			// eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
			arguments.callee; // IE 8 does not throw here
			return throwTypeError;
		} catch (calleeThrows) {
			try {
				// IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
				return $gOPD(arguments, 'callee').get;
			} catch (gOPDthrows) {
				return throwTypeError;
			}
		}
	}())
	: throwTypeError;

var hasSymbols = __webpack_require__(6339)();
var hasProto = __webpack_require__(1856)();

var getProto = Object.getPrototypeOf || (
	hasProto
		? function (x) { return x.__proto__; } // eslint-disable-line no-proto
		: null
);

var needsEval = {};

var TypedArray = typeof Uint8Array === 'undefined' || !getProto ? undefined : getProto(Uint8Array);

var INTRINSICS = {
	__proto__: null,
	'%AggregateError%': typeof AggregateError === 'undefined' ? undefined : AggregateError,
	'%Array%': Array,
	'%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined : ArrayBuffer,
	'%ArrayIteratorPrototype%': hasSymbols && getProto ? getProto([][Symbol.iterator]()) : undefined,
	'%AsyncFromSyncIteratorPrototype%': undefined,
	'%AsyncFunction%': needsEval,
	'%AsyncGenerator%': needsEval,
	'%AsyncGeneratorFunction%': needsEval,
	'%AsyncIteratorPrototype%': needsEval,
	'%Atomics%': typeof Atomics === 'undefined' ? undefined : Atomics,
	'%BigInt%': typeof BigInt === 'undefined' ? undefined : BigInt,
	'%BigInt64Array%': typeof BigInt64Array === 'undefined' ? undefined : BigInt64Array,
	'%BigUint64Array%': typeof BigUint64Array === 'undefined' ? undefined : BigUint64Array,
	'%Boolean%': Boolean,
	'%DataView%': typeof DataView === 'undefined' ? undefined : DataView,
	'%Date%': Date,
	'%decodeURI%': decodeURI,
	'%decodeURIComponent%': decodeURIComponent,
	'%encodeURI%': encodeURI,
	'%encodeURIComponent%': encodeURIComponent,
	'%Error%': $Error,
	'%eval%': eval, // eslint-disable-line no-eval
	'%EvalError%': $EvalError,
	'%Float32Array%': typeof Float32Array === 'undefined' ? undefined : Float32Array,
	'%Float64Array%': typeof Float64Array === 'undefined' ? undefined : Float64Array,
	'%FinalizationRegistry%': typeof FinalizationRegistry === 'undefined' ? undefined : FinalizationRegistry,
	'%Function%': $Function,
	'%GeneratorFunction%': needsEval,
	'%Int8Array%': typeof Int8Array === 'undefined' ? undefined : Int8Array,
	'%Int16Array%': typeof Int16Array === 'undefined' ? undefined : Int16Array,
	'%Int32Array%': typeof Int32Array === 'undefined' ? undefined : Int32Array,
	'%isFinite%': isFinite,
	'%isNaN%': isNaN,
	'%IteratorPrototype%': hasSymbols && getProto ? getProto(getProto([][Symbol.iterator]())) : undefined,
	'%JSON%': typeof JSON === 'object' ? JSON : undefined,
	'%Map%': typeof Map === 'undefined' ? undefined : Map,
	'%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Map()[Symbol.iterator]()),
	'%Math%': Math,
	'%Number%': Number,
	'%Object%': Object,
	'%parseFloat%': parseFloat,
	'%parseInt%': parseInt,
	'%Promise%': typeof Promise === 'undefined' ? undefined : Promise,
	'%Proxy%': typeof Proxy === 'undefined' ? undefined : Proxy,
	'%RangeError%': $RangeError,
	'%ReferenceError%': $ReferenceError,
	'%Reflect%': typeof Reflect === 'undefined' ? undefined : Reflect,
	'%RegExp%': RegExp,
	'%Set%': typeof Set === 'undefined' ? undefined : Set,
	'%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Set()[Symbol.iterator]()),
	'%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined : SharedArrayBuffer,
	'%String%': String,
	'%StringIteratorPrototype%': hasSymbols && getProto ? getProto(''[Symbol.iterator]()) : undefined,
	'%Symbol%': hasSymbols ? Symbol : undefined,
	'%SyntaxError%': $SyntaxError,
	'%ThrowTypeError%': ThrowTypeError,
	'%TypedArray%': TypedArray,
	'%TypeError%': $TypeError,
	'%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined : Uint8Array,
	'%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined : Uint8ClampedArray,
	'%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined : Uint16Array,
	'%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined : Uint32Array,
	'%URIError%': $URIError,
	'%WeakMap%': typeof WeakMap === 'undefined' ? undefined : WeakMap,
	'%WeakRef%': typeof WeakRef === 'undefined' ? undefined : WeakRef,
	'%WeakSet%': typeof WeakSet === 'undefined' ? undefined : WeakSet
};

if (getProto) {
	try {
		null.error; // eslint-disable-line no-unused-expressions
	} catch (e) {
		// https://github.com/tc39/proposal-shadowrealm/pull/384#issuecomment-1364264229
		var errorProto = getProto(getProto(e));
		INTRINSICS['%Error.prototype%'] = errorProto;
	}
}

var doEval = function doEval(name) {
	var value;
	if (name === '%AsyncFunction%') {
		value = getEvalledConstructor('async function () {}');
	} else if (name === '%GeneratorFunction%') {
		value = getEvalledConstructor('function* () {}');
	} else if (name === '%AsyncGeneratorFunction%') {
		value = getEvalledConstructor('async function* () {}');
	} else if (name === '%AsyncGenerator%') {
		var fn = doEval('%AsyncGeneratorFunction%');
		if (fn) {
			value = fn.prototype;
		}
	} else if (name === '%AsyncIteratorPrototype%') {
		var gen = doEval('%AsyncGenerator%');
		if (gen && getProto) {
			value = getProto(gen.prototype);
		}
	}

	INTRINSICS[name] = value;

	return value;
};

var LEGACY_ALIASES = {
	__proto__: null,
	'%ArrayBufferPrototype%': ['ArrayBuffer', 'prototype'],
	'%ArrayPrototype%': ['Array', 'prototype'],
	'%ArrayProto_entries%': ['Array', 'prototype', 'entries'],
	'%ArrayProto_forEach%': ['Array', 'prototype', 'forEach'],
	'%ArrayProto_keys%': ['Array', 'prototype', 'keys'],
	'%ArrayProto_values%': ['Array', 'prototype', 'values'],
	'%AsyncFunctionPrototype%': ['AsyncFunction', 'prototype'],
	'%AsyncGenerator%': ['AsyncGeneratorFunction', 'prototype'],
	'%AsyncGeneratorPrototype%': ['AsyncGeneratorFunction', 'prototype', 'prototype'],
	'%BooleanPrototype%': ['Boolean', 'prototype'],
	'%DataViewPrototype%': ['DataView', 'prototype'],
	'%DatePrototype%': ['Date', 'prototype'],
	'%ErrorPrototype%': ['Error', 'prototype'],
	'%EvalErrorPrototype%': ['EvalError', 'prototype'],
	'%Float32ArrayPrototype%': ['Float32Array', 'prototype'],
	'%Float64ArrayPrototype%': ['Float64Array', 'prototype'],
	'%FunctionPrototype%': ['Function', 'prototype'],
	'%Generator%': ['GeneratorFunction', 'prototype'],
	'%GeneratorPrototype%': ['GeneratorFunction', 'prototype', 'prototype'],
	'%Int8ArrayPrototype%': ['Int8Array', 'prototype'],
	'%Int16ArrayPrototype%': ['Int16Array', 'prototype'],
	'%Int32ArrayPrototype%': ['Int32Array', 'prototype'],
	'%JSONParse%': ['JSON', 'parse'],
	'%JSONStringify%': ['JSON', 'stringify'],
	'%MapPrototype%': ['Map', 'prototype'],
	'%NumberPrototype%': ['Number', 'prototype'],
	'%ObjectPrototype%': ['Object', 'prototype'],
	'%ObjProto_toString%': ['Object', 'prototype', 'toString'],
	'%ObjProto_valueOf%': ['Object', 'prototype', 'valueOf'],
	'%PromisePrototype%': ['Promise', 'prototype'],
	'%PromiseProto_then%': ['Promise', 'prototype', 'then'],
	'%Promise_all%': ['Promise', 'all'],
	'%Promise_reject%': ['Promise', 'reject'],
	'%Promise_resolve%': ['Promise', 'resolve'],
	'%RangeErrorPrototype%': ['RangeError', 'prototype'],
	'%ReferenceErrorPrototype%': ['ReferenceError', 'prototype'],
	'%RegExpPrototype%': ['RegExp', 'prototype'],
	'%SetPrototype%': ['Set', 'prototype'],
	'%SharedArrayBufferPrototype%': ['SharedArrayBuffer', 'prototype'],
	'%StringPrototype%': ['String', 'prototype'],
	'%SymbolPrototype%': ['Symbol', 'prototype'],
	'%SyntaxErrorPrototype%': ['SyntaxError', 'prototype'],
	'%TypedArrayPrototype%': ['TypedArray', 'prototype'],
	'%TypeErrorPrototype%': ['TypeError', 'prototype'],
	'%Uint8ArrayPrototype%': ['Uint8Array', 'prototype'],
	'%Uint8ClampedArrayPrototype%': ['Uint8ClampedArray', 'prototype'],
	'%Uint16ArrayPrototype%': ['Uint16Array', 'prototype'],
	'%Uint32ArrayPrototype%': ['Uint32Array', 'prototype'],
	'%URIErrorPrototype%': ['URIError', 'prototype'],
	'%WeakMapPrototype%': ['WeakMap', 'prototype'],
	'%WeakSetPrototype%': ['WeakSet', 'prototype']
};

var bind = __webpack_require__(3331);
var hasOwn = __webpack_require__(9429);
var $concat = bind.call(Function.call, Array.prototype.concat);
var $spliceApply = bind.call(Function.apply, Array.prototype.splice);
var $replace = bind.call(Function.call, String.prototype.replace);
var $strSlice = bind.call(Function.call, String.prototype.slice);
var $exec = bind.call(Function.call, RegExp.prototype.exec);

/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */
var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
var reEscapeChar = /\\(\\)?/g; /** Used to match backslashes in property paths. */
var stringToPath = function stringToPath(string) {
	var first = $strSlice(string, 0, 1);
	var last = $strSlice(string, -1);
	if (first === '%' && last !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected closing `%`');
	} else if (last === '%' && first !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected opening `%`');
	}
	var result = [];
	$replace(string, rePropName, function (match, number, quote, subString) {
		result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
	});
	return result;
};
/* end adaptation */

var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
	var intrinsicName = name;
	var alias;
	if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
		alias = LEGACY_ALIASES[intrinsicName];
		intrinsicName = '%' + alias[0] + '%';
	}

	if (hasOwn(INTRINSICS, intrinsicName)) {
		var value = INTRINSICS[intrinsicName];
		if (value === needsEval) {
			value = doEval(intrinsicName);
		}
		if (typeof value === 'undefined' && !allowMissing) {
			throw new $TypeError('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
		}

		return {
			alias: alias,
			name: intrinsicName,
			value: value
		};
	}

	throw new $SyntaxError('intrinsic ' + name + ' does not exist!');
};

module.exports = function GetIntrinsic(name, allowMissing) {
	if (typeof name !== 'string' || name.length === 0) {
		throw new $TypeError('intrinsic name must be a non-empty string');
	}
	if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
		throw new $TypeError('"allowMissing" argument must be a boolean');
	}

	if ($exec(/^%?[^%]*%?$/, name) === null) {
		throw new $SyntaxError('`%` may not be present anywhere but at the beginning and end of the intrinsic name');
	}
	var parts = stringToPath(name);
	var intrinsicBaseName = parts.length > 0 ? parts[0] : '';

	var intrinsic = getBaseIntrinsic('%' + intrinsicBaseName + '%', allowMissing);
	var intrinsicRealName = intrinsic.name;
	var value = intrinsic.value;
	var skipFurtherCaching = false;

	var alias = intrinsic.alias;
	if (alias) {
		intrinsicBaseName = alias[0];
		$spliceApply(parts, $concat([0, 1], alias));
	}

	for (var i = 1, isOwn = true; i < parts.length; i += 1) {
		var part = parts[i];
		var first = $strSlice(part, 0, 1);
		var last = $strSlice(part, -1);
		if (
			(
				(first === '"' || first === "'" || first === '`')
				|| (last === '"' || last === "'" || last === '`')
			)
			&& first !== last
		) {
			throw new $SyntaxError('property names with quotes must have matching quotes');
		}
		if (part === 'constructor' || !isOwn) {
			skipFurtherCaching = true;
		}

		intrinsicBaseName += '.' + part;
		intrinsicRealName = '%' + intrinsicBaseName + '%';

		if (hasOwn(INTRINSICS, intrinsicRealName)) {
			value = INTRINSICS[intrinsicRealName];
		} else if (value != null) {
			if (!(part in value)) {
				if (!allowMissing) {
					throw new $TypeError('base intrinsic for ' + name + ' exists, but the property is not available.');
				}
				return void undefined;
			}
			if ($gOPD && (i + 1) >= parts.length) {
				var desc = $gOPD(value, part);
				isOwn = !!desc;

				// By convention, when a data property is converted to an accessor
				// property to emulate a data property that does not suffer from
				// the override mistake, that accessor's getter is marked with
				// an `originalValue` property. Here, when we detect this, we
				// uphold the illusion by pretending to see that original data
				// property, i.e., returning the value rather than the getter
				// itself.
				if (isOwn && 'get' in desc && !('originalValue' in desc.get)) {
					value = desc.get;
				} else {
					value = value[part];
				}
			} else {
				isOwn = hasOwn(value, part);
				value = value[part];
			}

			if (isOwn && !skipFurtherCaching) {
				INTRINSICS[intrinsicRealName] = value;
			}
		}
	}
	return value;
};


/***/ }),

/***/ 6339:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var origSymbol = typeof Symbol !== 'undefined' && Symbol;
var hasSymbolSham = __webpack_require__(6789);

module.exports = function hasNativeSymbols() {
	if (typeof origSymbol !== 'function') { return false; }
	if (typeof Symbol !== 'function') { return false; }
	if (typeof origSymbol('foo') !== 'symbol') { return false; }
	if (typeof Symbol('bar') !== 'symbol') { return false; }

	return hasSymbolSham();
};


/***/ }),

/***/ 6789:
/***/ (function(module) {

"use strict";


/* eslint complexity: [2, 18], max-statements: [2, 33] */
module.exports = function hasSymbols() {
	if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
	if (typeof Symbol.iterator === 'symbol') { return true; }

	var obj = {};
	var sym = Symbol('test');
	var symObj = Object(sym);
	if (typeof sym === 'string') { return false; }

	if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
	if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

	// temp disabled per https://github.com/ljharb/object.assign/issues/17
	// if (sym instanceof Symbol) { return false; }
	// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
	// if (!(symObj instanceof Symbol)) { return false; }

	// if (typeof Symbol.prototype.toString !== 'function') { return false; }
	// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

	var symVal = 42;
	obj[sym] = symVal;
	for (sym in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
	if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

	if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

	var syms = Object.getOwnPropertySymbols(obj);
	if (syms.length !== 1 || syms[0] !== sym) { return false; }

	if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

	if (typeof Object.getOwnPropertyDescriptor === 'function') {
		var descriptor = Object.getOwnPropertyDescriptor(obj, sym);
		if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
	}

	return true;
};


/***/ }),

/***/ 6073:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var callBound = __webpack_require__(2137);
var hasToStringTag = __webpack_require__(4111)();
var has;
var $exec;
var isRegexMarker;
var badStringifier;

if (hasToStringTag) {
	has = callBound('Object.prototype.hasOwnProperty');
	$exec = callBound('RegExp.prototype.exec');
	isRegexMarker = {};

	var throwRegexMarker = function () {
		throw isRegexMarker;
	};
	badStringifier = {
		toString: throwRegexMarker,
		valueOf: throwRegexMarker
	};

	if (typeof Symbol.toPrimitive === 'symbol') {
		badStringifier[Symbol.toPrimitive] = throwRegexMarker;
	}
}

var $toString = callBound('Object.prototype.toString');
var gOPD = Object.getOwnPropertyDescriptor;
var regexClass = '[object RegExp]';

module.exports = hasToStringTag
	// eslint-disable-next-line consistent-return
	? function isRegex(value) {
		if (!value || typeof value !== 'object') {
			return false;
		}

		var descriptor = gOPD(value, 'lastIndex');
		var hasLastIndexDataProperty = descriptor && has(descriptor, 'value');
		if (!hasLastIndexDataProperty) {
			return false;
		}

		try {
			$exec(value, badStringifier);
		} catch (e) {
			return e === isRegexMarker;
		}
	}
	: function isRegex(value) {
		// In older browsers, typeof regex incorrectly returns 'function'
		if (!value || (typeof value !== 'object' && typeof value !== 'function')) {
			return false;
		}

		return $toString(value) === regexClass;
	};


/***/ }),

/***/ 4521:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(1757);
var define = __webpack_require__(2656);
var hasDescriptors = __webpack_require__(8198)();
var gOPD = __webpack_require__(3828);

var $TypeError = __webpack_require__(1642);
var $floor = GetIntrinsic('%Math.floor%');

/** @type {import('.')} */
module.exports = function setFunctionLength(fn, length) {
	if (typeof fn !== 'function') {
		throw new $TypeError('`fn` is not a function');
	}
	if (typeof length !== 'number' || length < 0 || length > 0xFFFFFFFF || $floor(length) !== length) {
		throw new $TypeError('`length` must be a positive 32-bit integer');
	}

	var loose = arguments.length > 2 && !!arguments[2];

	var functionLengthIsConfigurable = true;
	var functionLengthIsWritable = true;
	if ('length' in fn && gOPD) {
		var desc = gOPD(fn, 'length');
		if (desc && !desc.configurable) {
			functionLengthIsConfigurable = false;
		}
		if (desc && !desc.writable) {
			functionLengthIsWritable = false;
		}
	}

	if (functionLengthIsConfigurable || functionLengthIsWritable || !loose) {
		if (hasDescriptors) {
			define(/** @type {Parameters<define>[0]} */ (fn), 'length', length, true, true);
		} else {
			define(/** @type {Parameters<define>[0]} */ (fn), 'length', length);
		}
	}
	return fn;
};


/***/ }),

/***/ 5371:
/***/ (function(module) {

"use strict";


/* eslint no-invalid-this: 1 */

var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
var toStr = Object.prototype.toString;
var max = Math.max;
var funcType = '[object Function]';

var concatty = function concatty(a, b) {
    var arr = [];

    for (var i = 0; i < a.length; i += 1) {
        arr[i] = a[i];
    }
    for (var j = 0; j < b.length; j += 1) {
        arr[j + a.length] = b[j];
    }

    return arr;
};

var slicy = function slicy(arrLike, offset) {
    var arr = [];
    for (var i = offset || 0, j = 0; i < arrLike.length; i += 1, j += 1) {
        arr[j] = arrLike[i];
    }
    return arr;
};

var joiny = function (arr, joiner) {
    var str = '';
    for (var i = 0; i < arr.length; i += 1) {
        str += arr[i];
        if (i + 1 < arr.length) {
            str += joiner;
        }
    }
    return str;
};

module.exports = function bind(that) {
    var target = this;
    if (typeof target !== 'function' || toStr.apply(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
    }
    var args = slicy(arguments, 1);

    var bound;
    var binder = function () {
        if (this instanceof bound) {
            var result = target.apply(
                this,
                concatty(args, arguments)
            );
            if (Object(result) === result) {
                return result;
            }
            return this;
        }
        return target.apply(
            that,
            concatty(args, arguments)
        );

    };

    var boundLength = max(0, target.length - args.length);
    var boundArgs = [];
    for (var i = 0; i < boundLength; i++) {
        boundArgs[i] = '$' + i;
    }

    bound = Function('binder', 'return function (' + joiny(boundArgs, ',') + '){ return binder.apply(this,arguments); }')(binder);

    if (target.prototype) {
        var Empty = function Empty() {};
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
    }

    return bound;
};


/***/ }),

/***/ 9015:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var implementation = __webpack_require__(5371);

module.exports = Function.prototype.bind || implementation;


/***/ }),

/***/ 1757:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var undefined;

var $Error = __webpack_require__(6716);
var $EvalError = __webpack_require__(6788);
var $RangeError = __webpack_require__(9204);
var $ReferenceError = __webpack_require__(9908);
var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);
var $URIError = __webpack_require__(1451);

var $Function = Function;

// eslint-disable-next-line consistent-return
var getEvalledConstructor = function (expressionSyntax) {
	try {
		return $Function('"use strict"; return (' + expressionSyntax + ').constructor;')();
	} catch (e) {}
};

var $gOPD = Object.getOwnPropertyDescriptor;
if ($gOPD) {
	try {
		$gOPD({}, '');
	} catch (e) {
		$gOPD = null; // this is IE 8, which has a broken gOPD
	}
}

var throwTypeError = function () {
	throw new $TypeError();
};
var ThrowTypeError = $gOPD
	? (function () {
		try {
			// eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
			arguments.callee; // IE 8 does not throw here
			return throwTypeError;
		} catch (calleeThrows) {
			try {
				// IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
				return $gOPD(arguments, 'callee').get;
			} catch (gOPDthrows) {
				return throwTypeError;
			}
		}
	}())
	: throwTypeError;

var hasSymbols = __webpack_require__(1207)();
var hasProto = __webpack_require__(1856)();

var getProto = Object.getPrototypeOf || (
	hasProto
		? function (x) { return x.__proto__; } // eslint-disable-line no-proto
		: null
);

var needsEval = {};

var TypedArray = typeof Uint8Array === 'undefined' || !getProto ? undefined : getProto(Uint8Array);

var INTRINSICS = {
	__proto__: null,
	'%AggregateError%': typeof AggregateError === 'undefined' ? undefined : AggregateError,
	'%Array%': Array,
	'%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined : ArrayBuffer,
	'%ArrayIteratorPrototype%': hasSymbols && getProto ? getProto([][Symbol.iterator]()) : undefined,
	'%AsyncFromSyncIteratorPrototype%': undefined,
	'%AsyncFunction%': needsEval,
	'%AsyncGenerator%': needsEval,
	'%AsyncGeneratorFunction%': needsEval,
	'%AsyncIteratorPrototype%': needsEval,
	'%Atomics%': typeof Atomics === 'undefined' ? undefined : Atomics,
	'%BigInt%': typeof BigInt === 'undefined' ? undefined : BigInt,
	'%BigInt64Array%': typeof BigInt64Array === 'undefined' ? undefined : BigInt64Array,
	'%BigUint64Array%': typeof BigUint64Array === 'undefined' ? undefined : BigUint64Array,
	'%Boolean%': Boolean,
	'%DataView%': typeof DataView === 'undefined' ? undefined : DataView,
	'%Date%': Date,
	'%decodeURI%': decodeURI,
	'%decodeURIComponent%': decodeURIComponent,
	'%encodeURI%': encodeURI,
	'%encodeURIComponent%': encodeURIComponent,
	'%Error%': $Error,
	'%eval%': eval, // eslint-disable-line no-eval
	'%EvalError%': $EvalError,
	'%Float32Array%': typeof Float32Array === 'undefined' ? undefined : Float32Array,
	'%Float64Array%': typeof Float64Array === 'undefined' ? undefined : Float64Array,
	'%FinalizationRegistry%': typeof FinalizationRegistry === 'undefined' ? undefined : FinalizationRegistry,
	'%Function%': $Function,
	'%GeneratorFunction%': needsEval,
	'%Int8Array%': typeof Int8Array === 'undefined' ? undefined : Int8Array,
	'%Int16Array%': typeof Int16Array === 'undefined' ? undefined : Int16Array,
	'%Int32Array%': typeof Int32Array === 'undefined' ? undefined : Int32Array,
	'%isFinite%': isFinite,
	'%isNaN%': isNaN,
	'%IteratorPrototype%': hasSymbols && getProto ? getProto(getProto([][Symbol.iterator]())) : undefined,
	'%JSON%': typeof JSON === 'object' ? JSON : undefined,
	'%Map%': typeof Map === 'undefined' ? undefined : Map,
	'%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Map()[Symbol.iterator]()),
	'%Math%': Math,
	'%Number%': Number,
	'%Object%': Object,
	'%parseFloat%': parseFloat,
	'%parseInt%': parseInt,
	'%Promise%': typeof Promise === 'undefined' ? undefined : Promise,
	'%Proxy%': typeof Proxy === 'undefined' ? undefined : Proxy,
	'%RangeError%': $RangeError,
	'%ReferenceError%': $ReferenceError,
	'%Reflect%': typeof Reflect === 'undefined' ? undefined : Reflect,
	'%RegExp%': RegExp,
	'%Set%': typeof Set === 'undefined' ? undefined : Set,
	'%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Set()[Symbol.iterator]()),
	'%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined : SharedArrayBuffer,
	'%String%': String,
	'%StringIteratorPrototype%': hasSymbols && getProto ? getProto(''[Symbol.iterator]()) : undefined,
	'%Symbol%': hasSymbols ? Symbol : undefined,
	'%SyntaxError%': $SyntaxError,
	'%ThrowTypeError%': ThrowTypeError,
	'%TypedArray%': TypedArray,
	'%TypeError%': $TypeError,
	'%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined : Uint8Array,
	'%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined : Uint8ClampedArray,
	'%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined : Uint16Array,
	'%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined : Uint32Array,
	'%URIError%': $URIError,
	'%WeakMap%': typeof WeakMap === 'undefined' ? undefined : WeakMap,
	'%WeakRef%': typeof WeakRef === 'undefined' ? undefined : WeakRef,
	'%WeakSet%': typeof WeakSet === 'undefined' ? undefined : WeakSet
};

if (getProto) {
	try {
		null.error; // eslint-disable-line no-unused-expressions
	} catch (e) {
		// https://github.com/tc39/proposal-shadowrealm/pull/384#issuecomment-1364264229
		var errorProto = getProto(getProto(e));
		INTRINSICS['%Error.prototype%'] = errorProto;
	}
}

var doEval = function doEval(name) {
	var value;
	if (name === '%AsyncFunction%') {
		value = getEvalledConstructor('async function () {}');
	} else if (name === '%GeneratorFunction%') {
		value = getEvalledConstructor('function* () {}');
	} else if (name === '%AsyncGeneratorFunction%') {
		value = getEvalledConstructor('async function* () {}');
	} else if (name === '%AsyncGenerator%') {
		var fn = doEval('%AsyncGeneratorFunction%');
		if (fn) {
			value = fn.prototype;
		}
	} else if (name === '%AsyncIteratorPrototype%') {
		var gen = doEval('%AsyncGenerator%');
		if (gen && getProto) {
			value = getProto(gen.prototype);
		}
	}

	INTRINSICS[name] = value;

	return value;
};

var LEGACY_ALIASES = {
	__proto__: null,
	'%ArrayBufferPrototype%': ['ArrayBuffer', 'prototype'],
	'%ArrayPrototype%': ['Array', 'prototype'],
	'%ArrayProto_entries%': ['Array', 'prototype', 'entries'],
	'%ArrayProto_forEach%': ['Array', 'prototype', 'forEach'],
	'%ArrayProto_keys%': ['Array', 'prototype', 'keys'],
	'%ArrayProto_values%': ['Array', 'prototype', 'values'],
	'%AsyncFunctionPrototype%': ['AsyncFunction', 'prototype'],
	'%AsyncGenerator%': ['AsyncGeneratorFunction', 'prototype'],
	'%AsyncGeneratorPrototype%': ['AsyncGeneratorFunction', 'prototype', 'prototype'],
	'%BooleanPrototype%': ['Boolean', 'prototype'],
	'%DataViewPrototype%': ['DataView', 'prototype'],
	'%DatePrototype%': ['Date', 'prototype'],
	'%ErrorPrototype%': ['Error', 'prototype'],
	'%EvalErrorPrototype%': ['EvalError', 'prototype'],
	'%Float32ArrayPrototype%': ['Float32Array', 'prototype'],
	'%Float64ArrayPrototype%': ['Float64Array', 'prototype'],
	'%FunctionPrototype%': ['Function', 'prototype'],
	'%Generator%': ['GeneratorFunction', 'prototype'],
	'%GeneratorPrototype%': ['GeneratorFunction', 'prototype', 'prototype'],
	'%Int8ArrayPrototype%': ['Int8Array', 'prototype'],
	'%Int16ArrayPrototype%': ['Int16Array', 'prototype'],
	'%Int32ArrayPrototype%': ['Int32Array', 'prototype'],
	'%JSONParse%': ['JSON', 'parse'],
	'%JSONStringify%': ['JSON', 'stringify'],
	'%MapPrototype%': ['Map', 'prototype'],
	'%NumberPrototype%': ['Number', 'prototype'],
	'%ObjectPrototype%': ['Object', 'prototype'],
	'%ObjProto_toString%': ['Object', 'prototype', 'toString'],
	'%ObjProto_valueOf%': ['Object', 'prototype', 'valueOf'],
	'%PromisePrototype%': ['Promise', 'prototype'],
	'%PromiseProto_then%': ['Promise', 'prototype', 'then'],
	'%Promise_all%': ['Promise', 'all'],
	'%Promise_reject%': ['Promise', 'reject'],
	'%Promise_resolve%': ['Promise', 'resolve'],
	'%RangeErrorPrototype%': ['RangeError', 'prototype'],
	'%ReferenceErrorPrototype%': ['ReferenceError', 'prototype'],
	'%RegExpPrototype%': ['RegExp', 'prototype'],
	'%SetPrototype%': ['Set', 'prototype'],
	'%SharedArrayBufferPrototype%': ['SharedArrayBuffer', 'prototype'],
	'%StringPrototype%': ['String', 'prototype'],
	'%SymbolPrototype%': ['Symbol', 'prototype'],
	'%SyntaxErrorPrototype%': ['SyntaxError', 'prototype'],
	'%TypedArrayPrototype%': ['TypedArray', 'prototype'],
	'%TypeErrorPrototype%': ['TypeError', 'prototype'],
	'%Uint8ArrayPrototype%': ['Uint8Array', 'prototype'],
	'%Uint8ClampedArrayPrototype%': ['Uint8ClampedArray', 'prototype'],
	'%Uint16ArrayPrototype%': ['Uint16Array', 'prototype'],
	'%Uint32ArrayPrototype%': ['Uint32Array', 'prototype'],
	'%URIErrorPrototype%': ['URIError', 'prototype'],
	'%WeakMapPrototype%': ['WeakMap', 'prototype'],
	'%WeakSetPrototype%': ['WeakSet', 'prototype']
};

var bind = __webpack_require__(9015);
var hasOwn = __webpack_require__(9429);
var $concat = bind.call(Function.call, Array.prototype.concat);
var $spliceApply = bind.call(Function.apply, Array.prototype.splice);
var $replace = bind.call(Function.call, String.prototype.replace);
var $strSlice = bind.call(Function.call, String.prototype.slice);
var $exec = bind.call(Function.call, RegExp.prototype.exec);

/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */
var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
var reEscapeChar = /\\(\\)?/g; /** Used to match backslashes in property paths. */
var stringToPath = function stringToPath(string) {
	var first = $strSlice(string, 0, 1);
	var last = $strSlice(string, -1);
	if (first === '%' && last !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected closing `%`');
	} else if (last === '%' && first !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected opening `%`');
	}
	var result = [];
	$replace(string, rePropName, function (match, number, quote, subString) {
		result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
	});
	return result;
};
/* end adaptation */

var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
	var intrinsicName = name;
	var alias;
	if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
		alias = LEGACY_ALIASES[intrinsicName];
		intrinsicName = '%' + alias[0] + '%';
	}

	if (hasOwn(INTRINSICS, intrinsicName)) {
		var value = INTRINSICS[intrinsicName];
		if (value === needsEval) {
			value = doEval(intrinsicName);
		}
		if (typeof value === 'undefined' && !allowMissing) {
			throw new $TypeError('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
		}

		return {
			alias: alias,
			name: intrinsicName,
			value: value
		};
	}

	throw new $SyntaxError('intrinsic ' + name + ' does not exist!');
};

module.exports = function GetIntrinsic(name, allowMissing) {
	if (typeof name !== 'string' || name.length === 0) {
		throw new $TypeError('intrinsic name must be a non-empty string');
	}
	if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
		throw new $TypeError('"allowMissing" argument must be a boolean');
	}

	if ($exec(/^%?[^%]*%?$/, name) === null) {
		throw new $SyntaxError('`%` may not be present anywhere but at the beginning and end of the intrinsic name');
	}
	var parts = stringToPath(name);
	var intrinsicBaseName = parts.length > 0 ? parts[0] : '';

	var intrinsic = getBaseIntrinsic('%' + intrinsicBaseName + '%', allowMissing);
	var intrinsicRealName = intrinsic.name;
	var value = intrinsic.value;
	var skipFurtherCaching = false;

	var alias = intrinsic.alias;
	if (alias) {
		intrinsicBaseName = alias[0];
		$spliceApply(parts, $concat([0, 1], alias));
	}

	for (var i = 1, isOwn = true; i < parts.length; i += 1) {
		var part = parts[i];
		var first = $strSlice(part, 0, 1);
		var last = $strSlice(part, -1);
		if (
			(
				(first === '"' || first === "'" || first === '`')
				|| (last === '"' || last === "'" || last === '`')
			)
			&& first !== last
		) {
			throw new $SyntaxError('property names with quotes must have matching quotes');
		}
		if (part === 'constructor' || !isOwn) {
			skipFurtherCaching = true;
		}

		intrinsicBaseName += '.' + part;
		intrinsicRealName = '%' + intrinsicBaseName + '%';

		if (hasOwn(INTRINSICS, intrinsicRealName)) {
			value = INTRINSICS[intrinsicRealName];
		} else if (value != null) {
			if (!(part in value)) {
				if (!allowMissing) {
					throw new $TypeError('base intrinsic for ' + name + ' exists, but the property is not available.');
				}
				return void undefined;
			}
			if ($gOPD && (i + 1) >= parts.length) {
				var desc = $gOPD(value, part);
				isOwn = !!desc;

				// By convention, when a data property is converted to an accessor
				// property to emulate a data property that does not suffer from
				// the override mistake, that accessor's getter is marked with
				// an `originalValue` property. Here, when we detect this, we
				// uphold the illusion by pretending to see that original data
				// property, i.e., returning the value rather than the getter
				// itself.
				if (isOwn && 'get' in desc && !('originalValue' in desc.get)) {
					value = desc.get;
				} else {
					value = value[part];
				}
			} else {
				isOwn = hasOwn(value, part);
				value = value[part];
			}

			if (isOwn && !skipFurtherCaching) {
				INTRINSICS[intrinsicRealName] = value;
			}
		}
	}
	return value;
};


/***/ }),

/***/ 1207:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var origSymbol = typeof Symbol !== 'undefined' && Symbol;
var hasSymbolSham = __webpack_require__(2326);

module.exports = function hasNativeSymbols() {
	if (typeof origSymbol !== 'function') { return false; }
	if (typeof Symbol !== 'function') { return false; }
	if (typeof origSymbol('foo') !== 'symbol') { return false; }
	if (typeof Symbol('bar') !== 'symbol') { return false; }

	return hasSymbolSham();
};


/***/ }),

/***/ 2326:
/***/ (function(module) {

"use strict";


/* eslint complexity: [2, 18], max-statements: [2, 33] */
module.exports = function hasSymbols() {
	if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
	if (typeof Symbol.iterator === 'symbol') { return true; }

	var obj = {};
	var sym = Symbol('test');
	var symObj = Object(sym);
	if (typeof sym === 'string') { return false; }

	if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
	if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

	// temp disabled per https://github.com/ljharb/object.assign/issues/17
	// if (sym instanceof Symbol) { return false; }
	// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
	// if (!(symObj instanceof Symbol)) { return false; }

	// if (typeof Symbol.prototype.toString !== 'function') { return false; }
	// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

	var symVal = 42;
	obj[sym] = symVal;
	for (sym in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
	if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

	if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

	var syms = Object.getOwnPropertySymbols(obj);
	if (syms.length !== 1 || syms[0] !== sym) { return false; }

	if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

	if (typeof Object.getOwnPropertyDescriptor === 'function') {
		var descriptor = Object.getOwnPropertyDescriptor(obj, sym);
		if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
	}

	return true;
};


/***/ }),

/***/ 5467:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var RequireObjectCoercible = __webpack_require__(7998);
var ToString = __webpack_require__(6245);
var callBound = __webpack_require__(6907);
var $replace = callBound('String.prototype.replace');

var mvsIsWS = (/^\s$/).test('\u180E');
/* eslint-disable no-control-regex */
var leftWhitespace = mvsIsWS
	? /^[\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF]+/
	: /^[\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF]+/;
var rightWhitespace = mvsIsWS
	? /[\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF]+$/
	: /[\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF]+$/;
/* eslint-enable no-control-regex */

module.exports = function trim() {
	var S = ToString(RequireObjectCoercible(this));
	return $replace($replace(S, leftWhitespace, ''), rightWhitespace, '');
};


/***/ }),

/***/ 4113:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var callBind = __webpack_require__(7618);
var define = __webpack_require__(5213);
var RequireObjectCoercible = __webpack_require__(7998);

var implementation = __webpack_require__(5467);
var getPolyfill = __webpack_require__(5626);
var shim = __webpack_require__(1029);

var bound = callBind(getPolyfill());
var boundMethod = function trim(receiver) {
	RequireObjectCoercible(receiver);
	return bound(receiver);
};

define(boundMethod, {
	getPolyfill: getPolyfill,
	implementation: implementation,
	shim: shim
});

module.exports = boundMethod;


/***/ }),

/***/ 6907:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(5037);

var callBind = __webpack_require__(7618);

var $indexOf = callBind(GetIntrinsic('String.prototype.indexOf'));

module.exports = function callBoundIntrinsic(name, allowMissing) {
	var intrinsic = GetIntrinsic(name, !!allowMissing);
	if (typeof intrinsic === 'function' && $indexOf(name, '.prototype.') > -1) {
		return callBind(intrinsic);
	}
	return intrinsic;
};


/***/ }),

/***/ 7618:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var bind = __webpack_require__(1769);
var GetIntrinsic = __webpack_require__(5037);
var setFunctionLength = __webpack_require__(4521);

var $TypeError = __webpack_require__(1642);
var $apply = GetIntrinsic('%Function.prototype.apply%');
var $call = GetIntrinsic('%Function.prototype.call%');
var $reflectApply = GetIntrinsic('%Reflect.apply%', true) || bind.call($call, $apply);

var $defineProperty = __webpack_require__(8918);
var $max = GetIntrinsic('%Math.max%');

module.exports = function callBind(originalFunction) {
	if (typeof originalFunction !== 'function') {
		throw new $TypeError('a function is required');
	}
	var func = $reflectApply(bind, $call, arguments);
	return setFunctionLength(
		func,
		1 + $max(0, originalFunction.length - (arguments.length - 1)),
		true
	);
};

var applyBind = function applyBind() {
	return $reflectApply(bind, $apply, arguments);
};

if ($defineProperty) {
	$defineProperty(module.exports, 'apply', { value: applyBind });
} else {
	module.exports.apply = applyBind;
}


/***/ }),

/***/ 5213:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var keys = __webpack_require__(806);
var hasSymbols = typeof Symbol === 'function' && typeof Symbol('foo') === 'symbol';

var toStr = Object.prototype.toString;
var concat = Array.prototype.concat;
var defineDataProperty = __webpack_require__(2656);

var isFunction = function (fn) {
	return typeof fn === 'function' && toStr.call(fn) === '[object Function]';
};

var supportsDescriptors = __webpack_require__(8198)();

var defineProperty = function (object, name, value, predicate) {
	if (name in object) {
		if (predicate === true) {
			if (object[name] === value) {
				return;
			}
		} else if (!isFunction(predicate) || !predicate()) {
			return;
		}
	}

	if (supportsDescriptors) {
		defineDataProperty(object, name, value, true);
	} else {
		defineDataProperty(object, name, value);
	}
};

var defineProperties = function (object, map) {
	var predicates = arguments.length > 2 ? arguments[2] : {};
	var props = keys(map);
	if (hasSymbols) {
		props = concat.call(props, Object.getOwnPropertySymbols(map));
	}
	for (var i = 0; i < props.length; i += 1) {
		defineProperty(object, props[i], map[props[i]], predicates[props[i]]);
	}
};

defineProperties.supportsDescriptors = !!supportsDescriptors;

module.exports = defineProperties;


/***/ }),

/***/ 1032:
/***/ (function(module) {

"use strict";


/* eslint no-invalid-this: 1 */

var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
var toStr = Object.prototype.toString;
var max = Math.max;
var funcType = '[object Function]';

var concatty = function concatty(a, b) {
    var arr = [];

    for (var i = 0; i < a.length; i += 1) {
        arr[i] = a[i];
    }
    for (var j = 0; j < b.length; j += 1) {
        arr[j + a.length] = b[j];
    }

    return arr;
};

var slicy = function slicy(arrLike, offset) {
    var arr = [];
    for (var i = offset || 0, j = 0; i < arrLike.length; i += 1, j += 1) {
        arr[j] = arrLike[i];
    }
    return arr;
};

var joiny = function (arr, joiner) {
    var str = '';
    for (var i = 0; i < arr.length; i += 1) {
        str += arr[i];
        if (i + 1 < arr.length) {
            str += joiner;
        }
    }
    return str;
};

module.exports = function bind(that) {
    var target = this;
    if (typeof target !== 'function' || toStr.apply(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
    }
    var args = slicy(arguments, 1);

    var bound;
    var binder = function () {
        if (this instanceof bound) {
            var result = target.apply(
                this,
                concatty(args, arguments)
            );
            if (Object(result) === result) {
                return result;
            }
            return this;
        }
        return target.apply(
            that,
            concatty(args, arguments)
        );

    };

    var boundLength = max(0, target.length - args.length);
    var boundArgs = [];
    for (var i = 0; i < boundLength; i++) {
        boundArgs[i] = '$' + i;
    }

    bound = Function('binder', 'return function (' + joiny(boundArgs, ',') + '){ return binder.apply(this,arguments); }')(binder);

    if (target.prototype) {
        var Empty = function Empty() {};
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
    }

    return bound;
};


/***/ }),

/***/ 1769:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var implementation = __webpack_require__(1032);

module.exports = Function.prototype.bind || implementation;


/***/ }),

/***/ 5037:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var undefined;

var $Error = __webpack_require__(6716);
var $EvalError = __webpack_require__(6788);
var $RangeError = __webpack_require__(9204);
var $ReferenceError = __webpack_require__(9908);
var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);
var $URIError = __webpack_require__(1451);

var $Function = Function;

// eslint-disable-next-line consistent-return
var getEvalledConstructor = function (expressionSyntax) {
	try {
		return $Function('"use strict"; return (' + expressionSyntax + ').constructor;')();
	} catch (e) {}
};

var $gOPD = Object.getOwnPropertyDescriptor;
if ($gOPD) {
	try {
		$gOPD({}, '');
	} catch (e) {
		$gOPD = null; // this is IE 8, which has a broken gOPD
	}
}

var throwTypeError = function () {
	throw new $TypeError();
};
var ThrowTypeError = $gOPD
	? (function () {
		try {
			// eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
			arguments.callee; // IE 8 does not throw here
			return throwTypeError;
		} catch (calleeThrows) {
			try {
				// IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
				return $gOPD(arguments, 'callee').get;
			} catch (gOPDthrows) {
				return throwTypeError;
			}
		}
	}())
	: throwTypeError;

var hasSymbols = __webpack_require__(5570)();
var hasProto = __webpack_require__(1856)();

var getProto = Object.getPrototypeOf || (
	hasProto
		? function (x) { return x.__proto__; } // eslint-disable-line no-proto
		: null
);

var needsEval = {};

var TypedArray = typeof Uint8Array === 'undefined' || !getProto ? undefined : getProto(Uint8Array);

var INTRINSICS = {
	__proto__: null,
	'%AggregateError%': typeof AggregateError === 'undefined' ? undefined : AggregateError,
	'%Array%': Array,
	'%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined : ArrayBuffer,
	'%ArrayIteratorPrototype%': hasSymbols && getProto ? getProto([][Symbol.iterator]()) : undefined,
	'%AsyncFromSyncIteratorPrototype%': undefined,
	'%AsyncFunction%': needsEval,
	'%AsyncGenerator%': needsEval,
	'%AsyncGeneratorFunction%': needsEval,
	'%AsyncIteratorPrototype%': needsEval,
	'%Atomics%': typeof Atomics === 'undefined' ? undefined : Atomics,
	'%BigInt%': typeof BigInt === 'undefined' ? undefined : BigInt,
	'%BigInt64Array%': typeof BigInt64Array === 'undefined' ? undefined : BigInt64Array,
	'%BigUint64Array%': typeof BigUint64Array === 'undefined' ? undefined : BigUint64Array,
	'%Boolean%': Boolean,
	'%DataView%': typeof DataView === 'undefined' ? undefined : DataView,
	'%Date%': Date,
	'%decodeURI%': decodeURI,
	'%decodeURIComponent%': decodeURIComponent,
	'%encodeURI%': encodeURI,
	'%encodeURIComponent%': encodeURIComponent,
	'%Error%': $Error,
	'%eval%': eval, // eslint-disable-line no-eval
	'%EvalError%': $EvalError,
	'%Float32Array%': typeof Float32Array === 'undefined' ? undefined : Float32Array,
	'%Float64Array%': typeof Float64Array === 'undefined' ? undefined : Float64Array,
	'%FinalizationRegistry%': typeof FinalizationRegistry === 'undefined' ? undefined : FinalizationRegistry,
	'%Function%': $Function,
	'%GeneratorFunction%': needsEval,
	'%Int8Array%': typeof Int8Array === 'undefined' ? undefined : Int8Array,
	'%Int16Array%': typeof Int16Array === 'undefined' ? undefined : Int16Array,
	'%Int32Array%': typeof Int32Array === 'undefined' ? undefined : Int32Array,
	'%isFinite%': isFinite,
	'%isNaN%': isNaN,
	'%IteratorPrototype%': hasSymbols && getProto ? getProto(getProto([][Symbol.iterator]())) : undefined,
	'%JSON%': typeof JSON === 'object' ? JSON : undefined,
	'%Map%': typeof Map === 'undefined' ? undefined : Map,
	'%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Map()[Symbol.iterator]()),
	'%Math%': Math,
	'%Number%': Number,
	'%Object%': Object,
	'%parseFloat%': parseFloat,
	'%parseInt%': parseInt,
	'%Promise%': typeof Promise === 'undefined' ? undefined : Promise,
	'%Proxy%': typeof Proxy === 'undefined' ? undefined : Proxy,
	'%RangeError%': $RangeError,
	'%ReferenceError%': $ReferenceError,
	'%Reflect%': typeof Reflect === 'undefined' ? undefined : Reflect,
	'%RegExp%': RegExp,
	'%Set%': typeof Set === 'undefined' ? undefined : Set,
	'%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Set()[Symbol.iterator]()),
	'%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined : SharedArrayBuffer,
	'%String%': String,
	'%StringIteratorPrototype%': hasSymbols && getProto ? getProto(''[Symbol.iterator]()) : undefined,
	'%Symbol%': hasSymbols ? Symbol : undefined,
	'%SyntaxError%': $SyntaxError,
	'%ThrowTypeError%': ThrowTypeError,
	'%TypedArray%': TypedArray,
	'%TypeError%': $TypeError,
	'%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined : Uint8Array,
	'%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined : Uint8ClampedArray,
	'%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined : Uint16Array,
	'%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined : Uint32Array,
	'%URIError%': $URIError,
	'%WeakMap%': typeof WeakMap === 'undefined' ? undefined : WeakMap,
	'%WeakRef%': typeof WeakRef === 'undefined' ? undefined : WeakRef,
	'%WeakSet%': typeof WeakSet === 'undefined' ? undefined : WeakSet
};

if (getProto) {
	try {
		null.error; // eslint-disable-line no-unused-expressions
	} catch (e) {
		// https://github.com/tc39/proposal-shadowrealm/pull/384#issuecomment-1364264229
		var errorProto = getProto(getProto(e));
		INTRINSICS['%Error.prototype%'] = errorProto;
	}
}

var doEval = function doEval(name) {
	var value;
	if (name === '%AsyncFunction%') {
		value = getEvalledConstructor('async function () {}');
	} else if (name === '%GeneratorFunction%') {
		value = getEvalledConstructor('function* () {}');
	} else if (name === '%AsyncGeneratorFunction%') {
		value = getEvalledConstructor('async function* () {}');
	} else if (name === '%AsyncGenerator%') {
		var fn = doEval('%AsyncGeneratorFunction%');
		if (fn) {
			value = fn.prototype;
		}
	} else if (name === '%AsyncIteratorPrototype%') {
		var gen = doEval('%AsyncGenerator%');
		if (gen && getProto) {
			value = getProto(gen.prototype);
		}
	}

	INTRINSICS[name] = value;

	return value;
};

var LEGACY_ALIASES = {
	__proto__: null,
	'%ArrayBufferPrototype%': ['ArrayBuffer', 'prototype'],
	'%ArrayPrototype%': ['Array', 'prototype'],
	'%ArrayProto_entries%': ['Array', 'prototype', 'entries'],
	'%ArrayProto_forEach%': ['Array', 'prototype', 'forEach'],
	'%ArrayProto_keys%': ['Array', 'prototype', 'keys'],
	'%ArrayProto_values%': ['Array', 'prototype', 'values'],
	'%AsyncFunctionPrototype%': ['AsyncFunction', 'prototype'],
	'%AsyncGenerator%': ['AsyncGeneratorFunction', 'prototype'],
	'%AsyncGeneratorPrototype%': ['AsyncGeneratorFunction', 'prototype', 'prototype'],
	'%BooleanPrototype%': ['Boolean', 'prototype'],
	'%DataViewPrototype%': ['DataView', 'prototype'],
	'%DatePrototype%': ['Date', 'prototype'],
	'%ErrorPrototype%': ['Error', 'prototype'],
	'%EvalErrorPrototype%': ['EvalError', 'prototype'],
	'%Float32ArrayPrototype%': ['Float32Array', 'prototype'],
	'%Float64ArrayPrototype%': ['Float64Array', 'prototype'],
	'%FunctionPrototype%': ['Function', 'prototype'],
	'%Generator%': ['GeneratorFunction', 'prototype'],
	'%GeneratorPrototype%': ['GeneratorFunction', 'prototype', 'prototype'],
	'%Int8ArrayPrototype%': ['Int8Array', 'prototype'],
	'%Int16ArrayPrototype%': ['Int16Array', 'prototype'],
	'%Int32ArrayPrototype%': ['Int32Array', 'prototype'],
	'%JSONParse%': ['JSON', 'parse'],
	'%JSONStringify%': ['JSON', 'stringify'],
	'%MapPrototype%': ['Map', 'prototype'],
	'%NumberPrototype%': ['Number', 'prototype'],
	'%ObjectPrototype%': ['Object', 'prototype'],
	'%ObjProto_toString%': ['Object', 'prototype', 'toString'],
	'%ObjProto_valueOf%': ['Object', 'prototype', 'valueOf'],
	'%PromisePrototype%': ['Promise', 'prototype'],
	'%PromiseProto_then%': ['Promise', 'prototype', 'then'],
	'%Promise_all%': ['Promise', 'all'],
	'%Promise_reject%': ['Promise', 'reject'],
	'%Promise_resolve%': ['Promise', 'resolve'],
	'%RangeErrorPrototype%': ['RangeError', 'prototype'],
	'%ReferenceErrorPrototype%': ['ReferenceError', 'prototype'],
	'%RegExpPrototype%': ['RegExp', 'prototype'],
	'%SetPrototype%': ['Set', 'prototype'],
	'%SharedArrayBufferPrototype%': ['SharedArrayBuffer', 'prototype'],
	'%StringPrototype%': ['String', 'prototype'],
	'%SymbolPrototype%': ['Symbol', 'prototype'],
	'%SyntaxErrorPrototype%': ['SyntaxError', 'prototype'],
	'%TypedArrayPrototype%': ['TypedArray', 'prototype'],
	'%TypeErrorPrototype%': ['TypeError', 'prototype'],
	'%Uint8ArrayPrototype%': ['Uint8Array', 'prototype'],
	'%Uint8ClampedArrayPrototype%': ['Uint8ClampedArray', 'prototype'],
	'%Uint16ArrayPrototype%': ['Uint16Array', 'prototype'],
	'%Uint32ArrayPrototype%': ['Uint32Array', 'prototype'],
	'%URIErrorPrototype%': ['URIError', 'prototype'],
	'%WeakMapPrototype%': ['WeakMap', 'prototype'],
	'%WeakSetPrototype%': ['WeakSet', 'prototype']
};

var bind = __webpack_require__(1769);
var hasOwn = __webpack_require__(9429);
var $concat = bind.call(Function.call, Array.prototype.concat);
var $spliceApply = bind.call(Function.apply, Array.prototype.splice);
var $replace = bind.call(Function.call, String.prototype.replace);
var $strSlice = bind.call(Function.call, String.prototype.slice);
var $exec = bind.call(Function.call, RegExp.prototype.exec);

/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */
var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
var reEscapeChar = /\\(\\)?/g; /** Used to match backslashes in property paths. */
var stringToPath = function stringToPath(string) {
	var first = $strSlice(string, 0, 1);
	var last = $strSlice(string, -1);
	if (first === '%' && last !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected closing `%`');
	} else if (last === '%' && first !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected opening `%`');
	}
	var result = [];
	$replace(string, rePropName, function (match, number, quote, subString) {
		result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
	});
	return result;
};
/* end adaptation */

var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
	var intrinsicName = name;
	var alias;
	if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
		alias = LEGACY_ALIASES[intrinsicName];
		intrinsicName = '%' + alias[0] + '%';
	}

	if (hasOwn(INTRINSICS, intrinsicName)) {
		var value = INTRINSICS[intrinsicName];
		if (value === needsEval) {
			value = doEval(intrinsicName);
		}
		if (typeof value === 'undefined' && !allowMissing) {
			throw new $TypeError('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
		}

		return {
			alias: alias,
			name: intrinsicName,
			value: value
		};
	}

	throw new $SyntaxError('intrinsic ' + name + ' does not exist!');
};

module.exports = function GetIntrinsic(name, allowMissing) {
	if (typeof name !== 'string' || name.length === 0) {
		throw new $TypeError('intrinsic name must be a non-empty string');
	}
	if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
		throw new $TypeError('"allowMissing" argument must be a boolean');
	}

	if ($exec(/^%?[^%]*%?$/, name) === null) {
		throw new $SyntaxError('`%` may not be present anywhere but at the beginning and end of the intrinsic name');
	}
	var parts = stringToPath(name);
	var intrinsicBaseName = parts.length > 0 ? parts[0] : '';

	var intrinsic = getBaseIntrinsic('%' + intrinsicBaseName + '%', allowMissing);
	var intrinsicRealName = intrinsic.name;
	var value = intrinsic.value;
	var skipFurtherCaching = false;

	var alias = intrinsic.alias;
	if (alias) {
		intrinsicBaseName = alias[0];
		$spliceApply(parts, $concat([0, 1], alias));
	}

	for (var i = 1, isOwn = true; i < parts.length; i += 1) {
		var part = parts[i];
		var first = $strSlice(part, 0, 1);
		var last = $strSlice(part, -1);
		if (
			(
				(first === '"' || first === "'" || first === '`')
				|| (last === '"' || last === "'" || last === '`')
			)
			&& first !== last
		) {
			throw new $SyntaxError('property names with quotes must have matching quotes');
		}
		if (part === 'constructor' || !isOwn) {
			skipFurtherCaching = true;
		}

		intrinsicBaseName += '.' + part;
		intrinsicRealName = '%' + intrinsicBaseName + '%';

		if (hasOwn(INTRINSICS, intrinsicRealName)) {
			value = INTRINSICS[intrinsicRealName];
		} else if (value != null) {
			if (!(part in value)) {
				if (!allowMissing) {
					throw new $TypeError('base intrinsic for ' + name + ' exists, but the property is not available.');
				}
				return void undefined;
			}
			if ($gOPD && (i + 1) >= parts.length) {
				var desc = $gOPD(value, part);
				isOwn = !!desc;

				// By convention, when a data property is converted to an accessor
				// property to emulate a data property that does not suffer from
				// the override mistake, that accessor's getter is marked with
				// an `originalValue` property. Here, when we detect this, we
				// uphold the illusion by pretending to see that original data
				// property, i.e., returning the value rather than the getter
				// itself.
				if (isOwn && 'get' in desc && !('originalValue' in desc.get)) {
					value = desc.get;
				} else {
					value = value[part];
				}
			} else {
				isOwn = hasOwn(value, part);
				value = value[part];
			}

			if (isOwn && !skipFurtherCaching) {
				INTRINSICS[intrinsicRealName] = value;
			}
		}
	}
	return value;
};


/***/ }),

/***/ 5570:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var origSymbol = typeof Symbol !== 'undefined' && Symbol;
var hasSymbolSham = __webpack_require__(5889);

module.exports = function hasNativeSymbols() {
	if (typeof origSymbol !== 'function') { return false; }
	if (typeof Symbol !== 'function') { return false; }
	if (typeof origSymbol('foo') !== 'symbol') { return false; }
	if (typeof Symbol('bar') !== 'symbol') { return false; }

	return hasSymbolSham();
};


/***/ }),

/***/ 5889:
/***/ (function(module) {

"use strict";


/* eslint complexity: [2, 18], max-statements: [2, 33] */
module.exports = function hasSymbols() {
	if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
	if (typeof Symbol.iterator === 'symbol') { return true; }

	var obj = {};
	var sym = Symbol('test');
	var symObj = Object(sym);
	if (typeof sym === 'string') { return false; }

	if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
	if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

	// temp disabled per https://github.com/ljharb/object.assign/issues/17
	// if (sym instanceof Symbol) { return false; }
	// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
	// if (!(symObj instanceof Symbol)) { return false; }

	// if (typeof Symbol.prototype.toString !== 'function') { return false; }
	// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

	var symVal = 42;
	obj[sym] = symVal;
	for (sym in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
	if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

	if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

	var syms = Object.getOwnPropertySymbols(obj);
	if (syms.length !== 1 || syms[0] !== sym) { return false; }

	if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

	if (typeof Object.getOwnPropertyDescriptor === 'function') {
		var descriptor = Object.getOwnPropertyDescriptor(obj, sym);
		if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
	}

	return true;
};


/***/ }),

/***/ 5626:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var implementation = __webpack_require__(5467);

var zeroWidthSpace = '\u200b';
var mongolianVowelSeparator = '\u180E';

module.exports = function getPolyfill() {
	if (
		String.prototype.trim
		&& zeroWidthSpace.trim() === zeroWidthSpace
		&& mongolianVowelSeparator.trim() === mongolianVowelSeparator
		&& ('_' + mongolianVowelSeparator).trim() === ('_' + mongolianVowelSeparator)
		&& (mongolianVowelSeparator + '_').trim() === (mongolianVowelSeparator + '_')
	) {
		return String.prototype.trim;
	}
	return implementation;
};


/***/ }),

/***/ 1029:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var define = __webpack_require__(5213);
var getPolyfill = __webpack_require__(5626);

module.exports = function shimStringTrim() {
	var polyfill = getPolyfill();
	define(String.prototype, { trim: polyfill }, {
		trim: function testTrim() {
			return String.prototype.trim !== polyfill;
		}
	});
	return polyfill;
};


/***/ }),

/***/ 3124:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var whichTypedArray = __webpack_require__(4010);
var taSlice = __webpack_require__(1140);
var gopd = __webpack_require__(3828);

// TODO: use call-bind, is-date, is-regex, is-string, is-boolean-object, is-number-object
function toS(obj) { return Object.prototype.toString.call(obj); }
function isDate(obj) { return toS(obj) === '[object Date]'; }
function isRegExp(obj) { return toS(obj) === '[object RegExp]'; }
function isError(obj) { return toS(obj) === '[object Error]'; }
function isBoolean(obj) { return toS(obj) === '[object Boolean]'; }
function isNumber(obj) { return toS(obj) === '[object Number]'; }
function isString(obj) { return toS(obj) === '[object String]'; }

// TODO: use isarray
var isArray = Array.isArray || function isArray(xs) {
	return Object.prototype.toString.call(xs) === '[object Array]';
};

// TODO: use for-each?
function forEach(xs, fn) {
	if (xs.forEach) { return xs.forEach(fn); }
	for (var i = 0; i < xs.length; i++) {
		fn(xs[i], i, xs);
	}
	return void undefined;
}

// TODO: use object-keys
var objectKeys = Object.keys || function keys(obj) {
	var res = [];
	for (var key in obj) { res.push(key); } // eslint-disable-line no-restricted-syntax
	return res;
};

var propertyIsEnumerable = Object.prototype.propertyIsEnumerable;
var getOwnPropertySymbols = Object.getOwnPropertySymbols; // eslint-disable-line id-length

// TODO: use reflect.ownkeys and filter out non-enumerables
function ownEnumerableKeys(obj) {
	var res = objectKeys(obj);

	// Include enumerable symbol properties.
	if (getOwnPropertySymbols) {
		var symbols = getOwnPropertySymbols(obj);
		for (var i = 0; i < symbols.length; i++) {
			if (propertyIsEnumerable.call(obj, symbols[i])) {
				res.push(symbols[i]);
			}
		}
	}
	return res;
}

// TODO: use object.hasown
var hasOwnProperty = Object.prototype.hasOwnProperty || function (obj, key) {
	return key in obj;
};

function isWritable(object, key) {
	if (typeof gopd !== 'function') {
		return true;
	}

	return !gopd(object, key).writable;
}

function copy(src, options) {
	if (typeof src === 'object' && src !== null) {
		var dst;

		if (isArray(src)) {
			dst = [];
		} else if (isDate(src)) {
			dst = new Date(src.getTime ? src.getTime() : src);
		} else if (isRegExp(src)) {
			dst = new RegExp(src);
		} else if (isError(src)) {
			dst = { message: src.message };
		} else if (isBoolean(src) || isNumber(src) || isString(src)) {
			dst = Object(src);
		} else {
			var ta = whichTypedArray(src);
			if (ta) {
				return taSlice(src);
			} else if (Object.create && Object.getPrototypeOf) {
				dst = Object.create(Object.getPrototypeOf(src));
			} else if (src.constructor === Object) {
				dst = {};
			} else {
				var proto = (src.constructor && src.constructor.prototype)
					|| src.__proto__
					|| {};
				var T = function T() {}; // eslint-disable-line func-style, func-name-matching
				T.prototype = proto;
				dst = new T();
			}
		}

		var iteratorFunction = options.includeSymbols ? ownEnumerableKeys : objectKeys;
		forEach(iteratorFunction(src), function (key) {
			dst[key] = src[key];
		});
		return dst;
	}
	return src;
}

/** @type {TraverseOptions} */
var emptyNull = { __proto__: null };

function walk(root, cb) {
	var path = [];
	var parents = [];
	var alive = true;
	var options = arguments.length > 2 ? arguments[2] : emptyNull;
	var iteratorFunction = options.includeSymbols ? ownEnumerableKeys : objectKeys;
	var immutable = !!options.immutable;

	return (function walker(node_) {
		var node = immutable ? copy(node_, options) : node_;
		var modifiers = {};

		var keepGoing = true;

		var state = {
			node: node,
			node_: node_,
			path: [].concat(path),
			parent: parents[parents.length - 1],
			parents: parents,
			key: path[path.length - 1],
			isRoot: path.length === 0,
			level: path.length,
			circular: null,
			update: function (x, stopHere) {
				if (!state.isRoot) {
					state.parent.node[state.key] = x;
				}
				state.node = x;
				if (stopHere) { keepGoing = false; }
			},
			delete: function (stopHere) {
				delete state.parent.node[state.key];
				if (stopHere) { keepGoing = false; }
			},
			remove: function (stopHere) {
				if (isArray(state.parent.node)) {
					state.parent.node.splice(state.key, 1);
				} else {
					delete state.parent.node[state.key];
				}
				if (stopHere) { keepGoing = false; }
			},
			keys: null,
			before: function (f) { modifiers.before = f; },
			after: function (f) { modifiers.after = f; },
			pre: function (f) { modifiers.pre = f; },
			post: function (f) { modifiers.post = f; },
			stop: function () { alive = false; },
			block: function () { keepGoing = false; },
		};

		if (!alive) { return state; }

		function updateState() {
			if (typeof state.node === 'object' && state.node !== null) {
				if (!state.keys || state.node_ !== state.node) {
					state.keys = iteratorFunction(state.node);
				}

				state.isLeaf = state.keys.length === 0;

				for (var i = 0; i < parents.length; i++) {
					if (parents[i].node_ === node_) {
						state.circular = parents[i];
						break; // eslint-disable-line no-restricted-syntax
					}
				}
			} else {
				state.isLeaf = true;
				state.keys = null;
			}

			state.notLeaf = !state.isLeaf;
			state.notRoot = !state.isRoot;
		}

		updateState();

		// use return values to update if defined
		var ret = cb.call(state, state.node);
		if (ret !== undefined && state.update) { state.update(ret); }

		if (modifiers.before) { modifiers.before.call(state, state.node); }

		if (!keepGoing) { return state; }

		if (
			typeof state.node === 'object'
			&& state.node !== null
			&& !state.circular
		) {
			parents.push(state);

			updateState();

			forEach(state.keys, function (key, i) {
				path.push(key);

				if (modifiers.pre) { modifiers.pre.call(state, state.node[key], key); }

				var child = walker(state.node[key]);
				if (
					immutable
					&& hasOwnProperty.call(state.node, key)
					&& !isWritable(state.node, key)
				) {
					state.node[key] = child.node;
				}

				child.isLast = i === state.keys.length - 1;
				child.isFirst = i === 0;

				if (modifiers.post) { modifiers.post.call(state, child); }

				path.pop();
			});
			parents.pop();
		}

		if (modifiers.after) { modifiers.after.call(state, state.node); }

		return state;
	}(root)).node;
}

/** @typedef {{ immutable?: boolean, includeSymbols?: boolean }} TraverseOptions */

/**
 * A traverse constructor
 * @param {object} obj - the object to traverse
 * @param {TraverseOptions | undefined} [options] - options for the traverse
 * @constructor
 */
function Traverse(obj) {
	/** @type {TraverseOptions} */
	this.options = arguments.length > 1 ? arguments[1] : emptyNull;
	this.value = obj;
}

/** @type {(ps: PropertyKey[]) => Traverse['value']} */
Traverse.prototype.get = function (ps) {
	var node = this.value;
	for (var i = 0; node && i < ps.length; i++) {
		var key = ps[i];
		if (
			!hasOwnProperty.call(node, key)
			|| (!this.options.includeSymbols && typeof key === 'symbol')
		) {
			return void undefined;
		}
		node = node[key];
	}
	return node;
};

/** @type {(ps: PropertyKey[]) => boolean} */
Traverse.prototype.has = function (ps) {
	var node = this.value;
	for (var i = 0; node && i < ps.length; i++) {
		var key = ps[i];
		if (!hasOwnProperty.call(node, key) || (!this.options.includeSymbols && typeof key === 'symbol')) {
			return false;
		}
		node = node[key];
	}
	return true;
};

Traverse.prototype.set = function (ps, value) {
	var node = this.value;
	for (var i = 0; i < ps.length - 1; i++) {
		var key = ps[i];
		if (!hasOwnProperty.call(node, key)) { node[key] = {}; }
		node = node[key];
	}
	node[ps[i]] = value;
	return value;
};

Traverse.prototype.map = function (cb) {
	return walk(this.value, cb, { __proto__: null, immutable: true, includeSymbols: !!this.options.includeSymbols });
};

Traverse.prototype.forEach = function (cb) {
	this.value = walk(this.value, cb, this.options);
	return this.value;
};

Traverse.prototype.reduce = function (cb, init) {
	var skip = arguments.length === 1;
	var acc = skip ? this.value : init;
	this.forEach(function (x) {
		if (!this.isRoot || !skip) {
			acc = cb.call(this, acc, x);
		}
	});
	return acc;
};

Traverse.prototype.paths = function () {
	var acc = [];
	this.forEach(function () {
		acc.push(this.path);
	});
	return acc;
};

Traverse.prototype.nodes = function () {
	var acc = [];
	this.forEach(function () {
		acc.push(this.node);
	});
	return acc;
};

Traverse.prototype.clone = function () {
	var parents = [];
	var nodes = [];
	var options = this.options;

	if (whichTypedArray(this.value)) {
		return taSlice(this.value);
	}

	return (function clone(src) {
		for (var i = 0; i < parents.length; i++) {
			if (parents[i] === src) {
				return nodes[i];
			}
		}

		if (typeof src === 'object' && src !== null) {
			var dst = copy(src, options);

			parents.push(src);
			nodes.push(dst);

			var iteratorFunction = options.includeSymbols ? ownEnumerableKeys : objectKeys;
			forEach(iteratorFunction(src), function (key) {
				dst[key] = clone(src[key]);
			});

			parents.pop();
			nodes.pop();
			return dst;
		}

		return src;

	}(this.value));
};

/** @type {(obj: object, options?: TraverseOptions) => Traverse} */
function traverse(obj) {
	var options = arguments.length > 1 ? arguments[1] : emptyNull;
	return new Traverse(obj, options);
}

// TODO: replace with object.assign?
forEach(ownEnumerableKeys(Traverse.prototype), function (key) {
	traverse[key] = function (obj) {
		var args = [].slice.call(arguments, 1);
		var t = new Traverse(obj);
		return t[key].apply(t, args);
	};
});

module.exports = traverse;


/***/ }),

/***/ 6740:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $TypeError = __webpack_require__(1642);

var callBound = __webpack_require__(6798);

var $typedArrayBuffer = callBound('TypedArray.prototype.buffer', true);

var isTypedArray = __webpack_require__(2527);

/** @type {import('.')} */
// node <= 0.10, < 0.11.4 has a nonconfigurable own property instead of a prototype getter
module.exports = $typedArrayBuffer || function typedArrayBuffer(x) {
	if (!isTypedArray(x)) {
		throw new $TypeError('Not a Typed Array');
	}
	return x.buffer;
};


/***/ }),

/***/ 6798:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(1634);

var callBind = __webpack_require__(8388);

var $indexOf = callBind(GetIntrinsic('String.prototype.indexOf'));

module.exports = function callBoundIntrinsic(name, allowMissing) {
	var intrinsic = GetIntrinsic(name, !!allowMissing);
	if (typeof intrinsic === 'function' && $indexOf(name, '.prototype.') > -1) {
		return callBind(intrinsic);
	}
	return intrinsic;
};


/***/ }),

/***/ 8388:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var bind = __webpack_require__(7715);
var GetIntrinsic = __webpack_require__(1634);
var setFunctionLength = __webpack_require__(4521);

var $TypeError = __webpack_require__(1642);
var $apply = GetIntrinsic('%Function.prototype.apply%');
var $call = GetIntrinsic('%Function.prototype.call%');
var $reflectApply = GetIntrinsic('%Reflect.apply%', true) || bind.call($call, $apply);

var $defineProperty = __webpack_require__(8918);
var $max = GetIntrinsic('%Math.max%');

module.exports = function callBind(originalFunction) {
	if (typeof originalFunction !== 'function') {
		throw new $TypeError('a function is required');
	}
	var func = $reflectApply(bind, $call, arguments);
	return setFunctionLength(
		func,
		1 + $max(0, originalFunction.length - (arguments.length - 1)),
		true
	);
};

var applyBind = function applyBind() {
	return $reflectApply(bind, $apply, arguments);
};

if ($defineProperty) {
	$defineProperty(module.exports, 'apply', { value: applyBind });
} else {
	module.exports.apply = applyBind;
}


/***/ }),

/***/ 9003:
/***/ (function(module) {

"use strict";


/* eslint no-invalid-this: 1 */

var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
var toStr = Object.prototype.toString;
var max = Math.max;
var funcType = '[object Function]';

var concatty = function concatty(a, b) {
    var arr = [];

    for (var i = 0; i < a.length; i += 1) {
        arr[i] = a[i];
    }
    for (var j = 0; j < b.length; j += 1) {
        arr[j + a.length] = b[j];
    }

    return arr;
};

var slicy = function slicy(arrLike, offset) {
    var arr = [];
    for (var i = offset || 0, j = 0; i < arrLike.length; i += 1, j += 1) {
        arr[j] = arrLike[i];
    }
    return arr;
};

var joiny = function (arr, joiner) {
    var str = '';
    for (var i = 0; i < arr.length; i += 1) {
        str += arr[i];
        if (i + 1 < arr.length) {
            str += joiner;
        }
    }
    return str;
};

module.exports = function bind(that) {
    var target = this;
    if (typeof target !== 'function' || toStr.apply(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
    }
    var args = slicy(arguments, 1);

    var bound;
    var binder = function () {
        if (this instanceof bound) {
            var result = target.apply(
                this,
                concatty(args, arguments)
            );
            if (Object(result) === result) {
                return result;
            }
            return this;
        }
        return target.apply(
            that,
            concatty(args, arguments)
        );

    };

    var boundLength = max(0, target.length - args.length);
    var boundArgs = [];
    for (var i = 0; i < boundLength; i++) {
        boundArgs[i] = '$' + i;
    }

    bound = Function('binder', 'return function (' + joiny(boundArgs, ',') + '){ return binder.apply(this,arguments); }')(binder);

    if (target.prototype) {
        var Empty = function Empty() {};
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
    }

    return bound;
};


/***/ }),

/***/ 7715:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var implementation = __webpack_require__(9003);

module.exports = Function.prototype.bind || implementation;


/***/ }),

/***/ 1634:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var undefined;

var $Error = __webpack_require__(6716);
var $EvalError = __webpack_require__(6788);
var $RangeError = __webpack_require__(9204);
var $ReferenceError = __webpack_require__(9908);
var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);
var $URIError = __webpack_require__(1451);

var $Function = Function;

// eslint-disable-next-line consistent-return
var getEvalledConstructor = function (expressionSyntax) {
	try {
		return $Function('"use strict"; return (' + expressionSyntax + ').constructor;')();
	} catch (e) {}
};

var $gOPD = Object.getOwnPropertyDescriptor;
if ($gOPD) {
	try {
		$gOPD({}, '');
	} catch (e) {
		$gOPD = null; // this is IE 8, which has a broken gOPD
	}
}

var throwTypeError = function () {
	throw new $TypeError();
};
var ThrowTypeError = $gOPD
	? (function () {
		try {
			// eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
			arguments.callee; // IE 8 does not throw here
			return throwTypeError;
		} catch (calleeThrows) {
			try {
				// IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
				return $gOPD(arguments, 'callee').get;
			} catch (gOPDthrows) {
				return throwTypeError;
			}
		}
	}())
	: throwTypeError;

var hasSymbols = __webpack_require__(263)();
var hasProto = __webpack_require__(1856)();

var getProto = Object.getPrototypeOf || (
	hasProto
		? function (x) { return x.__proto__; } // eslint-disable-line no-proto
		: null
);

var needsEval = {};

var TypedArray = typeof Uint8Array === 'undefined' || !getProto ? undefined : getProto(Uint8Array);

var INTRINSICS = {
	__proto__: null,
	'%AggregateError%': typeof AggregateError === 'undefined' ? undefined : AggregateError,
	'%Array%': Array,
	'%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined : ArrayBuffer,
	'%ArrayIteratorPrototype%': hasSymbols && getProto ? getProto([][Symbol.iterator]()) : undefined,
	'%AsyncFromSyncIteratorPrototype%': undefined,
	'%AsyncFunction%': needsEval,
	'%AsyncGenerator%': needsEval,
	'%AsyncGeneratorFunction%': needsEval,
	'%AsyncIteratorPrototype%': needsEval,
	'%Atomics%': typeof Atomics === 'undefined' ? undefined : Atomics,
	'%BigInt%': typeof BigInt === 'undefined' ? undefined : BigInt,
	'%BigInt64Array%': typeof BigInt64Array === 'undefined' ? undefined : BigInt64Array,
	'%BigUint64Array%': typeof BigUint64Array === 'undefined' ? undefined : BigUint64Array,
	'%Boolean%': Boolean,
	'%DataView%': typeof DataView === 'undefined' ? undefined : DataView,
	'%Date%': Date,
	'%decodeURI%': decodeURI,
	'%decodeURIComponent%': decodeURIComponent,
	'%encodeURI%': encodeURI,
	'%encodeURIComponent%': encodeURIComponent,
	'%Error%': $Error,
	'%eval%': eval, // eslint-disable-line no-eval
	'%EvalError%': $EvalError,
	'%Float32Array%': typeof Float32Array === 'undefined' ? undefined : Float32Array,
	'%Float64Array%': typeof Float64Array === 'undefined' ? undefined : Float64Array,
	'%FinalizationRegistry%': typeof FinalizationRegistry === 'undefined' ? undefined : FinalizationRegistry,
	'%Function%': $Function,
	'%GeneratorFunction%': needsEval,
	'%Int8Array%': typeof Int8Array === 'undefined' ? undefined : Int8Array,
	'%Int16Array%': typeof Int16Array === 'undefined' ? undefined : Int16Array,
	'%Int32Array%': typeof Int32Array === 'undefined' ? undefined : Int32Array,
	'%isFinite%': isFinite,
	'%isNaN%': isNaN,
	'%IteratorPrototype%': hasSymbols && getProto ? getProto(getProto([][Symbol.iterator]())) : undefined,
	'%JSON%': typeof JSON === 'object' ? JSON : undefined,
	'%Map%': typeof Map === 'undefined' ? undefined : Map,
	'%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Map()[Symbol.iterator]()),
	'%Math%': Math,
	'%Number%': Number,
	'%Object%': Object,
	'%parseFloat%': parseFloat,
	'%parseInt%': parseInt,
	'%Promise%': typeof Promise === 'undefined' ? undefined : Promise,
	'%Proxy%': typeof Proxy === 'undefined' ? undefined : Proxy,
	'%RangeError%': $RangeError,
	'%ReferenceError%': $ReferenceError,
	'%Reflect%': typeof Reflect === 'undefined' ? undefined : Reflect,
	'%RegExp%': RegExp,
	'%Set%': typeof Set === 'undefined' ? undefined : Set,
	'%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Set()[Symbol.iterator]()),
	'%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined : SharedArrayBuffer,
	'%String%': String,
	'%StringIteratorPrototype%': hasSymbols && getProto ? getProto(''[Symbol.iterator]()) : undefined,
	'%Symbol%': hasSymbols ? Symbol : undefined,
	'%SyntaxError%': $SyntaxError,
	'%ThrowTypeError%': ThrowTypeError,
	'%TypedArray%': TypedArray,
	'%TypeError%': $TypeError,
	'%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined : Uint8Array,
	'%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined : Uint8ClampedArray,
	'%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined : Uint16Array,
	'%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined : Uint32Array,
	'%URIError%': $URIError,
	'%WeakMap%': typeof WeakMap === 'undefined' ? undefined : WeakMap,
	'%WeakRef%': typeof WeakRef === 'undefined' ? undefined : WeakRef,
	'%WeakSet%': typeof WeakSet === 'undefined' ? undefined : WeakSet
};

if (getProto) {
	try {
		null.error; // eslint-disable-line no-unused-expressions
	} catch (e) {
		// https://github.com/tc39/proposal-shadowrealm/pull/384#issuecomment-1364264229
		var errorProto = getProto(getProto(e));
		INTRINSICS['%Error.prototype%'] = errorProto;
	}
}

var doEval = function doEval(name) {
	var value;
	if (name === '%AsyncFunction%') {
		value = getEvalledConstructor('async function () {}');
	} else if (name === '%GeneratorFunction%') {
		value = getEvalledConstructor('function* () {}');
	} else if (name === '%AsyncGeneratorFunction%') {
		value = getEvalledConstructor('async function* () {}');
	} else if (name === '%AsyncGenerator%') {
		var fn = doEval('%AsyncGeneratorFunction%');
		if (fn) {
			value = fn.prototype;
		}
	} else if (name === '%AsyncIteratorPrototype%') {
		var gen = doEval('%AsyncGenerator%');
		if (gen && getProto) {
			value = getProto(gen.prototype);
		}
	}

	INTRINSICS[name] = value;

	return value;
};

var LEGACY_ALIASES = {
	__proto__: null,
	'%ArrayBufferPrototype%': ['ArrayBuffer', 'prototype'],
	'%ArrayPrototype%': ['Array', 'prototype'],
	'%ArrayProto_entries%': ['Array', 'prototype', 'entries'],
	'%ArrayProto_forEach%': ['Array', 'prototype', 'forEach'],
	'%ArrayProto_keys%': ['Array', 'prototype', 'keys'],
	'%ArrayProto_values%': ['Array', 'prototype', 'values'],
	'%AsyncFunctionPrototype%': ['AsyncFunction', 'prototype'],
	'%AsyncGenerator%': ['AsyncGeneratorFunction', 'prototype'],
	'%AsyncGeneratorPrototype%': ['AsyncGeneratorFunction', 'prototype', 'prototype'],
	'%BooleanPrototype%': ['Boolean', 'prototype'],
	'%DataViewPrototype%': ['DataView', 'prototype'],
	'%DatePrototype%': ['Date', 'prototype'],
	'%ErrorPrototype%': ['Error', 'prototype'],
	'%EvalErrorPrototype%': ['EvalError', 'prototype'],
	'%Float32ArrayPrototype%': ['Float32Array', 'prototype'],
	'%Float64ArrayPrototype%': ['Float64Array', 'prototype'],
	'%FunctionPrototype%': ['Function', 'prototype'],
	'%Generator%': ['GeneratorFunction', 'prototype'],
	'%GeneratorPrototype%': ['GeneratorFunction', 'prototype', 'prototype'],
	'%Int8ArrayPrototype%': ['Int8Array', 'prototype'],
	'%Int16ArrayPrototype%': ['Int16Array', 'prototype'],
	'%Int32ArrayPrototype%': ['Int32Array', 'prototype'],
	'%JSONParse%': ['JSON', 'parse'],
	'%JSONStringify%': ['JSON', 'stringify'],
	'%MapPrototype%': ['Map', 'prototype'],
	'%NumberPrototype%': ['Number', 'prototype'],
	'%ObjectPrototype%': ['Object', 'prototype'],
	'%ObjProto_toString%': ['Object', 'prototype', 'toString'],
	'%ObjProto_valueOf%': ['Object', 'prototype', 'valueOf'],
	'%PromisePrototype%': ['Promise', 'prototype'],
	'%PromiseProto_then%': ['Promise', 'prototype', 'then'],
	'%Promise_all%': ['Promise', 'all'],
	'%Promise_reject%': ['Promise', 'reject'],
	'%Promise_resolve%': ['Promise', 'resolve'],
	'%RangeErrorPrototype%': ['RangeError', 'prototype'],
	'%ReferenceErrorPrototype%': ['ReferenceError', 'prototype'],
	'%RegExpPrototype%': ['RegExp', 'prototype'],
	'%SetPrototype%': ['Set', 'prototype'],
	'%SharedArrayBufferPrototype%': ['SharedArrayBuffer', 'prototype'],
	'%StringPrototype%': ['String', 'prototype'],
	'%SymbolPrototype%': ['Symbol', 'prototype'],
	'%SyntaxErrorPrototype%': ['SyntaxError', 'prototype'],
	'%TypedArrayPrototype%': ['TypedArray', 'prototype'],
	'%TypeErrorPrototype%': ['TypeError', 'prototype'],
	'%Uint8ArrayPrototype%': ['Uint8Array', 'prototype'],
	'%Uint8ClampedArrayPrototype%': ['Uint8ClampedArray', 'prototype'],
	'%Uint16ArrayPrototype%': ['Uint16Array', 'prototype'],
	'%Uint32ArrayPrototype%': ['Uint32Array', 'prototype'],
	'%URIErrorPrototype%': ['URIError', 'prototype'],
	'%WeakMapPrototype%': ['WeakMap', 'prototype'],
	'%WeakSetPrototype%': ['WeakSet', 'prototype']
};

var bind = __webpack_require__(7715);
var hasOwn = __webpack_require__(9429);
var $concat = bind.call(Function.call, Array.prototype.concat);
var $spliceApply = bind.call(Function.apply, Array.prototype.splice);
var $replace = bind.call(Function.call, String.prototype.replace);
var $strSlice = bind.call(Function.call, String.prototype.slice);
var $exec = bind.call(Function.call, RegExp.prototype.exec);

/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */
var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
var reEscapeChar = /\\(\\)?/g; /** Used to match backslashes in property paths. */
var stringToPath = function stringToPath(string) {
	var first = $strSlice(string, 0, 1);
	var last = $strSlice(string, -1);
	if (first === '%' && last !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected closing `%`');
	} else if (last === '%' && first !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected opening `%`');
	}
	var result = [];
	$replace(string, rePropName, function (match, number, quote, subString) {
		result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
	});
	return result;
};
/* end adaptation */

var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
	var intrinsicName = name;
	var alias;
	if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
		alias = LEGACY_ALIASES[intrinsicName];
		intrinsicName = '%' + alias[0] + '%';
	}

	if (hasOwn(INTRINSICS, intrinsicName)) {
		var value = INTRINSICS[intrinsicName];
		if (value === needsEval) {
			value = doEval(intrinsicName);
		}
		if (typeof value === 'undefined' && !allowMissing) {
			throw new $TypeError('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
		}

		return {
			alias: alias,
			name: intrinsicName,
			value: value
		};
	}

	throw new $SyntaxError('intrinsic ' + name + ' does not exist!');
};

module.exports = function GetIntrinsic(name, allowMissing) {
	if (typeof name !== 'string' || name.length === 0) {
		throw new $TypeError('intrinsic name must be a non-empty string');
	}
	if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
		throw new $TypeError('"allowMissing" argument must be a boolean');
	}

	if ($exec(/^%?[^%]*%?$/, name) === null) {
		throw new $SyntaxError('`%` may not be present anywhere but at the beginning and end of the intrinsic name');
	}
	var parts = stringToPath(name);
	var intrinsicBaseName = parts.length > 0 ? parts[0] : '';

	var intrinsic = getBaseIntrinsic('%' + intrinsicBaseName + '%', allowMissing);
	var intrinsicRealName = intrinsic.name;
	var value = intrinsic.value;
	var skipFurtherCaching = false;

	var alias = intrinsic.alias;
	if (alias) {
		intrinsicBaseName = alias[0];
		$spliceApply(parts, $concat([0, 1], alias));
	}

	for (var i = 1, isOwn = true; i < parts.length; i += 1) {
		var part = parts[i];
		var first = $strSlice(part, 0, 1);
		var last = $strSlice(part, -1);
		if (
			(
				(first === '"' || first === "'" || first === '`')
				|| (last === '"' || last === "'" || last === '`')
			)
			&& first !== last
		) {
			throw new $SyntaxError('property names with quotes must have matching quotes');
		}
		if (part === 'constructor' || !isOwn) {
			skipFurtherCaching = true;
		}

		intrinsicBaseName += '.' + part;
		intrinsicRealName = '%' + intrinsicBaseName + '%';

		if (hasOwn(INTRINSICS, intrinsicRealName)) {
			value = INTRINSICS[intrinsicRealName];
		} else if (value != null) {
			if (!(part in value)) {
				if (!allowMissing) {
					throw new $TypeError('base intrinsic for ' + name + ' exists, but the property is not available.');
				}
				return void undefined;
			}
			if ($gOPD && (i + 1) >= parts.length) {
				var desc = $gOPD(value, part);
				isOwn = !!desc;

				// By convention, when a data property is converted to an accessor
				// property to emulate a data property that does not suffer from
				// the override mistake, that accessor's getter is marked with
				// an `originalValue` property. Here, when we detect this, we
				// uphold the illusion by pretending to see that original data
				// property, i.e., returning the value rather than the getter
				// itself.
				if (isOwn && 'get' in desc && !('originalValue' in desc.get)) {
					value = desc.get;
				} else {
					value = value[part];
				}
			} else {
				isOwn = hasOwn(value, part);
				value = value[part];
			}

			if (isOwn && !skipFurtherCaching) {
				INTRINSICS[intrinsicRealName] = value;
			}
		}
	}
	return value;
};


/***/ }),

/***/ 263:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var origSymbol = typeof Symbol !== 'undefined' && Symbol;
var hasSymbolSham = __webpack_require__(9184);

module.exports = function hasNativeSymbols() {
	if (typeof origSymbol !== 'function') { return false; }
	if (typeof Symbol !== 'function') { return false; }
	if (typeof origSymbol('foo') !== 'symbol') { return false; }
	if (typeof Symbol('bar') !== 'symbol') { return false; }

	return hasSymbolSham();
};


/***/ }),

/***/ 9184:
/***/ (function(module) {

"use strict";


/* eslint complexity: [2, 18], max-statements: [2, 33] */
module.exports = function hasSymbols() {
	if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
	if (typeof Symbol.iterator === 'symbol') { return true; }

	var obj = {};
	var sym = Symbol('test');
	var symObj = Object(sym);
	if (typeof sym === 'string') { return false; }

	if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
	if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

	// temp disabled per https://github.com/ljharb/object.assign/issues/17
	// if (sym instanceof Symbol) { return false; }
	// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
	// if (!(symObj instanceof Symbol)) { return false; }

	// if (typeof Symbol.prototype.toString !== 'function') { return false; }
	// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

	var symVal = 42;
	obj[sym] = symVal;
	for (sym in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
	if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

	if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

	var syms = Object.getOwnPropertySymbols(obj);
	if (syms.length !== 1 || syms[0] !== sym) { return false; }

	if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

	if (typeof Object.getOwnPropertyDescriptor === 'function') {
		var descriptor = Object.getOwnPropertyDescriptor(obj, sym);
		if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
	}

	return true;
};


/***/ }),

/***/ 7046:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var forEach = __webpack_require__(4843);
var callBind = __webpack_require__(2526);

var typedArrays = __webpack_require__(4343)();

/** @typedef {Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array | Float64Array | BigInt64Array | BigUint64Array} TypedArray */
/** @typedef {(x: TypedArray) => number} ByteOffsetGetter */

/** @type {Object.<typeof typedArrays, ByteOffsetGetter>} */
var getters = {};
var hasProto = __webpack_require__(1856)();

var gOPD = __webpack_require__(3828);
var oDP = Object.defineProperty;
if (gOPD) {
	/** @type {ByteOffsetGetter} */
	var getByteOffset = function (x) {
		return x.byteOffset;
	};
	forEach(typedArrays, function (typedArray) {
		// In Safari 7, Typed Array constructors are typeof object
		if (typeof __webpack_require__.g[typedArray] === 'function' || typeof __webpack_require__.g[typedArray] === 'object') {
			var Proto = __webpack_require__.g[typedArray].prototype;
			// @ts-expect-error TS can't guarantee the callback is invoked sync
			var descriptor = gOPD(Proto, 'byteOffset');
			if (!descriptor && hasProto) {
				// @ts-expect-error hush, TS, every object has a dunder proto
				var superProto = Proto.__proto__; // eslint-disable-line no-proto
				// @ts-expect-error TS can't guarantee the callback is invoked sync
				descriptor = gOPD(superProto, 'byteOffset');
			}
			// Opera 12.16 has a magic byteOffset data property on instances AND on Proto
			if (descriptor && descriptor.get) {
				getters[typedArray] = callBind(descriptor.get);
			} else if (oDP) {
				// this is likely an engine where instances have a magic byteOffset data property
				var arr = new __webpack_require__.g[typedArray](2);
				// @ts-expect-error TS can't guarantee the callback is invoked sync
				descriptor = gOPD(arr, 'byteOffset');
				if (descriptor && descriptor.configurable) {
					oDP(arr, 'length', { value: 3 });
				}
				if (arr.length === 2) {
					getters[typedArray] = getByteOffset;
				}
			}
		}
	});
}

/** @type {ByteOffsetGetter} */
var tryTypedArrays = function tryAllTypedArrays(value) {
	/** @type {number} */ var foundOffset;
	forEach(getters, /** @type {(getter: ByteOffsetGetter) => void} */ function (getter) {
		if (typeof foundOffset !== 'number') {
			try {
				var offset = getter(value);
				if (typeof offset === 'number') {
					foundOffset = offset;
				}
			} catch (e) {}
		}
	});
	// @ts-expect-error TS can't guarantee the callback is invoked sync
	return foundOffset;
};

var isTypedArray = __webpack_require__(2527);

/** @type {import('.')} */
module.exports = function typedArrayByteOffset(value) {
	if (!isTypedArray(value)) {
		return false;
	}
	return tryTypedArrays(value);
};


/***/ }),

/***/ 2526:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var bind = __webpack_require__(1530);
var GetIntrinsic = __webpack_require__(3699);
var setFunctionLength = __webpack_require__(4521);

var $TypeError = __webpack_require__(1642);
var $apply = GetIntrinsic('%Function.prototype.apply%');
var $call = GetIntrinsic('%Function.prototype.call%');
var $reflectApply = GetIntrinsic('%Reflect.apply%', true) || bind.call($call, $apply);

var $defineProperty = __webpack_require__(8918);
var $max = GetIntrinsic('%Math.max%');

module.exports = function callBind(originalFunction) {
	if (typeof originalFunction !== 'function') {
		throw new $TypeError('a function is required');
	}
	var func = $reflectApply(bind, $call, arguments);
	return setFunctionLength(
		func,
		1 + $max(0, originalFunction.length - (arguments.length - 1)),
		true
	);
};

var applyBind = function applyBind() {
	return $reflectApply(bind, $apply, arguments);
};

if ($defineProperty) {
	$defineProperty(module.exports, 'apply', { value: applyBind });
} else {
	module.exports.apply = applyBind;
}


/***/ }),

/***/ 1609:
/***/ (function(module) {

"use strict";


/* eslint no-invalid-this: 1 */

var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
var toStr = Object.prototype.toString;
var max = Math.max;
var funcType = '[object Function]';

var concatty = function concatty(a, b) {
    var arr = [];

    for (var i = 0; i < a.length; i += 1) {
        arr[i] = a[i];
    }
    for (var j = 0; j < b.length; j += 1) {
        arr[j + a.length] = b[j];
    }

    return arr;
};

var slicy = function slicy(arrLike, offset) {
    var arr = [];
    for (var i = offset || 0, j = 0; i < arrLike.length; i += 1, j += 1) {
        arr[j] = arrLike[i];
    }
    return arr;
};

var joiny = function (arr, joiner) {
    var str = '';
    for (var i = 0; i < arr.length; i += 1) {
        str += arr[i];
        if (i + 1 < arr.length) {
            str += joiner;
        }
    }
    return str;
};

module.exports = function bind(that) {
    var target = this;
    if (typeof target !== 'function' || toStr.apply(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
    }
    var args = slicy(arguments, 1);

    var bound;
    var binder = function () {
        if (this instanceof bound) {
            var result = target.apply(
                this,
                concatty(args, arguments)
            );
            if (Object(result) === result) {
                return result;
            }
            return this;
        }
        return target.apply(
            that,
            concatty(args, arguments)
        );

    };

    var boundLength = max(0, target.length - args.length);
    var boundArgs = [];
    for (var i = 0; i < boundLength; i++) {
        boundArgs[i] = '$' + i;
    }

    bound = Function('binder', 'return function (' + joiny(boundArgs, ',') + '){ return binder.apply(this,arguments); }')(binder);

    if (target.prototype) {
        var Empty = function Empty() {};
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
    }

    return bound;
};


/***/ }),

/***/ 1530:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var implementation = __webpack_require__(1609);

module.exports = Function.prototype.bind || implementation;


/***/ }),

/***/ 3699:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var undefined;

var $Error = __webpack_require__(6716);
var $EvalError = __webpack_require__(6788);
var $RangeError = __webpack_require__(9204);
var $ReferenceError = __webpack_require__(9908);
var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);
var $URIError = __webpack_require__(1451);

var $Function = Function;

// eslint-disable-next-line consistent-return
var getEvalledConstructor = function (expressionSyntax) {
	try {
		return $Function('"use strict"; return (' + expressionSyntax + ').constructor;')();
	} catch (e) {}
};

var $gOPD = Object.getOwnPropertyDescriptor;
if ($gOPD) {
	try {
		$gOPD({}, '');
	} catch (e) {
		$gOPD = null; // this is IE 8, which has a broken gOPD
	}
}

var throwTypeError = function () {
	throw new $TypeError();
};
var ThrowTypeError = $gOPD
	? (function () {
		try {
			// eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
			arguments.callee; // IE 8 does not throw here
			return throwTypeError;
		} catch (calleeThrows) {
			try {
				// IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
				return $gOPD(arguments, 'callee').get;
			} catch (gOPDthrows) {
				return throwTypeError;
			}
		}
	}())
	: throwTypeError;

var hasSymbols = __webpack_require__(5162)();
var hasProto = __webpack_require__(1856)();

var getProto = Object.getPrototypeOf || (
	hasProto
		? function (x) { return x.__proto__; } // eslint-disable-line no-proto
		: null
);

var needsEval = {};

var TypedArray = typeof Uint8Array === 'undefined' || !getProto ? undefined : getProto(Uint8Array);

var INTRINSICS = {
	__proto__: null,
	'%AggregateError%': typeof AggregateError === 'undefined' ? undefined : AggregateError,
	'%Array%': Array,
	'%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined : ArrayBuffer,
	'%ArrayIteratorPrototype%': hasSymbols && getProto ? getProto([][Symbol.iterator]()) : undefined,
	'%AsyncFromSyncIteratorPrototype%': undefined,
	'%AsyncFunction%': needsEval,
	'%AsyncGenerator%': needsEval,
	'%AsyncGeneratorFunction%': needsEval,
	'%AsyncIteratorPrototype%': needsEval,
	'%Atomics%': typeof Atomics === 'undefined' ? undefined : Atomics,
	'%BigInt%': typeof BigInt === 'undefined' ? undefined : BigInt,
	'%BigInt64Array%': typeof BigInt64Array === 'undefined' ? undefined : BigInt64Array,
	'%BigUint64Array%': typeof BigUint64Array === 'undefined' ? undefined : BigUint64Array,
	'%Boolean%': Boolean,
	'%DataView%': typeof DataView === 'undefined' ? undefined : DataView,
	'%Date%': Date,
	'%decodeURI%': decodeURI,
	'%decodeURIComponent%': decodeURIComponent,
	'%encodeURI%': encodeURI,
	'%encodeURIComponent%': encodeURIComponent,
	'%Error%': $Error,
	'%eval%': eval, // eslint-disable-line no-eval
	'%EvalError%': $EvalError,
	'%Float32Array%': typeof Float32Array === 'undefined' ? undefined : Float32Array,
	'%Float64Array%': typeof Float64Array === 'undefined' ? undefined : Float64Array,
	'%FinalizationRegistry%': typeof FinalizationRegistry === 'undefined' ? undefined : FinalizationRegistry,
	'%Function%': $Function,
	'%GeneratorFunction%': needsEval,
	'%Int8Array%': typeof Int8Array === 'undefined' ? undefined : Int8Array,
	'%Int16Array%': typeof Int16Array === 'undefined' ? undefined : Int16Array,
	'%Int32Array%': typeof Int32Array === 'undefined' ? undefined : Int32Array,
	'%isFinite%': isFinite,
	'%isNaN%': isNaN,
	'%IteratorPrototype%': hasSymbols && getProto ? getProto(getProto([][Symbol.iterator]())) : undefined,
	'%JSON%': typeof JSON === 'object' ? JSON : undefined,
	'%Map%': typeof Map === 'undefined' ? undefined : Map,
	'%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Map()[Symbol.iterator]()),
	'%Math%': Math,
	'%Number%': Number,
	'%Object%': Object,
	'%parseFloat%': parseFloat,
	'%parseInt%': parseInt,
	'%Promise%': typeof Promise === 'undefined' ? undefined : Promise,
	'%Proxy%': typeof Proxy === 'undefined' ? undefined : Proxy,
	'%RangeError%': $RangeError,
	'%ReferenceError%': $ReferenceError,
	'%Reflect%': typeof Reflect === 'undefined' ? undefined : Reflect,
	'%RegExp%': RegExp,
	'%Set%': typeof Set === 'undefined' ? undefined : Set,
	'%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Set()[Symbol.iterator]()),
	'%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined : SharedArrayBuffer,
	'%String%': String,
	'%StringIteratorPrototype%': hasSymbols && getProto ? getProto(''[Symbol.iterator]()) : undefined,
	'%Symbol%': hasSymbols ? Symbol : undefined,
	'%SyntaxError%': $SyntaxError,
	'%ThrowTypeError%': ThrowTypeError,
	'%TypedArray%': TypedArray,
	'%TypeError%': $TypeError,
	'%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined : Uint8Array,
	'%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined : Uint8ClampedArray,
	'%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined : Uint16Array,
	'%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined : Uint32Array,
	'%URIError%': $URIError,
	'%WeakMap%': typeof WeakMap === 'undefined' ? undefined : WeakMap,
	'%WeakRef%': typeof WeakRef === 'undefined' ? undefined : WeakRef,
	'%WeakSet%': typeof WeakSet === 'undefined' ? undefined : WeakSet
};

if (getProto) {
	try {
		null.error; // eslint-disable-line no-unused-expressions
	} catch (e) {
		// https://github.com/tc39/proposal-shadowrealm/pull/384#issuecomment-1364264229
		var errorProto = getProto(getProto(e));
		INTRINSICS['%Error.prototype%'] = errorProto;
	}
}

var doEval = function doEval(name) {
	var value;
	if (name === '%AsyncFunction%') {
		value = getEvalledConstructor('async function () {}');
	} else if (name === '%GeneratorFunction%') {
		value = getEvalledConstructor('function* () {}');
	} else if (name === '%AsyncGeneratorFunction%') {
		value = getEvalledConstructor('async function* () {}');
	} else if (name === '%AsyncGenerator%') {
		var fn = doEval('%AsyncGeneratorFunction%');
		if (fn) {
			value = fn.prototype;
		}
	} else if (name === '%AsyncIteratorPrototype%') {
		var gen = doEval('%AsyncGenerator%');
		if (gen && getProto) {
			value = getProto(gen.prototype);
		}
	}

	INTRINSICS[name] = value;

	return value;
};

var LEGACY_ALIASES = {
	__proto__: null,
	'%ArrayBufferPrototype%': ['ArrayBuffer', 'prototype'],
	'%ArrayPrototype%': ['Array', 'prototype'],
	'%ArrayProto_entries%': ['Array', 'prototype', 'entries'],
	'%ArrayProto_forEach%': ['Array', 'prototype', 'forEach'],
	'%ArrayProto_keys%': ['Array', 'prototype', 'keys'],
	'%ArrayProto_values%': ['Array', 'prototype', 'values'],
	'%AsyncFunctionPrototype%': ['AsyncFunction', 'prototype'],
	'%AsyncGenerator%': ['AsyncGeneratorFunction', 'prototype'],
	'%AsyncGeneratorPrototype%': ['AsyncGeneratorFunction', 'prototype', 'prototype'],
	'%BooleanPrototype%': ['Boolean', 'prototype'],
	'%DataViewPrototype%': ['DataView', 'prototype'],
	'%DatePrototype%': ['Date', 'prototype'],
	'%ErrorPrototype%': ['Error', 'prototype'],
	'%EvalErrorPrototype%': ['EvalError', 'prototype'],
	'%Float32ArrayPrototype%': ['Float32Array', 'prototype'],
	'%Float64ArrayPrototype%': ['Float64Array', 'prototype'],
	'%FunctionPrototype%': ['Function', 'prototype'],
	'%Generator%': ['GeneratorFunction', 'prototype'],
	'%GeneratorPrototype%': ['GeneratorFunction', 'prototype', 'prototype'],
	'%Int8ArrayPrototype%': ['Int8Array', 'prototype'],
	'%Int16ArrayPrototype%': ['Int16Array', 'prototype'],
	'%Int32ArrayPrototype%': ['Int32Array', 'prototype'],
	'%JSONParse%': ['JSON', 'parse'],
	'%JSONStringify%': ['JSON', 'stringify'],
	'%MapPrototype%': ['Map', 'prototype'],
	'%NumberPrototype%': ['Number', 'prototype'],
	'%ObjectPrototype%': ['Object', 'prototype'],
	'%ObjProto_toString%': ['Object', 'prototype', 'toString'],
	'%ObjProto_valueOf%': ['Object', 'prototype', 'valueOf'],
	'%PromisePrototype%': ['Promise', 'prototype'],
	'%PromiseProto_then%': ['Promise', 'prototype', 'then'],
	'%Promise_all%': ['Promise', 'all'],
	'%Promise_reject%': ['Promise', 'reject'],
	'%Promise_resolve%': ['Promise', 'resolve'],
	'%RangeErrorPrototype%': ['RangeError', 'prototype'],
	'%ReferenceErrorPrototype%': ['ReferenceError', 'prototype'],
	'%RegExpPrototype%': ['RegExp', 'prototype'],
	'%SetPrototype%': ['Set', 'prototype'],
	'%SharedArrayBufferPrototype%': ['SharedArrayBuffer', 'prototype'],
	'%StringPrototype%': ['String', 'prototype'],
	'%SymbolPrototype%': ['Symbol', 'prototype'],
	'%SyntaxErrorPrototype%': ['SyntaxError', 'prototype'],
	'%TypedArrayPrototype%': ['TypedArray', 'prototype'],
	'%TypeErrorPrototype%': ['TypeError', 'prototype'],
	'%Uint8ArrayPrototype%': ['Uint8Array', 'prototype'],
	'%Uint8ClampedArrayPrototype%': ['Uint8ClampedArray', 'prototype'],
	'%Uint16ArrayPrototype%': ['Uint16Array', 'prototype'],
	'%Uint32ArrayPrototype%': ['Uint32Array', 'prototype'],
	'%URIErrorPrototype%': ['URIError', 'prototype'],
	'%WeakMapPrototype%': ['WeakMap', 'prototype'],
	'%WeakSetPrototype%': ['WeakSet', 'prototype']
};

var bind = __webpack_require__(1530);
var hasOwn = __webpack_require__(9429);
var $concat = bind.call(Function.call, Array.prototype.concat);
var $spliceApply = bind.call(Function.apply, Array.prototype.splice);
var $replace = bind.call(Function.call, String.prototype.replace);
var $strSlice = bind.call(Function.call, String.prototype.slice);
var $exec = bind.call(Function.call, RegExp.prototype.exec);

/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */
var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
var reEscapeChar = /\\(\\)?/g; /** Used to match backslashes in property paths. */
var stringToPath = function stringToPath(string) {
	var first = $strSlice(string, 0, 1);
	var last = $strSlice(string, -1);
	if (first === '%' && last !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected closing `%`');
	} else if (last === '%' && first !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected opening `%`');
	}
	var result = [];
	$replace(string, rePropName, function (match, number, quote, subString) {
		result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
	});
	return result;
};
/* end adaptation */

var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
	var intrinsicName = name;
	var alias;
	if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
		alias = LEGACY_ALIASES[intrinsicName];
		intrinsicName = '%' + alias[0] + '%';
	}

	if (hasOwn(INTRINSICS, intrinsicName)) {
		var value = INTRINSICS[intrinsicName];
		if (value === needsEval) {
			value = doEval(intrinsicName);
		}
		if (typeof value === 'undefined' && !allowMissing) {
			throw new $TypeError('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
		}

		return {
			alias: alias,
			name: intrinsicName,
			value: value
		};
	}

	throw new $SyntaxError('intrinsic ' + name + ' does not exist!');
};

module.exports = function GetIntrinsic(name, allowMissing) {
	if (typeof name !== 'string' || name.length === 0) {
		throw new $TypeError('intrinsic name must be a non-empty string');
	}
	if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
		throw new $TypeError('"allowMissing" argument must be a boolean');
	}

	if ($exec(/^%?[^%]*%?$/, name) === null) {
		throw new $SyntaxError('`%` may not be present anywhere but at the beginning and end of the intrinsic name');
	}
	var parts = stringToPath(name);
	var intrinsicBaseName = parts.length > 0 ? parts[0] : '';

	var intrinsic = getBaseIntrinsic('%' + intrinsicBaseName + '%', allowMissing);
	var intrinsicRealName = intrinsic.name;
	var value = intrinsic.value;
	var skipFurtherCaching = false;

	var alias = intrinsic.alias;
	if (alias) {
		intrinsicBaseName = alias[0];
		$spliceApply(parts, $concat([0, 1], alias));
	}

	for (var i = 1, isOwn = true; i < parts.length; i += 1) {
		var part = parts[i];
		var first = $strSlice(part, 0, 1);
		var last = $strSlice(part, -1);
		if (
			(
				(first === '"' || first === "'" || first === '`')
				|| (last === '"' || last === "'" || last === '`')
			)
			&& first !== last
		) {
			throw new $SyntaxError('property names with quotes must have matching quotes');
		}
		if (part === 'constructor' || !isOwn) {
			skipFurtherCaching = true;
		}

		intrinsicBaseName += '.' + part;
		intrinsicRealName = '%' + intrinsicBaseName + '%';

		if (hasOwn(INTRINSICS, intrinsicRealName)) {
			value = INTRINSICS[intrinsicRealName];
		} else if (value != null) {
			if (!(part in value)) {
				if (!allowMissing) {
					throw new $TypeError('base intrinsic for ' + name + ' exists, but the property is not available.');
				}
				return void undefined;
			}
			if ($gOPD && (i + 1) >= parts.length) {
				var desc = $gOPD(value, part);
				isOwn = !!desc;

				// By convention, when a data property is converted to an accessor
				// property to emulate a data property that does not suffer from
				// the override mistake, that accessor's getter is marked with
				// an `originalValue` property. Here, when we detect this, we
				// uphold the illusion by pretending to see that original data
				// property, i.e., returning the value rather than the getter
				// itself.
				if (isOwn && 'get' in desc && !('originalValue' in desc.get)) {
					value = desc.get;
				} else {
					value = value[part];
				}
			} else {
				isOwn = hasOwn(value, part);
				value = value[part];
			}

			if (isOwn && !skipFurtherCaching) {
				INTRINSICS[intrinsicRealName] = value;
			}
		}
	}
	return value;
};


/***/ }),

/***/ 5162:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var origSymbol = typeof Symbol !== 'undefined' && Symbol;
var hasSymbolSham = __webpack_require__(3903);

module.exports = function hasNativeSymbols() {
	if (typeof origSymbol !== 'function') { return false; }
	if (typeof Symbol !== 'function') { return false; }
	if (typeof origSymbol('foo') !== 'symbol') { return false; }
	if (typeof Symbol('bar') !== 'symbol') { return false; }

	return hasSymbolSham();
};


/***/ }),

/***/ 3903:
/***/ (function(module) {

"use strict";


/* eslint complexity: [2, 18], max-statements: [2, 33] */
module.exports = function hasSymbols() {
	if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
	if (typeof Symbol.iterator === 'symbol') { return true; }

	var obj = {};
	var sym = Symbol('test');
	var symObj = Object(sym);
	if (typeof sym === 'string') { return false; }

	if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
	if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

	// temp disabled per https://github.com/ljharb/object.assign/issues/17
	// if (sym instanceof Symbol) { return false; }
	// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
	// if (!(symObj instanceof Symbol)) { return false; }

	// if (typeof Symbol.prototype.toString !== 'function') { return false; }
	// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

	var symVal = 42;
	obj[sym] = symVal;
	for (sym in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
	if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

	if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

	var syms = Object.getOwnPropertySymbols(obj);
	if (syms.length !== 1 || syms[0] !== sym) { return false; }

	if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

	if (typeof Object.getOwnPropertyDescriptor === 'function') {
		var descriptor = Object.getOwnPropertyDescriptor(obj, sym);
		if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
	}

	return true;
};


/***/ }),

/***/ 8150:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


// / <reference types="node" />

var callBind = __webpack_require__(4888);
var forEach = __webpack_require__(4843);
var gOPD = __webpack_require__(3828);
var hasProto = __webpack_require__(1856)();
var isTypedArray = __webpack_require__(2527);
var typedArrays = __webpack_require__(131);

/** @typedef {(value: import('.').TypedArray) => number} TypedArrayLengthGetter */
/** @typedef {{ [k in `$${import('.').TypedArrayName}` | '__proto__']: k extends '__proto__' ? null : TypedArrayLengthGetter }} Cache */

/** @type {Cache} */
// @ts-expect-error TS doesn't seem to have a "will eventually satisfy" type
var getters = { __proto__: null };
var oDP = Object.defineProperty;
if (gOPD) {
	var getLength = /** @type {TypedArrayLengthGetter} */ function (x) {
		return x.length;
	};
	forEach(typedArrays, /** @type {(typedArray: import('.').TypedArrayName) => void} */ function (typedArray) {
		var TA = __webpack_require__.g[typedArray];
		// In Safari 7, Typed Array constructors are typeof object
		if (typeof TA === 'function' || typeof TA === 'object') {
			var Proto = TA.prototype;
			// @ts-expect-error TS doesn't narrow types inside callbacks, which is weird
			var descriptor = gOPD(Proto, 'length');
			if (!descriptor && hasProto) {
				var superProto = Proto.__proto__; // eslint-disable-line no-proto
				// @ts-expect-error TS doesn't narrow types inside callbacks, which is weird
				descriptor = gOPD(superProto, 'length');
			}
			// Opera 12.16 has a magic length data property on instances AND on Proto
			if (descriptor && descriptor.get) {
				// eslint-disable-next-line no-extra-parens
				getters[/** @type {`$${import('.').TypedArrayName}`} */ ('$' + typedArray)] = callBind(descriptor.get);
			} else if (oDP) {
				// this is likely an engine where instances have a magic length data property
				var arr = new __webpack_require__.g[typedArray](2);
				// @ts-expect-error TS doesn't narrow types inside callbacks, which is weird
				descriptor = gOPD(arr, 'length');
				if (descriptor && descriptor.configurable) {
					oDP(arr, 'length', { value: 3 });
				}
				if (arr.length === 2) {
				// eslint-disable-next-line no-extra-parens
					getters[/** @type {`$${import('.').TypedArrayName}`} */ ('$' + typedArray)] = getLength;
				}
			}
		}
	});
}

/** @type {TypedArrayLengthGetter} */
var tryTypedArrays = function tryAllTypedArrays(value) {
	/** @type {number} */ var foundLength;
	// @ts-expect-error not sure why this won't work
	forEach(getters, /** @type {(getter: TypedArrayLengthGetter) => void} */ function (getter) {
		if (typeof foundLength !== 'number') {
			try {
				var length = getter(value);
				if (typeof length === 'number') {
					foundLength = length;
				}
			} catch (e) {}
		}
	});
	// @ts-expect-error TS can't guarantee the above callback is invoked sync
	return foundLength;
};

/** @type {import('.')} */
module.exports = function typedArrayLength(value) {
	if (!isTypedArray(value)) {
		return false;
	}
	return tryTypedArrays(value);
};


/***/ }),

/***/ 4888:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var bind = __webpack_require__(3576);
var GetIntrinsic = __webpack_require__(8031);
var setFunctionLength = __webpack_require__(4521);

var $TypeError = __webpack_require__(1642);
var $apply = GetIntrinsic('%Function.prototype.apply%');
var $call = GetIntrinsic('%Function.prototype.call%');
var $reflectApply = GetIntrinsic('%Reflect.apply%', true) || bind.call($call, $apply);

var $defineProperty = __webpack_require__(8918);
var $max = GetIntrinsic('%Math.max%');

module.exports = function callBind(originalFunction) {
	if (typeof originalFunction !== 'function') {
		throw new $TypeError('a function is required');
	}
	var func = $reflectApply(bind, $call, arguments);
	return setFunctionLength(
		func,
		1 + $max(0, originalFunction.length - (arguments.length - 1)),
		true
	);
};

var applyBind = function applyBind() {
	return $reflectApply(bind, $apply, arguments);
};

if ($defineProperty) {
	$defineProperty(module.exports, 'apply', { value: applyBind });
} else {
	module.exports.apply = applyBind;
}


/***/ }),

/***/ 7380:
/***/ (function(module) {

"use strict";


/* eslint no-invalid-this: 1 */

var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
var toStr = Object.prototype.toString;
var max = Math.max;
var funcType = '[object Function]';

var concatty = function concatty(a, b) {
    var arr = [];

    for (var i = 0; i < a.length; i += 1) {
        arr[i] = a[i];
    }
    for (var j = 0; j < b.length; j += 1) {
        arr[j + a.length] = b[j];
    }

    return arr;
};

var slicy = function slicy(arrLike, offset) {
    var arr = [];
    for (var i = offset || 0, j = 0; i < arrLike.length; i += 1, j += 1) {
        arr[j] = arrLike[i];
    }
    return arr;
};

var joiny = function (arr, joiner) {
    var str = '';
    for (var i = 0; i < arr.length; i += 1) {
        str += arr[i];
        if (i + 1 < arr.length) {
            str += joiner;
        }
    }
    return str;
};

module.exports = function bind(that) {
    var target = this;
    if (typeof target !== 'function' || toStr.apply(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
    }
    var args = slicy(arguments, 1);

    var bound;
    var binder = function () {
        if (this instanceof bound) {
            var result = target.apply(
                this,
                concatty(args, arguments)
            );
            if (Object(result) === result) {
                return result;
            }
            return this;
        }
        return target.apply(
            that,
            concatty(args, arguments)
        );

    };

    var boundLength = max(0, target.length - args.length);
    var boundArgs = [];
    for (var i = 0; i < boundLength; i++) {
        boundArgs[i] = '$' + i;
    }

    bound = Function('binder', 'return function (' + joiny(boundArgs, ',') + '){ return binder.apply(this,arguments); }')(binder);

    if (target.prototype) {
        var Empty = function Empty() {};
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
    }

    return bound;
};


/***/ }),

/***/ 3576:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var implementation = __webpack_require__(7380);

module.exports = Function.prototype.bind || implementation;


/***/ }),

/***/ 8031:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var undefined;

var $Error = __webpack_require__(6716);
var $EvalError = __webpack_require__(6788);
var $RangeError = __webpack_require__(9204);
var $ReferenceError = __webpack_require__(9908);
var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);
var $URIError = __webpack_require__(1451);

var $Function = Function;

// eslint-disable-next-line consistent-return
var getEvalledConstructor = function (expressionSyntax) {
	try {
		return $Function('"use strict"; return (' + expressionSyntax + ').constructor;')();
	} catch (e) {}
};

var $gOPD = Object.getOwnPropertyDescriptor;
if ($gOPD) {
	try {
		$gOPD({}, '');
	} catch (e) {
		$gOPD = null; // this is IE 8, which has a broken gOPD
	}
}

var throwTypeError = function () {
	throw new $TypeError();
};
var ThrowTypeError = $gOPD
	? (function () {
		try {
			// eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
			arguments.callee; // IE 8 does not throw here
			return throwTypeError;
		} catch (calleeThrows) {
			try {
				// IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
				return $gOPD(arguments, 'callee').get;
			} catch (gOPDthrows) {
				return throwTypeError;
			}
		}
	}())
	: throwTypeError;

var hasSymbols = __webpack_require__(307)();
var hasProto = __webpack_require__(1856)();

var getProto = Object.getPrototypeOf || (
	hasProto
		? function (x) { return x.__proto__; } // eslint-disable-line no-proto
		: null
);

var needsEval = {};

var TypedArray = typeof Uint8Array === 'undefined' || !getProto ? undefined : getProto(Uint8Array);

var INTRINSICS = {
	__proto__: null,
	'%AggregateError%': typeof AggregateError === 'undefined' ? undefined : AggregateError,
	'%Array%': Array,
	'%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined : ArrayBuffer,
	'%ArrayIteratorPrototype%': hasSymbols && getProto ? getProto([][Symbol.iterator]()) : undefined,
	'%AsyncFromSyncIteratorPrototype%': undefined,
	'%AsyncFunction%': needsEval,
	'%AsyncGenerator%': needsEval,
	'%AsyncGeneratorFunction%': needsEval,
	'%AsyncIteratorPrototype%': needsEval,
	'%Atomics%': typeof Atomics === 'undefined' ? undefined : Atomics,
	'%BigInt%': typeof BigInt === 'undefined' ? undefined : BigInt,
	'%BigInt64Array%': typeof BigInt64Array === 'undefined' ? undefined : BigInt64Array,
	'%BigUint64Array%': typeof BigUint64Array === 'undefined' ? undefined : BigUint64Array,
	'%Boolean%': Boolean,
	'%DataView%': typeof DataView === 'undefined' ? undefined : DataView,
	'%Date%': Date,
	'%decodeURI%': decodeURI,
	'%decodeURIComponent%': decodeURIComponent,
	'%encodeURI%': encodeURI,
	'%encodeURIComponent%': encodeURIComponent,
	'%Error%': $Error,
	'%eval%': eval, // eslint-disable-line no-eval
	'%EvalError%': $EvalError,
	'%Float32Array%': typeof Float32Array === 'undefined' ? undefined : Float32Array,
	'%Float64Array%': typeof Float64Array === 'undefined' ? undefined : Float64Array,
	'%FinalizationRegistry%': typeof FinalizationRegistry === 'undefined' ? undefined : FinalizationRegistry,
	'%Function%': $Function,
	'%GeneratorFunction%': needsEval,
	'%Int8Array%': typeof Int8Array === 'undefined' ? undefined : Int8Array,
	'%Int16Array%': typeof Int16Array === 'undefined' ? undefined : Int16Array,
	'%Int32Array%': typeof Int32Array === 'undefined' ? undefined : Int32Array,
	'%isFinite%': isFinite,
	'%isNaN%': isNaN,
	'%IteratorPrototype%': hasSymbols && getProto ? getProto(getProto([][Symbol.iterator]())) : undefined,
	'%JSON%': typeof JSON === 'object' ? JSON : undefined,
	'%Map%': typeof Map === 'undefined' ? undefined : Map,
	'%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Map()[Symbol.iterator]()),
	'%Math%': Math,
	'%Number%': Number,
	'%Object%': Object,
	'%parseFloat%': parseFloat,
	'%parseInt%': parseInt,
	'%Promise%': typeof Promise === 'undefined' ? undefined : Promise,
	'%Proxy%': typeof Proxy === 'undefined' ? undefined : Proxy,
	'%RangeError%': $RangeError,
	'%ReferenceError%': $ReferenceError,
	'%Reflect%': typeof Reflect === 'undefined' ? undefined : Reflect,
	'%RegExp%': RegExp,
	'%Set%': typeof Set === 'undefined' ? undefined : Set,
	'%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Set()[Symbol.iterator]()),
	'%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined : SharedArrayBuffer,
	'%String%': String,
	'%StringIteratorPrototype%': hasSymbols && getProto ? getProto(''[Symbol.iterator]()) : undefined,
	'%Symbol%': hasSymbols ? Symbol : undefined,
	'%SyntaxError%': $SyntaxError,
	'%ThrowTypeError%': ThrowTypeError,
	'%TypedArray%': TypedArray,
	'%TypeError%': $TypeError,
	'%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined : Uint8Array,
	'%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined : Uint8ClampedArray,
	'%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined : Uint16Array,
	'%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined : Uint32Array,
	'%URIError%': $URIError,
	'%WeakMap%': typeof WeakMap === 'undefined' ? undefined : WeakMap,
	'%WeakRef%': typeof WeakRef === 'undefined' ? undefined : WeakRef,
	'%WeakSet%': typeof WeakSet === 'undefined' ? undefined : WeakSet
};

if (getProto) {
	try {
		null.error; // eslint-disable-line no-unused-expressions
	} catch (e) {
		// https://github.com/tc39/proposal-shadowrealm/pull/384#issuecomment-1364264229
		var errorProto = getProto(getProto(e));
		INTRINSICS['%Error.prototype%'] = errorProto;
	}
}

var doEval = function doEval(name) {
	var value;
	if (name === '%AsyncFunction%') {
		value = getEvalledConstructor('async function () {}');
	} else if (name === '%GeneratorFunction%') {
		value = getEvalledConstructor('function* () {}');
	} else if (name === '%AsyncGeneratorFunction%') {
		value = getEvalledConstructor('async function* () {}');
	} else if (name === '%AsyncGenerator%') {
		var fn = doEval('%AsyncGeneratorFunction%');
		if (fn) {
			value = fn.prototype;
		}
	} else if (name === '%AsyncIteratorPrototype%') {
		var gen = doEval('%AsyncGenerator%');
		if (gen && getProto) {
			value = getProto(gen.prototype);
		}
	}

	INTRINSICS[name] = value;

	return value;
};

var LEGACY_ALIASES = {
	__proto__: null,
	'%ArrayBufferPrototype%': ['ArrayBuffer', 'prototype'],
	'%ArrayPrototype%': ['Array', 'prototype'],
	'%ArrayProto_entries%': ['Array', 'prototype', 'entries'],
	'%ArrayProto_forEach%': ['Array', 'prototype', 'forEach'],
	'%ArrayProto_keys%': ['Array', 'prototype', 'keys'],
	'%ArrayProto_values%': ['Array', 'prototype', 'values'],
	'%AsyncFunctionPrototype%': ['AsyncFunction', 'prototype'],
	'%AsyncGenerator%': ['AsyncGeneratorFunction', 'prototype'],
	'%AsyncGeneratorPrototype%': ['AsyncGeneratorFunction', 'prototype', 'prototype'],
	'%BooleanPrototype%': ['Boolean', 'prototype'],
	'%DataViewPrototype%': ['DataView', 'prototype'],
	'%DatePrototype%': ['Date', 'prototype'],
	'%ErrorPrototype%': ['Error', 'prototype'],
	'%EvalErrorPrototype%': ['EvalError', 'prototype'],
	'%Float32ArrayPrototype%': ['Float32Array', 'prototype'],
	'%Float64ArrayPrototype%': ['Float64Array', 'prototype'],
	'%FunctionPrototype%': ['Function', 'prototype'],
	'%Generator%': ['GeneratorFunction', 'prototype'],
	'%GeneratorPrototype%': ['GeneratorFunction', 'prototype', 'prototype'],
	'%Int8ArrayPrototype%': ['Int8Array', 'prototype'],
	'%Int16ArrayPrototype%': ['Int16Array', 'prototype'],
	'%Int32ArrayPrototype%': ['Int32Array', 'prototype'],
	'%JSONParse%': ['JSON', 'parse'],
	'%JSONStringify%': ['JSON', 'stringify'],
	'%MapPrototype%': ['Map', 'prototype'],
	'%NumberPrototype%': ['Number', 'prototype'],
	'%ObjectPrototype%': ['Object', 'prototype'],
	'%ObjProto_toString%': ['Object', 'prototype', 'toString'],
	'%ObjProto_valueOf%': ['Object', 'prototype', 'valueOf'],
	'%PromisePrototype%': ['Promise', 'prototype'],
	'%PromiseProto_then%': ['Promise', 'prototype', 'then'],
	'%Promise_all%': ['Promise', 'all'],
	'%Promise_reject%': ['Promise', 'reject'],
	'%Promise_resolve%': ['Promise', 'resolve'],
	'%RangeErrorPrototype%': ['RangeError', 'prototype'],
	'%ReferenceErrorPrototype%': ['ReferenceError', 'prototype'],
	'%RegExpPrototype%': ['RegExp', 'prototype'],
	'%SetPrototype%': ['Set', 'prototype'],
	'%SharedArrayBufferPrototype%': ['SharedArrayBuffer', 'prototype'],
	'%StringPrototype%': ['String', 'prototype'],
	'%SymbolPrototype%': ['Symbol', 'prototype'],
	'%SyntaxErrorPrototype%': ['SyntaxError', 'prototype'],
	'%TypedArrayPrototype%': ['TypedArray', 'prototype'],
	'%TypeErrorPrototype%': ['TypeError', 'prototype'],
	'%Uint8ArrayPrototype%': ['Uint8Array', 'prototype'],
	'%Uint8ClampedArrayPrototype%': ['Uint8ClampedArray', 'prototype'],
	'%Uint16ArrayPrototype%': ['Uint16Array', 'prototype'],
	'%Uint32ArrayPrototype%': ['Uint32Array', 'prototype'],
	'%URIErrorPrototype%': ['URIError', 'prototype'],
	'%WeakMapPrototype%': ['WeakMap', 'prototype'],
	'%WeakSetPrototype%': ['WeakSet', 'prototype']
};

var bind = __webpack_require__(3576);
var hasOwn = __webpack_require__(9429);
var $concat = bind.call(Function.call, Array.prototype.concat);
var $spliceApply = bind.call(Function.apply, Array.prototype.splice);
var $replace = bind.call(Function.call, String.prototype.replace);
var $strSlice = bind.call(Function.call, String.prototype.slice);
var $exec = bind.call(Function.call, RegExp.prototype.exec);

/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */
var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
var reEscapeChar = /\\(\\)?/g; /** Used to match backslashes in property paths. */
var stringToPath = function stringToPath(string) {
	var first = $strSlice(string, 0, 1);
	var last = $strSlice(string, -1);
	if (first === '%' && last !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected closing `%`');
	} else if (last === '%' && first !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected opening `%`');
	}
	var result = [];
	$replace(string, rePropName, function (match, number, quote, subString) {
		result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
	});
	return result;
};
/* end adaptation */

var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
	var intrinsicName = name;
	var alias;
	if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
		alias = LEGACY_ALIASES[intrinsicName];
		intrinsicName = '%' + alias[0] + '%';
	}

	if (hasOwn(INTRINSICS, intrinsicName)) {
		var value = INTRINSICS[intrinsicName];
		if (value === needsEval) {
			value = doEval(intrinsicName);
		}
		if (typeof value === 'undefined' && !allowMissing) {
			throw new $TypeError('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
		}

		return {
			alias: alias,
			name: intrinsicName,
			value: value
		};
	}

	throw new $SyntaxError('intrinsic ' + name + ' does not exist!');
};

module.exports = function GetIntrinsic(name, allowMissing) {
	if (typeof name !== 'string' || name.length === 0) {
		throw new $TypeError('intrinsic name must be a non-empty string');
	}
	if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
		throw new $TypeError('"allowMissing" argument must be a boolean');
	}

	if ($exec(/^%?[^%]*%?$/, name) === null) {
		throw new $SyntaxError('`%` may not be present anywhere but at the beginning and end of the intrinsic name');
	}
	var parts = stringToPath(name);
	var intrinsicBaseName = parts.length > 0 ? parts[0] : '';

	var intrinsic = getBaseIntrinsic('%' + intrinsicBaseName + '%', allowMissing);
	var intrinsicRealName = intrinsic.name;
	var value = intrinsic.value;
	var skipFurtherCaching = false;

	var alias = intrinsic.alias;
	if (alias) {
		intrinsicBaseName = alias[0];
		$spliceApply(parts, $concat([0, 1], alias));
	}

	for (var i = 1, isOwn = true; i < parts.length; i += 1) {
		var part = parts[i];
		var first = $strSlice(part, 0, 1);
		var last = $strSlice(part, -1);
		if (
			(
				(first === '"' || first === "'" || first === '`')
				|| (last === '"' || last === "'" || last === '`')
			)
			&& first !== last
		) {
			throw new $SyntaxError('property names with quotes must have matching quotes');
		}
		if (part === 'constructor' || !isOwn) {
			skipFurtherCaching = true;
		}

		intrinsicBaseName += '.' + part;
		intrinsicRealName = '%' + intrinsicBaseName + '%';

		if (hasOwn(INTRINSICS, intrinsicRealName)) {
			value = INTRINSICS[intrinsicRealName];
		} else if (value != null) {
			if (!(part in value)) {
				if (!allowMissing) {
					throw new $TypeError('base intrinsic for ' + name + ' exists, but the property is not available.');
				}
				return void undefined;
			}
			if ($gOPD && (i + 1) >= parts.length) {
				var desc = $gOPD(value, part);
				isOwn = !!desc;

				// By convention, when a data property is converted to an accessor
				// property to emulate a data property that does not suffer from
				// the override mistake, that accessor's getter is marked with
				// an `originalValue` property. Here, when we detect this, we
				// uphold the illusion by pretending to see that original data
				// property, i.e., returning the value rather than the getter
				// itself.
				if (isOwn && 'get' in desc && !('originalValue' in desc.get)) {
					value = desc.get;
				} else {
					value = value[part];
				}
			} else {
				isOwn = hasOwn(value, part);
				value = value[part];
			}

			if (isOwn && !skipFurtherCaching) {
				INTRINSICS[intrinsicRealName] = value;
			}
		}
	}
	return value;
};


/***/ }),

/***/ 307:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var origSymbol = typeof Symbol !== 'undefined' && Symbol;
var hasSymbolSham = __webpack_require__(1766);

module.exports = function hasNativeSymbols() {
	if (typeof origSymbol !== 'function') { return false; }
	if (typeof Symbol !== 'function') { return false; }
	if (typeof origSymbol('foo') !== 'symbol') { return false; }
	if (typeof Symbol('bar') !== 'symbol') { return false; }

	return hasSymbolSham();
};


/***/ }),

/***/ 1766:
/***/ (function(module) {

"use strict";


/* eslint complexity: [2, 18], max-statements: [2, 33] */
module.exports = function hasSymbols() {
	if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
	if (typeof Symbol.iterator === 'symbol') { return true; }

	var obj = {};
	var sym = Symbol('test');
	var symObj = Object(sym);
	if (typeof sym === 'string') { return false; }

	if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
	if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

	// temp disabled per https://github.com/ljharb/object.assign/issues/17
	// if (sym instanceof Symbol) { return false; }
	// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
	// if (!(symObj instanceof Symbol)) { return false; }

	// if (typeof Symbol.prototype.toString !== 'function') { return false; }
	// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

	var symVal = 42;
	obj[sym] = symVal;
	for (sym in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
	if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

	if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

	var syms = Object.getOwnPropertySymbols(obj);
	if (syms.length !== 1 || syms[0] !== sym) { return false; }

	if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

	if (typeof Object.getOwnPropertyDescriptor === 'function') {
		var descriptor = Object.getOwnPropertyDescriptor(obj, sym);
		if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
	}

	return true;
};


/***/ }),

/***/ 4073:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $TypeError = __webpack_require__(1642);

var Get = __webpack_require__(3675);
var GetValueFromBuffer = __webpack_require__(9661);
var IsDetachedBuffer = __webpack_require__(1320);
var max = __webpack_require__(1367);
var min = __webpack_require__(2967);
var Set = __webpack_require__(8055);
var SetValueInBuffer = __webpack_require__(3383);
var ToIntegerOrInfinity = __webpack_require__(2897);
var ToString = __webpack_require__(7249);
var TypedArrayElementSize = __webpack_require__(9149);
var TypedArrayElementType = __webpack_require__(1586);
var TypedArraySpeciesCreate = __webpack_require__(817);
var ValidateTypedArray = __webpack_require__(3842);

var typedArrayBuffer = __webpack_require__(6740);
var typedArrayByteOffset = __webpack_require__(7046);

// https://tc39.es/ecma262/#sec-%typedarray%.prototype.slice

module.exports = function slice(start, end) {
	var O = this; // step 1

	ValidateTypedArray(O, 'SEQ-CST'); // step 2

	// 3. Let len be O.[[ArrayLength]].
	var len = O.length; // steps 3

	var relativeStart = ToIntegerOrInfinity(start); // step 4

	var k;
	if (relativeStart === -Infinity) {
		k = 0; // step 5
	} else if (relativeStart < 0) {
		k = max(len + relativeStart, 0); // step 6
	} else {
		k = min(relativeStart, len); // step 7
	}

	var relativeEnd = typeof end === 'undefined' ? len : ToIntegerOrInfinity(end); // step 8

	var final;
	if (relativeEnd === -Infinity) {
		final = 0; // step 9
	} else if (relativeEnd < 0) {
		final = max(len + relativeEnd, 0); // step 10
	} else {
		final = min(relativeEnd, len); // step 11
	}

	var count = max(final - k, 0); // step 12

	var A = TypedArraySpeciesCreate(O, [count]); // step 13

	if (count > 0) { // step 14
		if (IsDetachedBuffer(typedArrayBuffer(O))) {
			throw new $TypeError('Cannot use a Typed Array with an underlying ArrayBuffer that is detached'); // step 14.a
		}
		var srcType = TypedArrayElementType(O); // step 14.b
		var targetType = TypedArrayElementType(A); // step 14.c
		if (srcType === targetType) { // step 14.d
			//  1. NOTE: The transfer must be performed in a manner that preserves the bit-level encoding of the source data.
			var srcBuffer = typedArrayBuffer(O); // step 14.d.ii
			var targetBuffer = typedArrayBuffer(A); // step 14.d.iii
			var elementSize = TypedArrayElementSize(O); // step 14.d.iv
			var srcByteOffset = typedArrayByteOffset(O); // step 14.d.v
			var srcByteIndex = (k * elementSize) + srcByteOffset; // step 14.d.vi
			var targetByteIndex = typedArrayByteOffset(A); // step 14.d.vii
			var limit = targetByteIndex + (count * elementSize); // step 14.d.viii
			while (targetByteIndex < limit) { // step 14.d.ix
				var value = GetValueFromBuffer(srcBuffer, srcByteIndex, 'UINT8', true, 'UNORDERED'); // step 14.d.ix.1
				SetValueInBuffer(targetBuffer, targetByteIndex, 'UINT8', value, true, 'UNORDERED'); // step 14.d.ix.2
				srcByteIndex += 1; // step 14.d.ix.3
				targetByteIndex += 1; // step 14.d.ix.4
			}
		} else { // step 14.e
			var n = 0; // step 14.e.i
			while (k < final) { // step 14.e.ii
				var Pk = ToString(k); // step 14.e.ii.1
				var kValue = Get(O, Pk); // step 14.e.ii.2
				Set(A, ToString(n), kValue, true); // step 14.e.ii.3
				k += 1; // step 14.e.ii.4
				n += 1; // step 14.e.ii.5
			}
		}
	}

	return A; // step 15
};


/***/ }),

/***/ 1140:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var define = __webpack_require__(6776);
var callBind = __webpack_require__(8374);

var implementation = __webpack_require__(4073);
var getPolyfill = __webpack_require__(5046);
var shim = __webpack_require__(8564);

var bound = callBind(getPolyfill());

define(bound, {
	getPolyfill: getPolyfill,
	implementation: implementation,
	shim: shim
});

module.exports = bound;


/***/ }),

/***/ 1154:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var callBind = __webpack_require__(8374);

var $indexOf = callBind(GetIntrinsic('String.prototype.indexOf'));

module.exports = function callBoundIntrinsic(name, allowMissing) {
	var intrinsic = GetIntrinsic(name, !!allowMissing);
	if (typeof intrinsic === 'function' && $indexOf(name, '.prototype.') > -1) {
		return callBind(intrinsic);
	}
	return intrinsic;
};


/***/ }),

/***/ 8374:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var bind = __webpack_require__(8474);
var GetIntrinsic = __webpack_require__(682);
var setFunctionLength = __webpack_require__(4521);

var $TypeError = __webpack_require__(1642);
var $apply = GetIntrinsic('%Function.prototype.apply%');
var $call = GetIntrinsic('%Function.prototype.call%');
var $reflectApply = GetIntrinsic('%Reflect.apply%', true) || bind.call($call, $apply);

var $defineProperty = __webpack_require__(8918);
var $max = GetIntrinsic('%Math.max%');

module.exports = function callBind(originalFunction) {
	if (typeof originalFunction !== 'function') {
		throw new $TypeError('a function is required');
	}
	var func = $reflectApply(bind, $call, arguments);
	return setFunctionLength(
		func,
		1 + $max(0, originalFunction.length - (arguments.length - 1)),
		true
	);
};

var applyBind = function applyBind() {
	return $reflectApply(bind, $apply, arguments);
};

if ($defineProperty) {
	$defineProperty(module.exports, 'apply', { value: applyBind });
} else {
	module.exports.apply = applyBind;
}


/***/ }),

/***/ 6776:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var keys = __webpack_require__(806);
var hasSymbols = typeof Symbol === 'function' && typeof Symbol('foo') === 'symbol';

var toStr = Object.prototype.toString;
var concat = Array.prototype.concat;
var defineDataProperty = __webpack_require__(2656);

var isFunction = function (fn) {
	return typeof fn === 'function' && toStr.call(fn) === '[object Function]';
};

var supportsDescriptors = __webpack_require__(8198)();

var defineProperty = function (object, name, value, predicate) {
	if (name in object) {
		if (predicate === true) {
			if (object[name] === value) {
				return;
			}
		} else if (!isFunction(predicate) || !predicate()) {
			return;
		}
	}

	if (supportsDescriptors) {
		defineDataProperty(object, name, value, true);
	} else {
		defineDataProperty(object, name, value);
	}
};

var defineProperties = function (object, map) {
	var predicates = arguments.length > 2 ? arguments[2] : {};
	var props = keys(map);
	if (hasSymbols) {
		props = concat.call(props, Object.getOwnPropertySymbols(map));
	}
	for (var i = 0; i < props.length; i += 1) {
		defineProperty(object, props[i], map[props[i]], predicates[props[i]]);
	}
};

defineProperties.supportsDescriptors = !!supportsDescriptors;

module.exports = defineProperties;


/***/ }),

/***/ 2855:
/***/ (function(module) {

"use strict";


/* eslint no-invalid-this: 1 */

var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
var toStr = Object.prototype.toString;
var max = Math.max;
var funcType = '[object Function]';

var concatty = function concatty(a, b) {
    var arr = [];

    for (var i = 0; i < a.length; i += 1) {
        arr[i] = a[i];
    }
    for (var j = 0; j < b.length; j += 1) {
        arr[j + a.length] = b[j];
    }

    return arr;
};

var slicy = function slicy(arrLike, offset) {
    var arr = [];
    for (var i = offset || 0, j = 0; i < arrLike.length; i += 1, j += 1) {
        arr[j] = arrLike[i];
    }
    return arr;
};

var joiny = function (arr, joiner) {
    var str = '';
    for (var i = 0; i < arr.length; i += 1) {
        str += arr[i];
        if (i + 1 < arr.length) {
            str += joiner;
        }
    }
    return str;
};

module.exports = function bind(that) {
    var target = this;
    if (typeof target !== 'function' || toStr.apply(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
    }
    var args = slicy(arguments, 1);

    var bound;
    var binder = function () {
        if (this instanceof bound) {
            var result = target.apply(
                this,
                concatty(args, arguments)
            );
            if (Object(result) === result) {
                return result;
            }
            return this;
        }
        return target.apply(
            that,
            concatty(args, arguments)
        );

    };

    var boundLength = max(0, target.length - args.length);
    var boundArgs = [];
    for (var i = 0; i < boundLength; i++) {
        boundArgs[i] = '$' + i;
    }

    bound = Function('binder', 'return function (' + joiny(boundArgs, ',') + '){ return binder.apply(this,arguments); }')(binder);

    if (target.prototype) {
        var Empty = function Empty() {};
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
    }

    return bound;
};


/***/ }),

/***/ 8474:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var implementation = __webpack_require__(2855);

module.exports = Function.prototype.bind || implementation;


/***/ }),

/***/ 682:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var undefined;

var $Error = __webpack_require__(6716);
var $EvalError = __webpack_require__(6788);
var $RangeError = __webpack_require__(9204);
var $ReferenceError = __webpack_require__(9908);
var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);
var $URIError = __webpack_require__(1451);

var $Function = Function;

// eslint-disable-next-line consistent-return
var getEvalledConstructor = function (expressionSyntax) {
	try {
		return $Function('"use strict"; return (' + expressionSyntax + ').constructor;')();
	} catch (e) {}
};

var $gOPD = Object.getOwnPropertyDescriptor;
if ($gOPD) {
	try {
		$gOPD({}, '');
	} catch (e) {
		$gOPD = null; // this is IE 8, which has a broken gOPD
	}
}

var throwTypeError = function () {
	throw new $TypeError();
};
var ThrowTypeError = $gOPD
	? (function () {
		try {
			// eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
			arguments.callee; // IE 8 does not throw here
			return throwTypeError;
		} catch (calleeThrows) {
			try {
				// IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
				return $gOPD(arguments, 'callee').get;
			} catch (gOPDthrows) {
				return throwTypeError;
			}
		}
	}())
	: throwTypeError;

var hasSymbols = __webpack_require__(5314)();
var hasProto = __webpack_require__(1856)();

var getProto = Object.getPrototypeOf || (
	hasProto
		? function (x) { return x.__proto__; } // eslint-disable-line no-proto
		: null
);

var needsEval = {};

var TypedArray = typeof Uint8Array === 'undefined' || !getProto ? undefined : getProto(Uint8Array);

var INTRINSICS = {
	__proto__: null,
	'%AggregateError%': typeof AggregateError === 'undefined' ? undefined : AggregateError,
	'%Array%': Array,
	'%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined : ArrayBuffer,
	'%ArrayIteratorPrototype%': hasSymbols && getProto ? getProto([][Symbol.iterator]()) : undefined,
	'%AsyncFromSyncIteratorPrototype%': undefined,
	'%AsyncFunction%': needsEval,
	'%AsyncGenerator%': needsEval,
	'%AsyncGeneratorFunction%': needsEval,
	'%AsyncIteratorPrototype%': needsEval,
	'%Atomics%': typeof Atomics === 'undefined' ? undefined : Atomics,
	'%BigInt%': typeof BigInt === 'undefined' ? undefined : BigInt,
	'%BigInt64Array%': typeof BigInt64Array === 'undefined' ? undefined : BigInt64Array,
	'%BigUint64Array%': typeof BigUint64Array === 'undefined' ? undefined : BigUint64Array,
	'%Boolean%': Boolean,
	'%DataView%': typeof DataView === 'undefined' ? undefined : DataView,
	'%Date%': Date,
	'%decodeURI%': decodeURI,
	'%decodeURIComponent%': decodeURIComponent,
	'%encodeURI%': encodeURI,
	'%encodeURIComponent%': encodeURIComponent,
	'%Error%': $Error,
	'%eval%': eval, // eslint-disable-line no-eval
	'%EvalError%': $EvalError,
	'%Float32Array%': typeof Float32Array === 'undefined' ? undefined : Float32Array,
	'%Float64Array%': typeof Float64Array === 'undefined' ? undefined : Float64Array,
	'%FinalizationRegistry%': typeof FinalizationRegistry === 'undefined' ? undefined : FinalizationRegistry,
	'%Function%': $Function,
	'%GeneratorFunction%': needsEval,
	'%Int8Array%': typeof Int8Array === 'undefined' ? undefined : Int8Array,
	'%Int16Array%': typeof Int16Array === 'undefined' ? undefined : Int16Array,
	'%Int32Array%': typeof Int32Array === 'undefined' ? undefined : Int32Array,
	'%isFinite%': isFinite,
	'%isNaN%': isNaN,
	'%IteratorPrototype%': hasSymbols && getProto ? getProto(getProto([][Symbol.iterator]())) : undefined,
	'%JSON%': typeof JSON === 'object' ? JSON : undefined,
	'%Map%': typeof Map === 'undefined' ? undefined : Map,
	'%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Map()[Symbol.iterator]()),
	'%Math%': Math,
	'%Number%': Number,
	'%Object%': Object,
	'%parseFloat%': parseFloat,
	'%parseInt%': parseInt,
	'%Promise%': typeof Promise === 'undefined' ? undefined : Promise,
	'%Proxy%': typeof Proxy === 'undefined' ? undefined : Proxy,
	'%RangeError%': $RangeError,
	'%ReferenceError%': $ReferenceError,
	'%Reflect%': typeof Reflect === 'undefined' ? undefined : Reflect,
	'%RegExp%': RegExp,
	'%Set%': typeof Set === 'undefined' ? undefined : Set,
	'%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Set()[Symbol.iterator]()),
	'%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined : SharedArrayBuffer,
	'%String%': String,
	'%StringIteratorPrototype%': hasSymbols && getProto ? getProto(''[Symbol.iterator]()) : undefined,
	'%Symbol%': hasSymbols ? Symbol : undefined,
	'%SyntaxError%': $SyntaxError,
	'%ThrowTypeError%': ThrowTypeError,
	'%TypedArray%': TypedArray,
	'%TypeError%': $TypeError,
	'%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined : Uint8Array,
	'%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined : Uint8ClampedArray,
	'%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined : Uint16Array,
	'%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined : Uint32Array,
	'%URIError%': $URIError,
	'%WeakMap%': typeof WeakMap === 'undefined' ? undefined : WeakMap,
	'%WeakRef%': typeof WeakRef === 'undefined' ? undefined : WeakRef,
	'%WeakSet%': typeof WeakSet === 'undefined' ? undefined : WeakSet
};

if (getProto) {
	try {
		null.error; // eslint-disable-line no-unused-expressions
	} catch (e) {
		// https://github.com/tc39/proposal-shadowrealm/pull/384#issuecomment-1364264229
		var errorProto = getProto(getProto(e));
		INTRINSICS['%Error.prototype%'] = errorProto;
	}
}

var doEval = function doEval(name) {
	var value;
	if (name === '%AsyncFunction%') {
		value = getEvalledConstructor('async function () {}');
	} else if (name === '%GeneratorFunction%') {
		value = getEvalledConstructor('function* () {}');
	} else if (name === '%AsyncGeneratorFunction%') {
		value = getEvalledConstructor('async function* () {}');
	} else if (name === '%AsyncGenerator%') {
		var fn = doEval('%AsyncGeneratorFunction%');
		if (fn) {
			value = fn.prototype;
		}
	} else if (name === '%AsyncIteratorPrototype%') {
		var gen = doEval('%AsyncGenerator%');
		if (gen && getProto) {
			value = getProto(gen.prototype);
		}
	}

	INTRINSICS[name] = value;

	return value;
};

var LEGACY_ALIASES = {
	__proto__: null,
	'%ArrayBufferPrototype%': ['ArrayBuffer', 'prototype'],
	'%ArrayPrototype%': ['Array', 'prototype'],
	'%ArrayProto_entries%': ['Array', 'prototype', 'entries'],
	'%ArrayProto_forEach%': ['Array', 'prototype', 'forEach'],
	'%ArrayProto_keys%': ['Array', 'prototype', 'keys'],
	'%ArrayProto_values%': ['Array', 'prototype', 'values'],
	'%AsyncFunctionPrototype%': ['AsyncFunction', 'prototype'],
	'%AsyncGenerator%': ['AsyncGeneratorFunction', 'prototype'],
	'%AsyncGeneratorPrototype%': ['AsyncGeneratorFunction', 'prototype', 'prototype'],
	'%BooleanPrototype%': ['Boolean', 'prototype'],
	'%DataViewPrototype%': ['DataView', 'prototype'],
	'%DatePrototype%': ['Date', 'prototype'],
	'%ErrorPrototype%': ['Error', 'prototype'],
	'%EvalErrorPrototype%': ['EvalError', 'prototype'],
	'%Float32ArrayPrototype%': ['Float32Array', 'prototype'],
	'%Float64ArrayPrototype%': ['Float64Array', 'prototype'],
	'%FunctionPrototype%': ['Function', 'prototype'],
	'%Generator%': ['GeneratorFunction', 'prototype'],
	'%GeneratorPrototype%': ['GeneratorFunction', 'prototype', 'prototype'],
	'%Int8ArrayPrototype%': ['Int8Array', 'prototype'],
	'%Int16ArrayPrototype%': ['Int16Array', 'prototype'],
	'%Int32ArrayPrototype%': ['Int32Array', 'prototype'],
	'%JSONParse%': ['JSON', 'parse'],
	'%JSONStringify%': ['JSON', 'stringify'],
	'%MapPrototype%': ['Map', 'prototype'],
	'%NumberPrototype%': ['Number', 'prototype'],
	'%ObjectPrototype%': ['Object', 'prototype'],
	'%ObjProto_toString%': ['Object', 'prototype', 'toString'],
	'%ObjProto_valueOf%': ['Object', 'prototype', 'valueOf'],
	'%PromisePrototype%': ['Promise', 'prototype'],
	'%PromiseProto_then%': ['Promise', 'prototype', 'then'],
	'%Promise_all%': ['Promise', 'all'],
	'%Promise_reject%': ['Promise', 'reject'],
	'%Promise_resolve%': ['Promise', 'resolve'],
	'%RangeErrorPrototype%': ['RangeError', 'prototype'],
	'%ReferenceErrorPrototype%': ['ReferenceError', 'prototype'],
	'%RegExpPrototype%': ['RegExp', 'prototype'],
	'%SetPrototype%': ['Set', 'prototype'],
	'%SharedArrayBufferPrototype%': ['SharedArrayBuffer', 'prototype'],
	'%StringPrototype%': ['String', 'prototype'],
	'%SymbolPrototype%': ['Symbol', 'prototype'],
	'%SyntaxErrorPrototype%': ['SyntaxError', 'prototype'],
	'%TypedArrayPrototype%': ['TypedArray', 'prototype'],
	'%TypeErrorPrototype%': ['TypeError', 'prototype'],
	'%Uint8ArrayPrototype%': ['Uint8Array', 'prototype'],
	'%Uint8ClampedArrayPrototype%': ['Uint8ClampedArray', 'prototype'],
	'%Uint16ArrayPrototype%': ['Uint16Array', 'prototype'],
	'%Uint32ArrayPrototype%': ['Uint32Array', 'prototype'],
	'%URIErrorPrototype%': ['URIError', 'prototype'],
	'%WeakMapPrototype%': ['WeakMap', 'prototype'],
	'%WeakSetPrototype%': ['WeakSet', 'prototype']
};

var bind = __webpack_require__(8474);
var hasOwn = __webpack_require__(9429);
var $concat = bind.call(Function.call, Array.prototype.concat);
var $spliceApply = bind.call(Function.apply, Array.prototype.splice);
var $replace = bind.call(Function.call, String.prototype.replace);
var $strSlice = bind.call(Function.call, String.prototype.slice);
var $exec = bind.call(Function.call, RegExp.prototype.exec);

/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */
var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
var reEscapeChar = /\\(\\)?/g; /** Used to match backslashes in property paths. */
var stringToPath = function stringToPath(string) {
	var first = $strSlice(string, 0, 1);
	var last = $strSlice(string, -1);
	if (first === '%' && last !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected closing `%`');
	} else if (last === '%' && first !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected opening `%`');
	}
	var result = [];
	$replace(string, rePropName, function (match, number, quote, subString) {
		result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
	});
	return result;
};
/* end adaptation */

var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
	var intrinsicName = name;
	var alias;
	if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
		alias = LEGACY_ALIASES[intrinsicName];
		intrinsicName = '%' + alias[0] + '%';
	}

	if (hasOwn(INTRINSICS, intrinsicName)) {
		var value = INTRINSICS[intrinsicName];
		if (value === needsEval) {
			value = doEval(intrinsicName);
		}
		if (typeof value === 'undefined' && !allowMissing) {
			throw new $TypeError('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
		}

		return {
			alias: alias,
			name: intrinsicName,
			value: value
		};
	}

	throw new $SyntaxError('intrinsic ' + name + ' does not exist!');
};

module.exports = function GetIntrinsic(name, allowMissing) {
	if (typeof name !== 'string' || name.length === 0) {
		throw new $TypeError('intrinsic name must be a non-empty string');
	}
	if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
		throw new $TypeError('"allowMissing" argument must be a boolean');
	}

	if ($exec(/^%?[^%]*%?$/, name) === null) {
		throw new $SyntaxError('`%` may not be present anywhere but at the beginning and end of the intrinsic name');
	}
	var parts = stringToPath(name);
	var intrinsicBaseName = parts.length > 0 ? parts[0] : '';

	var intrinsic = getBaseIntrinsic('%' + intrinsicBaseName + '%', allowMissing);
	var intrinsicRealName = intrinsic.name;
	var value = intrinsic.value;
	var skipFurtherCaching = false;

	var alias = intrinsic.alias;
	if (alias) {
		intrinsicBaseName = alias[0];
		$spliceApply(parts, $concat([0, 1], alias));
	}

	for (var i = 1, isOwn = true; i < parts.length; i += 1) {
		var part = parts[i];
		var first = $strSlice(part, 0, 1);
		var last = $strSlice(part, -1);
		if (
			(
				(first === '"' || first === "'" || first === '`')
				|| (last === '"' || last === "'" || last === '`')
			)
			&& first !== last
		) {
			throw new $SyntaxError('property names with quotes must have matching quotes');
		}
		if (part === 'constructor' || !isOwn) {
			skipFurtherCaching = true;
		}

		intrinsicBaseName += '.' + part;
		intrinsicRealName = '%' + intrinsicBaseName + '%';

		if (hasOwn(INTRINSICS, intrinsicRealName)) {
			value = INTRINSICS[intrinsicRealName];
		} else if (value != null) {
			if (!(part in value)) {
				if (!allowMissing) {
					throw new $TypeError('base intrinsic for ' + name + ' exists, but the property is not available.');
				}
				return void undefined;
			}
			if ($gOPD && (i + 1) >= parts.length) {
				var desc = $gOPD(value, part);
				isOwn = !!desc;

				// By convention, when a data property is converted to an accessor
				// property to emulate a data property that does not suffer from
				// the override mistake, that accessor's getter is marked with
				// an `originalValue` property. Here, when we detect this, we
				// uphold the illusion by pretending to see that original data
				// property, i.e., returning the value rather than the getter
				// itself.
				if (isOwn && 'get' in desc && !('originalValue' in desc.get)) {
					value = desc.get;
				} else {
					value = value[part];
				}
			} else {
				isOwn = hasOwn(value, part);
				value = value[part];
			}

			if (isOwn && !skipFurtherCaching) {
				INTRINSICS[intrinsicRealName] = value;
			}
		}
	}
	return value;
};


/***/ }),

/***/ 5314:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var origSymbol = typeof Symbol !== 'undefined' && Symbol;
var hasSymbolSham = __webpack_require__(6188);

module.exports = function hasNativeSymbols() {
	if (typeof origSymbol !== 'function') { return false; }
	if (typeof Symbol !== 'function') { return false; }
	if (typeof origSymbol('foo') !== 'symbol') { return false; }
	if (typeof Symbol('bar') !== 'symbol') { return false; }

	return hasSymbolSham();
};


/***/ }),

/***/ 6188:
/***/ (function(module) {

"use strict";


/* eslint complexity: [2, 18], max-statements: [2, 33] */
module.exports = function hasSymbols() {
	if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
	if (typeof Symbol.iterator === 'symbol') { return true; }

	var obj = {};
	var sym = Symbol('test');
	var symObj = Object(sym);
	if (typeof sym === 'string') { return false; }

	if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
	if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

	// temp disabled per https://github.com/ljharb/object.assign/issues/17
	// if (sym instanceof Symbol) { return false; }
	// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
	// if (!(symObj instanceof Symbol)) { return false; }

	// if (typeof Symbol.prototype.toString !== 'function') { return false; }
	// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

	var symVal = 42;
	obj[sym] = symVal;
	for (sym in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
	if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

	if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

	var syms = Object.getOwnPropertySymbols(obj);
	if (syms.length !== 1 || syms[0] !== sym) { return false; }

	if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

	if (typeof Object.getOwnPropertyDescriptor === 'function') {
		var descriptor = Object.getOwnPropertyDescriptor(obj, sym);
		if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
	}

	return true;
};


/***/ }),

/***/ 6841:
/***/ (function(module) {

"use strict";


var fnToStr = Function.prototype.toString;
var reflectApply = typeof Reflect === 'object' && Reflect !== null && Reflect.apply;
var badArrayLike;
var isCallableMarker;
if (typeof reflectApply === 'function' && typeof Object.defineProperty === 'function') {
	try {
		badArrayLike = Object.defineProperty({}, 'length', {
			get: function () {
				throw isCallableMarker;
			}
		});
		isCallableMarker = {};
		// eslint-disable-next-line no-throw-literal
		reflectApply(function () { throw 42; }, null, badArrayLike);
	} catch (_) {
		if (_ !== isCallableMarker) {
			reflectApply = null;
		}
	}
} else {
	reflectApply = null;
}

var constructorRegex = /^\s*class\b/;
var isES6ClassFn = function isES6ClassFunction(value) {
	try {
		var fnStr = fnToStr.call(value);
		return constructorRegex.test(fnStr);
	} catch (e) {
		return false; // not a function
	}
};

var tryFunctionObject = function tryFunctionToStr(value) {
	try {
		if (isES6ClassFn(value)) { return false; }
		fnToStr.call(value);
		return true;
	} catch (e) {
		return false;
	}
};
var toStr = Object.prototype.toString;
var objectClass = '[object Object]';
var fnClass = '[object Function]';
var genClass = '[object GeneratorFunction]';
var ddaClass = '[object HTMLAllCollection]'; // IE 11
var ddaClass2 = '[object HTML document.all class]';
var ddaClass3 = '[object HTMLCollection]'; // IE 9-10
var hasToStringTag = typeof Symbol === 'function' && !!Symbol.toStringTag; // better: use `has-tostringtag`

var isIE68 = !(0 in [,]); // eslint-disable-line no-sparse-arrays, comma-spacing

var isDDA = function isDocumentDotAll() { return false; };
if (typeof document === 'object') {
	// Firefox 3 canonicalizes DDA to undefined when it's not accessed directly
	var all = document.all;
	if (toStr.call(all) === toStr.call(document.all)) {
		isDDA = function isDocumentDotAll(value) {
			/* globals document: false */
			// in IE 6-8, typeof document.all is "object" and it's truthy
			if ((isIE68 || !value) && (typeof value === 'undefined' || typeof value === 'object')) {
				try {
					var str = toStr.call(value);
					return (
						str === ddaClass
						|| str === ddaClass2
						|| str === ddaClass3 // opera 12.16
						|| str === objectClass // IE 6-8
					) && value('') == null; // eslint-disable-line eqeqeq
				} catch (e) { /**/ }
			}
			return false;
		};
	}
}

module.exports = reflectApply
	? function isCallable(value) {
		if (isDDA(value)) { return true; }
		if (!value) { return false; }
		if (typeof value !== 'function' && typeof value !== 'object') { return false; }
		try {
			reflectApply(value, null, badArrayLike);
		} catch (e) {
			if (e !== isCallableMarker) { return false; }
		}
		return !isES6ClassFn(value) && tryFunctionObject(value);
	}
	: function isCallable(value) {
		if (isDDA(value)) { return true; }
		if (!value) { return false; }
		if (typeof value !== 'function' && typeof value !== 'object') { return false; }
		if (hasToStringTag) { return tryFunctionObject(value); }
		if (isES6ClassFn(value)) { return false; }
		var strClass = toStr.call(value);
		if (strClass !== fnClass && strClass !== genClass && !(/^\[object HTML/).test(strClass)) { return false; }
		return tryFunctionObject(value);
	};


/***/ }),

/***/ 5726:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var hasMap = typeof Map === 'function' && Map.prototype;
var mapSizeDescriptor = Object.getOwnPropertyDescriptor && hasMap ? Object.getOwnPropertyDescriptor(Map.prototype, 'size') : null;
var mapSize = hasMap && mapSizeDescriptor && typeof mapSizeDescriptor.get === 'function' ? mapSizeDescriptor.get : null;
var mapForEach = hasMap && Map.prototype.forEach;
var hasSet = typeof Set === 'function' && Set.prototype;
var setSizeDescriptor = Object.getOwnPropertyDescriptor && hasSet ? Object.getOwnPropertyDescriptor(Set.prototype, 'size') : null;
var setSize = hasSet && setSizeDescriptor && typeof setSizeDescriptor.get === 'function' ? setSizeDescriptor.get : null;
var setForEach = hasSet && Set.prototype.forEach;
var hasWeakMap = typeof WeakMap === 'function' && WeakMap.prototype;
var weakMapHas = hasWeakMap ? WeakMap.prototype.has : null;
var hasWeakSet = typeof WeakSet === 'function' && WeakSet.prototype;
var weakSetHas = hasWeakSet ? WeakSet.prototype.has : null;
var hasWeakRef = typeof WeakRef === 'function' && WeakRef.prototype;
var weakRefDeref = hasWeakRef ? WeakRef.prototype.deref : null;
var booleanValueOf = Boolean.prototype.valueOf;
var objectToString = Object.prototype.toString;
var functionToString = Function.prototype.toString;
var $match = String.prototype.match;
var $slice = String.prototype.slice;
var $replace = String.prototype.replace;
var $toUpperCase = String.prototype.toUpperCase;
var $toLowerCase = String.prototype.toLowerCase;
var $test = RegExp.prototype.test;
var $concat = Array.prototype.concat;
var $join = Array.prototype.join;
var $arrSlice = Array.prototype.slice;
var $floor = Math.floor;
var bigIntValueOf = typeof BigInt === 'function' ? BigInt.prototype.valueOf : null;
var gOPS = Object.getOwnPropertySymbols;
var symToString = typeof Symbol === 'function' && typeof Symbol.iterator === 'symbol' ? Symbol.prototype.toString : null;
var hasShammedSymbols = typeof Symbol === 'function' && typeof Symbol.iterator === 'object';
// ie, `has-tostringtag/shams
var toStringTag = typeof Symbol === 'function' && Symbol.toStringTag && (typeof Symbol.toStringTag === hasShammedSymbols ? 'object' : 'symbol')
    ? Symbol.toStringTag
    : null;
var isEnumerable = Object.prototype.propertyIsEnumerable;

var gPO = (typeof Reflect === 'function' ? Reflect.getPrototypeOf : Object.getPrototypeOf) || (
    [].__proto__ === Array.prototype // eslint-disable-line no-proto
        ? function (O) {
            return O.__proto__; // eslint-disable-line no-proto
        }
        : null
);

function addNumericSeparator(num, str) {
    if (
        num === Infinity
        || num === -Infinity
        || num !== num
        || (num && num > -1000 && num < 1000)
        || $test.call(/e/, str)
    ) {
        return str;
    }
    var sepRegex = /[0-9](?=(?:[0-9]{3})+(?![0-9]))/g;
    if (typeof num === 'number') {
        var int = num < 0 ? -$floor(-num) : $floor(num); // trunc(num)
        if (int !== num) {
            var intStr = String(int);
            var dec = $slice.call(str, intStr.length + 1);
            return $replace.call(intStr, sepRegex, '$&_') + '.' + $replace.call($replace.call(dec, /([0-9]{3})/g, '$&_'), /_$/, '');
        }
    }
    return $replace.call(str, sepRegex, '$&_');
}

var utilInspect = __webpack_require__(5794);
var inspectCustom = utilInspect.custom;
var inspectSymbol = isSymbol(inspectCustom) ? inspectCustom : null;

module.exports = function inspect_(obj, options, depth, seen) {
    var opts = options || {};

    if (has(opts, 'quoteStyle') && (opts.quoteStyle !== 'single' && opts.quoteStyle !== 'double')) {
        throw new TypeError('option "quoteStyle" must be "single" or "double"');
    }
    if (
        has(opts, 'maxStringLength') && (typeof opts.maxStringLength === 'number'
            ? opts.maxStringLength < 0 && opts.maxStringLength !== Infinity
            : opts.maxStringLength !== null
        )
    ) {
        throw new TypeError('option "maxStringLength", if provided, must be a positive integer, Infinity, or `null`');
    }
    var customInspect = has(opts, 'customInspect') ? opts.customInspect : true;
    if (typeof customInspect !== 'boolean' && customInspect !== 'symbol') {
        throw new TypeError('option "customInspect", if provided, must be `true`, `false`, or `\'symbol\'`');
    }

    if (
        has(opts, 'indent')
        && opts.indent !== null
        && opts.indent !== '\t'
        && !(parseInt(opts.indent, 10) === opts.indent && opts.indent > 0)
    ) {
        throw new TypeError('option "indent" must be "\\t", an integer > 0, or `null`');
    }
    if (has(opts, 'numericSeparator') && typeof opts.numericSeparator !== 'boolean') {
        throw new TypeError('option "numericSeparator", if provided, must be `true` or `false`');
    }
    var numericSeparator = opts.numericSeparator;

    if (typeof obj === 'undefined') {
        return 'undefined';
    }
    if (obj === null) {
        return 'null';
    }
    if (typeof obj === 'boolean') {
        return obj ? 'true' : 'false';
    }

    if (typeof obj === 'string') {
        return inspectString(obj, opts);
    }
    if (typeof obj === 'number') {
        if (obj === 0) {
            return Infinity / obj > 0 ? '0' : '-0';
        }
        var str = String(obj);
        return numericSeparator ? addNumericSeparator(obj, str) : str;
    }
    if (typeof obj === 'bigint') {
        var bigIntStr = String(obj) + 'n';
        return numericSeparator ? addNumericSeparator(obj, bigIntStr) : bigIntStr;
    }

    var maxDepth = typeof opts.depth === 'undefined' ? 5 : opts.depth;
    if (typeof depth === 'undefined') { depth = 0; }
    if (depth >= maxDepth && maxDepth > 0 && typeof obj === 'object') {
        return isArray(obj) ? '[Array]' : '[Object]';
    }

    var indent = getIndent(opts, depth);

    if (typeof seen === 'undefined') {
        seen = [];
    } else if (indexOf(seen, obj) >= 0) {
        return '[Circular]';
    }

    function inspect(value, from, noIndent) {
        if (from) {
            seen = $arrSlice.call(seen);
            seen.push(from);
        }
        if (noIndent) {
            var newOpts = {
                depth: opts.depth
            };
            if (has(opts, 'quoteStyle')) {
                newOpts.quoteStyle = opts.quoteStyle;
            }
            return inspect_(value, newOpts, depth + 1, seen);
        }
        return inspect_(value, opts, depth + 1, seen);
    }

    if (typeof obj === 'function' && !isRegExp(obj)) { // in older engines, regexes are callable
        var name = nameOf(obj);
        var keys = arrObjKeys(obj, inspect);
        return '[Function' + (name ? ': ' + name : ' (anonymous)') + ']' + (keys.length > 0 ? ' { ' + $join.call(keys, ', ') + ' }' : '');
    }
    if (isSymbol(obj)) {
        var symString = hasShammedSymbols ? $replace.call(String(obj), /^(Symbol\(.*\))_[^)]*$/, '$1') : symToString.call(obj);
        return typeof obj === 'object' && !hasShammedSymbols ? markBoxed(symString) : symString;
    }
    if (isElement(obj)) {
        var s = '<' + $toLowerCase.call(String(obj.nodeName));
        var attrs = obj.attributes || [];
        for (var i = 0; i < attrs.length; i++) {
            s += ' ' + attrs[i].name + '=' + wrapQuotes(quote(attrs[i].value), 'double', opts);
        }
        s += '>';
        if (obj.childNodes && obj.childNodes.length) { s += '...'; }
        s += '</' + $toLowerCase.call(String(obj.nodeName)) + '>';
        return s;
    }
    if (isArray(obj)) {
        if (obj.length === 0) { return '[]'; }
        var xs = arrObjKeys(obj, inspect);
        if (indent && !singleLineValues(xs)) {
            return '[' + indentedJoin(xs, indent) + ']';
        }
        return '[ ' + $join.call(xs, ', ') + ' ]';
    }
    if (isError(obj)) {
        var parts = arrObjKeys(obj, inspect);
        if (!('cause' in Error.prototype) && 'cause' in obj && !isEnumerable.call(obj, 'cause')) {
            return '{ [' + String(obj) + '] ' + $join.call($concat.call('[cause]: ' + inspect(obj.cause), parts), ', ') + ' }';
        }
        if (parts.length === 0) { return '[' + String(obj) + ']'; }
        return '{ [' + String(obj) + '] ' + $join.call(parts, ', ') + ' }';
    }
    if (typeof obj === 'object' && customInspect) {
        if (inspectSymbol && typeof obj[inspectSymbol] === 'function' && utilInspect) {
            return utilInspect(obj, { depth: maxDepth - depth });
        } else if (customInspect !== 'symbol' && typeof obj.inspect === 'function') {
            return obj.inspect();
        }
    }
    if (isMap(obj)) {
        var mapParts = [];
        if (mapForEach) {
            mapForEach.call(obj, function (value, key) {
                mapParts.push(inspect(key, obj, true) + ' => ' + inspect(value, obj));
            });
        }
        return collectionOf('Map', mapSize.call(obj), mapParts, indent);
    }
    if (isSet(obj)) {
        var setParts = [];
        if (setForEach) {
            setForEach.call(obj, function (value) {
                setParts.push(inspect(value, obj));
            });
        }
        return collectionOf('Set', setSize.call(obj), setParts, indent);
    }
    if (isWeakMap(obj)) {
        return weakCollectionOf('WeakMap');
    }
    if (isWeakSet(obj)) {
        return weakCollectionOf('WeakSet');
    }
    if (isWeakRef(obj)) {
        return weakCollectionOf('WeakRef');
    }
    if (isNumber(obj)) {
        return markBoxed(inspect(Number(obj)));
    }
    if (isBigInt(obj)) {
        return markBoxed(inspect(bigIntValueOf.call(obj)));
    }
    if (isBoolean(obj)) {
        return markBoxed(booleanValueOf.call(obj));
    }
    if (isString(obj)) {
        return markBoxed(inspect(String(obj)));
    }
    // note: in IE 8, sometimes `global !== window` but both are the prototypes of each other
    /* eslint-env browser */
    if (typeof window !== 'undefined' && obj === window) {
        return '{ [object Window] }';
    }
    if (
        (typeof globalThis !== 'undefined' && obj === globalThis)
        || (typeof __webpack_require__.g !== 'undefined' && obj === __webpack_require__.g)
    ) {
        return '{ [object globalThis] }';
    }
    if (!isDate(obj) && !isRegExp(obj)) {
        var ys = arrObjKeys(obj, inspect);
        var isPlainObject = gPO ? gPO(obj) === Object.prototype : obj instanceof Object || obj.constructor === Object;
        var protoTag = obj instanceof Object ? '' : 'null prototype';
        var stringTag = !isPlainObject && toStringTag && Object(obj) === obj && toStringTag in obj ? $slice.call(toStr(obj), 8, -1) : protoTag ? 'Object' : '';
        var constructorTag = isPlainObject || typeof obj.constructor !== 'function' ? '' : obj.constructor.name ? obj.constructor.name + ' ' : '';
        var tag = constructorTag + (stringTag || protoTag ? '[' + $join.call($concat.call([], stringTag || [], protoTag || []), ': ') + '] ' : '');
        if (ys.length === 0) { return tag + '{}'; }
        if (indent) {
            return tag + '{' + indentedJoin(ys, indent) + '}';
        }
        return tag + '{ ' + $join.call(ys, ', ') + ' }';
    }
    return String(obj);
};

function wrapQuotes(s, defaultStyle, opts) {
    var quoteChar = (opts.quoteStyle || defaultStyle) === 'double' ? '"' : "'";
    return quoteChar + s + quoteChar;
}

function quote(s) {
    return $replace.call(String(s), /"/g, '&quot;');
}

function isArray(obj) { return toStr(obj) === '[object Array]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }
function isDate(obj) { return toStr(obj) === '[object Date]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }
function isRegExp(obj) { return toStr(obj) === '[object RegExp]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }
function isError(obj) { return toStr(obj) === '[object Error]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }
function isString(obj) { return toStr(obj) === '[object String]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }
function isNumber(obj) { return toStr(obj) === '[object Number]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }
function isBoolean(obj) { return toStr(obj) === '[object Boolean]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }

// Symbol and BigInt do have Symbol.toStringTag by spec, so that can't be used to eliminate false positives
function isSymbol(obj) {
    if (hasShammedSymbols) {
        return obj && typeof obj === 'object' && obj instanceof Symbol;
    }
    if (typeof obj === 'symbol') {
        return true;
    }
    if (!obj || typeof obj !== 'object' || !symToString) {
        return false;
    }
    try {
        symToString.call(obj);
        return true;
    } catch (e) {}
    return false;
}

function isBigInt(obj) {
    if (!obj || typeof obj !== 'object' || !bigIntValueOf) {
        return false;
    }
    try {
        bigIntValueOf.call(obj);
        return true;
    } catch (e) {}
    return false;
}

var hasOwn = Object.prototype.hasOwnProperty || function (key) { return key in this; };
function has(obj, key) {
    return hasOwn.call(obj, key);
}

function toStr(obj) {
    return objectToString.call(obj);
}

function nameOf(f) {
    if (f.name) { return f.name; }
    var m = $match.call(functionToString.call(f), /^function\s*([\w$]+)/);
    if (m) { return m[1]; }
    return null;
}

function indexOf(xs, x) {
    if (xs.indexOf) { return xs.indexOf(x); }
    for (var i = 0, l = xs.length; i < l; i++) {
        if (xs[i] === x) { return i; }
    }
    return -1;
}

function isMap(x) {
    if (!mapSize || !x || typeof x !== 'object') {
        return false;
    }
    try {
        mapSize.call(x);
        try {
            setSize.call(x);
        } catch (s) {
            return true;
        }
        return x instanceof Map; // core-js workaround, pre-v2.5.0
    } catch (e) {}
    return false;
}

function isWeakMap(x) {
    if (!weakMapHas || !x || typeof x !== 'object') {
        return false;
    }
    try {
        weakMapHas.call(x, weakMapHas);
        try {
            weakSetHas.call(x, weakSetHas);
        } catch (s) {
            return true;
        }
        return x instanceof WeakMap; // core-js workaround, pre-v2.5.0
    } catch (e) {}
    return false;
}

function isWeakRef(x) {
    if (!weakRefDeref || !x || typeof x !== 'object') {
        return false;
    }
    try {
        weakRefDeref.call(x);
        return true;
    } catch (e) {}
    return false;
}

function isSet(x) {
    if (!setSize || !x || typeof x !== 'object') {
        return false;
    }
    try {
        setSize.call(x);
        try {
            mapSize.call(x);
        } catch (m) {
            return true;
        }
        return x instanceof Set; // core-js workaround, pre-v2.5.0
    } catch (e) {}
    return false;
}

function isWeakSet(x) {
    if (!weakSetHas || !x || typeof x !== 'object') {
        return false;
    }
    try {
        weakSetHas.call(x, weakSetHas);
        try {
            weakMapHas.call(x, weakMapHas);
        } catch (s) {
            return true;
        }
        return x instanceof WeakSet; // core-js workaround, pre-v2.5.0
    } catch (e) {}
    return false;
}

function isElement(x) {
    if (!x || typeof x !== 'object') { return false; }
    if (typeof HTMLElement !== 'undefined' && x instanceof HTMLElement) {
        return true;
    }
    return typeof x.nodeName === 'string' && typeof x.getAttribute === 'function';
}

function inspectString(str, opts) {
    if (str.length > opts.maxStringLength) {
        var remaining = str.length - opts.maxStringLength;
        var trailer = '... ' + remaining + ' more character' + (remaining > 1 ? 's' : '');
        return inspectString($slice.call(str, 0, opts.maxStringLength), opts) + trailer;
    }
    // eslint-disable-next-line no-control-regex
    var s = $replace.call($replace.call(str, /(['\\])/g, '\\$1'), /[\x00-\x1f]/g, lowbyte);
    return wrapQuotes(s, 'single', opts);
}

function lowbyte(c) {
    var n = c.charCodeAt(0);
    var x = {
        8: 'b',
        9: 't',
        10: 'n',
        12: 'f',
        13: 'r'
    }[n];
    if (x) { return '\\' + x; }
    return '\\x' + (n < 0x10 ? '0' : '') + $toUpperCase.call(n.toString(16));
}

function markBoxed(str) {
    return 'Object(' + str + ')';
}

function weakCollectionOf(type) {
    return type + ' { ? }';
}

function collectionOf(type, size, entries, indent) {
    var joinedEntries = indent ? indentedJoin(entries, indent) : $join.call(entries, ', ');
    return type + ' (' + size + ') {' + joinedEntries + '}';
}

function singleLineValues(xs) {
    for (var i = 0; i < xs.length; i++) {
        if (indexOf(xs[i], '\n') >= 0) {
            return false;
        }
    }
    return true;
}

function getIndent(opts, depth) {
    var baseIndent;
    if (opts.indent === '\t') {
        baseIndent = '\t';
    } else if (typeof opts.indent === 'number' && opts.indent > 0) {
        baseIndent = $join.call(Array(opts.indent + 1), ' ');
    } else {
        return null;
    }
    return {
        base: baseIndent,
        prev: $join.call(Array(depth + 1), baseIndent)
    };
}

function indentedJoin(xs, indent) {
    if (xs.length === 0) { return ''; }
    var lineJoiner = '\n' + indent.prev + indent.base;
    return lineJoiner + $join.call(xs, ',' + lineJoiner) + '\n' + indent.prev;
}

function arrObjKeys(obj, inspect) {
    var isArr = isArray(obj);
    var xs = [];
    if (isArr) {
        xs.length = obj.length;
        for (var i = 0; i < obj.length; i++) {
            xs[i] = has(obj, i) ? inspect(obj[i], obj) : '';
        }
    }
    var syms = typeof gOPS === 'function' ? gOPS(obj) : [];
    var symMap;
    if (hasShammedSymbols) {
        symMap = {};
        for (var k = 0; k < syms.length; k++) {
            symMap['$' + syms[k]] = syms[k];
        }
    }

    for (var key in obj) { // eslint-disable-line no-restricted-syntax
        if (!has(obj, key)) { continue; } // eslint-disable-line no-restricted-syntax, no-continue
        if (isArr && String(Number(key)) === key && key < obj.length) { continue; } // eslint-disable-line no-restricted-syntax, no-continue
        if (hasShammedSymbols && symMap['$' + key] instanceof Symbol) {
            // this is to prevent shammed Symbols, which are stored as strings, from being included in the string key section
            continue; // eslint-disable-line no-restricted-syntax, no-continue
        } else if ($test.call(/[^\w$]/, key)) {
            xs.push(inspect(key, obj) + ': ' + inspect(obj[key], obj));
        } else {
            xs.push(key + ': ' + inspect(obj[key], obj));
        }
    }
    if (typeof gOPS === 'function') {
        for (var j = 0; j < syms.length; j++) {
            if (isEnumerable.call(obj, syms[j])) {
                xs.push('[' + inspect(syms[j]) + ']: ' + inspect(obj[syms[j]], obj));
            }
        }
    }
    return xs;
}


/***/ }),

/***/ 5046:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var implementation = __webpack_require__(4073);

module.exports = function getPolyfill() {
	return (typeof Uint8Array === 'function' && Uint8Array.prototype.slice) || implementation;
};


/***/ }),

/***/ 8564:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var define = __webpack_require__(6776);
var getProto = __webpack_require__(9495);

var getPolyfill = __webpack_require__(5046);

module.exports = function shimTypedArraySlice() {
	if (typeof Uint8Array === 'function') {
		var polyfill = getPolyfill();
		var proto = getProto(Uint8Array.prototype);
		define(
			proto,
			{ slice: polyfill },
			{ slice: function () { return proto.slice !== polyfill; } }
		);
	}

	return polyfill;
};


/***/ }),

/***/ 4010:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var forEach = __webpack_require__(4843);
var availableTypedArrays = __webpack_require__(4343);
var callBind = __webpack_require__(4899);
var callBound = __webpack_require__(7120);
var gOPD = __webpack_require__(3828);

/** @type {(O: object) => string} */
var $toString = callBound('Object.prototype.toString');
var hasToStringTag = __webpack_require__(4111)();

var g = typeof globalThis === 'undefined' ? __webpack_require__.g : globalThis;
var typedArrays = availableTypedArrays();

var $slice = callBound('String.prototype.slice');
var getPrototypeOf = Object.getPrototypeOf; // require('getprototypeof');

/** @type {<T = unknown>(array: readonly T[], value: unknown) => number} */
var $indexOf = callBound('Array.prototype.indexOf', true) || function indexOf(array, value) {
	for (var i = 0; i < array.length; i += 1) {
		if (array[i] === value) {
			return i;
		}
	}
	return -1;
};

/** @typedef {(receiver: import('.').TypedArray) => string | typeof Uint8Array.prototype.slice.call | typeof Uint8Array.prototype.set.call} Getter */
/** @type {{ [k in `\$${import('.').TypedArrayName}`]?: Getter } & { __proto__: null }} */
var cache = { __proto__: null };
if (hasToStringTag && gOPD && getPrototypeOf) {
	forEach(typedArrays, function (typedArray) {
		var arr = new g[typedArray]();
		if (Symbol.toStringTag in arr) {
			var proto = getPrototypeOf(arr);
			// @ts-expect-error TS won't narrow inside a closure
			var descriptor = gOPD(proto, Symbol.toStringTag);
			if (!descriptor) {
				var superProto = getPrototypeOf(proto);
				// @ts-expect-error TS won't narrow inside a closure
				descriptor = gOPD(superProto, Symbol.toStringTag);
			}
			// @ts-expect-error TODO: fix
			cache['$' + typedArray] = callBind(descriptor.get);
		}
	});
} else {
	forEach(typedArrays, function (typedArray) {
		var arr = new g[typedArray]();
		var fn = arr.slice || arr.set;
		if (fn) {
			// @ts-expect-error TODO: fix
			cache['$' + typedArray] = callBind(fn);
		}
	});
}

/** @type {(value: object) => false | import('.').TypedArrayName} */
var tryTypedArrays = function tryAllTypedArrays(value) {
	/** @type {ReturnType<typeof tryAllTypedArrays>} */ var found = false;
	forEach(
		// eslint-disable-next-line no-extra-parens
		/** @type {Record<`\$${TypedArrayName}`, Getter>} */ /** @type {any} */ (cache),
		/** @type {(getter: Getter, name: `\$${import('.').TypedArrayName}`) => void} */
		function (getter, typedArray) {
			if (!found) {
				try {
				// @ts-expect-error TODO: fix
					if ('$' + getter(value) === typedArray) {
						found = $slice(typedArray, 1);
					}
				} catch (e) { /**/ }
			}
		}
	);
	return found;
};

/** @type {(value: object) => false | import('.').TypedArrayName} */
var trySlices = function tryAllSlices(value) {
	/** @type {ReturnType<typeof tryAllSlices>} */ var found = false;
	forEach(
		// eslint-disable-next-line no-extra-parens
		/** @type {Record<`\$${TypedArrayName}`, Getter>} */ /** @type {any} */ (cache),
		/** @type {(getter: typeof cache, name: `\$${import('.').TypedArrayName}`) => void} */ function (getter, name) {
			if (!found) {
				try {
					// @ts-expect-error TODO: fix
					getter(value);
					found = $slice(name, 1);
				} catch (e) { /**/ }
			}
		}
	);
	return found;
};

/** @type {import('.')} */
module.exports = function whichTypedArray(value) {
	if (!value || typeof value !== 'object') { return false; }
	if (!hasToStringTag) {
		/** @type {string} */
		var tag = $slice($toString(value), 8, -1);
		if ($indexOf(typedArrays, tag) > -1) {
			return tag;
		}
		if (tag !== 'Object') {
			return false;
		}
		// node < 0.6 hits here on real Typed Arrays
		return trySlices(value);
	}
	if (!gOPD) { return null; } // unknown engine
	return tryTypedArrays(value);
};


/***/ }),

/***/ 7120:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(6883);

var callBind = __webpack_require__(4899);

var $indexOf = callBind(GetIntrinsic('String.prototype.indexOf'));

module.exports = function callBoundIntrinsic(name, allowMissing) {
	var intrinsic = GetIntrinsic(name, !!allowMissing);
	if (typeof intrinsic === 'function' && $indexOf(name, '.prototype.') > -1) {
		return callBind(intrinsic);
	}
	return intrinsic;
};


/***/ }),

/***/ 4899:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var bind = __webpack_require__(7961);
var GetIntrinsic = __webpack_require__(6883);
var setFunctionLength = __webpack_require__(4521);

var $TypeError = __webpack_require__(1642);
var $apply = GetIntrinsic('%Function.prototype.apply%');
var $call = GetIntrinsic('%Function.prototype.call%');
var $reflectApply = GetIntrinsic('%Reflect.apply%', true) || bind.call($call, $apply);

var $defineProperty = __webpack_require__(8918);
var $max = GetIntrinsic('%Math.max%');

module.exports = function callBind(originalFunction) {
	if (typeof originalFunction !== 'function') {
		throw new $TypeError('a function is required');
	}
	var func = $reflectApply(bind, $call, arguments);
	return setFunctionLength(
		func,
		1 + $max(0, originalFunction.length - (arguments.length - 1)),
		true
	);
};

var applyBind = function applyBind() {
	return $reflectApply(bind, $apply, arguments);
};

if ($defineProperty) {
	$defineProperty(module.exports, 'apply', { value: applyBind });
} else {
	module.exports.apply = applyBind;
}


/***/ }),

/***/ 7562:
/***/ (function(module) {

"use strict";


/* eslint no-invalid-this: 1 */

var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
var toStr = Object.prototype.toString;
var max = Math.max;
var funcType = '[object Function]';

var concatty = function concatty(a, b) {
    var arr = [];

    for (var i = 0; i < a.length; i += 1) {
        arr[i] = a[i];
    }
    for (var j = 0; j < b.length; j += 1) {
        arr[j + a.length] = b[j];
    }

    return arr;
};

var slicy = function slicy(arrLike, offset) {
    var arr = [];
    for (var i = offset || 0, j = 0; i < arrLike.length; i += 1, j += 1) {
        arr[j] = arrLike[i];
    }
    return arr;
};

var joiny = function (arr, joiner) {
    var str = '';
    for (var i = 0; i < arr.length; i += 1) {
        str += arr[i];
        if (i + 1 < arr.length) {
            str += joiner;
        }
    }
    return str;
};

module.exports = function bind(that) {
    var target = this;
    if (typeof target !== 'function' || toStr.apply(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
    }
    var args = slicy(arguments, 1);

    var bound;
    var binder = function () {
        if (this instanceof bound) {
            var result = target.apply(
                this,
                concatty(args, arguments)
            );
            if (Object(result) === result) {
                return result;
            }
            return this;
        }
        return target.apply(
            that,
            concatty(args, arguments)
        );

    };

    var boundLength = max(0, target.length - args.length);
    var boundArgs = [];
    for (var i = 0; i < boundLength; i++) {
        boundArgs[i] = '$' + i;
    }

    bound = Function('binder', 'return function (' + joiny(boundArgs, ',') + '){ return binder.apply(this,arguments); }')(binder);

    if (target.prototype) {
        var Empty = function Empty() {};
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
    }

    return bound;
};


/***/ }),

/***/ 7961:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var implementation = __webpack_require__(7562);

module.exports = Function.prototype.bind || implementation;


/***/ }),

/***/ 6883:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var undefined;

var $Error = __webpack_require__(6716);
var $EvalError = __webpack_require__(6788);
var $RangeError = __webpack_require__(9204);
var $ReferenceError = __webpack_require__(9908);
var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);
var $URIError = __webpack_require__(1451);

var $Function = Function;

// eslint-disable-next-line consistent-return
var getEvalledConstructor = function (expressionSyntax) {
	try {
		return $Function('"use strict"; return (' + expressionSyntax + ').constructor;')();
	} catch (e) {}
};

var $gOPD = Object.getOwnPropertyDescriptor;
if ($gOPD) {
	try {
		$gOPD({}, '');
	} catch (e) {
		$gOPD = null; // this is IE 8, which has a broken gOPD
	}
}

var throwTypeError = function () {
	throw new $TypeError();
};
var ThrowTypeError = $gOPD
	? (function () {
		try {
			// eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
			arguments.callee; // IE 8 does not throw here
			return throwTypeError;
		} catch (calleeThrows) {
			try {
				// IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
				return $gOPD(arguments, 'callee').get;
			} catch (gOPDthrows) {
				return throwTypeError;
			}
		}
	}())
	: throwTypeError;

var hasSymbols = __webpack_require__(8861)();
var hasProto = __webpack_require__(1856)();

var getProto = Object.getPrototypeOf || (
	hasProto
		? function (x) { return x.__proto__; } // eslint-disable-line no-proto
		: null
);

var needsEval = {};

var TypedArray = typeof Uint8Array === 'undefined' || !getProto ? undefined : getProto(Uint8Array);

var INTRINSICS = {
	__proto__: null,
	'%AggregateError%': typeof AggregateError === 'undefined' ? undefined : AggregateError,
	'%Array%': Array,
	'%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined : ArrayBuffer,
	'%ArrayIteratorPrototype%': hasSymbols && getProto ? getProto([][Symbol.iterator]()) : undefined,
	'%AsyncFromSyncIteratorPrototype%': undefined,
	'%AsyncFunction%': needsEval,
	'%AsyncGenerator%': needsEval,
	'%AsyncGeneratorFunction%': needsEval,
	'%AsyncIteratorPrototype%': needsEval,
	'%Atomics%': typeof Atomics === 'undefined' ? undefined : Atomics,
	'%BigInt%': typeof BigInt === 'undefined' ? undefined : BigInt,
	'%BigInt64Array%': typeof BigInt64Array === 'undefined' ? undefined : BigInt64Array,
	'%BigUint64Array%': typeof BigUint64Array === 'undefined' ? undefined : BigUint64Array,
	'%Boolean%': Boolean,
	'%DataView%': typeof DataView === 'undefined' ? undefined : DataView,
	'%Date%': Date,
	'%decodeURI%': decodeURI,
	'%decodeURIComponent%': decodeURIComponent,
	'%encodeURI%': encodeURI,
	'%encodeURIComponent%': encodeURIComponent,
	'%Error%': $Error,
	'%eval%': eval, // eslint-disable-line no-eval
	'%EvalError%': $EvalError,
	'%Float32Array%': typeof Float32Array === 'undefined' ? undefined : Float32Array,
	'%Float64Array%': typeof Float64Array === 'undefined' ? undefined : Float64Array,
	'%FinalizationRegistry%': typeof FinalizationRegistry === 'undefined' ? undefined : FinalizationRegistry,
	'%Function%': $Function,
	'%GeneratorFunction%': needsEval,
	'%Int8Array%': typeof Int8Array === 'undefined' ? undefined : Int8Array,
	'%Int16Array%': typeof Int16Array === 'undefined' ? undefined : Int16Array,
	'%Int32Array%': typeof Int32Array === 'undefined' ? undefined : Int32Array,
	'%isFinite%': isFinite,
	'%isNaN%': isNaN,
	'%IteratorPrototype%': hasSymbols && getProto ? getProto(getProto([][Symbol.iterator]())) : undefined,
	'%JSON%': typeof JSON === 'object' ? JSON : undefined,
	'%Map%': typeof Map === 'undefined' ? undefined : Map,
	'%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Map()[Symbol.iterator]()),
	'%Math%': Math,
	'%Number%': Number,
	'%Object%': Object,
	'%parseFloat%': parseFloat,
	'%parseInt%': parseInt,
	'%Promise%': typeof Promise === 'undefined' ? undefined : Promise,
	'%Proxy%': typeof Proxy === 'undefined' ? undefined : Proxy,
	'%RangeError%': $RangeError,
	'%ReferenceError%': $ReferenceError,
	'%Reflect%': typeof Reflect === 'undefined' ? undefined : Reflect,
	'%RegExp%': RegExp,
	'%Set%': typeof Set === 'undefined' ? undefined : Set,
	'%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Set()[Symbol.iterator]()),
	'%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined : SharedArrayBuffer,
	'%String%': String,
	'%StringIteratorPrototype%': hasSymbols && getProto ? getProto(''[Symbol.iterator]()) : undefined,
	'%Symbol%': hasSymbols ? Symbol : undefined,
	'%SyntaxError%': $SyntaxError,
	'%ThrowTypeError%': ThrowTypeError,
	'%TypedArray%': TypedArray,
	'%TypeError%': $TypeError,
	'%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined : Uint8Array,
	'%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined : Uint8ClampedArray,
	'%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined : Uint16Array,
	'%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined : Uint32Array,
	'%URIError%': $URIError,
	'%WeakMap%': typeof WeakMap === 'undefined' ? undefined : WeakMap,
	'%WeakRef%': typeof WeakRef === 'undefined' ? undefined : WeakRef,
	'%WeakSet%': typeof WeakSet === 'undefined' ? undefined : WeakSet
};

if (getProto) {
	try {
		null.error; // eslint-disable-line no-unused-expressions
	} catch (e) {
		// https://github.com/tc39/proposal-shadowrealm/pull/384#issuecomment-1364264229
		var errorProto = getProto(getProto(e));
		INTRINSICS['%Error.prototype%'] = errorProto;
	}
}

var doEval = function doEval(name) {
	var value;
	if (name === '%AsyncFunction%') {
		value = getEvalledConstructor('async function () {}');
	} else if (name === '%GeneratorFunction%') {
		value = getEvalledConstructor('function* () {}');
	} else if (name === '%AsyncGeneratorFunction%') {
		value = getEvalledConstructor('async function* () {}');
	} else if (name === '%AsyncGenerator%') {
		var fn = doEval('%AsyncGeneratorFunction%');
		if (fn) {
			value = fn.prototype;
		}
	} else if (name === '%AsyncIteratorPrototype%') {
		var gen = doEval('%AsyncGenerator%');
		if (gen && getProto) {
			value = getProto(gen.prototype);
		}
	}

	INTRINSICS[name] = value;

	return value;
};

var LEGACY_ALIASES = {
	__proto__: null,
	'%ArrayBufferPrototype%': ['ArrayBuffer', 'prototype'],
	'%ArrayPrototype%': ['Array', 'prototype'],
	'%ArrayProto_entries%': ['Array', 'prototype', 'entries'],
	'%ArrayProto_forEach%': ['Array', 'prototype', 'forEach'],
	'%ArrayProto_keys%': ['Array', 'prototype', 'keys'],
	'%ArrayProto_values%': ['Array', 'prototype', 'values'],
	'%AsyncFunctionPrototype%': ['AsyncFunction', 'prototype'],
	'%AsyncGenerator%': ['AsyncGeneratorFunction', 'prototype'],
	'%AsyncGeneratorPrototype%': ['AsyncGeneratorFunction', 'prototype', 'prototype'],
	'%BooleanPrototype%': ['Boolean', 'prototype'],
	'%DataViewPrototype%': ['DataView', 'prototype'],
	'%DatePrototype%': ['Date', 'prototype'],
	'%ErrorPrototype%': ['Error', 'prototype'],
	'%EvalErrorPrototype%': ['EvalError', 'prototype'],
	'%Float32ArrayPrototype%': ['Float32Array', 'prototype'],
	'%Float64ArrayPrototype%': ['Float64Array', 'prototype'],
	'%FunctionPrototype%': ['Function', 'prototype'],
	'%Generator%': ['GeneratorFunction', 'prototype'],
	'%GeneratorPrototype%': ['GeneratorFunction', 'prototype', 'prototype'],
	'%Int8ArrayPrototype%': ['Int8Array', 'prototype'],
	'%Int16ArrayPrototype%': ['Int16Array', 'prototype'],
	'%Int32ArrayPrototype%': ['Int32Array', 'prototype'],
	'%JSONParse%': ['JSON', 'parse'],
	'%JSONStringify%': ['JSON', 'stringify'],
	'%MapPrototype%': ['Map', 'prototype'],
	'%NumberPrototype%': ['Number', 'prototype'],
	'%ObjectPrototype%': ['Object', 'prototype'],
	'%ObjProto_toString%': ['Object', 'prototype', 'toString'],
	'%ObjProto_valueOf%': ['Object', 'prototype', 'valueOf'],
	'%PromisePrototype%': ['Promise', 'prototype'],
	'%PromiseProto_then%': ['Promise', 'prototype', 'then'],
	'%Promise_all%': ['Promise', 'all'],
	'%Promise_reject%': ['Promise', 'reject'],
	'%Promise_resolve%': ['Promise', 'resolve'],
	'%RangeErrorPrototype%': ['RangeError', 'prototype'],
	'%ReferenceErrorPrototype%': ['ReferenceError', 'prototype'],
	'%RegExpPrototype%': ['RegExp', 'prototype'],
	'%SetPrototype%': ['Set', 'prototype'],
	'%SharedArrayBufferPrototype%': ['SharedArrayBuffer', 'prototype'],
	'%StringPrototype%': ['String', 'prototype'],
	'%SymbolPrototype%': ['Symbol', 'prototype'],
	'%SyntaxErrorPrototype%': ['SyntaxError', 'prototype'],
	'%TypedArrayPrototype%': ['TypedArray', 'prototype'],
	'%TypeErrorPrototype%': ['TypeError', 'prototype'],
	'%Uint8ArrayPrototype%': ['Uint8Array', 'prototype'],
	'%Uint8ClampedArrayPrototype%': ['Uint8ClampedArray', 'prototype'],
	'%Uint16ArrayPrototype%': ['Uint16Array', 'prototype'],
	'%Uint32ArrayPrototype%': ['Uint32Array', 'prototype'],
	'%URIErrorPrototype%': ['URIError', 'prototype'],
	'%WeakMapPrototype%': ['WeakMap', 'prototype'],
	'%WeakSetPrototype%': ['WeakSet', 'prototype']
};

var bind = __webpack_require__(7961);
var hasOwn = __webpack_require__(9429);
var $concat = bind.call(Function.call, Array.prototype.concat);
var $spliceApply = bind.call(Function.apply, Array.prototype.splice);
var $replace = bind.call(Function.call, String.prototype.replace);
var $strSlice = bind.call(Function.call, String.prototype.slice);
var $exec = bind.call(Function.call, RegExp.prototype.exec);

/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */
var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
var reEscapeChar = /\\(\\)?/g; /** Used to match backslashes in property paths. */
var stringToPath = function stringToPath(string) {
	var first = $strSlice(string, 0, 1);
	var last = $strSlice(string, -1);
	if (first === '%' && last !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected closing `%`');
	} else if (last === '%' && first !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected opening `%`');
	}
	var result = [];
	$replace(string, rePropName, function (match, number, quote, subString) {
		result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
	});
	return result;
};
/* end adaptation */

var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
	var intrinsicName = name;
	var alias;
	if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
		alias = LEGACY_ALIASES[intrinsicName];
		intrinsicName = '%' + alias[0] + '%';
	}

	if (hasOwn(INTRINSICS, intrinsicName)) {
		var value = INTRINSICS[intrinsicName];
		if (value === needsEval) {
			value = doEval(intrinsicName);
		}
		if (typeof value === 'undefined' && !allowMissing) {
			throw new $TypeError('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
		}

		return {
			alias: alias,
			name: intrinsicName,
			value: value
		};
	}

	throw new $SyntaxError('intrinsic ' + name + ' does not exist!');
};

module.exports = function GetIntrinsic(name, allowMissing) {
	if (typeof name !== 'string' || name.length === 0) {
		throw new $TypeError('intrinsic name must be a non-empty string');
	}
	if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
		throw new $TypeError('"allowMissing" argument must be a boolean');
	}

	if ($exec(/^%?[^%]*%?$/, name) === null) {
		throw new $SyntaxError('`%` may not be present anywhere but at the beginning and end of the intrinsic name');
	}
	var parts = stringToPath(name);
	var intrinsicBaseName = parts.length > 0 ? parts[0] : '';

	var intrinsic = getBaseIntrinsic('%' + intrinsicBaseName + '%', allowMissing);
	var intrinsicRealName = intrinsic.name;
	var value = intrinsic.value;
	var skipFurtherCaching = false;

	var alias = intrinsic.alias;
	if (alias) {
		intrinsicBaseName = alias[0];
		$spliceApply(parts, $concat([0, 1], alias));
	}

	for (var i = 1, isOwn = true; i < parts.length; i += 1) {
		var part = parts[i];
		var first = $strSlice(part, 0, 1);
		var last = $strSlice(part, -1);
		if (
			(
				(first === '"' || first === "'" || first === '`')
				|| (last === '"' || last === "'" || last === '`')
			)
			&& first !== last
		) {
			throw new $SyntaxError('property names with quotes must have matching quotes');
		}
		if (part === 'constructor' || !isOwn) {
			skipFurtherCaching = true;
		}

		intrinsicBaseName += '.' + part;
		intrinsicRealName = '%' + intrinsicBaseName + '%';

		if (hasOwn(INTRINSICS, intrinsicRealName)) {
			value = INTRINSICS[intrinsicRealName];
		} else if (value != null) {
			if (!(part in value)) {
				if (!allowMissing) {
					throw new $TypeError('base intrinsic for ' + name + ' exists, but the property is not available.');
				}
				return void undefined;
			}
			if ($gOPD && (i + 1) >= parts.length) {
				var desc = $gOPD(value, part);
				isOwn = !!desc;

				// By convention, when a data property is converted to an accessor
				// property to emulate a data property that does not suffer from
				// the override mistake, that accessor's getter is marked with
				// an `originalValue` property. Here, when we detect this, we
				// uphold the illusion by pretending to see that original data
				// property, i.e., returning the value rather than the getter
				// itself.
				if (isOwn && 'get' in desc && !('originalValue' in desc.get)) {
					value = desc.get;
				} else {
					value = value[part];
				}
			} else {
				isOwn = hasOwn(value, part);
				value = value[part];
			}

			if (isOwn && !skipFurtherCaching) {
				INTRINSICS[intrinsicRealName] = value;
			}
		}
	}
	return value;
};


/***/ }),

/***/ 8861:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var origSymbol = typeof Symbol !== 'undefined' && Symbol;
var hasSymbolSham = __webpack_require__(704);

module.exports = function hasNativeSymbols() {
	if (typeof origSymbol !== 'function') { return false; }
	if (typeof Symbol !== 'function') { return false; }
	if (typeof origSymbol('foo') !== 'symbol') { return false; }
	if (typeof Symbol('bar') !== 'symbol') { return false; }

	return hasSymbolSham();
};


/***/ }),

/***/ 704:
/***/ (function(module) {

"use strict";


/* eslint complexity: [2, 18], max-statements: [2, 33] */
module.exports = function hasSymbols() {
	if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
	if (typeof Symbol.iterator === 'symbol') { return true; }

	var obj = {};
	var sym = Symbol('test');
	var symObj = Object(sym);
	if (typeof sym === 'string') { return false; }

	if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
	if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

	// temp disabled per https://github.com/ljharb/object.assign/issues/17
	// if (sym instanceof Symbol) { return false; }
	// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
	// if (!(symObj instanceof Symbol)) { return false; }

	// if (typeof Symbol.prototype.toString !== 'function') { return false; }
	// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

	var symVal = 42;
	obj[sym] = symVal;
	for (sym in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
	if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

	if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

	var syms = Object.getOwnPropertySymbols(obj);
	if (syms.length !== 1 || syms[0] !== sym) { return false; }

	if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

	if (typeof Object.getOwnPropertyDescriptor === 'function') {
		var descriptor = Object.getOwnPropertyDescriptor(obj, sym);
		if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
	}

	return true;
};


/***/ }),

/***/ 9196:
/***/ (function(module) {

"use strict";
module.exports = window["React"];

/***/ }),

/***/ 5794:
/***/ (function() {

/* (ignored) */

/***/ }),

/***/ 4343:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var possibleNames = __webpack_require__(131);

var g = typeof globalThis === 'undefined' ? __webpack_require__.g : globalThis;

/** @type {import('.')} */
module.exports = function availableTypedArrays() {
	var /** @type {ReturnType<typeof availableTypedArrays>} */ out = [];
	for (var i = 0; i < possibleNames.length; i++) {
		if (typeof g[possibleNames[i]] === 'function') {
			// @ts-expect-error
			out[out.length] = possibleNames[i];
		}
	}
	return out;
};


/***/ }),

/***/ 7153:
/***/ (function(module, exports) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
	Copyright (c) 2018 Jed Watson.
	Licensed under the MIT License (MIT), see
	http://jedwatson.github.io/classnames
*/
/* global define */

(function () {
	'use strict';

	var hasOwn = {}.hasOwnProperty;

	function classNames () {
		var classes = '';

		for (var i = 0; i < arguments.length; i++) {
			var arg = arguments[i];
			if (arg) {
				classes = appendClass(classes, parseValue(arg));
			}
		}

		return classes;
	}

	function parseValue (arg) {
		if (typeof arg === 'string' || typeof arg === 'number') {
			return arg;
		}

		if (typeof arg !== 'object') {
			return '';
		}

		if (Array.isArray(arg)) {
			return classNames.apply(null, arg);
		}

		if (arg.toString !== Object.prototype.toString && !arg.toString.toString().includes('[native code]')) {
			return arg.toString();
		}

		var classes = '';

		for (var key in arg) {
			if (hasOwn.call(arg, key) && arg[key]) {
				classes = appendClass(classes, key);
			}
		}

		return classes;
	}

	function appendClass (value, newClass) {
		if (!newClass) {
			return value;
		}
	
		if (value) {
			return value + ' ' + newClass;
		}
	
		return value + newClass;
	}

	if ( true && module.exports) {
		classNames.default = classNames;
		module.exports = classNames;
	} else if (true) {
		// register as 'classnames', consistent with npm package name
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {
			return classNames;
		}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else {}
}());


/***/ }),

/***/ 6245:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(5037);

var $String = GetIntrinsic('%String%');
var $TypeError = __webpack_require__(1642);

// https://262.ecma-international.org/6.0/#sec-tostring

module.exports = function ToString(argument) {
	if (typeof argument === 'symbol') {
		throw new $TypeError('Cannot convert a Symbol value to a string');
	}
	return $String(argument);
};


/***/ }),

/***/ 2981:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $TypeError = __webpack_require__(1642);

// https://tc39.es/ecma262/#sec-arraybufferbytelength

var IsDetachedBuffer = __webpack_require__(1320);

var isArrayBuffer = __webpack_require__(4602);
var isSharedArrayBuffer = __webpack_require__(5604);
var arrayBufferByteLength = __webpack_require__(480);

var isGrowable = false; // TODO: support this

module.exports = function ArrayBufferByteLength(arrayBuffer, order) {
	var isSAB = isSharedArrayBuffer(arrayBuffer);
	if (!isArrayBuffer(arrayBuffer) && !isSAB) {
		throw new $TypeError('Assertion failed: `arrayBuffer` must be an ArrayBuffer or a SharedArrayBuffer');
	}
	if (order !== 'SEQ-CST' && order !== 'UNORDERED') {
		throw new $TypeError('Assertion failed: `order` must be ~SEQ-CST~ or ~UNORDERED~');
	}

	// 1. If IsSharedArrayBuffer(arrayBuffer) is true and arrayBuffer has an [[ArrayBufferByteLengthData]] internal slot, then
	// TODO: see if IsFixedLengthArrayBuffer can be used here in the spec instead
	if (isSAB && isGrowable) { // step 1
		// a. Let bufferByteLengthBlock be arrayBuffer.[[ArrayBufferByteLengthData]].
		// b. Let rawLength be GetRawBytesFromSharedBlock(bufferByteLengthBlock, 0, BIGUINT64, true, order).
		// c. Let isLittleEndian be the value of the [[LittleEndian]] field of the surrounding agent's Agent Record.
		// d. Return ℝ(RawBytesToNumeric(BIGUINT64, rawLength, isLittleEndian)).
	}

	if (IsDetachedBuffer(arrayBuffer)) {
		throw new $TypeError('Assertion failed: `arrayBuffer` must not be detached'); // step 2
	}

	return arrayBufferByteLength(arrayBuffer);
};


/***/ }),

/***/ 6548:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $BigInt = GetIntrinsic('%BigInt%', true);
var $RangeError = __webpack_require__(9204);
var $TypeError = __webpack_require__(1642);

var zero = $BigInt && $BigInt(0);

// https://262.ecma-international.org/11.0/#sec-numeric-types-bigint-remainder

module.exports = function BigIntRemainder(n, d) {
	if (typeof n !== 'bigint' || typeof d !== 'bigint') {
		throw new $TypeError('Assertion failed: `n` and `d` arguments must be BigInts');
	}

	if (d === zero) {
		throw new $RangeError('Division by zero');
	}

	if (n === zero) {
		return zero;
	}

	// shortcut for the actual spec mechanics
	return n % d;
};


/***/ }),

/***/ 9002:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $TypeError = __webpack_require__(1642);

var isPropertyDescriptor = __webpack_require__(6862);
var DefineOwnProperty = __webpack_require__(208);

var FromPropertyDescriptor = __webpack_require__(8367);
var IsDataDescriptor = __webpack_require__(4065);
var IsPropertyKey = __webpack_require__(9762);
var SameValue = __webpack_require__(3392);
var ToPropertyDescriptor = __webpack_require__(8110);
var Type = __webpack_require__(9655);

// https://262.ecma-international.org/6.0/#sec-definepropertyorthrow

module.exports = function DefinePropertyOrThrow(O, P, desc) {
	if (Type(O) !== 'Object') {
		throw new $TypeError('Assertion failed: Type(O) is not Object');
	}

	if (!IsPropertyKey(P)) {
		throw new $TypeError('Assertion failed: IsPropertyKey(P) is not true');
	}

	var Desc = isPropertyDescriptor(desc) ? desc : ToPropertyDescriptor(desc);
	if (!isPropertyDescriptor(Desc)) {
		throw new $TypeError('Assertion failed: Desc is not a valid Property Descriptor');
	}

	return DefineOwnProperty(
		IsDataDescriptor,
		SameValue,
		FromPropertyDescriptor,
		O,
		P,
		Desc
	);
};


/***/ }),

/***/ 8367:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $TypeError = __webpack_require__(1642);

var isPropertyDescriptor = __webpack_require__(6862);
var fromPropertyDescriptor = __webpack_require__(2646);

// https://262.ecma-international.org/6.0/#sec-frompropertydescriptor

module.exports = function FromPropertyDescriptor(Desc) {
	if (typeof Desc !== 'undefined' && !isPropertyDescriptor(Desc)) {
		throw new $TypeError('Assertion failed: `Desc` must be a Property Descriptor');
	}

	return fromPropertyDescriptor(Desc);
};


/***/ }),

/***/ 3675:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $TypeError = __webpack_require__(1642);

var inspect = __webpack_require__(5726);

var IsPropertyKey = __webpack_require__(9762);
var Type = __webpack_require__(9655);

// https://262.ecma-international.org/6.0/#sec-get-o-p

module.exports = function Get(O, P) {
	// 7.3.1.1
	if (Type(O) !== 'Object') {
		throw new $TypeError('Assertion failed: Type(O) is not Object');
	}
	// 7.3.1.2
	if (!IsPropertyKey(P)) {
		throw new $TypeError('Assertion failed: IsPropertyKey(P) is not true, got ' + inspect(P));
	}
	// 7.3.1.3
	return O[P];
};


/***/ }),

/***/ 9661:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);
var $Uint8Array = GetIntrinsic('%Uint8Array%', true);

var callBound = __webpack_require__(1154);

var $slice = callBound('Array.prototype.slice');

var isInteger = __webpack_require__(6156);

var IsDetachedBuffer = __webpack_require__(1320);
var RawBytesToNumeric = __webpack_require__(9219);

var isArrayBuffer = __webpack_require__(4602);
var isSharedArrayBuffer = __webpack_require__(5604);
var safeConcat = __webpack_require__(3002);

var tableTAO = __webpack_require__(2170);

var defaultEndianness = __webpack_require__(2142);

// https://262.ecma-international.org/15.0/#sec-getvaluefrombuffer

module.exports = function GetValueFromBuffer(arrayBuffer, byteIndex, type, isTypedArray, order) {
	var isSAB = isSharedArrayBuffer(arrayBuffer);
	if (!isArrayBuffer(arrayBuffer) && !isSAB) {
		throw new $TypeError('Assertion failed: `arrayBuffer` must be an ArrayBuffer or a SharedArrayBuffer');
	}

	if (!isInteger(byteIndex)) {
		throw new $TypeError('Assertion failed: `byteIndex` must be an integer');
	}

	if (typeof type !== 'string' || typeof tableTAO.size['$' + type] !== 'number') {
		throw new $TypeError('Assertion failed: `type` must be a Typed Array element type');
	}

	if (typeof isTypedArray !== 'boolean') {
		throw new $TypeError('Assertion failed: `isTypedArray` must be a boolean');
	}

	if (order !== 'SEQ-CST' && order !== 'UNORDERED') {
		throw new $TypeError('Assertion failed: `order` must be either `SEQ-CST` or `UNORDERED`');
	}

	if (arguments.length > 5 && typeof arguments[5] !== 'boolean') {
		throw new $TypeError('Assertion failed: `isLittleEndian` must be a boolean, if present');
	}

	if (IsDetachedBuffer(arrayBuffer)) {
		throw new $TypeError('Assertion failed: `arrayBuffer` is detached'); // step 1
	}

	// 2. Assert: There are sufficient bytes in arrayBuffer starting at byteIndex to represent a value of type.

	if (byteIndex < 0) {
		throw new $TypeError('Assertion failed: `byteIndex` must be non-negative'); // step 3
	}

	// 4. Let block be arrayBuffer.[[ArrayBufferData]].

	var elementSize = tableTAO.size['$' + type]; // step 5
	if (!elementSize) {
		throw new $TypeError('Assertion failed: `type` must be one of "INT8", "UINT8", "UINT8C", "INT16", "UINT16", "INT32", "UINT32", "BIGINT64", "BIGUINT64", "FLOAT32", or "FLOAT64"');
	}

	var rawValue;
	if (isSAB) { // step 6
		/*
		a. Let execution be the [[CandidateExecution]] field of the surrounding agent's Agent Record.
		b. Let eventList be the [[EventList]] field of the element in execution.[[EventLists]] whose [[AgentSignifier]] is AgentSignifier().
		c. If isTypedArray is true and type is "Int8", "Uint8", "Int16", "Uint16", "Int32", or "Uint32", let noTear be true; otherwise let noTear be false.
		d. Let rawValue be a List of length elementSize of nondeterministically chosen byte values.
		e. NOTE: In implementations, rawValue is the result of a non-atomic or atomic read instruction on the underlying hardware. The nondeterminism is a semantic prescription of the memory model to describe observable behaviour of hardware with weak consistency.
		f. Let readEvent be ReadSharedMemory{ [[Order]]: order, [[NoTear]]: noTear, [[Block]]: block, [[ByteIndex]]: byteIndex, [[ElementSize]]: elementSize }.
		g. Append readEvent to eventList.
		h. Append Chosen Value Record { [[Event]]: readEvent, [[ChosenValue]]: rawValue } to execution.[[ChosenValues]].
		*/
		throw new $SyntaxError('SharedArrayBuffer is not supported by this implementation');
	} else {
		// 7. Let rawValue be a List of elementSize containing, in order, the elementSize sequence of bytes starting with block[byteIndex].
		rawValue = $slice(new $Uint8Array(arrayBuffer, byteIndex), 0, elementSize); // step 6
	}

	// 8. If isLittleEndian is not present, set isLittleEndian to either true or false. The choice is implementation dependent and should be the alternative that is most efficient for the implementation. An implementation must use the same value each time this step is executed and the same value must be used for the corresponding step in the SetValueInBuffer abstract operation.
	var isLittleEndian = arguments.length > 5 ? arguments[5] : defaultEndianness === 'little'; // step 8

	var bytes = isLittleEndian
		? $slice(safeConcat([0, 0, 0, 0, 0, 0, 0, 0], rawValue), -elementSize)
		: $slice(safeConcat(rawValue, [0, 0, 0, 0, 0, 0, 0, 0]), 0, elementSize);

	return RawBytesToNumeric(type, bytes, isLittleEndian);
};


/***/ }),

/***/ 5584:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $TypeError = __webpack_require__(1642);

var hasOwn = __webpack_require__(9429);

var IsPropertyKey = __webpack_require__(9762);
var Type = __webpack_require__(9655);

// https://262.ecma-international.org/6.0/#sec-hasownproperty

module.exports = function HasOwnProperty(O, P) {
	if (Type(O) !== 'Object') {
		throw new $TypeError('Assertion failed: `O` must be an Object');
	}
	if (!IsPropertyKey(P)) {
		throw new $TypeError('Assertion failed: `P` must be a Property Key');
	}
	return hasOwn(O, P);
};


/***/ }),

/***/ 2985:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


// https://262.ecma-international.org/6.0/#sec-isarray
module.exports = __webpack_require__(692);


/***/ }),

/***/ 4734:
/***/ (function(module) {

"use strict";


// https://262.ecma-international.org/15.0/#sec-isbigintelementtype

module.exports = function IsBigIntElementType(type) {
	return type === 'BIGUINT64' || type === 'BIGINT64';
};


/***/ }),

/***/ 3071:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


// http://262.ecma-international.org/5.1/#sec-9.11

module.exports = __webpack_require__(6841);


/***/ }),

/***/ 7010:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(4342);

var $construct = GetIntrinsic('%Reflect.construct%', true);

var DefinePropertyOrThrow = __webpack_require__(9002);
try {
	DefinePropertyOrThrow({}, '', { '[[Get]]': function () {} });
} catch (e) {
	// Accessor properties aren't supported
	DefinePropertyOrThrow = null;
}

// https://262.ecma-international.org/6.0/#sec-isconstructor

if (DefinePropertyOrThrow && $construct) {
	var isConstructorMarker = {};
	var badArrayLike = {};
	DefinePropertyOrThrow(badArrayLike, 'length', {
		'[[Get]]': function () {
			throw isConstructorMarker;
		},
		'[[Enumerable]]': true
	});

	module.exports = function IsConstructor(argument) {
		try {
			// `Reflect.construct` invokes `IsConstructor(target)` before `Get(args, 'length')`:
			$construct(argument, badArrayLike);
		} catch (err) {
			return err === isConstructorMarker;
		}
	};
} else {
	module.exports = function IsConstructor(argument) {
		// unfortunately there's no way to truly check this without try/catch `new argument` in old environments
		return typeof argument === 'function' && !!argument.prototype;
	};
}


/***/ }),

/***/ 4065:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $TypeError = __webpack_require__(1642);

var hasOwn = __webpack_require__(9429);

var isPropertyDescriptor = __webpack_require__(6862);

// https://262.ecma-international.org/5.1/#sec-8.10.2

module.exports = function IsDataDescriptor(Desc) {
	if (typeof Desc === 'undefined') {
		return false;
	}

	if (!isPropertyDescriptor(Desc)) {
		throw new $TypeError('Assertion failed: `Desc` must be a Property Descriptor');
	}

	if (!hasOwn(Desc, '[[Value]]') && !hasOwn(Desc, '[[Writable]]')) {
		return false;
	}

	return true;
};


/***/ }),

/***/ 1320:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $TypeError = __webpack_require__(1642);

var $byteLength = __webpack_require__(480);
var availableTypedArrays = __webpack_require__(4343)();
var callBound = __webpack_require__(1154);
var isArrayBuffer = __webpack_require__(4602);
var isSharedArrayBuffer = __webpack_require__(5604);

var $sabByteLength = callBound('SharedArrayBuffer.prototype.byteLength', true);

// https://262.ecma-international.org/8.0/#sec-isdetachedbuffer

module.exports = function IsDetachedBuffer(arrayBuffer) {
	var isSAB = isSharedArrayBuffer(arrayBuffer);
	if (!isArrayBuffer(arrayBuffer) && !isSAB) {
		throw new $TypeError('Assertion failed: `arrayBuffer` must be an Object with an [[ArrayBufferData]] internal slot');
	}
	if ((isSAB ? $sabByteLength : $byteLength)(arrayBuffer) === 0) {
		try {
			new __webpack_require__.g[availableTypedArrays[0]](arrayBuffer); // eslint-disable-line no-new
		} catch (error) {
			return !!error && error.name === 'TypeError';
		}
	}
	return false;
};


/***/ }),

/***/ 9442:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $TypeError = __webpack_require__(1642);

var callBound = __webpack_require__(1154);

var $arrayBufferResizable = callBound('%ArrayBuffer.prototype.resizable%', true);
var $sharedArrayGrowable = callBound('%SharedArrayBuffer.prototype.growable%', true);

var isArrayBuffer = __webpack_require__(4602);
var isSharedArrayBuffer = __webpack_require__(5604);

// https://262.ecma-international.org/15.0/#sec-isfixedlengtharraybuffer

module.exports = function IsFixedLengthArrayBuffer(arrayBuffer) {
	var isAB = isArrayBuffer(arrayBuffer);
	var isSAB = isSharedArrayBuffer(arrayBuffer);
	if (!isAB && !isSAB) {
		throw new $TypeError('Assertion failed: `arrayBuffer` must be an ArrayBuffer or SharedArrayBuffer');
	}

	if (isAB && $arrayBufferResizable) {
		return !$arrayBufferResizable(arrayBuffer); // step 1
	}
	if (isSAB && $sharedArrayGrowable) {
		return !$sharedArrayGrowable(arrayBuffer); // step 1
	}
	return true; // step 2
};


/***/ }),

/***/ 9762:
/***/ (function(module) {

"use strict";


// https://262.ecma-international.org/6.0/#sec-ispropertykey

module.exports = function IsPropertyKey(argument) {
	return typeof argument === 'string' || typeof argument === 'symbol';
};


/***/ }),

/***/ 9954:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $TypeError = __webpack_require__(1642);

var IsDetachedBuffer = __webpack_require__(1320);
var TypedArrayElementSize = __webpack_require__(9149);

var isTypedArrayWithBufferWitnessRecord = __webpack_require__(359);

var typedArrayBuffer = __webpack_require__(6740);
var typedArrayByteOffset = __webpack_require__(7046);
var typedArrayLength = __webpack_require__(8150);

// https://tc39.es/ecma262/#sec-istypedarrayoutofbounds

module.exports = function IsTypedArrayOutOfBounds(taRecord) {
	if (!isTypedArrayWithBufferWitnessRecord(taRecord)) {
		throw new $TypeError('Assertion failed: `taRecord` must be a TypedArray With Buffer Witness Record');
	}

	var O = taRecord['[[Object]]']; // step 1

	var bufferByteLength = taRecord['[[CachedBufferByteLength]]']; // step 2

	if (IsDetachedBuffer(typedArrayBuffer(O)) && bufferByteLength !== 'DETACHED') {
		throw new $TypeError('Assertion failed: typed array is detached only if the byte length is ~DETACHED~'); // step 3
	}

	if (bufferByteLength === 'DETACHED') {
		return true; // step 4
	}

	var byteOffsetStart = typedArrayByteOffset(O); // step 5

	var byteOffsetEnd;
	var length = typedArrayLength(O);
	// TODO: probably use package for array length
	// seems to apply when TA is backed by a resizable/growable AB
	if (length === 'AUTO') { // step 6
		byteOffsetEnd = bufferByteLength; // step 6.a
	} else {
		var elementSize = TypedArrayElementSize(O); // step 7.a

		byteOffsetEnd = byteOffsetStart + (length * elementSize); // step 7.b
	}

	if (byteOffsetStart > bufferByteLength || byteOffsetEnd > bufferByteLength) {
		return true; // step 8
	}

	// 9. NOTE: 0-length TypedArrays are not considered out-of-bounds.

	return false; // step 10
};


/***/ }),

/***/ 7551:
/***/ (function(module) {

"use strict";


// https://262.ecma-international.org/15.0/#sec-isunsignedelementtype

module.exports = function IsUnsignedElementType(type) {
	return type === 'UINT8'
		|| type === 'UINT8C'
		|| type === 'UINT16'
		|| type === 'UINT32'
		|| type === 'BIGUINT64';
};


/***/ }),

/***/ 6005:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $TypeError = __webpack_require__(1642);

var ArrayBufferByteLength = __webpack_require__(2981);
var IsDetachedBuffer = __webpack_require__(1320);

var isTypedArray = __webpack_require__(2527);
var typedArrayBuffer = __webpack_require__(6740);

// https://tc39.es/ecma262/#sec-maketypedarraywithbufferwitnessrecord

module.exports = function MakeTypedArrayWithBufferWitnessRecord(obj, order) {
	if (!isTypedArray(obj)) {
		throw new $TypeError('Assertion failed: `obj` must be a Typed Array');
	}
	if (order !== 'SEQ-CST' && order !== 'UNORDERED') {
		throw new $TypeError('Assertion failed: `order` must be ~SEQ-CST~ or ~UNORDERED~');
	}

	var buffer = typedArrayBuffer(obj); // step 1

	var byteLength = IsDetachedBuffer(buffer) ? 'DETACHED' : ArrayBufferByteLength(buffer, order); // steps 2 - 3

	return { '[[Object]]': obj, '[[CachedBufferByteLength]]': byteLength }; // step 4
};


/***/ }),

/***/ 4604:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $TypeError = __webpack_require__(1642);

var hasOwnProperty = __webpack_require__(5584);
var ToBigInt64 = __webpack_require__(1242);
var ToBigUint64 = __webpack_require__(2947);
var ToInt16 = __webpack_require__(3181);
var ToInt32 = __webpack_require__(2587);
var ToInt8 = __webpack_require__(5562);
var ToUint16 = __webpack_require__(5465);
var ToUint32 = __webpack_require__(5964);
var ToUint8 = __webpack_require__(9496);
var ToUint8Clamp = __webpack_require__(6550);

var valueToFloat32Bytes = __webpack_require__(3647);
var valueToFloat64Bytes = __webpack_require__(7511);
var integerToNBytes = __webpack_require__(1520);

var keys = __webpack_require__(806);

// https://262.ecma-international.org/15.0/#table-the-typedarray-constructors
var TypeToSizes = {
	__proto__: null,
	INT8: 1,
	UINT8: 1,
	UINT8C: 1,
	INT16: 2,
	UINT16: 2,
	INT32: 4,
	UINT32: 4,
	BIGINT64: 8,
	BIGUINT64: 8,
	FLOAT32: 4,
	FLOAT64: 8
};

var TypeToAO = {
	__proto__: null,
	INT8: ToInt8,
	UINT8: ToUint8,
	UINT8C: ToUint8Clamp,
	INT16: ToInt16,
	UINT16: ToUint16,
	INT32: ToInt32,
	UINT32: ToUint32,
	BIGINT64: ToBigInt64,
	BIGUINT64: ToBigUint64
};

// https://262.ecma-international.org/15.0/#sec-numerictorawbytes

module.exports = function NumericToRawBytes(type, value, isLittleEndian) {
	if (typeof type !== 'string' || !hasOwnProperty(TypeToSizes, type)) {
		throw new $TypeError('Assertion failed: `type` must be a TypedArray element type: ' + keys(TypeToSizes));
	}
	if (typeof value !== 'number' && typeof value !== 'bigint') {
		throw new $TypeError('Assertion failed: `value` must be a Number or a BigInt');
	}
	if (typeof isLittleEndian !== 'boolean') {
		throw new $TypeError('Assertion failed: `isLittleEndian` must be a Boolean');
	}

	if (type === 'FLOAT32') { // step 1
		return valueToFloat32Bytes(value, isLittleEndian);
	} else if (type === 'FLOAT64') { // step 2
		return valueToFloat64Bytes(value, isLittleEndian);
	} // step 3

	var n = TypeToSizes[type]; // step 3.a

	var convOp = TypeToAO[type]; // step 3.b

	var intValue = convOp(value); // step 3.c

	return integerToNBytes(intValue, n, isLittleEndian); // step 3.d, 3.e, 4
};


/***/ }),

/***/ 9219:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);
var callBound = __webpack_require__(1154);

var $RangeError = __webpack_require__(9204);
var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);
var $BigInt = GetIntrinsic('%BigInt%', true);

var hasOwnProperty = __webpack_require__(5584);
var IsArray = __webpack_require__(2985);
var IsBigIntElementType = __webpack_require__(4734);
var IsUnsignedElementType = __webpack_require__(7551);

var bytesAsFloat32 = __webpack_require__(8727);
var bytesAsFloat64 = __webpack_require__(7604);
var bytesAsInteger = __webpack_require__(2367);
var every = __webpack_require__(8172);
var isByteValue = __webpack_require__(1824);

var $reverse = callBound('Array.prototype.reverse');
var $slice = callBound('Array.prototype.slice');

var keys = __webpack_require__(806);

// https://262.ecma-international.org/15.0/#table-the-typedarray-constructors
var TypeToSizes = {
	__proto__: null,
	INT8: 1,
	UINT8: 1,
	UINT8C: 1,
	INT16: 2,
	UINT16: 2,
	INT32: 4,
	UINT32: 4,
	BIGINT64: 8,
	BIGUINT64: 8,
	FLOAT32: 4,
	FLOAT64: 8
};

// https://262.ecma-international.org/15.0/#sec-rawbytestonumeric

module.exports = function RawBytesToNumeric(type, rawBytes, isLittleEndian) {
	if (!hasOwnProperty(TypeToSizes, type)) {
		throw new $TypeError('Assertion failed: `type` must be a TypedArray element type: ' + keys(TypeToSizes));
	}
	if (!IsArray(rawBytes) || !every(rawBytes, isByteValue)) {
		throw new $TypeError('Assertion failed: `rawBytes` must be an Array of bytes');
	}
	if (typeof isLittleEndian !== 'boolean') {
		throw new $TypeError('Assertion failed: `isLittleEndian` must be a Boolean');
	}

	var elementSize = TypeToSizes[type]; // step 1

	if (rawBytes.length !== elementSize) {
		// this assertion is not in the spec, but it'd be an editorial error if it were ever violated
		throw new $RangeError('Assertion failed: `rawBytes` must have a length of ' + elementSize + ' for type ' + type);
	}

	var isBigInt = IsBigIntElementType(type);
	if (isBigInt && !$BigInt) {
		throw new $SyntaxError('this environment does not support BigInts');
	}

	// eslint-disable-next-line no-param-reassign
	rawBytes = $slice(rawBytes, 0, elementSize);
	if (!isLittleEndian) {
		$reverse(rawBytes); // step 2
	}

	if (type === 'FLOAT32') { // step 3
		return bytesAsFloat32(rawBytes);
	}

	if (type === 'FLOAT64') { // step 4
		return bytesAsFloat64(rawBytes);
	}

	return bytesAsInteger(rawBytes, elementSize, IsUnsignedElementType(type), isBigInt);
};


/***/ }),

/***/ 3392:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $isNaN = __webpack_require__(9404);

// http://262.ecma-international.org/5.1/#sec-9.12

module.exports = function SameValue(x, y) {
	if (x === y) { // 0 === -0, but they are not identical.
		if (x === 0) { return 1 / x === 1 / y; }
		return true;
	}
	return $isNaN(x) && $isNaN(y);
};


/***/ }),

/***/ 8055:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $TypeError = __webpack_require__(1642);

var IsPropertyKey = __webpack_require__(9762);
var SameValue = __webpack_require__(3392);
var Type = __webpack_require__(9655);

// IE 9 does not throw in strict mode when writability/configurability/extensibility is violated
var noThrowOnStrictViolation = (function () {
	try {
		delete [].length;
		return true;
	} catch (e) {
		return false;
	}
}());

// https://262.ecma-international.org/6.0/#sec-set-o-p-v-throw

module.exports = function Set(O, P, V, Throw) {
	if (Type(O) !== 'Object') {
		throw new $TypeError('Assertion failed: `O` must be an Object');
	}
	if (!IsPropertyKey(P)) {
		throw new $TypeError('Assertion failed: `P` must be a Property Key');
	}
	if (typeof Throw !== 'boolean') {
		throw new $TypeError('Assertion failed: `Throw` must be a Boolean');
	}
	if (Throw) {
		O[P] = V; // eslint-disable-line no-param-reassign
		if (noThrowOnStrictViolation && !SameValue(O[P], V)) {
			throw new $TypeError('Attempted to assign to readonly property.');
		}
		return true;
	}
	try {
		O[P] = V; // eslint-disable-line no-param-reassign
		return noThrowOnStrictViolation ? SameValue(O[P], V) : true;
	} catch (e) {
		return false;
	}

};


/***/ }),

/***/ 3383:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);
var $Uint8Array = GetIntrinsic('%Uint8Array%', true);

var isInteger = __webpack_require__(6156);

var IsBigIntElementType = __webpack_require__(4734);
var IsDetachedBuffer = __webpack_require__(1320);
var NumericToRawBytes = __webpack_require__(4604);

var isArrayBuffer = __webpack_require__(4602);
var isSharedArrayBuffer = __webpack_require__(5604);
var has = __webpack_require__(9429);

var tableTAO = __webpack_require__(2170);

var defaultEndianness = __webpack_require__(2142);
var forEach = __webpack_require__(9065);

// https://262.ecma-international.org/15.0/#sec-setvalueinbuffer

/* eslint max-params: 0 */

module.exports = function SetValueInBuffer(arrayBuffer, byteIndex, type, value, isTypedArray, order) {
	var isSAB = isSharedArrayBuffer(arrayBuffer);
	if (!isArrayBuffer(arrayBuffer) && !isSAB) {
		throw new $TypeError('Assertion failed: `arrayBuffer` must be an ArrayBuffer or a SharedArrayBuffer');
	}

	if (!isInteger(byteIndex) || byteIndex < 0) {
		throw new $TypeError('Assertion failed: `byteIndex` must be a non-negative integer');
	}

	if (typeof type !== 'string' || !has(tableTAO.size, '$' + type)) {
		throw new $TypeError('Assertion failed: `type` must be a Typed Array Element Type');
	}

	if (typeof value !== 'number' && typeof value !== 'bigint') {
		throw new $TypeError('Assertion failed: `value` must be a Number or a BigInt');
	}

	if (typeof isTypedArray !== 'boolean') {
		throw new $TypeError('Assertion failed: `isTypedArray` must be a boolean');
	}
	if (order !== 'SEQ-CST' && order !== 'UNORDERED' && order !== 'INIT') {
		throw new $TypeError('Assertion failed: `order` must be `"SEQ-CST"`, `"UNORDERED"`, or `"INIT"`');
	}

	if (arguments.length > 6 && typeof arguments[6] !== 'boolean') {
		throw new $TypeError('Assertion failed: `isLittleEndian` must be a boolean, if present');
	}

	if (IsDetachedBuffer(arrayBuffer)) {
		throw new $TypeError('Assertion failed: ArrayBuffer is detached'); // step 1
	}

	// 2. Assert: There are sufficient bytes in arrayBuffer starting at byteIndex to represent a value of type.

	if (IsBigIntElementType(type) ? typeof value !== 'bigint' : typeof value !== 'number') { // step 3
		throw new $TypeError('Assertion failed: `value` must be a BigInt if type is ~BIGINT64~ or ~BIGUINT64~, otherwise a Number');
	}

	// 4. Let block be arrayBuffer’s [[ArrayBufferData]] internal slot.

	var elementSize = tableTAO.size['$' + type]; // step 5

	// 6. If isLittleEndian is not present, set isLittleEndian to either true or false. The choice is implementation dependent and should be the alternative that is most efficient for the implementation. An implementation must use the same value each time this step is executed and the same value must be used for the corresponding step in the GetValueFromBuffer abstract operation.
	var isLittleEndian = arguments.length > 6 ? arguments[6] : defaultEndianness === 'little'; // step 6

	var rawBytes = NumericToRawBytes(type, value, isLittleEndian); // step 7

	if (isSAB) { // step 8
		/*
			Let execution be the [[CandidateExecution]] field of the surrounding agent's Agent Record.
			Let eventList be the [[EventList]] field of the element in execution.[[EventsRecords]] whose [[AgentSignifier]] is AgentSignifier().
			If isTypedArray is true and IsNoTearConfiguration(type, order) is true, let noTear be true; otherwise let noTear be false.
			Append WriteSharedMemory { [[Order]]: order, [[NoTear]]: noTear, [[Block]]: block, [[ByteIndex]]: byteIndex, [[ElementSize]]: elementSize, [[Payload]]: rawBytes } to eventList.
		*/
		throw new $SyntaxError('SharedArrayBuffer is not supported by this implementation');
	} else {
		// 9. Store the individual bytes of rawBytes into block, in order, starting at block[byteIndex].
		var arr = new $Uint8Array(arrayBuffer, byteIndex, elementSize);
		forEach(rawBytes, function (rawByte, i) {
			arr[i] = rawByte;
		});
	}

	// 10. Return NormalCompletion(undefined).
};


/***/ }),

/***/ 5994:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $species = GetIntrinsic('%Symbol.species%', true);
var $TypeError = __webpack_require__(1642);

var IsConstructor = __webpack_require__(7010);
var Type = __webpack_require__(9655);

// https://262.ecma-international.org/6.0/#sec-speciesconstructor

module.exports = function SpeciesConstructor(O, defaultConstructor) {
	if (Type(O) !== 'Object') {
		throw new $TypeError('Assertion failed: Type(O) is not Object');
	}
	var C = O.constructor;
	if (typeof C === 'undefined') {
		return defaultConstructor;
	}
	if (Type(C) !== 'Object') {
		throw new $TypeError('O.constructor is not an Object');
	}
	var S = $species ? C[$species] : void 0;
	if (S == null) {
		return defaultConstructor;
	}
	if (IsConstructor(S)) {
		return S;
	}
	throw new $TypeError('no constructor found');
};


/***/ }),

/***/ 907:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $BigInt = GetIntrinsic('%BigInt%', true);
var $TypeError = __webpack_require__(1642);
var $SyntaxError = __webpack_require__(6724);

// https://262.ecma-international.org/14.0/#sec-stringtobigint

module.exports = function StringToBigInt(argument) {
	if (typeof argument !== 'string') {
		throw new $TypeError('`argument` must be a string');
	}
	if (!$BigInt) {
		throw new $SyntaxError('BigInts are not supported in this environment');
	}
	try {
		return $BigInt(argument);
	} catch (e) {
		return void undefined;
	}
};


/***/ }),

/***/ 4967:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $Number = GetIntrinsic('%Number%');
var $RegExp = GetIntrinsic('%RegExp%');
var $TypeError = __webpack_require__(1642);
var $parseInteger = GetIntrinsic('%parseInt%');

var callBound = __webpack_require__(1154);
var regexTester = __webpack_require__(1312);

var $strSlice = callBound('String.prototype.slice');
var isBinary = regexTester(/^0b[01]+$/i);
var isOctal = regexTester(/^0o[0-7]+$/i);
var isInvalidHexLiteral = regexTester(/^[-+]0x[0-9a-f]+$/i);
var nonWS = ['\u0085', '\u200b', '\ufffe'].join('');
var nonWSregex = new $RegExp('[' + nonWS + ']', 'g');
var hasNonWS = regexTester(nonWSregex);

var $trim = __webpack_require__(4113);

// https://262.ecma-international.org/13.0/#sec-stringtonumber

module.exports = function StringToNumber(argument) {
	if (typeof argument !== 'string') {
		throw new $TypeError('Assertion failed: `argument` is not a String');
	}
	if (isBinary(argument)) {
		return $Number($parseInteger($strSlice(argument, 2), 2));
	}
	if (isOctal(argument)) {
		return $Number($parseInteger($strSlice(argument, 2), 8));
	}
	if (hasNonWS(argument) || isInvalidHexLiteral(argument)) {
		return NaN;
	}
	var trimmed = $trim(argument);
	if (trimmed !== argument) {
		return StringToNumber(trimmed);
	}
	return $Number(argument);
};


/***/ }),

/***/ 9752:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $BigInt = GetIntrinsic('%BigInt%', true);
var $Number = GetIntrinsic('%Number%');
var $TypeError = __webpack_require__(1642);
var $SyntaxError = __webpack_require__(6724);

var StringToBigInt = __webpack_require__(907);
var ToPrimitive = __webpack_require__(210);

// https://262.ecma-international.org/13.0/#sec-tobigint

module.exports = function ToBigInt(argument) {
	if (!$BigInt) {
		throw new $SyntaxError('BigInts are not supported in this environment');
	}

	var prim = ToPrimitive(argument, $Number);

	if (prim == null) {
		throw new $TypeError('Cannot convert null or undefined to a BigInt');
	}

	if (typeof prim === 'boolean') {
		return prim ? $BigInt(1) : $BigInt(0);
	}

	if (typeof prim === 'number') {
		throw new $TypeError('Cannot convert a Number value to a BigInt');
	}

	if (typeof prim === 'string') {
		var n = StringToBigInt(prim);
		if (typeof n === 'undefined') {
			throw new $TypeError('Failed to parse String to BigInt');
		}
		return n;
	}

	if (typeof prim === 'symbol') {
		throw new $TypeError('Cannot convert a Symbol value to a BigInt');
	}

	if (typeof prim !== 'bigint') {
		throw new $SyntaxError('Assertion failed: unknown primitive type');
	}

	return prim;
};


/***/ }),

/***/ 1242:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $BigInt = GetIntrinsic('%BigInt%', true);
var $pow = GetIntrinsic('%Math.pow%');

var ToBigInt = __webpack_require__(9752);
var BigIntRemainder = __webpack_require__(6548);

var modBigInt = __webpack_require__(8626);

// BigInt(2**63), but node v10.4-v10.8 have a bug where you can't `BigInt(x)` anything larger than MAX_SAFE_INTEGER
var twoSixtyThree = $BigInt && (BigInt($pow(2, 32)) * BigInt($pow(2, 31)));

// BigInt(2**64), but node v10.4-v10.8 have a bug where you can't `BigInt(x)` anything larger than MAX_SAFE_INTEGER
var twoSixtyFour = $BigInt && (BigInt($pow(2, 32)) * BigInt($pow(2, 32)));

// https://262.ecma-international.org/11.0/#sec-tobigint64

module.exports = function ToBigInt64(argument) {
	var n = ToBigInt(argument);
	var int64bit = modBigInt(BigIntRemainder, n, twoSixtyFour);
	return int64bit >= twoSixtyThree ? int64bit - twoSixtyFour : int64bit;
};


/***/ }),

/***/ 2947:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $BigInt = GetIntrinsic('%BigInt%', true);
var $pow = GetIntrinsic('%Math.pow%');

var ToBigInt = __webpack_require__(9752);
var BigIntRemainder = __webpack_require__(6548);

var modBigInt = __webpack_require__(8626);

// BigInt(2**64), but node v10.4-v10.8 have a bug where you can't `BigInt(x)` anything larger than MAX_SAFE_INTEGER
var twoSixtyFour = $BigInt && (BigInt($pow(2, 32)) * BigInt($pow(2, 32)));

// https://262.ecma-international.org/11.0/#sec-tobiguint64

module.exports = function ToBigUint64(argument) {
	var n = ToBigInt(argument);
	var int64bit = modBigInt(BigIntRemainder, n, twoSixtyFour);
	return int64bit;
};


/***/ }),

/***/ 6440:
/***/ (function(module) {

"use strict";


// http://262.ecma-international.org/5.1/#sec-9.2

module.exports = function ToBoolean(value) { return !!value; };


/***/ }),

/***/ 3181:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var modulo = __webpack_require__(8457);
var ToNumber = __webpack_require__(3438);
var truncate = __webpack_require__(736);

var isFinite = __webpack_require__(7991);

// https://262.ecma-international.org/14.0/#sec-toint16

var two16 = 0x10000; // Math.pow(2, 16);

module.exports = function ToInt16(argument) {
	var number = ToNumber(argument);
	if (!isFinite(number) || number === 0) {
		return 0;
	}
	var int = truncate(number);
	var int16bit = modulo(int, two16);
	return int16bit >= 0x8000 ? int16bit - two16 : int16bit;
};


/***/ }),

/***/ 2587:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var modulo = __webpack_require__(8457);
var ToNumber = __webpack_require__(3438);
var truncate = __webpack_require__(736);

var isFinite = __webpack_require__(7991);

// https://262.ecma-international.org/14.0/#sec-toint32

var two31 = 0x80000000; // Math.pow(2, 31);
var two32 = 0x100000000; // Math.pow(2, 32);

module.exports = function ToInt32(argument) {
	var number = ToNumber(argument);
	if (!isFinite(number) || number === 0) {
		return 0;
	}
	var int = truncate(number);
	var int32bit = modulo(int, two32);
	var result = int32bit >= two31 ? int32bit - two32 : int32bit;
	return result === 0 ? 0 : result; // in the spec, these are math values, so we filter out -0 here
};


/***/ }),

/***/ 5562:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var modulo = __webpack_require__(8457);
var ToNumber = __webpack_require__(3438);
var truncate = __webpack_require__(736);

var isFinite = __webpack_require__(7991);

// https://262.ecma-international.org/14.0/#sec-toint8

module.exports = function ToInt8(argument) {
	var number = ToNumber(argument);
	if (!isFinite(number) || number === 0) {
		return 0;
	}
	var int = truncate(number);
	var int8bit = modulo(int, 0x100);
	return int8bit >= 0x80 ? int8bit - 0x100 : int8bit;
};


/***/ }),

/***/ 2897:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var ToNumber = __webpack_require__(3438);
var truncate = __webpack_require__(736);

var $isNaN = __webpack_require__(9404);
var $isFinite = __webpack_require__(7991);

// https://262.ecma-international.org/14.0/#sec-tointegerorinfinity

module.exports = function ToIntegerOrInfinity(value) {
	var number = ToNumber(value);
	if ($isNaN(number) || number === 0) { return 0; }
	if (!$isFinite(number)) { return number; }
	return truncate(number);
};


/***/ }),

/***/ 3438:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $TypeError = __webpack_require__(1642);
var $Number = GetIntrinsic('%Number%');
var isPrimitive = __webpack_require__(4968);

var ToPrimitive = __webpack_require__(210);
var StringToNumber = __webpack_require__(4967);

// https://262.ecma-international.org/13.0/#sec-tonumber

module.exports = function ToNumber(argument) {
	var value = isPrimitive(argument) ? argument : ToPrimitive(argument, $Number);
	if (typeof value === 'symbol') {
		throw new $TypeError('Cannot convert a Symbol value to a number');
	}
	if (typeof value === 'bigint') {
		throw new $TypeError('Conversion from \'BigInt\' to \'number\' is not allowed.');
	}
	if (typeof value === 'string') {
		return StringToNumber(value);
	}
	return $Number(value);
};


/***/ }),

/***/ 210:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var toPrimitive = __webpack_require__(5249);

// https://262.ecma-international.org/6.0/#sec-toprimitive

module.exports = function ToPrimitive(input) {
	if (arguments.length > 1) {
		return toPrimitive(input, arguments[1]);
	}
	return toPrimitive(input);
};


/***/ }),

/***/ 8110:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var hasOwn = __webpack_require__(9429);

var $TypeError = __webpack_require__(1642);

var Type = __webpack_require__(9655);
var ToBoolean = __webpack_require__(6440);
var IsCallable = __webpack_require__(3071);

// https://262.ecma-international.org/5.1/#sec-8.10.5

module.exports = function ToPropertyDescriptor(Obj) {
	if (Type(Obj) !== 'Object') {
		throw new $TypeError('ToPropertyDescriptor requires an object');
	}

	var desc = {};
	if (hasOwn(Obj, 'enumerable')) {
		desc['[[Enumerable]]'] = ToBoolean(Obj.enumerable);
	}
	if (hasOwn(Obj, 'configurable')) {
		desc['[[Configurable]]'] = ToBoolean(Obj.configurable);
	}
	if (hasOwn(Obj, 'value')) {
		desc['[[Value]]'] = Obj.value;
	}
	if (hasOwn(Obj, 'writable')) {
		desc['[[Writable]]'] = ToBoolean(Obj.writable);
	}
	if (hasOwn(Obj, 'get')) {
		var getter = Obj.get;
		if (typeof getter !== 'undefined' && !IsCallable(getter)) {
			throw new $TypeError('getter must be a function');
		}
		desc['[[Get]]'] = getter;
	}
	if (hasOwn(Obj, 'set')) {
		var setter = Obj.set;
		if (typeof setter !== 'undefined' && !IsCallable(setter)) {
			throw new $TypeError('setter must be a function');
		}
		desc['[[Set]]'] = setter;
	}

	if ((hasOwn(desc, '[[Get]]') || hasOwn(desc, '[[Set]]')) && (hasOwn(desc, '[[Value]]') || hasOwn(desc, '[[Writable]]'))) {
		throw new $TypeError('Invalid property descriptor. Cannot both specify accessors and a value or writable attribute');
	}
	return desc;
};


/***/ }),

/***/ 7249:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $String = GetIntrinsic('%String%');
var $TypeError = __webpack_require__(1642);

// https://262.ecma-international.org/6.0/#sec-tostring

module.exports = function ToString(argument) {
	if (typeof argument === 'symbol') {
		throw new $TypeError('Cannot convert a Symbol value to a string');
	}
	return $String(argument);
};


/***/ }),

/***/ 5465:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var modulo = __webpack_require__(8457);
var ToNumber = __webpack_require__(3438);
var truncate = __webpack_require__(736);

var isFinite = __webpack_require__(7991);

// https://262.ecma-international.org/14.0/#sec-touint16

var two16 = 0x10000; // Math.pow(2, 16)

module.exports = function ToUint16(argument) {
	var number = ToNumber(argument);
	if (!isFinite(number) || number === 0) {
		return 0;
	}
	var int = truncate(number);
	var int16bit = modulo(int, two16);
	return int16bit === 0 ? 0 : int16bit; // in the spec, these are math values, so we filter out -0 here
};


/***/ }),

/***/ 5964:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var modulo = __webpack_require__(8457);
var ToNumber = __webpack_require__(3438);
var truncate = __webpack_require__(736);

var isFinite = __webpack_require__(7991);

// https://262.ecma-international.org/14.0/#sec-touint32

var two32 = 0x100000000; // Math.pow(2, 32);

module.exports = function ToUint32(argument) {
	var number = ToNumber(argument);
	if (!isFinite(number) || number === 0) {
		return 0;
	}
	var int = truncate(number);
	var int32bit = modulo(int, two32);
	return int32bit === 0 ? 0 : int32bit; // in the spec, these are math values, so we filter out -0 here
};


/***/ }),

/***/ 9496:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var isFinite = __webpack_require__(7991);

var modulo = __webpack_require__(8457);
var ToNumber = __webpack_require__(3438);
var truncate = __webpack_require__(736);

// https://262.ecma-international.org/14.0/#sec-touint8

module.exports = function ToUint8(argument) {
	var number = ToNumber(argument);
	if (!isFinite(number) || number === 0) {
		return 0;
	}
	var int = truncate(number);
	var int8bit = modulo(int, 0x100);
	return int8bit;
};


/***/ }),

/***/ 6550:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var clamp = __webpack_require__(3832);

var ToNumber = __webpack_require__(3438);
var floor = __webpack_require__(3473);

var $isNaN = __webpack_require__(9404);

// https://262.ecma-international.org/15.0/#sec-touint8clamp

module.exports = function ToUint8Clamp(argument) {
	var number = ToNumber(argument); // step 1

	if ($isNaN(number)) { return 0; } // step 2

	var clamped = clamp(number, 0, 255); // step 4

	var f = floor(clamped); // step 5

	if (clamped < (f + 0.5)) { return f; } // step 6

	if (clamped > (f + 0.5)) { return f + 1; } // step 7

	return f % 2 === 0 ? f : f + 1; // step 8
};


/***/ }),

/***/ 9655:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var ES5Type = __webpack_require__(1528);

// https://262.ecma-international.org/11.0/#sec-ecmascript-data-types-and-values

module.exports = function Type(x) {
	if (typeof x === 'symbol') {
		return 'Symbol';
	}
	if (typeof x === 'bigint') {
		return 'BigInt';
	}
	return ES5Type(x);
};


/***/ }),

/***/ 7265:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);

var IsArray = __webpack_require__(2985);
var IsConstructor = __webpack_require__(7010);
var IsTypedArrayOutOfBounds = __webpack_require__(9954);
var TypedArrayLength = __webpack_require__(8921);
var ValidateTypedArray = __webpack_require__(3842);

var availableTypedArrays = __webpack_require__(4343)();

// https://262.ecma-international.org/15.0/#typedarraycreatefromconstructor

module.exports = function TypedArrayCreateFromConstructor(constructor, argumentList) {
	if (!IsConstructor(constructor)) {
		throw new $TypeError('Assertion failed: `constructor` must be a constructor');
	}
	if (!IsArray(argumentList)) {
		throw new $TypeError('Assertion failed: `argumentList` must be a List');
	}
	if (availableTypedArrays.length === 0) {
		throw new $SyntaxError('Assertion failed: Typed Arrays are not supported in this environment');
	}

	// var newTypedArray = Construct(constructor, argumentList); // step 1
	var newTypedArray;
	if (argumentList.length === 0) {
		newTypedArray = new constructor();
	} else if (argumentList.length === 1) {
		newTypedArray = new constructor(argumentList[0]);
	} else if (argumentList.length === 2) {
		newTypedArray = new constructor(argumentList[0], argumentList[1]);
	} else {
		newTypedArray = new constructor(argumentList[0], argumentList[1], argumentList[2]);
	}

	var taRecord = ValidateTypedArray(newTypedArray, 'SEQ-CST'); // step 2

	if (argumentList.length === 1 && typeof argumentList[0] === 'number') { // step 3
		if (IsTypedArrayOutOfBounds(taRecord)) {
			throw new $TypeError('new Typed Array is out of bounds'); // step 3.a
		}
		var length = TypedArrayLength(taRecord); // step 3.b
		if (length < argumentList[0]) {
			throw new $TypeError('`argumentList[0]` must be <= `newTypedArray.length`'); // step 3.c
		}
	}

	return newTypedArray; // step 4
};


/***/ }),

/***/ 9149:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);

var isInteger = __webpack_require__(6156);

var whichTypedArray = __webpack_require__(4010);

// https://262.ecma-international.org/13.0/#sec-typedarrayelementsize

var tableTAO = __webpack_require__(2170);

module.exports = function TypedArrayElementSize(O) {
	var type = whichTypedArray(O);
	if (type === false) {
		throw new $TypeError('Assertion failed: `O` must be a TypedArray');
	}
	var size = tableTAO.size['$' + tableTAO.name['$' + type]];
	if (!isInteger(size) || size < 0) {
		throw new $SyntaxError('Assertion failed: Unknown TypedArray type `' + type + '`');
	}

	return size;
};


/***/ }),

/***/ 1586:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);

var whichTypedArray = __webpack_require__(4010);

// https://262.ecma-international.org/15.0/#sec-typedarrayelementtype

var tableTAO = __webpack_require__(2170);

module.exports = function TypedArrayElementType(O) {
	var type = whichTypedArray(O);
	if (type === false) {
		throw new $TypeError('Assertion failed: `O` must be a TypedArray');
	}
	var result = tableTAO.name['$' + type];
	if (typeof result !== 'string') {
		throw new $SyntaxError('Assertion failed: Unknown TypedArray type `' + type + '`');
	}

	return result;
};


/***/ }),

/***/ 8921:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $TypeError = __webpack_require__(1642);

var floor = __webpack_require__(3473);
var IsFixedLengthArrayBuffer = __webpack_require__(9442);
var IsTypedArrayOutOfBounds = __webpack_require__(9954);
var TypedArrayElementSize = __webpack_require__(9149);

var isTypedArrayWithBufferWitnessRecord = __webpack_require__(359);

var typedArrayBuffer = __webpack_require__(6740);
var typedArrayByteOffset = __webpack_require__(7046);
var typedArrayLength = __webpack_require__(8150);

// http://www.ecma-international.org/ecma-262/15.0/#sec-typedarraylength

module.exports = function TypedArrayLength(taRecord) {
	if (!isTypedArrayWithBufferWitnessRecord(taRecord)) {
		throw new $TypeError('Assertion failed: `taRecord` must be a TypedArray With Buffer Witness Record');
	}

	if (IsTypedArrayOutOfBounds(taRecord)) {
		throw new $TypeError('Assertion failed: `taRecord` is out of bounds'); // step 1
	}

	var O = taRecord['[[Object]]']; // step 2

	var length = typedArrayLength(O);
	if (length !== 'AUTO') {
		return length; // step 3
	}

	if (IsFixedLengthArrayBuffer(typedArrayBuffer(O))) {
		throw new $TypeError('Assertion failed: array buffer is not fixed length'); // step 4
	}

	var byteOffset = typedArrayByteOffset(O); // step 5

	var elementSize = TypedArrayElementSize(O); // step 6

	var byteLength = taRecord['[[CachedBufferByteLength]]']; // step 7

	if (byteLength === 'DETACHED') {
		throw new $TypeError('Assertion failed: typed array is detached'); // step 8
	}

	return floor((byteLength - byteOffset) / elementSize); // step 9
};


/***/ }),

/***/ 817:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $SyntaxError = __webpack_require__(6724);
var $TypeError = __webpack_require__(1642);

var whichTypedArray = __webpack_require__(4010);
var availableTypedArrays = __webpack_require__(4343)();

var IsArray = __webpack_require__(2985);
var SpeciesConstructor = __webpack_require__(5994);
var TypedArrayCreateFromConstructor = __webpack_require__(7265);

var getConstructor = __webpack_require__(9660);

// https://262.ecma-international.org/15.0/#typedarray-species-create

module.exports = function TypedArraySpeciesCreate(exemplar, argumentList) {
	if (availableTypedArrays.length === 0) {
		throw new $SyntaxError('Assertion failed: Typed Arrays are not supported in this environment');
	}

	var kind = whichTypedArray(exemplar);
	if (!kind) {
		throw new $TypeError('Assertion failed: exemplar must be a TypedArray'); // step 1
	}
	if (!IsArray(argumentList)) {
		throw new $TypeError('Assertion failed: `argumentList` must be a List'); // step 1
	}

	var defaultConstructor = getConstructor(kind); // step 2
	if (typeof defaultConstructor !== 'function') {
		throw new $SyntaxError('Assertion failed: `constructor` of `exemplar` (' + kind + ') must exist. Please report this!');
	}
	var constructor = SpeciesConstructor(exemplar, defaultConstructor); // step 3

	return TypedArrayCreateFromConstructor(constructor, argumentList); // step 4
};


/***/ }),

/***/ 3842:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $TypeError = __webpack_require__(1642);

var IsTypedArrayOutOfBounds = __webpack_require__(9954);
var MakeTypedArrayWithBufferWitnessRecord = __webpack_require__(6005);
var Type = __webpack_require__(9655);

var isTypedArray = __webpack_require__(2527);

// https://262.ecma-international.org/15.0/#sec-validatetypedarray

module.exports = function ValidateTypedArray(O, order) {
	if (order !== 'SEQ-CST' && order !== 'UNORDERED') {
		throw new $TypeError('Assertion failed: `order` must be ~SEQ-CST~ or ~UNORDERED~');
	}

	if (Type(O) !== 'Object') {
		throw new $TypeError('Assertion failed: `O` must be an Object'); // step 1
	}
	if (!isTypedArray(O)) {
		throw new $TypeError('Assertion failed: `O` must be a Typed Array'); // steps 1 - 2
	}

	var taRecord = MakeTypedArrayWithBufferWitnessRecord(O, order); // step 3

	if (IsTypedArrayOutOfBounds(taRecord)) {
		throw new $TypeError('`O` must be in-bounds and backed by a non-detached buffer'); // step 4
	}

	return taRecord; // step 5
};


/***/ }),

/***/ 3832:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $TypeError = __webpack_require__(1642);
var max = GetIntrinsic('%Math.max%');
var min = GetIntrinsic('%Math.min%');

// https://262.ecma-international.org/12.0/#clamping

module.exports = function clamp(x, lower, upper) {
	if (typeof x !== 'number' || typeof lower !== 'number' || typeof upper !== 'number' || !(lower <= upper)) {
		throw new $TypeError('Assertion failed: all three arguments must be MVs, and `lower` must be `<= upper`');
	}
	return min(max(lower, x), upper);
};


/***/ }),

/***/ 3473:
/***/ (function(module) {

"use strict";


// var modulo = require('./modulo');
var $floor = Math.floor;

// http://262.ecma-international.org/11.0/#eqn-floor

module.exports = function floor(x) {
	// return x - modulo(x, 1);
	if (typeof x === 'bigint') {
		return x;
	}
	return $floor(x);
};


/***/ }),

/***/ 1367:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

// https://262.ecma-international.org/6.0/#sec-algorithm-conventions

module.exports = GetIntrinsic('%Math.max%');


/***/ }),

/***/ 2967:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

// https://262.ecma-international.org/6.0/#sec-algorithm-conventions

module.exports = GetIntrinsic('%Math.min%');


/***/ }),

/***/ 8457:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var mod = __webpack_require__(2076);

// https://262.ecma-international.org/5.1/#sec-5.2

module.exports = function modulo(x, y) {
	return mod(x, y);
};


/***/ }),

/***/ 2170:
/***/ (function(module) {

"use strict";


// https://262.ecma-international.org/15.0/#table-the-typedarray-constructors

module.exports = {
	__proto__: null,
	name: {
		__proto__: null,
		$Int8Array: 'INT8',
		$Uint8Array: 'UINT8',
		$Uint8ClampedArray: 'UINT8C',
		$Int16Array: 'INT16',
		$Uint16Array: 'UINT16',
		$Int32Array: 'INT32',
		$Uint32Array: 'UINT32',
		$BigInt64Array: 'BIGINT64',
		$BigUint64Array: 'BIGUINT64',
		$Float32Array: 'FLOAT32',
		$Float64Array: 'FLOAT64'
	},
	size: {
		__proto__: null,
		$INT8: 1,
		$UINT8: 1,
		$UINT8C: 1,
		$INT16: 2,
		$UINT16: 2,
		$INT32: 4,
		$UINT32: 4,
		$BIGINT64: 8,
		$BIGUINT64: 8,
		$FLOAT32: 4,
		$FLOAT64: 8
	}
};


/***/ }),

/***/ 736:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var floor = __webpack_require__(3473);

var $TypeError = __webpack_require__(1642);

// https://262.ecma-international.org/14.0/#eqn-truncate

module.exports = function truncate(x) {
	if (typeof x !== 'number' && typeof x !== 'bigint') {
		throw new $TypeError('argument must be a Number or a BigInt');
	}
	var result = x < 0 ? -floor(-x) : floor(x);
	return result === 0 ? 0 : result; // in the spec, these are math values, so we filter out -0 here
};


/***/ }),

/***/ 1528:
/***/ (function(module) {

"use strict";


// https://262.ecma-international.org/5.1/#sec-8

module.exports = function Type(x) {
	if (x === null) {
		return 'Null';
	}
	if (typeof x === 'undefined') {
		return 'Undefined';
	}
	if (typeof x === 'function' || typeof x === 'object') {
		return 'Object';
	}
	if (typeof x === 'number') {
		return 'Number';
	}
	if (typeof x === 'boolean') {
		return 'Boolean';
	}
	if (typeof x === 'string') {
		return 'String';
	}
};


/***/ }),

/***/ 4342:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


// TODO: remove, semver-major

module.exports = __webpack_require__(682);


/***/ }),

/***/ 208:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var hasPropertyDescriptors = __webpack_require__(8198);

var $defineProperty = __webpack_require__(8918);

var hasArrayLengthDefineBug = hasPropertyDescriptors.hasArrayLengthDefineBug();

// eslint-disable-next-line global-require
var isArray = hasArrayLengthDefineBug && __webpack_require__(692);

var callBound = __webpack_require__(1154);

var $isEnumerable = callBound('Object.prototype.propertyIsEnumerable');

// eslint-disable-next-line max-params
module.exports = function DefineOwnProperty(IsDataDescriptor, SameValue, FromPropertyDescriptor, O, P, desc) {
	if (!$defineProperty) {
		if (!IsDataDescriptor(desc)) {
			// ES3 does not support getters/setters
			return false;
		}
		if (!desc['[[Configurable]]'] || !desc['[[Writable]]']) {
			return false;
		}

		// fallback for ES3
		if (P in O && $isEnumerable(O, P) !== !!desc['[[Enumerable]]']) {
			// a non-enumerable existing property
			return false;
		}

		// property does not exist at all, or exists but is enumerable
		var V = desc['[[Value]]'];
		// eslint-disable-next-line no-param-reassign
		O[P] = V; // will use [[Define]]
		return SameValue(O[P], V);
	}
	if (
		hasArrayLengthDefineBug
		&& P === 'length'
		&& '[[Value]]' in desc
		&& isArray(O)
		&& O.length !== desc['[[Value]]']
	) {
		// eslint-disable-next-line no-param-reassign
		O.length = desc['[[Value]]'];
		return O.length === desc['[[Value]]'];
	}

	$defineProperty(O, P, FromPropertyDescriptor(desc));
	return true;
};


/***/ }),

/***/ 692:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $Array = GetIntrinsic('%Array%');

// eslint-disable-next-line global-require
var toStr = !$Array.isArray && __webpack_require__(1154)('Object.prototype.toString');

module.exports = $Array.isArray || function IsArray(argument) {
	return toStr(argument) === '[object Array]';
};


/***/ }),

/***/ 8727:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $pow = GetIntrinsic('%Math.pow%');

module.exports = function bytesAsFloat32(rawBytes) {
	// return new $Float32Array(new $Uint8Array(rawBytes).buffer)[0];

	/*
        Let value be the byte elements of rawBytes concatenated and interpreted as a little-endian bit string encoding of an IEEE 754-2008 binary32 value.
If value is an IEEE 754-2008 binary32 NaN value, return the NaN Number value.
Return the Number value that corresponds to value.
        */
	var sign = rawBytes[3] & 0x80 ? -1 : 1; // Check the sign bit
	var exponent = ((rawBytes[3] & 0x7F) << 1)
		| (rawBytes[2] >> 7); // Combine bits for exponent
	var mantissa = ((rawBytes[2] & 0x7F) << 16)
		| (rawBytes[1] << 8)
		| rawBytes[0]; // Combine bits for mantissa

	if (exponent === 0 && mantissa === 0) {
		return sign === 1 ? 0 : -0;
	}
	if (exponent === 0xFF && mantissa === 0) {
		return sign === 1 ? Infinity : -Infinity;
	}
	if (exponent === 0xFF && mantissa !== 0) {
		return NaN;
	}

	exponent -= 127; // subtract the bias

	if (exponent === -127) {
		return sign * mantissa * $pow(2, -126 - 23);
	}
	return sign * (1 + (mantissa * $pow(2, -23))) * $pow(2, exponent);
};


/***/ }),

/***/ 7604:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $pow = GetIntrinsic('%Math.pow%');

module.exports = function bytesAsFloat64(rawBytes) {
	// return new $Float64Array(new $Uint8Array(rawBytes).buffer)[0];

	/*
    Let value be the byte elements of rawBytes concatenated and interpreted as a little-endian bit string encoding of an IEEE 754-2008 binary64 value.
If value is an IEEE 754-2008 binary64 NaN value, return the NaN Number value.
Return the Number value that corresponds to value.
    */
	var sign = rawBytes[7] & 0x80 ? -1 : 1; // first bit
	var exponent = ((rawBytes[7] & 0x7F) << 4) // 7 bits from index 7
        | ((rawBytes[6] & 0xF0) >> 4); // 4 bits from index 6
	var mantissa = ((rawBytes[6] & 0x0F) * 0x1000000000000) // 4 bits from index 6
        + (rawBytes[5] * 0x10000000000) // 8 bits from index 5
        + (rawBytes[4] * 0x100000000) // 8 bits from index 4
        + (rawBytes[3] * 0x1000000) // 8 bits from index 3
        + (rawBytes[2] * 0x10000) // 8 bits from index 2
        + (rawBytes[1] * 0x100) // 8 bits from index 1
        + rawBytes[0]; // 8 bits from index 0

	if (exponent === 0 && mantissa === 0) {
		return sign * 0;
	}
	if (exponent === 0x7FF && mantissa !== 0) {
		return NaN;
	}
	if (exponent === 0x7FF && mantissa === 0) {
		return sign * Infinity;
	}

	exponent -= 1023; // subtract the bias

	// Handle subnormal numbers
	if (exponent === -1023) {
		return sign * mantissa * 5e-324; // $pow(2, -1022 - 52)
	}

	return sign * (1 + (mantissa / 0x10000000000000)) * $pow(2, exponent);
};


/***/ }),

/***/ 2367:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $pow = GetIntrinsic('%Math.pow%');
var $Number = GetIntrinsic('%Number%');
var $BigInt = GetIntrinsic('%BigInt%', true);

module.exports = function bytesAsInteger(rawBytes, elementSize, isUnsigned, isBigInt) {
	var Z = isBigInt ? $BigInt : $Number;

	// this is common to both branches
	var intValue = Z(0);
	for (var i = 0; i < rawBytes.length; i++) {
		intValue += Z(rawBytes[i] * $pow(2, 8 * i));
	}
	/*
	Let intValue be the byte elements of rawBytes concatenated and interpreted as a bit string encoding of an unsigned little-endian binary number.
	*/

	if (!isUnsigned) { // steps 5-6
		// Let intValue be the byte elements of rawBytes concatenated and interpreted as a bit string encoding of a binary little-endian 2's complement number of bit length elementSize × 8.
		var bitLength = elementSize * 8;

		if (rawBytes[elementSize - 1] & 0x80) {
			intValue -= Z($pow(2, bitLength));
		}
	}

	return intValue; // step 7
};


/***/ }),

/***/ 2142:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $Uint8Array = GetIntrinsic('%Uint8Array%', true);
var $Uint32Array = GetIntrinsic('%Uint32Array%', true);

var typedArrayBuffer = __webpack_require__(6740);

var uInt32 = $Uint32Array && new $Uint32Array([0x12345678]);
var uInt8 = uInt32 && new $Uint8Array(typedArrayBuffer(uInt32));

module.exports = uInt8
	? uInt8[0] === 0x78
		? 'little'
		: uInt8[0] === 0x12
			? 'big'
			: uInt8[0] === 0x34
				? 'mixed' // https://developer.mozilla.org/en-US/docs/Glossary/Endianness
				: 'unknown' // ???
	: 'indeterminate'; // no way to know


/***/ }),

/***/ 8172:
/***/ (function(module) {

"use strict";


module.exports = function every(array, predicate) {
	for (var i = 0; i < array.length; i += 1) {
		if (!predicate(array[i], i, array)) {
			return false;
		}
	}
	return true;
};


/***/ }),

/***/ 9065:
/***/ (function(module) {

"use strict";


module.exports = function forEach(array, callback) {
	for (var i = 0; i < array.length; i += 1) {
		callback(array[i], i, array); // eslint-disable-line callback-return
	}
};


/***/ }),

/***/ 1211:
/***/ (function(module) {

"use strict";


var MAX_ITER = 1075; // 1023+52 (subnormals) => BIAS+NUM_SIGNFICAND_BITS-1
var maxBits = 54; // only 53 bits for fraction

module.exports = function fractionToBitString(x) {
	var str = '';
	if (x === 0) {
		return str;
	}
	var j = MAX_ITER;

	var y;
	// Each time we multiply by 2 and find a ones digit, add a '1'; otherwise, add a '0'..
	for (var i = 0; i < MAX_ITER; i += 1) {
		y = x * 2;
		if (y >= 1) {
			x = y - 1; // eslint-disable-line no-param-reassign
			str += '1';
			if (j === MAX_ITER) {
				j = i; // first 1
			}
		} else {
			x = y; // eslint-disable-line no-param-reassign
			str += '0';
		}
		// Stop when we have no more decimals to process or in the event we found a fraction which cannot be represented in a finite number of bits...
		if (y === 1 || i - j > maxBits) {
			return str;
		}
	}
	return str;
};


/***/ }),

/***/ 2646:
/***/ (function(module) {

"use strict";


module.exports = function fromPropertyDescriptor(Desc) {
	if (typeof Desc === 'undefined') {
		return Desc;
	}
	var obj = {};
	if ('[[Value]]' in Desc) {
		obj.value = Desc['[[Value]]'];
	}
	if ('[[Writable]]' in Desc) {
		obj.writable = !!Desc['[[Writable]]'];
	}
	if ('[[Get]]' in Desc) {
		obj.get = Desc['[[Get]]'];
	}
	if ('[[Set]]' in Desc) {
		obj.set = Desc['[[Set]]'];
	}
	if ('[[Enumerable]]' in Desc) {
		obj.enumerable = !!Desc['[[Enumerable]]'];
	}
	if ('[[Configurable]]' in Desc) {
		obj.configurable = !!Desc['[[Configurable]]'];
	}
	return obj;
};


/***/ }),

/***/ 9495:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var originalGetProto = GetIntrinsic('%Object.getPrototypeOf%', true);

var hasProto = __webpack_require__(1856)();

module.exports = originalGetProto || (
	hasProto
		? function (O) {
			return O.__proto__; // eslint-disable-line no-proto
		}
		: null
);


/***/ }),

/***/ 20:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $floor = GetIntrinsic('%Math.floor%');

// https://runestone.academy/ns/books/published/pythonds/BasicDS/ConvertingDecimalNumberstoBinaryNumbers.html#:~:text=The%20Divide%20by%202%20algorithm,have%20a%20remainder%20of%200

module.exports = function intToBinaryString(x) {
	var str = '';
	var y;

	while (x > 0) {
		y = x / 2;
		x = $floor(y); // eslint-disable-line no-param-reassign
		if (y === x) {
			str = '0' + str;
		} else {
			str = '1' + str;
		}
	}
	return str;
};


/***/ }),

/***/ 1520:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $Number = GetIntrinsic('%Number%');
var $BigInt = GetIntrinsic('%BigInt%', true);

module.exports = function integerToNBytes(intValue, n, isLittleEndian) {
	var Z = typeof intValue === 'bigint' ? $BigInt : $Number;
	/*
	if (intValue >= 0) { // step 3.d
		// Let rawBytes be a List containing the n-byte binary encoding of intValue. If isLittleEndian is false, the bytes are ordered in big endian order. Otherwise, the bytes are ordered in little endian order.
	} else { // step 3.e
		// Let rawBytes be a List containing the n-byte binary 2's complement encoding of intValue. If isLittleEndian is false, the bytes are ordered in big endian order. Otherwise, the bytes are ordered in little endian order.
	}
    */
	if (intValue < 0) {
		intValue >>>= 0; // eslint-disable-line no-param-reassign
	}

	var rawBytes = [];
	for (var i = 0; i < n; i++) {
		rawBytes[isLittleEndian ? i : n - 1 - i] = $Number(intValue & Z(0xFF));
		intValue >>= Z(8); // eslint-disable-line no-param-reassign
	}

	return rawBytes; // step 4
};


/***/ }),

/***/ 1824:
/***/ (function(module) {

"use strict";


module.exports = function isByteValue(value) {
	return typeof value === 'number' && value >= 0 && value <= 255 && (value | 0) === value;
};


/***/ }),

/***/ 7991:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $isNaN = __webpack_require__(9404);

module.exports = function (x) { return (typeof x === 'number' || typeof x === 'bigint') && !$isNaN(x) && x !== Infinity && x !== -Infinity; };


/***/ }),

/***/ 6156:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $abs = GetIntrinsic('%Math.abs%');
var $floor = GetIntrinsic('%Math.floor%');

var $isNaN = __webpack_require__(9404);
var $isFinite = __webpack_require__(7991);

module.exports = function isInteger(argument) {
	if (typeof argument !== 'number' || $isNaN(argument) || !$isFinite(argument)) {
		return false;
	}
	var absValue = $abs(argument);
	return $floor(absValue) === absValue;
};



/***/ }),

/***/ 9404:
/***/ (function(module) {

"use strict";


module.exports = Number.isNaN || function isNaN(a) {
	return a !== a;
};


/***/ }),

/***/ 2745:
/***/ (function(module) {

"use strict";


module.exports = function isNegativeZero(x) {
	return x === 0 && 1 / x === 1 / -0;
};


/***/ }),

/***/ 4968:
/***/ (function(module) {

"use strict";


module.exports = function isPrimitive(value) {
	return value === null || (typeof value !== 'function' && typeof value !== 'object');
};


/***/ }),

/***/ 2076:
/***/ (function(module) {

"use strict";


var $floor = Math.floor;

module.exports = function mod(number, modulo) {
	var remain = number % modulo;
	return $floor(remain >= 0 ? remain : remain + modulo);
};


/***/ }),

/***/ 8626:
/***/ (function(module) {

"use strict";


module.exports = function bigIntMod(BigIntRemainder, bigint, modulo) {
	var remain = BigIntRemainder(bigint, modulo);
	return remain >= 0 ? remain : remain + modulo;
};


/***/ }),

/***/ 6862:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var $TypeError = __webpack_require__(1642);

var hasOwn = __webpack_require__(9429);

var allowed = {
	__proto__: null,
	'[[Configurable]]': true,
	'[[Enumerable]]': true,
	'[[Get]]': true,
	'[[Set]]': true,
	'[[Value]]': true,
	'[[Writable]]': true
};

// https://262.ecma-international.org/6.0/#sec-property-descriptor-specification-type

module.exports = function isPropertyDescriptor(Desc) {
	if (!Desc || typeof Desc !== 'object') {
		return false;
	}

	for (var key in Desc) { // eslint-disable-line
		if (hasOwn(Desc, key) && !allowed[key]) {
			return false;
		}
	}

	var isData = hasOwn(Desc, '[[Value]]') || hasOwn(Desc, '[[Writable]]');
	var IsAccessor = hasOwn(Desc, '[[Get]]') || hasOwn(Desc, '[[Set]]');
	if (isData && IsAccessor) {
		throw new $TypeError('Property Descriptors may not be both accessor and data descriptors');
	}
	return true;
};


/***/ }),

/***/ 359:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var hasOwn = __webpack_require__(9429);
var isTypedArray = __webpack_require__(2527);

var isInteger = __webpack_require__(6156);

module.exports = function isTypedArrayWithBufferWitnessRecord(value) {
	return !!value
		&& typeof value === 'object'
		&& hasOwn(value, '[[Object]]')
		&& hasOwn(value, '[[CachedBufferByteLength]]')
		&& (
			(isInteger(value['[[CachedBufferByteLength]]']) && value['[[CachedBufferByteLength]]'] >= 0)
			|| value['[[CachedBufferByteLength]]'] === 'DETACHED'
		)
		&& isTypedArray(value['[[Object]]']);
};


/***/ }),

/***/ 9660:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var constructors = {
	__proto__: null,
	$Int8Array: GetIntrinsic('%Int8Array%', true),
	$Uint8Array: GetIntrinsic('%Uint8Array%', true),
	$Uint8ClampedArray: GetIntrinsic('%Uint8ClampedArray%', true),
	$Int16Array: GetIntrinsic('%Int16Array%', true),
	$Uint16Array: GetIntrinsic('%Uint16Array%', true),
	$Int32Array: GetIntrinsic('%Int32Array%', true),
	$Uint32Array: GetIntrinsic('%Uint32Array%', true),
	$BigInt64Array: GetIntrinsic('%BigInt64Array%', true),
	$BigUint64Array: GetIntrinsic('%BigUint64Array%', true),
	$Float32Array: GetIntrinsic('%Float32Array%', true),
	$Float64Array: GetIntrinsic('%Float64Array%', true)
};

module.exports = function getConstructor(kind) {
	return constructors['$' + kind];
};


/***/ }),

/***/ 3647:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $abs = GetIntrinsic('%Math.abs%');
var $floor = GetIntrinsic('%Math.floor%');
var $pow = GetIntrinsic('%Math.pow%');

var isFinite = __webpack_require__(7991);
var isNaN = __webpack_require__(9404);
var isNegativeZero = __webpack_require__(2745);

var maxFiniteFloat32 = 3.4028234663852886e+38; // roughly 2 ** 128 - 1

module.exports = function valueToFloat32Bytes(value, isLittleEndian) {
	if (isNaN(value)) {
		return isLittleEndian ? [0, 0, 192, 127] : [127, 192, 0, 0]; // hardcoded
	}

	var leastSig;

	if (value === 0) {
		leastSig = isNegativeZero(value) ? 0x80 : 0;
		return isLittleEndian ? [0, 0, 0, leastSig] : [leastSig, 0, 0, 0];
	}

	if ($abs(value) > maxFiniteFloat32 || !isFinite(value)) {
		leastSig = value < 0 ? 255 : 127;
		return isLittleEndian ? [0, 0, 128, leastSig] : [leastSig, 128, 0, 0];
	}

	var sign = value < 0 ? 1 : 0;
	value = $abs(value); // eslint-disable-line no-param-reassign

	var exponent = 0;
	while (value >= 2) {
		exponent += 1;
		value /= 2; // eslint-disable-line no-param-reassign
	}

	while (value < 1) {
		exponent -= 1;
		value *= 2; // eslint-disable-line no-param-reassign
	}

	var mantissa = value - 1;
	mantissa *= $pow(2, 23) + 0.5;
	mantissa = $floor(mantissa);

	exponent += 127;
	exponent <<= 23;

	var result = (sign << 31)
        | exponent
        | mantissa;

	var byte0 = result & 255;
	result >>= 8;
	var byte1 = result & 255;
	result >>= 8;
	var byte2 = result & 255;
	result >>= 8;
	var byte3 = result & 255;

	if (isLittleEndian) {
		return [byte0, byte1, byte2, byte3];
	}
	return [byte3, byte2, byte1, byte0];
};


/***/ }),

/***/ 7511:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var GetIntrinsic = __webpack_require__(682);

var $parseInt = GetIntrinsic('%parseInt%');
var $abs = GetIntrinsic('%Math.abs%');
var $floor = GetIntrinsic('%Math.floor%');

var callBound = __webpack_require__(1154);

var $strIndexOf = callBound('String.prototype.indexOf');
var $strSlice = callBound('String.prototype.slice');

var fractionToBitString = __webpack_require__(1211);
var intToBinString = __webpack_require__(20);
var isNegativeZero = __webpack_require__(2745);

var float64bias = 1023;

var elevenOnes = '11111111111';
var elevenZeroes = '00000000000';
var fiftyOneZeroes = elevenZeroes + elevenZeroes + elevenZeroes + elevenZeroes + '0000000';

// IEEE 754-1985
module.exports = function valueToFloat64Bytes(value, isLittleEndian) {
	var signBit = value < 0 || isNegativeZero(value) ? '1' : '0';
	var exponentBits;
	var significandBits;

	if (isNaN(value)) {
		exponentBits = elevenOnes;
		significandBits = '1' + fiftyOneZeroes;
	} else if (!isFinite(value)) {
		exponentBits = elevenOnes;
		significandBits = '0' + fiftyOneZeroes;
	} else if (value === 0) {
		exponentBits = elevenZeroes;
		significandBits = '0' + fiftyOneZeroes;
	} else {
		value = $abs(value); // eslint-disable-line no-param-reassign

		// Isolate the integer part (digits before the decimal):
		var integerPart = $floor(value);

		var intBinString = intToBinString(integerPart); // bit string for integer part
		var fracBinString = fractionToBitString(value - integerPart); // bit string for fractional part

		var numberOfBits;
		// find exponent needed to normalize integer+fractional parts
		if (intBinString) {
			exponentBits = intBinString.length - 1; // move the decimal to the left
		} else {
			var first1 = $strIndexOf(fracBinString, '1');
			if (first1 > -1) {
				numberOfBits = first1 + 1;
			}
			exponentBits = -numberOfBits; // move the decimal to the right
		}

		significandBits = intBinString + fracBinString;
		if (exponentBits < 0) {
			// subnormals
			if (exponentBits <= -float64bias) {
				numberOfBits = float64bias - 1; // limit number of removed bits
			}
			significandBits = $strSlice(significandBits, numberOfBits); // remove all leading 0s and the first 1 for normal values; for subnormals, remove up to `float64bias - 1` leading bits
		} else {
			significandBits = $strSlice(significandBits, 1); // remove the leading '1' (implicit/hidden bit)
		}
		exponentBits = $strSlice(elevenZeroes + intToBinString(exponentBits + float64bias), -11); // Convert the exponent to a bit string

		significandBits = $strSlice(significandBits + fiftyOneZeroes + '0', 0, 52); // fill in any trailing zeros and ensure we have only 52 fraction bits
	}

	var bits = signBit + exponentBits + significandBits;
	var rawBytes = [];
	for (var i = 0; i < 8; i++) {
		var targetIndex = isLittleEndian ? 8 - i - 1 : i;
		rawBytes[targetIndex] = $parseInt($strSlice(bits, i * 8, (i + 1) * 8), 2);
	}

	return rawBytes;
};


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	!function() {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = function(module) {
/******/ 			var getter = module && module.__esModule ?
/******/ 				function() { return module['default']; } :
/******/ 				function() { return module; };
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/global */
/******/ 	!function() {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be in strict mode.
!function() {
"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "AlignmentControl": function() { return /* reexport */ AlignmentControl; },
  "AlignmentToolbar": function() { return /* reexport */ AlignmentToolbar; },
  "Autocomplete": function() { return /* reexport */ autocomplete; },
  "BlockAlignmentControl": function() { return /* reexport */ BlockAlignmentControl; },
  "BlockAlignmentToolbar": function() { return /* reexport */ BlockAlignmentToolbar; },
  "BlockBreadcrumb": function() { return /* reexport */ block_breadcrumb; },
  "BlockColorsStyleSelector": function() { return /* reexport */ color_style_selector; },
  "BlockContextProvider": function() { return /* reexport */ BlockContextProvider; },
  "BlockControls": function() { return /* reexport */ block_controls; },
  "BlockEdit": function() { return /* reexport */ BlockEdit; },
  "BlockEditorKeyboardShortcuts": function() { return /* reexport */ keyboard_shortcuts; },
  "BlockEditorProvider": function() { return /* reexport */ provider; },
  "BlockFormatControls": function() { return /* reexport */ BlockFormatControls; },
  "BlockIcon": function() { return /* reexport */ block_icon; },
  "BlockInspector": function() { return /* reexport */ block_inspector; },
  "BlockList": function() { return /* reexport */ BlockList; },
  "BlockMover": function() { return /* reexport */ block_mover; },
  "BlockNavigationDropdown": function() { return /* reexport */ dropdown; },
  "BlockPreview": function() { return /* reexport */ block_preview; },
  "BlockSelectionClearer": function() { return /* reexport */ BlockSelectionClearer; },
  "BlockSettingsMenu": function() { return /* reexport */ block_settings_menu; },
  "BlockSettingsMenuControls": function() { return /* reexport */ block_settings_menu_controls; },
  "BlockStyles": function() { return /* reexport */ block_styles; },
  "BlockTitle": function() { return /* reexport */ BlockTitle; },
  "BlockToolbar": function() { return /* reexport */ block_toolbar; },
  "BlockTools": function() { return /* reexport */ BlockTools; },
  "BlockVerticalAlignmentControl": function() { return /* reexport */ BlockVerticalAlignmentControl; },
  "BlockVerticalAlignmentToolbar": function() { return /* reexport */ BlockVerticalAlignmentToolbar; },
  "ButtonBlockAppender": function() { return /* reexport */ button_block_appender; },
  "ButtonBlockerAppender": function() { return /* reexport */ ButtonBlockerAppender; },
  "ColorPalette": function() { return /* reexport */ color_palette; },
  "ColorPaletteControl": function() { return /* reexport */ ColorPaletteControl; },
  "ContrastChecker": function() { return /* reexport */ contrast_checker; },
  "CopyHandler": function() { return /* reexport */ copy_handler; },
  "DefaultBlockAppender": function() { return /* reexport */ default_block_appender; },
  "FontSizePicker": function() { return /* reexport */ font_size_picker; },
  "HeightControl": function() { return /* reexport */ HeightControl; },
  "InnerBlocks": function() { return /* reexport */ inner_blocks; },
  "Inserter": function() { return /* reexport */ inserter; },
  "InspectorAdvancedControls": function() { return /* reexport */ InspectorAdvancedControls; },
  "InspectorControls": function() { return /* reexport */ inspector_controls; },
  "JustifyContentControl": function() { return /* reexport */ JustifyContentControl; },
  "JustifyToolbar": function() { return /* reexport */ JustifyToolbar; },
  "LineHeightControl": function() { return /* reexport */ line_height_control; },
  "MediaPlaceholder": function() { return /* reexport */ media_placeholder; },
  "MediaReplaceFlow": function() { return /* reexport */ media_replace_flow; },
  "MediaUpload": function() { return /* reexport */ media_upload; },
  "MediaUploadCheck": function() { return /* reexport */ check; },
  "MultiSelectScrollIntoView": function() { return /* reexport */ MultiSelectScrollIntoView; },
  "NavigableToolbar": function() { return /* reexport */ navigable_toolbar; },
  "ObserveTyping": function() { return /* reexport */ observe_typing; },
  "PanelColorSettings": function() { return /* reexport */ panel_color_settings; },
  "PlainText": function() { return /* reexport */ plain_text; },
  "RichText": function() { return /* reexport */ rich_text; },
  "RichTextShortcut": function() { return /* reexport */ RichTextShortcut; },
  "RichTextToolbarButton": function() { return /* reexport */ RichTextToolbarButton; },
  "SETTINGS_DEFAULTS": function() { return /* reexport */ SETTINGS_DEFAULTS; },
  "SkipToSelectedBlock": function() { return /* reexport */ skip_to_selected_block; },
  "ToolSelector": function() { return /* reexport */ tool_selector; },
  "Typewriter": function() { return /* reexport */ typewriter; },
  "URLInput": function() { return /* reexport */ url_input; },
  "URLInputButton": function() { return /* reexport */ url_input_button; },
  "URLPopover": function() { return /* reexport */ url_popover; },
  "Warning": function() { return /* reexport */ warning; },
  "WritingFlow": function() { return /* reexport */ writing_flow; },
  "__experimentalBlockAlignmentMatrixControl": function() { return /* reexport */ block_alignment_matrix_control; },
  "__experimentalBlockFullHeightAligmentControl": function() { return /* reexport */ block_full_height_alignment_control; },
  "__experimentalBlockPatternSetup": function() { return /* reexport */ block_pattern_setup; },
  "__experimentalBlockPatternsList": function() { return /* reexport */ block_patterns_list; },
  "__experimentalBlockVariationPicker": function() { return /* reexport */ block_variation_picker; },
  "__experimentalBlockVariationTransforms": function() { return /* reexport */ block_variation_transforms; },
  "__experimentalBorderRadiusControl": function() { return /* reexport */ BorderRadiusControl; },
  "__experimentalColorGradientControl": function() { return /* reexport */ control; },
  "__experimentalColorGradientSettingsDropdown": function() { return /* reexport */ ColorGradientSettingsDropdown; },
  "__experimentalDateFormatPicker": function() { return /* reexport */ DateFormatPicker; },
  "__experimentalDuotoneControl": function() { return /* reexport */ duotone_control; },
  "__experimentalFontAppearanceControl": function() { return /* reexport */ FontAppearanceControl; },
  "__experimentalFontFamilyControl": function() { return /* reexport */ FontFamilyControl; },
  "__experimentalGetBorderClassesAndStyles": function() { return /* reexport */ getBorderClassesAndStyles; },
  "__experimentalGetColorClassesAndStyles": function() { return /* reexport */ getColorClassesAndStyles; },
  "__experimentalGetElementClassName": function() { return /* reexport */ __experimentalGetElementClassName; },
  "__experimentalGetGapCSSValue": function() { return /* reexport */ getGapCSSValue; },
  "__experimentalGetGradientClass": function() { return /* reexport */ __experimentalGetGradientClass; },
  "__experimentalGetGradientObjectByGradientValue": function() { return /* reexport */ __experimentalGetGradientObjectByGradientValue; },
  "__experimentalGetMatchingVariation": function() { return /* reexport */ __experimentalGetMatchingVariation; },
  "__experimentalGetSpacingClassesAndStyles": function() { return /* reexport */ getSpacingClassesAndStyles; },
  "__experimentalImageEditor": function() { return /* reexport */ ImageEditor; },
  "__experimentalImageSizeControl": function() { return /* reexport */ ImageSizeControl; },
  "__experimentalImageURLInputUI": function() { return /* reexport */ ImageURLInputUI; },
  "__experimentalInspectorPopoverHeader": function() { return /* reexport */ InspectorPopoverHeader; },
  "__experimentalLayoutStyle": function() { return /* reexport */ LayoutStyle; },
  "__experimentalLetterSpacingControl": function() { return /* reexport */ LetterSpacingControl; },
  "__experimentalLibrary": function() { return /* reexport */ library; },
  "__experimentalLinkControl": function() { return /* reexport */ link_control; },
  "__experimentalLinkControlSearchInput": function() { return /* reexport */ search_input; },
  "__experimentalLinkControlSearchItem": function() { return /* reexport */ search_item; },
  "__experimentalLinkControlSearchResults": function() { return /* reexport */ LinkControlSearchResults; },
  "__experimentalListView": function() { return /* reexport */ components_list_view; },
  "__experimentalPanelColorGradientSettings": function() { return /* reexport */ panel_color_gradient_settings; },
  "__experimentalPreviewOptions": function() { return /* reexport */ PreviewOptions; },
  "__experimentalPublishDateTimePicker": function() { return /* reexport */ publish_date_time_picker; },
  "__experimentalRecursionProvider": function() { return /* reexport */ RecursionProvider; },
  "__experimentalResponsiveBlockControl": function() { return /* reexport */ responsive_block_control; },
  "__experimentalSpacingSizesControl": function() { return /* reexport */ SpacingSizesControl; },
  "__experimentalTextDecorationControl": function() { return /* reexport */ TextDecorationControl; },
  "__experimentalTextTransformControl": function() { return /* reexport */ TextTransformControl; },
  "__experimentalUnitControl": function() { return /* reexport */ UnitControl; },
  "__experimentalUseBlockOverlayActive": function() { return /* reexport */ useBlockOverlayActive; },
  "__experimentalUseBlockPreview": function() { return /* reexport */ useBlockPreview; },
  "__experimentalUseBorderProps": function() { return /* reexport */ useBorderProps; },
  "__experimentalUseColorProps": function() { return /* reexport */ useColorProps; },
  "__experimentalUseCustomSides": function() { return /* reexport */ useCustomSides; },
  "__experimentalUseGradient": function() { return /* reexport */ __experimentalUseGradient; },
  "__experimentalUseHasRecursion": function() { return /* reexport */ useHasRecursion; },
  "__experimentalUseMultipleOriginColorsAndGradients": function() { return /* reexport */ useMultipleOriginColorsAndGradients; },
  "__experimentalUseResizeCanvas": function() { return /* reexport */ useResizeCanvas; },
  "__experimentaluseLayoutClasses": function() { return /* reexport */ useLayoutClasses; },
  "__experimentaluseLayoutStyles": function() { return /* reexport */ useLayoutStyles; },
  "__unstableBlockNameContext": function() { return /* reexport */ block_name_context; },
  "__unstableBlockSettingsMenuFirstItem": function() { return /* reexport */ block_settings_menu_first_item; },
  "__unstableBlockToolbarLastItem": function() { return /* reexport */ block_toolbar_last_item; },
  "__unstableDuotoneFilter": function() { return /* reexport */ DuotoneFilter; },
  "__unstableDuotoneStylesheet": function() { return /* reexport */ DuotoneStylesheet; },
  "__unstableDuotoneUnsetStylesheet": function() { return /* reexport */ DuotoneUnsetStylesheet; },
  "__unstableEditorStyles": function() { return /* reexport */ EditorStyles; },
  "__unstableGetValuesFromColors": function() { return /* reexport */ getValuesFromColors; },
  "__unstableIframe": function() { return /* reexport */ iframe; },
  "__unstableInserterMenuExtension": function() { return /* reexport */ inserter_menu_extension; },
  "__unstablePresetDuotoneFilter": function() { return /* reexport */ PresetDuotoneFilter; },
  "__unstableRichTextInputEvent": function() { return /* reexport */ __unstableRichTextInputEvent; },
  "__unstableUseBlockSelectionClearer": function() { return /* reexport */ useBlockSelectionClearer; },
  "__unstableUseClipboardHandler": function() { return /* reexport */ useClipboardHandler; },
  "__unstableUseMouseMoveTypingReset": function() { return /* reexport */ useMouseMoveTypingReset; },
  "__unstableUseTypewriter": function() { return /* reexport */ useTypewriter; },
  "__unstableUseTypingObserver": function() { return /* reexport */ useTypingObserver; },
  "createCustomColorsHOC": function() { return /* reexport */ createCustomColorsHOC; },
  "getColorClassName": function() { return /* reexport */ getColorClassName; },
  "getColorObjectByAttributeValues": function() { return /* reexport */ getColorObjectByAttributeValues; },
  "getColorObjectByColorValue": function() { return /* reexport */ getColorObjectByColorValue; },
  "getComputedFluidTypographyValue": function() { return /* reexport */ getComputedFluidTypographyValue; },
  "getFontSize": function() { return /* reexport */ getFontSize; },
  "getFontSizeClass": function() { return /* reexport */ getFontSizeClass; },
  "getFontSizeObjectByValue": function() { return /* reexport */ getFontSizeObjectByValue; },
  "getGradientSlugByValue": function() { return /* reexport */ getGradientSlugByValue; },
  "getGradientValueBySlug": function() { return /* reexport */ getGradientValueBySlug; },
  "getPxFromCssUnit": function() { return /* reexport */ parse_css_unit_to_px; },
  "getTypographyClassesAndStyles": function() { return /* reexport */ getTypographyClassesAndStyles; },
  "privateApis": function() { return /* reexport */ privateApis; },
  "store": function() { return /* reexport */ store; },
  "storeConfig": function() { return /* reexport */ storeConfig; },
  "transformStyles": function() { return /* reexport */ transform_styles; },
  "useBlockDisplayInformation": function() { return /* reexport */ useBlockDisplayInformation; },
  "useBlockEditContext": function() { return /* reexport */ useBlockEditContext; },
  "useBlockProps": function() { return /* reexport */ useBlockProps; },
  "useCachedTruthy": function() { return /* reexport */ useCachedTruthy; },
  "useInnerBlocksProps": function() { return /* reexport */ useInnerBlocksProps; },
  "useSetting": function() { return /* reexport */ useSetting; },
  "withColorContext": function() { return /* reexport */ with_color_context; },
  "withColors": function() { return /* reexport */ withColors; },
  "withFontSizes": function() { return /* reexport */ with_font_sizes; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-editor/build-module/store/selectors.js
var selectors_namespaceObject = {};
__webpack_require__.r(selectors_namespaceObject);
__webpack_require__.d(selectors_namespaceObject, {
  "__experimentalGetActiveBlockIdByBlockNames": function() { return __experimentalGetActiveBlockIdByBlockNames; },
  "__experimentalGetAllowedBlocks": function() { return __experimentalGetAllowedBlocks; },
  "__experimentalGetAllowedPatterns": function() { return __experimentalGetAllowedPatterns; },
  "__experimentalGetBlockListSettingsForBlocks": function() { return __experimentalGetBlockListSettingsForBlocks; },
  "__experimentalGetDirectInsertBlock": function() { return __experimentalGetDirectInsertBlock; },
  "__experimentalGetGlobalBlocksByName": function() { return __experimentalGetGlobalBlocksByName; },
  "__experimentalGetLastBlockAttributeChanges": function() { return __experimentalGetLastBlockAttributeChanges; },
  "__experimentalGetParsedPattern": function() { return __experimentalGetParsedPattern; },
  "__experimentalGetPatternTransformItems": function() { return __experimentalGetPatternTransformItems; },
  "__experimentalGetPatternsByBlockTypes": function() { return __experimentalGetPatternsByBlockTypes; },
  "__experimentalGetReusableBlockTitle": function() { return __experimentalGetReusableBlockTitle; },
  "__unstableGetBlockWithoutInnerBlocks": function() { return __unstableGetBlockWithoutInnerBlocks; },
  "__unstableGetClientIdWithClientIdsTree": function() { return __unstableGetClientIdWithClientIdsTree; },
  "__unstableGetClientIdsTree": function() { return __unstableGetClientIdsTree; },
  "__unstableGetContentLockingParent": function() { return __unstableGetContentLockingParent; },
  "__unstableGetEditorMode": function() { return __unstableGetEditorMode; },
  "__unstableGetSelectedBlocksWithPartialSelection": function() { return __unstableGetSelectedBlocksWithPartialSelection; },
  "__unstableGetTemporarilyEditingAsBlocks": function() { return __unstableGetTemporarilyEditingAsBlocks; },
  "__unstableGetVisibleBlocks": function() { return __unstableGetVisibleBlocks; },
  "__unstableHasActiveBlockOverlayActive": function() { return __unstableHasActiveBlockOverlayActive; },
  "__unstableIsFullySelected": function() { return __unstableIsFullySelected; },
  "__unstableIsLastBlockChangeIgnored": function() { return __unstableIsLastBlockChangeIgnored; },
  "__unstableIsSelectionCollapsed": function() { return __unstableIsSelectionCollapsed; },
  "__unstableIsSelectionMergeable": function() { return __unstableIsSelectionMergeable; },
  "__unstableIsWithinBlockOverlay": function() { return __unstableIsWithinBlockOverlay; },
  "__unstableSelectionHasUnmergeableBlock": function() { return __unstableSelectionHasUnmergeableBlock; },
  "areInnerBlocksControlled": function() { return areInnerBlocksControlled; },
  "canEditBlock": function() { return canEditBlock; },
  "canInsertBlockType": function() { return canInsertBlockType; },
  "canInsertBlocks": function() { return canInsertBlocks; },
  "canLockBlockType": function() { return canLockBlockType; },
  "canMoveBlock": function() { return canMoveBlock; },
  "canMoveBlocks": function() { return canMoveBlocks; },
  "canRemoveBlock": function() { return canRemoveBlock; },
  "canRemoveBlocks": function() { return canRemoveBlocks; },
  "didAutomaticChange": function() { return didAutomaticChange; },
  "getAdjacentBlockClientId": function() { return getAdjacentBlockClientId; },
  "getAllowedBlocks": function() { return getAllowedBlocks; },
  "getBlock": function() { return getBlock; },
  "getBlockAttributes": function() { return getBlockAttributes; },
  "getBlockCount": function() { return getBlockCount; },
  "getBlockHierarchyRootClientId": function() { return getBlockHierarchyRootClientId; },
  "getBlockIndex": function() { return getBlockIndex; },
  "getBlockInsertionPoint": function() { return getBlockInsertionPoint; },
  "getBlockListSettings": function() { return getBlockListSettings; },
  "getBlockMode": function() { return getBlockMode; },
  "getBlockName": function() { return getBlockName; },
  "getBlockNamesByClientId": function() { return getBlockNamesByClientId; },
  "getBlockOrder": function() { return getBlockOrder; },
  "getBlockParents": function() { return getBlockParents; },
  "getBlockParentsByBlockName": function() { return getBlockParentsByBlockName; },
  "getBlockRootClientId": function() { return getBlockRootClientId; },
  "getBlockSelectionEnd": function() { return getBlockSelectionEnd; },
  "getBlockSelectionStart": function() { return getBlockSelectionStart; },
  "getBlockTransformItems": function() { return getBlockTransformItems; },
  "getBlocks": function() { return getBlocks; },
  "getBlocksByClientId": function() { return getBlocksByClientId; },
  "getClientIdsOfDescendants": function() { return getClientIdsOfDescendants; },
  "getClientIdsWithDescendants": function() { return getClientIdsWithDescendants; },
  "getDraggedBlockClientIds": function() { return getDraggedBlockClientIds; },
  "getFirstMultiSelectedBlockClientId": function() { return getFirstMultiSelectedBlockClientId; },
  "getGlobalBlockCount": function() { return getGlobalBlockCount; },
  "getInserterItems": function() { return getInserterItems; },
  "getLastMultiSelectedBlockClientId": function() { return getLastMultiSelectedBlockClientId; },
  "getLowestCommonAncestorWithSelectedBlock": function() { return getLowestCommonAncestorWithSelectedBlock; },
  "getMultiSelectedBlockClientIds": function() { return getMultiSelectedBlockClientIds; },
  "getMultiSelectedBlocks": function() { return getMultiSelectedBlocks; },
  "getMultiSelectedBlocksEndClientId": function() { return getMultiSelectedBlocksEndClientId; },
  "getMultiSelectedBlocksStartClientId": function() { return getMultiSelectedBlocksStartClientId; },
  "getNextBlockClientId": function() { return getNextBlockClientId; },
  "getPatternsByBlockTypes": function() { return getPatternsByBlockTypes; },
  "getPreviousBlockClientId": function() { return getPreviousBlockClientId; },
  "getSelectedBlock": function() { return getSelectedBlock; },
  "getSelectedBlockClientId": function() { return getSelectedBlockClientId; },
  "getSelectedBlockClientIds": function() { return getSelectedBlockClientIds; },
  "getSelectedBlockCount": function() { return getSelectedBlockCount; },
  "getSelectedBlocksInitialCaretPosition": function() { return getSelectedBlocksInitialCaretPosition; },
  "getSelectionEnd": function() { return getSelectionEnd; },
  "getSelectionStart": function() { return getSelectionStart; },
  "getSettings": function() { return getSettings; },
  "getTemplate": function() { return getTemplate; },
  "getTemplateLock": function() { return getTemplateLock; },
  "hasBlockMovingClientId": function() { return selectors_hasBlockMovingClientId; },
  "hasInserterItems": function() { return hasInserterItems; },
  "hasMultiSelection": function() { return hasMultiSelection; },
  "hasSelectedBlock": function() { return hasSelectedBlock; },
  "hasSelectedInnerBlock": function() { return hasSelectedInnerBlock; },
  "isAncestorBeingDragged": function() { return isAncestorBeingDragged; },
  "isAncestorMultiSelected": function() { return isAncestorMultiSelected; },
  "isBlockBeingDragged": function() { return isBlockBeingDragged; },
  "isBlockHighlighted": function() { return isBlockHighlighted; },
  "isBlockInsertionPointVisible": function() { return isBlockInsertionPointVisible; },
  "isBlockMultiSelected": function() { return isBlockMultiSelected; },
  "isBlockSelected": function() { return isBlockSelected; },
  "isBlockValid": function() { return isBlockValid; },
  "isBlockVisible": function() { return isBlockVisible; },
  "isBlockWithinSelection": function() { return isBlockWithinSelection; },
  "isCaretWithinFormattedText": function() { return isCaretWithinFormattedText; },
  "isDraggingBlocks": function() { return isDraggingBlocks; },
  "isFirstMultiSelectedBlock": function() { return isFirstMultiSelectedBlock; },
  "isLastBlockChangePersistent": function() { return isLastBlockChangePersistent; },
  "isMultiSelecting": function() { return selectors_isMultiSelecting; },
  "isNavigationMode": function() { return isNavigationMode; },
  "isSelectionEnabled": function() { return selectors_isSelectionEnabled; },
  "isTyping": function() { return selectors_isTyping; },
  "isValidTemplate": function() { return isValidTemplate; },
  "wasBlockJustInserted": function() { return wasBlockJustInserted; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-editor/build-module/store/private-actions.js
var private_actions_namespaceObject = {};
__webpack_require__.r(private_actions_namespaceObject);
__webpack_require__.d(private_actions_namespaceObject, {
  "__experimentalUpdateSettings": function() { return __experimentalUpdateSettings; },
  "hideBlockInterface": function() { return hideBlockInterface; },
  "showBlockInterface": function() { return showBlockInterface; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-editor/build-module/store/private-selectors.js
var private_selectors_namespaceObject = {};
__webpack_require__.r(private_selectors_namespaceObject);
__webpack_require__.d(private_selectors_namespaceObject, {
  "getLastInsertedBlocksClientIds": function() { return getLastInsertedBlocksClientIds; },
  "isBlockInterfaceHidden": function() { return private_selectors_isBlockInterfaceHidden; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-editor/build-module/store/actions.js
var actions_namespaceObject = {};
__webpack_require__.r(actions_namespaceObject);
__webpack_require__.d(actions_namespaceObject, {
  "__unstableDeleteSelection": function() { return __unstableDeleteSelection; },
  "__unstableExpandSelection": function() { return __unstableExpandSelection; },
  "__unstableMarkAutomaticChange": function() { return __unstableMarkAutomaticChange; },
  "__unstableMarkLastChangeAsPersistent": function() { return __unstableMarkLastChangeAsPersistent; },
  "__unstableMarkNextChangeAsNotPersistent": function() { return __unstableMarkNextChangeAsNotPersistent; },
  "__unstableSaveReusableBlock": function() { return __unstableSaveReusableBlock; },
  "__unstableSetEditorMode": function() { return __unstableSetEditorMode; },
  "__unstableSetTemporarilyEditingAsBlocks": function() { return __unstableSetTemporarilyEditingAsBlocks; },
  "__unstableSplitSelection": function() { return __unstableSplitSelection; },
  "clearSelectedBlock": function() { return clearSelectedBlock; },
  "duplicateBlocks": function() { return duplicateBlocks; },
  "enterFormattedText": function() { return enterFormattedText; },
  "exitFormattedText": function() { return exitFormattedText; },
  "flashBlock": function() { return flashBlock; },
  "hideInsertionPoint": function() { return hideInsertionPoint; },
  "insertAfterBlock": function() { return insertAfterBlock; },
  "insertBeforeBlock": function() { return insertBeforeBlock; },
  "insertBlock": function() { return insertBlock; },
  "insertBlocks": function() { return insertBlocks; },
  "insertDefaultBlock": function() { return insertDefaultBlock; },
  "mergeBlocks": function() { return mergeBlocks; },
  "moveBlockToPosition": function() { return moveBlockToPosition; },
  "moveBlocksDown": function() { return moveBlocksDown; },
  "moveBlocksToPosition": function() { return moveBlocksToPosition; },
  "moveBlocksUp": function() { return moveBlocksUp; },
  "multiSelect": function() { return multiSelect; },
  "receiveBlocks": function() { return receiveBlocks; },
  "removeBlock": function() { return removeBlock; },
  "removeBlocks": function() { return removeBlocks; },
  "replaceBlock": function() { return replaceBlock; },
  "replaceBlocks": function() { return replaceBlocks; },
  "replaceInnerBlocks": function() { return replaceInnerBlocks; },
  "resetBlocks": function() { return resetBlocks; },
  "resetSelection": function() { return resetSelection; },
  "selectBlock": function() { return selectBlock; },
  "selectNextBlock": function() { return selectNextBlock; },
  "selectPreviousBlock": function() { return selectPreviousBlock; },
  "selectionChange": function() { return selectionChange; },
  "setBlockMovingClientId": function() { return setBlockMovingClientId; },
  "setBlockVisibility": function() { return setBlockVisibility; },
  "setHasControlledInnerBlocks": function() { return setHasControlledInnerBlocks; },
  "setNavigationMode": function() { return setNavigationMode; },
  "setTemplateValidity": function() { return setTemplateValidity; },
  "showInsertionPoint": function() { return showInsertionPoint; },
  "startDraggingBlocks": function() { return startDraggingBlocks; },
  "startMultiSelect": function() { return startMultiSelect; },
  "startTyping": function() { return startTyping; },
  "stopDraggingBlocks": function() { return stopDraggingBlocks; },
  "stopMultiSelect": function() { return stopMultiSelect; },
  "stopTyping": function() { return stopTyping; },
  "synchronizeTemplate": function() { return synchronizeTemplate; },
  "toggleBlockHighlight": function() { return toggleBlockHighlight; },
  "toggleBlockMode": function() { return toggleBlockMode; },
  "toggleSelection": function() { return toggleSelection; },
  "updateBlock": function() { return updateBlock; },
  "updateBlockAttributes": function() { return updateBlockAttributes; },
  "updateBlockListSettings": function() { return updateBlockListSettings; },
  "updateSettings": function() { return updateSettings; },
  "validateBlocksToTemplate": function() { return validateBlocksToTemplate; }
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-editor/build-module/components/global-styles/index.js
var global_styles_namespaceObject = {};
__webpack_require__.r(global_styles_namespaceObject);
__webpack_require__.d(global_styles_namespaceObject, {
  "GlobalStylesContext": function() { return GlobalStylesContext; },
  "useGlobalSetting": function() { return useGlobalSetting; },
  "useGlobalStyle": function() { return useGlobalStyle; },
  "useGlobalStylesOutput": function() { return useGlobalStylesOutput; },
  "useGlobalStylesReset": function() { return useGlobalStylesReset; }
});

;// CONCATENATED MODULE: external ["wp","blocks"]
var external_wp_blocks_namespaceObject = window["wp"]["blocks"];
;// CONCATENATED MODULE: external ["wp","hooks"]
var external_wp_hooks_namespaceObject = window["wp"]["hooks"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/compat.js
/**
 * WordPress dependencies
 */



function migrateLightBlockWrapper(settings) {
  const {
    apiVersion = 1
  } = settings;

  if (apiVersion < 2 && (0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, 'lightBlockWrapper', false)) {
    settings.apiVersion = 2;
  }

  return settings;
}

(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/compat/migrateLightBlockWrapper', migrateLightBlockWrapper);

;// CONCATENATED MODULE: ./node_modules/@babel/runtime/helpers/esm/extends.js
function _extends() {
  return _extends = Object.assign ? Object.assign.bind() : function (n) {
    for (var e = 1; e < arguments.length; e++) {
      var t = arguments[e];
      for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]);
    }
    return n;
  }, _extends.apply(null, arguments);
}

;// CONCATENATED MODULE: external ["wp","element"]
var external_wp_element_namespaceObject = window["wp"]["element"];
// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__(7153);
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);
;// CONCATENATED MODULE: external ["wp","compose"]
var external_wp_compose_namespaceObject = window["wp"]["compose"];
;// CONCATENATED MODULE: external ["wp","data"]
var external_wp_data_namespaceObject = window["wp"]["data"];
;// CONCATENATED MODULE: external "lodash"
var external_lodash_namespaceObject = window["lodash"];
;// CONCATENATED MODULE: external ["wp","components"]
var external_wp_components_namespaceObject = window["wp"]["components"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-controls/groups.js
/**
 * WordPress dependencies
 */

const BlockControlsDefault = (0,external_wp_components_namespaceObject.createSlotFill)('BlockControls');
const BlockControlsBlock = (0,external_wp_components_namespaceObject.createSlotFill)('BlockControlsBlock');
const BlockControlsInline = (0,external_wp_components_namespaceObject.createSlotFill)('BlockFormatControls');
const BlockControlsOther = (0,external_wp_components_namespaceObject.createSlotFill)('BlockControlsOther');
const BlockControlsParent = (0,external_wp_components_namespaceObject.createSlotFill)('BlockControlsParent');
const groups = {
  default: BlockControlsDefault,
  block: BlockControlsBlock,
  inline: BlockControlsInline,
  other: BlockControlsOther,
  parent: BlockControlsParent
};
/* harmony default export */ var block_controls_groups = (groups);

// EXTERNAL MODULE: ./node_modules/fast-deep-equal/es6/index.js
var es6 = __webpack_require__(5619);
var es6_default = /*#__PURE__*/__webpack_require__.n(es6);
;// CONCATENATED MODULE: external ["wp","i18n"]
var external_wp_i18n_namespaceObject = window["wp"]["i18n"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/defaults.js
/**
 * WordPress dependencies
 */

const PREFERENCES_DEFAULTS = {
  insertUsage: {}
};
/**
 * The default editor settings
 *
 * @typedef {Object} SETTINGS_DEFAULT
 * @property {boolean}       alignWide                              Enable/Disable Wide/Full Alignments
 * @property {boolean}       supportsLayout                         Enable/disable layouts support in container blocks.
 * @property {boolean}       imageEditing                           Image Editing settings set to false to disable.
 * @property {Array}         imageSizes                             Available image sizes
 * @property {number}        maxWidth                               Max width to constraint resizing
 * @property {boolean|Array} allowedBlockTypes                      Allowed block types
 * @property {boolean}       hasFixedToolbar                        Whether or not the editor toolbar is fixed
 * @property {boolean}       focusMode                              Whether the focus mode is enabled or not
 * @property {Array}         styles                                 Editor Styles
 * @property {boolean}       keepCaretInsideBlock                   Whether caret should move between blocks in edit mode
 * @property {string}        bodyPlaceholder                        Empty post placeholder
 * @property {string}        titlePlaceholder                       Empty title placeholder
 * @property {boolean}       canLockBlocks                          Whether the user can manage Block Lock state
 * @property {boolean}       codeEditingEnabled                     Whether or not the user can switch to the code editor
 * @property {boolean}       generateAnchors                        Enable/Disable auto anchor generation for Heading blocks
 * @property {boolean}       enableOpenverseMediaCategory           Enable/Disable the Openverse media category in the inserter.
 * @property {boolean}       clearBlockSelection                    Whether the block editor should clear selection on mousedown when a block is not clicked.
 * @property {boolean}       __experimentalCanUserUseUnfilteredHTML Whether the user should be able to use unfiltered HTML or the HTML should be filtered e.g., to remove elements considered insecure like iframes.
 * @property {boolean}       __experimentalBlockDirectory           Whether the user has enabled the Block Directory
 * @property {Array}         __experimentalBlockPatterns            Array of objects representing the block patterns
 * @property {Array}         __experimentalBlockPatternCategories   Array of objects representing the block pattern categories
 * @property {boolean}       __unstableGalleryWithImageBlocks       Whether the user has enabled the refactored gallery block which uses InnerBlocks
 */

const SETTINGS_DEFAULTS = {
  alignWide: false,
  supportsLayout: true,
  // colors setting is not used anymore now defaults are passed from theme.json on the server and core has its own defaults.
  // The setting is only kept for backward compatibility purposes.
  colors: [{
    name: (0,external_wp_i18n_namespaceObject.__)('Black'),
    slug: 'black',
    color: '#000000'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Cyan bluish gray'),
    slug: 'cyan-bluish-gray',
    color: '#abb8c3'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('White'),
    slug: 'white',
    color: '#ffffff'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Pale pink'),
    slug: 'pale-pink',
    color: '#f78da7'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Vivid red'),
    slug: 'vivid-red',
    color: '#cf2e2e'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Luminous vivid orange'),
    slug: 'luminous-vivid-orange',
    color: '#ff6900'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Luminous vivid amber'),
    slug: 'luminous-vivid-amber',
    color: '#fcb900'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Light green cyan'),
    slug: 'light-green-cyan',
    color: '#7bdcb5'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Vivid green cyan'),
    slug: 'vivid-green-cyan',
    color: '#00d084'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Pale cyan blue'),
    slug: 'pale-cyan-blue',
    color: '#8ed1fc'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Vivid cyan blue'),
    slug: 'vivid-cyan-blue',
    color: '#0693e3'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Vivid purple'),
    slug: 'vivid-purple',
    color: '#9b51e0'
  }],
  // fontSizes setting is not used anymore now defaults are passed from theme.json on the server and core has its own defaults.
  // The setting is only kept for backward compatibility purposes.
  fontSizes: [{
    name: (0,external_wp_i18n_namespaceObject._x)('Small', 'font size name'),
    size: 13,
    slug: 'small'
  }, {
    name: (0,external_wp_i18n_namespaceObject._x)('Normal', 'font size name'),
    size: 16,
    slug: 'normal'
  }, {
    name: (0,external_wp_i18n_namespaceObject._x)('Medium', 'font size name'),
    size: 20,
    slug: 'medium'
  }, {
    name: (0,external_wp_i18n_namespaceObject._x)('Large', 'font size name'),
    size: 36,
    slug: 'large'
  }, {
    name: (0,external_wp_i18n_namespaceObject._x)('Huge', 'font size name'),
    size: 42,
    slug: 'huge'
  }],
  // Image default size slug.
  imageDefaultSize: 'large',
  imageSizes: [{
    slug: 'thumbnail',
    name: (0,external_wp_i18n_namespaceObject.__)('Thumbnail')
  }, {
    slug: 'medium',
    name: (0,external_wp_i18n_namespaceObject.__)('Medium')
  }, {
    slug: 'large',
    name: (0,external_wp_i18n_namespaceObject.__)('Large')
  }, {
    slug: 'full',
    name: (0,external_wp_i18n_namespaceObject.__)('Full Size')
  }],
  // Allow plugin to disable Image Editor if need be.
  imageEditing: true,
  // This is current max width of the block inner area
  // It's used to constraint image resizing and this value could be overridden later by themes
  maxWidth: 580,
  // Allowed block types for the editor, defaulting to true (all supported).
  allowedBlockTypes: true,
  // Maximum upload size in bytes allowed for the site.
  maxUploadFileSize: 0,
  // List of allowed mime types and file extensions.
  allowedMimeTypes: null,
  // Allows to disable block locking interface.
  canLockBlocks: true,
  // Allows to disable Openverse media category in the inserter.
  enableOpenverseMediaCategory: true,
  clearBlockSelection: true,
  __experimentalCanUserUseUnfilteredHTML: false,
  __experimentalBlockDirectory: false,
  __mobileEnablePageTemplates: false,
  __experimentalBlockPatterns: [],
  __experimentalBlockPatternCategories: [],
  __unstableGalleryWithImageBlocks: false,
  __unstableIsPreviewMode: false,
  // These settings will be completely revamped in the future.
  // The goal is to evolve this into an API which will instruct
  // the block inspector to animate transitions between what it
  // displays based on the relationship between the selected block
  // and its parent, and only enable it if the parent is controlling
  // its children blocks.
  blockInspectorAnimation: {
    animationParent: 'core/navigation',
    'core/navigation': {
      enterDirection: 'leftToRight'
    },
    'core/navigation-submenu': {
      enterDirection: 'rightToLeft'
    },
    'core/navigation-link': {
      enterDirection: 'rightToLeft'
    },
    'core/search': {
      enterDirection: 'rightToLeft'
    },
    'core/social-links': {
      enterDirection: 'rightToLeft'
    },
    'core/page-list': {
      enterDirection: 'rightToLeft'
    },
    'core/spacer': {
      enterDirection: 'rightToLeft'
    },
    'core/home-link': {
      enterDirection: 'rightToLeft'
    },
    'core/site-title': {
      enterDirection: 'rightToLeft'
    },
    'core/site-logo': {
      enterDirection: 'rightToLeft'
    }
  },
  generateAnchors: false,
  // gradients setting is not used anymore now defaults are passed from theme.json on the server and core has its own defaults.
  // The setting is only kept for backward compatibility purposes.
  gradients: [{
    name: (0,external_wp_i18n_namespaceObject.__)('Vivid cyan blue to vivid purple'),
    gradient: 'linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)',
    slug: 'vivid-cyan-blue-to-vivid-purple'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Light green cyan to vivid green cyan'),
    gradient: 'linear-gradient(135deg,rgb(122,220,180) 0%,rgb(0,208,130) 100%)',
    slug: 'light-green-cyan-to-vivid-green-cyan'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Luminous vivid amber to luminous vivid orange'),
    gradient: 'linear-gradient(135deg,rgba(252,185,0,1) 0%,rgba(255,105,0,1) 100%)',
    slug: 'luminous-vivid-amber-to-luminous-vivid-orange'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Luminous vivid orange to vivid red'),
    gradient: 'linear-gradient(135deg,rgba(255,105,0,1) 0%,rgb(207,46,46) 100%)',
    slug: 'luminous-vivid-orange-to-vivid-red'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Very light gray to cyan bluish gray'),
    gradient: 'linear-gradient(135deg,rgb(238,238,238) 0%,rgb(169,184,195) 100%)',
    slug: 'very-light-gray-to-cyan-bluish-gray'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Cool to warm spectrum'),
    gradient: 'linear-gradient(135deg,rgb(74,234,220) 0%,rgb(151,120,209) 20%,rgb(207,42,186) 40%,rgb(238,44,130) 60%,rgb(251,105,98) 80%,rgb(254,248,76) 100%)',
    slug: 'cool-to-warm-spectrum'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Blush light purple'),
    gradient: 'linear-gradient(135deg,rgb(255,206,236) 0%,rgb(152,150,240) 100%)',
    slug: 'blush-light-purple'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Blush bordeaux'),
    gradient: 'linear-gradient(135deg,rgb(254,205,165) 0%,rgb(254,45,45) 50%,rgb(107,0,62) 100%)',
    slug: 'blush-bordeaux'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Luminous dusk'),
    gradient: 'linear-gradient(135deg,rgb(255,203,112) 0%,rgb(199,81,192) 50%,rgb(65,88,208) 100%)',
    slug: 'luminous-dusk'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Pale ocean'),
    gradient: 'linear-gradient(135deg,rgb(255,245,203) 0%,rgb(182,227,212) 50%,rgb(51,167,181) 100%)',
    slug: 'pale-ocean'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Electric grass'),
    gradient: 'linear-gradient(135deg,rgb(202,248,128) 0%,rgb(113,206,126) 100%)',
    slug: 'electric-grass'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Midnight'),
    gradient: 'linear-gradient(135deg,rgb(2,3,129) 0%,rgb(40,116,252) 100%)',
    slug: 'midnight'
  }],
  __unstableResolvedAssets: {
    styles: [],
    scripts: []
  }
};

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/array.js
/**
 * Insert one or multiple elements into a given position of an array.
 *
 * @param {Array}  array    Source array.
 * @param {*}      elements Elements to insert.
 * @param {number} index    Insert Position.
 *
 * @return {Array} Result.
 */
function insertAt(array, elements, index) {
  return [...array.slice(0, index), ...(Array.isArray(elements) ? elements : [elements]), ...array.slice(index)];
}
/**
 * Moves an element in an array.
 *
 * @param {Array}  array Source array.
 * @param {number} from  Source index.
 * @param {number} to    Destination index.
 * @param {number} count Number of elements to move.
 *
 * @return {Array} Result.
 */

function moveTo(array, from, to) {
  let count = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
  const withoutMovedElements = [...array];
  withoutMovedElements.splice(from, count);
  return insertAt(withoutMovedElements, array.slice(from, from + count), to);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/reducer.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */




const identity = x => x;
/**
 * Given an array of blocks, returns an object where each key is a nesting
 * context, the value of which is an array of block client IDs existing within
 * that nesting context.
 *
 * @param {Array}   blocks       Blocks to map.
 * @param {?string} rootClientId Assumed root client ID.
 *
 * @return {Object} Block order map object.
 */


function mapBlockOrder(blocks) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  const result = new Map();
  const current = [];
  result.set(rootClientId, current);
  blocks.forEach(block => {
    const {
      clientId,
      innerBlocks
    } = block;
    current.push(clientId);
    mapBlockOrder(innerBlocks, clientId).forEach((order, subClientId) => {
      result.set(subClientId, order);
    });
  });
  return result;
}
/**
 * Given an array of blocks, returns an object where each key contains
 * the clientId of the block and the value is the parent of the block.
 *
 * @param {Array}   blocks       Blocks to map.
 * @param {?string} rootClientId Assumed root client ID.
 *
 * @return {Object} Block order map object.
 */


function mapBlockParents(blocks) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  const result = [];
  const stack = [[rootClientId, blocks]];

  while (stack.length) {
    const [parent, currentBlocks] = stack.shift();
    currentBlocks.forEach(_ref => {
      let {
        innerBlocks,
        ...block
      } = _ref;
      result.push([block.clientId, parent]);

      if (innerBlocks !== null && innerBlocks !== void 0 && innerBlocks.length) {
        stack.push([block.clientId, innerBlocks]);
      }
    });
  }

  return result;
}
/**
 * Helper method to iterate through all blocks, recursing into inner blocks,
 * applying a transformation function to each one.
 * Returns a flattened object with the transformed blocks.
 *
 * @param {Array}    blocks    Blocks to flatten.
 * @param {Function} transform Transforming function to be applied to each block.
 *
 * @return {Array} Flattened object.
 */


function flattenBlocks(blocks) {
  let transform = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : identity;
  const result = [];
  const stack = [...blocks];

  while (stack.length) {
    const {
      innerBlocks,
      ...block
    } = stack.shift();
    stack.push(...innerBlocks);
    result.push([block.clientId, transform(block)]);
  }

  return result;
}

function getFlattenedClientIds(blocks) {
  const result = {};
  const stack = [...blocks];

  while (stack.length) {
    const {
      innerBlocks,
      ...block
    } = stack.shift();
    stack.push(...innerBlocks);
    result[block.clientId] = true;
  }

  return result;
}
/**
 * Given an array of blocks, returns an object containing all blocks, without
 * attributes, recursing into inner blocks. Keys correspond to the block client
 * ID, the value of which is the attributes object.
 *
 * @param {Array} blocks Blocks to flatten.
 *
 * @return {Array} Flattened block attributes object.
 */


function getFlattenedBlocksWithoutAttributes(blocks) {
  return flattenBlocks(blocks, block => {
    const {
      attributes,
      ...restBlock
    } = block;
    return restBlock;
  });
}
/**
 * Given an array of blocks, returns an object containing all block attributes,
 * recursing into inner blocks. Keys correspond to the block client ID, the
 * value of which is the attributes object.
 *
 * @param {Array} blocks Blocks to flatten.
 *
 * @return {Array} Flattened block attributes object.
 */


function getFlattenedBlockAttributes(blocks) {
  return flattenBlocks(blocks, block => block.attributes);
}
/**
 * Returns true if the two object arguments have the same keys, or false
 * otherwise.
 *
 * @param {Object} a First object.
 * @param {Object} b Second object.
 *
 * @return {boolean} Whether the two objects have the same keys.
 */


function hasSameKeys(a, b) {
  return es6_default()(Object.keys(a), Object.keys(b));
}
/**
 * Returns true if, given the currently dispatching action and the previously
 * dispatched action, the two actions are updating the same block attribute, or
 * false otherwise.
 *
 * @param {Object} action     Currently dispatching action.
 * @param {Object} lastAction Previously dispatched action.
 *
 * @return {boolean} Whether actions are updating the same block attribute.
 */

function isUpdatingSameBlockAttribute(action, lastAction) {
  return action.type === 'UPDATE_BLOCK_ATTRIBUTES' && lastAction !== undefined && lastAction.type === 'UPDATE_BLOCK_ATTRIBUTES' && es6_default()(action.clientIds, lastAction.clientIds) && hasSameKeys(action.attributes, lastAction.attributes);
}

function updateBlockTreeForBlocks(state, blocks) {
  const treeToUpdate = state.tree;
  const stack = [...blocks];
  const flattenedBlocks = [...blocks];

  while (stack.length) {
    const block = stack.shift();
    stack.push(...block.innerBlocks);
    flattenedBlocks.push(...block.innerBlocks);
  } // Create objects before mutating them, that way it's always defined.


  for (const block of flattenedBlocks) {
    treeToUpdate.set(block.clientId, {});
  }

  for (const block of flattenedBlocks) {
    treeToUpdate.set(block.clientId, Object.assign(treeToUpdate.get(block.clientId), { ...state.byClientId.get(block.clientId),
      attributes: state.attributes.get(block.clientId),
      innerBlocks: block.innerBlocks.map(subBlock => treeToUpdate.get(subBlock.clientId))
    }));
  }
}

function updateParentInnerBlocksInTree(state, updatedClientIds) {
  let updateChildrenOfUpdatedClientIds = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  const treeToUpdate = state.tree;
  const uncontrolledParents = new Set([]);
  const controlledParents = new Set();

  for (const clientId of updatedClientIds) {
    let current = updateChildrenOfUpdatedClientIds ? clientId : state.parents.get(clientId);

    do {
      if (state.controlledInnerBlocks[current]) {
        // Should stop on controlled blocks.
        // If we reach a controlled parent, break out of the loop.
        controlledParents.add(current);
        break;
      } else {
        // Else continue traversing up through parents.
        uncontrolledParents.add(current);
        current = state.parents.get(current);
      }
    } while (current !== undefined);
  } // To make sure the order of assignments doesn't matter,
  // we first create empty objects and mutates the inner blocks later.


  for (const clientId of uncontrolledParents) {
    treeToUpdate.set(clientId, { ...treeToUpdate.get(clientId)
    });
  }

  for (const clientId of uncontrolledParents) {
    treeToUpdate.get(clientId).innerBlocks = (state.order.get(clientId) || []).map(subClientId => treeToUpdate.get(subClientId));
  } // Controlled parent blocks, need a dedicated key for their inner blocks
  // to be used when doing getBlocks( controlledBlockClientId ).


  for (const clientId of controlledParents) {
    treeToUpdate.set('controlled||' + clientId, {
      innerBlocks: (state.order.get(clientId) || []).map(subClientId => treeToUpdate.get(subClientId))
    });
  }
}
/**
 * Higher-order reducer intended to compute full block objects key for each block in the post.
 * This is a denormalization to optimize the performance of the getBlock selectors and avoid
 * recomputing the block objects and avoid heavy memoization.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


const withBlockTree = reducer => function () {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;
  const newState = reducer(state, action);

  if (newState === state) {
    return state;
  }

  newState.tree = state.tree ? state.tree : new Map();

  switch (action.type) {
    case 'RECEIVE_BLOCKS':
    case 'INSERT_BLOCKS':
      {
        newState.tree = new Map(newState.tree);
        updateBlockTreeForBlocks(newState, action.blocks);
        updateParentInnerBlocksInTree(newState, action.rootClientId ? [action.rootClientId] : [''], true);
        break;
      }

    case 'UPDATE_BLOCK':
      newState.tree = new Map(newState.tree);
      newState.tree.set(action.clientId, { ...newState.tree.get(action.clientId),
        ...newState.byClientId.get(action.clientId),
        attributes: newState.attributes.get(action.clientId)
      });
      updateParentInnerBlocksInTree(newState, [action.clientId], false);
      break;

    case 'UPDATE_BLOCK_ATTRIBUTES':
      {
        newState.tree = new Map(newState.tree);
        action.clientIds.forEach(clientId => {
          newState.tree.set(clientId, { ...newState.tree.get(clientId),
            attributes: newState.attributes.get(clientId)
          });
        });
        updateParentInnerBlocksInTree(newState, action.clientIds, false);
        break;
      }

    case 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN':
      {
        const inserterClientIds = getFlattenedClientIds(action.blocks);
        newState.tree = new Map(newState.tree);
        action.replacedClientIds.concat( // Controlled inner blocks are only removed
        // if the block doesn't move to another position
        // otherwise their content will be lost.
        action.replacedClientIds.filter(clientId => !inserterClientIds[clientId]).map(clientId => 'controlled||' + clientId)).forEach(key => {
          newState.tree.delete(key);
        });
        updateBlockTreeForBlocks(newState, action.blocks);
        updateParentInnerBlocksInTree(newState, action.blocks.map(b => b.clientId), false); // If there are no replaced blocks, it means we're removing blocks so we need to update their parent.

        const parentsOfRemovedBlocks = [];

        for (const clientId of action.clientIds) {
          if (state.parents.get(clientId) !== undefined && (state.parents.get(clientId) === '' || newState.byClientId.get(state.parents.get(clientId)))) {
            parentsOfRemovedBlocks.push(state.parents.get(clientId));
          }
        }

        updateParentInnerBlocksInTree(newState, parentsOfRemovedBlocks, true);
        break;
      }

    case 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN':
      const parentsOfRemovedBlocks = [];

      for (const clientId of action.clientIds) {
        if (state.parents.get(clientId) !== undefined && (state.parents.get(clientId) === '' || newState.byClientId.get(state.parents.get(clientId)))) {
          parentsOfRemovedBlocks.push(state.parents.get(clientId));
        }
      }

      newState.tree = new Map(newState.tree);
      action.removedClientIds.concat(action.removedClientIds.map(clientId => 'controlled||' + clientId)).forEach(key => {
        newState.tree.delete(key);
      });
      updateParentInnerBlocksInTree(newState, parentsOfRemovedBlocks, true);
      break;

    case 'MOVE_BLOCKS_TO_POSITION':
      {
        const updatedBlockUids = [];

        if (action.fromRootClientId) {
          updatedBlockUids.push(action.fromRootClientId);
        } else {
          updatedBlockUids.push('');
        }

        if (action.toRootClientId) {
          updatedBlockUids.push(action.toRootClientId);
        }

        newState.tree = new Map(newState.tree);
        updateParentInnerBlocksInTree(newState, updatedBlockUids, true);
        break;
      }

    case 'MOVE_BLOCKS_UP':
    case 'MOVE_BLOCKS_DOWN':
      {
        const updatedBlockUids = [action.rootClientId ? action.rootClientId : ''];
        newState.tree = new Map(newState.tree);
        updateParentInnerBlocksInTree(newState, updatedBlockUids, true);
        break;
      }

    case 'SAVE_REUSABLE_BLOCK_SUCCESS':
      {
        const updatedBlockUids = [];
        newState.attributes.forEach((attributes, clientId) => {
          if (newState.byClientId.get(clientId).name === 'core/block' && attributes.ref === action.updatedId) {
            updatedBlockUids.push(clientId);
          }
        });
        newState.tree = new Map(newState.tree);
        updatedBlockUids.forEach(clientId => {
          newState.tree.set(clientId, { ...newState.byClientId.get(clientId),
            attributes: newState.attributes.get(clientId),
            innerBlocks: newState.tree.get(clientId).innerBlocks
          });
        });
        updateParentInnerBlocksInTree(newState, updatedBlockUids, false);
      }
  }

  return newState;
};
/**
 * Higher-order reducer intended to augment the blocks reducer, assigning an
 * `isPersistentChange` property value corresponding to whether a change in
 * state can be considered as persistent. All changes are considered persistent
 * except when updating the same block attribute as in the previous action.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


function withPersistentBlockChange(reducer) {
  let lastAction;
  let markNextChangeAsNotPersistent = false;
  return (state, action) => {
    let nextState = reducer(state, action);
    const isExplicitPersistentChange = action.type === 'MARK_LAST_CHANGE_AS_PERSISTENT' || markNextChangeAsNotPersistent; // Defer to previous state value (or default) unless changing or
    // explicitly marking as persistent.

    if (state === nextState && !isExplicitPersistentChange) {
      var _state$isPersistentCh;

      markNextChangeAsNotPersistent = action.type === 'MARK_NEXT_CHANGE_AS_NOT_PERSISTENT';
      const nextIsPersistentChange = (_state$isPersistentCh = state === null || state === void 0 ? void 0 : state.isPersistentChange) !== null && _state$isPersistentCh !== void 0 ? _state$isPersistentCh : true;

      if (state.isPersistentChange === nextIsPersistentChange) {
        return state;
      }

      return { ...nextState,
        isPersistentChange: nextIsPersistentChange
      };
    }

    nextState = { ...nextState,
      isPersistentChange: isExplicitPersistentChange ? !markNextChangeAsNotPersistent : !isUpdatingSameBlockAttribute(action, lastAction)
    }; // In comparing against the previous action, consider only those which
    // would have qualified as one which would have been ignored or not
    // have resulted in a changed state.

    lastAction = action;
    markNextChangeAsNotPersistent = action.type === 'MARK_NEXT_CHANGE_AS_NOT_PERSISTENT';
    return nextState;
  };
}
/**
 * Higher-order reducer intended to augment the blocks reducer, assigning an
 * `isIgnoredChange` property value corresponding to whether a change in state
 * can be considered as ignored. A change is considered ignored when the result
 * of an action not incurred by direct user interaction.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


function withIgnoredBlockChange(reducer) {
  /**
   * Set of action types for which a blocks state change should be ignored.
   *
   * @type {Set}
   */
  const IGNORED_ACTION_TYPES = new Set(['RECEIVE_BLOCKS']);
  return (state, action) => {
    const nextState = reducer(state, action);

    if (nextState !== state) {
      nextState.isIgnoredChange = IGNORED_ACTION_TYPES.has(action.type);
    }

    return nextState;
  };
}
/**
 * Higher-order reducer targeting the combined blocks reducer, augmenting
 * block client IDs in remove action to include cascade of inner blocks.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


const withInnerBlocksRemoveCascade = reducer => (state, action) => {
  // Gets all children which need to be removed.
  const getAllChildren = clientIds => {
    let result = clientIds;

    for (let i = 0; i < result.length; i++) {
      if (!state.order.get(result[i]) || action.keepControlledInnerBlocks && action.keepControlledInnerBlocks[result[i]]) {
        continue;
      }

      if (result === clientIds) {
        result = [...result];
      }

      result.push(...state.order.get(result[i]));
    }

    return result;
  };

  if (state) {
    switch (action.type) {
      case 'REMOVE_BLOCKS':
        action = { ...action,
          type: 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN',
          removedClientIds: getAllChildren(action.clientIds)
        };
        break;

      case 'REPLACE_BLOCKS':
        action = { ...action,
          type: 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN',
          replacedClientIds: getAllChildren(action.clientIds)
        };
        break;
    }
  }

  return reducer(state, action);
};
/**
 * Higher-order reducer which targets the combined blocks reducer and handles
 * the `RESET_BLOCKS` action. When dispatched, this action will replace all
 * blocks that exist in the post, leaving blocks that exist only in state (e.g.
 * reusable blocks and blocks controlled by inner blocks controllers) alone.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


const withBlockReset = reducer => (state, action) => {
  if (action.type === 'RESET_BLOCKS') {
    const newState = { ...state,
      byClientId: new Map(getFlattenedBlocksWithoutAttributes(action.blocks)),
      attributes: new Map(getFlattenedBlockAttributes(action.blocks)),
      order: mapBlockOrder(action.blocks),
      parents: new Map(mapBlockParents(action.blocks)),
      controlledInnerBlocks: {}
    };
    newState.tree = new Map(state === null || state === void 0 ? void 0 : state.tree);
    updateBlockTreeForBlocks(newState, action.blocks);
    newState.tree.set('', {
      innerBlocks: action.blocks.map(subBlock => newState.tree.get(subBlock.clientId))
    });
    return newState;
  }

  return reducer(state, action);
};
/**
 * Higher-order reducer which targets the combined blocks reducer and handles
 * the `REPLACE_INNER_BLOCKS` action. When dispatched, this action the state
 * should become equivalent to the execution of a `REMOVE_BLOCKS` action
 * containing all the child's of the root block followed by the execution of
 * `INSERT_BLOCKS` with the new blocks.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


const withReplaceInnerBlocks = reducer => (state, action) => {
  if (action.type !== 'REPLACE_INNER_BLOCKS') {
    return reducer(state, action);
  } // Finds every nested inner block controller. We must check the action blocks
  // and not just the block parent state because some inner block controllers
  // should be deleted if specified, whereas others should not be deleted. If
  // a controlled should not be deleted, then we need to avoid deleting its
  // inner blocks from the block state because its inner blocks will not be
  // attached to the block in the action.


  const nestedControllers = {};

  if (Object.keys(state.controlledInnerBlocks).length) {
    const stack = [...action.blocks];

    while (stack.length) {
      const {
        innerBlocks,
        ...block
      } = stack.shift();
      stack.push(...innerBlocks);

      if (!!state.controlledInnerBlocks[block.clientId]) {
        nestedControllers[block.clientId] = true;
      }
    }
  } // The `keepControlledInnerBlocks` prop will keep the inner blocks of the
  // marked block in the block state so that they can be reattached to the
  // marked block when we re-insert everything a few lines below.


  let stateAfterBlocksRemoval = state;

  if (state.order.get(action.rootClientId)) {
    stateAfterBlocksRemoval = reducer(stateAfterBlocksRemoval, {
      type: 'REMOVE_BLOCKS',
      keepControlledInnerBlocks: nestedControllers,
      clientIds: state.order.get(action.rootClientId)
    });
  }

  let stateAfterInsert = stateAfterBlocksRemoval;

  if (action.blocks.length) {
    stateAfterInsert = reducer(stateAfterInsert, { ...action,
      type: 'INSERT_BLOCKS',
      index: 0
    }); // We need to re-attach the controlled inner blocks to the blocks tree and
    // preserve their block order. Otherwise, an inner block controller's blocks
    // will be deleted entirely from its entity.

    const stateAfterInsertOrder = new Map(stateAfterInsert.order);
    Object.keys(nestedControllers).forEach(key => {
      if (state.order.get(key)) {
        stateAfterInsertOrder.set(key, state.order.get(key));
      }
    });
    stateAfterInsert.order = stateAfterInsertOrder;
    stateAfterInsert.tree = new Map(stateAfterInsert.tree);
    Object.keys(nestedControllers).forEach(_key => {
      const key = `controlled||${_key}`;

      if (state.tree.has(key)) {
        stateAfterInsert.tree.set(key, state.tree.get(key));
      }
    });
  }

  return stateAfterInsert;
};
/**
 * Higher-order reducer which targets the combined blocks reducer and handles
 * the `SAVE_REUSABLE_BLOCK_SUCCESS` action. This action can't be handled by
 * regular reducers and needs a higher-order reducer since it needs access to
 * both `byClientId` and `attributes` simultaneously.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


const withSaveReusableBlock = reducer => (state, action) => {
  if (state && action.type === 'SAVE_REUSABLE_BLOCK_SUCCESS') {
    const {
      id,
      updatedId
    } = action; // If a temporary reusable block is saved, we swap the temporary id with the final one.

    if (id === updatedId) {
      return state;
    }

    state = { ...state
    };
    state.attributes = new Map(state.attributes);
    state.attributes.forEach((attributes, clientId) => {
      const {
        name
      } = state.byClientId.get(clientId);

      if (name === 'core/block' && attributes.ref === id) {
        state.attributes.set(clientId, { ...attributes,
          ref: updatedId
        });
      }
    });
  }

  return reducer(state, action);
};
/**
 * Higher-order reducer which removes blocks from state when switching parent block controlled state.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


const withResetControlledBlocks = reducer => (state, action) => {
  if (action.type === 'SET_HAS_CONTROLLED_INNER_BLOCKS') {
    // when switching a block from controlled to uncontrolled or inverse,
    // we need to remove its content first.
    const tempState = reducer(state, {
      type: 'REPLACE_INNER_BLOCKS',
      rootClientId: action.clientId,
      blocks: []
    });
    return reducer(tempState, action);
  }

  return reducer(state, action);
};
/**
 * Reducer returning the blocks state.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */


const blocks = (0,external_wp_compose_namespaceObject.pipe)(external_wp_data_namespaceObject.combineReducers, withSaveReusableBlock, // Needs to be before withBlockCache.
withBlockTree, // Needs to be before withInnerBlocksRemoveCascade.
withInnerBlocksRemoveCascade, withReplaceInnerBlocks, // Needs to be after withInnerBlocksRemoveCascade.
withBlockReset, withPersistentBlockChange, withIgnoredBlockChange, withResetControlledBlocks)({
  // The state is using a Map instead of a plain object for performance reasons.
  // You can run the "./test/performance.js" unit test to check the impact
  // code changes can have on this reducer.
  byClientId() {
    let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new Map();
    let action = arguments.length > 1 ? arguments[1] : undefined;

    switch (action.type) {
      case 'RECEIVE_BLOCKS':
      case 'INSERT_BLOCKS':
        {
          const newState = new Map(state);
          getFlattenedBlocksWithoutAttributes(action.blocks).forEach(_ref2 => {
            let [key, value] = _ref2;
            newState.set(key, value);
          });
          return newState;
        }

      case 'UPDATE_BLOCK':
        {
          // Ignore updates if block isn't known.
          if (!state.has(action.clientId)) {
            return state;
          } // Do nothing if only attributes change.


          const {
            attributes,
            ...changes
          } = action.updates;

          if (Object.values(changes).length === 0) {
            return state;
          }

          const newState = new Map(state);
          newState.set(action.clientId, { ...state.get(action.clientId),
            ...changes
          });
          return newState;
        }

      case 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        {
          if (!action.blocks) {
            return state;
          }

          const newState = new Map(state);
          action.replacedClientIds.forEach(clientId => {
            newState.delete(clientId);
          });
          getFlattenedBlocksWithoutAttributes(action.blocks).forEach(_ref3 => {
            let [key, value] = _ref3;
            newState.set(key, value);
          });
          return newState;
        }

      case 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        {
          const newState = new Map(state);
          action.removedClientIds.forEach(clientId => {
            newState.delete(clientId);
          });
          return newState;
        }
    }

    return state;
  },

  // The state is using a Map instead of a plain object for performance reasons.
  // You can run the "./test/performance.js" unit test to check the impact
  // code changes can have on this reducer.
  attributes() {
    let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new Map();
    let action = arguments.length > 1 ? arguments[1] : undefined;

    switch (action.type) {
      case 'RECEIVE_BLOCKS':
      case 'INSERT_BLOCKS':
        {
          const newState = new Map(state);
          getFlattenedBlockAttributes(action.blocks).forEach(_ref4 => {
            let [key, value] = _ref4;
            newState.set(key, value);
          });
          return newState;
        }

      case 'UPDATE_BLOCK':
        {
          // Ignore updates if block isn't known or there are no attribute changes.
          if (!state.get(action.clientId) || !action.updates.attributes) {
            return state;
          }

          const newState = new Map(state);
          newState.set(action.clientId, { ...state.get(action.clientId),
            ...action.updates.attributes
          });
          return newState;
        }

      case 'UPDATE_BLOCK_ATTRIBUTES':
        {
          // Avoid a state change if none of the block IDs are known.
          if (action.clientIds.every(id => !state.get(id))) {
            return state;
          }

          let hasChange = false;
          const newState = new Map(state);

          for (const clientId of action.clientIds) {
            var _action$attributes;

            const updatedAttributeEntries = Object.entries(action.uniqueByBlock ? action.attributes[clientId] : (_action$attributes = action.attributes) !== null && _action$attributes !== void 0 ? _action$attributes : {});

            if (updatedAttributeEntries.length === 0) {
              continue;
            }

            let hasUpdatedAttributes = false;
            const existingAttributes = state.get(clientId);
            const newAttributes = {};
            updatedAttributeEntries.forEach(_ref5 => {
              let [key, value] = _ref5;

              if (existingAttributes[key] !== value) {
                hasUpdatedAttributes = true;
                newAttributes[key] = value;
              }
            });
            hasChange = hasChange || hasUpdatedAttributes;

            if (hasUpdatedAttributes) {
              newState.set(clientId, { ...existingAttributes,
                ...newAttributes
              });
            }
          }

          return hasChange ? newState : state;
        }

      case 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        {
          if (!action.blocks) {
            return state;
          }

          const newState = new Map(state);
          action.replacedClientIds.forEach(clientId => {
            newState.delete(clientId);
          });
          getFlattenedBlockAttributes(action.blocks).forEach(_ref6 => {
            let [key, value] = _ref6;
            newState.set(key, value);
          });
          return newState;
        }

      case 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        {
          const newState = new Map(state);
          action.removedClientIds.forEach(clientId => {
            newState.delete(clientId);
          });
          return newState;
        }
    }

    return state;
  },

  // The state is using a Map instead of a plain object for performance reasons.
  // You can run the "./test/performance.js" unit test to check the impact
  // code changes can have on this reducer.
  order() {
    let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new Map();
    let action = arguments.length > 1 ? arguments[1] : undefined;

    switch (action.type) {
      case 'RECEIVE_BLOCKS':
        {
          var _state$get;

          const blockOrder = mapBlockOrder(action.blocks);
          const newState = new Map(state);
          blockOrder.forEach((order, clientId) => {
            if (clientId !== '') {
              newState.set(clientId, order);
            }
          });
          newState.set('', ((_state$get = state.get('')) !== null && _state$get !== void 0 ? _state$get : []).concat(blockOrder['']));
          return newState;
        }

      case 'INSERT_BLOCKS':
        {
          const {
            rootClientId = ''
          } = action;
          const subState = state.get(rootClientId) || [];
          const mappedBlocks = mapBlockOrder(action.blocks, rootClientId);
          const {
            index = subState.length
          } = action;
          const newState = new Map(state);
          mappedBlocks.forEach((order, clientId) => {
            newState.set(clientId, order);
          });
          newState.set(rootClientId, insertAt(subState, mappedBlocks.get(rootClientId), index));
          return newState;
        }

      case 'MOVE_BLOCKS_TO_POSITION':
        {
          var _state$get$filter, _state$get2;

          const {
            fromRootClientId = '',
            toRootClientId = '',
            clientIds
          } = action;
          const {
            index = state.get(toRootClientId).length
          } = action; // Moving inside the same parent block.

          if (fromRootClientId === toRootClientId) {
            const subState = state.get(toRootClientId);
            const fromIndex = subState.indexOf(clientIds[0]);
            const newState = new Map(state);
            newState.set(toRootClientId, moveTo(state.get(toRootClientId), fromIndex, index, clientIds.length));
            return newState;
          } // Moving from a parent block to another.


          const newState = new Map(state);
          newState.set(fromRootClientId, (_state$get$filter = (_state$get2 = state.get(fromRootClientId)) === null || _state$get2 === void 0 ? void 0 : _state$get2.filter(id => !clientIds.includes(id))) !== null && _state$get$filter !== void 0 ? _state$get$filter : []);
          newState.set(toRootClientId, insertAt(state.get(toRootClientId), clientIds, index));
          return newState;
        }

      case 'MOVE_BLOCKS_UP':
        {
          const {
            clientIds,
            rootClientId = ''
          } = action;
          const firstClientId = clientIds[0];
          const subState = state.get(rootClientId);

          if (!subState.length || firstClientId === subState[0]) {
            return state;
          }

          const firstIndex = subState.indexOf(firstClientId);
          const newState = new Map(state);
          newState.set(rootClientId, moveTo(subState, firstIndex, firstIndex - 1, clientIds.length));
          return newState;
        }

      case 'MOVE_BLOCKS_DOWN':
        {
          const {
            clientIds,
            rootClientId = ''
          } = action;
          const firstClientId = clientIds[0];
          const lastClientId = clientIds[clientIds.length - 1];
          const subState = state.get(rootClientId);

          if (!subState.length || lastClientId === subState[subState.length - 1]) {
            return state;
          }

          const firstIndex = subState.indexOf(firstClientId);
          const newState = new Map(state);
          newState.set(rootClientId, moveTo(subState, firstIndex, firstIndex + 1, clientIds.length));
          return newState;
        }

      case 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        {
          const {
            clientIds
          } = action;

          if (!action.blocks) {
            return state;
          }

          const mappedBlocks = mapBlockOrder(action.blocks);
          const newState = new Map(state);
          action.replacedClientIds.forEach(clientId => {
            newState.delete(clientId);
          });
          mappedBlocks.forEach((order, clientId) => {
            if (clientId !== '') {
              newState.set(clientId, order);
            }
          });
          newState.forEach((order, clientId) => {
            const newSubOrder = Object.values(order).reduce((result, subClientId) => {
              if (subClientId === clientIds[0]) {
                return [...result, ...mappedBlocks.get('')];
              }

              if (clientIds.indexOf(subClientId) === -1) {
                result.push(subClientId);
              }

              return result;
            }, []);
            newState.set(clientId, newSubOrder);
          });
          return newState;
        }

      case 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        {
          const newState = new Map(state); // Remove inner block ordering for removed blocks.

          action.removedClientIds.forEach(clientId => {
            newState.delete(clientId);
          });
          newState.forEach((order, clientId) => {
            var _order$filter;

            const newSubOrder = (_order$filter = order === null || order === void 0 ? void 0 : order.filter(id => !action.removedClientIds.includes(id))) !== null && _order$filter !== void 0 ? _order$filter : [];

            if (newSubOrder.length !== order.length) {
              newState.set(clientId, newSubOrder);
            }
          });
          return newState;
        }
    }

    return state;
  },

  // While technically redundant data as the inverse of `order`, it serves as
  // an optimization for the selectors which derive the ancestry of a block.
  parents() {
    let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new Map();
    let action = arguments.length > 1 ? arguments[1] : undefined;

    switch (action.type) {
      case 'RECEIVE_BLOCKS':
        {
          const newState = new Map(state);
          mapBlockParents(action.blocks).forEach(_ref7 => {
            let [key, value] = _ref7;
            newState.set(key, value);
          });
          return newState;
        }

      case 'INSERT_BLOCKS':
        {
          const newState = new Map(state);
          mapBlockParents(action.blocks, action.rootClientId || '').forEach(_ref8 => {
            let [key, value] = _ref8;
            newState.set(key, value);
          });
          return newState;
        }

      case 'MOVE_BLOCKS_TO_POSITION':
        {
          const newState = new Map(state);
          action.clientIds.forEach(id => {
            newState.set(id, action.toRootClientId || '');
          });
          return newState;
        }

      case 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        {
          const newState = new Map(state);
          action.replacedClientIds.forEach(clientId => {
            newState.delete(clientId);
          });
          mapBlockParents(action.blocks, state.get(action.clientIds[0])).forEach(_ref9 => {
            let [key, value] = _ref9;
            newState.set(key, value);
          });
          return newState;
        }

      case 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        {
          const newState = new Map(state);
          action.removedClientIds.forEach(clientId => {
            newState.delete(clientId);
          });
          return newState;
        }
    }

    return state;
  },

  controlledInnerBlocks() {
    let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    let {
      type,
      clientId,
      hasControlledInnerBlocks
    } = arguments.length > 1 ? arguments[1] : undefined;

    if (type === 'SET_HAS_CONTROLLED_INNER_BLOCKS') {
      return { ...state,
        [clientId]: hasControlledInnerBlocks
      };
    }

    return state;
  }

});
/**
 * Reducer returning visibility status of block interface.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */

function isBlockInterfaceHidden() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'HIDE_BLOCK_INTERFACE':
      return true;

    case 'SHOW_BLOCK_INTERFACE':
      return false;
  }

  return state;
}
/**
 * Reducer returning typing state.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */

function isTyping() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'START_TYPING':
      return true;

    case 'STOP_TYPING':
      return false;
  }

  return state;
}
/**
 * Reducer returning dragged block client id.
 *
 * @param {string[]} state  Current state.
 * @param {Object}   action Dispatched action.
 *
 * @return {string[]} Updated state.
 */

function draggedBlocks() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'START_DRAGGING_BLOCKS':
      return action.clientIds;

    case 'STOP_DRAGGING_BLOCKS':
      return [];
  }

  return state;
}
/**
 * Reducer tracking the visible blocks.
 *
 * @param {Record<string,boolean>} state  Current state.
 * @param {Object}                 action Dispatched action.
 *
 * @return {Record<string,boolean>} Block visibility.
 */

function blockVisibility() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;

  if (action.type === 'SET_BLOCK_VISIBILITY') {
    return { ...state,
      ...action.updates
    };
  }

  return state;
}
/**
 * Internal helper reducer for selectionStart and selectionEnd. Can hold a block
 * selection, represented by an object with property clientId.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */

function selectionHelper() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'CLEAR_SELECTED_BLOCK':
      {
        if (state.clientId) {
          return {};
        }

        return state;
      }

    case 'SELECT_BLOCK':
      if (action.clientId === state.clientId) {
        return state;
      }

      return {
        clientId: action.clientId
      };

    case 'REPLACE_INNER_BLOCKS':
    case 'INSERT_BLOCKS':
      {
        if (!action.updateSelection || !action.blocks.length) {
          return state;
        }

        return {
          clientId: action.blocks[0].clientId
        };
      }

    case 'REMOVE_BLOCKS':
      if (!action.clientIds || !action.clientIds.length || action.clientIds.indexOf(state.clientId) === -1) {
        return state;
      }

      return {};

    case 'REPLACE_BLOCKS':
      {
        if (action.clientIds.indexOf(state.clientId) === -1) {
          return state;
        }

        const blockToSelect = action.blocks[action.indexToSelect] || action.blocks[action.blocks.length - 1];

        if (!blockToSelect) {
          return {};
        }

        if (blockToSelect.clientId === state.clientId) {
          return state;
        }

        return {
          clientId: blockToSelect.clientId
        };
      }
  }

  return state;
}
/**
 * Reducer returning the selection state.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */


function selection() {
  var _state$selectionStart, _state$selectionEnd, _state$selectionStart2, _state$selectionEnd2;

  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'SELECTION_CHANGE':
      if (action.clientId) {
        return {
          selectionStart: {
            clientId: action.clientId,
            attributeKey: action.attributeKey,
            offset: action.startOffset
          },
          selectionEnd: {
            clientId: action.clientId,
            attributeKey: action.attributeKey,
            offset: action.endOffset
          }
        };
      }

      return {
        selectionStart: action.start || state.selectionStart,
        selectionEnd: action.end || state.selectionEnd
      };

    case 'RESET_SELECTION':
      const {
        selectionStart,
        selectionEnd
      } = action;
      return {
        selectionStart,
        selectionEnd
      };

    case 'MULTI_SELECT':
      const {
        start,
        end
      } = action;

      if (start === ((_state$selectionStart = state.selectionStart) === null || _state$selectionStart === void 0 ? void 0 : _state$selectionStart.clientId) && end === ((_state$selectionEnd = state.selectionEnd) === null || _state$selectionEnd === void 0 ? void 0 : _state$selectionEnd.clientId)) {
        return state;
      }

      return {
        selectionStart: {
          clientId: start
        },
        selectionEnd: {
          clientId: end
        }
      };

    case 'RESET_BLOCKS':
      const startClientId = state === null || state === void 0 ? void 0 : (_state$selectionStart2 = state.selectionStart) === null || _state$selectionStart2 === void 0 ? void 0 : _state$selectionStart2.clientId;
      const endClientId = state === null || state === void 0 ? void 0 : (_state$selectionEnd2 = state.selectionEnd) === null || _state$selectionEnd2 === void 0 ? void 0 : _state$selectionEnd2.clientId; // Do nothing if there's no selected block.

      if (!startClientId && !endClientId) {
        return state;
      } // If the start of the selection won't exist after reset, remove selection.


      if (!action.blocks.some(block => block.clientId === startClientId)) {
        return {
          selectionStart: {},
          selectionEnd: {}
        };
      } // If the end of the selection won't exist after reset, collapse selection.


      if (!action.blocks.some(block => block.clientId === endClientId)) {
        return { ...state,
          selectionEnd: state.selectionStart
        };
      }

  }

  return {
    selectionStart: selectionHelper(state.selectionStart, action),
    selectionEnd: selectionHelper(state.selectionEnd, action)
  };
}
/**
 * Reducer returning whether the user is multi-selecting.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */

function isMultiSelecting() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'START_MULTI_SELECT':
      return true;

    case 'STOP_MULTI_SELECT':
      return false;
  }

  return state;
}
/**
 * Reducer returning whether selection is enabled.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */

function isSelectionEnabled() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'TOGGLE_SELECTION':
      return action.isSelectionEnabled;
  }

  return state;
}
/**
 * Reducer returning the initial block selection.
 *
 * Currently this in only used to restore the selection after block deletion and
 * pasting new content.This reducer should eventually be removed in favour of setting
 * selection directly.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {number|null} Initial position: 0, -1 or null.
 */

function initialPosition() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  if (action.type === 'REPLACE_BLOCKS' && action.initialPosition !== undefined) {
    return action.initialPosition;
  } else if (['MULTI_SELECT', 'SELECT_BLOCK', 'RESET_SELECTION', 'INSERT_BLOCKS', 'REPLACE_INNER_BLOCKS'].includes(action.type)) {
    return action.initialPosition;
  }

  return state;
}
function blocksMode() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;

  if (action.type === 'TOGGLE_BLOCK_MODE') {
    const {
      clientId
    } = action;
    return { ...state,
      [clientId]: state[clientId] && state[clientId] === 'html' ? 'visual' : 'html'
    };
  }

  return state;
}
/**
 * Reducer returning the block insertion point visibility, either null if there
 * is not an explicit insertion point assigned, or an object of its `index` and
 * `rootClientId`.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */

function insertionPoint() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'SHOW_INSERTION_POINT':
      {
        const {
          rootClientId,
          index,
          __unstableWithInserter,
          operation
        } = action;
        const nextState = {
          rootClientId,
          index,
          __unstableWithInserter,
          operation
        }; // Bail out updates if the states are the same.

        return es6_default()(state, nextState) ? state : nextState;
      }

    case 'HIDE_INSERTION_POINT':
      return null;
  }

  return state;
}
/**
 * Reducer returning whether the post blocks match the defined template or not.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {boolean} Updated state.
 */

function template() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
    isValid: true
  };
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'SET_TEMPLATE_VALIDITY':
      return { ...state,
        isValid: action.isValid
      };
  }

  return state;
}
/**
 * Reducer returning the editor setting.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */

function settings() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : SETTINGS_DEFAULTS;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'UPDATE_SETTINGS':
      return { ...state,
        ...action.settings
      };
  }

  return state;
}
/**
 * Reducer returning the user preferences.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {string} Updated state.
 */

function preferences() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : PREFERENCES_DEFAULTS;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'INSERT_BLOCKS':
    case 'REPLACE_BLOCKS':
      return action.blocks.reduce((prevState, block) => {
        const {
          attributes,
          name: blockName
        } = block;
        const match = (0,external_wp_data_namespaceObject.select)(external_wp_blocks_namespaceObject.store).getActiveBlockVariation(blockName, attributes); // If a block variation match is found change the name to be the same with the
        // one that is used for block variations in the Inserter (`getItemFromVariation`).

        let id = match !== null && match !== void 0 && match.name ? `${blockName}/${match.name}` : blockName;
        const insert = {
          name: id
        };

        if (blockName === 'core/block') {
          insert.ref = attributes.ref;
          id += '/' + attributes.ref;
        }

        return { ...prevState,
          insertUsage: { ...prevState.insertUsage,
            [id]: {
              time: action.time,
              count: prevState.insertUsage[id] ? prevState.insertUsage[id].count + 1 : 1,
              insert
            }
          }
        };
      }, state);
  }

  return state;
}
/**
 * Reducer returning an object where each key is a block client ID, its value
 * representing the settings for its nested blocks.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */

const blockListSettings = function () {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    // Even if the replaced blocks have the same client ID, our logic
    // should correct the state.
    case 'REPLACE_BLOCKS':
    case 'REMOVE_BLOCKS':
      {
        return Object.fromEntries(Object.entries(state).filter(_ref10 => {
          let [id] = _ref10;
          return !action.clientIds.includes(id);
        }));
      }

    case 'UPDATE_BLOCK_LIST_SETTINGS':
      {
        const {
          clientId
        } = action;

        if (!action.settings) {
          if (state.hasOwnProperty(clientId)) {
            const {
              [clientId]: removedBlock,
              ...restBlocks
            } = state;
            return restBlocks;
          }

          return state;
        }

        if (es6_default()(state[clientId], action.settings)) {
          return state;
        }

        return { ...state,
          [clientId]: action.settings
        };
      }
  }

  return state;
};
/**
 * Reducer returning which mode is enabled.
 *
 * @param {string} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {string} Updated state.
 */

function editorMode() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'edit';
  let action = arguments.length > 1 ? arguments[1] : undefined;

  // Let inserting block in navigation mode always trigger Edit mode.
  if (action.type === 'INSERT_BLOCKS' && state === 'navigation') {
    return 'edit';
  }

  if (action.type === 'SET_EDITOR_MODE') {
    return action.mode;
  }

  return state;
}
/**
 * Reducer returning whether the block moving mode is enabled or not.
 *
 * @param {string|null} state  Current state.
 * @param {Object}      action Dispatched action.
 *
 * @return {string|null} Updated state.
 */

function hasBlockMovingClientId() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  if (action.type === 'SET_BLOCK_MOVING_MODE') {
    return action.hasBlockMovingClientId;
  }

  if (action.type === 'SET_EDITOR_MODE') {
    return null;
  }

  return state;
}
/**
 * Reducer return an updated state representing the most recent block attribute
 * update. The state is structured as an object where the keys represent the
 * client IDs of blocks, the values a subset of attributes from the most recent
 * block update. The state is always reset to null if the last action is
 * anything other than an attributes update.
 *
 * @param {Object<string,Object>} state  Current state.
 * @param {Object}                action Action object.
 *
 * @return {[string,Object]} Updated state.
 */

function lastBlockAttributesChange() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'UPDATE_BLOCK':
      if (!action.updates.attributes) {
        break;
      }

      return {
        [action.clientId]: action.updates.attributes
      };

    case 'UPDATE_BLOCK_ATTRIBUTES':
      return action.clientIds.reduce((accumulator, id) => ({ ...accumulator,
        [id]: action.uniqueByBlock ? action.attributes[id] : action.attributes
      }), {});
  }

  return state;
}
/**
 * Reducer returning automatic change state.
 *
 * @param {?string} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {string | undefined} Updated state.
 */

function automaticChangeStatus(state, action) {
  switch (action.type) {
    case 'MARK_AUTOMATIC_CHANGE':
      return 'pending';

    case 'MARK_AUTOMATIC_CHANGE_FINAL':
      if (state === 'pending') {
        return 'final';
      }

      return;

    case 'SELECTION_CHANGE':
      // As long as the state is not final, ignore any selection changes.
      if (state !== 'final') {
        return state;
      }

      return;
    // Undoing an automatic change should still be possible after mouse
    // move or after visibility change.

    case 'SET_BLOCK_VISIBILITY':
    case 'START_TYPING':
    case 'STOP_TYPING':
    case 'UPDATE_BLOCK_LIST_SETTINGS':
      return state;
  } // TODO: This is a source of bug, as each time there's a change in timing,
  // or a new action is added, this could break.
  // Reset the state by default (for any action not handled).

}
/**
 * Reducer returning current highlighted block.
 *
 * @param {boolean} state  Current highlighted block.
 * @param {Object}  action Dispatched action.
 *
 * @return {string} Updated state.
 */

function highlightedBlock(state, action) {
  switch (action.type) {
    case 'TOGGLE_BLOCK_HIGHLIGHT':
      const {
        clientId,
        isHighlighted
      } = action;

      if (isHighlighted) {
        return clientId;
      } else if (state === clientId) {
        return null;
      }

      return state;

    case 'SELECT_BLOCK':
      if (action.clientId !== state) {
        return null;
      }

  }

  return state;
}
/**
 * Reducer returning the block insertion event list state.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */

function lastBlockInserted() {
  var _action$meta;

  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'INSERT_BLOCKS':
    case 'REPLACE_BLOCKS':
    case 'REPLACE_INNER_BLOCKS':
      if (!action.blocks.length) {
        return state;
      }

      const clientIds = action.blocks.map(block => {
        return block.clientId;
      });
      const source = (_action$meta = action.meta) === null || _action$meta === void 0 ? void 0 : _action$meta.source;
      return {
        clientIds,
        source
      };

    case 'RESET_BLOCKS':
      return {};
  }

  return state;
}
/**
 * Reducer returning the block that is eding temporarily edited as blocks.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */

function temporarilyEditingAsBlocks() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  let action = arguments.length > 1 ? arguments[1] : undefined;

  if (action.type === 'SET_TEMPORARILY_EDITING_AS_BLOCKS') {
    return action.temporarilyEditingAsBlocks;
  }

  return state;
}
/* harmony default export */ var reducer = ((0,external_wp_data_namespaceObject.combineReducers)({
  blocks,
  isTyping,
  isBlockInterfaceHidden,
  draggedBlocks,
  selection,
  isMultiSelecting,
  isSelectionEnabled,
  initialPosition,
  blocksMode,
  blockListSettings,
  insertionPoint,
  template,
  settings,
  preferences,
  lastBlockAttributesChange,
  editorMode,
  hasBlockMovingClientId,
  automaticChangeStatus,
  highlightedBlock,
  lastBlockInserted,
  temporarilyEditingAsBlocks,
  blockVisibility
}));

;// CONCATENATED MODULE: ./node_modules/rememo/rememo.js


/** @typedef {(...args: any[]) => *[]} GetDependants */

/** @typedef {() => void} Clear */

/**
 * @typedef {{
 *   getDependants: GetDependants,
 *   clear: Clear
 * }} EnhancedSelector
 */

/**
 * Internal cache entry.
 *
 * @typedef CacheNode
 *
 * @property {?CacheNode|undefined} [prev] Previous node.
 * @property {?CacheNode|undefined} [next] Next node.
 * @property {*[]} args Function arguments for cache entry.
 * @property {*} val Function result.
 */

/**
 * @typedef Cache
 *
 * @property {Clear} clear Function to clear cache.
 * @property {boolean} [isUniqueByDependants] Whether dependants are valid in
 * considering cache uniqueness. A cache is unique if dependents are all arrays
 * or objects.
 * @property {CacheNode?} [head] Cache head.
 * @property {*[]} [lastDependants] Dependants from previous invocation.
 */

/**
 * Arbitrary value used as key for referencing cache object in WeakMap tree.
 *
 * @type {{}}
 */
var LEAF_KEY = {};

/**
 * Returns the first argument as the sole entry in an array.
 *
 * @template T
 *
 * @param {T} value Value to return.
 *
 * @return {[T]} Value returned as entry in array.
 */
function arrayOf(value) {
	return [value];
}

/**
 * Returns true if the value passed is object-like, or false otherwise. A value
 * is object-like if it can support property assignment, e.g. object or array.
 *
 * @param {*} value Value to test.
 *
 * @return {boolean} Whether value is object-like.
 */
function isObjectLike(value) {
	return !!value && 'object' === typeof value;
}

/**
 * Creates and returns a new cache object.
 *
 * @return {Cache} Cache object.
 */
function createCache() {
	/** @type {Cache} */
	var cache = {
		clear: function () {
			cache.head = null;
		},
	};

	return cache;
}

/**
 * Returns true if entries within the two arrays are strictly equal by
 * reference from a starting index.
 *
 * @param {*[]} a First array.
 * @param {*[]} b Second array.
 * @param {number} fromIndex Index from which to start comparison.
 *
 * @return {boolean} Whether arrays are shallowly equal.
 */
function isShallowEqual(a, b, fromIndex) {
	var i;

	if (a.length !== b.length) {
		return false;
	}

	for (i = fromIndex; i < a.length; i++) {
		if (a[i] !== b[i]) {
			return false;
		}
	}

	return true;
}

/**
 * Returns a memoized selector function. The getDependants function argument is
 * called before the memoized selector and is expected to return an immutable
 * reference or array of references on which the selector depends for computing
 * its own return value. The memoize cache is preserved only as long as those
 * dependant references remain the same. If getDependants returns a different
 * reference(s), the cache is cleared and the selector value regenerated.
 *
 * @template {(...args: *[]) => *} S
 *
 * @param {S} selector Selector function.
 * @param {GetDependants=} getDependants Dependant getter returning an array of
 * references used in cache bust consideration.
 */
/* harmony default export */ function rememo(selector, getDependants) {
	/** @type {WeakMap<*,*>} */
	var rootCache;

	/** @type {GetDependants} */
	var normalizedGetDependants = getDependants ? getDependants : arrayOf;

	/**
	 * Returns the cache for a given dependants array. When possible, a WeakMap
	 * will be used to create a unique cache for each set of dependants. This
	 * is feasible due to the nature of WeakMap in allowing garbage collection
	 * to occur on entries where the key object is no longer referenced. Since
	 * WeakMap requires the key to be an object, this is only possible when the
	 * dependant is object-like. The root cache is created as a hierarchy where
	 * each top-level key is the first entry in a dependants set, the value a
	 * WeakMap where each key is the next dependant, and so on. This continues
	 * so long as the dependants are object-like. If no dependants are object-
	 * like, then the cache is shared across all invocations.
	 *
	 * @see isObjectLike
	 *
	 * @param {*[]} dependants Selector dependants.
	 *
	 * @return {Cache} Cache object.
	 */
	function getCache(dependants) {
		var caches = rootCache,
			isUniqueByDependants = true,
			i,
			dependant,
			map,
			cache;

		for (i = 0; i < dependants.length; i++) {
			dependant = dependants[i];

			// Can only compose WeakMap from object-like key.
			if (!isObjectLike(dependant)) {
				isUniqueByDependants = false;
				break;
			}

			// Does current segment of cache already have a WeakMap?
			if (caches.has(dependant)) {
				// Traverse into nested WeakMap.
				caches = caches.get(dependant);
			} else {
				// Create, set, and traverse into a new one.
				map = new WeakMap();
				caches.set(dependant, map);
				caches = map;
			}
		}

		// We use an arbitrary (but consistent) object as key for the last item
		// in the WeakMap to serve as our running cache.
		if (!caches.has(LEAF_KEY)) {
			cache = createCache();
			cache.isUniqueByDependants = isUniqueByDependants;
			caches.set(LEAF_KEY, cache);
		}

		return caches.get(LEAF_KEY);
	}

	/**
	 * Resets root memoization cache.
	 */
	function clear() {
		rootCache = new WeakMap();
	}

	/* eslint-disable jsdoc/check-param-names */
	/**
	 * The augmented selector call, considering first whether dependants have
	 * changed before passing it to underlying memoize function.
	 *
	 * @param {*}    source    Source object for derivation.
	 * @param {...*} extraArgs Additional arguments to pass to selector.
	 *
	 * @return {*} Selector result.
	 */
	/* eslint-enable jsdoc/check-param-names */
	function callSelector(/* source, ...extraArgs */) {
		var len = arguments.length,
			cache,
			node,
			i,
			args,
			dependants;

		// Create copy of arguments (avoid leaking deoptimization).
		args = new Array(len);
		for (i = 0; i < len; i++) {
			args[i] = arguments[i];
		}

		dependants = normalizedGetDependants.apply(null, args);
		cache = getCache(dependants);

		// If not guaranteed uniqueness by dependants (primitive type), shallow
		// compare against last dependants and, if references have changed,
		// destroy cache to recalculate result.
		if (!cache.isUniqueByDependants) {
			if (
				cache.lastDependants &&
				!isShallowEqual(dependants, cache.lastDependants, 0)
			) {
				cache.clear();
			}

			cache.lastDependants = dependants;
		}

		node = cache.head;
		while (node) {
			// Check whether node arguments match arguments
			if (!isShallowEqual(node.args, args, 1)) {
				node = node.next;
				continue;
			}

			// At this point we can assume we've found a match

			// Surface matched node to head if not already
			if (node !== cache.head) {
				// Adjust siblings to point to each other.
				/** @type {CacheNode} */ (node.prev).next = node.next;
				if (node.next) {
					node.next.prev = node.prev;
				}

				node.next = cache.head;
				node.prev = null;
				/** @type {CacheNode} */ (cache.head).prev = node;
				cache.head = node;
			}

			// Return immediately
			return node.val;
		}

		// No cached value found. Continue to insertion phase:

		node = /** @type {CacheNode} */ ({
			// Generate the result from original function
			val: selector.apply(null, args),
		});

		// Avoid including the source object in the cache.
		args[0] = null;
		node.args = args;

		// Don't need to check whether node is already head, since it would
		// have been returned above already if it was

		// Shift existing head down list
		if (cache.head) {
			cache.head.prev = node;
			node.next = cache.head;
		}

		cache.head = node;

		return node.val;
	}

	callSelector.getDependants = normalizedGetDependants;
	callSelector.clear = clear;
	clear();

	return /** @type {S & EnhancedSelector} */ (callSelector);
}

;// CONCATENATED MODULE: external ["wp","primitives"]
var external_wp_primitives_namespaceObject = window["wp"]["primitives"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/symbol.js


/**
 * WordPress dependencies
 */

const symbol = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M21.3 10.8l-5.6-5.6c-.7-.7-1.8-.7-2.5 0l-5.6 5.6c-.7.7-.7 1.8 0 2.5l5.6 5.6c.3.3.8.5 1.2.5s.9-.2 1.2-.5l5.6-5.6c.8-.7.8-1.9.1-2.5zm-1 1.4l-5.6 5.6c-.1.1-.3.1-.4 0l-5.6-5.6c-.1-.1-.1-.3 0-.4l5.6-5.6s.1-.1.2-.1.1 0 .2.1l5.6 5.6c.1.1.1.3 0 .4zm-16.6-.4L10 5.5l-1-1-6.3 6.3c-.7.7-.7 1.8 0 2.5L9 19.5l1.1-1.1-6.3-6.3c-.2 0-.2-.2-.1-.3z"
}));
/* harmony default export */ var library_symbol = (symbol);

;// CONCATENATED MODULE: external ["wp","richText"]
var external_wp_richText_namespaceObject = window["wp"]["richText"];
;// CONCATENATED MODULE: external ["wp","deprecated"]
var external_wp_deprecated_namespaceObject = window["wp"]["deprecated"];
var external_wp_deprecated_default = /*#__PURE__*/__webpack_require__.n(external_wp_deprecated_namespaceObject);
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/utils.js
/**
 * Helper function that maps attribute definition properties to the
 * ones used by RichText utils like `create, toHTMLString, etc..`.
 *
 * @param {Object} attributeDefinition A block's attribute definition object.
 * @return {Object} The mapped object.
 */
function mapRichTextSettings(attributeDefinition) {
  const {
    multiline: multilineTag,
    __unstableMultilineWrapperTags: multilineWrapperTags,
    __unstablePreserveWhiteSpace: preserveWhiteSpace
  } = attributeDefinition;
  return {
    multilineTag,
    multilineWrapperTags,
    preserveWhiteSpace
  };
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/utils/sorting.js
/**
 * Recursive stable sorting comparator function.
 *
 * @param {string|Function} field Field to sort by.
 * @param {Array}           items Items to sort.
 * @param {string}          order Order, 'asc' or 'desc'.
 * @return {Function} Comparison function to be used in a `.sort()`.
 */
const comparator = (field, items, order) => {
  return (a, b) => {
    let cmpA, cmpB;

    if (typeof field === 'function') {
      cmpA = field(a);
      cmpB = field(b);
    } else {
      cmpA = a[field];
      cmpB = b[field];
    }

    if (cmpA > cmpB) {
      return order === 'asc' ? 1 : -1;
    } else if (cmpB > cmpA) {
      return order === 'asc' ? -1 : 1;
    }

    const orderA = items.findIndex(item => item === a);
    const orderB = items.findIndex(item => item === b); // Stable sort: maintaining original array order

    if (orderA > orderB) {
      return 1;
    } else if (orderB > orderA) {
      return -1;
    }

    return 0;
  };
};
/**
 * Order items by a certain key.
 * Supports decorator functions that allow complex picking of a comparison field.
 * Sorts in ascending order by default, but supports descending as well.
 * Stable sort - maintains original order of equal items.
 *
 * @param {Array}           items Items to order.
 * @param {string|Function} field Field to order by.
 * @param {string}          order Sorting order, `asc` or `desc`.
 * @return {Array} Sorted items.
 */


function orderBy(items, field) {
  let order = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'asc';
  return items.concat().sort(comparator(field, items, order));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/selectors.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */








/**
 * Internal dependencies
 */



/**
 * A block selection object.
 *
 * @typedef {Object} WPBlockSelection
 *
 * @property {string} clientId     A block client ID.
 * @property {string} attributeKey A block attribute key.
 * @property {number} offset       An attribute value offset, based on the rich
 *                                 text value. See `wp.richText.create`.
 */
// Module constants.

const MILLISECONDS_PER_HOUR = 3600 * 1000;
const MILLISECONDS_PER_DAY = 24 * 3600 * 1000;
const MILLISECONDS_PER_WEEK = 7 * 24 * 3600 * 1000;
/**
 * Shared reference to an empty array for cases where it is important to avoid
 * returning a new array reference on every invocation, as in a connected or
 * other pure component which performs `shouldComponentUpdate` check on props.
 * This should be used as a last resort, since the normalized data should be
 * maintained by the reducer result in state.
 *
 * @type {Array}
 */

const EMPTY_ARRAY = [];
/**
 * Returns a block's name given its client ID, or null if no block exists with
 * the client ID.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {string} Block name.
 */

function getBlockName(state, clientId) {
  const block = state.blocks.byClientId.get(clientId);
  const socialLinkName = 'core/social-link';

  if (external_wp_element_namespaceObject.Platform.OS !== 'web' && (block === null || block === void 0 ? void 0 : block.name) === socialLinkName) {
    const attributes = state.blocks.attributes.get(clientId);
    const {
      service
    } = attributes !== null && attributes !== void 0 ? attributes : {};
    return service ? `${socialLinkName}-${service}` : socialLinkName;
  }

  return block ? block.name : null;
}
/**
 * Returns whether a block is valid or not.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Is Valid.
 */

function isBlockValid(state, clientId) {
  const block = state.blocks.byClientId.get(clientId);
  return !!block && block.isValid;
}
/**
 * Returns a block's attributes given its client ID, or null if no block exists with
 * the client ID.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {Object?} Block attributes.
 */

function getBlockAttributes(state, clientId) {
  const block = state.blocks.byClientId.get(clientId);

  if (!block) {
    return null;
  }

  return state.blocks.attributes.get(clientId);
}
/**
 * Returns a block given its client ID. This is a parsed copy of the block,
 * containing its `blockName`, `clientId`, and current `attributes` state. This
 * is not the block's registration settings, which must be retrieved from the
 * blocks module registration store.
 *
 * getBlock recurses through its inner blocks until all its children blocks have
 * been retrieved. Note that getBlock will not return the child inner blocks of
 * an inner block controller. This is because an inner block controller syncs
 * itself with its own entity, and should therefore not be included with the
 * blocks of a different entity. For example, say you call `getBlocks( TP )` to
 * get the blocks of a template part. If another template part is a child of TP,
 * then the nested template part's child blocks will not be returned. This way,
 * the template block itself is considered part of the parent, but the children
 * are not.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {Object} Parsed block object.
 */

function getBlock(state, clientId) {
  if (!state.blocks.byClientId.has(clientId)) {
    return null;
  }

  return state.blocks.tree.get(clientId);
}
const __unstableGetBlockWithoutInnerBlocks = rememo((state, clientId) => {
  if (!state.blocks.byClientId.has(clientId)) {
    return null;
  }

  return { ...state.blocks.byClientId.get(clientId),
    attributes: getBlockAttributes(state, clientId)
  };
}, (state, clientId) => [state.blocks.byClientId.get(clientId), state.blocks.attributes.get(clientId)]);
/**
 * Returns all block objects for the current post being edited as an array in
 * the order they appear in the post. Note that this will exclude child blocks
 * of nested inner block controllers.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {Object[]} Post blocks.
 */

function getBlocks(state, rootClientId) {
  var _state$blocks$tree$ge;

  const treeKey = !rootClientId || !areInnerBlocksControlled(state, rootClientId) ? rootClientId || '' : 'controlled||' + rootClientId;
  return ((_state$blocks$tree$ge = state.blocks.tree.get(treeKey)) === null || _state$blocks$tree$ge === void 0 ? void 0 : _state$blocks$tree$ge.innerBlocks) || EMPTY_ARRAY;
}
/**
 * Returns a stripped down block object containing only its client ID,
 * and its inner blocks' client IDs.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Client ID of the block to get.
 *
 * @return {Object} Client IDs of the post blocks.
 */

const __unstableGetClientIdWithClientIdsTree = rememo((state, clientId) => ({
  clientId,
  innerBlocks: __unstableGetClientIdsTree(state, clientId)
}), state => [state.blocks.order]);
/**
 * Returns the block tree represented in the block-editor store from the
 * given root, consisting of stripped down block objects containing only
 * their client IDs, and their inner blocks' client IDs.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {Object[]} Client IDs of the post blocks.
 */

const __unstableGetClientIdsTree = rememo(function (state) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  return getBlockOrder(state, rootClientId).map(clientId => __unstableGetClientIdWithClientIdsTree(state, clientId));
}, state => [state.blocks.order]);
/**
 * Returns an array containing the clientIds of all descendants of the blocks
 * given. Returned ids are ordered first by the order of the ids given, then
 * by the order that they appear in the editor.
 *
 * @param {Object} state     Global application state.
 * @param {Array}  clientIds Array of blocks to inspect.
 *
 * @return {Array} ids of descendants.
 */

const getClientIdsOfDescendants = rememo((state, clientIds) => {
  const collectedIds = [];

  for (const givenId of clientIds) {
    for (const descendantId of getBlockOrder(state, givenId)) {
      collectedIds.push(descendantId, ...getClientIdsOfDescendants(state, [descendantId]));
    }
  }

  return collectedIds;
}, state => [state.blocks.order]);
/**
 * Returns an array containing the clientIds of the top-level blocks and
 * their descendants of any depth (for nested blocks). Ids are returned
 * in the same order that they appear in the editor.
 *
 * @param {Object} state Global application state.
 *
 * @return {Array} ids of top-level and descendant blocks.
 */

const getClientIdsWithDescendants = rememo(state => {
  const collectedIds = [];

  for (const topLevelId of getBlockOrder(state)) {
    collectedIds.push(topLevelId, ...getClientIdsOfDescendants(state, [topLevelId]));
  }

  return collectedIds;
}, state => [state.blocks.order]);
/**
 * Returns the total number of blocks, or the total number of blocks with a specific name in a post.
 * The number returned includes nested blocks.
 *
 * @param {Object}  state     Global application state.
 * @param {?string} blockName Optional block name, if specified only blocks of that type will be counted.
 *
 * @return {number} Number of blocks in the post, or number of blocks with name equal to blockName.
 */

const getGlobalBlockCount = rememo((state, blockName) => {
  const clientIds = getClientIdsWithDescendants(state);

  if (!blockName) {
    return clientIds.length;
  }

  return clientIds.reduce((accumulator, clientId) => {
    const block = state.blocks.byClientId.get(clientId);
    return block.name === blockName ? accumulator + 1 : accumulator;
  }, 0);
}, state => [state.blocks.order, state.blocks.byClientId]);
/**
 * Returns all global blocks that match a blockName. Results include nested blocks.
 *
 * @param {Object}  state     Global application state.
 * @param {?string} blockName Optional block name, if not specified, returns an empty array.
 *
 * @return {Array} Array of clientIds of blocks with name equal to blockName.
 */

const __experimentalGetGlobalBlocksByName = rememo((state, blockName) => {
  if (!blockName) {
    return EMPTY_ARRAY;
  }

  const clientIds = getClientIdsWithDescendants(state);
  const foundBlocks = clientIds.filter(clientId => {
    const block = state.blocks.byClientId.get(clientId);
    return block.name === blockName;
  });
  return foundBlocks.length > 0 ? foundBlocks : EMPTY_ARRAY;
}, state => [state.blocks.order, state.blocks.byClientId]);
/**
 * Given an array of block client IDs, returns the corresponding array of block
 * objects.
 *
 * @param {Object}   state     Editor state.
 * @param {string[]} clientIds Client IDs for which blocks are to be returned.
 *
 * @return {WPBlock[]} Block objects.
 */

const getBlocksByClientId = rememo((state, clientIds) => (Array.isArray(clientIds) ? clientIds : [clientIds]).map(clientId => getBlock(state, clientId)), (state, clientIds) => (Array.isArray(clientIds) ? clientIds : [clientIds]).map(clientId => state.blocks.tree.get(clientId)));
/**
 * Given an array of block client IDs, returns the corresponding array of block
 * names.
 *
 * @param {Object}   state     Editor state.
 * @param {string[]} clientIds Client IDs for which block names are to be returned.
 *
 * @return {string[]} Block names.
 */

const getBlockNamesByClientId = rememo((state, clientIds) => getBlocksByClientId(state, clientIds).filter(Boolean).map(block => block.name), (state, clientIds) => getBlocksByClientId(state, clientIds));
/**
 * Returns the number of blocks currently present in the post.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {number} Number of blocks in the post.
 */

function getBlockCount(state, rootClientId) {
  return getBlockOrder(state, rootClientId).length;
}
/**
 * Returns the current selection start block client ID, attribute key and text
 * offset.
 *
 * @param {Object} state Block editor state.
 *
 * @return {WPBlockSelection} Selection start information.
 */

function getSelectionStart(state) {
  return state.selection.selectionStart;
}
/**
 * Returns the current selection end block client ID, attribute key and text
 * offset.
 *
 * @param {Object} state Block editor state.
 *
 * @return {WPBlockSelection} Selection end information.
 */

function getSelectionEnd(state) {
  return state.selection.selectionEnd;
}
/**
 * Returns the current block selection start. This value may be null, and it
 * may represent either a singular block selection or multi-selection start.
 * A selection is singular if its start and end match.
 *
 * @param {Object} state Global application state.
 *
 * @return {?string} Client ID of block selection start.
 */

function getBlockSelectionStart(state) {
  return state.selection.selectionStart.clientId;
}
/**
 * Returns the current block selection end. This value may be null, and it
 * may represent either a singular block selection or multi-selection end.
 * A selection is singular if its start and end match.
 *
 * @param {Object} state Global application state.
 *
 * @return {?string} Client ID of block selection end.
 */

function getBlockSelectionEnd(state) {
  return state.selection.selectionEnd.clientId;
}
/**
 * Returns the number of blocks currently selected in the post.
 *
 * @param {Object} state Global application state.
 *
 * @return {number} Number of blocks selected in the post.
 */

function getSelectedBlockCount(state) {
  const multiSelectedBlockCount = getMultiSelectedBlockClientIds(state).length;

  if (multiSelectedBlockCount) {
    return multiSelectedBlockCount;
  }

  return state.selection.selectionStart.clientId ? 1 : 0;
}
/**
 * Returns true if there is a single selected block, or false otherwise.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Whether a single block is selected.
 */

function hasSelectedBlock(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;
  return !!selectionStart.clientId && selectionStart.clientId === selectionEnd.clientId;
}
/**
 * Returns the currently selected block client ID, or null if there is no
 * selected block.
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} Selected block client ID.
 */

function getSelectedBlockClientId(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;
  const {
    clientId
  } = selectionStart;

  if (!clientId || clientId !== selectionEnd.clientId) {
    return null;
  }

  return clientId;
}
/**
 * Returns the currently selected block, or null if there is no selected block.
 *
 * @param {Object} state Global application state.
 *
 * @return {?Object} Selected block.
 */

function getSelectedBlock(state) {
  const clientId = getSelectedBlockClientId(state);
  return clientId ? getBlock(state, clientId) : null;
}
/**
 * Given a block client ID, returns the root block from which the block is
 * nested, an empty string for top-level blocks, or null if the block does not
 * exist.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block from which to find root client ID.
 *
 * @return {?string} Root client ID, if exists
 */

function getBlockRootClientId(state, clientId) {
  return state.blocks.parents.has(clientId) ? state.blocks.parents.get(clientId) : null;
}
/**
 * Given a block client ID, returns the list of all its parents from top to bottom.
 *
 * @param {Object}  state     Editor state.
 * @param {string}  clientId  Block from which to find root client ID.
 * @param {boolean} ascending Order results from bottom to top (true) or top to bottom (false).
 *
 * @return {Array} ClientIDs of the parent blocks.
 */

const getBlockParents = rememo(function (state, clientId) {
  let ascending = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  const parents = [];
  let current = clientId;

  while (!!state.blocks.parents.get(current)) {
    current = state.blocks.parents.get(current);
    parents.push(current);
  }

  return ascending ? parents : parents.reverse();
}, state => [state.blocks.parents]);
/**
 * Given a block client ID and a block name, returns the list of all its parents
 * from top to bottom, filtered by the given name(s). For example, if passed
 * 'core/group' as the blockName, it will only return parents which are group
 * blocks. If passed `[ 'core/group', 'core/cover']`, as the blockName, it will
 * return parents which are group blocks and parents which are cover blocks.
 *
 * @param {Object}          state     Editor state.
 * @param {string}          clientId  Block from which to find root client ID.
 * @param {string|string[]} blockName Block name(s) to filter.
 * @param {boolean}         ascending Order results from bottom to top (true) or top to bottom (false).
 *
 * @return {Array} ClientIDs of the parent blocks.
 */

const getBlockParentsByBlockName = rememo(function (state, clientId, blockName) {
  let ascending = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
  const parents = getBlockParents(state, clientId, ascending);
  return parents.map(id => ({
    id,
    name: getBlockName(state, id)
  })).filter(_ref => {
    let {
      name
    } = _ref;

    if (Array.isArray(blockName)) {
      return blockName.includes(name);
    }

    return name === blockName;
  }).map(_ref2 => {
    let {
      id
    } = _ref2;
    return id;
  });
}, state => [state.blocks.parents]);
/**
 * Given a block client ID, returns the root of the hierarchy from which the block is nested, return the block itself for root level blocks.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block from which to find root client ID.
 *
 * @return {string} Root client ID
 */

function getBlockHierarchyRootClientId(state, clientId) {
  let current = clientId;
  let parent;

  do {
    parent = current;
    current = state.blocks.parents.get(current);
  } while (current);

  return parent;
}
/**
 * Given a block client ID, returns the lowest common ancestor with selected client ID.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block from which to find common ancestor client ID.
 *
 * @return {string} Common ancestor client ID or undefined
 */

function getLowestCommonAncestorWithSelectedBlock(state, clientId) {
  const selectedId = getSelectedBlockClientId(state);
  const clientParents = [...getBlockParents(state, clientId), clientId];
  const selectedParents = [...getBlockParents(state, selectedId), selectedId];
  let lowestCommonAncestor;
  const maxDepth = Math.min(clientParents.length, selectedParents.length);

  for (let index = 0; index < maxDepth; index++) {
    if (clientParents[index] === selectedParents[index]) {
      lowestCommonAncestor = clientParents[index];
    } else {
      break;
    }
  }

  return lowestCommonAncestor;
}
/**
 * Returns the client ID of the block adjacent one at the given reference
 * startClientId and modifier directionality. Defaults start startClientId to
 * the selected block, and direction as next block. Returns null if there is no
 * adjacent block.
 *
 * @param {Object}  state         Editor state.
 * @param {?string} startClientId Optional client ID of block from which to
 *                                search.
 * @param {?number} modifier      Directionality multiplier (1 next, -1
 *                                previous).
 *
 * @return {?string} Return the client ID of the block, or null if none exists.
 */

function getAdjacentBlockClientId(state, startClientId) {
  let modifier = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;

  // Default to selected block.
  if (startClientId === undefined) {
    startClientId = getSelectedBlockClientId(state);
  } // Try multi-selection starting at extent based on modifier.


  if (startClientId === undefined) {
    if (modifier < 0) {
      startClientId = getFirstMultiSelectedBlockClientId(state);
    } else {
      startClientId = getLastMultiSelectedBlockClientId(state);
    }
  } // Validate working start client ID.


  if (!startClientId) {
    return null;
  } // Retrieve start block root client ID, being careful to allow the falsey
  // empty string top-level root by explicitly testing against null.


  const rootClientId = getBlockRootClientId(state, startClientId);

  if (rootClientId === null) {
    return null;
  }

  const {
    order
  } = state.blocks;
  const orderSet = order.get(rootClientId);
  const index = orderSet.indexOf(startClientId);
  const nextIndex = index + 1 * modifier; // Block was first in set and we're attempting to get previous.

  if (nextIndex < 0) {
    return null;
  } // Block was last in set and we're attempting to get next.


  if (nextIndex === orderSet.length) {
    return null;
  } // Assume incremented index is within the set.


  return orderSet[nextIndex];
}
/**
 * Returns the previous block's client ID from the given reference start ID.
 * Defaults start to the selected block. Returns null if there is no previous
 * block.
 *
 * @param {Object}  state         Editor state.
 * @param {?string} startClientId Optional client ID of block from which to
 *                                search.
 *
 * @return {?string} Adjacent block's client ID, or null if none exists.
 */

function getPreviousBlockClientId(state, startClientId) {
  return getAdjacentBlockClientId(state, startClientId, -1);
}
/**
 * Returns the next block's client ID from the given reference start ID.
 * Defaults start to the selected block. Returns null if there is no next
 * block.
 *
 * @param {Object}  state         Editor state.
 * @param {?string} startClientId Optional client ID of block from which to
 *                                search.
 *
 * @return {?string} Adjacent block's client ID, or null if none exists.
 */

function getNextBlockClientId(state, startClientId) {
  return getAdjacentBlockClientId(state, startClientId, 1);
}
/* eslint-disable jsdoc/valid-types */

/**
 * Returns the initial caret position for the selected block.
 * This position is to used to position the caret properly when the selected block changes.
 * If the current block is not a RichText, having initial position set to 0 means "focus block"
 *
 * @param {Object} state Global application state.
 *
 * @return {0|-1|null} Initial position.
 */

function getSelectedBlocksInitialCaretPosition(state) {
  /* eslint-enable jsdoc/valid-types */
  return state.initialPosition;
}
/**
 * Returns the current selection set of block client IDs (multiselection or single selection).
 *
 * @param {Object} state Editor state.
 *
 * @return {Array} Multi-selected block client IDs.
 */

const getSelectedBlockClientIds = rememo(state => {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;

  if (!selectionStart.clientId || !selectionEnd.clientId) {
    return EMPTY_ARRAY;
  }

  if (selectionStart.clientId === selectionEnd.clientId) {
    return [selectionStart.clientId];
  } // Retrieve root client ID to aid in retrieving relevant nested block
  // order, being careful to allow the falsey empty string top-level root
  // by explicitly testing against null.


  const rootClientId = getBlockRootClientId(state, selectionStart.clientId);

  if (rootClientId === null) {
    return EMPTY_ARRAY;
  }

  const blockOrder = getBlockOrder(state, rootClientId);
  const startIndex = blockOrder.indexOf(selectionStart.clientId);
  const endIndex = blockOrder.indexOf(selectionEnd.clientId);

  if (startIndex > endIndex) {
    return blockOrder.slice(endIndex, startIndex + 1);
  }

  return blockOrder.slice(startIndex, endIndex + 1);
}, state => [state.blocks.order, state.selection.selectionStart.clientId, state.selection.selectionEnd.clientId]);
/**
 * Returns the current multi-selection set of block client IDs, or an empty
 * array if there is no multi-selection.
 *
 * @param {Object} state Editor state.
 *
 * @return {Array} Multi-selected block client IDs.
 */

function getMultiSelectedBlockClientIds(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;

  if (selectionStart.clientId === selectionEnd.clientId) {
    return EMPTY_ARRAY;
  }

  return getSelectedBlockClientIds(state);
}
/**
 * Returns the current multi-selection set of blocks, or an empty array if
 * there is no multi-selection.
 *
 * @param {Object} state Editor state.
 *
 * @return {Array} Multi-selected block objects.
 */

const getMultiSelectedBlocks = rememo(state => {
  const multiSelectedBlockClientIds = getMultiSelectedBlockClientIds(state);

  if (!multiSelectedBlockClientIds.length) {
    return EMPTY_ARRAY;
  }

  return multiSelectedBlockClientIds.map(clientId => getBlock(state, clientId));
}, state => [...getSelectedBlockClientIds.getDependants(state), state.blocks.byClientId, state.blocks.order, state.blocks.attributes]);
/**
 * Returns the client ID of the first block in the multi-selection set, or null
 * if there is no multi-selection.
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} First block client ID in the multi-selection set.
 */

function getFirstMultiSelectedBlockClientId(state) {
  return getMultiSelectedBlockClientIds(state)[0] || null;
}
/**
 * Returns the client ID of the last block in the multi-selection set, or null
 * if there is no multi-selection.
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} Last block client ID in the multi-selection set.
 */

function getLastMultiSelectedBlockClientId(state) {
  const selectedClientIds = getMultiSelectedBlockClientIds(state);
  return selectedClientIds[selectedClientIds.length - 1] || null;
}
/**
 * Returns true if a multi-selection exists, and the block corresponding to the
 * specified client ID is the first block of the multi-selection set, or false
 * otherwise.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Whether block is first in multi-selection.
 */

function isFirstMultiSelectedBlock(state, clientId) {
  return getFirstMultiSelectedBlockClientId(state) === clientId;
}
/**
 * Returns true if the client ID occurs within the block multi-selection, or
 * false otherwise.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Whether block is in multi-selection set.
 */

function isBlockMultiSelected(state, clientId) {
  return getMultiSelectedBlockClientIds(state).indexOf(clientId) !== -1;
}
/**
 * Returns true if an ancestor of the block is multi-selected, or false
 * otherwise.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Whether an ancestor of the block is in multi-selection
 *                   set.
 */

const isAncestorMultiSelected = rememo((state, clientId) => {
  let ancestorClientId = clientId;
  let isMultiSelected = false;

  while (ancestorClientId && !isMultiSelected) {
    ancestorClientId = getBlockRootClientId(state, ancestorClientId);
    isMultiSelected = isBlockMultiSelected(state, ancestorClientId);
  }

  return isMultiSelected;
}, state => [state.blocks.order, state.selection.selectionStart.clientId, state.selection.selectionEnd.clientId]);
/**
 * Returns the client ID of the block which begins the multi-selection set, or
 * null if there is no multi-selection.
 *
 * This is not necessarily the first client ID in the selection.
 *
 * @see getFirstMultiSelectedBlockClientId
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} Client ID of block beginning multi-selection.
 */

function getMultiSelectedBlocksStartClientId(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;

  if (selectionStart.clientId === selectionEnd.clientId) {
    return null;
  }

  return selectionStart.clientId || null;
}
/**
 * Returns the client ID of the block which ends the multi-selection set, or
 * null if there is no multi-selection.
 *
 * This is not necessarily the last client ID in the selection.
 *
 * @see getLastMultiSelectedBlockClientId
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} Client ID of block ending multi-selection.
 */

function getMultiSelectedBlocksEndClientId(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;

  if (selectionStart.clientId === selectionEnd.clientId) {
    return null;
  }

  return selectionEnd.clientId || null;
}
/**
 * Returns true if the selection is not partial.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Whether the selection is mergeable.
 */

function __unstableIsFullySelected(state) {
  const selectionAnchor = getSelectionStart(state);
  const selectionFocus = getSelectionEnd(state);
  return !selectionAnchor.attributeKey && !selectionFocus.attributeKey && typeof selectionAnchor.offset === 'undefined' && typeof selectionFocus.offset === 'undefined';
}
/**
 * Returns true if the selection is collapsed.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Whether the selection is collapsed.
 */

function __unstableIsSelectionCollapsed(state) {
  const selectionAnchor = getSelectionStart(state);
  const selectionFocus = getSelectionEnd(state);
  return !!selectionAnchor && !!selectionFocus && selectionAnchor.clientId === selectionFocus.clientId && selectionAnchor.attributeKey === selectionFocus.attributeKey && selectionAnchor.offset === selectionFocus.offset;
}
function __unstableSelectionHasUnmergeableBlock(state) {
  return getSelectedBlockClientIds(state).some(clientId => {
    const blockName = getBlockName(state, clientId);
    const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockName);
    return !blockType.merge;
  });
}
/**
 * Check whether the selection is mergeable.
 *
 * @param {Object}  state     Editor state.
 * @param {boolean} isForward Whether to merge forwards.
 *
 * @return {boolean} Whether the selection is mergeable.
 */

function __unstableIsSelectionMergeable(state, isForward) {
  const selectionAnchor = getSelectionStart(state);
  const selectionFocus = getSelectionEnd(state); // It's not mergeable if the start and end are within the same block.

  if (selectionAnchor.clientId === selectionFocus.clientId) return false; // It's not mergeable if there's no rich text selection.

  if (!selectionAnchor.attributeKey || !selectionFocus.attributeKey || typeof selectionAnchor.offset === 'undefined' || typeof selectionFocus.offset === 'undefined') return false;
  const anchorRootClientId = getBlockRootClientId(state, selectionAnchor.clientId);
  const focusRootClientId = getBlockRootClientId(state, selectionFocus.clientId); // It's not mergeable if the selection doesn't start and end in the same
  // block list. Maybe in the future it should be allowed.

  if (anchorRootClientId !== focusRootClientId) {
    return false;
  }

  const blockOrder = getBlockOrder(state, anchorRootClientId);
  const anchorIndex = blockOrder.indexOf(selectionAnchor.clientId);
  const focusIndex = blockOrder.indexOf(selectionFocus.clientId); // Reassign selection start and end based on order.

  let selectionStart, selectionEnd;

  if (anchorIndex > focusIndex) {
    selectionStart = selectionFocus;
    selectionEnd = selectionAnchor;
  } else {
    selectionStart = selectionAnchor;
    selectionEnd = selectionFocus;
  }

  const targetBlockClientId = isForward ? selectionEnd.clientId : selectionStart.clientId;
  const blockToMergeClientId = isForward ? selectionStart.clientId : selectionEnd.clientId;
  const targetBlockName = getBlockName(state, targetBlockClientId);
  const targetBlockType = (0,external_wp_blocks_namespaceObject.getBlockType)(targetBlockName);
  if (!targetBlockType.merge) return false;
  const blockToMerge = getBlock(state, blockToMergeClientId); // It's mergeable if the blocks are of the same type.

  if (blockToMerge.name === targetBlockName) return true; // If the blocks are of a different type, try to transform the block being
  // merged into the same type of block.

  const blocksToMerge = (0,external_wp_blocks_namespaceObject.switchToBlockType)(blockToMerge, targetBlockName);
  return blocksToMerge && blocksToMerge.length;
}
/**
 * Get partial selected blocks with their content updated
 * based on the selection.
 *
 * @param {Object} state Editor state.
 *
 * @return {Object[]} Updated partial selected blocks.
 */

const __unstableGetSelectedBlocksWithPartialSelection = state => {
  const selectionAnchor = getSelectionStart(state);
  const selectionFocus = getSelectionEnd(state);

  if (selectionAnchor.clientId === selectionFocus.clientId) {
    return EMPTY_ARRAY;
  } // Can't split if the selection is not set.


  if (!selectionAnchor.attributeKey || !selectionFocus.attributeKey || typeof selectionAnchor.offset === 'undefined' || typeof selectionFocus.offset === 'undefined') {
    return EMPTY_ARRAY;
  }

  const anchorRootClientId = getBlockRootClientId(state, selectionAnchor.clientId);
  const focusRootClientId = getBlockRootClientId(state, selectionFocus.clientId); // It's not splittable if the selection doesn't start and end in the same
  // block list. Maybe in the future it should be allowed.

  if (anchorRootClientId !== focusRootClientId) {
    return EMPTY_ARRAY;
  }

  const blockOrder = getBlockOrder(state, anchorRootClientId);
  const anchorIndex = blockOrder.indexOf(selectionAnchor.clientId);
  const focusIndex = blockOrder.indexOf(selectionFocus.clientId); // Reassign selection start and end based on order.

  const [selectionStart, selectionEnd] = anchorIndex > focusIndex ? [selectionFocus, selectionAnchor] : [selectionAnchor, selectionFocus];
  const blockA = getBlock(state, selectionStart.clientId);
  const blockAType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockA.name);
  const blockB = getBlock(state, selectionEnd.clientId);
  const blockBType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockB.name);
  const htmlA = blockA.attributes[selectionStart.attributeKey];
  const htmlB = blockB.attributes[selectionEnd.attributeKey];
  const attributeDefinitionA = blockAType.attributes[selectionStart.attributeKey];
  const attributeDefinitionB = blockBType.attributes[selectionEnd.attributeKey];
  let valueA = (0,external_wp_richText_namespaceObject.create)({
    html: htmlA,
    ...mapRichTextSettings(attributeDefinitionA)
  });
  let valueB = (0,external_wp_richText_namespaceObject.create)({
    html: htmlB,
    ...mapRichTextSettings(attributeDefinitionB)
  });
  valueA = (0,external_wp_richText_namespaceObject.remove)(valueA, 0, selectionStart.offset);
  valueB = (0,external_wp_richText_namespaceObject.remove)(valueB, selectionEnd.offset, valueB.text.length);
  return [{ ...blockA,
    attributes: { ...blockA.attributes,
      [selectionStart.attributeKey]: (0,external_wp_richText_namespaceObject.toHTMLString)({
        value: valueA,
        ...mapRichTextSettings(attributeDefinitionA)
      })
    }
  }, { ...blockB,
    attributes: { ...blockB.attributes,
      [selectionEnd.attributeKey]: (0,external_wp_richText_namespaceObject.toHTMLString)({
        value: valueB,
        ...mapRichTextSettings(attributeDefinitionB)
      })
    }
  }];
};
/**
 * Returns an array containing all block client IDs in the editor in the order
 * they appear. Optionally accepts a root client ID of the block list for which
 * the order should be returned, defaulting to the top-level block order.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {Array} Ordered client IDs of editor blocks.
 */

function getBlockOrder(state, rootClientId) {
  return state.blocks.order.get(rootClientId || '') || EMPTY_ARRAY;
}
/**
 * Returns the index at which the block corresponding to the specified client
 * ID occurs within the block order, or `-1` if the block does not exist.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {number} Index at which block exists in order.
 */

function getBlockIndex(state, clientId) {
  const rootClientId = getBlockRootClientId(state, clientId);
  return getBlockOrder(state, rootClientId).indexOf(clientId);
}
/**
 * Returns true if the block corresponding to the specified client ID is
 * currently selected and no multi-selection exists, or false otherwise.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Whether block is selected and multi-selection exists.
 */

function isBlockSelected(state, clientId) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;

  if (selectionStart.clientId !== selectionEnd.clientId) {
    return false;
  }

  return selectionStart.clientId === clientId;
}
/**
 * Returns true if one of the block's inner blocks is selected.
 *
 * @param {Object}  state    Editor state.
 * @param {string}  clientId Block client ID.
 * @param {boolean} deep     Perform a deep check.
 *
 * @return {boolean} Whether the block as an inner block selected
 */

function hasSelectedInnerBlock(state, clientId) {
  let deep = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  return getBlockOrder(state, clientId).some(innerClientId => isBlockSelected(state, innerClientId) || isBlockMultiSelected(state, innerClientId) || deep && hasSelectedInnerBlock(state, innerClientId, deep));
}
/**
 * Returns true if the block corresponding to the specified client ID is
 * currently selected but isn't the last of the selected blocks. Here "last"
 * refers to the block sequence in the document, _not_ the sequence of
 * multi-selection, which is why `state.selectionEnd` isn't used.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Whether block is selected and not the last in the
 *                   selection.
 */

function isBlockWithinSelection(state, clientId) {
  if (!clientId) {
    return false;
  }

  const clientIds = getMultiSelectedBlockClientIds(state);
  const index = clientIds.indexOf(clientId);
  return index > -1 && index < clientIds.length - 1;
}
/**
 * Returns true if a multi-selection has been made, or false otherwise.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Whether multi-selection has been made.
 */

function hasMultiSelection(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;
  return selectionStart.clientId !== selectionEnd.clientId;
}
/**
 * Whether in the process of multi-selecting or not. This flag is only true
 * while the multi-selection is being selected (by mouse move), and is false
 * once the multi-selection has been settled.
 *
 * @see hasMultiSelection
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} True if multi-selecting, false if not.
 */

function selectors_isMultiSelecting(state) {
  return state.isMultiSelecting;
}
/**
 * Selector that returns if multi-selection is enabled or not.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} True if it should be possible to multi-select blocks, false if multi-selection is disabled.
 */

function selectors_isSelectionEnabled(state) {
  return state.isSelectionEnabled;
}
/**
 * Returns the block's editing mode, defaulting to "visual" if not explicitly
 * assigned.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {Object} Block editing mode.
 */

function getBlockMode(state, clientId) {
  return state.blocksMode[clientId] || 'visual';
}
/**
 * Returns true if the user is typing, or false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether user is typing.
 */

function selectors_isTyping(state) {
  return state.isTyping;
}
/**
 * Returns true if the user is dragging blocks, or false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether user is dragging blocks.
 */

function isDraggingBlocks(state) {
  return !!state.draggedBlocks.length;
}
/**
 * Returns the client ids of any blocks being directly dragged.
 *
 * This does not include children of a parent being dragged.
 *
 * @param {Object} state Global application state.
 *
 * @return {string[]} Array of dragged block client ids.
 */

function getDraggedBlockClientIds(state) {
  return state.draggedBlocks;
}
/**
 * Returns whether the block is being dragged.
 *
 * Only returns true if the block is being directly dragged,
 * not if the block is a child of a parent being dragged.
 * See `isAncestorBeingDragged` for child blocks.
 *
 * @param {Object} state    Global application state.
 * @param {string} clientId Client id for block to check.
 *
 * @return {boolean} Whether the block is being dragged.
 */

function isBlockBeingDragged(state, clientId) {
  return state.draggedBlocks.includes(clientId);
}
/**
 * Returns whether a parent/ancestor of the block is being dragged.
 *
 * @param {Object} state    Global application state.
 * @param {string} clientId Client id for block to check.
 *
 * @return {boolean} Whether the block's ancestor is being dragged.
 */

function isAncestorBeingDragged(state, clientId) {
  // Return early if no blocks are being dragged rather than
  // the more expensive check for parents.
  if (!isDraggingBlocks(state)) {
    return false;
  }

  const parents = getBlockParents(state, clientId);
  return parents.some(parentClientId => isBlockBeingDragged(state, parentClientId));
}
/**
 * Returns true if the caret is within formatted text, or false otherwise.
 *
 * @deprecated
 *
 * @return {boolean} Whether the caret is within formatted text.
 */

function isCaretWithinFormattedText() {
  external_wp_deprecated_default()('wp.data.select( "core/block-editor" ).isCaretWithinFormattedText', {
    since: '6.1',
    version: '6.3'
  });
  return false;
}
/**
 * Returns the insertion point, the index at which the new inserted block would
 * be placed. Defaults to the last index.
 *
 * @param {Object} state Editor state.
 *
 * @return {Object} Insertion point object with `rootClientId`, `index`.
 */

const getBlockInsertionPoint = rememo(state => {
  let rootClientId, index;
  const {
    insertionPoint,
    selection: {
      selectionEnd
    }
  } = state;

  if (insertionPoint !== null) {
    return insertionPoint;
  }

  const {
    clientId
  } = selectionEnd;

  if (clientId) {
    rootClientId = getBlockRootClientId(state, clientId) || undefined;
    index = getBlockIndex(state, selectionEnd.clientId) + 1;
  } else {
    index = getBlockOrder(state).length;
  }

  return {
    rootClientId,
    index
  };
}, state => [state.insertionPoint, state.selection.selectionEnd.clientId, state.blocks.parents, state.blocks.order]);
/**
 * Returns true if we should show the block insertion point.
 *
 * @param {Object} state Global application state.
 *
 * @return {?boolean} Whether the insertion point is visible or not.
 */

function isBlockInsertionPointVisible(state) {
  return state.insertionPoint !== null;
}
/**
 * Returns whether the blocks matches the template or not.
 *
 * @param {boolean} state
 * @return {?boolean} Whether the template is valid or not.
 */

function isValidTemplate(state) {
  return state.template.isValid;
}
/**
 * Returns the defined block template
 *
 * @param {boolean} state
 *
 * @return {?Array} Block Template.
 */

function getTemplate(state) {
  return state.settings.template;
}
/**
 * Returns the defined block template lock. Optionally accepts a root block
 * client ID as context, otherwise defaulting to the global context.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional block root client ID.
 *
 * @return {string|false} Block Template Lock
 */

function getTemplateLock(state, rootClientId) {
  var _getBlockListSettings, _getBlockListSettings2;

  if (!rootClientId) {
    var _state$settings$templ;

    return (_state$settings$templ = state.settings.templateLock) !== null && _state$settings$templ !== void 0 ? _state$settings$templ : false;
  }

  return (_getBlockListSettings = (_getBlockListSettings2 = getBlockListSettings(state, rootClientId)) === null || _getBlockListSettings2 === void 0 ? void 0 : _getBlockListSettings2.templateLock) !== null && _getBlockListSettings !== void 0 ? _getBlockListSettings : false;
}

const checkAllowList = function (list, item) {
  let defaultResult = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

  if (typeof list === 'boolean') {
    return list;
  }

  if (Array.isArray(list)) {
    // TODO: when there is a canonical way to detect that we are editing a post
    // the following check should be changed to something like:
    // if ( list.includes( 'core/post-content' ) && getEditorMode() === 'post-content' && item === null )
    if (list.includes('core/post-content') && item === null) {
      return true;
    }

    return list.includes(item);
  }

  return defaultResult;
};
/**
 * Determines if the given block type is allowed to be inserted into the block list.
 * This function is not exported and not memoized because using a memoized selector
 * inside another memoized selector is just a waste of time.
 *
 * @param {Object}        state        Editor state.
 * @param {string|Object} blockName    The block type object, e.g., the response
 *                                     from the block directory; or a string name of
 *                                     an installed block type, e.g.' core/paragraph'.
 * @param {?string}       rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given block type is allowed to be inserted.
 */


const canInsertBlockTypeUnmemoized = function (state, blockName) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  let blockType;

  if (blockName && 'object' === typeof blockName) {
    blockType = blockName;
    blockName = blockType.name;
  } else {
    blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockName);
  }

  if (!blockType) {
    return false;
  }

  const {
    allowedBlockTypes
  } = getSettings(state);
  const isBlockAllowedInEditor = checkAllowList(allowedBlockTypes, blockName, true);

  if (!isBlockAllowedInEditor) {
    return false;
  }

  const isLocked = !!getTemplateLock(state, rootClientId);

  if (isLocked) {
    return false;
  }

  const parentBlockListSettings = getBlockListSettings(state, rootClientId); // The parent block doesn't have settings indicating it doesn't support
  // inner blocks, return false.

  if (rootClientId && parentBlockListSettings === undefined) {
    return false;
  }

  const parentAllowedBlocks = parentBlockListSettings === null || parentBlockListSettings === void 0 ? void 0 : parentBlockListSettings.allowedBlocks;
  const hasParentAllowedBlock = checkAllowList(parentAllowedBlocks, blockName);
  const blockAllowedParentBlocks = blockType.parent;
  const parentName = getBlockName(state, rootClientId);
  const hasBlockAllowedParent = checkAllowList(blockAllowedParentBlocks, parentName);
  let hasBlockAllowedAncestor = true;
  const blockAllowedAncestorBlocks = blockType.ancestor;

  if (blockAllowedAncestorBlocks) {
    const ancestors = [rootClientId, ...getBlockParents(state, rootClientId)];
    hasBlockAllowedAncestor = ancestors.some(ancestorClientId => checkAllowList(blockAllowedAncestorBlocks, getBlockName(state, ancestorClientId)));
  }

  const canInsert = hasBlockAllowedAncestor && (hasParentAllowedBlock === null && hasBlockAllowedParent === null || hasParentAllowedBlock === true || hasBlockAllowedParent === true);

  if (!canInsert) {
    return canInsert;
  }
  /**
   * This filter is an ad-hoc solution to prevent adding template parts inside post content.
   * Conceptually, having a filter inside a selector is bad pattern so this code will be
   * replaced by a declarative API that doesn't the following drawbacks:
   *
   * Filters are not reactive: Upon switching between "template mode" and non "template mode",
   * the filter and selector won't necessarily be executed again. For now, it doesn't matter much
   * because you can't switch between the two modes while the inserter stays open.
   *
   * Filters are global: Once they're defined, they will affect all editor instances and all registries.
   * An ideal API would only affect specific editor instances.
   */


  return (0,external_wp_hooks_namespaceObject.applyFilters)('blockEditor.__unstableCanInsertBlockType', canInsert, blockType, rootClientId, {
    // Pass bound selectors of the current registry. If we're in a nested
    // context, the data will differ from the one selected from the root
    // registry.
    getBlock: getBlock.bind(null, state),
    getBlockParentsByBlockName: getBlockParentsByBlockName.bind(null, state)
  });
};
/**
 * Determines if the given block type is allowed to be inserted into the block list.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  blockName    The name of the block type, e.g.' core/paragraph'.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given block type is allowed to be inserted.
 */


const canInsertBlockType = rememo(canInsertBlockTypeUnmemoized, (state, blockName, rootClientId) => [state.blockListSettings[rootClientId], state.blocks.byClientId.get(rootClientId), state.settings.allowedBlockTypes, state.settings.templateLock]);
/**
 * Determines if the given blocks are allowed to be inserted into the block
 * list.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientIds    The block client IDs to be inserted.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given blocks are allowed to be inserted.
 */

function canInsertBlocks(state, clientIds) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  return clientIds.every(id => canInsertBlockType(state, getBlockName(state, id), rootClientId));
}
/**
 * Determines if the given block is allowed to be deleted.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientId     The block client Id.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given block is allowed to be removed.
 */

function canRemoveBlock(state, clientId) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  const attributes = getBlockAttributes(state, clientId); // attributes can be null if the block is already deleted.

  if (attributes === null) {
    return true;
  }

  const {
    lock
  } = attributes;
  const parentIsLocked = !!getTemplateLock(state, rootClientId); // If we don't have a lock on the blockType level, we defer to the parent templateLock.

  if (lock === undefined || (lock === null || lock === void 0 ? void 0 : lock.remove) === undefined) {
    return !parentIsLocked;
  } // When remove is true, it means we cannot remove it.


  return !(lock !== null && lock !== void 0 && lock.remove);
}
/**
 * Determines if the given blocks are allowed to be removed.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientIds    The block client IDs to be removed.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given blocks are allowed to be removed.
 */

function canRemoveBlocks(state, clientIds) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  return clientIds.every(clientId => canRemoveBlock(state, clientId, rootClientId));
}
/**
 * Determines if the given block is allowed to be moved.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientId     The block client Id.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean | undefined} Whether the given block is allowed to be moved.
 */

function canMoveBlock(state, clientId) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  const attributes = getBlockAttributes(state, clientId);

  if (attributes === null) {
    return;
  }

  const {
    lock
  } = attributes;
  const parentIsLocked = getTemplateLock(state, rootClientId) === 'all'; // If we don't have a lock on the blockType level, we defer to the parent templateLock.

  if (lock === undefined || (lock === null || lock === void 0 ? void 0 : lock.move) === undefined) {
    return !parentIsLocked;
  } // When move is true, it means we cannot move it.


  return !(lock !== null && lock !== void 0 && lock.move);
}
/**
 * Determines if the given blocks are allowed to be moved.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientIds    The block client IDs to be moved.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given blocks are allowed to be moved.
 */

function canMoveBlocks(state, clientIds) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  return clientIds.every(clientId => canMoveBlock(state, clientId, rootClientId));
}
/**
 * Determines if the given block is allowed to be edited.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId The block client Id.
 *
 * @return {boolean} Whether the given block is allowed to be edited.
 */

function canEditBlock(state, clientId) {
  const attributes = getBlockAttributes(state, clientId);

  if (attributes === null) {
    return true;
  }

  const {
    lock
  } = attributes; // When the edit is true, we cannot edit the block.

  return !(lock !== null && lock !== void 0 && lock.edit);
}
/**
 * Determines if the given block type can be locked/unlocked by a user.
 *
 * @param {Object}          state      Editor state.
 * @param {(string|Object)} nameOrType Block name or type object.
 *
 * @return {boolean} Whether a given block type can be locked/unlocked.
 */

function canLockBlockType(state, nameOrType) {
  var _state$settings;

  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(nameOrType, 'lock', true)) {
    return false;
  } // Use block editor settings as the default value.


  return !!((_state$settings = state.settings) !== null && _state$settings !== void 0 && _state$settings.canLockBlocks);
}
/**
 * Returns information about how recently and frequently a block has been inserted.
 *
 * @param {Object} state Global application state.
 * @param {string} id    A string which identifies the insert, e.g. 'core/block/12'
 *
 * @return {?{ time: number, count: number }} An object containing `time` which is when the last
 *                                            insert occurred as a UNIX epoch, and `count` which is
 *                                            the number of inserts that have occurred.
 */

function getInsertUsage(state, id) {
  var _state$preferences$in, _state$preferences$in2;

  return (_state$preferences$in = (_state$preferences$in2 = state.preferences.insertUsage) === null || _state$preferences$in2 === void 0 ? void 0 : _state$preferences$in2[id]) !== null && _state$preferences$in !== void 0 ? _state$preferences$in : null;
}
/**
 * Returns whether we can show a block type in the inserter
 *
 * @param {Object}  state        Global State
 * @param {Object}  blockType    BlockType
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given block type is allowed to be shown in the inserter.
 */


const canIncludeBlockTypeInInserter = (state, blockType, rootClientId) => {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'inserter', true)) {
    return false;
  }

  return canInsertBlockTypeUnmemoized(state, blockType.name, rootClientId);
};
/**
 * Return a function to be used to tranform a block variation to an inserter item
 *
 * @param {Object} state Global State
 * @param {Object} item  Denormalized inserter item
 * @return {Function} Function to transform a block variation to inserter item
 */


const getItemFromVariation = (state, item) => variation => {
  const variationId = `${item.id}/${variation.name}`;
  const {
    time,
    count = 0
  } = getInsertUsage(state, variationId) || {};
  return { ...item,
    id: variationId,
    icon: variation.icon || item.icon,
    title: variation.title || item.title,
    description: variation.description || item.description,
    category: variation.category || item.category,
    // If `example` is explicitly undefined for the variation, the preview will not be shown.
    example: variation.hasOwnProperty('example') ? variation.example : item.example,
    initialAttributes: { ...item.initialAttributes,
      ...variation.attributes
    },
    innerBlocks: variation.innerBlocks,
    keywords: variation.keywords || item.keywords,
    frecency: calculateFrecency(time, count)
  };
};
/**
 * Returns the calculated frecency.
 *
 * 'frecency' is a heuristic (https://en.wikipedia.org/wiki/Frecency)
 * that combines block usage frequenty and recency.
 *
 * @param {number} time  When the last insert occurred as a UNIX epoch
 * @param {number} count The number of inserts that have occurred.
 *
 * @return {number} The calculated frecency.
 */


const calculateFrecency = (time, count) => {
  if (!time) {
    return count;
  } // The selector is cached, which means Date.now() is the last time that the
  // relevant state changed. This suits our needs.


  const duration = Date.now() - time;

  switch (true) {
    case duration < MILLISECONDS_PER_HOUR:
      return count * 4;

    case duration < MILLISECONDS_PER_DAY:
      return count * 2;

    case duration < MILLISECONDS_PER_WEEK:
      return count / 2;

    default:
      return count / 4;
  }
};
/**
 * Returns a function that accepts a block type and builds an item to be shown
 * in a specific context. It's used for building items for Inserter and available
 * block Transfroms list.
 *
 * @param {Object} state              Editor state.
 * @param {Object} options            Options object for handling the building of a block type.
 * @param {string} options.buildScope The scope for which the item is going to be used.
 * @return {Function} Function returns an item to be shown in a specific context (Inserter|Transforms list).
 */


const buildBlockTypeItem = (state, _ref3) => {
  let {
    buildScope = 'inserter'
  } = _ref3;
  return blockType => {
    const id = blockType.name;
    let isDisabled = false;

    if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType.name, 'multiple', true)) {
      isDisabled = getBlocksByClientId(state, getClientIdsWithDescendants(state)).some(_ref4 => {
        let {
          name
        } = _ref4;
        return name === blockType.name;
      });
    }

    const {
      time,
      count = 0
    } = getInsertUsage(state, id) || {};
    const blockItemBase = {
      id,
      name: blockType.name,
      title: blockType.title,
      icon: blockType.icon,
      isDisabled,
      frecency: calculateFrecency(time, count)
    };
    if (buildScope === 'transform') return blockItemBase;
    const inserterVariations = (0,external_wp_blocks_namespaceObject.getBlockVariations)(blockType.name, 'inserter');
    return { ...blockItemBase,
      initialAttributes: {},
      description: blockType.description,
      category: blockType.category,
      keywords: blockType.keywords,
      variations: inserterVariations,
      example: blockType.example,
      utility: 1 // Deprecated.

    };
  };
};
/**
 * Determines the items that appear in the inserter. Includes both static
 * items (e.g. a regular block type) and dynamic items (e.g. a reusable block).
 *
 * Each item object contains what's necessary to display a button in the
 * inserter and handle its selection.
 *
 * The 'frecency' property is a heuristic (https://en.wikipedia.org/wiki/Frecency)
 * that combines block usage frequenty and recency.
 *
 * Items are returned ordered descendingly by their 'utility' and 'frecency'.
 *
 * @param    {Object}   state             Editor state.
 * @param    {?string}  rootClientId      Optional root client ID of block list.
 *
 * @return {WPEditorInserterItem[]} Items that appear in inserter.
 *
 * @typedef {Object} WPEditorInserterItem
 * @property {string}   id                Unique identifier for the item.
 * @property {string}   name              The type of block to create.
 * @property {Object}   initialAttributes Attributes to pass to the newly created block.
 * @property {string}   title             Title of the item, as it appears in the inserter.
 * @property {string}   icon              Dashicon for the item, as it appears in the inserter.
 * @property {string}   category          Block category that the item is associated with.
 * @property {string[]} keywords          Keywords that can be searched to find this item.
 * @property {boolean}  isDisabled        Whether or not the user should be prevented from inserting
 *                                        this item.
 * @property {number}   frecency          Heuristic that combines frequency and recency.
 */


const getInserterItems = rememo(function (state) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  const buildBlockTypeInserterItem = buildBlockTypeItem(state, {
    buildScope: 'inserter'
  });
  /*
   * Matches block comment delimiters amid serialized content.
   *
   * @see `tokenizer` in `@wordpress/block-serialization-default-parser`
   * package
   *
   * blockParserTokenizer differs from the original tokenizer in the
   * following ways:
   *
   * - removed global flag (/g)
   * - prepended ^\s*
   *
   */

  const blockParserTokenizer = /^\s*<!--\s+(\/)?wp:([a-z][a-z0-9_-]*\/)?([a-z][a-z0-9_-]*)\s+({(?:(?=([^}]+|}+(?=})|(?!}\s+\/?-->)[^])*)\5|[^]*?)}\s+)?(\/)?-->/;

  const buildReusableBlockInserterItem = reusableBlock => {
    let icon = library_symbol;
    /*
     * Instead of always displaying a generic "symbol" icon for every
     * reusable block, try to use an icon that represents the first
     * outermost block contained in the reusable block. This requires
     * scanning the serialized form of the reusable block to find its
     * first block delimiter, then looking up the corresponding block
     * type, if available.
     */

    if (external_wp_element_namespaceObject.Platform.OS === 'web') {
      const content = typeof reusableBlock.content.raw === 'string' ? reusableBlock.content.raw : reusableBlock.content;
      const rawBlockMatch = content.match(blockParserTokenizer);

      if (rawBlockMatch) {
        const [,, namespace = 'core/', blockName] = rawBlockMatch;
        const referencedBlockType = (0,external_wp_blocks_namespaceObject.getBlockType)(namespace + blockName);

        if (referencedBlockType) {
          icon = referencedBlockType.icon;
        }
      }
    }

    const id = `core/block/${reusableBlock.id}`;
    const {
      time,
      count = 0
    } = getInsertUsage(state, id) || {};
    const frecency = calculateFrecency(time, count);
    return {
      id,
      name: 'core/block',
      initialAttributes: {
        ref: reusableBlock.id
      },
      title: reusableBlock.title.raw,
      icon,
      category: 'reusable',
      keywords: [],
      isDisabled: false,
      utility: 1,
      // Deprecated.
      frecency
    };
  };

  const blockTypeInserterItems = (0,external_wp_blocks_namespaceObject.getBlockTypes)().filter(blockType => canIncludeBlockTypeInInserter(state, blockType, rootClientId)).map(buildBlockTypeInserterItem);
  const reusableBlockInserterItems = canInsertBlockTypeUnmemoized(state, 'core/block', rootClientId) ? getReusableBlocks(state).map(buildReusableBlockInserterItem) : [];
  const items = blockTypeInserterItems.reduce((accumulator, item) => {
    const {
      variations = []
    } = item; // Exclude any block type item that is to be replaced by a default variation.

    if (!variations.some(_ref5 => {
      let {
        isDefault
      } = _ref5;
      return isDefault;
    })) {
      accumulator.push(item);
    }

    if (variations.length) {
      const variationMapper = getItemFromVariation(state, item);
      accumulator.push(...variations.map(variationMapper));
    }

    return accumulator;
  }, []); // Ensure core blocks are prioritized in the returned results,
  // because third party blocks can be registered earlier than
  // the core blocks (usually by using the `init` action),
  // thus affecting the display order.
  // We don't sort reusable blocks as they are handled differently.

  const groupByType = (blocks, block) => {
    const {
      core,
      noncore
    } = blocks;
    const type = block.name.startsWith('core/') ? core : noncore;
    type.push(block);
    return blocks;
  };

  const {
    core: coreItems,
    noncore: nonCoreItems
  } = items.reduce(groupByType, {
    core: [],
    noncore: []
  });
  const sortedBlockTypes = [...coreItems, ...nonCoreItems];
  return [...sortedBlockTypes, ...reusableBlockInserterItems];
}, (state, rootClientId) => [state.blockListSettings[rootClientId], state.blocks.byClientId, state.blocks.order, state.preferences.insertUsage, state.settings.allowedBlockTypes, state.settings.templateLock, getReusableBlocks(state), (0,external_wp_blocks_namespaceObject.getBlockTypes)()]);
/**
 * Determines the items that appear in the available block transforms list.
 *
 * Each item object contains what's necessary to display a menu item in the
 * transform list and handle its selection.
 *
 * The 'frecency' property is a heuristic (https://en.wikipedia.org/wiki/Frecency)
 * that combines block usage frequenty and recency.
 *
 * Items are returned ordered descendingly by their 'frecency'.
 *
 * @param    {Object}          state        Editor state.
 * @param    {Object|Object[]} blocks       Block object or array objects.
 * @param    {?string}         rootClientId Optional root client ID of block list.
 *
 * @return {WPEditorTransformItem[]} Items that appear in inserter.
 *
 * @typedef {Object} WPEditorTransformItem
 * @property {string}          id           Unique identifier for the item.
 * @property {string}          name         The type of block to create.
 * @property {string}          title        Title of the item, as it appears in the inserter.
 * @property {string}          icon         Dashicon for the item, as it appears in the inserter.
 * @property {boolean}         isDisabled   Whether or not the user should be prevented from inserting
 *                                          this item.
 * @property {number}          frecency     Heuristic that combines frequency and recency.
 */

const getBlockTransformItems = rememo(function (state, blocks) {
  var _itemsByName$sourceBl;

  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  const normalizedBlocks = Array.isArray(blocks) ? blocks : [blocks];
  const [sourceBlock] = normalizedBlocks;
  const buildBlockTypeTransformItem = buildBlockTypeItem(state, {
    buildScope: 'transform'
  });
  const blockTypeTransformItems = (0,external_wp_blocks_namespaceObject.getBlockTypes)().filter(blockType => canIncludeBlockTypeInInserter(state, blockType, rootClientId)).map(buildBlockTypeTransformItem);
  const itemsByName = Object.fromEntries(Object.entries(blockTypeTransformItems).map(_ref6 => {
    let [, value] = _ref6;
    return [value.name, value];
  })); // Consider unwraping the highest priority.

  itemsByName['*'] = {
    frecency: +Infinity,
    id: '*',
    isDisabled: false,
    name: '*',
    title: (0,external_wp_i18n_namespaceObject.__)('Unwrap'),
    icon: (_itemsByName$sourceBl = itemsByName[sourceBlock === null || sourceBlock === void 0 ? void 0 : sourceBlock.name]) === null || _itemsByName$sourceBl === void 0 ? void 0 : _itemsByName$sourceBl.icon
  };
  const possibleTransforms = (0,external_wp_blocks_namespaceObject.getPossibleBlockTransformations)(normalizedBlocks).reduce((accumulator, block) => {
    if (block === '*') {
      accumulator.push(itemsByName['*']);
    } else if (itemsByName[block === null || block === void 0 ? void 0 : block.name]) {
      accumulator.push(itemsByName[block.name]);
    }

    return accumulator;
  }, []);
  return orderBy(possibleTransforms, block => itemsByName[block.name].frecency, 'desc');
}, (state, blocks, rootClientId) => [state.blockListSettings[rootClientId], state.blocks.byClientId, state.preferences.insertUsage, state.settings.allowedBlockTypes, state.settings.templateLock, (0,external_wp_blocks_namespaceObject.getBlockTypes)()]);
/**
 * Determines whether there are items to show in the inserter.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Items that appear in inserter.
 */

const hasInserterItems = rememo(function (state) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  const hasBlockType = (0,external_wp_blocks_namespaceObject.getBlockTypes)().some(blockType => canIncludeBlockTypeInInserter(state, blockType, rootClientId));

  if (hasBlockType) {
    return true;
  }

  const hasReusableBlock = canInsertBlockTypeUnmemoized(state, 'core/block', rootClientId) && getReusableBlocks(state).length > 0;
  return hasReusableBlock;
}, (state, rootClientId) => [state.blockListSettings[rootClientId], state.blocks.byClientId, state.settings.allowedBlockTypes, state.settings.templateLock, getReusableBlocks(state), (0,external_wp_blocks_namespaceObject.getBlockTypes)()]);
/**
 * Returns the list of allowed inserter blocks for inner blocks children.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {Array?} The list of allowed block types.
 */

const getAllowedBlocks = rememo(function (state) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

  if (!rootClientId) {
    return;
  }

  return (0,external_wp_blocks_namespaceObject.getBlockTypes)().filter(blockType => canIncludeBlockTypeInInserter(state, blockType, rootClientId));
}, (state, rootClientId) => [state.blockListSettings[rootClientId], state.blocks.byClientId, state.settings.allowedBlockTypes, state.settings.templateLock, (0,external_wp_blocks_namespaceObject.getBlockTypes)()]);
const __experimentalGetAllowedBlocks = rememo(function (state) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  external_wp_deprecated_default()('wp.data.select( "core/block-editor" ).__experimentalGetAllowedBlocks', {
    alternative: 'wp.data.select( "core/block-editor" ).getAllowedBlocks',
    since: '6.2',
    version: '6.4'
  });
  return getAllowedBlocks(state, rootClientId);
}, (state, rootClientId) => [...getAllowedBlocks.getDependants(state, rootClientId)]);
/**
 * Returns the block to be directly inserted by the block appender.
 *
 * @param    {Object}         state            Editor state.
 * @param    {?string}        rootClientId     Optional root client ID of block list.
 *
 * @return {?WPDirectInsertBlock}              The block type to be directly inserted.
 *
 * @typedef {Object} WPDirectInsertBlock
 * @property {string}         name             The type of block.
 * @property {?Object}        attributes       Attributes to pass to the newly created block.
 * @property {?Array<string>} attributesToCopy Attributes to be copied from adjecent blocks when inserted.
 */

const __experimentalGetDirectInsertBlock = rememo(function (state) {
  var _state$blockListSetti, _state$blockListSetti2;

  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

  if (!rootClientId) {
    return;
  }

  const defaultBlock = (_state$blockListSetti = state.blockListSettings[rootClientId]) === null || _state$blockListSetti === void 0 ? void 0 : _state$blockListSetti.__experimentalDefaultBlock;
  const directInsert = (_state$blockListSetti2 = state.blockListSettings[rootClientId]) === null || _state$blockListSetti2 === void 0 ? void 0 : _state$blockListSetti2.__experimentalDirectInsert;

  if (!defaultBlock || !directInsert) {
    return;
  }

  if (typeof directInsert === 'function') {
    return directInsert(getBlock(state, rootClientId)) ? defaultBlock : null;
  }

  return defaultBlock;
}, (state, rootClientId) => [state.blockListSettings[rootClientId], state.blocks.tree.get(rootClientId)]);

const checkAllowListRecursive = (blocks, allowedBlockTypes) => {
  if (typeof allowedBlockTypes === 'boolean') {
    return allowedBlockTypes;
  }

  const blocksQueue = [...blocks];

  while (blocksQueue.length > 0) {
    var _block$innerBlocks;

    const block = blocksQueue.shift();
    const isAllowed = checkAllowList(allowedBlockTypes, block.name || block.blockName, true);

    if (!isAllowed) {
      return false;
    }

    (_block$innerBlocks = block.innerBlocks) === null || _block$innerBlocks === void 0 ? void 0 : _block$innerBlocks.forEach(innerBlock => {
      blocksQueue.push(innerBlock);
    });
  }

  return true;
};

const __experimentalGetParsedPattern = rememo((state, patternName) => {
  const patterns = state.settings.__experimentalBlockPatterns;
  const pattern = patterns.find(_ref7 => {
    let {
      name
    } = _ref7;
    return name === patternName;
  });

  if (!pattern) {
    return null;
  }

  return { ...pattern,
    blocks: (0,external_wp_blocks_namespaceObject.parse)(pattern.content, {
      __unstableSkipMigrationLogs: true
    })
  };
}, state => [state.settings.__experimentalBlockPatterns]);
const getAllAllowedPatterns = rememo(state => {
  const patterns = state.settings.__experimentalBlockPatterns;
  const {
    allowedBlockTypes
  } = getSettings(state);
  const parsedPatterns = patterns.filter(_ref8 => {
    let {
      inserter = true
    } = _ref8;
    return !!inserter;
  }).map(_ref9 => {
    let {
      name
    } = _ref9;
    return __experimentalGetParsedPattern(state, name);
  });
  const allowedPatterns = parsedPatterns.filter(_ref10 => {
    let {
      blocks
    } = _ref10;
    return checkAllowListRecursive(blocks, allowedBlockTypes);
  });
  return allowedPatterns;
}, state => [state.settings.__experimentalBlockPatterns, state.settings.allowedBlockTypes]);
/**
 * Returns the list of allowed patterns for inner blocks children.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional target root client ID.
 *
 * @return {Array?} The list of allowed patterns.
 */

const __experimentalGetAllowedPatterns = rememo(function (state) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  const availableParsedPatterns = getAllAllowedPatterns(state);
  const patternsAllowed = availableParsedPatterns.filter(_ref11 => {
    let {
      blocks
    } = _ref11;
    return blocks.every(_ref12 => {
      let {
        name
      } = _ref12;
      return canInsertBlockType(state, name, rootClientId);
    });
  });
  return patternsAllowed;
}, (state, rootClientId) => [state.settings.__experimentalBlockPatterns, state.settings.allowedBlockTypes, state.settings.templateLock, state.blockListSettings[rootClientId], state.blocks.byClientId.get(rootClientId)]);
/**
 * Returns the list of patterns based on their declared `blockTypes`
 * and a block's name.
 * Patterns can use `blockTypes` to integrate in work flows like
 * suggesting appropriate patterns in a Placeholder state(during insertion)
 * or blocks transformations.
 *
 * @param {Object}          state        Editor state.
 * @param {string|string[]} blockNames   Block's name or array of block names to find matching pattens.
 * @param {?string}         rootClientId Optional target root client ID.
 *
 * @return {Array} The list of matched block patterns based on declared `blockTypes` and block name.
 */

const getPatternsByBlockTypes = rememo(function (state, blockNames) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  if (!blockNames) return EMPTY_ARRAY;

  const patterns = __experimentalGetAllowedPatterns(state, rootClientId);

  const normalizedBlockNames = Array.isArray(blockNames) ? blockNames : [blockNames];
  const filteredPatterns = patterns.filter(pattern => {
    var _pattern$blockTypes, _pattern$blockTypes$s;

    return pattern === null || pattern === void 0 ? void 0 : (_pattern$blockTypes = pattern.blockTypes) === null || _pattern$blockTypes === void 0 ? void 0 : (_pattern$blockTypes$s = _pattern$blockTypes.some) === null || _pattern$blockTypes$s === void 0 ? void 0 : _pattern$blockTypes$s.call(_pattern$blockTypes, blockName => normalizedBlockNames.includes(blockName));
  });

  if (filteredPatterns.length === 0) {
    return EMPTY_ARRAY;
  }

  return filteredPatterns;
}, (state, blockNames, rootClientId) => [...__experimentalGetAllowedPatterns.getDependants(state, rootClientId)]);
const __experimentalGetPatternsByBlockTypes = rememo(function (state, blockNames) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  external_wp_deprecated_default()('wp.data.select( "core/block-editor" ).__experimentalGetPatternsByBlockTypes', {
    alternative: 'wp.data.select( "core/block-editor" ).getPatternsByBlockTypes',
    since: '6.2',
    version: '6.4'
  });
  return getPatternsByBlockTypes(state, blockNames, rootClientId);
}, (state, blockNames, rootClientId) => [...__experimentalGetAllowedPatterns.getDependants(state, rootClientId)]);
/**
 * Determines the items that appear in the available pattern transforms list.
 *
 * For now we only handle blocks without InnerBlocks and take into account
 * the `__experimentalRole` property of blocks' attributes for the transformation.
 *
 * We return the first set of possible eligible block patterns,
 * by checking the `blockTypes` property. We still have to recurse through
 * block pattern's blocks and try to find matches from the selected blocks.
 * Now this happens in the consumer to avoid heavy operations in the selector.
 *
 * @param {Object}   state        Editor state.
 * @param {Object[]} blocks       The selected blocks.
 * @param {?string}  rootClientId Optional root client ID of block list.
 *
 * @return {WPBlockPattern[]} Items that are eligible for a pattern transformation.
 */

const __experimentalGetPatternTransformItems = rememo(function (state, blocks) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  if (!blocks) return EMPTY_ARRAY;
  /**
   * For now we only handle blocks without InnerBlocks and take into account
   * the `__experimentalRole` property of blocks' attributes for the transformation.
   * Note that the blocks have been retrieved through `getBlock`, which doesn't
   * return the inner blocks of an inner block controller, so we still need
   * to check for this case too.
   */

  if (blocks.some(_ref13 => {
    let {
      clientId,
      innerBlocks
    } = _ref13;
    return innerBlocks.length || areInnerBlocksControlled(state, clientId);
  })) {
    return EMPTY_ARRAY;
  } // Create a Set of the selected block names that is used in patterns filtering.


  const selectedBlockNames = Array.from(new Set(blocks.map(_ref14 => {
    let {
      name
    } = _ref14;
    return name;
  })));
  /**
   * Here we will return first set of possible eligible block patterns,
   * by checking the `blockTypes` property. We still have to recurse through
   * block pattern's blocks and try to find matches from the selected blocks.
   * Now this happens in the consumer to avoid heavy operations in the selector.
   */

  return getPatternsByBlockTypes(state, selectedBlockNames, rootClientId);
}, (state, blocks, rootClientId) => [...getPatternsByBlockTypes.getDependants(state, rootClientId)]);
/**
 * Returns the Block List settings of a block, if any exist.
 *
 * @param {Object}  state    Editor state.
 * @param {?string} clientId Block client ID.
 *
 * @return {?Object} Block settings of the block if set.
 */

function getBlockListSettings(state, clientId) {
  return state.blockListSettings[clientId];
}
/**
 * Returns the editor settings.
 *
 * @param {Object} state Editor state.
 *
 * @return {Object} The editor settings object.
 */

function getSettings(state) {
  return state.settings;
}
/**
 * Returns true if the most recent block change is be considered persistent, or
 * false otherwise. A persistent change is one committed by BlockEditorProvider
 * via its `onChange` callback, in addition to `onInput`.
 *
 * @param {Object} state Block editor state.
 *
 * @return {boolean} Whether the most recent block change was persistent.
 */

function isLastBlockChangePersistent(state) {
  return state.blocks.isPersistentChange;
}
/**
 * Returns the block list settings for an array of blocks, if any exist.
 *
 * @param {Object} state     Editor state.
 * @param {Array}  clientIds Block client IDs.
 *
 * @return {Object} An object where the keys are client ids and the values are
 *                  a block list setting object.
 */

const __experimentalGetBlockListSettingsForBlocks = rememo(function (state) {
  let clientIds = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
  return clientIds.reduce((blockListSettingsForBlocks, clientId) => {
    if (!state.blockListSettings[clientId]) {
      return blockListSettingsForBlocks;
    }

    return { ...blockListSettingsForBlocks,
      [clientId]: state.blockListSettings[clientId]
    };
  }, {});
}, state => [state.blockListSettings]);
/**
 * Returns the title of a given reusable block
 *
 * @param {Object}        state Global application state.
 * @param {number|string} ref   The shared block's ID.
 *
 * @return {string} The reusable block saved title.
 */

const __experimentalGetReusableBlockTitle = rememo((state, ref) => {
  var _reusableBlock$title;

  const reusableBlock = getReusableBlocks(state).find(block => block.id === ref);

  if (!reusableBlock) {
    return null;
  }

  return (_reusableBlock$title = reusableBlock.title) === null || _reusableBlock$title === void 0 ? void 0 : _reusableBlock$title.raw;
}, state => [getReusableBlocks(state)]);
/**
 * Returns true if the most recent block change is be considered ignored, or
 * false otherwise. An ignored change is one not to be committed by
 * BlockEditorProvider, neither via `onChange` nor `onInput`.
 *
 * @param {Object} state Block editor state.
 *
 * @return {boolean} Whether the most recent block change was ignored.
 */

function __unstableIsLastBlockChangeIgnored(state) {
  // TODO: Removal Plan: Changes incurred by RECEIVE_BLOCKS should not be
  // ignored if in-fact they result in a change in blocks state. The current
  // need to ignore changes not a result of user interaction should be
  // accounted for in the refactoring of reusable blocks as occurring within
  // their own separate block editor / state (#7119).
  return state.blocks.isIgnoredChange;
}
/**
 * Returns the block attributes changed as a result of the last dispatched
 * action.
 *
 * @param {Object} state Block editor state.
 *
 * @return {Object<string,Object>} Subsets of block attributes changed, keyed
 *                                 by block client ID.
 */

function __experimentalGetLastBlockAttributeChanges(state) {
  return state.lastBlockAttributesChange;
}
/**
 * Returns the available reusable blocks
 *
 * @param {Object} state Global application state.
 *
 * @return {Array} Reusable blocks
 */

function getReusableBlocks(state) {
  var _state$settings$__exp, _state$settings2;

  return (_state$settings$__exp = state === null || state === void 0 ? void 0 : (_state$settings2 = state.settings) === null || _state$settings2 === void 0 ? void 0 : _state$settings2.__experimentalReusableBlocks) !== null && _state$settings$__exp !== void 0 ? _state$settings$__exp : EMPTY_ARRAY;
}
/**
 * Returns whether the navigation mode is enabled.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Is navigation mode enabled.
 */


function isNavigationMode(state) {
  return state.editorMode === 'navigation';
}
/**
 * Returns the current editor mode.
 *
 * @param {Object} state Editor state.
 *
 * @return {string} the editor mode.
 */

function __unstableGetEditorMode(state) {
  return state.editorMode;
}
/**
 * Returns whether block moving mode is enabled.
 *
 * @param {Object} state Editor state.
 *
 * @return {string} Client Id of moving block.
 */

function selectors_hasBlockMovingClientId(state) {
  return state.hasBlockMovingClientId;
}
/**
 * Returns true if the last change was an automatic change, false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether the last change was automatic.
 */

function didAutomaticChange(state) {
  return !!state.automaticChangeStatus;
}
/**
 * Returns true if the current highlighted block matches the block clientId.
 *
 * @param {Object} state    Global application state.
 * @param {string} clientId The block to check.
 *
 * @return {boolean} Whether the block is currently highlighted.
 */

function isBlockHighlighted(state, clientId) {
  return state.highlightedBlock === clientId;
}
/**
 * Checks if a given block has controlled inner blocks.
 *
 * @param {Object} state    Global application state.
 * @param {string} clientId The block to check.
 *
 * @return {boolean} True if the block has controlled inner blocks.
 */

function areInnerBlocksControlled(state, clientId) {
  return !!state.blocks.controlledInnerBlocks[clientId];
}
/**
 * Returns the clientId for the first 'active' block of a given array of block names.
 * A block is 'active' if it (or a child) is the selected block.
 * Returns the first match moving up the DOM from the selected block.
 *
 * @param {Object}   state            Global application state.
 * @param {string[]} validBlocksNames The names of block types to check for.
 *
 * @return {string} The matching block's clientId.
 */

const __experimentalGetActiveBlockIdByBlockNames = rememo((state, validBlockNames) => {
  if (!validBlockNames.length) {
    return null;
  } // Check if selected block is a valid entity area.


  const selectedBlockClientId = getSelectedBlockClientId(state);

  if (validBlockNames.includes(getBlockName(state, selectedBlockClientId))) {
    return selectedBlockClientId;
  } // Check if first selected block is a child of a valid entity area.


  const multiSelectedBlockClientIds = getMultiSelectedBlockClientIds(state);
  const entityAreaParents = getBlockParentsByBlockName(state, selectedBlockClientId || multiSelectedBlockClientIds[0], validBlockNames);

  if (entityAreaParents) {
    // Last parent closest/most interior.
    return entityAreaParents[entityAreaParents.length - 1];
  }

  return null;
}, (state, validBlockNames) => [state.selection.selectionStart.clientId, state.selection.selectionEnd.clientId, validBlockNames]);
/**
 * Tells if the block with the passed clientId was just inserted.
 *
 * @param {Object}  state    Global application state.
 * @param {Object}  clientId Client Id of the block.
 * @param {?string} source   Optional insertion source of the block.
 * @return {boolean} True if the block matches the last block inserted from the specified source.
 */

function wasBlockJustInserted(state, clientId, source) {
  var _lastBlockInserted$cl;

  const {
    lastBlockInserted
  } = state;
  return ((_lastBlockInserted$cl = lastBlockInserted.clientIds) === null || _lastBlockInserted$cl === void 0 ? void 0 : _lastBlockInserted$cl.includes(clientId)) && lastBlockInserted.source === source;
}
/**
 * Tells if the block is visible on the canvas or not.
 *
 * @param {Object} state    Global application state.
 * @param {Object} clientId Client Id of the block.
 * @return {boolean} True if the block is visible.
 */

function isBlockVisible(state, clientId) {
  var _state$blockVisibilit, _state$blockVisibilit2;

  return (_state$blockVisibilit = (_state$blockVisibilit2 = state.blockVisibility) === null || _state$blockVisibilit2 === void 0 ? void 0 : _state$blockVisibilit2[clientId]) !== null && _state$blockVisibilit !== void 0 ? _state$blockVisibilit : true;
}
/**
 * Returns the list of all hidden blocks.
 *
 * @param {Object} state Global application state.
 * @return {[string]} List of hidden blocks.
 */

const __unstableGetVisibleBlocks = rememo(state => {
  return new Set(Object.keys(state.blockVisibility).filter(key => state.blockVisibility[key]));
}, state => [state.blockVisibility]);
/**
 * DO-NOT-USE in production.
 * This selector is created for internal/experimental only usage and may be
 * removed anytime without any warning, causing breakage on any plugin or theme invoking it.
 */

const __unstableGetContentLockingParent = rememo((state, clientId) => {
  let current = clientId;
  let result;

  while (state.blocks.parents.has(current)) {
    current = state.blocks.parents.get(current);

    if (current && getTemplateLock(state, current) === 'contentOnly') {
      result = current;
    }
  }

  return result;
}, state => [state.blocks.parents, state.blockListSettings]);
/**
 * DO-NOT-USE in production.
 * This selector is created for internal/experimental only usage and may be
 * removed anytime without any warning, causing breakage on any plugin or theme invoking it.
 *
 * @param {Object} state Global application state.
 */

function __unstableGetTemporarilyEditingAsBlocks(state) {
  return state.temporarilyEditingAsBlocks;
}
function __unstableHasActiveBlockOverlayActive(state, clientId) {
  // If the block editing is locked, the block overlay is always active.
  if (!canEditBlock(state, clientId)) {
    return true;
  }

  const editorMode = __unstableGetEditorMode(state); // In zoom-out mode, the block overlay is always active for top level blocks.


  if (editorMode === 'zoom-out' && clientId && !getBlockRootClientId(state, clientId)) {
    return true;
  } // In navigation mode, the block overlay is active when the block is not
  // selected (and doesn't contain a selected child). The same behavior is
  // also enabled in all modes for blocks that have controlled children
  // (reusable block, template part, navigation), unless explicitly disabled
  // with `supports.__experimentalDisableBlockOverlay`.


  const blockSupportDisable = (0,external_wp_blocks_namespaceObject.hasBlockSupport)(getBlockName(state, clientId), '__experimentalDisableBlockOverlay', false);
  const shouldEnableIfUnselected = editorMode === 'navigation' || (blockSupportDisable ? false : areInnerBlocksControlled(state, clientId));
  return shouldEnableIfUnselected && !isBlockSelected(state, clientId) && !hasSelectedInnerBlock(state, clientId, true);
}
function __unstableIsWithinBlockOverlay(state, clientId) {
  let parent = state.blocks.parents.get(clientId);

  while (!!parent) {
    if (__unstableHasActiveBlockOverlayActive(state, parent)) {
      return true;
    }

    parent = state.blocks.parents.get(parent);
  }

  return false;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/private-actions.js
/**
 * WordPress dependencies
 */

/**
 * A list of private/experimental block editor settings that
 * should not become a part of the WordPress public API.
 * BlockEditorProvider will remove these settings from the
 * settings object it receives.
 *
 * @see https://github.com/WordPress/gutenberg/pull/46131
 */

const privateSettings = ['inserterMediaCategories', 'blockInspectorAnimation'];
/**
 * Action that updates the block editor settings and
 * conditionally preserves the experimental ones.
 *
 * @param {Object}  settings                  Updated settings
 * @param {boolean} stripExperimentalSettings Whether to strip experimental settings.
 * @return {Object} Action object
 */

function __experimentalUpdateSettings(settings) {
  let stripExperimentalSettings = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  let cleanSettings = settings; // There are no plugins in the mobile apps, so there is no
  // need to strip the experimental settings:

  if (stripExperimentalSettings && external_wp_element_namespaceObject.Platform.OS === 'web') {
    cleanSettings = {};

    for (const key in settings) {
      if (!privateSettings.includes(key)) {
        cleanSettings[key] = settings[key];
      }
    }
  }

  return {
    type: 'UPDATE_SETTINGS',
    settings: cleanSettings
  };
}
/**
 * Hides the block interface (eg. toolbar, outline, etc.)
 *
 * @return {Object} Action object.
 */

function hideBlockInterface() {
  return {
    type: 'HIDE_BLOCK_INTERFACE'
  };
}
/**
 * Shows the block interface (eg. toolbar, outline, etc.)
 *
 * @return {Object} Action object.
 */

function showBlockInterface() {
  return {
    type: 'SHOW_BLOCK_INTERFACE'
  };
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/private-selectors.js
/**
 * Returns true if the block interface is hidden, or false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether the block toolbar is hidden.
 */
function private_selectors_isBlockInterfaceHidden(state) {
  return state.isBlockInterfaceHidden;
}
/**
 * Gets the client ids of the last inserted blocks.
 *
 * @param {Object} state Global application state.
 * @return {Array|undefined} Client Ids of the last inserted block(s).
 */

function getLastInsertedBlocksClientIds(state) {
  var _state$lastBlockInser;

  return state === null || state === void 0 ? void 0 : (_state$lastBlockInser = state.lastBlockInserted) === null || _state$lastBlockInser === void 0 ? void 0 : _state$lastBlockInser.clientIds;
}

;// CONCATENATED MODULE: external ["wp","a11y"]
var external_wp_a11y_namespaceObject = window["wp"]["a11y"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/utils/selection.js
/**
 * A robust way to retain selection position through various
 * transforms is to insert a special character at the position and
 * then recover it.
 */
const START_OF_SELECTED_AREA = '\u0086';
/**
 * Retrieve the block attribute that contains the selection position.
 *
 * @param {Object} blockAttributes Block attributes.
 * @return {string|void} The name of the block attribute that was previously selected.
 */

function retrieveSelectedAttribute(blockAttributes) {
  if (!blockAttributes) {
    return;
  }

  return Object.keys(blockAttributes).find(name => {
    const value = blockAttributes[name];
    return typeof value === 'string' && value.indexOf(START_OF_SELECTED_AREA) !== -1;
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/actions.js
/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */




/** @typedef {import('../components/use-on-block-drop/types').WPDropOperation} WPDropOperation */

const castArray = maybeArray => Array.isArray(maybeArray) ? maybeArray : [maybeArray];
/**
 * Action which will insert a default block insert action if there
 * are no other blocks at the root of the editor. This action should be used
 * in actions which may result in no blocks remaining in the editor (removal,
 * replacement, etc).
 */


const ensureDefaultBlock = () => _ref => {
  let {
    select,
    dispatch
  } = _ref;
  // To avoid a focus loss when removing the last block, assure there is
  // always a default block if the last of the blocks have been removed.
  const count = select.getBlockCount();

  if (count > 0) {
    return;
  } // If there's an custom appender, don't insert default block.
  // We have to remember to manually move the focus elsewhere to
  // prevent it from being lost though.


  const {
    __unstableHasCustomAppender
  } = select.getSettings();

  if (__unstableHasCustomAppender) {
    return;
  }

  dispatch.insertDefaultBlock();
};
/**
 * Action that resets blocks state to the specified array of blocks, taking precedence
 * over any other content reflected as an edit in state.
 *
 * @param {Array} blocks Array of blocks.
 */


const resetBlocks = blocks => _ref2 => {
  let {
    dispatch
  } = _ref2;
  dispatch({
    type: 'RESET_BLOCKS',
    blocks
  });
  dispatch(validateBlocksToTemplate(blocks));
};
/**
 * Block validity is a function of blocks state (at the point of a
 * reset) and the template setting. As a compromise to its placement
 * across distinct parts of state, it is implemented here as a side-
 * effect of the block reset action.
 *
 * @param {Array} blocks Array of blocks.
 */

const validateBlocksToTemplate = blocks => _ref3 => {
  let {
    select,
    dispatch
  } = _ref3;
  const template = select.getTemplate();
  const templateLock = select.getTemplateLock(); // Unlocked templates are considered always valid because they act
  // as default values only.

  const isBlocksValidToTemplate = !template || templateLock !== 'all' || (0,external_wp_blocks_namespaceObject.doBlocksMatchTemplate)(blocks, template); // Update if validity has changed.

  const isValidTemplate = select.isValidTemplate();

  if (isBlocksValidToTemplate !== isValidTemplate) {
    dispatch.setTemplateValidity(isBlocksValidToTemplate);
    return isBlocksValidToTemplate;
  }
};
/**
 * A block selection object.
 *
 * @typedef {Object} WPBlockSelection
 *
 * @property {string} clientId     A block client ID.
 * @property {string} attributeKey A block attribute key.
 * @property {number} offset       An attribute value offset, based on the rich
 *                                 text value. See `wp.richText.create`.
 */

/**
 * A selection object.
 *
 * @typedef {Object} WPSelection
 *
 * @property {WPBlockSelection} start The selection start.
 * @property {WPBlockSelection} end   The selection end.
 */

/* eslint-disable jsdoc/valid-types */

/**
 * Returns an action object used in signalling that selection state should be
 * reset to the specified selection.
 *
 * @param {WPBlockSelection} selectionStart  The selection start.
 * @param {WPBlockSelection} selectionEnd    The selection end.
 * @param {0|-1|null}        initialPosition Initial block position.
 *
 * @return {Object} Action object.
 */

function resetSelection(selectionStart, selectionEnd, initialPosition) {
  /* eslint-enable jsdoc/valid-types */
  return {
    type: 'RESET_SELECTION',
    selectionStart,
    selectionEnd,
    initialPosition
  };
}
/**
 * Returns an action object used in signalling that blocks have been received.
 * Unlike resetBlocks, these should be appended to the existing known set, not
 * replacing.
 *
 * @deprecated
 *
 * @param {Object[]} blocks Array of block objects.
 *
 * @return {Object} Action object.
 */

function receiveBlocks(blocks) {
  external_wp_deprecated_default()('wp.data.dispatch( "core/block-editor" ).receiveBlocks', {
    since: '5.9',
    alternative: 'resetBlocks or insertBlocks'
  });
  return {
    type: 'RECEIVE_BLOCKS',
    blocks
  };
}
/**
 * Action that updates attributes of multiple blocks with the specified client IDs.
 *
 * @param {string|string[]} clientIds     Block client IDs.
 * @param {Object}          attributes    Block attributes to be merged. Should be keyed by clientIds if
 *                                        uniqueByBlock is true.
 * @param {boolean}         uniqueByBlock true if each block in clientIds array has a unique set of attributes
 * @return {Object} Action object.
 */

function updateBlockAttributes(clientIds, attributes) {
  let uniqueByBlock = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  return {
    type: 'UPDATE_BLOCK_ATTRIBUTES',
    clientIds: castArray(clientIds),
    attributes,
    uniqueByBlock
  };
}
/**
 * Action that updates the block with the specified client ID.
 *
 * @param {string} clientId Block client ID.
 * @param {Object} updates  Block attributes to be merged.
 *
 * @return {Object} Action object.
 */

function updateBlock(clientId, updates) {
  return {
    type: 'UPDATE_BLOCK',
    clientId,
    updates
  };
}
/* eslint-disable jsdoc/valid-types */

/**
 * Returns an action object used in signalling that the block with the
 * specified client ID has been selected, optionally accepting a position
 * value reflecting its selection directionality. An initialPosition of -1
 * reflects a reverse selection.
 *
 * @param {string}    clientId        Block client ID.
 * @param {0|-1|null} initialPosition Optional initial position. Pass as -1 to
 *                                    reflect reverse selection.
 *
 * @return {Object} Action object.
 */

function selectBlock(clientId) {
  let initialPosition = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

  /* eslint-enable jsdoc/valid-types */
  return {
    type: 'SELECT_BLOCK',
    initialPosition,
    clientId
  };
}
/**
 * Yields action objects used in signalling that the block preceding the given
 * clientId (or optionally, its first parent from bottom to top)
 * should be selected.
 *
 * @param {string}  clientId         Block client ID.
 * @param {boolean} fallbackToParent If true, select the first parent if there is no previous block.
 */

const selectPreviousBlock = function (clientId) {
  let fallbackToParent = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  return _ref4 => {
    let {
      select,
      dispatch
    } = _ref4;
    const previousBlockClientId = select.getPreviousBlockClientId(clientId);

    if (previousBlockClientId) {
      dispatch.selectBlock(previousBlockClientId, -1);
    } else if (fallbackToParent) {
      const firstParentClientId = select.getBlockRootClientId(clientId);

      if (firstParentClientId) {
        dispatch.selectBlock(firstParentClientId, -1);
      }
    }
  };
};
/**
 * Yields action objects used in signalling that the block following the given
 * clientId should be selected.
 *
 * @param {string} clientId Block client ID.
 */

const selectNextBlock = clientId => _ref5 => {
  let {
    select,
    dispatch
  } = _ref5;
  const nextBlockClientId = select.getNextBlockClientId(clientId);

  if (nextBlockClientId) {
    dispatch.selectBlock(nextBlockClientId);
  }
};
/**
 * Action that starts block multi-selection.
 *
 * @return {Object} Action object.
 */

function startMultiSelect() {
  return {
    type: 'START_MULTI_SELECT'
  };
}
/**
 * Action that stops block multi-selection.
 *
 * @return {Object} Action object.
 */

function stopMultiSelect() {
  return {
    type: 'STOP_MULTI_SELECT'
  };
}
/**
 * Action that changes block multi-selection.
 *
 * @param {string}      start                         First block of the multi selection.
 * @param {string}      end                           Last block of the multiselection.
 * @param {number|null} __experimentalInitialPosition Optional initial position. Pass as null to skip focus within editor canvas.
 */

const multiSelect = function (start, end) {
  let __experimentalInitialPosition = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

  return _ref6 => {
    let {
      select,
      dispatch
    } = _ref6;
    const startBlockRootClientId = select.getBlockRootClientId(start);
    const endBlockRootClientId = select.getBlockRootClientId(end); // Only allow block multi-selections at the same level.

    if (startBlockRootClientId !== endBlockRootClientId) {
      return;
    }

    dispatch({
      type: 'MULTI_SELECT',
      start,
      end,
      initialPosition: __experimentalInitialPosition
    });
    const blockCount = select.getSelectedBlockCount();
    (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: %s: number of selected blocks */
    (0,external_wp_i18n_namespaceObject._n)('%s block selected.', '%s blocks selected.', blockCount), blockCount), 'assertive');
  };
};
/**
 * Action that clears the block selection.
 *
 * @return {Object} Action object.
 */

function clearSelectedBlock() {
  return {
    type: 'CLEAR_SELECTED_BLOCK'
  };
}
/**
 * Action that enables or disables block selection.
 *
 * @param {boolean} [isSelectionEnabled=true] Whether block selection should
 *                                            be enabled.
 *
 * @return {Object} Action object.
 */

function toggleSelection() {
  let isSelectionEnabled = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
  return {
    type: 'TOGGLE_SELECTION',
    isSelectionEnabled
  };
}

function getBlocksWithDefaultStylesApplied(blocks, blockEditorSettings) {
  var _blockEditorSettings$, _blockEditorSettings$2;

  const preferredStyleVariations = (_blockEditorSettings$ = blockEditorSettings === null || blockEditorSettings === void 0 ? void 0 : (_blockEditorSettings$2 = blockEditorSettings.__experimentalPreferredStyleVariations) === null || _blockEditorSettings$2 === void 0 ? void 0 : _blockEditorSettings$2.value) !== null && _blockEditorSettings$ !== void 0 ? _blockEditorSettings$ : {};
  return blocks.map(block => {
    var _block$attributes;

    const blockName = block.name;

    if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockName, 'defaultStylePicker', true)) {
      return block;
    }

    if (!preferredStyleVariations[blockName]) {
      return block;
    }

    const className = (_block$attributes = block.attributes) === null || _block$attributes === void 0 ? void 0 : _block$attributes.className;

    if (className !== null && className !== void 0 && className.includes('is-style-')) {
      return block;
    }

    const {
      attributes = {}
    } = block;
    const blockStyle = preferredStyleVariations[blockName];
    return { ...block,
      attributes: { ...attributes,
        className: `${className || ''} is-style-${blockStyle}`.trim()
      }
    };
  });
}
/* eslint-disable jsdoc/valid-types */

/**
 * Action that replaces given blocks with one or more replacement blocks.
 *
 * @param {(string|string[])} clientIds       Block client ID(s) to replace.
 * @param {(Object|Object[])} blocks          Replacement block(s).
 * @param {number}            indexToSelect   Index of replacement block to select.
 * @param {0|-1|null}         initialPosition Index of caret after in the selected block after the operation.
 * @param {?Object}           meta            Optional Meta values to be passed to the action object.
 *
 * @return {Object} Action object.
 */


const replaceBlocks = function (clientIds, blocks, indexToSelect) {
  let initialPosition = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
  let meta = arguments.length > 4 ? arguments[4] : undefined;
  return _ref7 => {
    let {
      select,
      dispatch
    } = _ref7;

    /* eslint-enable jsdoc/valid-types */
    clientIds = castArray(clientIds);
    blocks = getBlocksWithDefaultStylesApplied(castArray(blocks), select.getSettings());
    const rootClientId = select.getBlockRootClientId(clientIds[0]); // Replace is valid if the new blocks can be inserted in the root block.

    for (let index = 0; index < blocks.length; index++) {
      const block = blocks[index];
      const canInsertBlock = select.canInsertBlockType(block.name, rootClientId);

      if (!canInsertBlock) {
        return;
      }
    }

    dispatch({
      type: 'REPLACE_BLOCKS',
      clientIds,
      blocks,
      time: Date.now(),
      indexToSelect,
      initialPosition,
      meta
    });
    dispatch(ensureDefaultBlock());
  };
};
/**
 * Action that replaces a single block with one or more replacement blocks.
 *
 * @param {(string|string[])} clientId Block client ID to replace.
 * @param {(Object|Object[])} block    Replacement block(s).
 *
 * @return {Object} Action object.
 */

function replaceBlock(clientId, block) {
  return replaceBlocks(clientId, block);
}
/**
 * Higher-order action creator which, given the action type to dispatch creates
 * an action creator for managing block movement.
 *
 * @param {string} type Action type to dispatch.
 *
 * @return {Function} Action creator.
 */

const createOnMove = type => (clientIds, rootClientId) => _ref8 => {
  let {
    select,
    dispatch
  } = _ref8;
  // If one of the blocks is locked or the parent is locked, we cannot move any block.
  const canMoveBlocks = select.canMoveBlocks(clientIds, rootClientId);

  if (!canMoveBlocks) {
    return;
  }

  dispatch({
    type,
    clientIds: castArray(clientIds),
    rootClientId
  });
};

const moveBlocksDown = createOnMove('MOVE_BLOCKS_DOWN');
const moveBlocksUp = createOnMove('MOVE_BLOCKS_UP');
/**
 * Action that moves given blocks to a new position.
 *
 * @param {?string} clientIds        The client IDs of the blocks.
 * @param {?string} fromRootClientId Root client ID source.
 * @param {?string} toRootClientId   Root client ID destination.
 * @param {number}  index            The index to move the blocks to.
 */

const moveBlocksToPosition = function (clientIds) {
  let fromRootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  let toRootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
  let index = arguments.length > 3 ? arguments[3] : undefined;
  return _ref9 => {
    let {
      select,
      dispatch
    } = _ref9;
    const canMoveBlocks = select.canMoveBlocks(clientIds, fromRootClientId); // If one of the blocks is locked or the parent is locked, we cannot move any block.

    if (!canMoveBlocks) {
      return;
    } // If moving inside the same root block the move is always possible.


    if (fromRootClientId !== toRootClientId) {
      const canRemoveBlocks = select.canRemoveBlocks(clientIds, fromRootClientId); // If we're moving to another block, it means we're deleting blocks from
      // the original block, so we need to check if removing is possible.

      if (!canRemoveBlocks) {
        return;
      }

      const canInsertBlocks = select.canInsertBlocks(clientIds, toRootClientId); // If moving to other parent block, the move is possible if we can insert a block of the same type inside the new parent block.

      if (!canInsertBlocks) {
        return;
      }
    }

    dispatch({
      type: 'MOVE_BLOCKS_TO_POSITION',
      fromRootClientId,
      toRootClientId,
      clientIds,
      index
    });
  };
};
/**
 * Action that moves given block to a new position.
 *
 * @param {?string} clientId         The client ID of the block.
 * @param {?string} fromRootClientId Root client ID source.
 * @param {?string} toRootClientId   Root client ID destination.
 * @param {number}  index            The index to move the block to.
 */

function moveBlockToPosition(clientId) {
  let fromRootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  let toRootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
  let index = arguments.length > 3 ? arguments[3] : undefined;
  return moveBlocksToPosition([clientId], fromRootClientId, toRootClientId, index);
}
/**
 * Action that inserts a single block, optionally at a specific index respective a root block list.
 *
 * @param {Object}   block           Block object to insert.
 * @param {?number}  index           Index at which block should be inserted.
 * @param {?string}  rootClientId    Optional root client ID of block list on which to insert.
 * @param {?boolean} updateSelection If true block selection will be updated. If false, block selection will not change. Defaults to true.
 * @param {?Object}  meta            Optional Meta values to be passed to the action object.
 *
 * @return {Object} Action object.
 */

function insertBlock(block, index, rootClientId, updateSelection, meta) {
  return insertBlocks([block], index, rootClientId, updateSelection, 0, meta);
}
/* eslint-disable jsdoc/valid-types */

/**
 * Action that inserts an array of blocks, optionally at a specific index respective a root block list.
 *
 * @param {Object[]}  blocks          Block objects to insert.
 * @param {?number}   index           Index at which block should be inserted.
 * @param {?string}   rootClientId    Optional root client ID of block list on which to insert.
 * @param {?boolean}  updateSelection If true block selection will be updated.  If false, block selection will not change. Defaults to true.
 * @param {0|-1|null} initialPosition Initial focus position. Setting it to null prevent focusing the inserted block.
 * @param {?Object}   meta            Optional Meta values to be passed to the action object.
 * @return {Object} Action object.
 */

const insertBlocks = function (blocks, index, rootClientId) {
  let updateSelection = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
  let initialPosition = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
  let meta = arguments.length > 5 ? arguments[5] : undefined;
  return _ref10 => {
    let {
      select,
      dispatch
    } = _ref10;

    /* eslint-enable jsdoc/valid-types */
    if (initialPosition !== null && typeof initialPosition === 'object') {
      meta = initialPosition;
      initialPosition = 0;
      external_wp_deprecated_default()("meta argument in wp.data.dispatch('core/block-editor')", {
        since: '5.8',
        hint: 'The meta argument is now the 6th argument of the function'
      });
    }

    blocks = getBlocksWithDefaultStylesApplied(castArray(blocks), select.getSettings());
    const allowedBlocks = [];

    for (const block of blocks) {
      const isValid = select.canInsertBlockType(block.name, rootClientId);

      if (isValid) {
        allowedBlocks.push(block);
      }
    }

    if (allowedBlocks.length) {
      dispatch({
        type: 'INSERT_BLOCKS',
        blocks: allowedBlocks,
        index,
        rootClientId,
        time: Date.now(),
        updateSelection,
        initialPosition: updateSelection ? initialPosition : null,
        meta
      });
    }
  };
};
/**
 * Action that shows the insertion point.
 *
 * @param    {?string}         rootClientId           Optional root client ID of block list on
 *                                                    which to insert.
 * @param    {?number}         index                  Index at which block should be inserted.
 * @param    {?Object}         __unstableOptions      Additional options.
 * @property {boolean}         __unstableWithInserter Whether or not to show an inserter button.
 * @property {WPDropOperation} operation              The operation to perform when applied,
 *                                                    either 'insert' or 'replace' for now.
 *
 * @return {Object} Action object.
 */

function showInsertionPoint(rootClientId, index) {
  let __unstableOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

  const {
    __unstableWithInserter,
    operation
  } = __unstableOptions;
  return {
    type: 'SHOW_INSERTION_POINT',
    rootClientId,
    index,
    __unstableWithInserter,
    operation
  };
}
/**
 * Action that hides the insertion point.
 */

const hideInsertionPoint = () => _ref11 => {
  let {
    select,
    dispatch
  } = _ref11;

  if (!select.isBlockInsertionPointVisible()) {
    return;
  }

  dispatch({
    type: 'HIDE_INSERTION_POINT'
  });
};
/**
 * Action that resets the template validity.
 *
 * @param {boolean} isValid template validity flag.
 *
 * @return {Object} Action object.
 */

function setTemplateValidity(isValid) {
  return {
    type: 'SET_TEMPLATE_VALIDITY',
    isValid
  };
}
/**
 * Action that synchronizes the template with the list of blocks.
 *
 * @return {Object} Action object.
 */

const synchronizeTemplate = () => _ref12 => {
  let {
    select,
    dispatch
  } = _ref12;
  dispatch({
    type: 'SYNCHRONIZE_TEMPLATE'
  });
  const blocks = select.getBlocks();
  const template = select.getTemplate();
  const updatedBlockList = (0,external_wp_blocks_namespaceObject.synchronizeBlocksWithTemplate)(blocks, template);
  dispatch.resetBlocks(updatedBlockList);
};
/**
 * Delete the current selection.
 *
 * @param {boolean} isForward
 */

const __unstableDeleteSelection = isForward => _ref13 => {
  let {
    registry,
    select,
    dispatch
  } = _ref13;
  const selectionAnchor = select.getSelectionStart();
  const selectionFocus = select.getSelectionEnd();
  if (selectionAnchor.clientId === selectionFocus.clientId) return; // It's not mergeable if there's no rich text selection.

  if (!selectionAnchor.attributeKey || !selectionFocus.attributeKey || typeof selectionAnchor.offset === 'undefined' || typeof selectionFocus.offset === 'undefined') return false;
  const anchorRootClientId = select.getBlockRootClientId(selectionAnchor.clientId);
  const focusRootClientId = select.getBlockRootClientId(selectionFocus.clientId); // It's not mergeable if the selection doesn't start and end in the same
  // block list. Maybe in the future it should be allowed.

  if (anchorRootClientId !== focusRootClientId) {
    return;
  }

  const blockOrder = select.getBlockOrder(anchorRootClientId);
  const anchorIndex = blockOrder.indexOf(selectionAnchor.clientId);
  const focusIndex = blockOrder.indexOf(selectionFocus.clientId); // Reassign selection start and end based on order.

  let selectionStart, selectionEnd;

  if (anchorIndex > focusIndex) {
    selectionStart = selectionFocus;
    selectionEnd = selectionAnchor;
  } else {
    selectionStart = selectionAnchor;
    selectionEnd = selectionFocus;
  }

  const targetSelection = isForward ? selectionEnd : selectionStart;
  const targetBlock = select.getBlock(targetSelection.clientId);
  const targetBlockType = (0,external_wp_blocks_namespaceObject.getBlockType)(targetBlock.name);

  if (!targetBlockType.merge) {
    return;
  }

  const selectionA = selectionStart;
  const selectionB = selectionEnd;
  const blockA = select.getBlock(selectionA.clientId);
  const blockAType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockA.name);
  const blockB = select.getBlock(selectionB.clientId);
  const blockBType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockB.name);
  const htmlA = blockA.attributes[selectionA.attributeKey];
  const htmlB = blockB.attributes[selectionB.attributeKey];
  const attributeDefinitionA = blockAType.attributes[selectionA.attributeKey];
  const attributeDefinitionB = blockBType.attributes[selectionB.attributeKey];
  let valueA = (0,external_wp_richText_namespaceObject.create)({
    html: htmlA,
    ...mapRichTextSettings(attributeDefinitionA)
  });
  let valueB = (0,external_wp_richText_namespaceObject.create)({
    html: htmlB,
    ...mapRichTextSettings(attributeDefinitionB)
  });
  valueA = (0,external_wp_richText_namespaceObject.remove)(valueA, selectionA.offset, valueA.text.length);
  valueB = (0,external_wp_richText_namespaceObject.insert)(valueB, START_OF_SELECTED_AREA, 0, selectionB.offset); // Clone the blocks so we don't manipulate the original.

  const cloneA = (0,external_wp_blocks_namespaceObject.cloneBlock)(blockA, {
    [selectionA.attributeKey]: (0,external_wp_richText_namespaceObject.toHTMLString)({
      value: valueA,
      ...mapRichTextSettings(attributeDefinitionA)
    })
  });
  const cloneB = (0,external_wp_blocks_namespaceObject.cloneBlock)(blockB, {
    [selectionB.attributeKey]: (0,external_wp_richText_namespaceObject.toHTMLString)({
      value: valueB,
      ...mapRichTextSettings(attributeDefinitionB)
    })
  });
  const followingBlock = isForward ? cloneA : cloneB; // We can only merge blocks with similar types
  // thus, we transform the block to merge first

  const blocksWithTheSameType = blockA.name === blockB.name ? [followingBlock] : (0,external_wp_blocks_namespaceObject.switchToBlockType)(followingBlock, targetBlockType.name); // If the block types can not match, do nothing

  if (!blocksWithTheSameType || !blocksWithTheSameType.length) {
    return;
  }

  let updatedAttributes;

  if (isForward) {
    const blockToMerge = blocksWithTheSameType.pop();
    updatedAttributes = targetBlockType.merge(blockToMerge.attributes, cloneB.attributes);
  } else {
    const blockToMerge = blocksWithTheSameType.shift();
    updatedAttributes = targetBlockType.merge(cloneA.attributes, blockToMerge.attributes);
  }

  const newAttributeKey = retrieveSelectedAttribute(updatedAttributes);
  const convertedHtml = updatedAttributes[newAttributeKey];
  const convertedValue = (0,external_wp_richText_namespaceObject.create)({
    html: convertedHtml,
    ...mapRichTextSettings(targetBlockType.attributes[newAttributeKey])
  });
  const newOffset = convertedValue.text.indexOf(START_OF_SELECTED_AREA);
  const newValue = (0,external_wp_richText_namespaceObject.remove)(convertedValue, newOffset, newOffset + 1);
  const newHtml = (0,external_wp_richText_namespaceObject.toHTMLString)({
    value: newValue,
    ...mapRichTextSettings(targetBlockType.attributes[newAttributeKey])
  });
  updatedAttributes[newAttributeKey] = newHtml;
  const selectedBlockClientIds = select.getSelectedBlockClientIds();
  const replacement = [...(isForward ? blocksWithTheSameType : []), { // Preserve the original client ID.
    ...targetBlock,
    attributes: { ...targetBlock.attributes,
      ...updatedAttributes
    }
  }, ...(isForward ? [] : blocksWithTheSameType)];
  registry.batch(() => {
    dispatch.selectionChange(targetBlock.clientId, newAttributeKey, newOffset, newOffset);
    dispatch.replaceBlocks(selectedBlockClientIds, replacement, 0, // If we don't pass the `indexToSelect` it will default to the last block.
    select.getSelectedBlocksInitialCaretPosition());
  });
};
/**
 * Split the current selection.
 */

const __unstableSplitSelection = () => _ref14 => {
  let {
    select,
    dispatch
  } = _ref14;
  const selectionAnchor = select.getSelectionStart();
  const selectionFocus = select.getSelectionEnd();
  if (selectionAnchor.clientId === selectionFocus.clientId) return; // Can't split if the selection is not set.

  if (!selectionAnchor.attributeKey || !selectionFocus.attributeKey || typeof selectionAnchor.offset === 'undefined' || typeof selectionFocus.offset === 'undefined') return;
  const anchorRootClientId = select.getBlockRootClientId(selectionAnchor.clientId);
  const focusRootClientId = select.getBlockRootClientId(selectionFocus.clientId); // It's not splittable if the selection doesn't start and end in the same
  // block list. Maybe in the future it should be allowed.

  if (anchorRootClientId !== focusRootClientId) {
    return;
  }

  const blockOrder = select.getBlockOrder(anchorRootClientId);
  const anchorIndex = blockOrder.indexOf(selectionAnchor.clientId);
  const focusIndex = blockOrder.indexOf(selectionFocus.clientId); // Reassign selection start and end based on order.

  let selectionStart, selectionEnd;

  if (anchorIndex > focusIndex) {
    selectionStart = selectionFocus;
    selectionEnd = selectionAnchor;
  } else {
    selectionStart = selectionAnchor;
    selectionEnd = selectionFocus;
  }

  const selectionA = selectionStart;
  const selectionB = selectionEnd;
  const blockA = select.getBlock(selectionA.clientId);
  const blockAType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockA.name);
  const blockB = select.getBlock(selectionB.clientId);
  const blockBType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockB.name);
  const htmlA = blockA.attributes[selectionA.attributeKey];
  const htmlB = blockB.attributes[selectionB.attributeKey];
  const attributeDefinitionA = blockAType.attributes[selectionA.attributeKey];
  const attributeDefinitionB = blockBType.attributes[selectionB.attributeKey];
  let valueA = (0,external_wp_richText_namespaceObject.create)({
    html: htmlA,
    ...mapRichTextSettings(attributeDefinitionA)
  });
  let valueB = (0,external_wp_richText_namespaceObject.create)({
    html: htmlB,
    ...mapRichTextSettings(attributeDefinitionB)
  });
  valueA = (0,external_wp_richText_namespaceObject.remove)(valueA, selectionA.offset, valueA.text.length);
  valueB = (0,external_wp_richText_namespaceObject.remove)(valueB, 0, selectionB.offset);
  dispatch.replaceBlocks(select.getSelectedBlockClientIds(), [{ // Preserve the original client ID.
    ...blockA,
    attributes: { ...blockA.attributes,
      [selectionA.attributeKey]: (0,external_wp_richText_namespaceObject.toHTMLString)({
        value: valueA,
        ...mapRichTextSettings(attributeDefinitionA)
      })
    }
  }, (0,external_wp_blocks_namespaceObject.createBlock)((0,external_wp_blocks_namespaceObject.getDefaultBlockName)()), { // Preserve the original client ID.
    ...blockB,
    attributes: { ...blockB.attributes,
      [selectionB.attributeKey]: (0,external_wp_richText_namespaceObject.toHTMLString)({
        value: valueB,
        ...mapRichTextSettings(attributeDefinitionB)
      })
    }
  }], 1, // If we don't pass the `indexToSelect` it will default to the last block.
  select.getSelectedBlocksInitialCaretPosition());
};
/**
 * Expand the selection to cover the entire blocks, removing partial selection.
 */

const __unstableExpandSelection = () => _ref15 => {
  let {
    select,
    dispatch
  } = _ref15;
  const selectionAnchor = select.getSelectionStart();
  const selectionFocus = select.getSelectionEnd();
  dispatch.selectionChange({
    start: {
      clientId: selectionAnchor.clientId
    },
    end: {
      clientId: selectionFocus.clientId
    }
  });
};
/**
 * Action that merges two blocks.
 *
 * @param {string} firstBlockClientId  Client ID of the first block to merge.
 * @param {string} secondBlockClientId Client ID of the second block to merge.
 */

const mergeBlocks = (firstBlockClientId, secondBlockClientId) => _ref16 => {
  let {
    registry,
    select,
    dispatch
  } = _ref16;
  const blocks = [firstBlockClientId, secondBlockClientId];
  dispatch({
    type: 'MERGE_BLOCKS',
    blocks
  });
  const [clientIdA, clientIdB] = blocks;
  const blockA = select.getBlock(clientIdA);
  const blockAType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockA.name);
  if (!blockAType) return;
  const blockB = select.getBlock(clientIdB);

  if (blockAType && !blockAType.merge) {
    // If there's no merge function defined, attempt merging inner
    // blocks.
    const blocksWithTheSameType = (0,external_wp_blocks_namespaceObject.switchToBlockType)(blockB, blockAType.name); // Only focus the previous block if it's not mergeable.

    if ((blocksWithTheSameType === null || blocksWithTheSameType === void 0 ? void 0 : blocksWithTheSameType.length) !== 1) {
      dispatch.selectBlock(blockA.clientId);
      return;
    }

    const [blockWithSameType] = blocksWithTheSameType;

    if (blockWithSameType.innerBlocks.length < 1) {
      dispatch.selectBlock(blockA.clientId);
      return;
    }

    registry.batch(() => {
      dispatch.insertBlocks(blockWithSameType.innerBlocks, undefined, clientIdA);
      dispatch.removeBlock(clientIdB);
      dispatch.selectBlock(blockWithSameType.innerBlocks[0].clientId);
    });
    return;
  }

  const blockBType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockB.name);
  const {
    clientId,
    attributeKey,
    offset
  } = select.getSelectionStart();
  const selectedBlockType = clientId === clientIdA ? blockAType : blockBType;
  const attributeDefinition = selectedBlockType.attributes[attributeKey];
  const canRestoreTextSelection = (clientId === clientIdA || clientId === clientIdB) && attributeKey !== undefined && offset !== undefined && // We cannot restore text selection if the RichText identifier
  // is not a defined block attribute key. This can be the case if the
  // fallback intance ID is used to store selection (and no RichText
  // identifier is set), or when the identifier is wrong.
  !!attributeDefinition;

  if (!attributeDefinition) {
    if (typeof attributeKey === 'number') {
      window.console.error(`RichText needs an identifier prop that is the block attribute key of the attribute it controls. Its type is expected to be a string, but was ${typeof attributeKey}`);
    } else {
      window.console.error('The RichText identifier prop does not match any attributes defined by the block.');
    }
  } // Clone the blocks so we don't insert the character in a "live" block.


  const cloneA = (0,external_wp_blocks_namespaceObject.cloneBlock)(blockA);
  const cloneB = (0,external_wp_blocks_namespaceObject.cloneBlock)(blockB);

  if (canRestoreTextSelection) {
    const selectedBlock = clientId === clientIdA ? cloneA : cloneB;
    const html = selectedBlock.attributes[attributeKey];
    const value = (0,external_wp_richText_namespaceObject.insert)((0,external_wp_richText_namespaceObject.create)({
      html,
      ...mapRichTextSettings(attributeDefinition)
    }), START_OF_SELECTED_AREA, offset, offset);
    selectedBlock.attributes[attributeKey] = (0,external_wp_richText_namespaceObject.toHTMLString)({
      value,
      ...mapRichTextSettings(attributeDefinition)
    });
  } // We can only merge blocks with similar types
  // thus, we transform the block to merge first.


  const blocksWithTheSameType = blockA.name === blockB.name ? [cloneB] : (0,external_wp_blocks_namespaceObject.switchToBlockType)(cloneB, blockA.name); // If the block types can not match, do nothing.

  if (!blocksWithTheSameType || !blocksWithTheSameType.length) {
    return;
  } // Calling the merge to update the attributes and remove the block to be merged.


  const updatedAttributes = blockAType.merge(cloneA.attributes, blocksWithTheSameType[0].attributes);

  if (canRestoreTextSelection) {
    const newAttributeKey = retrieveSelectedAttribute(updatedAttributes);
    const convertedHtml = updatedAttributes[newAttributeKey];
    const convertedValue = (0,external_wp_richText_namespaceObject.create)({
      html: convertedHtml,
      ...mapRichTextSettings(blockAType.attributes[newAttributeKey])
    });
    const newOffset = convertedValue.text.indexOf(START_OF_SELECTED_AREA);
    const newValue = (0,external_wp_richText_namespaceObject.remove)(convertedValue, newOffset, newOffset + 1);
    const newHtml = (0,external_wp_richText_namespaceObject.toHTMLString)({
      value: newValue,
      ...mapRichTextSettings(blockAType.attributes[newAttributeKey])
    });
    updatedAttributes[newAttributeKey] = newHtml;
    dispatch.selectionChange(blockA.clientId, newAttributeKey, newOffset, newOffset);
  }

  dispatch.replaceBlocks([blockA.clientId, blockB.clientId], [{ ...blockA,
    attributes: { ...blockA.attributes,
      ...updatedAttributes
    }
  }, ...blocksWithTheSameType.slice(1)], 0 // If we don't pass the `indexToSelect` it will default to the last block.
  );
};
/**
 * Yields action objects used in signalling that the blocks corresponding to
 * the set of specified client IDs are to be removed.
 *
 * @param {string|string[]} clientIds      Client IDs of blocks to remove.
 * @param {boolean}         selectPrevious True if the previous block
 *                                         or the immediate parent
 *                                         (if no previous block exists)
 *                                         should be selected
 *                                         when a block is removed.
 */

const removeBlocks = function (clientIds) {
  let selectPrevious = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
  return _ref17 => {
    let {
      select,
      dispatch
    } = _ref17;

    if (!clientIds || !clientIds.length) {
      return;
    }

    clientIds = castArray(clientIds);
    const rootClientId = select.getBlockRootClientId(clientIds[0]);
    const canRemoveBlocks = select.canRemoveBlocks(clientIds, rootClientId);

    if (!canRemoveBlocks) {
      return;
    }

    if (selectPrevious) {
      dispatch.selectPreviousBlock(clientIds[0], selectPrevious);
    }

    dispatch({
      type: 'REMOVE_BLOCKS',
      clientIds
    }); // To avoid a focus loss when removing the last block, assure there is
    // always a default block if the last of the blocks have been removed.

    dispatch(ensureDefaultBlock());
  };
};
/**
 * Returns an action object used in signalling that the block with the
 * specified client ID is to be removed.
 *
 * @param {string}  clientId       Client ID of block to remove.
 * @param {boolean} selectPrevious True if the previous block should be
 *                                 selected when a block is removed.
 *
 * @return {Object} Action object.
 */

function removeBlock(clientId, selectPrevious) {
  return removeBlocks([clientId], selectPrevious);
}
/* eslint-disable jsdoc/valid-types */

/**
 * Returns an action object used in signalling that the inner blocks with the
 * specified client ID should be replaced.
 *
 * @param {string}    rootClientId    Client ID of the block whose InnerBlocks will re replaced.
 * @param {Object[]}  blocks          Block objects to insert as new InnerBlocks
 * @param {?boolean}  updateSelection If true block selection will be updated. If false, block selection will not change. Defaults to false.
 * @param {0|-1|null} initialPosition Initial block position.
 * @return {Object} Action object.
 */

function replaceInnerBlocks(rootClientId, blocks) {
  let updateSelection = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  let initialPosition = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;

  /* eslint-enable jsdoc/valid-types */
  return {
    type: 'REPLACE_INNER_BLOCKS',
    rootClientId,
    blocks,
    updateSelection,
    initialPosition: updateSelection ? initialPosition : null,
    time: Date.now()
  };
}
/**
 * Returns an action object used to toggle the block editing mode between
 * visual and HTML modes.
 *
 * @param {string} clientId Block client ID.
 *
 * @return {Object} Action object.
 */

function toggleBlockMode(clientId) {
  return {
    type: 'TOGGLE_BLOCK_MODE',
    clientId
  };
}
/**
 * Returns an action object used in signalling that the user has begun to type.
 *
 * @return {Object} Action object.
 */

function startTyping() {
  return {
    type: 'START_TYPING'
  };
}
/**
 * Returns an action object used in signalling that the user has stopped typing.
 *
 * @return {Object} Action object.
 */

function stopTyping() {
  return {
    type: 'STOP_TYPING'
  };
}
/**
 * Returns an action object used in signalling that the user has begun to drag blocks.
 *
 * @param {string[]} clientIds An array of client ids being dragged
 *
 * @return {Object} Action object.
 */

function startDraggingBlocks() {
  let clientIds = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  return {
    type: 'START_DRAGGING_BLOCKS',
    clientIds
  };
}
/**
 * Returns an action object used in signalling that the user has stopped dragging blocks.
 *
 * @return {Object} Action object.
 */

function stopDraggingBlocks() {
  return {
    type: 'STOP_DRAGGING_BLOCKS'
  };
}
/**
 * Returns an action object used in signalling that the caret has entered formatted text.
 *
 * @deprecated
 *
 * @return {Object} Action object.
 */

function enterFormattedText() {
  external_wp_deprecated_default()('wp.data.dispatch( "core/block-editor" ).enterFormattedText', {
    since: '6.1',
    version: '6.3'
  });
  return {
    type: 'DO_NOTHING'
  };
}
/**
 * Returns an action object used in signalling that the user caret has exited formatted text.
 *
 * @deprecated
 *
 * @return {Object} Action object.
 */

function exitFormattedText() {
  external_wp_deprecated_default()('wp.data.dispatch( "core/block-editor" ).exitFormattedText', {
    since: '6.1',
    version: '6.3'
  });
  return {
    type: 'DO_NOTHING'
  };
}
/**
 * Action that changes the position of the user caret.
 *
 * @param {string|WPSelection} clientId     The selected block client ID.
 * @param {string}             attributeKey The selected block attribute key.
 * @param {number}             startOffset  The start offset.
 * @param {number}             endOffset    The end offset.
 *
 * @return {Object} Action object.
 */

function selectionChange(clientId, attributeKey, startOffset, endOffset) {
  if (typeof clientId === 'string') {
    return {
      type: 'SELECTION_CHANGE',
      clientId,
      attributeKey,
      startOffset,
      endOffset
    };
  }

  return {
    type: 'SELECTION_CHANGE',
    ...clientId
  };
}
/**
 * Action that adds a new block of the default type to the block list.
 *
 * @param {?Object} attributes   Optional attributes of the block to assign.
 * @param {?string} rootClientId Optional root client ID of block list on which
 *                               to append.
 * @param {?number} index        Optional index where to insert the default block.
 */

const insertDefaultBlock = (attributes, rootClientId, index) => _ref18 => {
  let {
    dispatch
  } = _ref18;
  // Abort if there is no default block type (if it has been unregistered).
  const defaultBlockName = (0,external_wp_blocks_namespaceObject.getDefaultBlockName)();

  if (!defaultBlockName) {
    return;
  }

  const block = (0,external_wp_blocks_namespaceObject.createBlock)(defaultBlockName, attributes);
  return dispatch.insertBlock(block, index, rootClientId);
};
/**
 * Action that changes the nested settings of a given block.
 *
 * @param {string} clientId Client ID of the block whose nested setting are
 *                          being received.
 * @param {Object} settings Object with the new settings for the nested block.
 *
 * @return {Object} Action object
 */

function updateBlockListSettings(clientId, settings) {
  return {
    type: 'UPDATE_BLOCK_LIST_SETTINGS',
    clientId,
    settings
  };
}
/**
 * Action that updates the block editor settings.
 *
 * @param {Object} settings Updated settings
 *
 * @return {Object} Action object
 */

function updateSettings(settings) {
  return __experimentalUpdateSettings(settings, true);
}
/**
 * Action that signals that a temporary reusable block has been saved
 * in order to switch its temporary id with the real id.
 *
 * @param {string} id        Reusable block's id.
 * @param {string} updatedId Updated block's id.
 *
 * @return {Object} Action object.
 */

function __unstableSaveReusableBlock(id, updatedId) {
  return {
    type: 'SAVE_REUSABLE_BLOCK_SUCCESS',
    id,
    updatedId
  };
}
/**
 * Action that marks the last block change explicitly as persistent.
 *
 * @return {Object} Action object.
 */

function __unstableMarkLastChangeAsPersistent() {
  return {
    type: 'MARK_LAST_CHANGE_AS_PERSISTENT'
  };
}
/**
 * Action that signals that the next block change should be marked explicitly as not persistent.
 *
 * @return {Object} Action object.
 */

function __unstableMarkNextChangeAsNotPersistent() {
  return {
    type: 'MARK_NEXT_CHANGE_AS_NOT_PERSISTENT'
  };
}
/**
 * Action that marks the last block change as an automatic change, meaning it was not
 * performed by the user, and can be undone using the `Escape` and `Backspace` keys.
 * This action must be called after the change was made, and any actions that are a
 * consequence of it, so it is recommended to be called at the next idle period to ensure all
 * selection changes have been recorded.
 */

const __unstableMarkAutomaticChange = () => _ref19 => {
  let {
    dispatch
  } = _ref19;
  dispatch({
    type: 'MARK_AUTOMATIC_CHANGE'
  });
  const {
    requestIdleCallback = cb => setTimeout(cb, 100)
  } = window;
  requestIdleCallback(() => {
    dispatch({
      type: 'MARK_AUTOMATIC_CHANGE_FINAL'
    });
  });
};
/**
 * Action that enables or disables the navigation mode.
 *
 * @param {boolean} isNavigationMode Enable/Disable navigation mode.
 */

const setNavigationMode = function () {
  let isNavigationMode = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
  return _ref20 => {
    let {
      dispatch
    } = _ref20;

    dispatch.__unstableSetEditorMode(isNavigationMode ? 'navigation' : 'edit');
  };
};
/**
 * Action that sets the editor mode
 *
 * @param {string} mode Editor mode
 */

const __unstableSetEditorMode = mode => _ref21 => {
  let {
    dispatch,
    select
  } = _ref21;

  // When switching to zoom-out mode, we need to select the root block
  if (mode === 'zoom-out') {
    const firstSelectedClientId = select.getBlockSelectionStart();

    if (firstSelectedClientId) {
      dispatch.selectBlock(select.getBlockHierarchyRootClientId(firstSelectedClientId));
    }
  }

  dispatch({
    type: 'SET_EDITOR_MODE',
    mode
  });

  if (mode === 'navigation') {
    (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)('You are currently in navigation mode. Navigate blocks using the Tab key and Arrow keys. Use Left and Right Arrow keys to move between nesting levels. To exit navigation mode and edit the selected block, press Enter.'));
  } else if (mode === 'edit') {
    (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)('You are currently in edit mode. To return to the navigation mode, press Escape.'));
  } else if (mode === 'zoom-out') {
    (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)('You are currently in zoom-out mode.'));
  }
};
/**
 * Action that enables or disables the block moving mode.
 *
 * @param {string|null} hasBlockMovingClientId Enable/Disable block moving mode.
 */

const setBlockMovingClientId = function () {
  let hasBlockMovingClientId = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
  return _ref22 => {
    let {
      dispatch
    } = _ref22;
    dispatch({
      type: 'SET_BLOCK_MOVING_MODE',
      hasBlockMovingClientId
    });

    if (hasBlockMovingClientId) {
      (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)('Use the Tab key and Arrow keys to choose new block location. Use Left and Right Arrow keys to move between nesting levels. Once location is selected press Enter or Space to move the block.'));
    }
  };
};
/**
 * Action that duplicates a list of blocks.
 *
 * @param {string[]} clientIds
 * @param {boolean}  updateSelection
 */

const duplicateBlocks = function (clientIds) {
  let updateSelection = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
  return _ref23 => {
    let {
      select,
      dispatch
    } = _ref23;

    if (!clientIds || !clientIds.length) {
      return;
    } // Return early if blocks don't exist.


    const blocks = select.getBlocksByClientId(clientIds);

    if (blocks.some(block => !block)) {
      return;
    } // Return early if blocks don't support multiple usage.


    const blockNames = blocks.map(block => block.name);

    if (blockNames.some(blockName => !(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockName, 'multiple', true))) {
      return;
    }

    const rootClientId = select.getBlockRootClientId(clientIds[0]);
    const clientIdsArray = castArray(clientIds);
    const lastSelectedIndex = select.getBlockIndex(clientIdsArray[clientIdsArray.length - 1]);
    const clonedBlocks = blocks.map(block => (0,external_wp_blocks_namespaceObject.__experimentalCloneSanitizedBlock)(block));
    dispatch.insertBlocks(clonedBlocks, lastSelectedIndex + 1, rootClientId, updateSelection);

    if (clonedBlocks.length > 1 && updateSelection) {
      dispatch.multiSelect(clonedBlocks[0].clientId, clonedBlocks[clonedBlocks.length - 1].clientId);
    }

    return clonedBlocks.map(block => block.clientId);
  };
};
/**
 * Action that inserts an empty block before a given block.
 *
 * @param {string} clientId
 */

const insertBeforeBlock = clientId => _ref24 => {
  let {
    select,
    dispatch
  } = _ref24;

  if (!clientId) {
    return;
  }

  const rootClientId = select.getBlockRootClientId(clientId);
  const isLocked = select.getTemplateLock(rootClientId);

  if (isLocked) {
    return;
  }

  const firstSelectedIndex = select.getBlockIndex(clientId);
  return dispatch.insertDefaultBlock({}, rootClientId, firstSelectedIndex);
};
/**
 * Action that inserts an empty block after a given block.
 *
 * @param {string} clientId
 */

const insertAfterBlock = clientId => _ref25 => {
  let {
    select,
    dispatch
  } = _ref25;

  if (!clientId) {
    return;
  }

  const rootClientId = select.getBlockRootClientId(clientId);
  const isLocked = select.getTemplateLock(rootClientId);

  if (isLocked) {
    return;
  }

  const firstSelectedIndex = select.getBlockIndex(clientId);
  return dispatch.insertDefaultBlock({}, rootClientId, firstSelectedIndex + 1);
};
/**
 * Action that toggles the highlighted block state.
 *
 * @param {string}  clientId      The block's clientId.
 * @param {boolean} isHighlighted The highlight state.
 */

function toggleBlockHighlight(clientId, isHighlighted) {
  return {
    type: 'TOGGLE_BLOCK_HIGHLIGHT',
    clientId,
    isHighlighted
  };
}
/**
 * Action that "flashes" the block with a given `clientId` by rhythmically highlighting it.
 *
 * @param {string} clientId Target block client ID.
 */

const flashBlock = clientId => async _ref26 => {
  let {
    dispatch
  } = _ref26;
  dispatch(toggleBlockHighlight(clientId, true));
  await new Promise(resolve => setTimeout(resolve, 150));
  dispatch(toggleBlockHighlight(clientId, false));
};
/**
 * Action that sets whether a block has controlled inner blocks.
 *
 * @param {string}  clientId                 The block's clientId.
 * @param {boolean} hasControlledInnerBlocks True if the block's inner blocks are controlled.
 */

function setHasControlledInnerBlocks(clientId, hasControlledInnerBlocks) {
  return {
    type: 'SET_HAS_CONTROLLED_INNER_BLOCKS',
    hasControlledInnerBlocks,
    clientId
  };
}
/**
 * Action that sets whether given blocks are visible on the canvas.
 *
 * @param {Record<string,boolean>} updates For each block's clientId, its new visibility setting.
 */

function setBlockVisibility(updates) {
  return {
    type: 'SET_BLOCK_VISIBILITY',
    updates
  };
}
/**
 * Action that sets whether a block is being temporaritly edited as blocks.
 *
 * DO-NOT-USE in production.
 * This action is created for internal/experimental only usage and may be
 * removed anytime without any warning, causing breakage on any plugin or theme invoking it.
 *
 * @param {?string} temporarilyEditingAsBlocks The block's clientId being temporaritly edited as blocks.
 */

function __unstableSetTemporarilyEditingAsBlocks(temporarilyEditingAsBlocks) {
  return {
    type: 'SET_TEMPORARILY_EDITING_AS_BLOCKS',
    temporarilyEditingAsBlocks
  };
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/constants.js
const STORE_NAME = 'core/block-editor';

;// CONCATENATED MODULE: external ["wp","privateApis"]
var external_wp_privateApis_namespaceObject = window["wp"]["privateApis"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/lock-unlock.js
/**
 * WordPress dependencies
 */

const {
  lock,
  unlock
} = (0,external_wp_privateApis_namespaceObject.__dangerousOptInToUnstableAPIsOnlyForCoreModules)('I know using unstable features means my plugin or theme will inevitably break on the next WordPress release.', '@wordpress/block-editor');

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */








/**
 * Block editor data store configuration.
 *
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/data/README.md#registerStore
 */

const storeConfig = {
  reducer: reducer,
  selectors: selectors_namespaceObject,
  actions: actions_namespaceObject
};
/**
 * Store definition for the block editor namespace.
 *
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/data/README.md#createReduxStore
 */

const store = (0,external_wp_data_namespaceObject.createReduxStore)(STORE_NAME, { ...storeConfig,
  persist: ['preferences']
}); // We will be able to use the `register` function once we switch
// the "preferences" persistence to use the new preferences package.

const registeredStore = (0,external_wp_data_namespaceObject.registerStore)(STORE_NAME, { ...storeConfig,
  persist: ['preferences']
});
unlock(registeredStore).registerPrivateActions(private_actions_namespaceObject);
unlock(registeredStore).registerPrivateSelectors(private_selectors_namespaceObject);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-edit/context.js
/**
 * WordPress dependencies
 */

const DEFAULT_BLOCK_EDIT_CONTEXT = {
  name: '',
  isSelected: false
};
const Context = (0,external_wp_element_namespaceObject.createContext)(DEFAULT_BLOCK_EDIT_CONTEXT);
const {
  Provider
} = Context;

/**
 * A hook that returns the block edit context.
 *
 * @return {Object} Block edit context
 */

function useBlockEditContext() {
  return (0,external_wp_element_namespaceObject.useContext)(Context);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/use-display-block-controls/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */



function useDisplayBlockControls() {
  const {
    isSelected,
    clientId,
    name
  } = useBlockEditContext();
  return (0,external_wp_data_namespaceObject.useSelect)(select => {
    if (isSelected) {
      return true;
    }

    const {
      getBlockName,
      isFirstMultiSelectedBlock,
      getMultiSelectedBlockClientIds
    } = select(store);

    if (isFirstMultiSelectedBlock(clientId)) {
      return getMultiSelectedBlockClientIds().every(id => getBlockName(id) === name);
    }

    return false;
  }, [clientId, isSelected, name]);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-controls/hook.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function useBlockControlsFill(group, shareWithChildBlocks) {
  const isDisplayed = useDisplayBlockControls();
  const {
    clientId
  } = useBlockEditContext();
  const isParentDisplayed = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlockName,
      hasSelectedInnerBlock
    } = select(store);
    const {
      hasBlockSupport
    } = select(external_wp_blocks_namespaceObject.store);
    return shareWithChildBlocks && hasBlockSupport(getBlockName(clientId), '__experimentalExposeControlsToChildren', false) && hasSelectedInnerBlock(clientId);
  }, [shareWithChildBlocks, clientId]);

  if (isDisplayed) {
    var _groups$group;

    return (_groups$group = block_controls_groups[group]) === null || _groups$group === void 0 ? void 0 : _groups$group.Fill;
  }

  if (isParentDisplayed) {
    return block_controls_groups.parent.Fill;
  }

  return null;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-controls/fill.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function BlockControlsFill(_ref) {
  let {
    group = 'default',
    controls,
    children,
    __experimentalShareWithChildBlocks = false
  } = _ref;
  const Fill = useBlockControlsFill(group, __experimentalShareWithChildBlocks);

  if (!Fill) {
    return null;
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalStyleProvider, {
    document: document
  }, (0,external_wp_element_namespaceObject.createElement)(Fill, null, fillProps => {
    // Children passed to BlockControlsFill will not have access to any
    // React Context whose Provider is part of the BlockControlsSlot tree.
    // So we re-create the Provider in this subtree.
    const value = !(0,external_lodash_namespaceObject.isEmpty)(fillProps) ? fillProps : null;
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToolbarContext.Provider, {
      value: value
    }, group === 'default' && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarGroup, {
      controls: controls
    }), children);
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-controls/slot.js



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function BlockControlsSlot(_ref) {
  let {
    group = 'default',
    ...props
  } = _ref;
  const accessibleToolbarState = (0,external_wp_element_namespaceObject.useContext)(external_wp_components_namespaceObject.__experimentalToolbarContext);
  const Slot = block_controls_groups[group].Slot;
  const fills = (0,external_wp_components_namespaceObject.__experimentalUseSlotFills)(Slot.__unstableName);
  const hasFills = Boolean(fills && fills.length);

  if (!hasFills) {
    return null;
  }

  if (group === 'default') {
    return (0,external_wp_element_namespaceObject.createElement)(Slot, _extends({}, props, {
      bubblesVirtually: true,
      fillProps: accessibleToolbarState
    }));
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToolbarGroup, null, (0,external_wp_element_namespaceObject.createElement)(Slot, _extends({}, props, {
    bubblesVirtually: true,
    fillProps: accessibleToolbarState
  })));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-controls/index.js



/**
 * Internal dependencies
 */


const BlockControls = BlockControlsFill;
BlockControls.Slot = BlockControlsSlot; // This is just here for backward compatibility.

const BlockFormatControls = props => {
  return (0,external_wp_element_namespaceObject.createElement)(BlockControlsFill, _extends({
    group: "inline"
  }, props));
};

BlockFormatControls.Slot = props => {
  return (0,external_wp_element_namespaceObject.createElement)(BlockControlsSlot, _extends({
    group: "inline"
  }, props));
};

/* harmony default export */ var block_controls = (BlockControls);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/justify-left.js


/**
 * WordPress dependencies
 */

const justifyLeft = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M9 9v6h11V9H9zM4 20h1.5V4H4v16z"
}));
/* harmony default export */ var justify_left = (justifyLeft);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/justify-center.js


/**
 * WordPress dependencies
 */

const justifyCenter = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M20 9h-7.2V4h-1.6v5H4v6h7.2v5h1.6v-5H20z"
}));
/* harmony default export */ var justify_center = (justifyCenter);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/justify-right.js


/**
 * WordPress dependencies
 */

const justifyRight = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M4 15h11V9H4v6zM18.5 4v16H20V4h-1.5z"
}));
/* harmony default export */ var justify_right = (justifyRight);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/justify-space-between.js


/**
 * WordPress dependencies
 */

const justifySpaceBetween = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M9 15h6V9H9v6zm-5 5h1.5V4H4v16zM18.5 4v16H20V4h-1.5z"
}));
/* harmony default export */ var justify_space_between = (justifySpaceBetween);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/justify-stretch.js


/**
 * WordPress dependencies
 */

const justifyStretch = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M4 4H5.5V20H4V4ZM7 10L17 10V14L7 14V10ZM20 4H18.5V20H20V4Z"
}));
/* harmony default export */ var justify_stretch = (justifyStretch);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/arrow-right.js


/**
 * WordPress dependencies
 */

const arrowRight = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "m14.5 6.5-1 1 3.7 3.7H4v1.6h13.2l-3.7 3.7 1 1 5.6-5.5z"
}));
/* harmony default export */ var arrow_right = (arrowRight);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/arrow-down.js


/**
 * WordPress dependencies
 */

const arrowDown = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "m16.5 13.5-3.7 3.7V4h-1.5v13.2l-3.8-3.7-1 1 5.5 5.6 5.5-5.6z"
}));
/* harmony default export */ var arrow_down = (arrowDown);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/layouts/utils.js
/**
 * WordPress dependencies
 */

/**
 * Utility to generate the proper CSS selector for layout styles.
 *
 * @param {string} selectors CSS selector, also supports multiple comma-separated selectors.
 * @param {string} append    The string to append.
 *
 * @return {string} - CSS selector.
 */

function appendSelectors(selectors) {
  let append = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  // Ideally we shouldn't need the `.editor-styles-wrapper` increased specificity here
  // The problem though is that we have a `.editor-styles-wrapper p { margin: reset; }` style
  // it's used to reset the default margin added by wp-admin to paragraphs
  // so we need this to be higher speficity otherwise, it won't be applied to paragraphs inside containers
  // When the post editor is fully iframed, this extra classname could be removed.
  return selectors.split(',').map(subselector => `.editor-styles-wrapper ${subselector}${append ? ` ${append}` : ''}`).join(',');
}
/**
 * Get generated blockGap CSS rules based on layout definitions provided in theme.json
 * Falsy values in the layout definition's spacingStyles rules will be swapped out
 * with the provided `blockGapValue`.
 *
 * @param {string} selector          The CSS selector to target for the generated rules.
 * @param {Object} layoutDefinitions Layout definitions object from theme.json.
 * @param {string} layoutType        The layout type (e.g. `default` or `flex`).
 * @param {string} blockGapValue     The current blockGap value to be applied.
 * @return {string} The generated CSS rules.
 */

function getBlockGapCSS(selector, layoutDefinitions, layoutType, blockGapValue) {
  var _layoutDefinitions$la, _layoutDefinitions$la2;

  let output = '';

  if (layoutDefinitions !== null && layoutDefinitions !== void 0 && (_layoutDefinitions$la = layoutDefinitions[layoutType]) !== null && _layoutDefinitions$la !== void 0 && (_layoutDefinitions$la2 = _layoutDefinitions$la.spacingStyles) !== null && _layoutDefinitions$la2 !== void 0 && _layoutDefinitions$la2.length && blockGapValue) {
    layoutDefinitions[layoutType].spacingStyles.forEach(gapStyle => {
      output += `${appendSelectors(selector, gapStyle.selector.trim())} { `;
      output += Object.entries(gapStyle.rules).map(_ref => {
        let [cssProperty, value] = _ref;
        return `${cssProperty}: ${value ? value : blockGapValue}`;
      }).join('; ');
      output += '; }';
    });
  }

  return output;
}
/**
 * Helper method to assign contextual info to clarify
 * alignment settings.
 *
 * Besides checking if `contentSize` and `wideSize` have a
 * value, we now show this information only if their values
 * are not a `css var`. This needs to change when parsing
 * css variables land.
 *
 * @see https://github.com/WordPress/gutenberg/pull/34710#issuecomment-918000752
 *
 * @param {Object} layout The layout object.
 * @return {Object} An object with contextual info per alignment.
 */

function getAlignmentsInfo(layout) {
  const {
    contentSize,
    wideSize,
    type = 'default'
  } = layout;
  const alignmentInfo = {};
  const sizeRegex = /^(?!0)\d+(px|em|rem|vw|vh|%)?$/i;

  if (sizeRegex.test(contentSize) && type === 'constrained') {
    // translators: %s: container size (i.e. 600px etc)
    alignmentInfo.none = (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)('Max %s wide'), contentSize);
  }

  if (sizeRegex.test(wideSize)) {
    // translators: %s: container size (i.e. 600px etc)
    alignmentInfo.wide = (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)('Max %s wide'), wideSize);
  }

  return alignmentInfo;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/provider/block-refs-provider.js


/**
 * WordPress dependencies
 */

const BlockRefs = (0,external_wp_element_namespaceObject.createContext)({
  refs: new Map(),
  callbacks: new Map()
});
function BlockRefsProvider(_ref) {
  let {
    children
  } = _ref;
  const value = (0,external_wp_element_namespaceObject.useMemo)(() => ({
    refs: new Map(),
    callbacks: new Map()
  }), []);
  return (0,external_wp_element_namespaceObject.createElement)(BlockRefs.Provider, {
    value: value
  }, children);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-list/use-block-props/use-block-refs.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/** @typedef {import('@wordpress/element').RefCallback} RefCallback */

/** @typedef {import('@wordpress/element').RefObject} RefObject */

/**
 * Provides a ref to the BlockRefs context.
 *
 * @param {string} clientId The client ID of the element ref.
 *
 * @return {RefCallback} Ref callback.
 */

function useBlockRefProvider(clientId) {
  const {
    refs,
    callbacks
  } = (0,external_wp_element_namespaceObject.useContext)(BlockRefs);
  const ref = (0,external_wp_element_namespaceObject.useRef)();
  (0,external_wp_element_namespaceObject.useLayoutEffect)(() => {
    refs.set(ref, clientId);
    return () => {
      refs.delete(ref);
    };
  }, [clientId]);
  return (0,external_wp_compose_namespaceObject.useRefEffect)(element => {
    // Update the ref in the provider.
    ref.current = element; // Call any update functions.

    callbacks.forEach((id, setElement) => {
      if (clientId === id) {
        setElement(element);
      }
    });
  }, [clientId]);
}
/**
 * Gets a ref pointing to the current block element. Continues to return a
 * stable ref even if the block client ID changes.
 *
 * @param {string} clientId The client ID to get a ref for.
 *
 * @return {RefObject} A ref containing the element.
 */

function useBlockRef(clientId) {
  const {
    refs
  } = (0,external_wp_element_namespaceObject.useContext)(BlockRefs);
  const freshClientId = (0,external_wp_element_namespaceObject.useRef)();
  freshClientId.current = clientId; // Always return an object, even if no ref exists for a given client ID, so
  // that `current` works at a later point.

  return (0,external_wp_element_namespaceObject.useMemo)(() => ({
    get current() {
      let element = null; // Multiple refs may be created for a single block. Find the
      // first that has an element set.

      for (const [ref, id] of refs.entries()) {
        if (id === freshClientId.current && ref.current) {
          element = ref.current;
        }
      }

      return element;
    }

  }), []);
}
/**
 * Return the element for a given client ID. Updates whenever the element
 * changes, becomes available, or disappears.
 *
 * @param {string} clientId The client ID to an element for.
 *
 * @return {Element|null} The block's wrapper element.
 */


function useBlockElement(clientId) {
  const {
    callbacks
  } = (0,external_wp_element_namespaceObject.useContext)(BlockRefs);
  const ref = useBlockRef(clientId);
  const [element, setElement] = (0,external_wp_element_namespaceObject.useState)(null);
  (0,external_wp_element_namespaceObject.useLayoutEffect)(() => {
    if (!clientId) {
      return;
    }

    callbacks.set(setElement, clientId);
    return () => {
      callbacks.delete(setElement);
    };
  }, [clientId]);
  return ref.current || element;
}




;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/spacing-sizes-control/utils.js
/**
 * WordPress dependencies
 */

/**
 * Checks is given value is a spacing preset.
 *
 * @param {string} value Value to check
 *
 * @return {boolean} Return true if value is string in format var:preset|spacing|.
 */

function isValueSpacingPreset(value) {
  if (!(value !== null && value !== void 0 && value.includes)) {
    return false;
  }

  return value === '0' || value.includes('var:preset|spacing|');
}
/**
 * Converts a spacing preset into a custom value.
 *
 * @param {string} value        Value to convert
 * @param {Array}  spacingSizes Array of the current spacing preset objects
 *
 * @return {string} Mapping of the spacing preset to its equivalent custom value.
 */

function getCustomValueFromPreset(value, spacingSizes) {
  if (!isValueSpacingPreset(value)) {
    return value;
  }

  const slug = getSpacingPresetSlug(value);
  const spacingSize = spacingSizes.find(size => String(size.slug) === slug);
  return spacingSize === null || spacingSize === void 0 ? void 0 : spacingSize.size;
}
/**
 * Converts a custom value to preset value if one can be found.
 *
 * Returns value as-is if no match is found.
 *
 * @param {string} value        Value to convert
 * @param {Array}  spacingSizes Array of the current spacing preset objects
 *
 * @return {string} The preset value if it can be found.
 */

function getPresetValueFromCustomValue(value, spacingSizes) {
  // Return value as-is if it is already a preset;
  if (isValueSpacingPreset(value)) {
    return value;
  }

  const spacingMatch = spacingSizes.find(size => String(size.size) === String(value));

  if (spacingMatch !== null && spacingMatch !== void 0 && spacingMatch.slug) {
    return `var:preset|spacing|${spacingMatch.slug}`;
  }

  return value;
}
/**
 * Converts a spacing preset into a custom value.
 *
 * @param {string} value Value to convert.
 *
 * @return {string | undefined} CSS var string for given spacing preset value.
 */

function getSpacingPresetCssVar(value) {
  if (!value) {
    return;
  }

  const slug = value.match(/var:preset\|spacing\|(.+)/);

  if (!slug) {
    return value;
  }

  return `var(--wp--preset--spacing--${slug[1]})`;
}
/**
 * Returns the slug section of the given spacing preset string.
 *
 * @param {string} value Value to extract slug from.
 *
 * @return {string|undefined} The int value of the slug from given spacing preset.
 */

function getSpacingPresetSlug(value) {
  if (!value) {
    return;
  }

  if (value === '0' || value === 'default') {
    return value;
  }

  const slug = value.match(/var:preset\|spacing\|(.+)/);
  return slug ? slug[1] : undefined;
}
/**
 * Converts spacing preset value into a Range component value .
 *
 * @param {string} presetValue  Value to convert to Range value.
 * @param {Array}  spacingSizes Array of current spacing preset value objects.
 *
 * @return {number} The int value for use in Range control.
 */

function getSliderValueFromPreset(presetValue, spacingSizes) {
  if (presetValue === undefined) {
    return 0;
  }

  const slug = parseFloat(presetValue, 10) === 0 ? '0' : getSpacingPresetSlug(presetValue);
  const sliderValue = spacingSizes.findIndex(spacingSize => {
    return String(spacingSize.slug) === slug;
  }); // Returning NaN rather than undefined as undefined makes range control thumb sit in center

  return sliderValue !== -1 ? sliderValue : NaN;
}
const LABELS = {
  all: (0,external_wp_i18n_namespaceObject.__)('All sides'),
  top: (0,external_wp_i18n_namespaceObject.__)('Top'),
  bottom: (0,external_wp_i18n_namespaceObject.__)('Bottom'),
  left: (0,external_wp_i18n_namespaceObject.__)('Left'),
  right: (0,external_wp_i18n_namespaceObject.__)('Right'),
  mixed: (0,external_wp_i18n_namespaceObject.__)('Mixed'),
  vertical: (0,external_wp_i18n_namespaceObject.__)('Vertical'),
  horizontal: (0,external_wp_i18n_namespaceObject.__)('Horizontal')
};
const DEFAULT_VALUES = {
  top: undefined,
  right: undefined,
  bottom: undefined,
  left: undefined
};
const ALL_SIDES = ['top', 'right', 'bottom', 'left'];
/**
 * Gets an items with the most occurrence within an array
 * https://stackoverflow.com/a/20762713
 *
 * @param {Array<any>} arr Array of items to check.
 * @return {any} The item with the most occurrences.
 */

function mode(arr) {
  return arr.sort((a, b) => arr.filter(v => v === a).length - arr.filter(v => v === b).length).pop();
}
/**
 * Gets the 'all' input value from values data.
 *
 * @param {Object} values Box spacing values
 *
 * @return {string} The most common value from all sides of box.
 */


function getAllRawValue() {
  let values = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  return mode(Object.values(values));
}
/**
 * Checks to determine if values are mixed.
 *
 * @param {Object} values Box values.
 * @param {Array}  sides  Sides that values relate to.
 *
 * @return {boolean} Whether values are mixed.
 */

function isValuesMixed() {
  let values = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let sides = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : ALL_SIDES;
  return Object.values(values).length >= 1 && Object.values(values).length < sides.length || new Set(Object.values(values)).size > 1;
}
/**
 * Checks to determine if values are defined.
 *
 * @param {Object} values Box values.
 *
 * @return {boolean} Whether values are defined.
 */

function isValuesDefined(values) {
  if (values === undefined || values === null) {
    return false;
  }

  return Object.values(values).filter(value => !!value).length > 0;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/settings.js


/**
 * WordPress dependencies
 */

const settings_settings = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M14.5 13.8c-1.1 0-2.1.7-2.4 1.8H4V17h8.1c.3 1 1.3 1.8 2.4 1.8s2.1-.7 2.4-1.8H20v-1.5h-3.1c-.3-1-1.3-1.7-2.4-1.7zM11.9 7c-.3-1-1.3-1.8-2.4-1.8S7.4 6 7.1 7H4v1.5h3.1c.3 1 1.3 1.8 2.4 1.8s2.1-.7 2.4-1.8H20V7h-8.1z"
}));
/* harmony default export */ var library_settings = (settings_settings);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/use-setting/index.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



const blockedPaths = ['color', 'border', 'dimensions', 'typography', 'spacing'];
const deprecatedFlags = {
  'color.palette': settings => settings.colors,
  'color.gradients': settings => settings.gradients,
  'color.custom': settings => settings.disableCustomColors === undefined ? undefined : !settings.disableCustomColors,
  'color.customGradient': settings => settings.disableCustomGradients === undefined ? undefined : !settings.disableCustomGradients,
  'typography.fontSizes': settings => settings.fontSizes,
  'typography.customFontSize': settings => settings.disableCustomFontSizes === undefined ? undefined : !settings.disableCustomFontSizes,
  'typography.lineHeight': settings => settings.enableCustomLineHeight,
  'spacing.units': settings => {
    if (settings.enableCustomUnits === undefined) {
      return;
    }

    if (settings.enableCustomUnits === true) {
      return ['px', 'em', 'rem', 'vh', 'vw', '%'];
    }

    return settings.enableCustomUnits;
  },
  'spacing.padding': settings => settings.enableCustomSpacing
};
const prefixedFlags = {
  /*
   * These were only available in the plugin
   * and can be removed when the minimum WordPress version
   * for the plugin is 5.9.
   */
  'border.customColor': 'border.color',
  'border.customStyle': 'border.style',
  'border.customWidth': 'border.width',
  'typography.customFontStyle': 'typography.fontStyle',
  'typography.customFontWeight': 'typography.fontWeight',
  'typography.customLetterSpacing': 'typography.letterSpacing',
  'typography.customTextDecorations': 'typography.textDecoration',
  'typography.customTextTransforms': 'typography.textTransform',

  /*
   * These were part of WordPress 5.8 and we need to keep them.
   */
  'border.customRadius': 'border.radius',
  'spacing.customMargin': 'spacing.margin',
  'spacing.customPadding': 'spacing.padding',
  'typography.customLineHeight': 'typography.lineHeight'
};
/**
 * Remove `custom` prefixes for flags that did not land in 5.8.
 *
 * This provides continued support for `custom` prefixed properties. It will
 * be removed once third party devs have had sufficient time to update themes,
 * plugins, etc.
 *
 * @see https://github.com/WordPress/gutenberg/pull/34485
 *
 * @param {string} path Path to desired value in settings.
 * @return {string}     The value for defined setting.
 */

const removeCustomPrefixes = path => {
  return prefixedFlags[path] || path;
};
/**
 * Hook that retrieves the given setting for the block instance in use.
 *
 * It looks up the settings first in the block instance hierarchy.
 * If none is found, it'll look it up in the block editor store.
 *
 * @param {string} path The path to the setting.
 * @return {any} Returns the value defined for the setting.
 * @example
 * ```js
 * const isEnabled = useSetting( 'typography.dropCap' );
 * ```
 */


function useSetting(path) {
  const {
    name: blockName,
    clientId
  } = useBlockEditContext();
  return (0,external_wp_data_namespaceObject.useSelect)(select => {
    if (blockedPaths.includes(path)) {
      // eslint-disable-next-line no-console
      console.warn('Top level useSetting paths are disabled. Please use a subpath to query the information needed.');
      return undefined;
    } // 0. Allow third parties to filter the block's settings at runtime.


    let result = (0,external_wp_hooks_namespaceObject.applyFilters)('blockEditor.useSetting.before', undefined, path, clientId, blockName);

    if (undefined !== result) {
      return result;
    }

    const normalizedPath = removeCustomPrefixes(path); // 1. Take settings from the block instance or its ancestors.
    // Start from the current block and work our way up the ancestors.

    const candidates = [clientId, ...select(store).getBlockParents(clientId,
    /* ascending */
    true)];

    for (const candidateClientId of candidates) {
      const candidateBlockName = select(store).getBlockName(candidateClientId);

      if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(candidateBlockName, '__experimentalSettings', false)) {
        var _get;

        const candidateAtts = select(store).getBlockAttributes(candidateClientId);
        result = (_get = (0,external_lodash_namespaceObject.get)(candidateAtts, `settings.blocks.${blockName}.${normalizedPath}`)) !== null && _get !== void 0 ? _get : (0,external_lodash_namespaceObject.get)(candidateAtts, `settings.${normalizedPath}`);

        if (result !== undefined) {
          // Stop the search for more distant ancestors and move on.
          break;
        }
      }
    } // 2. Fall back to the settings from the block editor store (__experimentalFeatures).


    const settings = select(store).getSettings();

    if (result === undefined) {
      var _get2;

      const defaultsPath = `__experimentalFeatures.${normalizedPath}`;
      const blockPath = `__experimentalFeatures.blocks.${blockName}.${normalizedPath}`;
      result = (_get2 = (0,external_lodash_namespaceObject.get)(settings, blockPath)) !== null && _get2 !== void 0 ? _get2 : (0,external_lodash_namespaceObject.get)(settings, defaultsPath);
    } // Return if the setting was found in either the block instance or the store.


    if (result !== undefined) {
      if (external_wp_blocks_namespaceObject.__EXPERIMENTAL_PATHS_WITH_MERGE[normalizedPath]) {
        var _ref, _result$custom;

        return (_ref = (_result$custom = result.custom) !== null && _result$custom !== void 0 ? _result$custom : result.theme) !== null && _ref !== void 0 ? _ref : result.default;
      }

      return result;
    } // 3. Otherwise, use deprecated settings.


    const deprecatedSettingsValue = deprecatedFlags[normalizedPath] ? deprecatedFlags[normalizedPath](settings) : undefined;

    if (deprecatedSettingsValue !== undefined) {
      return deprecatedSettingsValue;
    } // 4. Fallback for typography.dropCap:
    // This is only necessary to support typography.dropCap.
    // when __experimentalFeatures are not present (core without plugin).
    // To remove when __experimentalFeatures are ported to core.


    return normalizedPath === 'typography.dropCap' ? true : undefined;
  }, [blockName, clientId, path]);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/spacing-sizes-control/spacing-input-control.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */




const CUSTOM_VALUE_SETTINGS = {
  px: {
    max: 300,
    steps: 1
  },
  '%': {
    max: 100,
    steps: 1
  },
  vw: {
    max: 100,
    steps: 1
  },
  vh: {
    max: 100,
    steps: 1
  },
  em: {
    max: 10,
    steps: 0.1
  },
  rm: {
    max: 10,
    steps: 0.1
  }
};
function SpacingInputControl(_ref) {
  var _CUSTOM_VALUE_SETTING, _CUSTOM_VALUE_SETTING2, _CUSTOM_VALUE_SETTING3, _CUSTOM_VALUE_SETTING4, _spacingSizes$current;

  let {
    spacingSizes,
    value,
    side,
    onChange,
    isMixed = false,
    type,
    minimumCustomValue,
    onMouseOver,
    onMouseOut
  } = _ref;
  // Treat value as a preset value if the passed in value matches the value of one of the spacingSizes.
  value = getPresetValueFromCustomValue(value, spacingSizes);
  let selectListSizes = spacingSizes;
  const showRangeControl = spacingSizes.length <= 8;
  const disableCustomSpacingSizes = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const editorSettings = select(store).getSettings();
    return editorSettings === null || editorSettings === void 0 ? void 0 : editorSettings.disableCustomSpacingSizes;
  });
  const [showCustomValueControl, setShowCustomValueControl] = (0,external_wp_element_namespaceObject.useState)(!disableCustomSpacingSizes && value !== undefined && !isValueSpacingPreset(value));
  const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
    availableUnits: useSetting('spacing.units') || ['px', 'em', 'rem']
  });
  let currentValue = null;
  const showCustomValueInSelectList = !showRangeControl && !showCustomValueControl && value !== undefined && (!isValueSpacingPreset(value) || isValueSpacingPreset(value) && isMixed);

  if (showCustomValueInSelectList) {
    selectListSizes = [...spacingSizes, {
      name: !isMixed ? // translators: A custom measurement, eg. a number followed by a unit like 12px.
      (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)('Custom (%s)'), value) : (0,external_wp_i18n_namespaceObject.__)('Mixed'),
      slug: 'custom',
      size: value
    }];
    currentValue = selectListSizes.length - 1;
  } else if (!isMixed) {
    currentValue = !showCustomValueControl ? getSliderValueFromPreset(value, spacingSizes) : getCustomValueFromPreset(value, spacingSizes);
  }

  const selectedUnit = (0,external_wp_element_namespaceObject.useMemo)(() => (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(currentValue), [currentValue])[1] || units[0].value;

  const setInitialValue = () => {
    if (value === undefined) {
      onChange('0');
    }
  };

  const customTooltipContent = newValue => {
    var _spacingSizes$newValu;

    return value === undefined ? undefined : (_spacingSizes$newValu = spacingSizes[newValue]) === null || _spacingSizes$newValu === void 0 ? void 0 : _spacingSizes$newValu.name;
  };

  const customRangeValue = parseFloat(currentValue, 10);

  const getNewCustomValue = newSize => {
    const isNumeric = !isNaN(parseFloat(newSize));
    const nextValue = isNumeric ? newSize : undefined;
    return nextValue;
  };

  const getNewPresetValue = (newSize, controlType) => {
    var _spacingSizes$newSize;

    const size = parseInt(newSize, 10);

    if (controlType === 'selectList') {
      if (size === 0) {
        return undefined;
      }

      if (size === 1) {
        return '0';
      }
    } else if (size === 0) {
      return '0';
    }

    return `var:preset|spacing|${(_spacingSizes$newSize = spacingSizes[newSize]) === null || _spacingSizes$newSize === void 0 ? void 0 : _spacingSizes$newSize.slug}`;
  };

  const handleCustomValueSliderChange = next => {
    onChange([next, selectedUnit].join(''));
  };

  const allPlaceholder = isMixed ? (0,external_wp_i18n_namespaceObject.__)('Mixed') : null;
  const currentValueHint = !isMixed ? customTooltipContent(currentValue) : (0,external_wp_i18n_namespaceObject.__)('Mixed');
  const options = selectListSizes.map((size, index) => ({
    key: index,
    name: size.name
  }));
  const marks = spacingSizes.map((newValue, index) => ({
    value: index,
    label: undefined
  }));
  const ariaLabel = (0,external_wp_i18n_namespaceObject.sprintf)( // translators: 1: The side of the block being modified (top, bottom, left, etc.). 2. Type of spacing being modified (Padding, margin, etc)
  (0,external_wp_i18n_namespaceObject.__)('%1$s %2$s'), LABELS[side], type === null || type === void 0 ? void 0 : type.toLowerCase());
  const showHint = showRangeControl && !showCustomValueControl && currentValueHint !== undefined;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, side !== 'all' && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalHStack, {
    className: "components-spacing-sizes-control__side-labels"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.BaseControl.VisualLabel, {
    className: "components-spacing-sizes-control__side-label"
  }, LABELS[side]), showHint && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.BaseControl.VisualLabel, {
    className: "components-spacing-sizes-control__hint-single"
  }, currentValueHint)), side === 'all' && showHint && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.BaseControl.VisualLabel, {
    className: "components-spacing-sizes-control__hint-all"
  }, currentValueHint), !disableCustomSpacingSizes && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    label: showCustomValueControl ? (0,external_wp_i18n_namespaceObject.__)('Use size preset') : (0,external_wp_i18n_namespaceObject.__)('Set custom size'),
    icon: library_settings,
    onClick: () => {
      setShowCustomValueControl(!showCustomValueControl);
    },
    isPressed: showCustomValueControl,
    isSmall: true,
    className: classnames_default()({
      'components-spacing-sizes-control__custom-toggle-all': side === 'all',
      'components-spacing-sizes-control__custom-toggle-single': side !== 'all'
    }),
    iconSize: 24
  }), showCustomValueControl && (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalUnitControl, {
    onMouseOver: onMouseOver,
    onMouseOut: onMouseOut,
    onFocus: onMouseOver,
    onBlur: onMouseOut,
    onChange: newSize => onChange(getNewCustomValue(newSize)),
    value: currentValue,
    units: units,
    min: minimumCustomValue,
    placeholder: allPlaceholder,
    disableUnits: isMixed,
    label: ariaLabel,
    hideLabelFromVision: true,
    className: "components-spacing-sizes-control__custom-value-input",
    size: '__unstable-large'
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.RangeControl, {
    onMouseOver: onMouseOver,
    onMouseOut: onMouseOut,
    onFocus: onMouseOver,
    onBlur: onMouseOut,
    value: customRangeValue,
    min: 0,
    max: (_CUSTOM_VALUE_SETTING = (_CUSTOM_VALUE_SETTING2 = CUSTOM_VALUE_SETTINGS[selectedUnit]) === null || _CUSTOM_VALUE_SETTING2 === void 0 ? void 0 : _CUSTOM_VALUE_SETTING2.max) !== null && _CUSTOM_VALUE_SETTING !== void 0 ? _CUSTOM_VALUE_SETTING : 10,
    step: (_CUSTOM_VALUE_SETTING3 = (_CUSTOM_VALUE_SETTING4 = CUSTOM_VALUE_SETTINGS[selectedUnit]) === null || _CUSTOM_VALUE_SETTING4 === void 0 ? void 0 : _CUSTOM_VALUE_SETTING4.steps) !== null && _CUSTOM_VALUE_SETTING3 !== void 0 ? _CUSTOM_VALUE_SETTING3 : 0.1,
    withInputField: false,
    onChange: handleCustomValueSliderChange,
    className: "components-spacing-sizes-control__custom-value-range",
    __nextHasNoMarginBottom: true
  })), showRangeControl && !showCustomValueControl && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.RangeControl, {
    onMouseOver: onMouseOver,
    onMouseOut: onMouseOut,
    className: "components-spacing-sizes-control__range-control",
    value: currentValue,
    onChange: newSize => onChange(getNewPresetValue(newSize)),
    onMouseDown: event => {
      var _event$nativeEvent;

      // If mouse down is near start of range set initial value to 0, which
      // prevents the user have to drag right then left to get 0 setting.
      if ((event === null || event === void 0 ? void 0 : (_event$nativeEvent = event.nativeEvent) === null || _event$nativeEvent === void 0 ? void 0 : _event$nativeEvent.offsetX) < 35) {
        setInitialValue();
      }
    },
    withInputField: false,
    "aria-valuenow": currentValue,
    "aria-valuetext": (_spacingSizes$current = spacingSizes[currentValue]) === null || _spacingSizes$current === void 0 ? void 0 : _spacingSizes$current.name,
    renderTooltipContent: customTooltipContent,
    min: 0,
    max: spacingSizes.length - 1,
    marks: marks,
    label: ariaLabel,
    hideLabelFromVision: true,
    __nextHasNoMarginBottom: true,
    onFocus: onMouseOver,
    onBlur: onMouseOut
  }), !showRangeControl && !showCustomValueControl && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.CustomSelectControl, {
    className: "components-spacing-sizes-control__custom-select-control",
    value: options.find(option => option.key === currentValue) || '' // passing undefined here causes a downshift controlled/uncontrolled warning
    ,
    onChange: selection => {
      onChange(getNewPresetValue(selection.selectedItem.key, 'selectList'));
    },
    options: options,
    label: ariaLabel,
    hideLabelFromVision: true,
    __nextUnconstrainedWidth: true,
    size: '__unstable-large',
    onMouseOver: onMouseOver,
    onMouseOut: onMouseOut,
    onFocus: onMouseOver,
    onBlur: onMouseOut
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/spacing-sizes-control/all-input-control.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */



function AllInputControl(_ref) {
  let {
    onChange,
    values,
    sides,
    spacingSizes,
    type,
    minimumCustomValue,
    onMouseOver,
    onMouseOut
  } = _ref;
  const allValue = getAllRawValue(values);
  const hasValues = isValuesDefined(values);
  const isMixed = hasValues && isValuesMixed(values, sides);

  const handleOnChange = next => {
    const nextValues = (0,external_wp_components_namespaceObject.__experimentalApplyValueToSides)(values, next, sides);
    onChange(nextValues);
  };

  return (0,external_wp_element_namespaceObject.createElement)(SpacingInputControl, {
    value: allValue,
    onChange: handleOnChange,
    side: 'all',
    spacingSizes: spacingSizes,
    isMixed: isMixed,
    type: type,
    minimumCustomValue: minimumCustomValue,
    onMouseOver: onMouseOver,
    onMouseOut: onMouseOut
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/spacing-sizes-control/input-controls.js


/**
 * Internal dependencies
 */


function BoxInputControls(_ref) {
  let {
    values,
    sides,
    onChange,
    spacingSizes,
    type,
    minimumCustomValue,
    onMouseOver,
    onMouseOut
  } = _ref;
  // Filter sides if custom configuration provided, maintaining default order.
  const filteredSides = sides !== null && sides !== void 0 && sides.length ? ALL_SIDES.filter(side => sides.includes(side)) : ALL_SIDES;

  const createHandleOnChange = side => next => {
    const nextValues = { ...values
    };
    nextValues[side] = next;
    onChange(nextValues);
  };

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, filteredSides.map(side => {
    return (0,external_wp_element_namespaceObject.createElement)(SpacingInputControl, {
      value: values[side],
      label: LABELS[side],
      key: `spacing-sizes-control-${side}`,
      withInputField: false,
      side: side,
      onChange: createHandleOnChange(side),
      spacingSizes: spacingSizes,
      type: type,
      minimumCustomValue: minimumCustomValue,
      onMouseOver: onMouseOver,
      onMouseOut: onMouseOut
    });
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/spacing-sizes-control/axial-input-controls.js


/**
 * Internal dependencies
 */


const groupedSides = ['vertical', 'horizontal'];
function AxialInputControls(_ref) {
  let {
    onChange,
    values,
    sides,
    spacingSizes,
    type,
    minimumCustomValue,
    onMouseOver,
    onMouseOut
  } = _ref;

  const createHandleOnChange = side => next => {
    if (!onChange) {
      return;
    }

    const nextValues = { ...values
    };

    if (side === 'vertical') {
      nextValues.top = next;
      nextValues.bottom = next;
    }

    if (side === 'horizontal') {
      nextValues.left = next;
      nextValues.right = next;
    }

    onChange(nextValues);
  }; // Filter sides if custom configuration provided, maintaining default order.


  const filteredSides = sides !== null && sides !== void 0 && sides.length ? groupedSides.filter(side => sides.includes(side)) : groupedSides;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, filteredSides.map(side => {
    const axisValue = side === 'vertical' ? values.top : values.left;
    return (0,external_wp_element_namespaceObject.createElement)(SpacingInputControl, {
      value: axisValue,
      onChange: createHandleOnChange(side),
      label: LABELS[side],
      key: `spacing-sizes-control-${side}`,
      withInputField: false,
      side: side,
      spacingSizes: spacingSizes,
      type: type,
      minimumCustomValue: minimumCustomValue,
      onMouseOver: onMouseOver,
      onMouseOut: onMouseOut
    });
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/link.js


/**
 * WordPress dependencies
 */

const link_link = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M15.6 7.2H14v1.5h1.6c2 0 3.7 1.7 3.7 3.7s-1.7 3.7-3.7 3.7H14v1.5h1.6c2.8 0 5.2-2.3 5.2-5.2 0-2.9-2.3-5.2-5.2-5.2zM4.7 12.4c0-2 1.7-3.7 3.7-3.7H10V7.2H8.4c-2.9 0-5.2 2.3-5.2 5.2 0 2.9 2.3 5.2 5.2 5.2H10v-1.5H8.4c-2 0-3.7-1.7-3.7-3.7zm4.6.9h5.3v-1.5H9.3v1.5z"
}));
/* harmony default export */ var library_link = (link_link);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/link-off.js


/**
 * WordPress dependencies
 */

const linkOff = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M15.6 7.3h-.7l1.6-3.5-.9-.4-3.9 8.5H9v1.5h2l-1.3 2.8H8.4c-2 0-3.7-1.7-3.7-3.7s1.7-3.7 3.7-3.7H10V7.3H8.4c-2.9 0-5.2 2.3-5.2 5.2 0 2.9 2.3 5.2 5.2 5.2H9l-1.4 3.2.9.4 5.7-12.5h1.4c2 0 3.7 1.7 3.7 3.7s-1.7 3.7-3.7 3.7H14v1.5h1.6c2.9 0 5.2-2.3 5.2-5.2 0-2.9-2.4-5.2-5.2-5.2z"
}));
/* harmony default export */ var link_off = (linkOff);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/spacing-sizes-control/linked-button.js


/**
 * WordPress dependencies
 */



function LinkedButton(_ref) {
  let {
    isLinked,
    onClick
  } = _ref;
  const label = isLinked ? (0,external_wp_i18n_namespaceObject.__)('Unlink sides') : (0,external_wp_i18n_namespaceObject.__)('Link sides');
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Tooltip, {
    text: label
  }, (0,external_wp_element_namespaceObject.createElement)("span", {
    className: "component-spacing-sizes-control__linked-button"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    isSmall: true,
    icon: isLinked ? library_link : link_off,
    iconSize: 24,
    "aria-label": label,
    onClick: onClick
  })));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/spacing-sizes-control/index.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */







function SpacingSizesControl(_ref) {
  let {
    inputProps,
    onChange,
    label = (0,external_wp_i18n_namespaceObject.__)('Spacing Control'),
    values,
    sides,
    splitOnAxis = false,
    useSelect,
    minimumCustomValue = 0,
    onMouseOver,
    onMouseOut
  } = _ref;
  const spacingSizes = [{
    name: 0,
    slug: '0',
    size: 0
  }, ...(useSetting('spacing.spacingSizes') || [])];

  if (spacingSizes.length > 8) {
    spacingSizes.unshift({
      name: (0,external_wp_i18n_namespaceObject.__)('Default'),
      slug: 'default',
      size: undefined
    });
  }

  const inputValues = values || DEFAULT_VALUES;
  const hasInitialValue = isValuesDefined(values);
  const hasOneSide = (sides === null || sides === void 0 ? void 0 : sides.length) === 1;
  const [isLinked, setIsLinked] = (0,external_wp_element_namespaceObject.useState)(!hasInitialValue || !isValuesMixed(inputValues, sides) || hasOneSide);

  const toggleLinked = () => {
    setIsLinked(!isLinked);
  };

  const handleOnChange = nextValue => {
    const newValues = { ...values,
      ...nextValue
    };
    onChange(newValues);
  };

  const inputControlProps = { ...inputProps,
    onChange: handleOnChange,
    isLinked,
    sides,
    values: inputValues,
    spacingSizes,
    useSelect,
    type: label,
    minimumCustomValue,
    onMouseOver,
    onMouseOut
  };
  return (0,external_wp_element_namespaceObject.createElement)("fieldset", {
    className: classnames_default()('component-spacing-sizes-control', {
      'is-unlinked': !isLinked
    })
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.BaseControl.VisualLabel, {
    as: "legend"
  }, label), !hasOneSide && (0,external_wp_element_namespaceObject.createElement)(LinkedButton, {
    onClick: toggleLinked,
    isLinked: isLinked
  }), isLinked && (0,external_wp_element_namespaceObject.createElement)(AllInputControl, _extends({
    "aria-label": label
  }, inputControlProps)), !isLinked && splitOnAxis && (0,external_wp_element_namespaceObject.createElement)(AxialInputControls, inputControlProps), !isLinked && !splitOnAxis && (0,external_wp_element_namespaceObject.createElement)(BoxInputControls, inputControlProps));
}

;// CONCATENATED MODULE: external ["wp","warning"]
var external_wp_warning_namespaceObject = window["wp"]["warning"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inspector-controls/groups.js
/**
 * WordPress dependencies
 */

const InspectorControlsDefault = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControls');
const InspectorControlsAdvanced = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorAdvancedControls');
const InspectorControlsBorder = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsBorder');
const InspectorControlsColor = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsColor');
const InspectorControlsDimensions = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsDimensions');
const InspectorControlsPosition = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsPosition');
const InspectorControlsTypography = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsTypography');
const InspectorControlsListView = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsListView');
const InspectorControlsStyles = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsStyles');
const groups_groups = {
  default: InspectorControlsDefault,
  advanced: InspectorControlsAdvanced,
  border: InspectorControlsBorder,
  color: InspectorControlsColor,
  dimensions: InspectorControlsDimensions,
  list: InspectorControlsListView,
  settings: InspectorControlsDefault,
  // Alias for default.
  styles: InspectorControlsStyles,
  typography: InspectorControlsTypography,
  position: InspectorControlsPosition
};
/* harmony default export */ var inspector_controls_groups = (groups_groups);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inspector-controls/fill.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



function InspectorControlsFill(_ref) {
  var _groups$group;

  let {
    children,
    group = 'default',
    __experimentalGroup
  } = _ref;

  if (__experimentalGroup) {
    external_wp_deprecated_default()('`__experimentalGroup` property in `InspectorControlsFill`', {
      since: '6.2',
      version: '6.4',
      alternative: '`group`'
    });
    group = __experimentalGroup;
  }

  const isDisplayed = useDisplayBlockControls();
  const Fill = (_groups$group = inspector_controls_groups[group]) === null || _groups$group === void 0 ? void 0 : _groups$group.Fill;

  if (!Fill) {
    typeof process !== "undefined" && process.env && "production" !== "production" ? 0 : void 0;
    return null;
  }

  if (!isDisplayed) {
    return null;
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalStyleProvider, {
    document: document
  }, (0,external_wp_element_namespaceObject.createElement)(Fill, null, fillProps => {
    // Children passed to InspectorControlsFill will not have
    // access to any React Context whose Provider is part of
    // the InspectorControlsSlot tree. So we re-create the
    // Provider in this subtree.
    const value = !(0,external_lodash_namespaceObject.isEmpty)(fillProps) ? fillProps : null;
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToolsPanelContext.Provider, {
      value: value
    }, children);
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/utils.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Removed falsy values from nested object.
 *
 * @param {*} object
 * @return {*} Object cleaned from falsy values
 */

const utils_cleanEmptyObject = object => {
  if (object === null || typeof object !== 'object' || Array.isArray(object)) {
    return object;
  }

  const cleanedNestedObjects = Object.fromEntries(Object.entries((0,external_lodash_namespaceObject.mapValues)(object, utils_cleanEmptyObject)).filter(_ref => {
    let [, value] = _ref;
    return Boolean(value);
  }));
  return (0,external_lodash_namespaceObject.isEmpty)(cleanedNestedObjects) ? undefined : cleanedNestedObjects;
};
/**
 * Converts a path to an array of its fragments.
 * Supports strings, numbers and arrays:
 *
 * 'foo' => [ 'foo' ]
 * 2 => [ '2' ]
 * [ 'foo', 'bar' ] => [ 'foo', 'bar' ]
 *
 * @param {string|number|Array} path Path
 * @return {Array} Normalized path.
 */

function normalizePath(path) {
  if (Array.isArray(path)) {
    return path;
  } else if (typeof path === 'number') {
    return [path.toString()];
  }

  return [path];
}
/**
 * Clones an object.
 * Non-object values are returned unchanged.
 *
 * @param {*} object Object to clone.
 * @return {*} Cloned object, or original literal non-object value.
 */


function cloneObject(object) {
  if (typeof object === 'object') {
    return { ...Object.fromEntries(Object.entries(object).map(_ref2 => {
        let [key, value] = _ref2;
        return [key, cloneObject(value)];
      }))
    };
  }

  return object;
}
/**
 * Perform an immutable set.
 * Handles nullish initial values.
 * Clones all nested objects in the specified object.
 *
 * @param {Object}              object Object to set a value in.
 * @param {number|string|Array} path   Path in the object to modify.
 * @param {*}                   value  New value to set.
 * @return {Object} Cloned object with the new value set.
 */


function immutableSet(object, path, value) {
  const normalizedPath = normalizePath(path);
  const newObject = object ? cloneObject(object) : {};
  normalizedPath.reduce((acc, key, i) => {
    if (acc[key] === undefined) {
      acc[key] = {};
    }

    if (i === normalizedPath.length - 1) {
      acc[key] = value;
    }

    return acc[key];
  }, newObject);
  return newObject;
}
function transformStyles(activeSupports, migrationPaths, result, source, index, results) {
  var _source$;

  // If there are no active supports return early.
  if (Object.values(activeSupports !== null && activeSupports !== void 0 ? activeSupports : {}).every(isActive => !isActive)) {
    return result;
  } // If the condition verifies we are probably in the presence of a wrapping transform
  // e.g: nesting paragraphs in a group or columns and in that case the styles should not be transformed.


  if (results.length === 1 && result.innerBlocks.length === source.length) {
    return result;
  } // For cases where we have a transform from one block to multiple blocks
  // or multiple blocks to one block we apply the styles of the first source block
  // to the result(s).


  let referenceBlockAttributes = (_source$ = source[0]) === null || _source$ === void 0 ? void 0 : _source$.attributes; // If we are in presence of transform between more than one block in the source
  // that has more than one block in the result
  // we apply the styles on source N to the result N,
  // if source N does not exists we do nothing.

  if (results.length > 1 && source.length > 1) {
    if (source[index]) {
      var _source$index;

      referenceBlockAttributes = (_source$index = source[index]) === null || _source$index === void 0 ? void 0 : _source$index.attributes;
    } else {
      return result;
    }
  }

  let returnBlock = result;
  Object.entries(activeSupports).forEach(_ref3 => {
    let [support, isActive] = _ref3;

    if (isActive) {
      migrationPaths[support].forEach(path => {
        const styleValue = (0,external_lodash_namespaceObject.get)(referenceBlockAttributes, path);

        if (styleValue) {
          returnBlock = { ...returnBlock,
            attributes: immutableSet(returnBlock.attributes, path, styleValue)
          };
        }
      });
    }
  });
  return returnBlock;
}
/**
 * Check whether serialization of specific block support feature or set should
 * be skipped.
 *
 * @param {string|Object} blockType  Block name or block type object.
 * @param {string}        featureSet Name of block support feature set.
 * @param {string}        feature    Name of the individual feature to check.
 *
 * @return {boolean} Whether serialization should occur.
 */

function shouldSkipSerialization(blockType, featureSet, feature) {
  const support = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, featureSet);
  const skipSerialization = support === null || support === void 0 ? void 0 : support.__experimentalSkipSerialization;

  if (Array.isArray(skipSerialization)) {
    return skipSerialization.includes(feature);
  }

  return skipSerialization;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inspector-controls/block-support-tools-panel.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function BlockSupportToolsPanel(_ref) {
  let {
    children,
    group,
    label
  } = _ref;
  const {
    updateBlockAttributes
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const {
    getBlockAttributes,
    getMultiSelectedBlockClientIds,
    getSelectedBlockClientId,
    hasMultiSelection
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const panelId = getSelectedBlockClientId();
  const resetAll = (0,external_wp_element_namespaceObject.useCallback)(function () {
    let resetFilters = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    const newAttributes = {};
    const clientIds = hasMultiSelection() ? getMultiSelectedBlockClientIds() : [panelId];
    clientIds.forEach(clientId => {
      const {
        style
      } = getBlockAttributes(clientId);
      let newBlockAttributes = {
        style
      };
      resetFilters.forEach(resetFilter => {
        newBlockAttributes = { ...newBlockAttributes,
          ...resetFilter(newBlockAttributes)
        };
      }); // Enforce a cleaned style object.

      newBlockAttributes = { ...newBlockAttributes,
        style: utils_cleanEmptyObject(newBlockAttributes.style)
      };
      newAttributes[clientId] = newBlockAttributes;
    });
    updateBlockAttributes(clientIds, newAttributes, true);
  }, [utils_cleanEmptyObject, getBlockAttributes, getMultiSelectedBlockClientIds, hasMultiSelection, panelId, updateBlockAttributes]);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToolsPanel, {
    className: `${group}-block-support-panel`,
    label: label,
    resetAll: resetAll,
    key: panelId,
    panelId: panelId,
    hasInnerWrapper: true,
    shouldRenderPlaceholderItems: true // Required to maintain fills ordering.
    ,
    __experimentalFirstVisibleItemClass: "first",
    __experimentalLastVisibleItemClass: "last"
  }, children);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inspector-controls/block-support-slot-container.js



/**
 * WordPress dependencies
 */


function BlockSupportSlotContainer(_ref) {
  let {
    Slot,
    ...props
  } = _ref;
  const toolsPanelContext = (0,external_wp_element_namespaceObject.useContext)(external_wp_components_namespaceObject.__experimentalToolsPanelContext);
  return (0,external_wp_element_namespaceObject.createElement)(Slot, _extends({}, props, {
    fillProps: toolsPanelContext,
    bubblesVirtually: true
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inspector-controls/slot.js



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function InspectorControlsSlot(_ref) {
  var _groups$group;

  let {
    __experimentalGroup,
    group = 'default',
    label,
    ...props
  } = _ref;

  if (__experimentalGroup) {
    external_wp_deprecated_default()('`__experimentalGroup` property in `InspectorControlsSlot`', {
      since: '6.2',
      version: '6.4',
      alternative: '`group`'
    });
    group = __experimentalGroup;
  }

  const Slot = (_groups$group = inspector_controls_groups[group]) === null || _groups$group === void 0 ? void 0 : _groups$group.Slot;
  const slot = (0,external_wp_components_namespaceObject.__experimentalUseSlot)(Slot === null || Slot === void 0 ? void 0 : Slot.__unstableName);
  const fills = (0,external_wp_components_namespaceObject.__experimentalUseSlotFills)(Slot === null || Slot === void 0 ? void 0 : Slot.__unstableName);

  if (!Slot || !slot) {
    typeof process !== "undefined" && process.env && "production" !== "production" ? 0 : void 0;
    return null;
  }

  const hasFills = Boolean(fills && fills.length);

  if (!hasFills) {
    return null;
  }

  if (label) {
    return (0,external_wp_element_namespaceObject.createElement)(BlockSupportToolsPanel, {
      group: group,
      label: label
    }, (0,external_wp_element_namespaceObject.createElement)(BlockSupportSlotContainer, _extends({}, props, {
      Slot: Slot
    })));
  }

  return (0,external_wp_element_namespaceObject.createElement)(Slot, _extends({}, props, {
    bubblesVirtually: true
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inspector-controls/index.js



/**
 * Internal dependencies
 */


const InspectorControls = InspectorControlsFill;
InspectorControls.Slot = InspectorControlsSlot; // This is just here for backward compatibility.

const InspectorAdvancedControls = props => {
  return (0,external_wp_element_namespaceObject.createElement)(InspectorControlsFill, _extends({}, props, {
    group: "advanced"
  }));
};

InspectorAdvancedControls.Slot = props => {
  return (0,external_wp_element_namespaceObject.createElement)(InspectorControlsSlot, _extends({}, props, {
    group: "advanced"
  }));
};

InspectorAdvancedControls.slotName = 'InspectorAdvancedControls';
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/inspector-controls/README.md
 */

/* harmony default export */ var inspector_controls = (InspectorControls);

;// CONCATENATED MODULE: external ["wp","isShallowEqual"]
var external_wp_isShallowEqual_namespaceObject = window["wp"]["isShallowEqual"];
var external_wp_isShallowEqual_default = /*#__PURE__*/__webpack_require__.n(external_wp_isShallowEqual_namespaceObject);
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-popover/use-popover-scroll.js
/**
 * WordPress dependencies
 */

/**
 * Allow scrolling "through" popovers over the canvas. This is only called for
 * as long as the pointer is over a popover. Do not use React events because it
 * will bubble through portals.
 *
 * @param {Object} scrollableRef
 */

function usePopoverScroll(scrollableRef) {
  return (0,external_wp_compose_namespaceObject.useRefEffect)(node => {
    if (!scrollableRef) {
      return;
    }

    function onWheel(event) {
      const {
        deltaX,
        deltaY
      } = event;
      scrollableRef.current.scrollBy(deltaX, deltaY);
    } // Tell the browser that we do not call event.preventDefault
    // See https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/addEventListener#improving_scrolling_performance_with_passive_listeners


    const options = {
      passive: true
    };
    node.addEventListener('wheel', onWheel, options);
    return () => {
      node.removeEventListener('wheel', onWheel, options);
    };
  }, [scrollableRef]);
}

/* harmony default export */ var use_popover_scroll = (usePopoverScroll);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-popover/index.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



const MAX_POPOVER_RECOMPUTE_COUNTER = Number.MAX_SAFE_INTEGER;

function BlockPopover(_ref, ref) {
  let {
    clientId,
    bottomClientId,
    children,
    __unstableRefreshSize,
    __unstableCoverTarget = false,
    __unstablePopoverSlot,
    __unstableContentRef,
    shift = true,
    ...props
  } = _ref;
  const selectedElement = useBlockElement(clientId);
  const lastSelectedElement = useBlockElement(bottomClientId !== null && bottomClientId !== void 0 ? bottomClientId : clientId);
  const mergedRefs = (0,external_wp_compose_namespaceObject.useMergeRefs)([ref, use_popover_scroll(__unstableContentRef)]);
  const [popoverDimensionsRecomputeCounter, forceRecomputePopoverDimensions] = (0,external_wp_element_namespaceObject.useReducer)( // Module is there to make sure that the counter doesn't overflow.
  s => (s + 1) % MAX_POPOVER_RECOMPUTE_COUNTER, 0); // When blocks are moved up/down, they are animated to their new position by
  // updating the `transform` property manually (i.e. without using CSS
  // transitions or animations). The animation, which can also scroll the block
  // editor, can sometimes cause the position of the Popover to get out of sync.
  // A MutationObserver is therefore used to make sure that changes to the
  // selectedElement's attribute (i.e. `transform`) can be tracked and used to
  // trigger the Popover to rerender.

  (0,external_wp_element_namespaceObject.useLayoutEffect)(() => {
    if (!selectedElement) {
      return;
    }

    const observer = new window.MutationObserver(forceRecomputePopoverDimensions);
    observer.observe(selectedElement, {
      attributes: true
    });
    return () => {
      observer.disconnect();
    };
  }, [selectedElement]);
  const style = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if ( // popoverDimensionsRecomputeCounter is by definition always equal or greater
    // than 0. This check is only there to satisfy the correctness of the
    // exhaustive-deps rule for the `useMemo` hook.
    popoverDimensionsRecomputeCounter < 0 || !selectedElement || lastSelectedElement !== selectedElement) {
      return {};
    }

    return {
      position: 'absolute',
      width: selectedElement.offsetWidth,
      height: selectedElement.offsetHeight
    };
  }, [selectedElement, lastSelectedElement, __unstableRefreshSize, popoverDimensionsRecomputeCounter]);
  const popoverAnchor = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if ( // popoverDimensionsRecomputeCounter is by definition always equal or greater
    // than 0. This check is only there to satisfy the correctness of the
    // exhaustive-deps rule for the `useMemo` hook.
    popoverDimensionsRecomputeCounter < 0 || !selectedElement || bottomClientId && !lastSelectedElement) {
      return undefined;
    }

    return {
      getBoundingClientRect() {
        var _lastSelectedBCR$left, _lastSelectedBCR$top, _lastSelectedBCR$righ, _lastSelectedBCR$bott;

        const selectedBCR = selectedElement.getBoundingClientRect();
        const lastSelectedBCR = lastSelectedElement === null || lastSelectedElement === void 0 ? void 0 : lastSelectedElement.getBoundingClientRect(); // Get the biggest rectangle that encompasses completely the currently
        // selected element and the last selected element:
        // - for top/left coordinates, use the smaller numbers
        // - for the bottom/right coordinates, use the largest numbers

        const left = Math.min(selectedBCR.left, (_lastSelectedBCR$left = lastSelectedBCR === null || lastSelectedBCR === void 0 ? void 0 : lastSelectedBCR.left) !== null && _lastSelectedBCR$left !== void 0 ? _lastSelectedBCR$left : Infinity);
        const top = Math.min(selectedBCR.top, (_lastSelectedBCR$top = lastSelectedBCR === null || lastSelectedBCR === void 0 ? void 0 : lastSelectedBCR.top) !== null && _lastSelectedBCR$top !== void 0 ? _lastSelectedBCR$top : Infinity);
        const right = Math.max(selectedBCR.right, (_lastSelectedBCR$righ = lastSelectedBCR.right) !== null && _lastSelectedBCR$righ !== void 0 ? _lastSelectedBCR$righ : -Infinity);
        const bottom = Math.max(selectedBCR.bottom, (_lastSelectedBCR$bott = lastSelectedBCR.bottom) !== null && _lastSelectedBCR$bott !== void 0 ? _lastSelectedBCR$bott : -Infinity);
        const width = right - left;
        const height = bottom - top;
        return new window.DOMRect(left, top, width, height);
      },

      ownerDocument: selectedElement.ownerDocument
    };
  }, [bottomClientId, lastSelectedElement, selectedElement, popoverDimensionsRecomputeCounter]);

  if (!selectedElement || bottomClientId && !lastSelectedElement) {
    return null;
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Popover, _extends({
    ref: mergedRefs,
    animate: false,
    focusOnMount: false,
    anchor: popoverAnchor // Render in the old slot if needed for backward compatibility,
    // otherwise render in place (not in the default popover slot).
    ,
    __unstableSlotName: __unstablePopoverSlot || null,
    placement: "top-start",
    resize: false,
    flip: false,
    shift: shift
  }, props, {
    className: classnames_default()('block-editor-block-popover', props.className),
    variant: "unstyled"
  }), __unstableCoverTarget && (0,external_wp_element_namespaceObject.createElement)("div", {
    style: style
  }, children), !__unstableCoverTarget && children);
}

/* harmony default export */ var block_popover = ((0,external_wp_element_namespaceObject.forwardRef)(BlockPopover));

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/margin.js


/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */







/**
 * Determines if there is margin support.
 *
 * @param {string|Object} blockType Block name or Block Type object.
 *
 * @return {boolean} Whether there is support.
 */

function hasMarginSupport(blockType) {
  const support = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, SPACING_SUPPORT_KEY);
  return !!(true === support || support !== null && support !== void 0 && support.margin);
}
/**
 * Checks if there is a current value in the margin block support attributes.
 *
 * @param {Object} props Block props.
 * @return {boolean}      Whether or not the block has a margin value set.
 */

function hasMarginValue(props) {
  var _props$attributes$sty, _props$attributes$sty2;

  return ((_props$attributes$sty = props.attributes.style) === null || _props$attributes$sty === void 0 ? void 0 : (_props$attributes$sty2 = _props$attributes$sty.spacing) === null || _props$attributes$sty2 === void 0 ? void 0 : _props$attributes$sty2.margin) !== undefined;
}
/**
 * Resets the margin block support attributes. This can be used when disabling
 * the margin support controls for a block via a `ToolsPanel`.
 *
 * @param {Object} props               Block props.
 * @param {Object} props.attributes    Block's attributes.
 * @param {Object} props.setAttributes Function to set block's attributes.
 */

function resetMargin(_ref) {
  let {
    attributes = {},
    setAttributes
  } = _ref;
  const {
    style
  } = attributes;
  setAttributes({
    style: utils_cleanEmptyObject({ ...style,
      spacing: { ...(style === null || style === void 0 ? void 0 : style.spacing),
        margin: undefined
      }
    })
  });
}
/**
 * Custom hook that checks if margin settings have been disabled.
 *
 * @param {string} name The name of the block.
 *
 * @return {boolean} Whether margin setting is disabled.
 */

function useIsMarginDisabled() {
  let {
    name: blockName
  } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  const isDisabled = !useSetting('spacing.margin');
  const isInvalid = !useIsDimensionsSupportValid(blockName, 'margin');
  return !hasMarginSupport(blockName) || isDisabled || isInvalid;
}
/**
 * Inspector control panel containing the margin related configuration
 *
 * @param {Object} props Block props.
 *
 * @return {WPElement} Margin edit element.
 */

function MarginEdit(props) {
  var _style$spacing, _style$spacing2;

  const {
    name: blockName,
    attributes: {
      style
    },
    setAttributes,
    onMouseOver,
    onMouseOut
  } = props;
  const spacingSizes = useSetting('spacing.spacingSizes');
  const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
    availableUnits: useSetting('spacing.units') || ['%', 'px', 'em', 'rem', 'vw']
  });
  const sides = useCustomSides(blockName, 'margin');
  const splitOnAxis = sides && sides.some(side => AXIAL_SIDES.includes(side));

  if (useIsMarginDisabled(props)) {
    return null;
  }

  const onChange = next => {
    const newStyle = { ...style,
      spacing: { ...(style === null || style === void 0 ? void 0 : style.spacing),
        margin: next
      }
    };
    setAttributes({
      style: utils_cleanEmptyObject(newStyle)
    });
  };

  return external_wp_element_namespaceObject.Platform.select({
    web: (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (!spacingSizes || (spacingSizes === null || spacingSizes === void 0 ? void 0 : spacingSizes.length) === 0) && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalBoxControl, {
      values: style === null || style === void 0 ? void 0 : (_style$spacing = style.spacing) === null || _style$spacing === void 0 ? void 0 : _style$spacing.margin,
      onChange: onChange,
      label: (0,external_wp_i18n_namespaceObject.__)('Margin'),
      sides: sides,
      units: units,
      allowReset: false,
      splitOnAxis: splitOnAxis,
      onMouseOver: onMouseOver,
      onMouseOut: onMouseOut
    }), (spacingSizes === null || spacingSizes === void 0 ? void 0 : spacingSizes.length) > 0 && (0,external_wp_element_namespaceObject.createElement)(SpacingSizesControl, {
      values: style === null || style === void 0 ? void 0 : (_style$spacing2 = style.spacing) === null || _style$spacing2 === void 0 ? void 0 : _style$spacing2.margin,
      onChange: onChange,
      label: (0,external_wp_i18n_namespaceObject.__)('Margin'),
      sides: sides,
      units: units,
      allowReset: false,
      splitOnAxis: false,
      onMouseOver: onMouseOver,
      onMouseOut: onMouseOut
    })),
    native: null
  });
}
function MarginVisualizer(_ref2) {
  var _attributes$style, _attributes$style$spa;

  let {
    clientId,
    attributes,
    forceShow
  } = _ref2;
  const margin = attributes === null || attributes === void 0 ? void 0 : (_attributes$style = attributes.style) === null || _attributes$style === void 0 ? void 0 : (_attributes$style$spa = _attributes$style.spacing) === null || _attributes$style$spa === void 0 ? void 0 : _attributes$style$spa.margin;
  const style = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const marginTop = margin !== null && margin !== void 0 && margin.top ? getSpacingPresetCssVar(margin === null || margin === void 0 ? void 0 : margin.top) : 0;
    const marginRight = margin !== null && margin !== void 0 && margin.right ? getSpacingPresetCssVar(margin === null || margin === void 0 ? void 0 : margin.right) : 0;
    const marginBottom = margin !== null && margin !== void 0 && margin.bottom ? getSpacingPresetCssVar(margin === null || margin === void 0 ? void 0 : margin.bottom) : 0;
    const marginLeft = margin !== null && margin !== void 0 && margin.left ? getSpacingPresetCssVar(margin === null || margin === void 0 ? void 0 : margin.left) : 0;
    return {
      borderTopWidth: marginTop,
      borderRightWidth: marginRight,
      borderBottomWidth: marginBottom,
      borderLeftWidth: marginLeft,
      top: marginTop ? `calc(${marginTop} * -1)` : 0,
      right: marginRight ? `calc(${marginRight} * -1)` : 0,
      bottom: marginBottom ? `calc(${marginBottom} * -1)` : 0,
      left: marginLeft ? `calc(${marginLeft} * -1)` : 0
    };
  }, [margin]);
  const [isActive, setIsActive] = (0,external_wp_element_namespaceObject.useState)(false);
  const valueRef = (0,external_wp_element_namespaceObject.useRef)(margin);
  const timeoutRef = (0,external_wp_element_namespaceObject.useRef)();

  const clearTimer = () => {
    if (timeoutRef.current) {
      window.clearTimeout(timeoutRef.current);
    }
  };

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!external_wp_isShallowEqual_default()(margin, valueRef.current) && !forceShow) {
      setIsActive(true);
      valueRef.current = margin;
      timeoutRef.current = setTimeout(() => {
        setIsActive(false);
      }, 400);
    }

    return () => {
      setIsActive(false);
      clearTimer();
    };
  }, [margin, forceShow]);

  if (!isActive && !forceShow) {
    return null;
  }

  return (0,external_wp_element_namespaceObject.createElement)(block_popover, {
    clientId: clientId,
    __unstableCoverTarget: true,
    __unstableRefreshSize: margin,
    __unstablePopoverSlot: "block-toolbar",
    shift: false
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor__padding-visualizer",
    style: style
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/height-control/index.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


const RANGE_CONTROL_CUSTOM_SETTINGS = {
  px: {
    max: 1000,
    step: 1
  },
  '%': {
    max: 100,
    step: 1
  },
  vw: {
    max: 100,
    step: 1
  },
  vh: {
    max: 100,
    step: 1
  },
  em: {
    max: 50,
    step: 0.1
  },
  rem: {
    max: 50,
    step: 0.1
  }
};
/**
 * HeightControl renders a linked unit control and range control for adjusting the height of a block.
 *
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/height-control/README.md
 *
 * @param {Object}                     props
 * @param {?string}                    props.label    A label for the control.
 * @param {( value: string ) => void } props.onChange Called when the height changes.
 * @param {string}                     props.value    The current height value.
 *
 * @return {WPComponent} The component to be rendered.
 */

function HeightControl(_ref) {
  var _units$, _RANGE_CONTROL_CUSTOM, _RANGE_CONTROL_CUSTOM2, _RANGE_CONTROL_CUSTOM3, _RANGE_CONTROL_CUSTOM4;

  let {
    label = (0,external_wp_i18n_namespaceObject.__)('Height'),
    onChange,
    value
  } = _ref;
  const customRangeValue = parseFloat(value);
  const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
    availableUnits: useSetting('spacing.units') || ['%', 'px', 'em', 'rem', 'vh', 'vw']
  });
  const selectedUnit = (0,external_wp_element_namespaceObject.useMemo)(() => (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(value), [value])[1] || ((_units$ = units[0]) === null || _units$ === void 0 ? void 0 : _units$.value) || 'px';

  const handleSliderChange = next => {
    onChange([next, selectedUnit].join(''));
  };

  const handleUnitChange = newUnit => {
    // Attempt to smooth over differences between currentUnit and newUnit.
    // This should slightly improve the experience of switching between unit types.
    const [currentValue, currentUnit] = (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(value);

    if (['em', 'rem'].includes(newUnit) && currentUnit === 'px') {
      // Convert pixel value to an approximate of the new unit, assuming a root size of 16px.
      onChange((currentValue / 16).toFixed(2) + newUnit);
    } else if (['em', 'rem'].includes(currentUnit) && newUnit === 'px') {
      // Convert to pixel value assuming a root size of 16px.
      onChange(Math.round(currentValue * 16) + newUnit);
    } else if (['vh', 'vw', '%'].includes(newUnit) && currentValue > 100) {
      // When converting to `vh`, `vw`, or `%` units, cap the new value at 100.
      onChange(100 + newUnit);
    }
  };

  return (0,external_wp_element_namespaceObject.createElement)("fieldset", {
    className: "block-editor-height-control"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.BaseControl.VisualLabel, {
    as: "legend"
  }, label), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Flex, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.FlexItem, {
    isBlock: true
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalUnitControl, {
    value: value,
    units: units,
    onChange: onChange,
    onUnitChange: handleUnitChange,
    min: 0,
    size: '__unstable-large'
  })), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.FlexItem, {
    isBlock: true
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalSpacer, {
    marginX: 2,
    marginBottom: 0
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.RangeControl, {
    value: customRangeValue,
    min: 0,
    max: (_RANGE_CONTROL_CUSTOM = (_RANGE_CONTROL_CUSTOM2 = RANGE_CONTROL_CUSTOM_SETTINGS[selectedUnit]) === null || _RANGE_CONTROL_CUSTOM2 === void 0 ? void 0 : _RANGE_CONTROL_CUSTOM2.max) !== null && _RANGE_CONTROL_CUSTOM !== void 0 ? _RANGE_CONTROL_CUSTOM : 100,
    step: (_RANGE_CONTROL_CUSTOM3 = (_RANGE_CONTROL_CUSTOM4 = RANGE_CONTROL_CUSTOM_SETTINGS[selectedUnit]) === null || _RANGE_CONTROL_CUSTOM4 === void 0 ? void 0 : _RANGE_CONTROL_CUSTOM4.step) !== null && _RANGE_CONTROL_CUSTOM3 !== void 0 ? _RANGE_CONTROL_CUSTOM3 : 0.1,
    withInputField: false,
    onChange: handleSliderChange,
    __nextHasNoMarginBottom: true
  })))));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/min-height.js


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





/**
 * Determines if there is minHeight support.
 *
 * @param {string|Object} blockType Block name or Block Type object.
 * @return {boolean} Whether there is support.
 */

function hasMinHeightSupport(blockType) {
  const support = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, DIMENSIONS_SUPPORT_KEY);
  return !!(true === support || support !== null && support !== void 0 && support.minHeight);
}
/**
 * Checks if there is a current value in the minHeight block support attributes.
 *
 * @param {Object} props Block props.
 * @return {boolean} Whether or not the block has a minHeight value set.
 */

function hasMinHeightValue(props) {
  var _props$attributes$sty, _props$attributes$sty2;

  return ((_props$attributes$sty = props.attributes.style) === null || _props$attributes$sty === void 0 ? void 0 : (_props$attributes$sty2 = _props$attributes$sty.dimensions) === null || _props$attributes$sty2 === void 0 ? void 0 : _props$attributes$sty2.minHeight) !== undefined;
}
/**
 * Resets the minHeight block support attributes. This can be used when disabling
 * the padding support controls for a block via a `ToolsPanel`.
 *
 * @param {Object} props               Block props.
 * @param {Object} props.attributes    Block's attributes.
 * @param {Object} props.setAttributes Function to set block's attributes.
 */

function resetMinHeight(_ref) {
  let {
    attributes = {},
    setAttributes
  } = _ref;
  const {
    style
  } = attributes;
  setAttributes({
    style: utils_cleanEmptyObject({ ...style,
      dimensions: { ...(style === null || style === void 0 ? void 0 : style.dimensions),
        minHeight: undefined
      }
    })
  });
}
/**
 * Custom hook that checks if minHeight controls have been disabled.
 *
 * @param {string} name The name of the block.
 * @return {boolean} Whether minHeight control is disabled.
 */

function useIsMinHeightDisabled() {
  let {
    name: blockName
  } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  const isDisabled = !useSetting('dimensions.minHeight');
  return !hasMinHeightSupport(blockName) || isDisabled;
}
/**
 * Inspector control panel containing the minHeight related configuration.
 *
 * @param {Object} props Block props.
 * @return {WPElement} Edit component for height.
 */

function MinHeightEdit(props) {
  var _style$dimensions;

  const {
    attributes: {
      style
    },
    setAttributes
  } = props;

  if (useIsMinHeightDisabled(props)) {
    return null;
  }

  const onChange = next => {
    const newStyle = { ...style,
      dimensions: { ...(style === null || style === void 0 ? void 0 : style.dimensions),
        minHeight: next
      }
    };
    setAttributes({
      style: utils_cleanEmptyObject(newStyle)
    });
  };

  return (0,external_wp_element_namespaceObject.createElement)(HeightControl, {
    label: (0,external_wp_i18n_namespaceObject.__)('Min. height'),
    value: style === null || style === void 0 ? void 0 : (_style$dimensions = style.dimensions) === null || _style$dimensions === void 0 ? void 0 : _style$dimensions.minHeight,
    onChange: onChange
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/padding.js


/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */







/**
 * Determines if there is padding support.
 *
 * @param {string|Object} blockType Block name or Block Type object.
 *
 * @return {boolean} Whether there is support.
 */

function hasPaddingSupport(blockType) {
  const support = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, SPACING_SUPPORT_KEY);
  return !!(true === support || support !== null && support !== void 0 && support.padding);
}
/**
 * Checks if there is a current value in the padding block support attributes.
 *
 * @param {Object} props Block props.
 * @return {boolean}      Whether or not the block has a padding value set.
 */

function hasPaddingValue(props) {
  var _props$attributes$sty, _props$attributes$sty2;

  return ((_props$attributes$sty = props.attributes.style) === null || _props$attributes$sty === void 0 ? void 0 : (_props$attributes$sty2 = _props$attributes$sty.spacing) === null || _props$attributes$sty2 === void 0 ? void 0 : _props$attributes$sty2.padding) !== undefined;
}
/**
 * Resets the padding block support attributes. This can be used when disabling
 * the padding support controls for a block via a `ToolsPanel`.
 *
 * @param {Object} props               Block props.
 * @param {Object} props.attributes    Block's attributes.
 * @param {Object} props.setAttributes Function to set block's attributes.
 */

function resetPadding(_ref) {
  let {
    attributes = {},
    setAttributes
  } = _ref;
  const {
    style
  } = attributes;
  setAttributes({
    style: utils_cleanEmptyObject({ ...style,
      spacing: { ...(style === null || style === void 0 ? void 0 : style.spacing),
        padding: undefined
      }
    })
  });
}
/**
 * Custom hook that checks if padding settings have been disabled.
 *
 * @param {string} name The name of the block.
 *
 * @return {boolean} Whether padding setting is disabled.
 */

function useIsPaddingDisabled() {
  let {
    name: blockName
  } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  const isDisabled = !useSetting('spacing.padding');
  const isInvalid = !useIsDimensionsSupportValid(blockName, 'padding');
  return !hasPaddingSupport(blockName) || isDisabled || isInvalid;
}
/**
 * Inspector control panel containing the padding related configuration
 *
 * @param {Object} props
 *
 * @return {WPElement} Padding edit element.
 */

function PaddingEdit(props) {
  var _style$spacing, _style$spacing2;

  const {
    name: blockName,
    attributes: {
      style
    },
    setAttributes,
    onMouseOver,
    onMouseOut
  } = props;
  const spacingSizes = useSetting('spacing.spacingSizes');
  const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
    availableUnits: useSetting('spacing.units') || ['%', 'px', 'em', 'rem', 'vw']
  });
  const sides = useCustomSides(blockName, 'padding');
  const splitOnAxis = sides && sides.some(side => AXIAL_SIDES.includes(side));

  if (useIsPaddingDisabled(props)) {
    return null;
  }

  const onChange = next => {
    const newStyle = { ...style,
      spacing: { ...(style === null || style === void 0 ? void 0 : style.spacing),
        padding: next
      }
    };
    setAttributes({
      style: utils_cleanEmptyObject(newStyle)
    });
  };

  return external_wp_element_namespaceObject.Platform.select({
    web: (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (!spacingSizes || (spacingSizes === null || spacingSizes === void 0 ? void 0 : spacingSizes.length) === 0) && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalBoxControl, {
      values: style === null || style === void 0 ? void 0 : (_style$spacing = style.spacing) === null || _style$spacing === void 0 ? void 0 : _style$spacing.padding,
      onChange: onChange,
      label: (0,external_wp_i18n_namespaceObject.__)('Padding'),
      sides: sides,
      units: units,
      allowReset: false,
      splitOnAxis: splitOnAxis,
      onMouseOver: onMouseOver,
      onMouseOut: onMouseOut
    }), (spacingSizes === null || spacingSizes === void 0 ? void 0 : spacingSizes.length) > 0 && (0,external_wp_element_namespaceObject.createElement)(SpacingSizesControl, {
      values: style === null || style === void 0 ? void 0 : (_style$spacing2 = style.spacing) === null || _style$spacing2 === void 0 ? void 0 : _style$spacing2.padding,
      onChange: onChange,
      label: (0,external_wp_i18n_namespaceObject.__)('Padding'),
      sides: sides,
      units: units,
      allowReset: false,
      splitOnAxis: splitOnAxis,
      onMouseOver: onMouseOver,
      onMouseOut: onMouseOut
    })),
    native: null
  });
}
function PaddingVisualizer(_ref2) {
  var _attributes$style, _attributes$style$spa;

  let {
    clientId,
    attributes,
    forceShow
  } = _ref2;
  const padding = attributes === null || attributes === void 0 ? void 0 : (_attributes$style = attributes.style) === null || _attributes$style === void 0 ? void 0 : (_attributes$style$spa = _attributes$style.spacing) === null || _attributes$style$spa === void 0 ? void 0 : _attributes$style$spa.padding;
  const style = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return {
      borderTopWidth: padding !== null && padding !== void 0 && padding.top ? getSpacingPresetCssVar(padding === null || padding === void 0 ? void 0 : padding.top) : 0,
      borderRightWidth: padding !== null && padding !== void 0 && padding.right ? getSpacingPresetCssVar(padding === null || padding === void 0 ? void 0 : padding.right) : 0,
      borderBottomWidth: padding !== null && padding !== void 0 && padding.bottom ? getSpacingPresetCssVar(padding === null || padding === void 0 ? void 0 : padding.bottom) : 0,
      borderLeftWidth: padding !== null && padding !== void 0 && padding.left ? getSpacingPresetCssVar(padding === null || padding === void 0 ? void 0 : padding.left) : 0
    };
  }, [padding]);
  const [isActive, setIsActive] = (0,external_wp_element_namespaceObject.useState)(false);
  const valueRef = (0,external_wp_element_namespaceObject.useRef)(padding);
  const timeoutRef = (0,external_wp_element_namespaceObject.useRef)();

  const clearTimer = () => {
    if (timeoutRef.current) {
      window.clearTimeout(timeoutRef.current);
    }
  };

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!external_wp_isShallowEqual_default()(padding, valueRef.current) && !forceShow) {
      setIsActive(true);
      valueRef.current = padding;
      timeoutRef.current = setTimeout(() => {
        setIsActive(false);
      }, 400);
    }

    return () => {
      setIsActive(false);
      clearTimer();
    };
  }, [padding, forceShow]);

  if (!isActive && !forceShow) {
    return null;
  }

  return (0,external_wp_element_namespaceObject.createElement)(block_popover, {
    clientId: clientId,
    __unstableCoverTarget: true,
    __unstableRefreshSize: padding,
    __unstablePopoverSlot: "block-toolbar",
    shift: false
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor__padding-visualizer",
    style: style
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/child-layout.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function helpText(selfStretch, parentLayout) {
  const {
    orientation = 'horizontal'
  } = parentLayout;

  if (selfStretch === 'fill') {
    return (0,external_wp_i18n_namespaceObject.__)('Stretch to fill available space.');
  }

  if (selfStretch === 'fixed') {
    if (orientation === 'horizontal') {
      return (0,external_wp_i18n_namespaceObject.__)('Specify a fixed width.');
    }

    return (0,external_wp_i18n_namespaceObject.__)('Specify a fixed height.');
  }

  return (0,external_wp_i18n_namespaceObject.__)('Fit contents.');
}
/**
 * Inspector controls containing the child layout related configuration.
 *
 * @param {Object} props                        Block props.
 * @param {Object} props.attributes             Block attributes.
 * @param {Object} props.setAttributes          Function to set block attributes.
 * @param {Object} props.__unstableParentLayout
 *
 * @return {WPElement} child layout edit element.
 */


function ChildLayoutEdit(_ref) {
  let {
    attributes,
    setAttributes,
    __unstableParentLayout: parentLayout
  } = _ref;
  const {
    style = {}
  } = attributes;
  const {
    layout: childLayout = {}
  } = style;
  const {
    selfStretch,
    flexSize
  } = childLayout;
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (selfStretch === 'fixed' && !flexSize) {
      setAttributes({
        style: { ...style,
          layout: { ...childLayout,
            selfStretch: 'fit'
          }
        }
      });
    }
  }, []);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToggleGroupControl, {
    __nextHasNoMarginBottom: true,
    size: '__unstable-large',
    label: childLayoutOrientation(parentLayout),
    value: selfStretch || 'fit',
    help: helpText(selfStretch, parentLayout),
    onChange: value => {
      const newFlexSize = value !== 'fixed' ? null : flexSize;
      setAttributes({
        style: { ...style,
          layout: { ...childLayout,
            selfStretch: value,
            flexSize: newFlexSize
          }
        }
      });
    },
    isBlock: true
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOption, {
    key: 'fit',
    value: 'fit',
    label: (0,external_wp_i18n_namespaceObject.__)('Fit')
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOption, {
    key: 'fill',
    value: 'fill',
    label: (0,external_wp_i18n_namespaceObject.__)('Fill')
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOption, {
    key: 'fixed',
    value: 'fixed',
    label: (0,external_wp_i18n_namespaceObject.__)('Fixed')
  })), selfStretch === 'fixed' && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalUnitControl, {
    size: '__unstable-large',
    onChange: value => {
      setAttributes({
        style: { ...style,
          layout: { ...childLayout,
            flexSize: value
          }
        }
      });
    },
    value: flexSize
  }));
}
/**
 * Determines if there is child layout support.
 *
 * @param {Object} props                        Block Props object.
 * @param {Object} props.__unstableParentLayout Parent layout.
 *
 * @return {boolean}     Whether there is support.
 */

function hasChildLayoutSupport(_ref2) {
  let {
    __unstableParentLayout: parentLayout = {}
  } = _ref2;
  const {
    type: parentLayoutType = 'default',
    default: {
      type: defaultParentLayoutType = 'default'
    } = {},
    allowSizingOnChildren = false
  } = parentLayout;
  const support = (defaultParentLayoutType === 'flex' || parentLayoutType === 'flex') && allowSizingOnChildren;
  return support;
}
/**
 * Checks if there is a current value in the child layout attributes.
 *
 * @param {Object} props Block props.
 * @return {boolean}      Whether or not the block has a child layout value set.
 */

function hasChildLayoutValue(props) {
  var _props$attributes$sty;

  return ((_props$attributes$sty = props.attributes.style) === null || _props$attributes$sty === void 0 ? void 0 : _props$attributes$sty.layout) !== undefined;
}
/**
 * Resets the child layout attribute. This can be used when disabling
 * child layout controls for a block via a progressive discovery panel.
 *
 * @param {Object} props               Block props.
 * @param {Object} props.attributes    Block attributes.
 * @param {Object} props.setAttributes Function to set block attributes.
 */

function resetChildLayout(_ref3) {
  let {
    attributes = {},
    setAttributes
  } = _ref3;
  const {
    style
  } = attributes;
  setAttributes({
    style: { ...style,
      layout: undefined
    }
  });
}
/**
 * Custom hook that checks if child layout settings have been disabled.
 *
 * @param {Object} props Block props.
 *
 * @return {boolean}     Whether the child layout setting is disabled.
 */

function useIsChildLayoutDisabled(props) {
  const isDisabled = !useSetting('layout');
  return !hasChildLayoutSupport(props) || isDisabled;
}
function childLayoutOrientation(parentLayout) {
  const {
    orientation = 'horizontal'
  } = parentLayout;
  return orientation === 'horizontal' ? (0,external_wp_i18n_namespaceObject.__)('Width') : (0,external_wp_i18n_namespaceObject.__)('Height');
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/dimensions.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */










const DIMENSIONS_SUPPORT_KEY = 'dimensions';
const SPACING_SUPPORT_KEY = 'spacing';
const dimensions_ALL_SIDES = ['top', 'right', 'bottom', 'left'];
const AXIAL_SIDES = ['vertical', 'horizontal'];

function useVisualizerMouseOver() {
  const [isMouseOver, setIsMouseOver] = (0,external_wp_element_namespaceObject.useState)(false);
  const {
    hideBlockInterface,
    showBlockInterface
  } = unlock((0,external_wp_data_namespaceObject.useDispatch)(store));

  const onMouseOver = e => {
    e.stopPropagation();
    hideBlockInterface();
    setIsMouseOver(true);
  };

  const onMouseOut = e => {
    e.stopPropagation();
    showBlockInterface();
    setIsMouseOver(false);
  };

  return {
    isMouseOver,
    onMouseOver,
    onMouseOut
  };
}
/**
 * Inspector controls for dimensions support.
 *
 * @param {Object} props Block props.
 *
 * @return {WPElement} Inspector controls for dimensions and spacing support features.
 */


function DimensionsPanel(props) {
  const isGapDisabled = useIsGapDisabled(props);
  const isPaddingDisabled = useIsPaddingDisabled(props);
  const isMarginDisabled = useIsMarginDisabled(props);
  const isMinHeightDisabled = useIsMinHeightDisabled(props);
  const isChildLayoutDisabled = useIsChildLayoutDisabled(props);
  const isDisabled = useIsDimensionsDisabled(props);
  const isSupported = hasDimensionsSupport(props);
  const spacingSizes = useSetting('spacing.spacingSizes');
  const paddingMouseOver = useVisualizerMouseOver();
  const marginMouseOver = useVisualizerMouseOver();

  if (isDisabled || !isSupported) {
    return null;
  }

  const defaultDimensionsControls = (0,external_wp_blocks_namespaceObject.getBlockSupport)(props.name, [DIMENSIONS_SUPPORT_KEY, '__experimentalDefaultControls']);
  const defaultSpacingControls = (0,external_wp_blocks_namespaceObject.getBlockSupport)(props.name, [SPACING_SUPPORT_KEY, '__experimentalDefaultControls']);

  const createResetAllFilter = (attribute, featureSet) => newAttributes => {
    var _newAttributes$style;

    return { ...newAttributes,
      style: { ...newAttributes.style,
        [featureSet]: { ...((_newAttributes$style = newAttributes.style) === null || _newAttributes$style === void 0 ? void 0 : _newAttributes$style[featureSet]),
          [attribute]: undefined
        }
      }
    };
  };

  const spacingClassnames = classnames_default()({
    'tools-panel-item-spacing': spacingSizes && spacingSizes.length > 0
  });
  const {
    __unstableParentLayout: parentLayout
  } = props;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(inspector_controls, {
    group: "dimensions"
  }, !isPaddingDisabled && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
    className: spacingClassnames,
    hasValue: () => hasPaddingValue(props),
    label: (0,external_wp_i18n_namespaceObject.__)('Padding'),
    onDeselect: () => resetPadding(props),
    resetAllFilter: createResetAllFilter('padding', 'spacing'),
    isShownByDefault: defaultSpacingControls === null || defaultSpacingControls === void 0 ? void 0 : defaultSpacingControls.padding,
    panelId: props.clientId
  }, (0,external_wp_element_namespaceObject.createElement)(PaddingEdit, _extends({
    onMouseOver: paddingMouseOver.onMouseOver,
    onMouseOut: paddingMouseOver.onMouseOut
  }, props))), !isMarginDisabled && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
    className: spacingClassnames,
    hasValue: () => hasMarginValue(props),
    label: (0,external_wp_i18n_namespaceObject.__)('Margin'),
    onDeselect: () => resetMargin(props),
    resetAllFilter: createResetAllFilter('margin', 'spacing'),
    isShownByDefault: defaultSpacingControls === null || defaultSpacingControls === void 0 ? void 0 : defaultSpacingControls.margin,
    panelId: props.clientId
  }, (0,external_wp_element_namespaceObject.createElement)(MarginEdit, _extends({
    onMouseOver: marginMouseOver.onMouseOver,
    onMouseOut: marginMouseOver.onMouseOut
  }, props))), !isGapDisabled && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
    className: spacingClassnames,
    hasValue: () => hasGapValue(props),
    label: (0,external_wp_i18n_namespaceObject.__)('Block spacing'),
    onDeselect: () => resetGap(props),
    resetAllFilter: createResetAllFilter('blockGap', 'spacing'),
    isShownByDefault: defaultSpacingControls === null || defaultSpacingControls === void 0 ? void 0 : defaultSpacingControls.blockGap,
    panelId: props.clientId
  }, (0,external_wp_element_namespaceObject.createElement)(GapEdit, props)), !isMinHeightDisabled && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
    hasValue: () => hasMinHeightValue(props),
    label: (0,external_wp_i18n_namespaceObject.__)('Min. height'),
    onDeselect: () => resetMinHeight(props),
    resetAllFilter: createResetAllFilter('minHeight', 'dimensions'),
    isShownByDefault: defaultDimensionsControls === null || defaultDimensionsControls === void 0 ? void 0 : defaultDimensionsControls.minHeight,
    panelId: props.clientId
  }, (0,external_wp_element_namespaceObject.createElement)(MinHeightEdit, props)), !isChildLayoutDisabled && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalVStack, {
    as: external_wp_components_namespaceObject.__experimentalToolsPanelItem,
    spacing: 2,
    hasValue: () => hasChildLayoutValue(props),
    label: childLayoutOrientation(parentLayout),
    onDeselect: () => resetChildLayout(props),
    resetAllFilter: createResetAllFilter('selfStretch', 'layout'),
    isShownByDefault: false,
    panelId: props.clientId
  }, (0,external_wp_element_namespaceObject.createElement)(ChildLayoutEdit, props))), !isPaddingDisabled && (0,external_wp_element_namespaceObject.createElement)(PaddingVisualizer, _extends({
    forceShow: paddingMouseOver.isMouseOver
  }, props)), !isMarginDisabled && (0,external_wp_element_namespaceObject.createElement)(MarginVisualizer, _extends({
    forceShow: marginMouseOver.isMouseOver
  }, props)));
}
/**
 * Determine whether there is dimensions related block support.
 *
 * @param {Object} props Block props.
 *
 * @return {boolean} Whether there is support.
 */

function hasDimensionsSupport(props) {
  if (external_wp_element_namespaceObject.Platform.OS !== 'web') {
    return false;
  }

  const {
    name: blockName
  } = props;
  return hasGapSupport(blockName) || hasMinHeightSupport(blockName) || hasPaddingSupport(blockName) || hasMarginSupport(blockName) || hasChildLayoutSupport(props);
}
/**
 * Determines whether dimensions support has been disabled.
 *
 * @param {Object} props Block properties.
 *
 * @return {boolean} If spacing support is completely disabled.
 */

const useIsDimensionsDisabled = function () {
  let props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  const gapDisabled = useIsGapDisabled(props);
  const minHeightDisabled = useIsMinHeightDisabled(props);
  const paddingDisabled = useIsPaddingDisabled(props);
  const marginDisabled = useIsMarginDisabled(props);
  const childLayoutDisabled = useIsChildLayoutDisabled(props);
  return gapDisabled && minHeightDisabled && paddingDisabled && marginDisabled && childLayoutDisabled;
};
/**
 * Custom hook to retrieve which padding/margin/blockGap is supported
 * e.g. top, right, bottom or left.
 *
 * Sides are opted into by default. It is only if a specific side is set to
 * false that it is omitted.
 *
 * @param {string} blockName Block name.
 * @param {string} feature   The feature custom sides relate to e.g. padding or margins.
 *
 * @return {string[] | undefined} Strings representing the custom sides available.
 */


function useCustomSides(blockName, feature) {
  var _support$feature;

  const support = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockName, SPACING_SUPPORT_KEY); // Skip when setting is boolean as theme isn't setting arbitrary sides.

  if (!support || typeof support[feature] === 'boolean') {
    return;
  } // Return if the setting is an array of sides (e.g. `[ 'top', 'bottom' ]`).


  if (Array.isArray(support[feature])) {
    return support[feature];
  } // Finally, attempt to return `.sides` if the setting is an object.


  if ((_support$feature = support[feature]) !== null && _support$feature !== void 0 && _support$feature.sides) {
    return support[feature].sides;
  }
}
/**
 * Custom hook to determine whether the sides configured in the
 * block support are valid. A dimension property cannot declare
 * support for a mix of axial and individual sides.
 *
 * @param {string} blockName Block name.
 * @param {string} feature   The feature custom sides relate to e.g. padding or margins.
 *
 * @return {boolean} If the feature has a valid configuration of sides.
 */

function useIsDimensionsSupportValid(blockName, feature) {
  const sides = useCustomSides(blockName, feature);

  if (sides && sides.some(side => dimensions_ALL_SIDES.includes(side)) && sides.some(side => AXIAL_SIDES.includes(side))) {
    // eslint-disable-next-line no-console
    console.warn(`The ${feature} support for the "${blockName}" block can not be configured to support both axial and arbitrary sides.`);
    return false;
  }

  return true;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/gap.js


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */







/**
 * Determines if there is gap support.
 *
 * @param {string|Object} blockType Block name or Block Type object.
 * @return {boolean}                Whether there is support.
 */

function hasGapSupport(blockType) {
  const support = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, SPACING_SUPPORT_KEY);
  return !!(true === support || support !== null && support !== void 0 && support.blockGap);
}
/**
 * Checks if there is a current value in the gap block support attributes.
 *
 * @param {Object} props Block props.
 * @return {boolean}      Whether or not the block has a gap value set.
 */

function hasGapValue(props) {
  var _props$attributes$sty, _props$attributes$sty2;

  return ((_props$attributes$sty = props.attributes.style) === null || _props$attributes$sty === void 0 ? void 0 : (_props$attributes$sty2 = _props$attributes$sty.spacing) === null || _props$attributes$sty2 === void 0 ? void 0 : _props$attributes$sty2.blockGap) !== undefined;
}
/**
 * Returns a BoxControl object value from a given blockGap style value.
 * The string check is for backwards compatibility before Gutenberg supported
 * split gap values (row and column) and the value was a string n + unit.
 *
 * @param {string? | Object?} blockGapValue A block gap string or axial object value, e.g., '10px' or { top: '10px', left: '10px'}.
 * @return {Object|null}                    A value to pass to the BoxControl component.
 */

function getGapBoxControlValueFromStyle(blockGapValue) {
  if (!blockGapValue) {
    return null;
  }

  const isValueString = typeof blockGapValue === 'string';
  return {
    top: isValueString ? blockGapValue : blockGapValue === null || blockGapValue === void 0 ? void 0 : blockGapValue.top,
    left: isValueString ? blockGapValue : blockGapValue === null || blockGapValue === void 0 ? void 0 : blockGapValue.left
  };
}
/**
 * Returns a CSS value for the `gap` property from a given blockGap style.
 *
 * @param {string? | Object?} blockGapValue A block gap string or axial object value, e.g., '10px' or { top: '10px', left: '10px'}.
 * @param {string?}           defaultValue  A default gap value.
 * @return {string|null}                    The concatenated gap value (row and column).
 */

function getGapCSSValue(blockGapValue) {
  let defaultValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '0';
  const blockGapBoxControlValue = getGapBoxControlValueFromStyle(blockGapValue);

  if (!blockGapBoxControlValue) {
    return null;
  }

  const row = getSpacingPresetCssVar(blockGapBoxControlValue === null || blockGapBoxControlValue === void 0 ? void 0 : blockGapBoxControlValue.top) || defaultValue;
  const column = getSpacingPresetCssVar(blockGapBoxControlValue === null || blockGapBoxControlValue === void 0 ? void 0 : blockGapBoxControlValue.left) || defaultValue;
  return row === column ? row : `${row} ${column}`;
}
/**
 * Resets the gap block support attribute. This can be used when disabling
 * the gap support controls for a block via a progressive discovery panel.
 *
 * @param {Object} props               Block props.
 * @param {Object} props.attributes    Block's attributes.
 * @param {Object} props.setAttributes Function to set block's attributes.
 */

function resetGap(_ref) {
  let {
    attributes = {},
    setAttributes
  } = _ref;
  const {
    style
  } = attributes;
  setAttributes({
    style: { ...style,
      spacing: { ...(style === null || style === void 0 ? void 0 : style.spacing),
        blockGap: undefined
      }
    }
  });
}
/**
 * Custom hook that checks if gap settings have been disabled.
 *
 * @param {string} name The name of the block.
 * @return {boolean}     Whether the gap setting is disabled.
 */

function useIsGapDisabled() {
  let {
    name: blockName
  } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  const isDisabled = !useSetting('spacing.blockGap');
  return !hasGapSupport(blockName) || isDisabled;
}
/**
 * Inspector control panel containing the gap related configuration
 *
 * @param {Object} props
 *
 * @return {WPElement} Gap edit element.
 */

function GapEdit(props) {
  var _style$spacing;

  const {
    clientId,
    attributes: {
      style
    },
    name: blockName,
    setAttributes
  } = props;
  const spacingSizes = useSetting('spacing.spacingSizes');
  const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
    availableUnits: useSetting('spacing.units') || ['%', 'px', 'em', 'rem', 'vw']
  });
  const sides = useCustomSides(blockName, 'blockGap');
  const ref = useBlockRef(clientId);

  if (useIsGapDisabled(props)) {
    return null;
  }

  const splitOnAxis = sides && sides.some(side => AXIAL_SIDES.includes(side));

  const onChange = next => {
    var _window;

    let blockGap = next; // If splitOnAxis activated we need to return a BoxControl object to the BoxControl component.

    if (!!next && splitOnAxis) {
      blockGap = { ...getGapBoxControlValueFromStyle(next)
      };
    } else if (next !== null && next !== void 0 && next.hasOwnProperty('top')) {
      // If splitOnAxis is not enabled, treat the 'top' value as the shorthand gap value.
      blockGap = next.top;
    }

    const newStyle = { ...style,
      spacing: { ...(style === null || style === void 0 ? void 0 : style.spacing),
        blockGap
      }
    };
    setAttributes({
      style: utils_cleanEmptyObject(newStyle)
    }); // In Safari, changing the `gap` CSS value on its own will not trigger the layout
    // to be recalculated / re-rendered. To force the updated gap to re-render, here
    // we replace the block's node with itself.

    const isSafari = ((_window = window) === null || _window === void 0 ? void 0 : _window.navigator.userAgent) && window.navigator.userAgent.includes('Safari') && !window.navigator.userAgent.includes('Chrome ') && !window.navigator.userAgent.includes('Chromium ');

    if (ref.current && isSafari) {
      var _ref$current$parentNo;

      (_ref$current$parentNo = ref.current.parentNode) === null || _ref$current$parentNo === void 0 ? void 0 : _ref$current$parentNo.replaceChild(ref.current, ref.current);
    }
  };

  const gapValue = getGapBoxControlValueFromStyle(style === null || style === void 0 ? void 0 : (_style$spacing = style.spacing) === null || _style$spacing === void 0 ? void 0 : _style$spacing.blockGap); // The BoxControl component expects a full complement of side values.
  // Gap row and column values translate to top/bottom and left/right respectively.

  const boxControlGapValue = splitOnAxis ? { ...gapValue,
    right: gapValue === null || gapValue === void 0 ? void 0 : gapValue.left,
    bottom: gapValue === null || gapValue === void 0 ? void 0 : gapValue.top
  } : {
    top: gapValue === null || gapValue === void 0 ? void 0 : gapValue.top
  };
  return external_wp_element_namespaceObject.Platform.select({
    web: (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (!spacingSizes || (spacingSizes === null || spacingSizes === void 0 ? void 0 : spacingSizes.length) === 0) && (splitOnAxis ? (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalBoxControl, {
      label: (0,external_wp_i18n_namespaceObject.__)('Block spacing'),
      min: 0,
      onChange: onChange,
      units: units,
      sides: sides,
      values: boxControlGapValue,
      allowReset: false,
      splitOnAxis: splitOnAxis
    }) : (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalUnitControl, {
      label: (0,external_wp_i18n_namespaceObject.__)('Block spacing'),
      __unstableInputWidth: "80px",
      min: 0,
      onChange: onChange,
      units: units // Default to `row` for combined values.
      ,
      value: boxControlGapValue
    })), (spacingSizes === null || spacingSizes === void 0 ? void 0 : spacingSizes.length) > 0 && (0,external_wp_element_namespaceObject.createElement)(SpacingSizesControl, {
      values: boxControlGapValue,
      onChange: onChange,
      label: (0,external_wp_i18n_namespaceObject.__)('Block spacing'),
      sides: splitOnAxis ? sides : ['top'] // Use 'top' as the shorthand property in non-axial configurations.
      ,
      units: units,
      allowReset: false,
      splitOnAxis: splitOnAxis
    })),
    native: null
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-vertical-alignment-control/icons.js


/**
 * WordPress dependencies
 */

const alignBottom = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "M15 4H9v11h6V4zM4 18.5V20h16v-1.5H4z"
}));
const alignCenter = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "M20 11h-5V4H9v7H4v1.5h5V20h6v-7.5h5z"
}));
const alignTop = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "M9 20h6V9H9v11zM4 4v1.5h16V4H4z"
}));
const alignStretch = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "M4 4L20 4L20 5.5L4 5.5L4 4ZM10 7L14 7L14 17L10 17L10 7ZM20 18.5L4 18.5L4 20L20 20L20 18.5Z"
}));
const spaceBetween = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Path, {
  d: "M7 4H17V8L7 8V4ZM7 16L17 16V20L7 20V16ZM20 11.25H4V12.75H20V11.25Z"
}));

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-vertical-alignment-control/ui.js



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


const BLOCK_ALIGNMENTS_CONTROLS = {
  top: {
    icon: alignTop,
    title: (0,external_wp_i18n_namespaceObject._x)('Align top', 'Block vertical alignment setting')
  },
  center: {
    icon: alignCenter,
    title: (0,external_wp_i18n_namespaceObject._x)('Align middle', 'Block vertical alignment setting')
  },
  bottom: {
    icon: alignBottom,
    title: (0,external_wp_i18n_namespaceObject._x)('Align bottom', 'Block vertical alignment setting')
  },
  stretch: {
    icon: alignStretch,
    title: (0,external_wp_i18n_namespaceObject._x)('Stretch to fill', 'Block vertical alignment setting')
  },
  'space-between': {
    icon: spaceBetween,
    title: (0,external_wp_i18n_namespaceObject._x)('Space between', 'Block vertical alignment setting')
  }
};
const DEFAULT_CONTROLS = ['top', 'center', 'bottom'];
const DEFAULT_CONTROL = 'top';

function BlockVerticalAlignmentUI(_ref) {
  let {
    value,
    onChange,
    controls = DEFAULT_CONTROLS,
    isCollapsed = true,
    isToolbar
  } = _ref;

  function applyOrUnset(align) {
    return () => onChange(value === align ? undefined : align);
  }

  const activeAlignment = BLOCK_ALIGNMENTS_CONTROLS[value];
  const defaultAlignmentControl = BLOCK_ALIGNMENTS_CONTROLS[DEFAULT_CONTROL];
  const UIComponent = isToolbar ? external_wp_components_namespaceObject.ToolbarGroup : external_wp_components_namespaceObject.ToolbarDropdownMenu;
  const extraProps = isToolbar ? {
    isCollapsed
  } : {
    popoverProps: {
      variant: 'toolbar'
    }
  };
  return (0,external_wp_element_namespaceObject.createElement)(UIComponent, _extends({
    icon: activeAlignment ? activeAlignment.icon : defaultAlignmentControl.icon,
    label: (0,external_wp_i18n_namespaceObject._x)('Change vertical alignment', 'Block vertical alignment setting label'),
    controls: controls.map(control => {
      return { ...BLOCK_ALIGNMENTS_CONTROLS[control],
        isActive: value === control,
        role: isCollapsed ? 'menuitemradio' : undefined,
        onClick: applyOrUnset(control)
      };
    })
  }, extraProps));
}
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/block-vertical-alignment-toolbar/README.md
 */


/* harmony default export */ var ui = (BlockVerticalAlignmentUI);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-vertical-alignment-control/index.js



/**
 * Internal dependencies
 */


const BlockVerticalAlignmentControl = props => {
  return (0,external_wp_element_namespaceObject.createElement)(ui, _extends({}, props, {
    isToolbar: false
  }));
};

const BlockVerticalAlignmentToolbar = props => {
  return (0,external_wp_element_namespaceObject.createElement)(ui, _extends({}, props, {
    isToolbar: true
  }));
};
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/block-vertical-alignment-control/README.md
 */




;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/justify-content-control/ui.js



/**
 * WordPress dependencies
 */



const icons = {
  left: justify_left,
  center: justify_center,
  right: justify_right,
  'space-between': justify_space_between,
  stretch: justify_stretch
};

function JustifyContentUI(_ref) {
  let {
    allowedControls = ['left', 'center', 'right', 'space-between'],
    isCollapsed = true,
    onChange,
    value,
    popoverProps,
    isToolbar
  } = _ref;

  // If the control is already selected we want a click
  // again on the control to deselect the item, so we
  // call onChange( undefined )
  const handleClick = next => {
    if (next === value) {
      onChange(undefined);
    } else {
      onChange(next);
    }
  };

  const icon = value ? icons[value] : icons.left;
  const allControls = [{
    name: 'left',
    icon: justify_left,
    title: (0,external_wp_i18n_namespaceObject.__)('Justify items left'),
    isActive: 'left' === value,
    onClick: () => handleClick('left')
  }, {
    name: 'center',
    icon: justify_center,
    title: (0,external_wp_i18n_namespaceObject.__)('Justify items center'),
    isActive: 'center' === value,
    onClick: () => handleClick('center')
  }, {
    name: 'right',
    icon: justify_right,
    title: (0,external_wp_i18n_namespaceObject.__)('Justify items right'),
    isActive: 'right' === value,
    onClick: () => handleClick('right')
  }, {
    name: 'space-between',
    icon: justify_space_between,
    title: (0,external_wp_i18n_namespaceObject.__)('Space between items'),
    isActive: 'space-between' === value,
    onClick: () => handleClick('space-between')
  }, {
    name: 'stretch',
    icon: justify_stretch,
    title: (0,external_wp_i18n_namespaceObject.__)('Stretch items'),
    isActive: 'stretch' === value,
    onClick: () => handleClick('stretch')
  }];
  const UIComponent = isToolbar ? external_wp_components_namespaceObject.ToolbarGroup : external_wp_components_namespaceObject.ToolbarDropdownMenu;
  const extraProps = isToolbar ? {
    isCollapsed
  } : {};
  return (0,external_wp_element_namespaceObject.createElement)(UIComponent, _extends({
    icon: icon,
    popoverProps: popoverProps,
    label: (0,external_wp_i18n_namespaceObject.__)('Change items justification'),
    controls: allControls.filter(elem => allowedControls.includes(elem.name))
  }, extraProps));
}

/* harmony default export */ var justify_content_control_ui = (JustifyContentUI);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/justify-content-control/index.js



/**
 * Internal dependencies
 */


const JustifyContentControl = props => {
  return (0,external_wp_element_namespaceObject.createElement)(justify_content_control_ui, _extends({}, props, {
    isToolbar: false
  }));
};

const JustifyToolbar = props => {
  return (0,external_wp_element_namespaceObject.createElement)(justify_content_control_ui, _extends({}, props, {
    isToolbar: true
  }));
};
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/justify-content-control/README.md
 */




;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/layouts/flex.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




 // Used with the default, horizontal flex orientation.

const justifyContentMap = {
  left: 'flex-start',
  right: 'flex-end',
  center: 'center',
  'space-between': 'space-between'
}; // Used with the vertical (column) flex orientation.

const alignItemsMap = {
  left: 'flex-start',
  right: 'flex-end',
  center: 'center',
  stretch: 'stretch'
};
const verticalAlignmentMap = {
  top: 'flex-start',
  center: 'center',
  bottom: 'flex-end',
  stretch: 'stretch',
  'space-between': 'space-between'
};
const flexWrapOptions = ['wrap', 'nowrap'];
/* harmony default export */ var flex = ({
  name: 'flex',
  label: (0,external_wp_i18n_namespaceObject.__)('Flex'),
  inspectorControls: function FlexLayoutInspectorControls(_ref) {
    let {
      layout = {},
      onChange,
      layoutBlockSupport = {}
    } = _ref;
    const {
      allowOrientation = true
    } = layoutBlockSupport;
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Flex, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.FlexItem, null, (0,external_wp_element_namespaceObject.createElement)(FlexLayoutJustifyContentControl, {
      layout: layout,
      onChange: onChange
    })), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.FlexItem, null, allowOrientation && (0,external_wp_element_namespaceObject.createElement)(OrientationControl, {
      layout: layout,
      onChange: onChange
    }))), (0,external_wp_element_namespaceObject.createElement)(FlexWrapControl, {
      layout: layout,
      onChange: onChange
    }));
  },
  toolBarControls: function FlexLayoutToolbarControls(_ref2) {
    let {
      layout = {},
      onChange,
      layoutBlockSupport
    } = _ref2;

    if (layoutBlockSupport !== null && layoutBlockSupport !== void 0 && layoutBlockSupport.allowSwitching) {
      return null;
    }

    const {
      allowVerticalAlignment = true
    } = layoutBlockSupport;
    return (0,external_wp_element_namespaceObject.createElement)(block_controls, {
      group: "block",
      __experimentalShareWithChildBlocks: true
    }, (0,external_wp_element_namespaceObject.createElement)(FlexLayoutJustifyContentControl, {
      layout: layout,
      onChange: onChange,
      isToolbar: true
    }), allowVerticalAlignment && (0,external_wp_element_namespaceObject.createElement)(FlexLayoutVerticalAlignmentControl, {
      layout: layout,
      onChange: onChange,
      isToolbar: true
    }));
  },
  getLayoutStyle: function getLayoutStyle(_ref3) {
    var _style$spacing, _style$spacing2;

    let {
      selector,
      layout,
      style,
      blockName,
      hasBlockGapSupport,
      layoutDefinitions
    } = _ref3;
    const {
      orientation = 'horizontal'
    } = layout; // If a block's block.json skips serialization for spacing or spacing.blockGap,
    // don't apply the user-defined value to the styles.

    const blockGapValue = style !== null && style !== void 0 && (_style$spacing = style.spacing) !== null && _style$spacing !== void 0 && _style$spacing.blockGap && !shouldSkipSerialization(blockName, 'spacing', 'blockGap') ? getGapCSSValue(style === null || style === void 0 ? void 0 : (_style$spacing2 = style.spacing) === null || _style$spacing2 === void 0 ? void 0 : _style$spacing2.blockGap, '0.5em') : undefined;
    const justifyContent = justifyContentMap[layout.justifyContent];
    const flexWrap = flexWrapOptions.includes(layout.flexWrap) ? layout.flexWrap : 'wrap';
    const verticalAlignment = verticalAlignmentMap[layout.verticalAlignment];
    const alignItems = alignItemsMap[layout.justifyContent] || alignItemsMap.left;
    let output = '';
    const rules = [];

    if (flexWrap && flexWrap !== 'wrap') {
      rules.push(`flex-wrap: ${flexWrap}`);
    }

    if (orientation === 'horizontal') {
      if (verticalAlignment) {
        rules.push(`align-items: ${verticalAlignment}`);
      }

      if (justifyContent) {
        rules.push(`justify-content: ${justifyContent}`);
      }
    } else {
      if (verticalAlignment) {
        rules.push(`justify-content: ${verticalAlignment}`);
      }

      rules.push('flex-direction: column');
      rules.push(`align-items: ${alignItems}`);
    }

    if (rules.length) {
      output = `${appendSelectors(selector)} {
				${rules.join('; ')};
			}`;
    } // Output blockGap styles based on rules contained in layout definitions in theme.json.


    if (hasBlockGapSupport && blockGapValue) {
      output += getBlockGapCSS(selector, layoutDefinitions, 'flex', blockGapValue);
    }

    return output;
  },

  getOrientation(layout) {
    const {
      orientation = 'horizontal'
    } = layout;
    return orientation;
  },

  getAlignments() {
    return [];
  }

});

function FlexLayoutVerticalAlignmentControl(_ref4) {
  let {
    layout,
    onChange,
    isToolbar = false
  } = _ref4;
  const {
    orientation = 'horizontal'
  } = layout;
  const defaultVerticalAlignment = orientation === 'horizontal' ? verticalAlignmentMap.center : verticalAlignmentMap.top;
  const {
    verticalAlignment = defaultVerticalAlignment
  } = layout;

  const onVerticalAlignmentChange = value => {
    onChange({ ...layout,
      verticalAlignment: value
    });
  };

  if (isToolbar) {
    return (0,external_wp_element_namespaceObject.createElement)(BlockVerticalAlignmentControl, {
      onChange: onVerticalAlignmentChange,
      value: verticalAlignment,
      controls: orientation === 'horizontal' ? ['top', 'center', 'bottom', 'stretch'] : ['top', 'center', 'bottom', 'space-between']
    });
  }

  const verticalAlignmentOptions = [{
    value: 'flex-start',
    label: (0,external_wp_i18n_namespaceObject.__)('Align items top')
  }, {
    value: 'center',
    label: (0,external_wp_i18n_namespaceObject.__)('Align items center')
  }, {
    value: 'flex-end',
    label: (0,external_wp_i18n_namespaceObject.__)('Align items bottom')
  }];
  return (0,external_wp_element_namespaceObject.createElement)("fieldset", {
    className: "block-editor-hooks__flex-layout-vertical-alignment-control"
  }, (0,external_wp_element_namespaceObject.createElement)("legend", null, (0,external_wp_i18n_namespaceObject.__)('Vertical alignment')), (0,external_wp_element_namespaceObject.createElement)("div", null, verticalAlignmentOptions.map((value, icon, label) => {
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
      key: value,
      label: label,
      icon: icon,
      isPressed: verticalAlignment === value,
      onClick: () => onVerticalAlignmentChange(value)
    });
  })));
}

function FlexLayoutJustifyContentControl(_ref5) {
  let {
    layout,
    onChange,
    isToolbar = false
  } = _ref5;
  const {
    justifyContent = 'left',
    orientation = 'horizontal'
  } = layout;

  const onJustificationChange = value => {
    onChange({ ...layout,
      justifyContent: value
    });
  };

  const allowedControls = ['left', 'center', 'right'];

  if (orientation === 'horizontal') {
    allowedControls.push('space-between');
  } else {
    allowedControls.push('stretch');
  }

  if (isToolbar) {
    return (0,external_wp_element_namespaceObject.createElement)(JustifyContentControl, {
      allowedControls: allowedControls,
      value: justifyContent,
      onChange: onJustificationChange,
      popoverProps: {
        position: 'bottom right',
        variant: 'toolbar'
      }
    });
  }

  const justificationOptions = [{
    value: 'left',
    icon: justify_left,
    label: (0,external_wp_i18n_namespaceObject.__)('Justify items left')
  }, {
    value: 'center',
    icon: justify_center,
    label: (0,external_wp_i18n_namespaceObject.__)('Justify items center')
  }, {
    value: 'right',
    icon: justify_right,
    label: (0,external_wp_i18n_namespaceObject.__)('Justify items right')
  }];

  if (orientation === 'horizontal') {
    justificationOptions.push({
      value: 'space-between',
      icon: justify_space_between,
      label: (0,external_wp_i18n_namespaceObject.__)('Space between items')
    });
  } else {
    justificationOptions.push({
      value: 'stretch',
      icon: justify_stretch,
      label: (0,external_wp_i18n_namespaceObject.__)('Stretch items')
    });
  }

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToggleGroupControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Justification'),
    value: justifyContent,
    onChange: onJustificationChange,
    className: "block-editor-hooks__flex-layout-justification-controls"
  }, justificationOptions.map(_ref6 => {
    let {
      value,
      icon,
      label
    } = _ref6;
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOptionIcon, {
      key: value,
      value: value,
      icon: icon,
      label: label
    });
  }));
}

function FlexWrapControl(_ref7) {
  let {
    layout,
    onChange
  } = _ref7;
  const {
    flexWrap = 'wrap'
  } = layout;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ToggleControl, {
    label: (0,external_wp_i18n_namespaceObject.__)('Allow to wrap to multiple lines'),
    onChange: value => {
      onChange({ ...layout,
        flexWrap: value ? 'wrap' : 'nowrap'
      });
    },
    checked: flexWrap === 'wrap'
  });
}

function OrientationControl(_ref8) {
  let {
    layout,
    onChange
  } = _ref8;
  const {
    orientation = 'horizontal',
    verticalAlignment,
    justifyContent
  } = layout;
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToggleGroupControl, {
    __nextHasNoMarginBottom: true,
    className: "block-editor-hooks__flex-layout-orientation-controls",
    label: (0,external_wp_i18n_namespaceObject.__)('Orientation'),
    value: orientation,
    onChange: value => {
      // Make sure the vertical alignment and justification are compatible with the new orientation.
      let newVerticalAlignment = verticalAlignment;
      let newJustification = justifyContent;

      if (value === 'horizontal') {
        if (verticalAlignment === 'space-between') {
          newVerticalAlignment = 'center';
        }

        if (justifyContent === 'stretch') {
          newJustification = 'left';
        }
      } else {
        if (verticalAlignment === 'stretch') {
          newVerticalAlignment = 'top';
        }

        if (justifyContent === 'space-between') {
          newJustification = 'left';
        }
      }

      return onChange({ ...layout,
        orientation: value,
        verticalAlignment: newVerticalAlignment,
        justifyContent: newJustification
      });
    }
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOptionIcon, {
    icon: arrow_right,
    value: 'horizontal',
    label: (0,external_wp_i18n_namespaceObject.__)('Horizontal')
  }), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOptionIcon, {
    icon: arrow_down,
    value: 'vertical',
    label: (0,external_wp_i18n_namespaceObject.__)('Vertical')
  }));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/layouts/flow.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */




/* harmony default export */ var flow = ({
  name: 'default',
  label: (0,external_wp_i18n_namespaceObject.__)('Flow'),
  inspectorControls: function DefaultLayoutInspectorControls() {
    return null;
  },
  toolBarControls: function DefaultLayoutToolbarControls() {
    return null;
  },
  getLayoutStyle: function getLayoutStyle(_ref) {
    var _style$spacing;

    let {
      selector,
      style,
      blockName,
      hasBlockGapSupport,
      layoutDefinitions
    } = _ref;
    const blockGapStyleValue = getGapCSSValue(style === null || style === void 0 ? void 0 : (_style$spacing = style.spacing) === null || _style$spacing === void 0 ? void 0 : _style$spacing.blockGap); // If a block's block.json skips serialization for spacing or
    // spacing.blockGap, don't apply the user-defined value to the styles.

    let blockGapValue = '';

    if (!shouldSkipSerialization(blockName, 'spacing', 'blockGap')) {
      // If an object is provided only use the 'top' value for this kind of gap.
      if (blockGapStyleValue !== null && blockGapStyleValue !== void 0 && blockGapStyleValue.top) {
        blockGapValue = getGapCSSValue(blockGapStyleValue === null || blockGapStyleValue === void 0 ? void 0 : blockGapStyleValue.top);
      } else if (typeof blockGapStyleValue === 'string') {
        blockGapValue = getGapCSSValue(blockGapStyleValue);
      }
    }

    let output = ''; // Output blockGap styles based on rules contained in layout definitions in theme.json.

    if (hasBlockGapSupport && blockGapValue) {
      output += getBlockGapCSS(selector, layoutDefinitions, 'default', blockGapValue);
    }

    return output;
  },

  getOrientation() {
    return 'vertical';
  },

  getAlignments(layout, isBlockBasedTheme) {
    const alignmentInfo = getAlignmentsInfo(layout);

    if (layout.alignments !== undefined) {
      if (!layout.alignments.includes('none')) {
        layout.alignments.unshift('none');
      }

      return layout.alignments.map(alignment => ({
        name: alignment,
        info: alignmentInfo[alignment]
      }));
    }

    const alignments = [{
      name: 'left'
    }, {
      name: 'center'
    }, {
      name: 'right'
    }]; // This is for backwards compatibility with hybrid themes.

    if (!isBlockBasedTheme) {
      const {
        contentSize,
        wideSize
      } = layout;

      if (contentSize) {
        alignments.unshift({
          name: 'full'
        });
      }

      if (wideSize) {
        alignments.unshift({
          name: 'wide',
          info: alignmentInfo.wide
        });
      }
    }

    alignments.unshift({
      name: 'none',
      info: alignmentInfo.none
    });
    return alignments;
  }

});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/icon/index.js
/**
 * WordPress dependencies
 */

/** @typedef {{icon: JSX.Element, size?: number} & import('@wordpress/primitives').SVGProps} IconProps */

/**
 * Return an SVG icon.
 *
 * @param {IconProps} props icon is the SVG component to render
 *                          size is a number specifiying the icon size in pixels
 *                          Other props will be passed to wrapped SVG component
 *
 * @return {JSX.Element}  Icon component
 */

function Icon(_ref) {
  let {
    icon,
    size = 24,
    ...props
  } = _ref;
  return (0,external_wp_element_namespaceObject.cloneElement)(icon, {
    width: size,
    height: size,
    ...props
  });
}

/* harmony default export */ var build_module_icon = (Icon);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/position-center.js


/**
 * WordPress dependencies
 */

const positionCenter = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M7 9v6h10V9H7zM5 19.8h14v-1.5H5v1.5zM5 4.3v1.5h14V4.3H5z"
}));
/* harmony default export */ var position_center = (positionCenter);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/stretch-wide.js


/**
 * WordPress dependencies
 */

const stretchWide = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M5 9v6h14V9H5zm11-4.8H8v1.5h8V4.2zM8 19.8h8v-1.5H8v1.5z"
}));
/* harmony default export */ var stretch_wide = (stretchWide);

;// CONCATENATED MODULE: external ["wp","styleEngine"]
var external_wp_styleEngine_namespaceObject = window["wp"]["styleEngine"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/layouts/constrained.js


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





/* harmony default export */ var constrained = ({
  name: 'constrained',
  label: (0,external_wp_i18n_namespaceObject.__)('Constrained'),
  inspectorControls: function DefaultLayoutInspectorControls(_ref) {
    let {
      layout,
      onChange
    } = _ref;
    const {
      wideSize,
      contentSize,
      justifyContent = 'center'
    } = layout;

    const onJustificationChange = value => {
      onChange({ ...layout,
        justifyContent: value
      });
    };

    const justificationOptions = [{
      value: 'left',
      icon: justify_left,
      label: (0,external_wp_i18n_namespaceObject.__)('Justify items left')
    }, {
      value: 'center',
      icon: justify_center,
      label: (0,external_wp_i18n_namespaceObject.__)('Justify items center')
    }, {
      value: 'right',
      icon: justify_right,
      label: (0,external_wp_i18n_namespaceObject.__)('Justify items right')
    }];
    const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
      availableUnits: useSetting('spacing.units') || ['%', 'px', 'em', 'rem', 'vw']
    });
    return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "block-editor-hooks__layout-controls"
    }, (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "block-editor-hooks__layout-controls-unit"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalUnitControl, {
      className: "block-editor-hooks__layout-controls-unit-input",
      label: (0,external_wp_i18n_namespaceObject.__)('Content'),
      labelPosition: "top",
      __unstableInputWidth: "80px",
      value: contentSize || wideSize || '',
      onChange: nextWidth => {
        nextWidth = 0 > parseFloat(nextWidth) ? '0' : nextWidth;
        onChange({ ...layout,
          contentSize: nextWidth
        });
      },
      units: units
    }), (0,external_wp_element_namespaceObject.createElement)(build_module_icon, {
      icon: position_center
    })), (0,external_wp_element_namespaceObject.createElement)("div", {
      className: "block-editor-hooks__layout-controls-unit"
    }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalUnitControl, {
      className: "block-editor-hooks__layout-controls-unit-input",
      label: (0,external_wp_i18n_namespaceObject.__)('Wide'),
      labelPosition: "top",
      __unstableInputWidth: "80px",
      value: wideSize || contentSize || '',
      onChange: nextWidth => {
        nextWidth = 0 > parseFloat(nextWidth) ? '0' : nextWidth;
        onChange({ ...layout,
          wideSize: nextWidth
        });
      },
      units: units
    }), (0,external_wp_element_namespaceObject.createElement)(build_module_icon, {
      icon: stretch_wide
    }))), (0,external_wp_element_namespaceObject.createElement)("p", {
      className: "block-editor-hooks__layout-controls-helptext"
    }, (0,external_wp_i18n_namespaceObject.__)('Customize the width for all elements that are assigned to the center or wide columns.')), (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToggleGroupControl, {
      __nextHasNoMarginBottom: true,
      label: (0,external_wp_i18n_namespaceObject.__)('Justification'),
      value: justifyContent,
      onChange: onJustificationChange
    }, justificationOptions.map(_ref2 => {
      let {
        value,
        icon,
        label
      } = _ref2;
      return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOptionIcon, {
        key: value,
        value: value,
        icon: icon,
        label: label
      });
    })));
  },
  toolBarControls: function DefaultLayoutToolbarControls() {
    return null;
  },
  getLayoutStyle: function getLayoutStyle(_ref3) {
    var _style$spacing, _style$spacing2;

    let {
      selector,
      layout = {},
      style,
      blockName,
      hasBlockGapSupport,
      layoutDefinitions
    } = _ref3;
    const {
      contentSize,
      wideSize,
      justifyContent
    } = layout;
    const blockGapStyleValue = getGapCSSValue(style === null || style === void 0 ? void 0 : (_style$spacing = style.spacing) === null || _style$spacing === void 0 ? void 0 : _style$spacing.blockGap); // If a block's block.json skips serialization for spacing or
    // spacing.blockGap, don't apply the user-defined value to the styles.

    let blockGapValue = '';

    if (!shouldSkipSerialization(blockName, 'spacing', 'blockGap')) {
      // If an object is provided only use the 'top' value for this kind of gap.
      if (blockGapStyleValue !== null && blockGapStyleValue !== void 0 && blockGapStyleValue.top) {
        blockGapValue = getGapCSSValue(blockGapStyleValue === null || blockGapStyleValue === void 0 ? void 0 : blockGapStyleValue.top);
      } else if (typeof blockGapStyleValue === 'string') {
        blockGapValue = getGapCSSValue(blockGapStyleValue);
      }
    }

    const marginLeft = justifyContent === 'left' ? '0 !important' : 'auto !important';
    const marginRight = justifyContent === 'right' ? '0 !important' : 'auto !important';
    let output = !!contentSize || !!wideSize ? `
					${appendSelectors(selector, '> :where(:not(.alignleft):not(.alignright):not(.alignfull))')} {
						max-width: ${contentSize !== null && contentSize !== void 0 ? contentSize : wideSize};
						margin-left: ${marginLeft};
						margin-right: ${marginRight};
					}
					${appendSelectors(selector, '> .alignwide')}  {
						max-width: ${wideSize !== null && wideSize !== void 0 ? wideSize : contentSize};
					}
					${appendSelectors(selector, '> .alignfull')} {
						max-width: none;
					}
				` : '';

    if (justifyContent === 'left') {
      output += `${appendSelectors(selector, '> :where(:not(.alignleft):not(.alignright):not(.alignfull))')}
			{ margin-left: ${marginLeft}; }`;
    } else if (justifyContent === 'right') {
      output += `${appendSelectors(selector, '> :where(:not(.alignleft):not(.alignright):not(.alignfull))')}
			{ margin-right: ${marginRight}; }`;
    } // If there is custom padding, add negative margins for alignfull blocks.


    if (style !== null && style !== void 0 && (_style$spacing2 = style.spacing) !== null && _style$spacing2 !== void 0 && _style$spacing2.padding) {
      // The style object might be storing a preset so we need to make sure we get a usable value.
      const paddingValues = (0,external_wp_styleEngine_namespaceObject.getCSSRules)(style);
      paddingValues.forEach(rule => {
        if (rule.key === 'paddingRight') {
          output += `
					${appendSelectors(selector, '> .alignfull')} {
						margin-right: calc(${rule.value} * -1);
					}
					`;
        } else if (rule.key === 'paddingLeft') {
          output += `
					${appendSelectors(selector, '> .alignfull')} {
						margin-left: calc(${rule.value} * -1);
					}
					`;
        }
      });
    } // Output blockGap styles based on rules contained in layout definitions in theme.json.


    if (hasBlockGapSupport && blockGapValue) {
      output += getBlockGapCSS(selector, layoutDefinitions, 'constrained', blockGapValue);
    }

    return output;
  },

  getOrientation() {
    return 'vertical';
  },

  getAlignments(layout) {
    const alignmentInfo = getAlignmentsInfo(layout);

    if (layout.alignments !== undefined) {
      if (!layout.alignments.includes('none')) {
        layout.alignments.unshift('none');
      }

      return layout.alignments.map(alignment => ({
        name: alignment,
        info: alignmentInfo[alignment]
      }));
    }

    const {
      contentSize,
      wideSize
    } = layout;
    const alignments = [{
      name: 'left'
    }, {
      name: 'center'
    }, {
      name: 'right'
    }];

    if (contentSize) {
      alignments.unshift({
        name: 'full'
      });
    }

    if (wideSize) {
      alignments.unshift({
        name: 'wide',
        info: alignmentInfo.wide
      });
    }

    alignments.unshift({
      name: 'none',
      info: alignmentInfo.none
    });
    return alignments;
  }

});

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/layouts/index.js
/**
 * Internal dependencies
 */



const layoutTypes = [flow, flex, constrained];
/**
 * Retrieves a layout type by name.
 *
 * @param {string} name - The name of the layout type.
 * @return {Object} Layout type.
 */

function getLayoutType() {
  let name = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'default';
  return layoutTypes.find(layoutType => layoutType.name === name);
}
/**
 * Retrieves the available layout types.
 *
 * @return {Array} Layout types.
 */

function getLayoutTypes() {
  return layoutTypes;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-list/layout.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */



const defaultLayout = {
  type: 'default'
};
const Layout = (0,external_wp_element_namespaceObject.createContext)(defaultLayout);
/**
 * Allows to define the layout.
 */

const LayoutProvider = Layout.Provider;
/**
 * React hook used to retrieve the layout config.
 */

function useLayout() {
  return (0,external_wp_element_namespaceObject.useContext)(Layout);
}
function LayoutStyle(_ref) {
  let {
    layout = {},
    css,
    ...props
  } = _ref;
  const layoutType = getLayoutType(layout.type);
  const blockGapSupport = useSetting('spacing.blockGap');
  const hasBlockGapSupport = blockGapSupport !== null;

  if (layoutType) {
    var _layoutType$getLayout;

    if (css) {
      return (0,external_wp_element_namespaceObject.createElement)("style", null, css);
    }

    const layoutStyle = (_layoutType$getLayout = layoutType.getLayoutStyle) === null || _layoutType$getLayout === void 0 ? void 0 : _layoutType$getLayout.call(layoutType, {
      hasBlockGapSupport,
      layout,
      ...props
    });

    if (layoutStyle) {
      return (0,external_wp_element_namespaceObject.createElement)("style", null, layoutStyle);
    }
  }

  return null;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-alignment-control/use-available-alignments.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */




const use_available_alignments_EMPTY_ARRAY = [];
const use_available_alignments_DEFAULT_CONTROLS = ['none', 'left', 'center', 'right', 'wide', 'full'];
const WIDE_CONTROLS = ['wide', 'full'];
function useAvailableAlignments() {
  let controls = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : use_available_alignments_DEFAULT_CONTROLS;

  // Always add the `none` option if not exists.
  if (!controls.includes('none')) {
    controls = ['none', ...controls];
  }

  const {
    wideControlsEnabled = false,
    themeSupportsLayout,
    isBlockBasedTheme
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getSettings
    } = select(store);
    const settings = getSettings();
    return {
      wideControlsEnabled: settings.alignWide,
      themeSupportsLayout: settings.supportsLayout,
      isBlockBasedTheme: settings.__unstableIsBlockBasedTheme
    };
  }, []);
  const layout = useLayout();
  const layoutType = getLayoutType(layout === null || layout === void 0 ? void 0 : layout.type);
  const layoutAlignments = layoutType.getAlignments(layout, isBlockBasedTheme);

  if (themeSupportsLayout) {
    const alignments = layoutAlignments.filter(_ref => {
      let {
        name: alignmentName
      } = _ref;
      return controls.includes(alignmentName);
    }); // While we treat `none` as an alignment, we shouldn't return it if no
    // other alignments exist.

    if (alignments.length === 1 && alignments[0].name === 'none') {
      return use_available_alignments_EMPTY_ARRAY;
    }

    return alignments;
  } // Starting here, it's the fallback for themes not supporting the layout config.


  if (layoutType.name !== 'default' && layoutType.name !== 'constrained') {
    return use_available_alignments_EMPTY_ARRAY;
  }

  const {
    alignments: availableAlignments = use_available_alignments_DEFAULT_CONTROLS
  } = layout;
  const enabledControls = controls.filter(control => (layout.alignments || // Ignore the global wideAlignment check if the layout explicitely defines alignments.
  wideControlsEnabled || !WIDE_CONTROLS.includes(control)) && availableAlignments.includes(control)).map(enabledControl => ({
    name: enabledControl
  })); // While we treat `none` as an alignment, we shouldn't return it if no
  // other alignments exist.

  if (enabledControls.length === 1 && enabledControls[0].name === 'none') {
    return use_available_alignments_EMPTY_ARRAY;
  }

  return enabledControls;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/align-none.js


/**
 * WordPress dependencies
 */

const alignNone = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M5 15h14V9H5v6zm0 4.8h14v-1.5H5v1.5zM5 4.2v1.5h14V4.2H5z"
}));
/* harmony default export */ var align_none = (alignNone);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/position-left.js


/**
 * WordPress dependencies
 */

const positionLeft = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M4 9v6h14V9H4zm8-4.8H4v1.5h8V4.2zM4 19.8h8v-1.5H4v1.5z"
}));
/* harmony default export */ var position_left = (positionLeft);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/position-right.js


/**
 * WordPress dependencies
 */

const positionRight = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M6 15h14V9H6v6zm6-10.8v1.5h8V4.2h-8zm0 15.6h8v-1.5h-8v1.5z"
}));
/* harmony default export */ var position_right = (positionRight);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/stretch-full-width.js


/**
 * WordPress dependencies
 */

const stretchFullWidth = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M5 4v11h14V4H5zm3 15.8h8v-1.5H8v1.5z"
}));
/* harmony default export */ var stretch_full_width = (stretchFullWidth);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-alignment-control/constants.js
/**
 * WordPress dependencies
 */


const constants_BLOCK_ALIGNMENTS_CONTROLS = {
  none: {
    icon: align_none,
    title: (0,external_wp_i18n_namespaceObject._x)('None', 'Alignment option')
  },
  left: {
    icon: position_left,
    title: (0,external_wp_i18n_namespaceObject.__)('Align left')
  },
  center: {
    icon: position_center,
    title: (0,external_wp_i18n_namespaceObject.__)('Align center')
  },
  right: {
    icon: position_right,
    title: (0,external_wp_i18n_namespaceObject.__)('Align right')
  },
  wide: {
    icon: stretch_wide,
    title: (0,external_wp_i18n_namespaceObject.__)('Wide width')
  },
  full: {
    icon: stretch_full_width,
    title: (0,external_wp_i18n_namespaceObject.__)('Full width')
  }
};
const constants_DEFAULT_CONTROL = 'none';
const POPOVER_PROPS = {
  variant: 'toolbar'
};

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-alignment-control/ui.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function BlockAlignmentUI(_ref) {
  let {
    value,
    onChange,
    controls,
    isToolbar,
    isCollapsed = true
  } = _ref;
  const enabledControls = useAvailableAlignments(controls);
  const hasEnabledControls = !!enabledControls.length;

  if (!hasEnabledControls) {
    return null;
  }

  function onChangeAlignment(align) {
    onChange([value, 'none'].includes(align) ? undefined : align);
  }

  const activeAlignmentControl = constants_BLOCK_ALIGNMENTS_CONTROLS[value];
  const defaultAlignmentControl = constants_BLOCK_ALIGNMENTS_CONTROLS[constants_DEFAULT_CONTROL];
  const UIComponent = isToolbar ? external_wp_components_namespaceObject.ToolbarGroup : external_wp_components_namespaceObject.ToolbarDropdownMenu;
  const commonProps = {
    icon: activeAlignmentControl ? activeAlignmentControl.icon : defaultAlignmentControl.icon,
    label: (0,external_wp_i18n_namespaceObject.__)('Align')
  };
  const extraProps = isToolbar ? {
    isCollapsed,
    controls: enabledControls.map(_ref2 => {
      let {
        name: controlName
      } = _ref2;
      return { ...constants_BLOCK_ALIGNMENTS_CONTROLS[controlName],
        isActive: value === controlName || !value && controlName === 'none',
        role: isCollapsed ? 'menuitemradio' : undefined,
        onClick: () => onChangeAlignment(controlName)
      };
    })
  } : {
    toggleProps: {
      describedBy: (0,external_wp_i18n_namespaceObject.__)('Change alignment')
    },
    popoverProps: POPOVER_PROPS,
    children: _ref3 => {
      let {
        onClose
      } = _ref3;
      return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuGroup, {
        className: "block-editor-block-alignment-control__menu-group"
      }, enabledControls.map(_ref4 => {
        let {
          name: controlName,
          info
        } = _ref4;
        const {
          icon,
          title
        } = constants_BLOCK_ALIGNMENTS_CONTROLS[controlName]; // If no value is provided, mark as selected the `none` option.

        const isSelected = controlName === value || !value && controlName === 'none';
        return (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuItem, {
          key: controlName,
          icon: icon,
          iconPosition: "left",
          className: classnames_default()('components-dropdown-menu__menu-item', {
            'is-active': isSelected
          }),
          isSelected: isSelected,
          onClick: () => {
            onChangeAlignment(controlName);
            onClose();
          },
          role: "menuitemradio",
          info: info
        }, title);
      })));
    }
  };
  return (0,external_wp_element_namespaceObject.createElement)(UIComponent, _extends({}, commonProps, extraProps));
}

/* harmony default export */ var block_alignment_control_ui = (BlockAlignmentUI);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-alignment-control/index.js



/**
 * Internal dependencies
 */


const BlockAlignmentControl = props => {
  return (0,external_wp_element_namespaceObject.createElement)(block_alignment_control_ui, _extends({}, props, {
    isToolbar: false
  }));
};

const BlockAlignmentToolbar = props => {
  return (0,external_wp_element_namespaceObject.createElement)(block_alignment_control_ui, _extends({}, props, {
    isToolbar: true
  }));
};
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/block-alignment-control/README.md
 */




;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/align.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */




/**
 * An array which includes all possible valid alignments,
 * used to validate if an alignment is valid or not.
 *
 * @constant
 * @type {string[]}
 */

const ALL_ALIGNMENTS = ['left', 'center', 'right', 'wide', 'full'];
/**
 * An array which includes all wide alignments.
 * In order for this alignments to be valid they need to be supported by the block,
 * and by the theme.
 *
 * @constant
 * @type {string[]}
 */

const WIDE_ALIGNMENTS = ['wide', 'full'];
/**
 * Returns the valid alignments.
 * Takes into consideration the aligns supported by a block, if the block supports wide controls or not and if theme supports wide controls or not.
 * Exported just for testing purposes, not exported outside the module.
 *
 * @param {?boolean|string[]} blockAlign          Aligns supported by the block.
 * @param {?boolean}          hasWideBlockSupport True if block supports wide alignments. And False otherwise.
 * @param {?boolean}          hasWideEnabled      True if theme supports wide alignments. And False otherwise.
 *
 * @return {string[]} Valid alignments.
 */

function getValidAlignments(blockAlign) {
  let hasWideBlockSupport = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
  let hasWideEnabled = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
  let validAlignments;

  if (Array.isArray(blockAlign)) {
    validAlignments = ALL_ALIGNMENTS.filter(value => blockAlign.includes(value));
  } else if (blockAlign === true) {
    // `true` includes all alignments...
    validAlignments = [...ALL_ALIGNMENTS];
  } else {
    validAlignments = [];
  }

  if (!hasWideEnabled || blockAlign === true && !hasWideBlockSupport) {
    return validAlignments.filter(alignment => !WIDE_ALIGNMENTS.includes(alignment));
  }

  return validAlignments;
}
/**
 * Filters registered block settings, extending attributes to include `align`.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Filtered block settings.
 */

function addAttribute(settings) {
  var _settings$attributes$, _settings$attributes;

  // Allow blocks to specify their own attribute definition with default values if needed.
  if ('type' in ((_settings$attributes$ = (_settings$attributes = settings.attributes) === null || _settings$attributes === void 0 ? void 0 : _settings$attributes.align) !== null && _settings$attributes$ !== void 0 ? _settings$attributes$ : {})) {
    return settings;
  }

  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, 'align')) {
    // Gracefully handle if settings.attributes is undefined.
    settings.attributes = { ...settings.attributes,
      align: {
        type: 'string',
        // Allow for '' since it is used by updateAlignment function
        // in withToolbarControls for special cases with defined default values.
        enum: [...ALL_ALIGNMENTS, '']
      }
    };
  }

  return settings;
}
/**
 * Override the default edit UI to include new toolbar controls for block
 * alignment, if block defines support.
 *
 * @param {Function} BlockEdit Original component.
 *
 * @return {Function} Wrapped component.
 */

const withToolbarControls = (0,external_wp_compose_namespaceObject.createHigherOrderComponent)(BlockEdit => props => {
  const blockEdit = (0,external_wp_element_namespaceObject.createElement)(BlockEdit, props);
  const {
    name: blockName
  } = props; // Compute the block valid alignments by taking into account,
  // if the theme supports wide alignments or not and the layout's
  // availble alignments. We do that for conditionally rendering
  // Slot.

  const blockAllowedAlignments = getValidAlignments((0,external_wp_blocks_namespaceObject.getBlockSupport)(blockName, 'align'), (0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockName, 'alignWide', true));
  const validAlignments = useAvailableAlignments(blockAllowedAlignments).map(_ref => {
    let {
      name
    } = _ref;
    return name;
  });
  const isContentLocked = (0,external_wp_data_namespaceObject.useSelect)(select => {
    return select(store).__unstableGetContentLockingParent(props.clientId);
  }, [props.clientId]);

  if (!validAlignments.length || isContentLocked) {
    return blockEdit;
  }

  const updateAlignment = nextAlign => {
    if (!nextAlign) {
      var _blockType$attributes, _blockType$attributes2;

      const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(props.name);
      const blockDefaultAlign = blockType === null || blockType === void 0 ? void 0 : (_blockType$attributes = blockType.attributes) === null || _blockType$attributes === void 0 ? void 0 : (_blockType$attributes2 = _blockType$attributes.align) === null || _blockType$attributes2 === void 0 ? void 0 : _blockType$attributes2.default;

      if (blockDefaultAlign) {
        nextAlign = '';
      }
    }

    props.setAttributes({
      align: nextAlign
    });
  };

  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(block_controls, {
    group: "block",
    __experimentalShareWithChildBlocks: true
  }, (0,external_wp_element_namespaceObject.createElement)(BlockAlignmentControl, {
    value: props.attributes.align,
    onChange: updateAlignment,
    controls: validAlignments
  })), blockEdit);
}, 'withToolbarControls');
/**
 * Override the default block element to add alignment wrapper props.
 *
 * @param {Function} BlockListBlock Original component.
 *
 * @return {Function} Wrapped component.
 */

const withDataAlign = (0,external_wp_compose_namespaceObject.createHigherOrderComponent)(BlockListBlock => props => {
  const {
    name,
    attributes
  } = props;
  const {
    align
  } = attributes;
  const blockAllowedAlignments = getValidAlignments((0,external_wp_blocks_namespaceObject.getBlockSupport)(name, 'align'), (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, 'alignWide', true));
  const validAlignments = useAvailableAlignments(blockAllowedAlignments); // If an alignment is not assigned, there's no need to go through the
  // effort to validate or assign its value.

  if (align === undefined) {
    return (0,external_wp_element_namespaceObject.createElement)(BlockListBlock, props);
  }

  let wrapperProps = props.wrapperProps;

  if (validAlignments.some(alignment => alignment.name === align)) {
    wrapperProps = { ...wrapperProps,
      'data-align': align
    };
  }

  return (0,external_wp_element_namespaceObject.createElement)(BlockListBlock, _extends({}, props, {
    wrapperProps: wrapperProps
  }));
});
/**
 * Override props assigned to save component to inject alignment class name if
 * block supports it.
 *
 * @param {Object} props      Additional props applied to save element.
 * @param {Object} blockType  Block type.
 * @param {Object} attributes Block attributes.
 *
 * @return {Object} Filtered props applied to save element.
 */

function addAssignedAlign(props, blockType, attributes) {
  const {
    align
  } = attributes;
  const blockAlign = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, 'align');
  const hasWideBlockSupport = (0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'alignWide', true); // Compute valid alignments without taking into account if
  // the theme supports wide alignments or not.
  // This way changing themes does not impact the block save.

  const isAlignValid = getValidAlignments(blockAlign, hasWideBlockSupport).includes(align);

  if (isAlignValid) {
    props.className = classnames_default()(`align${align}`, props.className);
  }

  return props;
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/align/addAttribute', addAttribute);
(0,external_wp_hooks_namespaceObject.addFilter)('editor.BlockListBlock', 'core/editor/align/with-data-align', withDataAlign);
(0,external_wp_hooks_namespaceObject.addFilter)('editor.BlockEdit', 'core/editor/align/with-toolbar-controls', withToolbarControls);
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.getSaveContent.extraProps', 'core/align/addAssignedAlign', addAssignedAlign);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/lock.js
/**
 * WordPress dependencies
 */

/**
 * Filters registered block settings, extending attributes to include `lock`.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Filtered block settings.
 */

function lock_addAttribute(settings) {
  var _settings$attributes$, _settings$attributes;

  // Allow blocks to specify their own attribute definition with default values if needed.
  if ('type' in ((_settings$attributes$ = (_settings$attributes = settings.attributes) === null || _settings$attributes === void 0 ? void 0 : _settings$attributes.lock) !== null && _settings$attributes$ !== void 0 ? _settings$attributes$ : {})) {
    return settings;
  } // Gracefully handle if settings.attributes is undefined.


  settings.attributes = { ...settings.attributes,
    lock: {
      type: 'object'
    }
  };
  return settings;
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/lock/addAttribute', lock_addAttribute);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/anchor.js


/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */


/**
 * Regular expression matching invalid anchor characters for replacement.
 *
 * @type {RegExp}
 */

const ANCHOR_REGEX = /[\s#]/g;
const ANCHOR_SCHEMA = {
  type: 'string',
  source: 'attribute',
  attribute: 'id',
  selector: '*'
};
/**
 * Filters registered block settings, extending attributes with anchor using ID
 * of the first node.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Filtered block settings.
 */

function anchor_addAttribute(settings) {
  var _settings$attributes$, _settings$attributes;

  // Allow blocks to specify their own attribute definition with default values if needed.
  if ('type' in ((_settings$attributes$ = (_settings$attributes = settings.attributes) === null || _settings$attributes === void 0 ? void 0 : _settings$attributes.anchor) !== null && _settings$attributes$ !== void 0 ? _settings$attributes$ : {})) {
    return settings;
  }

  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, 'anchor')) {
    // Gracefully handle if settings.attributes is undefined.
    settings.attributes = { ...settings.attributes,
      anchor: ANCHOR_SCHEMA
    };
  }

  return settings;
}
/**
 * Override the default edit UI to include a new block inspector control for
 * assigning the anchor ID, if block supports anchor.
 *
 * @param {WPComponent} BlockEdit Original component.
 *
 * @return {WPComponent} Wrapped component.
 */

const withInspectorControl = (0,external_wp_compose_namespaceObject.createHigherOrderComponent)(BlockEdit => {
  return props => {
    const hasAnchor = (0,external_wp_blocks_namespaceObject.hasBlockSupport)(props.name, 'anchor');

    if (hasAnchor && props.isSelected) {
      const isWeb = external_wp_element_namespaceObject.Platform.OS === 'web';
      const textControl = (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.TextControl, {
        __nextHasNoMarginBottom: true,
        className: "html-anchor-control",
        label: (0,external_wp_i18n_namespaceObject.__)('HTML anchor'),
        help: (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_i18n_namespaceObject.__)('Enter a word or two — without spaces — to make a unique web address just for this block, called an “anchor.” Then, you’ll be able to link directly to this section of your page.'), isWeb && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.ExternalLink, {
          href: (0,external_wp_i18n_namespaceObject.__)('https://wordpress.org/support/article/page-jumps/')
        }, (0,external_wp_i18n_namespaceObject.__)('Learn more about anchors'))),
        value: props.attributes.anchor || '',
        placeholder: !isWeb ? (0,external_wp_i18n_namespaceObject.__)('Add an anchor') : null,
        onChange: nextValue => {
          nextValue = nextValue.replace(ANCHOR_REGEX, '-');
          props.setAttributes({
            anchor: nextValue
          });
        },
        autoCapitalize: "none",
        autoComplete: "off"
      });
      return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(BlockEdit, props), isWeb && (0,external_wp_element_namespaceObject.createElement)(inspector_controls, {
        group: "advanced"
      }, textControl), !isWeb && props.name === 'core/heading' && (0,external_wp_element_namespaceObject.createElement)(inspector_controls, null, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.PanelBody, {
        title: (0,external_wp_i18n_namespaceObject.__)('Heading settings')
      }, textControl)));
    }

    return (0,external_wp_element_namespaceObject.createElement)(BlockEdit, props);
  };
}, 'withInspectorControl');
/**
 * Override props assigned to save component to inject anchor ID, if block
 * supports anchor. This is only applied if the block's save result is an
 * element and not a markup string.
 *
 * @param {Object} extraProps Additional props applied to save element.
 * @param {Object} blockType  Block type.
 * @param {Object} attributes Current block attributes.
 *
 * @return {Object} Filtered props applied to save element.
 */

function addSaveProps(extraProps, blockType, attributes) {
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'anchor')) {
    extraProps.id = attributes.anchor === '' ? null : attributes.anchor;
  }

  return extraProps;
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/anchor/attribute', anchor_addAttribute);
(0,external_wp_hooks_namespaceObject.addFilter)('editor.BlockEdit', 'core/editor/anchor/with-inspector-control', withInspectorControl);
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.getSaveContent.extraProps', 'core/anchor/save-props', addSaveProps);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/aria-label.js
/**
 * WordPress dependencies
 */


const ARIA_LABEL_SCHEMA = {
  type: 'string',
  source: 'attribute',
  attribute: 'aria-label',
  selector: '*'
};
/**
 * Filters registered block settings, extending attributes with ariaLabel using aria-label
 * of the first node.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Filtered block settings.
 */

function aria_label_addAttribute(settings) {
  var _settings$attributes, _settings$attributes$;

  // Allow blocks to specify their own attribute definition with default values if needed.
  if (settings !== null && settings !== void 0 && (_settings$attributes = settings.attributes) !== null && _settings$attributes !== void 0 && (_settings$attributes$ = _settings$attributes.ariaLabel) !== null && _settings$attributes$ !== void 0 && _settings$attributes$.type) {
    return settings;
  }

  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, 'ariaLabel')) {
    // Gracefully handle if settings.attributes is undefined.
    settings.attributes = { ...settings.attributes,
      ariaLabel: ARIA_LABEL_SCHEMA
    };
  }

  return settings;
}
/**
 * Override props assigned to save component to inject aria-label, if block
 * supports ariaLabel. This is only applied if the block's save result is an
 * element and not a markup string.
 *
 * @param {Object} extraProps Additional props applied to save element.
 * @param {Object} blockType  Block type.
 * @param {Object} attributes Current block attributes.
 *
 * @return {Object} Filtered props applied to save element.
 */

function aria_label_addSaveProps(extraProps, blockType, attributes) {
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'ariaLabel')) {
    extraProps['aria-label'] = attributes.ariaLabel === '' ? null : attributes.ariaLabel;
  }

  return extraProps;
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/ariaLabel/attribute', aria_label_addAttribute);
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.getSaveContent.extraProps', 'core/ariaLabel/save-props', aria_label_addSaveProps);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/custom-class-name.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */


/**
 * Filters registered block settings, extending attributes with anchor using ID
 * of the first node.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Filtered block settings.
 */

function custom_class_name_addAttribute(settings) {
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, 'customClassName', true)) {
    // Gracefully handle if settings.attributes is undefined.
    settings.attributes = { ...settings.attributes,
      className: {
        type: 'string'
      }
    };
  }

  return settings;
}
/**
 * Override the default edit UI to include a new block inspector control for
 * assigning the custom class name, if block supports custom class name.
 *
 * @param {WPComponent} BlockEdit Original component.
 *
 * @return {WPComponent} Wrapped component.
 */

const custom_class_name_withInspectorControl = (0,external_wp_compose_namespaceObject.createHigherOrderComponent)(BlockEdit => {
  return props => {
    const hasCustomClassName = (0,external_wp_blocks_namespaceObject.hasBlockSupport)(props.name, 'customClassName', true);

    if (hasCustomClassName && props.isSelected) {
      return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(BlockEdit, props), (0,external_wp_element_namespaceObject.createElement)(inspector_controls, {
        group: "advanced"
      }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.TextControl, {
        __nextHasNoMarginBottom: true,
        autoComplete: "off",
        label: (0,external_wp_i18n_namespaceObject.__)('Additional CSS class(es)'),
        value: props.attributes.className || '',
        onChange: nextValue => {
          props.setAttributes({
            className: nextValue !== '' ? nextValue : undefined
          });
        },
        help: (0,external_wp_i18n_namespaceObject.__)('Separate multiple classes with spaces.')
      })));
    }

    return (0,external_wp_element_namespaceObject.createElement)(BlockEdit, props);
  };
}, 'withInspectorControl');
/**
 * Override props assigned to save component to inject anchor ID, if block
 * supports anchor. This is only applied if the block's save result is an
 * element and not a markup string.
 *
 * @param {Object} extraProps Additional props applied to save element.
 * @param {Object} blockType  Block type.
 * @param {Object} attributes Current block attributes.
 *
 * @return {Object} Filtered props applied to save element.
 */

function custom_class_name_addSaveProps(extraProps, blockType, attributes) {
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'customClassName', true) && attributes.className) {
    extraProps.className = classnames_default()(extraProps.className, attributes.className);
  }

  return extraProps;
}
function addTransforms(result, source, index, results) {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(result.name, 'customClassName', true)) {
    return result;
  } // If the condition verifies we are probably in the presence of a wrapping transform
  // e.g: nesting paragraphs in a group or columns and in that case the class should not be kept.


  if (results.length === 1 && result.innerBlocks.length === source.length) {
    return result;
  } // If we are transforming one block to multiple blocks or multiple blocks to one block,
  // we ignore the class during the transform.


  if (results.length === 1 && source.length > 1 || results.length > 1 && source.length === 1) {
    return result;
  } // If we are in presence of transform between one or more block in the source
  // that have one or more blocks in the result
  // we apply the class on source N to the result N,
  // if source N does not exists we do nothing.


  if (source[index]) {
    var _source$index;

    const originClassName = (_source$index = source[index]) === null || _source$index === void 0 ? void 0 : _source$index.attributes.className;

    if (originClassName) {
      return { ...result,
        attributes: { ...result.attributes,
          className: originClassName
        }
      };
    }
  }

  return result;
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/custom-class-name/attribute', custom_class_name_addAttribute);
(0,external_wp_hooks_namespaceObject.addFilter)('editor.BlockEdit', 'core/editor/custom-class-name/with-inspector-control', custom_class_name_withInspectorControl);
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.getSaveContent.extraProps', 'core/custom-class-name/save-props', custom_class_name_addSaveProps);
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.switchToBlockType.transformedBlock', 'core/color/addTransforms', addTransforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/generated-class-name.js
/**
 * WordPress dependencies
 */


/**
 * Override props assigned to save component to inject generated className if
 * block supports it. This is only applied if the block's save result is an
 * element and not a markup string.
 *
 * @param {Object} extraProps Additional props applied to save element.
 * @param {Object} blockType  Block type.
 *
 * @return {Object} Filtered props applied to save element.
 */

function addGeneratedClassName(extraProps, blockType) {
  // Adding the generated className.
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'className', true)) {
    if (typeof extraProps.className === 'string') {
      // We have some extra classes and want to add the default classname
      // We use uniq to prevent duplicate classnames.
      extraProps.className = [...new Set([(0,external_wp_blocks_namespaceObject.getBlockDefaultClassName)(blockType.name), ...extraProps.className.split(' ')])].join(' ').trim();
    } else {
      // There is no string in the className variable,
      // so we just dump the default name in there.
      extraProps.className = (0,external_wp_blocks_namespaceObject.getBlockDefaultClassName)(blockType.name);
    }
  }

  return extraProps;
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.getSaveContent.extraProps', 'core/generated-class-name/save-props', addGeneratedClassName);

;// CONCATENATED MODULE: external ["wp","dom"]
var external_wp_dom_namespaceObject = window["wp"]["dom"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-context/index.js


/**
 * WordPress dependencies
 */

/** @typedef {import('react').ReactNode} ReactNode */

/**
 * @typedef BlockContextProviderProps
 *
 * @property {Record<string,*>} value    Context value to merge with current
 *                                       value.
 * @property {ReactNode}        children Component children.
 */

/** @type {import('react').Context<Record<string,*>>} */

const block_context_Context = (0,external_wp_element_namespaceObject.createContext)({});
/**
 * Component which merges passed value with current consumed block context.
 *
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/block-context/README.md
 *
 * @param {BlockContextProviderProps} props
 */

function BlockContextProvider(_ref) {
  let {
    value,
    children
  } = _ref;
  const context = (0,external_wp_element_namespaceObject.useContext)(block_context_Context);
  const nextValue = (0,external_wp_element_namespaceObject.useMemo)(() => ({ ...context,
    ...value
  }), [context, value]);
  return (0,external_wp_element_namespaceObject.createElement)(block_context_Context.Provider, {
    value: nextValue,
    children: children
  });
}
/* harmony default export */ var block_context = (block_context_Context);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-edit/edit.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


/**
 * Default value used for blocks which do not define their own context needs,
 * used to guarantee that a block's `context` prop will always be an object. It
 * is assigned as a constant since it is always expected to be an empty object,
 * and in order to avoid unnecessary React reconciliations of a changing object.
 *
 * @type {{}}
 */

const DEFAULT_BLOCK_CONTEXT = {};
const Edit = props => {
  const {
    attributes = {},
    name
  } = props;
  const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(name);
  const blockContext = (0,external_wp_element_namespaceObject.useContext)(block_context); // Assign context values using the block type's declared context needs.

  const context = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return blockType && blockType.usesContext ? Object.fromEntries(Object.entries(blockContext).filter(_ref => {
      let [key] = _ref;
      return blockType.usesContext.includes(key);
    })) : DEFAULT_BLOCK_CONTEXT;
  }, [blockType, blockContext]);

  if (!blockType) {
    return null;
  } // `edit` and `save` are functions or components describing the markup
  // with which a block is displayed. If `blockType` is valid, assign
  // them preferentially as the render value for the block.


  const Component = blockType.edit || blockType.save;

  if (blockType.apiVersion > 1) {
    return (0,external_wp_element_namespaceObject.createElement)(Component, _extends({}, props, {
      context: context
    }));
  } // Generate a class name for the block's editable form.


  const generatedClassName = (0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'className', true) ? (0,external_wp_blocks_namespaceObject.getBlockDefaultClassName)(name) : null;
  const className = classnames_default()(generatedClassName, attributes.className, props.className);
  return (0,external_wp_element_namespaceObject.createElement)(Component, _extends({}, props, {
    context: context,
    className: className
  }));
};
/* harmony default export */ var edit = ((0,external_wp_components_namespaceObject.withFilters)('editor.BlockEdit')(Edit));

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-edit/index.js


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * The `useBlockEditContext` hook provides information about the block this hook is being used in.
 * It returns an object with the `name`, `isSelected` state, and the `clientId` of the block.
 * It is useful if you want to create custom hooks that need access to the current blocks clientId
 * but don't want to rely on the data getting passed in as a parameter.
 *
 * @return {Object} Block edit context
 */


function BlockEdit(props) {
  const {
    name,
    isSelected,
    clientId,
    attributes = {},
    __unstableLayoutClassNames
  } = props;
  const {
    layout = null
  } = attributes;
  const layoutSupport = (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, '__experimentalLayout', false);
  const context = {
    name,
    isSelected,
    clientId,
    layout: layoutSupport ? layout : null,
    __unstableLayoutClassNames
  };
  return (0,external_wp_element_namespaceObject.createElement)(Provider // It is important to return the same object if props haven't
  // changed to avoid  unnecessary rerenders.
  // See https://reactjs.org/docs/context.html#caveats.
  , {
    value: (0,external_wp_element_namespaceObject.useMemo)(() => context, Object.values(context))
  }, (0,external_wp_element_namespaceObject.createElement)(edit, props));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/more-horizontal.js


/**
 * WordPress dependencies
 */

const moreHorizontal = (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,external_wp_element_namespaceObject.createElement)(external_wp_primitives_namespaceObject.Path, {
  d: "M11 13h2v-2h-2v2zm-6 0h2v-2H5v2zm12-2v2h2v-2h-2z"
}));
/* harmony default export */ var more_horizontal = (moreHorizontal);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/warning/index.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






function Warning(_ref) {
  let {
    className,
    actions,
    children,
    secondaryActions
  } = _ref;
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    style: {
      display: 'contents',
      all: 'initial'
    }
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: classnames_default()(className, 'block-editor-warning')
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-warning__contents"
  }, (0,external_wp_element_namespaceObject.createElement)("p", {
    className: "block-editor-warning__message"
  }, children), (external_wp_element_namespaceObject.Children.count(actions) > 0 || secondaryActions) && (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-warning__actions"
  }, external_wp_element_namespaceObject.Children.count(actions) > 0 && external_wp_element_namespaceObject.Children.map(actions, (action, i) => (0,external_wp_element_namespaceObject.createElement)("span", {
    key: i,
    className: "block-editor-warning__action"
  }, action)), secondaryActions && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.DropdownMenu, {
    className: "block-editor-warning__secondary",
    icon: more_horizontal,
    label: (0,external_wp_i18n_namespaceObject.__)('More options'),
    popoverProps: {
      position: 'bottom left',
      className: 'block-editor-warning__dropdown'
    },
    noIcons: true
  }, () => (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuGroup, null, secondaryActions.map((item, pos) => (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.MenuItem, {
    onClick: item.onClick,
    key: pos
  }, item.title))))))));
}
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/warning/README.md
 */


/* harmony default export */ var warning = (Warning);

// EXTERNAL MODULE: ./node_modules/diff/lib/diff/character.js
var character = __webpack_require__(1973);
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-compare/block-view.js


/**
 * WordPress dependencies
 */



function BlockView(_ref) {
  let {
    title,
    rawContent,
    renderedContent,
    action,
    actionText,
    className
  } = _ref;
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: className
  }, (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-compare__content"
  }, (0,external_wp_element_namespaceObject.createElement)("h2", {
    className: "block-editor-block-compare__heading"
  }, title), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-compare__html"
  }, rawContent), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-compare__preview edit-post-visual-editor"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.RawHTML, null, (0,external_wp_dom_namespaceObject.safeHTML)(renderedContent)))), (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-compare__action"
  }, (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
    variant: "secondary",
    tabIndex: "0",
    onClick: action
  }, actionText)));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-compare/index.js


/**
 * External dependencies
 */
 // diff doesn't tree-shake correctly, so we import from the individual
// module here, to avoid including too much of the library


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function BlockCompare(_ref) {
  let {
    block,
    onKeep,
    onConvert,
    convertor,
    convertButtonText
  } = _ref;

  function getDifference(originalContent, newContent) {
    const difference = (0,character/* diffChars */.Kx)(originalContent, newContent);
    return difference.map((item, pos) => {
      const classes = classnames_default()({
        'block-editor-block-compare__added': item.added,
        'block-editor-block-compare__removed': item.removed
      });
      return (0,external_wp_element_namespaceObject.createElement)("span", {
        key: pos,
        className: classes
      }, item.value);
    });
  }

  function getConvertedContent(convertedBlock) {
    // The convertor may return an array of items or a single item.
    const newBlocks = Array.isArray(convertedBlock) ? convertedBlock : [convertedBlock]; // Get converted block details.

    const newContent = newBlocks.map(item => (0,external_wp_blocks_namespaceObject.getSaveContent)(item.name, item.attributes, item.innerBlocks));
    return newContent.join('');
  }

  const converted = getConvertedContent(convertor(block));
  const difference = getDifference(block.originalContent, converted);
  return (0,external_wp_element_namespaceObject.createElement)("div", {
    className: "block-editor-block-compare__wrapper"
  }, (0,external_wp_element_namespaceObject.createElement)(BlockView, {
    title: (0,external_wp_i18n_namespaceObject.__)('Current'),
    className: "block-editor-block-compare__current",
    action: onKeep,
    actionText: (0,external_wp_i18n_namespaceObject.__)('Convert to HTML'),
    rawContent: block.originalContent,
    renderedContent: block.originalContent
  }), (0,external_wp_element_namespaceObject.createElement)(BlockView, {
    title: (0,external_wp_i18n_namespaceObject.__)('After Conversion'),
    className: "block-editor-block-compare__converted",
    action: onConvert,
    actionText: convertButtonText,
    rawContent: difference,
    renderedContent: converted
  }));
}

/* harmony default export */ var block_compare = (BlockCompare);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-list/block-invalid-warning.js


/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */




function BlockInvalidWarning(_ref) {
  let {
    convertToHTML,
    convertToBlocks,
    convertToClassic,
    attemptBlockRecovery,
    block
  } = _ref;
  const hasHTMLBlock = !!(0,external_wp_blocks_namespaceObject.getBlockType)('core/html');
  const hasClassicBlock = !!(0,external_wp_blocks_namespaceObject.getBlockType)('core/freeform');
  const [compare, setCompare] = (0,external_wp_element_namespaceObject.useState)(false);
  const onCompare = (0,external_wp_element_namespaceObject.useCallback)(() => setCompare(true), []);
  const onCompareClose = (0,external_wp_element_namespaceObject.useCallback)(() => setCompare(false), []); // We memo the array here to prevent the children components from being updated unexpectedly.

  const hiddenActions = (0,external_wp_element_namespaceObject.useMemo)(() => [{
    // translators: Button to fix block content
    title: (0,external_wp_i18n_namespaceObject._x)('Resolve', 'imperative verb'),
    onClick: onCompare
  }, hasHTMLBlock && {
    title: (0,external_wp_i18n_namespaceObject.__)('Convert to HTML'),
    onClick: convertToHTML
  }, hasClassicBlock && {
    title: (0,external_wp_i18n_namespaceObject.__)('Convert to Classic Block'),
    onClick: convertToClassic
  }].filter(Boolean), [onCompare, hasHTMLBlock, convertToHTML, hasClassicBlock, convertToClassic]);
  return (0,external_wp_element_namespaceObject.createElement)(external_wp_element_namespaceObject.Fragment, null, (0,external_wp_element_namespaceObject.createElement)(warning, {
    actions: [(0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Button, {
      key: "recover",
      onClick: attemptBlockRecovery,
      variant: "primary"
    }, (0,external_wp_i18n_namespaceObject.__)('Attempt Block Recovery'))],
    secondaryActions: hiddenActions
  }, (0,external_wp_i18n_namespaceObject.__)('This block contains unexpected or invalid content.')), compare && (0,external_wp_element_namespaceObject.createElement)(external_wp_components_namespaceObject.Modal, {
    title: // translators: Dialog title to fix block content
    (0,external_wp_i18n_namespaceObject.__)('Resolve Block'),
    onRequestClose: onCompareClose,
    className: "block-editor-block-compare"
  }, (0,external_wp_element_namespaceObject.createElement)(block_compare, {
    block: block,
    onKeep: convertToHTML,
    onConvert: convertToBlocks,
    convertor: blockToBlocks,
    convertButtonText: (0,external_wp_i18n_namespaceObject.__)('Convert to Blocks')
  })));
}

const blockToClassic = block => (0,external_wp_blocks_namespaceObject.createBlock)('core/freeform', {
  content: block.originalContent
});

const blockToHTML = block => (0,external_wp_blocks_namespaceObject.createBlock)('core/html', {
  content: block.originalContent
});

const blockToBlocks = block => (0,external_wp_blocks_namespaceObject.rawHandler)({
  HTML: block.originalContent
});

const recoverBlock = _ref2 => {
  let {
    name,
    attributes,
    innerBlocks
  } = _ref2;
  return (0,external_wp_blocks_namespaceObject.createBlock)(name, attributes, innerBlocks);
};

/* harmony default export */ var block_invalid_warning = ((0,external_wp_compose_namespaceObject.compose)([(0,external_wp_data_namespaceObject.withSelect)((select, _ref3) => {
  let {
    clientId
  } = _ref3;
  return {
    block: select(store).getBlock(clientId)
  };
}), (0,external_wp_data_namespaceObject.withDispatch)((dispatch, _ref4) => {
  let {
    block
  } = _ref4;
  const {
    replaceBlock
  } = dispatch(store);
  return {
    convertToClassic() {
      replaceBlock(block.clientId, blockToClassic(block));
    },

    convertToHTML() {
      replaceBlock(block.clientId, blockToHTML(block));
    },

    convertToBlocks() {
      replaceBlock(block.clientId, blockToBlocks(block));
    },

    attemptBlockRecovery() {
      replaceBlock(block.clientId, recoverBlock(block));
    }

  };
})])(BlockInvalidWarning));

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-list/block-crash-warning.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const block_crash_warning_warning = (0,external_wp_element_namespaceObject.createElement)(warning, {
  className: "block-editor-block-list__block-crash-warning"
}, (0,external_wp_i18n_namespaceObject.__)('This block has encountered an error and cannot be previewed.'));
/* harmony default export */ var block_crash_warning = (() => block_crash_warning_warning);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-list/block-crash-boundary.js
/**
 * WordPress dependencies
 */


class BlockCrashBoundary extends external_wp_element_namespaceObject.Component {
  constructor() {
    super(...arguments);
    this.state = {
      hasError: false
    };
  }

  componentDidCatch() {
    this.setState({
      hasError: true
    });
  }

  render() {
    if (this.state.hasError) {
      return this.props.fallback;
    }

    return this.props.children;
  }

}

/* harmony default export */ var block_crash_boundary = (BlockCrashBoundary);

// EXTERNAL MODULE: ./node_modules/react-autosize-textarea/lib/index.js
var lib = __webpack_require__(773);
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-list/block-html.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



function BlockHTML(_ref) {
  let {
    clientId
  } = _ref;
  const [html, setHtml] = (0,external_wp_element_namespaceObject.useState)('');
  const block = (0,external_wp_data_namespaceObject.useSelect)(select => select(store).getBlock(clientId), [clientId]);
  const {
    updateBlock
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);

  const onChange = () => {
    const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(block.name);

    if (!blockType) {
      return;
    }

    const attributes = (0,external_wp_blocks_namespaceObject.getBlockAttributes)(blockType, html, block.attributes); // If html is empty  we reset the block to the default HTML and mark it as valid to avoid triggering an error

    const content = html ? html : (0,external_wp_blocks_namespaceObject.getSaveContent)(blockType, attributes);
    const [isValid] = html ? (0,external_wp_blocks_namespaceObject.validateBlock)({ ...block,
      attributes,
      originalContent: content
    }) : [true];
    updateBlock(clientId, {
      attributes,
      originalContent: content,
      isValid
    }); // Ensure the state is updated if we reset so it displays the default content.

    if (!html) {
      setHtml({
        content
      });
    }
  };

  (0,external_wp_element_namespaceObject.useEffect)(() => {
    setHtml((0,external_wp_blocks_namespaceObject.getBlockContent)(block));
  }, [block]);
  return (0,external_wp_element_namespaceObject.createElement)(lib/* default */.Z, {
    className: "block-editor-block-list__block-html-textarea",
    value: html,
    onBlur: onChange,
    onChange: event => setHtml(event.target.value)
  });
}

/* harmony default export */ var block_html = (BlockHTML);

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(9196);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);
;// CONCATENATED MODULE: ./node_modules/@react-spring/shared/dist/react-spring_shared.modern.mjs
var __defProp = Object.defineProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};

// src/globals.ts
var globals_exports = {};
__export(globals_exports, {
  assign: () => react_spring_shared_modern_assign,
  colors: () => colors,
  createStringInterpolator: () => createStringInterpolator,
  skipAnimation: () => skipAnimation,
  to: () => to,
  willAdvance: () => willAdvance
});

// ../rafz/dist/react-spring_rafz.modern.mjs
var updateQueue = makeQueue();
var raf = (fn) => schedule(fn, updateQueue);
var writeQueue = makeQueue();
raf.write = (fn) => schedule(fn, writeQueue);
var onStartQueue = makeQueue();
raf.onStart = (fn) => schedule(fn, onStartQueue);
var onFrameQueue = makeQueue();
raf.onFrame = (fn) => schedule(fn, onFrameQueue);
var onFinishQueue = makeQueue();
raf.onFinish = (fn) => schedule(fn, onFinishQueue);
var timeouts = [];
raf.setTimeout = (handler, ms) => {
  const time = raf.now() + ms;
  const cancel = () => {
    const i = timeouts.findIndex((t) => t.cancel == cancel);
    if (~i)
      timeouts.splice(i, 1);
    pendingCount -= ~i ? 1 : 0;
  };
  const timeout = { time, handler, cancel };
  timeouts.splice(findTimeout(time), 0, timeout);
  pendingCount += 1;
  start();
  return timeout;
};
var findTimeout = (time) => ~(~timeouts.findIndex((t) => t.time > time) || ~timeouts.length);
raf.cancel = (fn) => {
  onStartQueue.delete(fn);
  onFrameQueue.delete(fn);
  onFinishQueue.delete(fn);
  updateQueue.delete(fn);
  writeQueue.delete(fn);
};
raf.sync = (fn) => {
  sync = true;
  raf.batchedUpdates(fn);
  sync = false;
};
raf.throttle = (fn) => {
  let lastArgs;
  function queuedFn() {
    try {
      fn(...lastArgs);
    } finally {
      lastArgs = null;
    }
  }
  function throttled(...args) {
    lastArgs = args;
    raf.onStart(queuedFn);
  }
  throttled.handler = fn;
  throttled.cancel = () => {
    onStartQueue.delete(queuedFn);
    lastArgs = null;
  };
  return throttled;
};
var nativeRaf = typeof window != "undefined" ? window.requestAnimationFrame : (
  // eslint-disable-next-line @typescript-eslint/no-empty-function
  () => {
  }
);
raf.use = (impl) => nativeRaf = impl;
raf.now = typeof performance != "undefined" ? () => performance.now() : Date.now;
raf.batchedUpdates = (fn) => fn();
raf.catch = console.error;
raf.frameLoop = "always";
raf.advance = () => {
  if (raf.frameLoop !== "demand") {
    console.warn(
      "Cannot call the manual advancement of rafz whilst frameLoop is not set as demand"
    );
  } else {
    update();
  }
};
var ts = -1;
var pendingCount = 0;
var sync = false;
function schedule(fn, queue) {
  if (sync) {
    queue.delete(fn);
    fn(0);
  } else {
    queue.add(fn);
    start();
  }
}
function start() {
  if (ts < 0) {
    ts = 0;
    if (raf.frameLoop !== "demand") {
      nativeRaf(loop);
    }
  }
}
function stop() {
  ts = -1;
}
function loop() {
  if (~ts) {
    nativeRaf(loop);
    raf.batchedUpdates(update);
  }
}
function update() {
  const prevTs = ts;
  ts = raf.now();
  const count = findTimeout(ts);
  if (count) {
    eachSafely(timeouts.splice(0, count), (t) => t.handler());
    pendingCount -= count;
  }
  if (!pendingCount) {
    stop();
    return;
  }
  onStartQueue.flush();
  updateQueue.flush(prevTs ? Math.min(64, ts - prevTs) : 16.667);
  onFrameQueue.flush();
  writeQueue.flush();
  onFinishQueue.flush();
}
function makeQueue() {
  let next = /* @__PURE__ */ new Set();
  let current = next;
  return {
    add(fn) {
      pendingCount += current == next && !next.has(fn) ? 1 : 0;
      next.add(fn);
    },
    delete(fn) {
      pendingCount -= current == next && next.has(fn) ? 1 : 0;
      return next.delete(fn);
    },
    flush(arg) {
      if (current.size) {
        next = /* @__PURE__ */ new Set();
        pendingCount -= current.size;
        eachSafely(current, (fn) => fn(arg) && next.add(fn));
        pendingCount += next.size;
        current = next;
      }
    }
  };
}
function eachSafely(values, each2) {
  values.forEach((value) => {
    try {
      each2(value);
    } catch (e) {
      raf.catch(e);
    }
  });
}

// src/helpers.ts
function noop() {
}
var defineHidden = (obj, key, value) => Object.defineProperty(obj, key, { value, writable: true, configurable: true });
var is = {
  arr: Array.isArray,
  obj: (a) => !!a && a.constructor.name === "Object",
  fun: (a) => typeof a === "function",
  str: (a) => typeof a === "string",
  num: (a) => typeof a === "number",
  und: (a) => a === void 0
};
function isEqual(a, b) {
  if (is.arr(a)) {
    if (!is.arr(b) || a.length !== b.length)
      return false;
    for (let i = 0; i < a.length; i++) {
      if (a[i] !== b[i])
        return false;
    }
    return true;
  }
  return a === b;
}
var react_spring_shared_modern_each = (obj, fn) => obj.forEach(fn);
function eachProp(obj, fn, ctx) {
  if (is.arr(obj)) {
    for (let i = 0; i < obj.length; i++) {
      fn.call(ctx, obj[i], `${i}`);
    }
    return;
  }
  for (const key in obj) {
    if (obj.hasOwnProperty(key)) {
      fn.call(ctx, obj[key], key);
    }
  }
}
var toArray = (a) => is.und(a) ? [] : is.arr(a) ? a : [a];
function flush(queue, iterator) {
  if (queue.size) {
    const items = Array.from(queue);
    queue.clear();
    react_spring_shared_modern_each(items, iterator);
  }
}
var flushCalls = (queue, ...args) => flush(queue, (fn) => fn(...args));
var isSSR = () => typeof window === "undefined" || !window.navigator || /ServerSideRendering|^Deno\//.test(window.navigator.userAgent);

// src/globals.ts
var createStringInterpolator;
var to;
var colors = null;
var skipAnimation = false;
var willAdvance = noop;
var react_spring_shared_modern_assign = (globals) => {
  if (globals.to)
    to = globals.to;
  if (globals.now)
    raf.now = globals.now;
  if (globals.colors !== void 0)
    colors = globals.colors;
  if (globals.skipAnimation != null)
    skipAnimation = globals.skipAnimation;
  if (globals.createStringInterpolator)
    createStringInterpolator = globals.createStringInterpolator;
  if (globals.requestAnimationFrame)
    raf.use(globals.requestAnimationFrame);
  if (globals.batchedUpdates)
    raf.batchedUpdates = globals.batchedUpdates;
  if (globals.willAdvance)
    willAdvance = globals.willAdvance;
  if (globals.frameLoop)
    raf.frameLoop = globals.frameLoop;
};

// src/FrameLoop.ts
var startQueue = /* @__PURE__ */ new Set();
var currentFrame = [];
var prevFrame = [];
var priority = 0;
var frameLoop = {
  get idle() {
    return !startQueue.size && !currentFrame.length;
  },
  /** Advance the given animation on every frame until idle. */
  start(animation) {
    if (priority > animation.priority) {
      startQueue.add(animation);
      raf.onStart(flushStartQueue);
    } else {
      startSafely(animation);
      raf(advance);
    }
  },
  /** Advance all animations by the given time. */
  advance,
  /** Call this when an animation's priority changes. */
  sort(animation) {
    if (priority) {
      raf.onFrame(() => frameLoop.sort(animation));
    } else {
      const prevIndex = currentFrame.indexOf(animation);
      if (~prevIndex) {
        currentFrame.splice(prevIndex, 1);
        startUnsafely(animation);
      }
    }
  },
  /**
   * Clear all animations. For testing purposes.
   *
   * ☠️ Never call this from within the frameloop.
   */
  clear() {
    currentFrame = [];
    startQueue.clear();
  }
};
function flushStartQueue() {
  startQueue.forEach(startSafely);
  startQueue.clear();
  raf(advance);
}
function startSafely(animation) {
  if (!currentFrame.includes(animation))
    startUnsafely(animation);
}
function startUnsafely(animation) {
  currentFrame.splice(
    findIndex(currentFrame, (other) => other.priority > animation.priority),
    0,
    animation
  );
}
function advance(dt) {
  const nextFrame = prevFrame;
  for (let i = 0; i < currentFrame.length; i++) {
    const animation = currentFrame[i];
    priority = animation.priority;
    if (!animation.idle) {
      willAdvance(animation);
      animation.advance(dt);
      if (!animation.idle) {
        nextFrame.push(animation);
      }
    }
  }
  priority = 0;
  prevFrame = currentFrame;
  prevFrame.length = 0;
  currentFrame = nextFrame;
  return currentFrame.length > 0;
}
function findIndex(arr, test) {
  const index = arr.findIndex(test);
  return index < 0 ? arr.length : index;
}

// src/clamp.ts
var clamp = (min, max, v) => Math.min(Math.max(v, min), max);

// src/colors.ts
var colors2 = {
  transparent: 0,
  aliceblue: 4042850303,
  antiquewhite: 4209760255,
  aqua: 16777215,
  aquamarine: 2147472639,
  azure: 4043309055,
  beige: 4126530815,
  bisque: 4293182719,
  black: 255,
  blanchedalmond: 4293643775,
  blue: 65535,
  blueviolet: 2318131967,
  brown: 2771004159,
  burlywood: 3736635391,
  burntsienna: 3934150143,
  cadetblue: 1604231423,
  chartreuse: 2147418367,
  chocolate: 3530104575,
  coral: 4286533887,
  cornflowerblue: 1687547391,
  cornsilk: 4294499583,
  crimson: 3692313855,
  cyan: 16777215,
  darkblue: 35839,
  darkcyan: 9145343,
  darkgoldenrod: 3095792639,
  darkgray: 2846468607,
  darkgreen: 6553855,
  darkgrey: 2846468607,
  darkkhaki: 3182914559,
  darkmagenta: 2332068863,
  darkolivegreen: 1433087999,
  darkorange: 4287365375,
  darkorchid: 2570243327,
  darkred: 2332033279,
  darksalmon: 3918953215,
  darkseagreen: 2411499519,
  darkslateblue: 1211993087,
  darkslategray: 793726975,
  darkslategrey: 793726975,
  darkturquoise: 13554175,
  darkviolet: 2483082239,
  deeppink: 4279538687,
  deepskyblue: 12582911,
  dimgray: 1768516095,
  dimgrey: 1768516095,
  dodgerblue: 512819199,
  firebrick: 2988581631,
  floralwhite: 4294635775,
  forestgreen: 579543807,
  fuchsia: 4278255615,
  gainsboro: 3705462015,
  ghostwhite: 4177068031,
  gold: 4292280575,
  goldenrod: 3668254975,
  gray: 2155905279,
  green: 8388863,
  greenyellow: 2919182335,
  grey: 2155905279,
  honeydew: 4043305215,
  hotpink: 4285117695,
  indianred: 3445382399,
  indigo: 1258324735,
  ivory: 4294963455,
  khaki: 4041641215,
  lavender: 3873897215,
  lavenderblush: 4293981695,
  lawngreen: 2096890111,
  lemonchiffon: 4294626815,
  lightblue: 2916673279,
  lightcoral: 4034953471,
  lightcyan: 3774873599,
  lightgoldenrodyellow: 4210742015,
  lightgray: 3553874943,
  lightgreen: 2431553791,
  lightgrey: 3553874943,
  lightpink: 4290167295,
  lightsalmon: 4288707327,
  lightseagreen: 548580095,
  lightskyblue: 2278488831,
  lightslategray: 2005441023,
  lightslategrey: 2005441023,
  lightsteelblue: 2965692159,
  lightyellow: 4294959359,
  lime: 16711935,
  limegreen: 852308735,
  linen: 4210091775,
  magenta: 4278255615,
  maroon: 2147483903,
  mediumaquamarine: 1724754687,
  mediumblue: 52735,
  mediumorchid: 3126187007,
  mediumpurple: 2473647103,
  mediumseagreen: 1018393087,
  mediumslateblue: 2070474495,
  mediumspringgreen: 16423679,
  mediumturquoise: 1221709055,
  mediumvioletred: 3340076543,
  midnightblue: 421097727,
  mintcream: 4127193855,
  mistyrose: 4293190143,
  moccasin: 4293178879,
  navajowhite: 4292783615,
  navy: 33023,
  oldlace: 4260751103,
  olive: 2155872511,
  olivedrab: 1804477439,
  orange: 4289003775,
  orangered: 4282712319,
  orchid: 3664828159,
  palegoldenrod: 4008225535,
  palegreen: 2566625535,
  paleturquoise: 2951671551,
  palevioletred: 3681588223,
  papayawhip: 4293907967,
  peachpuff: 4292524543,
  peru: 3448061951,
  pink: 4290825215,
  plum: 3718307327,
  powderblue: 2967529215,
  purple: 2147516671,
  rebeccapurple: 1714657791,
  red: 4278190335,
  rosybrown: 3163525119,
  royalblue: 1097458175,
  saddlebrown: 2336560127,
  salmon: 4202722047,
  sandybrown: 4104413439,
  seagreen: 780883967,
  seashell: 4294307583,
  sienna: 2689740287,
  silver: 3233857791,
  skyblue: 2278484991,
  slateblue: 1784335871,
  slategray: 1887473919,
  slategrey: 1887473919,
  snow: 4294638335,
  springgreen: 16744447,
  steelblue: 1182971135,
  tan: 3535047935,
  teal: 8421631,
  thistle: 3636451583,
  tomato: 4284696575,
  turquoise: 1088475391,
  violet: 4001558271,
  wheat: 4125012991,
  white: 4294967295,
  whitesmoke: 4126537215,
  yellow: 4294902015,
  yellowgreen: 2597139199
};

// src/colorMatchers.ts
var NUMBER = "[-+]?\\d*\\.?\\d+";
var PERCENTAGE = NUMBER + "%";
function call(...parts) {
  return "\\(\\s*(" + parts.join(")\\s*,\\s*(") + ")\\s*\\)";
}
var rgb = new RegExp("rgb" + call(NUMBER, NUMBER, NUMBER));
var rgba = new RegExp("rgba" + call(NUMBER, NUMBER, NUMBER, NUMBER));
var hsl = new RegExp("hsl" + call(NUMBER, PERCENTAGE, PERCENTAGE));
var hsla = new RegExp(
  "hsla" + call(NUMBER, PERCENTAGE, PERCENTAGE, NUMBER)
);
var hex3 = /^#([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/;
var hex4 = /^#([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/;
var hex6 = /^#([0-9a-fA-F]{6})$/;
var hex8 = /^#([0-9a-fA-F]{8})$/;

// src/normalizeColor.ts
function normalizeColor(color) {
  let match;
  if (typeof color === "number") {
    return color >>> 0 === color && color >= 0 && color <= 4294967295 ? color : null;
  }
  if (match = hex6.exec(color))
    return parseInt(match[1] + "ff", 16) >>> 0;
  if (colors && colors[color] !== void 0) {
    return colors[color];
  }
  if (match = rgb.exec(color)) {
    return (parse255(match[1]) << 24 | // r
    parse255(match[2]) << 16 | // g
    parse255(match[3]) << 8 | // b
    255) >>> // a
    0;
  }
  if (match = rgba.exec(color)) {
    return (parse255(match[1]) << 24 | // r
    parse255(match[2]) << 16 | // g
    parse255(match[3]) << 8 | // b
    parse1(match[4])) >>> // a
    0;
  }
  if (match = hex3.exec(color)) {
    return parseInt(
      match[1] + match[1] + // r
      match[2] + match[2] + // g
      match[3] + match[3] + // b
      "ff",
      // a
      16
    ) >>> 0;
  }
  if (match = hex8.exec(color))
    return parseInt(match[1], 16) >>> 0;
  if (match = hex4.exec(color)) {
    return parseInt(
      match[1] + match[1] + // r
      match[2] + match[2] + // g
      match[3] + match[3] + // b
      match[4] + match[4],
      // a
      16
    ) >>> 0;
  }
  if (match = hsl.exec(color)) {
    return (hslToRgb(
      parse360(match[1]),
      // h
      parsePercentage(match[2]),
      // s
      parsePercentage(match[3])
      // l
    ) | 255) >>> // a
    0;
  }
  if (match = hsla.exec(color)) {
    return (hslToRgb(
      parse360(match[1]),
      // h
      parsePercentage(match[2]),
      // s
      parsePercentage(match[3])
      // l
    ) | parse1(match[4])) >>> // a
    0;
  }
  return null;
}
function hue2rgb(p, q, t) {
  if (t < 0)
    t += 1;
  if (t > 1)
    t -= 1;
  if (t < 1 / 6)
    return p + (q - p) * 6 * t;
  if (t < 1 / 2)
    return q;
  if (t < 2 / 3)
    return p + (q - p) * (2 / 3 - t) * 6;
  return p;
}
function hslToRgb(h, s, l) {
  const q = l < 0.5 ? l * (1 + s) : l + s - l * s;
  const p = 2 * l - q;
  const r = hue2rgb(p, q, h + 1 / 3);
  const g = hue2rgb(p, q, h);
  const b = hue2rgb(p, q, h - 1 / 3);
  return Math.round(r * 255) << 24 | Math.round(g * 255) << 16 | Math.round(b * 255) << 8;
}
function parse255(str) {
  const int = parseInt(str, 10);
  if (int < 0)
    return 0;
  if (int > 255)
    return 255;
  return int;
}
function parse360(str) {
  const int = parseFloat(str);
  return (int % 360 + 360) % 360 / 360;
}
function parse1(str) {
  const num = parseFloat(str);
  if (num < 0)
    return 0;
  if (num > 1)
    return 255;
  return Math.round(num * 255);
}
function parsePercentage(str) {
  const int = parseFloat(str);
  if (int < 0)
    return 0;
  if (int > 100)
    return 1;
  return int / 100;
}

// src/colorToRgba.ts
function colorToRgba(input) {
  let int32Color = normalizeColor(input);
  if (int32Color === null)
    return input;
  int32Color = int32Color || 0;
  const r = (int32Color & 4278190080) >>> 24;
  const g = (int32Color & 16711680) >>> 16;
  const b = (int32Color & 65280) >>> 8;
  const a = (int32Color & 255) / 255;
  return `rgba(${r}, ${g}, ${b}, ${a})`;
}

// src/createInterpolator.ts
var createInterpolator = (range, output, extrapolate) => {
  if (is.fun(range)) {
    return range;
  }
  if (is.arr(range)) {
    return createInterpolator({
      range,
      output,
      extrapolate
    });
  }
  if (is.str(range.output[0])) {
    return createStringInterpolator(range);
  }
  const config = range;
  const outputRange = config.output;
  const inputRange = config.range || [0, 1];
  const extrapolateLeft = config.extrapolateLeft || config.extrapolate || "extend";
  const extrapolateRight = config.extrapolateRight || config.extrapolate || "extend";
  const easing = config.easing || ((t) => t);
  return (input) => {
    const range2 = findRange(input, inputRange);
    return interpolate(
      input,
      inputRange[range2],
      inputRange[range2 + 1],
      outputRange[range2],
      outputRange[range2 + 1],
      easing,
      extrapolateLeft,
      extrapolateRight,
      config.map
    );
  };
};
function interpolate(input, inputMin, inputMax, outputMin, outputMax, easing, extrapolateLeft, extrapolateRight, map) {
  let result = map ? map(input) : input;
  if (result < inputMin) {
    if (extrapolateLeft === "identity")
      return result;
    else if (extrapolateLeft === "clamp")
      result = inputMin;
  }
  if (result > inputMax) {
    if (extrapolateRight === "identity")
      return result;
    else if (extrapolateRight === "clamp")
      result = inputMax;
  }
  if (outputMin === outputMax)
    return outputMin;
  if (inputMin === inputMax)
    return input <= inputMin ? outputMin : outputMax;
  if (inputMin === -Infinity)
    result = -result;
  else if (inputMax === Infinity)
    result = result - inputMin;
  else
    result = (result - inputMin) / (inputMax - inputMin);
  result = easing(result);
  if (outputMin === -Infinity)
    result = -result;
  else if (outputMax === Infinity)
    result = result + outputMin;
  else
    result = result * (outputMax - outputMin) + outputMin;
  return result;
}
function findRange(input, inputRange) {
  for (var i = 1; i < inputRange.length - 1; ++i)
    if (inputRange[i] >= input)
      break;
  return i - 1;
}

// src/easings.ts
var steps = (steps2, direction = "end") => (progress2) => {
  progress2 = direction === "end" ? Math.min(progress2, 0.999) : Math.max(progress2, 1e-3);
  const expanded = progress2 * steps2;
  const rounded = direction