# Contributing to Twenty Sixteen
Hey, it’s really great you want to contribute to the new default theme for the WordPress 4.4 release! Before you dive right in, we have a few pointers on how to contribute.

## How it works
Unlike previous default themes, Twenty Sixteen will remain on GitHub. As a result, the process is a little different. The theme is synced to the WordPress.org theme repository every night. It is also bundled with WordPress 4.4 from beta onwards.

## Reporting an issue
Twenty Sixteen should have all issues reported on GitHub at https://github.com/WordPress/twentysixteen/. We are not using trac for issue reporting.

## Best Practices
Whatever you add, make sure you keep to the theme review handbook guidelines here: https://make.wordpress.org/themes/handbook/review/required/.

### Commit Messages
Here are some good ideas for commit messages:
- Keep them to a one line summary.
- Keep them short (50 chars or less).
- Make them relevant to the commit.

## Commit Process
All changes happen through a pull request made by contributors, ideally associated with an issue. After you send your proposed changes, one of the committers will review and test. After that we can merge them in.

When you add a pull request, please also add in the description your WordPress.org username. We will then add it to CONTRIBUTORS.md. This is a running list of all contributors and essential to give everyone that has helped make this project props in core still.
