#pragma interface
#ifndef VUTIL_H
#define VUTIL_H

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <string>
#include <set>
#include <algorithm>
#include <iostream>
#include <list>

using namespace std;

extern int debug;
extern bool testmode;

// Patch to help compile this utility on unpatched kernel source
#ifndef EXT2_IMMUTABLE_FILE_FL
	#define EXT2_IMMUTABLE_FILE_FL		0x00000010
	#define EXT2_IMMUTABLE_LINK_FL24	0x00008000
	#define EXT2_IMMUTABLE_LINK_FL		0x08000000
	#define EXT2_IBARRIER_FL24			0x04000000
	#define EXT2_IBARRIER_FL				0x04000000
#endif


FILE *vutil_execdistcmd (const char *, const string &, const char *);
extern const char K_DUMPFILES[];
extern const char K_UNIFILES[];
extern const char K_PKGVERSION[];

class PACKAGE{
public:
	string name;
	string version;	// version + release
	PACKAGE(string &_name, string &_version)
		: name (_name), version(_version)
	{
	}
	PACKAGE(const char *_name, const char *_version)
		: name (_name), version(_version)
	{
	}
	PACKAGE(const string &line)
	{
		*this = line;
	}
	PACKAGE & operator = (const string &_line)
	{
		string line (_line);
		string::iterator pos = find (line.begin(),line.end(),'=');
		if (pos != line.end()){
			name = string(line.begin(),pos);
			version = string(pos + 1,line.end());
		}
		return *this;
	}
	PACKAGE (const PACKAGE &pkg)
	{
		name = pkg.name;
		version = pkg.version;
	}
	bool operator == (const PACKAGE &v) const
	{
		return name == v.name && version == v.version;
	}
	bool operator < (const PACKAGE &v) const
	{
		bool ret = false;
		if (name < v.name){
			ret = true;
		}else if (name == v.name && version < v.version){
			ret = true;
		}
		return ret;
	}
	// Load the file member of the package, but exclude configuration file
	void loadfiles(const string &ref, set<string> &files)
	{
		if (debug > 2) cout << "Loading files for package " << name << endl;
		string namever = name + '-' + version;
		FILE *fin = vutil_execdistcmd (K_UNIFILES,ref,namever.c_str());
		if (fin != NULL){
			char tmp[1000];
			while (fgets(tmp,sizeof(tmp)-1,fin)!=NULL){
				int last = strlen(tmp)-1;
				if (last >= 0 && tmp[last] == '\n') tmp[last] = '\0';
				files.insert (tmp);
			}
			pclose (fin);
		}
		if (debug > 2) cout << "Done\n";
	}
	#if 0
	bool locate(const string &path)
	{
		return find (files.begin(),files.end(),path) != files.end();
	}
	#endif
};

// Check if two package have the same name (but potentially different version)
class same_name{
	const PACKAGE &pkg;
public:
	same_name(const PACKAGE &_pkg) : pkg(_pkg) {}
	bool operator()(const PACKAGE &p)
	{
		return pkg.name == p.name;
	}
};


struct VSERVER_CONF{
	string vserversroot;
	string vserverdir;
	string iproot;
	string iprootdev;
	string iprootmask;
	bool onboot;
	string s_flags;
	string s_hostname;
	string s_domainname;
	string s_caps;
	int priority;
	int s_nice;
};


#include "vutil.p"

#endif

