#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>
#include <string>

using namespace std;

static int vdu_onedir (const string &path, long long &size)
{
	int ret = -1;
	int dirfd = open (path.c_str(),O_RDONLY);	// A handle to speed up
												// chdir
	if (dirfd == -1){
		fprintf (stderr,"Can't open directory %s (%s)\n",path.c_str()
			,strerror(errno));
	}else{
		fchdir (dirfd);
		DIR *dir = opendir (".");
		if (dir == NULL){
			fprintf (stderr,"Can't open (opendir) directory %s (%s)\n",path.c_str()
				,strerror(errno));
		}else{
			struct stat64 dirst;
			lstat64 (".",&dirst);
			ret = 0;
			struct dirent *ent;
			long long dirsize = 0;
			while ((ent=readdir(dir))!=NULL){
				struct stat64 st;
				if (lstat64(ent->d_name,&st)==-1){
					fprintf (stderr,"Can't stat %s/%s (%s)\n",path.c_str()
						,ent->d_name,strerror(errno));
					ret = -1;
					break;
				}else if (S_ISREG(st.st_mode)){
					if (st.st_nlink == 1){
						dirsize += st.st_size;
					}
				}else if (S_ISDIR(st.st_mode) && st.st_dev == dirst.st_dev){
					if (strcmp(ent->d_name,".")!=0
						&& strcmp(ent->d_name,"..")!=0){
						ret = vdu_onedir(path + "/" + ent->d_name,dirsize);
						fchdir (dirfd);
					}
				}
			}
			closedir (dir);
			size += dirsize;
		}
		close (dirfd);
	}
	return ret;
}

int main (int argc, char *argv[])
{
	int ret = -1;
	if (argc < 2){
		fprintf (stderr,"vdu version %s\n",VERSION);
		fprintf (stderr,"vdu directory ...\n\n");
		fprintf (stderr
			,"Compute the size of a directory tree, ignoring files\n"
			 "with more than one link.\n");
	}else{
		ret = 0;
		for (int i=1; i<argc && ret != -1; i++){
			long long size = 0;
			ret = vdu_onedir (string(argv[i]),size);
			long ksize = size >> 10;
			printf ("%s\t%ldK\n",argv[i],ksize);
		}
	}
	return ret;
}

