#include "linux/vswitch.h"
#include <errno.h>
#include <asm/unistd.h>
#define _UNISTD_H
#ifndef PROTO_SKIP
extern "C" long int syscall (long int __sysno, ...) __THROW;
#endif
#include <linux/unistd.h>
#include "old_syscall.p"
#include <stdio.h>

#ifndef __NR_vserver
#  define __NR_vserver	273
#endif

static enum KERNEL_TYPE{
	K_UNKNOWN,	// Do not support vserver at all
	K_NEW,		// New vserver kernel
	K_OLD		// Old vserver kernel
} state = K_UNKNOWN;


_syscall3(int, vserver, uint32_t, cmd, uint32_t, id, void *, data);


static void init()
{
	if (state == K_UNKNOWN){
		int ret = vserver (VCMD_get_version,0,NULL);
		if (ret == -1){
			state = K_OLD;
		}else{
			state = K_NEW;
		}
	}
}
	

extern "C" int call_new_s_context(int nbctx, int ctxs[], unsigned int remove_cap, unsigned int flags)
{
	int ret = -1;
	init();
	if (state == K_NEW){
		vcmd_new_s_context_v1 data;
		data.remove_cap = remove_cap;
		data.flags = flags;
		ret = vserver (VCMD_new_s_context,nbctx==0 ? -2 : ctxs[0],&data);
	}else{
		ret = call_old_new_s_context (nbctx,ctxs,remove_cap,flags);
	}
	return ret;
}

extern "C" int call_set_ipv4root(
	unsigned long ip[],
	int nb,
	unsigned long bcast,
	unsigned long mask[])
{
	int ret = -1;
	init();
	if (state == K_NEW){
		vcmd_set_ipv4root_v3 data;
		data.broadcast = bcast;
		for (int i=0; i<nb && i <NB_IPV4ROOT; i++){
			data.ip_mask_pair[i].ip = ip[i];
			data.ip_mask_pair[i].mask = mask[i];
		}
		ret = vserver (VCMD_set_ipv4root,nb,&data);
	}else{
		ret = call_old_set_ipv4root(ip,nb,bcast,mask);
	}
	return ret;
}

extern "C" int call_set_ctxlimit (int res, long lim)
{
	int ret = -1;
	init();
	if (state == K_NEW){
		vcmd_ctx_rlimit_v0 data;
		data.id = res;
		data.minimum = 0;
		data.softlimit = lim;
		data.maximum = lim;
		ret = vserver (VCMD_set_rlimit,0,&data);
	}else if (state == K_OLD){
		ret = call_old_set_ctxlimit (res,lim);
	}
	return ret;
}

