#!/bin/sh
# This is a simple script to evaluate the concept of
# synthetic vservers.
# Synthetic vservers are vservers created from scratch at every
# startup by combining the following
#	-Files from another vserver or the root server
#	-Configuration files
#	-Work area (data directory)

# The current script assumes the following directory exists
# /etcs: It contains one directory per vserver, holding the
#        file unique to this vserver. They are copied over the
#		 /etc files for the reference vserver (BUILDFROM)
# /datas: Has one directory per vserver. This directory will
#		  be mapped into the vserver world as directory /data
USR_LIB_VSERVER=/usr/lib/vserver
USR_SBIN=/usr/sbin
VSYNTH=/vsynth

vserver_mknod()
{
	mknod $1 $2 $3 $4
	chmod $5 $1
}

setupdir(){
	for sub in lib lib64 sbin bin usr
	do
		if [ -d $2/$sub ] ; then
			mkdir -p $1/$sub
			mount --bind $2/$sub $1/$sub
		fi
	done
	mkdir -p $1/proc $1/dev/pts $1/etc $1/home $1/root
	mkdir -p $1/tmp
	chmod 1777 $1/tmp
	cp -ax $2/etc/. $1/etc/.
}

setupdev(){
	VROOT=$1
	vserver_mknod $VROOT/dev/null c 1 3 666
	vserver_mknod $VROOT/dev/zero c 1 5 666
	vserver_mknod $VROOT/dev/full c 1 7 666
	vserver_mknod $VROOT/dev/random c 1 8 644
	vserver_mknod $VROOT/dev/urandom c 1 9 644
	vserver_mknod $VROOT/dev/tty c 5 0 666
	vserver_mknod $VROOT/dev/ptmx c 5 2 666
	# We fake this device to help some package managers
	touch $VROOT/dev/hdv1
}

setupdata(){
	if [ -d $VSYNTH/datas/$1 ] ; then
		echo Linking $VSYNTH/datas/$1 to /data
		mkdir -p $2/data
		mount --bind $VSYNTH/datas/$1 $2/data
	else
		echo No directory in $VSYNTH/datas/$1
	fi
}
setuphome(){
	if [ -d $VSYNTH/homes/$1 ] ; then
		echo Linking $VSYNTH/homes/$1 to /home
		mkdir -p $2/home
		mount --bind $VSYNTH/homes/$1 $2/home
	else
		echo No directory in $VSYNTH/homes/$1
	fi
}

setupetc(){
	if [ -d $VSYNTH/etcs/$1 ]; then
		echo Copying $VSYNTH/etcs/$1 to /etc
		cp -a $VSYNTH/etcs/$1/. $2/etc/.
	else
		echo No directory $VSYNTH/etcs/$1: Probably wrong
	fi
}

setupvar(){
	if [ -d $VSYNTH/var/$1 ]; then
		echo Linking $VSYNTH/vars/$1 to /var
		mkdir -p $2/home
		mount --bind $VSYNTH/vars/$1 $2/var
	else
		echo No directory $VSYNTH/vars/$1, building a /var skeleton
		mkdir -p $2/var
		$USR_LIB_VSERVER/copytree /var $2/var
	fi
}

# Run some config tasks
runtasks(){
	if [ -d "$VSYNTH/etcs/$1/assemble.d" ] ;then
		cd $VSYNTH/etcs/$1/assemble.d
		for cmd in *
		do
			echo Running /etc/assemble.d/$cmd
			$USR_SBIN/vserver --silent $1 exec /etc/assemble.d/$cmd
		done
	else
		echo No assembly script found in $VSYNTH/etcs/$1/assemble.d
	fi
}

unsetupdir(){
	for sub in lib lib64 sbin bin usr dev/pts proc data home
	do
		umount $1/$sub 2>/dev/null
	done
}

if [ "$1" = "--assemble" ] ; then
	eval `$USR_LIB_VSERVER/printconf.sh --quote $2`
	FROM=$3
	if [ "$FROM" = "/" ] ; then
		# Useful to try vservers, not secure
		echo Assembling a vserver from / is not secure, for testing only
		echo Do not modify packages...
		echo
		setupdir $VSERVERDIR /
		setupdev $VSERVERDIR
		setupetc $2 $VSERVERDIR
		setupdata $2 $VSERVERDIR
		setuphome $2 $VSERVERDIR
		setupvar $2 $VSERVERDIR
		runtasks $2
	else
		eval `$USR_LIB_VSERVER/printconf.sh --quote $3`
		REFVDIR=$VSERVERDIR
		eval `$USR_LIB_VSERVER/printconf.sh --quote $2`
		setupdir $VSERVERDIR $REFVDIR
		setupdev $VSERVERDIR
		setupetc $2 $VSERVERDIR
		setupdata $2 $VSERVERDIR
		setuphome $2 $VSERVERDIR
		setupvar $2 $VSERVERDIR
		runtasks $2
	fi
elif [ "$1" = "--remove" ] ; then
	eval `$USR_LIB_VSERVER/printconf.sh --quote $2`
	unsetupdir $VSERVERDIR	
	rm -fr $VSERVERDIR
else
	echo $0 --assemble or --remove
	exit 1
fi

