#!/bin/sh
# Complete the installation of a vserver
USR_LIB_VSERVER=/usr/lib/vserver
ETC_VSERVERS=/etc/vservers
vserver_mknod()
{
	mknod $1 $2 $3 $4
	chmod $5 $1
}

if [ $# != 1 ] ; then
	echo install-post.sh vserver
else
	test -f $ETC_VSERVERS/$1.conf || cp $USR_LIB_VSERVER/sample.conf $ETC_VSERVERS/$1.conf
	test -f $ETC_VSERVERS/$1.sh   || cp $USR_LIB_VSERVER/sample.sh $ETC_VSERVERS/$1.sh
	eval `$USR_LIB_VSERVER/printconf.sh --quote $1`
	VROOT="$VSERVERDIR"
	rm -fr "$VROOT/dev"
	mkdir "$VROOT/dev" && chmod 755 "$VROOT/dev"
	mkdir "$VROOT/dev/pts"
	vserver_mknod "$VROOT/dev/null" c 1 3 666
	vserver_mknod "$VROOT/dev/zero" c 1 5 666
	vserver_mknod "$VROOT/dev/full" c 1 7 666
	vserver_mknod "$VROOT/dev/random" c 1 8 644
	vserver_mknod "$VROOT/dev/urandom" c 1 9 644
	vserver_mknod "$VROOT/dev/tty" c 5 0 666
	vserver_mknod "$VROOT/dev/ptmx" c 5 2 666
	if [ -f $VROOT/etc/sysconfig/network ] ; then
		echo NETWORKING=yes >"$VROOT/etc/sysconfig/network"
		echo HOSTNAME=$1 >>"$VROOT/etc/sysconfig/network"
	fi
	rm -f $VROOT/etc/localtime
	cp -a /etc/localtime $VROOT/etc
	rm -f $VROOT/etc/resolv.conf
	cp -a /etc/resolv.conf $VROOT/etc/resolv.conf
	(
		LEVEL="--level 2345"
		if [ -f $VROOT/etc/SuSE-release ] ; then
			LEVEL=
		fi
		cd $VROOT/etc/rc.d/init.d || cd $VROOT/etc/init.d
		for serv in *
		do
			case $serv in
			*.bak|*~|functions|killall|halt|single)
				;;
			*)
				$USR_LIB_VSERVER/capchroot "$VROOT" /sbin/chkconfig $LEVEL $serv off
				;;
			esac
		done
		rm -f "$VROOT"/etc/rc.d/rc6.d/S*reboot
	)
	if [ ! -f "$VROOT/etc/fstab" ] ; then
		echo /dev/hdv1	/	ext2	defaults	1	1 >"$VROOT/etc/fstab"
		echo /dev/hdv1	/	ext2	rw	1	1 >"$VROOT/etc/mtab"
	fi
	cp -a $USR_LIB_VSERVER/vreboot $VROOT/sbin/.
	ln -sf vreboot $VROOT/sbin/vhalt
	if [ -x $ETC_VSERVERS/install-post.sh ]; then
		$ETC_VSERVERS/install-post.sh $VROOT
	fi
fi

