#!/bin/sh
USR_LIB_VSERVER=/usr/lib/vserver
USR_SBIN=/usr/sbin

vserver_mknod(){
	if [ ! -e $1 ] ; then
		mknod $1 $2 $3 $4
		chmod $5 $1
	fi
}

turnoff_services(){
	# Turn off some service useless on a vserver
	#		vserver_turnoff apmd network autofs dhcpd gpm ipchains iptables \
	#			irda isdn keytable kudzu linuxconf-setup netfs nfs nfslock \
	#			pcmcia portmap pppoe random rawdevices rhnsd rstatd ruserd \
	#			rwalld rwhod sendmail smb snmpd v_httpd h_xinetd v_sshd vservers \
	#			xfs ypbind xinetd
	(
		cd etc/init.d 2>/dev/null || cd etc/rc.d/init.d
		for serv in *
		do
			case $serv in
			*.bak|*~|functions|killall|halt|single)
				;;
			*)
				#$USR_LIB_VSERVER/capchroot $VSERVERS_ROOT/$1 /sbin/chkconfig --level 2345 $serv off
				$USR_SBIN/vserver --silent $1 chkconfig --level 2345 $serv off
				;;
			esac
		done
	)
}

. /etc/vservers.conf

# Either the directory does not exist or is empty
NBSUB=`ls $VSERVERS_ROOT/$1 2>/dev/null | grep -v lost+found | wc -l` 
NBSUB=`expr $NBSUB`
if [ "$NBSUB" != 0 -a "$2" != "force" ] ; then
	echo Virtual server $VSERVERS_ROOT/$1 already exist >&2
else
	if [ ! -d $VSERVERS_ROOT ] ; then
		mkdir $VSERVERS_ROOT || exit 1
		chmod 000 $VSERVERS_ROOT
		echo Directory $VSERVERS_ROOT was created with permissions 000
	fi
	VDIR=$VSERVERS_ROOT/$1
	mkdir -p $VDIR || exit 1
	chmod 755 $VDIR
	cp -ax /sbin /bin /etc /usr /lib $VDIR/. || exit 1
	mkdir $VDIR/var
	$USR_LIB_VSERVER/copytree /var $VDIR/var
	if [ -d /var/lib/rpm ] ; then
		cp -ax /var/lib/rpm/. $VDIR/var/lib/rpm/.
	fi
	if [ -d /lib64 ] ; then
		cp -ax /lib64 $VDIR/. || exit 1
	fi
	cd $VDIR || exit 1
	rm -fr lib/modules/*
	touch var/log/wtmp
	rm -f etc/cron.d/kmod
	mkdir proc tmp home root boot
	test -f /root/.bashrc && cp -a /root/.bashrc root/.
	test -f /root/.bash_profile && cp -a /root/.bash_profile root/.
	chmod 1777 tmp
	chmod 750 root
	# Create a minimal dev so the virtual server can't grab
	# more privileges
	mkdir -p dev dev/pts
	vserver_mknod dev/null c 1 3 666
	vserver_mknod dev/zero c 1 5 666
	vserver_mknod dev/full c 1 7 666
	vserver_mknod dev/random c 1 8 644
	vserver_mknod dev/urandom c 1 9 644
	vserver_mknod dev/tty c 5 0 666
	vserver_mknod dev/ptmx c 5 2 666
	touch dev/hdv1
	rm -f etc/rc.d/rc6.d/S*reboot
	# Create a dummy /etc/fstab and /etc/mtab to please
	# df and linuxconf. We use hdv1, which does not exist
	# to remind the admin that it is not the real drive
	echo /dev/hdv1 / ext2 defaults 1 1 >etc/fstab
	echo /dev/hdv1 / ext2 rw 0 0 >etc/mtab
	# Install the vreboot utility
	cp -a $USR_LIB_VSERVER/vreboot sbin/.
	ln -sf vreboot sbin/vhalt

	echo Directory $VSERVERS_ROOT/$1 has been populated
	if [ ! -d /etc/vservers ] ; then
		mkdir /etc/vservers
		chmod 600 /etc/vservers
		echo Directory /etc/vservers has been created
	fi
	CONF=/etc/vservers/$1.conf
	if [ ! -f $CONF ] ; then
		cat >$CONF <<-EOF
source /etc/vservers.conf
if [ "$PROFILE" = "" ] ; then
	PROFILE=prod
fi
# Select the IP number assigned to the virtual server
# This IP must be one IP of the server, either an interface
# or an IP alias
# A vserver may have more than one IP. Separate them with spaces.
# do not forget double quotes.
# Some examples:
# IPROOT="1.2.3.4 2.3.4.5"
# IPROOT="eth0:1.2.3.4 eth1:2.3.4.5"
# If the device is not specified, IPROOTDEV is used
case \$PROFILE in
prod)
	IPROOT=1.2.3.4
	# The netmask and broadcast are computed by default from IPROOTDEV
	#IPROOTMASK=
	#IPROOTBCAST=
	# You can define on which device the IP alias will be done
	# The IP alias will be set when the server is started and unset
	# when the server is stopped
	#IPROOTDEV=eth0
	# You can set a different host name for the vserver
	# If empty, the host name of the main server is used
	S_HOSTNAME=
	;;
backup)
	IPROOT=1.2.3.4
	#IPROOTMASK=
	#IPROOTBCAST=
	#IPROOTDEV=eth0
	S_HOSTNAME=
	;;
esac
# Uncomment the onboot line if you want to enable this
# virtual server at boot time
#ONBOOT=yes
# You can set a different NIS domain for the vserver
# If empty, the current on is kept
# Set it to "none" to have no NIS domain set
S_DOMAINNAME=
# You can set the priority level (nice) of all process in the vserver
# Even root won't be able to raise it
S_NICE=
# You can set various flags for the new security context
# lock: Prevent the vserver from setting new security context
# sched: Merge scheduler priority of all processes in the vserver
#        so that it acts a like a single one.
# nproc: Limit the number of processes in the vserver according to ulimit
#        (instead of a per user limit, this becomes a per vserver limit)
# private: No other process can join this security context. Even root
# Do not forget the quotes around the flags
S_FLAGS="lock nproc"
# You can set various ulimit flags and they will be inherited by the
# vserver. You enter here various command line argument of ulimit
# ULIMIT="-H -u 200"
# The example above, combined with the nproc S_FLAGS will limit the
# vserver to a maximum of 200 processes
ULIMIT="-HS -u 1000"
# You can set various capabilities. By default, the vserver are run
# with a limited set, so you can let root run in a vserver and not
# worry about it. He can't take over the machine. In some cases
# you can to give a little more capabilities (such as CAP_NET_RAW)
# S_CAPS="CAP_NET_RAW"
S_CAPS=""
# Select an unused context (this is optional)
# The default is to allocate a free context on the fly
# In general you don't need to force a context
#S_CONTEXT=
		EOF
		echo $CONF has been created. Look at it\!
	fi
	turnoff_services $1
fi

