Summary: Linux virtual server utilities
Name: vserver
Version: PACKAGE_REV
Release: 1
Vendor: Solucorp
Copyright: GPL
Group: system
Source: ftp://ftp.solucorp.qc.ca/pub/miscprj/vserver/vserver-PACKAGE_REV.src.tar.gz
BuildRoot: /tmp/vserver-root
Packager: Jacques Gelinas <jack@solucorp.qc.ca>

%description
This provides the components and a framework to setup virtual servers.
A virtual server runs inside a linux server. It is nevertheless highly
independant. As such, you can run various services with normal
configuration. The various vservers can't interact with each other
and can't interact with services in the main server.

This requires a special kernel supporting the new new_s_context and
set_ipv4root system call.

%prep
%setup

%build
make

%install
if [ "$RPM_BUILD_ROOT" != "" -a "$RPM_BUILD_ROOT" != "/" ] ; then
	rm -rf $RPM_BUILD_ROOT
fi
export RPM_BUILD_ROOT
make MANDIR=%_mandir install

%clean
if [ "$RPM_BUILD_ROOT" != "" -a "$RPM_BUILD_ROOT" != "/" ] ; then
	rm -rf $RPM_BUILD_ROOT
fi

%files
%defattr(-,root,root)
/usr/sbin/chbind
/usr/sbin/chcontext
/usr/sbin/rebootmgr
/usr/sbin/reducecap
/usr/sbin/vps
/usr/sbin/vpstree
/usr/sbin/vrpm
/usr/sbin/vserver
/usr/sbin/vserver-copy
/usr/sbin/vserver-stat
/usr/sbin/vtop 
/usr/sbin/vnetstat
/usr/sbin/vkill
/usr/sbin/vdu
/usr/sbin/vfiles
/usr/sbin/setctxlimit
#/usr/sbin/vprofile
/usr/lib/vserver
%config /etc/init.d/vservers
%config /etc/init.d/rebootmgr
%config /etc/init.d/v_*
%config /etc/vservers/newvserver.defaults
%config /etc/vservers.conf
%doc README
%doc LICENSE
%doc %_mandir/man8/*
%doc %_mandir/man5/*
%doc doc/changelog.txt
%doc doc/intro.txt
%doc doc/FAQ.txt

%package admin
Summary: Administration tools for vservers
Group: system
Requires: linuxconf-lib
Requires: linuxconf-util
autoreqprov: false
%description admin
This provides the newvserver tool to help setup a new vserver.
This tool is written using shellmod, which is part of the Linuxconf
project. Optionally, you may want to install the linuxconf-gui package.
If installed, newvserver works both in text mode and graphical mode.

%files admin
%defattr(-,root,root)
/usr/sbin/newvserver

%post admin
if [ "$1" = 1 ] ; then
	CTRL=/usr/lib/linuxconf/lib/shellmod-control
	test -x $CTRL && $CTRL --setmod /usr/sbin/newvserver
fi

%postun admin
if [ "$1" = 0 ] ; then
	CTRL=/usr/lib/linuxconf/lib/shellmod-control
	test -x $CTRL && $CTRL --unsetmod /usr/sbin/newvserver
fi

