#!/bin/bash
# Source a sh-style configuration file and prints the result
# in an easy program parseable way (VAR=VALUE, without quotes)
# This script also try to normalise some values to simplify other tools.
# For example, the variables expecting a yes or no are case insensitive
# and printconf.sh will always report them as yes or no in lower case.

USR_LIB_VSERVER=/usr/lib/vserver

Q=
ONLYVALUE=no
while true
do
	if [ "$1" == "--quote" ] ; then
		Q='"'
		shift
	elif [ "$1" == "--onlyvalue" ] ; then
		ONLYVALUE=yes
		shift
	else
		break
	fi
done

printvar(){
	VAR=$1
	shift
	if [ "$ONLYVALUE" = "yes" ] ; then
		echo $Q$*$Q
	else
		echo $VAR=$Q$*$Q
	fi
}

printyesno(){
	value="$2"
	case $2 in
	YES|Yes|yes|On|ON|on)
		value=yes
		;;
	*)
		value=no
		;;
	esac
	printvar $1 $value
}

if [ $# != 1 ] ; then
	echo $USR_LIB_VSERVER/printconf.sh vserver-name VARIABLES >&2
	exit 1
elif [ ! -f /etc/vservers/$1.conf ] ; then
	echo Vserver $1 does not exist >&2
	exit 1
else
	# We source this file in case it is not sourced by the vserver configuration
	source /etc/vservers.conf
	source /etc/vservers/$1.conf
	if [ "$VSERVERDIR" = "" ] ;then
		VSERVERDIR=$VSERVERS_ROOT/$1
	fi
	printvar VSERVERS_ROOT $VSERVERS_ROOT
	printvar VSERVERDIR $VSERVERDIR
	printvar PROFILE $PROFILE
	printvar IPROOT $IPROOT
	printvar IPROOTMASK $IPROOTMASK
	printvar IPROOTDEV $IPROOTDEV
	printyesno ONBOOT $ONBOOT
	printyesno GENERATEMTAB $GENERATEMTAB
	printvar PRIORITY $PRIORITY
	printvar S_DOMAINNAME $S_DOMAINNAME
	printvar S_HOSTNAME $S_HOSTNAME
	printvar S_CAPS $S_CAPS
	printvar S_NICE $S_NICE
	printvar S_FLAGS $S_FLAGS
	printvar ULIMIT $ULIMIT
	exit 0
fi

