#include <stdio.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>

int main (int argc, char *argv[])
{
	if (argc != 3){
		fprintf (stderr,"testlimit nbprocess malloc_size\n");
	}else{
		int nbproc = atoi(argv[1]);
		int size   = atoi(argv[2]);
		for (int i=0; i<nbproc; i++){
			if (fork()==0){
				void *pt = malloc(size);
				if (pt == NULL){
					fprintf (stderr,"Child %d: can't malloc (%s)\n"
						,i,strerror(errno));
				}else{
					memset (pt,1,size);
				}
				sleep (100);
				_exit (0);
			}
		}
		int status;
		while (wait(&status)!=-1);
	}
	return 0;
}

