#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include <utime.h>
#include "vutil.h"

int file_copy (const char *src, const char *dst, struct stat &st)
{
	int ret = -1;
	FILE *fin = fopen (src,"r");
	if (fin == NULL){
		fprintf (stderr,"Can't open file %s (%s)\n",src,strerror(errno));
	}else{
		FILE *fout = fopen (dst,"w");
		if (fout == NULL){
			fprintf (stderr,"Can't open file %s (%s)\n",dst,strerror(errno));
		}else{
			char buf[8192];
			int len;
			while ((len=fread(buf,1,sizeof(buf),fin))>0){
				fwrite (buf,1,len,fout);
			}
			fflush (fout);
			ret = 0;
			if (fchown (fileno(fout),st.st_uid,st.st_gid)==-1){
				fprintf (stderr,"Can't chown file %s (%s)\n"
					,dst,strerror(errno));
				ret = -1;
			}else if (fchmod (fileno(fout),st.st_mode)==-1){
				fprintf (stderr,"Can't chmod file %s (%s)\n"
					,dst,strerror(errno));
				ret = -1;
			}
			fclose(fout);
			struct utimbuf timbuf;
			timbuf.modtime = st.st_mtime;
			timbuf.actime = st.st_atime;
			if (utime (dst,&timbuf)==-1){
				fprintf (stderr,"Can't set time stamp on file %s (%s)\n"
					,dst,strerror(errno));
			}
		}
		fclose (fin);
	}
	return ret;
}


