#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/ext2_fs.h>

// Patch to help compile this utility on unpatched kernel source
#ifndef EXT2_IMMUTABLE_FILE_FL
	#define EXT2_IMMUTABLE_FILE_FL	0x00000010
	#define EXT2_IMMUTABLE_LINK_FL	0x00008000
#endif

/*
	Set the immutable flag on a file
*/
static int getext2flags (const char *fname, long &flags)
{
	int ret = -1;
	int fd = open (fname,O_RDONLY);
	if (fd == -1){
		fprintf (stderr,"Can't open file %s (%s)\n",fname,strerror(errno));
	}else{
		flags = 0;
		ret = ioctl (fd,EXT2_IOC_GETFLAGS,&flags);
		close (fd);
		if (ret == -1){
			fprintf (stderr,"Can't get ext2 flags on file %s (%s)\n"
				,fname,strerror(errno));
		}
	}
	return ret;
}


int main (int argc, char *argv[])
{
	int ret = -1;
	if (argc <= 1){
		fprintf (stderr
			,"showattr file ...\n"
			 "\n"
			 "Presents extended file attribute\n"
			);
	}else{
		for (int i=1; i<argc; i++){
			long flags;
			ret = getext2flags (argv[i],flags);
			if (ret == -1){
				break;
			}else{
				printf ("%s\t%08lx\n",argv[i],flags);
			}
		}
	}
	return ret;
}

