#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <net/if.h>
#include <unistd.h>
#include <errno.h>
#include <syscall.h>
#include <asm/unistd.h>

#ifndef __NR_set_ipv4root
	#define __NR_set_ipv4root	223
#endif

_syscall1(int, set_ipv4root, unsigned long, ip);

static void usage()
{
	fprintf (stderr,"chbind version %s\n",VERSION);
	fprintf (stderr,"chbind [ --silent ] [ --ip ip_num ] command argument\n");
	exit (-1);
}


static int ifconfig_ioctl(
	int fd,
	const char *ifname,
	int cmd,
	struct ifreq *ifr)
{
	strcpy(ifr->ifr_name, ifname);
	return ioctl(fd, cmd,ifr);
}

/*
	Fetch the IP number of an interface from the kernel.
	Assume the device is already available in the kernel
	Return -1 if any error.
*/
int ifconfig_getaddr (
	const char *ifname,
	unsigned long *addr)
{
	int ret = -1;
	int skfd = socket(AF_INET, SOCK_DGRAM, 0);
	*addr = 0;
	if (skfd != -1){
		struct ifreq ifr;
		if (ifconfig_ioctl(skfd,ifname,SIOCGIFADDR, &ifr) >= 0){
			struct sockaddr_in *sin = (struct sockaddr_in*)&ifr.ifr_addr;
			*addr = sin->sin_addr.s_addr;
			ret = 0;
		}
		close (skfd);
	}
	return ret;
}




int main (int argc, char *argv[])
{
	int ret = -1;
	int silent = 0;
	int i;
	unsigned long addr = 0;
	for (i=1; i<argc; i++){
		const char *arg = argv[i];
		const char *opt = argv[i+1];
		if (strcmp(arg,"--ip")==0){
			if (ifconfig_getaddr(opt,&addr)==-1){
				struct hostent *h = gethostbyname (opt);
				if (h == NULL){
					fprintf (stderr,"Invalid IP number or host name: %s\n",opt);
					usage();
				}else{
					memcpy (&addr,h->h_addr,sizeof(addr));
				}
			}
			i++;
		}else if (strcmp(arg,"--silent")==0){
			silent = 1;
		}else{
			break;
		}
	}
	if (i == argc){
		usage();
	}else if (argv[i][0] == '-'){
		usage();
	}else{
		if (set_ipv4root(addr)==0){
			if (!silent){
				unsigned long hostaddr = ntohl(addr);
				printf ("ipv4root is now %ld.%ld.%ld.%ld\n"
					,hostaddr>>24
					,(hostaddr>>16)&0xff
					,(hostaddr>>8)&0xff
					,hostaddr &0xff);
			}
			execvp (argv[i],argv+i);
		}else{
			perror ("Can't set the ipv4 root\n");
		}
	}
	return ret;
}


