/*
	Set the global per context limit of a resource (memory, file handle).
	This utility can do it either for the current context or a selected
	one.

	It uses the same options as ulimit, when possible
*/
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include "vutil.h"
#include <sys/resource.h>
#include "old_syscall.p"

static void set_ctxlim (int res, long lim, const char *msg)
{
	if (call_set_ctxlimit(res,lim)==-1){
		fprintf (stderr,"Error setting limit \"%s\": %s\n"
			,msg,strerror(errno));
		exit (-1);
	}
}

static void usage()
{
		fprintf (stderr,"setctxlimit version %s\n",VERSION);
		fprintf (stderr
			,"setctxlimit [ --ctx context ] limits\n"
			 "\n"
			 "-n Max. opened files\n");
}

int main (int argc, char *argv[])
{
	int ret = -1;
	if (argc < 2){
		usage();
	}else{
		ret = 0;
		for (int i=1; i<argc; i++){
			const char *arg = argv[i];
			const char *narg = argv[i+1];
			if (narg == NULL) narg = "";
			int val = atoi(narg);
			if (strcmp(arg,"--help")==0){
				usage();
			}else if (strcmp(arg,"--ctx")==0){
				int tb[]={val};
				if (call_new_s_context (1,tb,0,0)==-1){
					fprintf (stderr,"Can't select context %d (%s)\n"
						,val,strerror(errno));
					exit (-1);
				}
			}else if (strcmp (arg,"-n")==0){
				set_ctxlim (RLIMIT_NOFILE,val,"Number of opened files");
			}
		}
	}
	return ret;	
}

