/*
	Modified by Jacques Gelinas for the vserver project
*/
// $Id: syscall.c,v 1.1.4.4 2003/10/14 15:20:43 ensc Exp $    --*- c++ -*--

// Copyright (C) 2003 Enrico Scholz <enrico.scholz@informatik.tu-chemnitz.de>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; version 2 of the License.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


#include "linux/vswitch.h"
#include <errno.h>
#include <asm/unistd.h>
#include "old_syscall.p"

#ifndef __NR_vserver
#  define __NR_vserver	273
#endif

static enum KERNEL_TYPE{
	K_UNKNOWN,	// Do not support vserver at all
	K_NEW,		// New vserver kernel
	K_OLD		// Old vserver kernel
} state = K_UNKNOWN;


_syscall3(int, vserver, uint32_t, cmd, uint32_t, id, void *, data);


static void init()
{
	if (state == K_UNKNOWN){
		int ret = vserver (VCMD_get_version,0,NULL);
		if (ret == -1){
			state = K_OLD;
		}else{
			state = K_NEW;
		}
	}
}
	

extern "C" int call_new_s_context(int nbctx, int ctxs[], unsigned int remove_cap, unsigned int flags)
{
	int ret = -1;
	init();
	if (state == K_NEW){
		vcmd_new_s_context_v1 data;
		data.remove_cap = remove_cap;
		data.flags = flags;
		ret = vserver (VCMD_new_s_context,nbctx==0 ? 0 : ctxs[0],&data);
	}else{
		ret = call_old_new_s_context (nbctx,ctxs,remove_cap,flags);
	}
	return ret;
}

extern "C" int call_set_ipv4root(
	unsigned long ip[],
	int nb,
	unsigned long bcast,
	unsigned long mask[])
{
	int ret = -1;
	init();
	if (state == K_NEW){
		vcmd_set_ipv4root_v3 data;
		data.broadcast = bcast;
		for (int i=0; i<nb && i <NB_IPV4ROOT; i++){
			data.ip_mask_pair[i].ip = ip[i];
			data.ip_mask_pair[i].mask = mask[i];
		}
		ret = vserver (VCMD_set_ipv4root,nb,&data);
	}else{
		ret = call_old_set_ipv4root(ip,nb,bcast,mask);
	}
	return ret;
}

extern "C" int call_set_ctxlimit (int res, long lim)
{
	int ret = -1;
	init();
	if (state == K_NEW){
		vcmd_ctx_rlimit_v0 data;
		data.id = res;
		data.minimum = 0;
		data.softlimit = lim;
		data.maximum = lim;
		ret = vserver (VCMD_set_rlimit,0,&data);
	}else if (state == K_OLD){
		ret = call_old_set_ctxlimit (res,lim);
	}
	return ret;
}

