/*
	Copyright Jacques Gelinas jack@solucorp.qc.ca
	Distributed under the Gnu Public License, see the License file
	in this package.
*/
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <limits.h>
#include <unistd.h>

int main (int argc, char *argv[])
{
	int ret = -1;
	if (argc != 2){
		fprintf (stderr,"readlink symlink-file\n");
		fprintf (stderr,"Prints the contents of a symlink\n");
	}else{
		char buf[PATH_MAX];
		int len = readlink (argv[1],buf,sizeof(buf)-1);
		if (len > 0){
			buf[len] = '\0';
			printf ("%s\n",buf);
			ret = 0;
		}else{
			fprintf (stderr,"readlink failed for file %s (%s)\n"
				,argv[1],strerror(errno));
		}
	}
	return ret;
}

