/*
	Print the list of all network (IP) devices. Print the IP
	in fact, including all aliases.
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <net/if.h>


static int devlist_read2_2()
{
	int ret = -1;
	int skfd = socket (AF_INET,SOCK_DGRAM,0);
	if (skfd < 0) {
		perror ("socket");
	}else{
		struct ifconf ifc;
		int numreqs = 30;
		ifc.ifc_buf = NULL;
		ret = 0;
		while (1) {
			ifc.ifc_len = sizeof(struct ifreq) * numreqs;
			ifc.ifc_buf = (char*)realloc(ifc.ifc_buf, ifc.ifc_len);

			if (ioctl(skfd, SIOCGIFCONF, &ifc) < 0) {
				perror("SIOCGIFCONF");
				ret = -1;
				break;
			}
			if (ifc.ifc_len == (int)sizeof(struct ifreq) * numreqs) {
				/* assume it overflowed and try again */
				numreqs += 10;
				continue;
			}
			break;
		}
		if (ret == 0){
			struct ifreq *ifr = ifc.ifc_req;
			for (int n = 0; n < ifc.ifc_len; n += sizeof(struct ifreq)) {
				struct sockaddr_in *sin = (struct sockaddr_in*)&ifr->ifr_addr;
				unsigned long addr = ntohl(sin->sin_addr.s_addr);
				printf ("%lu.%lu.%lu.%lu\n"
					,(addr>>24)&0xff
					,(addr>>16)&0xff
					,(addr>>8)&0xff
					,addr&0xff);
				ifr++;
			}
		}
		free(ifc.ifc_buf);
	}
	return ret;
}

int main (int argc, char *argv[])
{
	devlist_read2_2();
	return 0;
}

