/*
	This tells the system call number for new_s_context and set_ipv4root
	using /proc/self/status. This helps until the vserver project is
	included officially in the kernel (and has its own syscall).

	We rely on /proc/self/status to find the syscall number.

	If it is not there, we rely on adm/unistd.h.

	If this file does not have those system calls (not a patched kernel source)
	we rely on static values in this file.
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <syscall.h>
#include <asm/unistd.h>

// Here is the trick. We keep a copy of the define, then undef it
// and then later, we try to locate the value reading /proc/self/status
// If this fails, we have the old preserved copy.
static int def_NR_set_ipv4root = 227;
#undef __NR_set_ipv4root

static int __NR_set_ipv4root_rev0;
static int __NR_set_ipv4root_rev1;
static int __NR_set_ipv4root_rev2;
static int rev_ipv4root=0;

_syscall1(int, set_ipv4root_rev0, unsigned long, ip);
_syscall2(int, set_ipv4root_rev1, unsigned long, ip, unsigned long, bcast);
_syscall3(int, set_ipv4root_rev2, unsigned long *, ip, int, nb, unsigned long, bcast);
static int def_NR_new_s_context = 226;
#undef __NR_new_s_context
static int __NR_new_s_context;
static int rev_s_context=0;

_syscall3(int, new_s_context, int, newctx, int, remove_cap, int, flags);

static void init()
{
	static int is_init = 0;
	if (!is_init){
		FILE *fin = fopen ("/proc/self/status","r");
		__NR_set_ipv4root_rev0 = def_NR_set_ipv4root;
		__NR_set_ipv4root_rev1 = def_NR_set_ipv4root;
		__NR_set_ipv4root_rev2 = def_NR_set_ipv4root;
		__NR_new_s_context = def_NR_new_s_context;
		if (fin != NULL){
			char line[100];
			while (fgets(line,sizeof(line)-1,fin)!=NULL){
				int num;
				char title[100],rev[100];
				rev[0] = '\0';
				if (sscanf(line,"%s %d %s",title,&num,rev)>=2){
					if (strcmp(title,"__NR_set_ipv4root:")==0){
						__NR_set_ipv4root_rev0 = num;
						__NR_set_ipv4root_rev1 = num;
						__NR_set_ipv4root_rev2 = num;
						if (strncmp(rev,"rev",3)==0){
							rev_ipv4root = atoi(rev+3);
						}
					}else if (strcmp(title,"__NR_new_s_context:")==0){
						__NR_new_s_context = num;
						if (strncmp(rev,"rev",3)==0){
							rev_s_context = atoi(rev+3);
						}
					}
				}
			}
			fclose (fin);
		}
		is_init = 1;
	}
}

extern "C" int call_new_s_context(int newctx, int remove_cap, int flags)
{
	init();
	return new_s_context(newctx,remove_cap,flags);
}

extern "C" int call_set_ipv4root (unsigned long ip[], int nb, unsigned long bcast)
{
	init();
	if (rev_ipv4root == 0){
		if (nb > 1){
			fprintf (stderr,"set_ipv4root: Several IP number specified, but this kernel only supports one. Ignored\n");
		}
		return set_ipv4root_rev0 (ip[0]);
	}else if (rev_ipv4root == 1){
		if (nb > 1){
			fprintf (stderr,"set_ipv4root: Several IP number specified, but this kernel only supports one. Ignored\n");
		}
		return set_ipv4root_rev1 (ip[0],bcast);
	}else if (rev_ipv4root == 2){
		return set_ipv4root_rev2 (ip,nb,bcast);
	}
	errno = EINVAL;
	return -1;
}



