#!/bin/sh
# Complete the installation of a vserver
vserver_mknod()
{
	mknod $1 $2 $3 $4
	chmod $5 $1
}

if [ $# != 1 ] ; then
	echo install-post.sh vserver
else
	VROOT=/vservers/$1
	rm -fr $VROOT/dev
	mkdir $VROOT/dev && chmod 755 $VROOT/dev
	mkdir $VROOT/dev/pts
	vserver_mknod $VROOT/dev/null c 1 3 666
	vserver_mknod $VROOT/dev/zero c 1 5 666
	vserver_mknod $VROOT/dev/full c 1 7 666
	vserver_mknod $VROOT/dev/random c 1 8 644
	vserver_mknod $VROOT/dev/urandom c 1 9 644
	vserver_mknod $VROOT/dev/tty c 5 0 666
	vserver_mknod $VROOT/dev/ptmx c 5 2 666
	test -f /etc/vservers/$1.conf || cp /usr/lib/vserver/sample.conf /etc/vservers/$1.conf
	test -f /etc/vservers/$1.sh   || cp /usr/lib/vserver/sample.sh /etc/vservers/$1.sh
	echo NETWORKING=yes >$VROOT/etc/sysconfig/network
	echo HOSTNAME=$1 >>$VROOT/etc/sysconfig/network
	(
		cd $VROOT/etc/rc.d/init.d || cd $VROOT/etc/init.d
		for serv in *
		do
			case $serv in
			*.bak|*~|functions|killall|halt|single)
				;;
			*)
				/usr/lib/vserver/capchroot /vservers/$1 /sbin/chkconfig --level 2345 $serv off
				;;
			esac
		done
		rm -f $VROOT/etc/rc.d/rc6.d/S*reboot
	)
	if [ ! -f $VROOT/etc/fstab ] ; then
		echo /dev/hdv1	/	ext2	defaults	1	1 >$VROOT/etc/fstab
		echo /dev/hdv1	/	ext2	rw	1	1 >$VROOT/etc/mtab
	fi
	cp -a /usr/lib/vserver/vreboot $VROOT/sbin/.
	ln -sf vreboot $VROOT/sbin/vhalt
fi

