/*
	This chroot command does very little. Once the chroot
	system call is executed, it (option) remove the CAP_SYS_CHROOT
	capability. Then it executes its argument
*/
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include "vutil.h"
#include <linux/capability.h>

int main (int argc, char *argv[])
{
	if (argc < 3){
		fprintf (stderr,"capchroot version %s\n",VERSION);
		fprintf (stderr
			,"capchroot --nochroot directory command argument\n"
			 "--nochroot remove the CAP_SYS_CHROOT capability\n"
			 "after the chroot system call\n");
	}else{
		bool nochroot = false;
		int dir = 1;
		if (strcmp(argv[1],"--nochroot")==0){
			nochroot = true;
			dir = 2;
		}
		if (chroot (argv[dir]) == -1){
			fprintf (stderr,"Can't chroot to directory %s (%s)\n",argv[dir]
				,strerror(errno));
		}else{
			if (nochroot){
				call_new_s_context (-2,1<<CAP_SYS_CHROOT,0);
			}
			int cmd = dir + 1;
			execvp (argv[cmd],argv+cmd);
			fprintf (stderr,"Can't execute %s (%s)\n",argv[cmd]
				,strerror(errno));
		}
	}
	return -1;
}


