#pragma interface
#ifndef VUTIL_H
#define VUTIL_H

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <string>
#include <set>
#include <algorithm>
#include <iostream.h>
#include <pfstream.h>
#include <list>

extern int debug;
extern bool testmode;

// Patch to help compile this utility on unpatched kernel source
#ifndef EXT2_IMMUTABLE_FILE_FL
	#define EXT2_IMMUTABLE_FILE_FL	0x00000010
	#define EXT2_IMMUTABLE_LINK_FL	0x00008000
#endif


class PACKAGE{
public:
	string name;
	string version;	// version + release
	PACKAGE(string &_name, string &_version)
		: name (_name), version(_version)
	{
	}
	PACKAGE(const char *_name, const char *_version)
		: name (_name), version(_version)
	{
	}
	PACKAGE(const string &line)
	{
		*this = line;
	}
	PACKAGE & operator = (const string &_line)
	{
		string line (_line);
		string::iterator pos = find (line.begin(),line.end(),'=');
		if (pos != line.end()){
			name = string(line.begin(),pos);
			version = string(pos + 1,line.end());
		}
		return *this;
	}
	bool operator == (const PACKAGE &v) const
	{
		return name == v.name && version == v.version;
	}
	// Load the file member of the package, but exclude configuration file
	void loadfiles(const string &ref, set<string> &files)
	{
		if (debug > 2) cout << "Loading files for package " << name << endl;
		string cmd = "| /usr/sbin/chroot " + ref + " /bin/rpm -ql --dump "
			+ name + "-" + version;
		ipfstream oo (cmd.c_str());
		while (1){
			char tmp[1000];
			int mode=-1,type=-1;
			oo.getline (tmp,sizeof(tmp)-1);
			if (tmp[0] == '\0') break;
			char *start = tmp;
			for (int i=0; i<8; i++){
				char *pt = start;
				while (*pt > ' ') pt++;
				if (*pt == ' ') *pt++ = '\0';
				if (i == 4){
					sscanf(start,"%o",&mode);
				}else if (i==7){
					type = atoi(start);
				}
				start = pt;
					
			}						
			if (type == 0 && S_ISREG(mode)){
				files.insert (tmp);
			}else if (debug > 10){
				cout << "Package " << name << " exclude " << tmp << endl;
			}
		}
		int status;
		wait (&status);
		if (debug > 2) cout << "Done\n";
	}
	#if 0
	bool locate(const string &path)
	{
		return find (files.begin(),files.end(),path) != files.end();
	}
	#endif
};


#include "vutil.p"

#endif

