#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>

int main (int argc, char *argv[])
{
	if (argc != 3){
		fprintf (stderr,"formboom N M\n"
			"where N is the number of process to start\n"
			"and M is the number of user to start\n"
			"Each user will try to start N process\n");
	}else{
		for (int i=0; i<atoi(argv[2]); i++){
			if (fork()==0){
				if (setuid (i+1)==-1){
					fprintf (stderr,"Can't setuid to uid %d (%s)\n",i+1
						,strerror(errno));
				}else{
					for (int j=0; j<atoi(argv[1]); j++){
						pid_t pid = fork();
						if (pid==-1){
							fprintf (stderr,"Fork failed (%s)\n",strerror(errno));
							break;
						}else if (pid == 0){
							sleep(20);
							_exit (0);
						}
					}
				}
				_exit (0);
			}
		}
		system ("ps ax | wc -l");
	}
	return 0;
}

