/*
	This tells the system call number for new_s_context and set_ipv4root
	using /proc/self/status. This helps until the vserver project is
	included officially in the kernel (and has its own syscall).

	We rely on /proc/self/status to find the syscall number.

	If it is not there, we rely on adm/unistd.h.

	If this file does not have those system calls (not a patched kernel source)
	we rely on static values in this file.
*/
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <syscall.h>
#include <asm/unistd.h>

#ifndef __NR_set_ipv4root
	#define __NR_set_ipv4root	227
#endif
// Here is the trick. We keep a copy of the define, then undef it
// and then later, we try to locate the value reading /proc/self/status
// If this fails, we have the old preserved copy.
static int def_NR_set_ipv4root = __NR_set_ipv4root;
#undef __NR_set_ipv4root

static int __NR_set_ipv4root;

_syscall1(int, set_ipv4root, unsigned long, ip);

#ifndef __NR_new_s_context
	#define __NR_new_s_context	226
#endif
static int def_NR_new_s_context = __NR_new_s_context;
#undef __NR_new_s_context
static int __NR_new_s_context;

_syscall3(int, new_s_context, int, newctx, int, remove_cap, int, flags);

static void init()
{
	static int is_init = 0;
	if (!is_init){
		FILE *fin = fopen ("/proc/self/status","r");
		__NR_set_ipv4root = def_NR_set_ipv4root;
		__NR_new_s_context = def_NR_new_s_context;
		if (fin != NULL){
			char line[100];
			while (fgets(line,sizeof(line)-1,fin)!=NULL){
				int num;
				char title[100];
				if (sscanf(line,"%s %d",title,&num)==2){
					if (strcmp(title,"__NR_set_ipv4root:")==0){
						__NR_set_ipv4root = num;
					}else if (strcmp(title,"__NR_new_s_context:")==0){
						__NR_new_s_context = num;
					}
				}
			}
			fclose (fin);
		}
		is_init = 1;
	}
}

extern "C" int call_new_s_context(int newctx, int remove_cap, int flags)
{
	init();
	return new_s_context(newctx,remove_cap,flags);
}

extern "C" int call_set_ipv4root (unsigned long ip)
{
	init();
	return set_ipv4root (ip);
}



