#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/stat.h>

int main (int argc, char *argv[])
{
	int ret = -1;
	if (argc < 2){
		fprintf (stderr,"showperm version %s\n",VERSION);
		fprintf (stderr,
			"showperm file or directory ...\n"
			"prints permission bits for files\n"
			"A very stripped down stat utility\n"
			);
	}else{
		ret = 0;
		for (int i=1; i<argc; i++){
			struct stat st;
			if (lstat(argv[i],&st)==-1){
				fprintf (stderr,"can't lstat %s (%s)\n",argv[i]
					,strerror(errno));
				ret = -1;
			}else{
				printf ("%03o\n",(st.st_mode & 0777));
			}
		}
	}
	return ret;
}

