/*
 *	@(#)ViewPlatformBehavior.java 1.5 01/02/07 16:10:59
 *
 * Copyright (c) 1996-2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

package com.sun.j3d.utils.behaviors.vp;

import javax.media.j3d.*;
import com.sun.j3d.utils.universe.*;

/**
 * Abstract class for ViewPlatformBehaviors.  A ViewPlatformBehavior must
 * be added to the ViewingPlatform with the
 * ViewingPlatform.addViewPlatformBehavior() method.  The ViewPlatformBehavior
 * will operate on the ViewPlatform transform (the TransformGroup return by
 * ViewingPlatform.getViewPlatformTransform()).
 * @since Java 3D 1.2.1
 */
abstract public class ViewPlatformBehavior extends Behavior {

    /**
     * The ViewingPlatform for this behavior
     */
    protected ViewingPlatform vp;

    /**
     * The target TransformGroup for this behavior
     */
    protected TransformGroup targetTG;

    /**
     * Sets the ViewingPlatform for this behavior.  This method is
     * called by the ViewingPlatform.
     * If a sub-calls overrides this method, it must call
     * super.setViewingPlatform(vp).
     * NOTE: Applications should <i>not</i> call this method.    
     */
    public void setViewingPlatform(ViewingPlatform vp) {
	this.vp = vp;
        
        if (vp!=null)
	    targetTG = vp.getViewPlatformTransform();
        else
            targetTG = null;
    }

    /**
     * Returns the ViewingPlatform for this behavior
     */
    public ViewingPlatform getViewingPlatform() {
	return vp;
    }

}
