/*
 *	@(#)DistanceAttenuation.java 1.14 01/01/11 07:20:11
 *
 * Copyright (c) 1996-2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 */

 /*
  *  Sound Distance Attenuation utilities
  *
  *  Various methods to create PointSound and ConeSound distance attenuation
  *  arrays.
  */

package com.sun.j3d.utils.audio;

import java.io.* ;
import javax.vecmath.* ;
import java.lang.String; 
import javax.media.j3d.*;
import com.sun.j3d.internal.J3dUtilsI18N;

public class DistanceAttenuation
{
  // private fields

  // public fields
  /**
   * Equation types
   */
  static final int DOUBLE_DISTANCE_HALF_GAIN = 1;

  // methods
  /**
   * Fill a Distance Attenuation array
   *
   * recommend that the distance attenuation Point2f array is defined to
   * be allocated to be 10 for DOUBLE_DISTANCE_HALF_GAIN - since 1/(2^10)
   * exceeds 1/1000 scale that is agreed to be affective zero gain
   * 
   * First method assumes that:
   *    type is half gain for every double of distance
   *    inner radius is 0.0 but region between 0th and 1st elements is constant
   *         since gains for these two elements are the same
   *    min gain approches zero.
   */
  public void fillDistanceAttenuation(
                         float unitDistance, float unitGain,
                         Point2f[] distanceAttenuation ) {
      if (distanceAttenuation == null)
          throw new SoundException(J3dUtilsI18N.getString("DistanceAttenuation0"));

      int length = distanceAttenuation.length;
      distanceAttenuation[0].x = 0.0f;
      distanceAttenuation[0].y = unitGain;
      float nextDistance = unitDistance;
      float nextGain     = unitGain;

      for (int i=1; i<length; i++) {
          distanceAttenuation[i].x = nextDistance;
          distanceAttenuation[i].y = nextGain;
          nextDistance *= 2.0f;
          nextGain *= 0.5f;
      } 
  }

  public void fillDistanceAttenuation(
                         float innerRadius, float maxConstantGain,
                         float unitDistance, float unitGain,
                         int curveType, Point2f[] distanceAttenuation ) {
      if (distanceAttenuation == null)
          throw new SoundException(J3dUtilsI18N.getString("DistanceAttenuation0"));

      int length = distanceAttenuation.length;
      distanceAttenuation[0].x = innerRadius;
      distanceAttenuation[0].y = maxConstantGain;
      // Danger if mzxConstanceGain is less than greater than unitGain
      // then your modeling attenuation that's physically improbable!
      float nextDistance = unitDistance;
      float nextGain     = unitGain;

      for (int i=1; i<length; i++) {
          distanceAttenuation[i].x = innerRadius + nextDistance;
          distanceAttenuation[i].y = nextGain;
          nextDistance *= 2.0f;
          nextGain *= 0.5f;
      } 
  }

  public void fillDistanceAttenuation(
                         float innerRadius, float maxConstantGain,
                         float unitDistance, float unitGain,
                         float outerRadius, float minConstantGain,
                         int curveType, Point2f[] distanceAttenuation ) {
  }
}

