/*
 *	@(#)ObjectFileParser.java 1.11 01/01/11 07:26:51
 *
 * Copyright (c) 1996-2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

package com.sun.j3d.loaders.objectfile;

import java.io.StreamTokenizer;
import java.io.IOException;
import java.io.Reader;

class ObjectFileParser extends StreamTokenizer {

  private static final char BACKSLASH = '\\';



  // setup
  //
  //    Sets up StreamTokenizer for reading ViewPoint .obj file format.
  //
  void setup()
  {
    resetSyntax();
    eolIsSignificant(true);
    lowerCaseMode(true);

    // All printable ascii characters
    wordChars('!', '~');

    // Comment from ! to end of line
    commentChar('!');

    whitespaceChars(' ', ' ');
    whitespaceChars('\n', '\n');
    whitespaceChars('\r', '\r');
    whitespaceChars('\t', '\t');

    // These characters returned as tokens
    ordinaryChar('#');
    ordinaryChar('/');
    ordinaryChar(BACKSLASH);
  } // End of setup



  // getToken
  //
  //	Gets the next token from the stream.  Puts one of the four
  //	constants (TT_WORD, TT_NUMBER, TT_EOL, or TT_EOF) or the token value
  //	for single character tokens into ttype.  Handles backslash
  //	continuation of lines.
  boolean getToken()
  {
    int t;
    boolean done = false;

    try {
      do {
	t = nextToken();
	if (t == BACKSLASH) {
	  t = nextToken();
	  if (ttype != TT_EOL) done = true;
	} else done = true;
      } while (!done);
    }
    catch (IOException e) {
      System.err.println(
        "IO error on line " + lineno() + ": " + e.getMessage());
      return false;
    }

    return true;
  } // End of getToken



  void printToken()
  {
    switch (ttype) {
    case TT_EOL:
      System.out.println("Token EOL");
      break;
    case TT_EOF:
      System.out.println("Token EOF");
      break;
    case TT_WORD:
      System.out.println("Token TT_WORD: " + sval);
      break;
    case '/':
      System.out.println("Token /");
      break;
    case BACKSLASH:
      System.out.println("Token " + BACKSLASH);
      break;
    case '#':
      System.out.println("Token #");
      break;
    }
  } // end of printToken



  // skipToNextLine
  //
  //	Skips all tokens on the rest of this line.  Doesn't do anything if
  //	We're already at the end of a line
  //
  boolean skipToNextLine()
  {
    boolean done = false;

    while (ttype != TT_EOL) {
      if (!getToken()) return false;
    }

    return true;
  } // end of skipToNextLine
  


  // getNumber
  //
  //	Gets a number from the stream.  Note that we don't recognize
  //	numbers in the tokenizer automatically because numbers might be in
  //	scientific notation, which isn't processed correctly by 
  //	StreamTokenizer.  The number is returned in nval.
  //
  boolean getNumber()
  {
    int t;

    try {
      if (getToken()) {
	if (ttype != TT_WORD)
	  throw new IOException("Expected number on line " + lineno());
	nval =  (Double.valueOf(sval)).doubleValue();
      } else return false;
    }
    catch (IOException e) {
      System.err.println(e.getMessage());
      return false;
    }
    catch (NumberFormatException e) {
      System.err.println(e.getMessage());
      return false;
    }
    return true;
  } // end of getNumber



  // ObjectFileParser constructor
  //
  ObjectFileParser(Reader r)
  {
    super(r);
    setup();
  } // end of ObjectFileParser

} // End of file ObjectFileParser.java
