/*
 *	@(#)SwitchPathInterpolator.java 1.12 01/01/11 07:26:37
 *
 * Copyright (c) 1996-2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

 package com.sun.j3d.loaders.lw3d;

 
import javax.vecmath.*;
import java.util.BitSet;
import java.util.Enumeration;

import javax.media.j3d.Alpha;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Switch;
import javax.media.j3d.PathInterpolator;
import com.sun.j3d.internal.J3dUtilsI18N;

/**
 * This class was used in conjunction with SequenceReader to create
 * Tloop functionality inside of Lightwave files.  This behavior handles
 * the switching between objects defined in separate lines of a 
 * sequence file.  That is, each line in a sequence file has the name
 * of an object (or an object sequence, if the name ends in "000")
 * and details the start and end frames that that object should be active.
 * This class determines which object/s defined in the file should be active
 * at any given time during the animation.
 */

class SwitchPathInterpolator extends PathInterpolator {

    Switch target;
    int firstSwitchIndex;
    int lastSwitchIndex;
    int currentChild;
    int childCount;
    
    /**
      * Constructs a new SwitchPathInterpolator object.
      * @param alpha the alpha object for this interpolator
      * @param knots an array of knot values that specify a spline
     */
    SwitchPathInterpolator(Alpha alpha, float knots[], Switch target) {

	super(alpha, knots);

	if (knots.length != (target.numChildren() + 1))
	    throw new IllegalArgumentException(J3dUtilsI18N.getString("SwitchPathInterpolator0"));

	this.target = target;
	firstSwitchIndex = 0;
	lastSwitchIndex = target.numChildren() - 1;
	childCount = lastSwitchIndex + 1;
    }

    /**
     * This method sets the correct child for the Switch node according
     * to alpha  
     * @param criteria enumeration of criteria that have triggered this wakeup
     */

    public void processStimulus(Enumeration criteria) {

	int child;

        /* Handle stimulus */
        if (this.getAlpha() != null) {

            // Let PathInterpolator calculate the correct
            // interpolated knot point 
            computePathInterpolation();

	    if (currentKnotIndex > 0)
	        child = currentKnotIndex - 1;
	    else
	        child = 0;
	
	    if (target.getWhichChild() != child) {
	        target.setWhichChild(child);
	    }

            if ((this.getAlpha()).finished())
                return;
        }

        wakeupOn(defaultWakeupCriterion);
    }

}
